/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.tiling.source.mvt;

import org.oscim.tiling.ITileDataSource;
import org.oscim.tiling.source.UrlTileDataSource;
import org.oscim.tiling.source.UrlTileSource;
import org.oscim.tiling.source.mvt.TileDecoder;

public class MapboxTileSource
extends UrlTileSource {
    private static final String DEFAULT_URL = "https://tile.mapzen.com/mapzen/vector/v1/all";
    private static final String DEFAULT_PATH = "/{Z}/{X}/{Y}.mvt";
    private final String locale;

    public static Builder<?> builder() {
        return new Builder();
    }

    protected MapboxTileSource(Builder<?> builder) {
        super((UrlTileSource.Builder<?>)builder);
        this.locale = ((Builder)builder).locale;
    }

    public MapboxTileSource() {
        this(MapboxTileSource.builder());
    }

    public MapboxTileSource(String urlString) {
        this((Builder)MapboxTileSource.builder().url(urlString));
    }

    @Override
    public ITileDataSource getDataSource() {
        return new UrlTileDataSource(this, new TileDecoder(this.locale), this.getHttpEngine());
    }

    public static class Builder<T extends Builder<T>>
    extends UrlTileSource.Builder<T> {
        private String locale = "";

        public Builder() {
            super(MapboxTileSource.DEFAULT_URL, MapboxTileSource.DEFAULT_PATH, 1, 17);
        }

        public T locale(String locale) {
            this.locale = locale;
            return (T)((Builder)this.self());
        }

        @Override
        public MapboxTileSource build() {
            return new MapboxTileSource(this);
        }
    }
}

