/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    private static final float LOAD_FACTOR = 0.6f;
    private static final long serialVersionUID = 1L;
    private final int capacity;

    private static int calculateInitialCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity must not be negative: " + capacity);
        }
        return (int)((float)capacity / 0.6f) + 2;
    }

    public LRUCache(int capacity) {
        super(LRUCache.calculateInitialCapacity(capacity), 0.6f, true);
        this.capacity = capacity;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.capacity;
    }
}

