/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils;

import java.util.List;
import org.oscim.core.Box;
import org.oscim.utils.SpatialIndex;
import org.oscim.utils.pool.Pool;
import org.oscim.utils.quadtree.BoxTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuadTree<T>
extends BoxTree<BoxTree.BoxItem<T>, T>
implements SpatialIndex<T> {
    static final Logger log = LoggerFactory.getLogger(QuadTree.class);
    final Pool<BoxTree.BoxItem<T>> boxPool = new Pool<BoxTree.BoxItem<T>>(){

        @Override
        protected BoxTree.BoxItem<T> createItem() {
            return new BoxTree.BoxItem();
        }
    };
    final CollectCb<T> collectCb = new CollectCb();

    public QuadTree(int extents, int maxDepth) {
        super(extents, maxDepth);
    }

    private BoxTree.BoxItem<T> getBox(Box box) {
        BoxTree.BoxItem<T> it = this.boxPool.get();
        it.x1 = (int)box.xmin;
        it.y1 = (int)box.ymin;
        it.x2 = (int)box.xmax;
        it.y2 = (int)box.ymax;
        return it;
    }

    @Override
    public void insert(Box box, T item) {
        this.insert(new BoxTree.BoxItem<T>(box, item));
    }

    @Override
    public boolean remove(Box box, T item) {
        BoxTree.BoxItem<T> bbox = this.getBox(box);
        boolean ok = this.remove(bbox, item);
        this.boxPool.release(bbox);
        return ok;
    }

    @Override
    public List<T> search(Box bbox, List<T> results) {
        BoxTree.BoxItem<T> box = this.getBox(bbox);
        this.search(box, this.collectCb, results);
        this.boxPool.release(box);
        return results;
    }

    @Override
    public boolean search(Box bbox, SpatialIndex.SearchCb<T> cb, Object context) {
        BoxTree.BoxItem<T> box = this.getBox(bbox);
        boolean finished = this.search(box, cb, context);
        this.boxPool.release(box);
        return finished;
    }

    static class CollectCb<T>
    implements SpatialIndex.SearchCb<T> {
        CollectCb() {
        }

        @Override
        public boolean call(T item, Object context) {
            List l = (List)context;
            l.add(item);
            return true;
        }
    }
}

