/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.async;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.oscim.utils.async.AsyncTask;
import org.oscim.utils.async.TaskQueue;

public class AsyncExecutor {
    private final ExecutorService executor;
    private final TaskQueue mainloop;

    public AsyncExecutor(int maxConcurrent, TaskQueue mainloop) {
        this.mainloop = mainloop;
        this.executor = Executors.newFixedThreadPool(maxConcurrent, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "VtmAsyncExecutor");
                thread.setDaemon(true);
                thread.setPriority(4);
                return thread;
            }
        });
    }

    public boolean post(Runnable task) {
        if (task instanceof AsyncTask) {
            ((AsyncTask)task).setTaskQueue(this.mainloop);
        }
        try {
            this.executor.execute(task);
        }
        catch (RejectedExecutionException e) {
            return false;
        }
        return true;
    }

    public void dispose() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Couldn't shutdown loading thread");
        }
    }
}

