/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.async;

import org.oscim.map.Map;

public abstract class SimpleWorker<T>
implements Runnable {
    protected final Map mMap;
    protected boolean mRunning;
    protected boolean mWait;
    protected boolean mCancel;
    protected boolean mDelayed;
    protected long mMinDelay;
    protected T mTaskTodo;
    protected T mTaskDone;
    protected T mTaskLocked;

    public SimpleWorker(Map map, long minDelay, T t1, T t2) {
        this.mMap = map;
        this.mMinDelay = minDelay;
        this.mTaskTodo = t1;
        this.mTaskLocked = t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SimpleWorker simpleWorker = this;
        synchronized (simpleWorker) {
            if (this.mCancel) {
                this.mCancel = false;
                this.mRunning = false;
                this.mDelayed = false;
                this.mWait = false;
                if (this.mTaskTodo != null) {
                    this.cleanup(this.mTaskTodo);
                }
                this.finish();
                return;
            }
            if (this.mDelayed || this.mTaskTodo == null) {
                if (this.mDelayed && this.mTaskTodo != null) {
                    this.onMainLoop(this.mTaskTodo);
                }
                this.mDelayed = false;
                this.mRunning = false;
                this.submit(0L);
                return;
            }
        }
        boolean done = this.doWork(this.mTaskTodo);
        SimpleWorker simpleWorker2 = this;
        synchronized (simpleWorker2) {
            this.mRunning = false;
            if (this.mCancel) {
                this.cleanup(this.mTaskTodo);
                this.finish();
                this.mCancel = false;
            } else if (done) {
                this.mTaskDone = this.mTaskTodo;
                this.mTaskTodo = null;
            } else if (this.mWait) {
                this.submit(this.mMinDelay);
                this.mWait = false;
            }
        }
    }

    public abstract boolean doWork(T var1);

    public abstract void cleanup(T var1);

    public void finish() {
    }

    public void onMainLoop(T task) {
    }

    public synchronized void submit(long delay) {
        if (this.mRunning) {
            this.mWait = true;
            return;
        }
        this.mRunning = true;
        if (delay <= 0L) {
            this.mMap.addTask(this);
            return;
        }
        if (!this.mDelayed) {
            this.mDelayed = true;
            this.mMap.postDelayed(this, delay);
        }
    }

    public synchronized T poll() {
        if (this.mTaskDone == null) {
            return null;
        }
        this.cleanup(this.mTaskLocked);
        this.mTaskTodo = this.mTaskLocked;
        this.mTaskLocked = this.mTaskDone;
        this.mTaskDone = null;
        if (this.mWait) {
            this.submit(this.mMinDelay);
            this.mWait = false;
        }
        return this.mTaskLocked;
    }

    public synchronized void cancel(boolean clear) {
        if (this.mRunning) {
            this.mCancel = true;
            return;
        }
        if (this.mTaskTodo != null) {
            this.cleanup(this.mTaskTodo);
        }
        this.finish();
    }

    public synchronized boolean isRunning() {
        return this.mRunning;
    }
}

