/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.geom;

import org.oscim.core.GeometryBuffer;
import org.oscim.utils.geom.GeometryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplifyDP {
    static final Logger log = LoggerFactory.getLogger(SimplifyDP.class);
    boolean[] markers = new boolean[128];
    int[] stack = new int[32];

    public void simplify(GeometryBuffer geom, float sqTolerance) {
        int[] idx = geom.index;
        int inPos = 0;
        int outPos = 0;
        for (int len : idx) {
            if (len < 0) break;
            if (len < 6) {
                inPos += len;
                outPos += len;
                continue;
            }
            int end = this.simplify(geom.points, inPos, len, outPos, sqTolerance);
            if (end > inPos + len) {
                log.error("out larger than cur: {} > {}", (Object)end, (Object)(inPos + len));
            }
            idx[i] = (short)(end - outPos);
            outPos = end;
            inPos += len;
        }
    }

    public int simplify(float[] points, int inPos, int length, int out, float sqTolerance) {
        int i;
        if (length >> 1 >= this.markers.length) {
            this.markers = new boolean[length >> 1];
        }
        int first = inPos;
        int last = inPos + length - 2;
        int index = 0;
        int sp = 0;
        while (true) {
            float maxSqDist = 0.0f;
            for (i = first + 2; i < last; i += 2) {
                float sqDist = GeometryUtils.squareSegmentDistance(points, i, first, last);
                if (!(sqDist > maxSqDist)) continue;
                index = i;
                maxSqDist = sqDist;
            }
            if (maxSqDist > sqTolerance) {
                this.markers[index - inPos >> 1] = true;
                if (sp + 4 == this.stack.length) {
                    int[] tmp = new int[this.stack.length + 64];
                    System.arraycopy(this.stack, 0, tmp, 0, this.stack.length);
                    this.stack = tmp;
                }
                this.stack[sp++] = first;
                this.stack[sp++] = index;
                this.stack[sp++] = index;
                this.stack[sp++] = last;
            }
            if (sp == 0) break;
            last = this.stack[--sp];
            first = this.stack[--sp];
        }
        points[out++] = points[inPos];
        points[out++] = points[inPos + 1];
        last = inPos + length - 2;
        for (i = 0; i < length / 2; ++i) {
            if (!this.markers[i]) continue;
            this.markers[i] = false;
            int pos = inPos + i * 2;
            points[out++] = points[pos];
            points[out++] = points[pos + 1];
        }
        points[out++] = points[last];
        points[out++] = points[last + 1];
        return out;
    }
}

