/*
 * Decompiled with CFR 0.152.
 */
package org.oscim.utils.pool;

import javax.annotation.CheckReturnValue;
import org.oscim.utils.pool.Inlist;

public abstract class SyncPool<T extends Inlist<?>> {
    protected final int mMaxFill;
    protected final boolean mClearItems;
    protected int mFill;
    protected T mPool;

    public SyncPool(int maxItemsInPool) {
        this(maxItemsInPool, true);
    }

    public SyncPool(int maxItemsInPool, boolean clearItems) {
        this.mMaxFill = maxItemsInPool;
        this.mFill = 0;
        this.mClearItems = clearItems;
    }

    public int getFill() {
        return this.mFill;
    }

    public void init(int items) {
        this.mFill = 0;
        this.mPool = null;
    }

    public synchronized void clear() {
        while (this.mPool != null) {
            this.freeItem(this.mPool);
            this.mPool = ((Inlist)this.mPool).next;
        }
    }

    protected boolean clearItem(T item) {
        return true;
    }

    protected void freeItem(T item) {
    }

    protected abstract T createItem();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public T release(T item) {
        if (item == null) {
            return null;
        }
        if (this.mClearItems && !this.clearItem(item)) {
            this.freeItem(item);
            return null;
        }
        if (this.mFill < this.mMaxFill) {
            SyncPool syncPool = this;
            synchronized (syncPool) {
                ++this.mFill;
                ((Inlist)item).next = this.mPool;
                this.mPool = item;
            }
        } else if (this.mClearItems) {
            this.freeItem(item);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    public T releaseAll(T item) {
        if (item == null) {
            return null;
        }
        if (this.mFill > this.mMaxFill) {
            while (item != null) {
                if (this.mClearItems) {
                    this.clearItem(item);
                    this.freeItem(item);
                }
                item = ((Inlist)item).next;
            }
            return null;
        }
        SyncPool syncPool = this;
        synchronized (syncPool) {
            while (item != null) {
                Object next = ((Inlist)item).next;
                if (this.mClearItems && !this.clearItem(item)) {
                    this.freeItem(item);
                    item = next;
                    continue;
                }
                ++this.mFill;
                ((Inlist)item).next = this.mPool;
                this.mPool = item;
                item = next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        SyncPool syncPool = this;
        synchronized (syncPool) {
            if (this.mPool == null) {
                return this.createItem();
            }
            --this.mFill;
            T ret = this.mPool;
            this.mPool = ((Inlist)this.mPool).next;
            ((Inlist)ret).next = null;
            return ret;
        }
    }
}

