/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Constant;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.Function;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.RecursiveArgument;
import org.mariuszgromada.math.mxparser.mXparser;

public class Tutorial {
    public static void main(String[] args) {
        mXparser.consolePrintln("                      mXparser - version 4.1.0\n         A flexible mathematical eXpressions parser for JAVA.\n\nYou may use this software under the condition of Simplified BSD License:\n\nCopyright 2010-2017 MARIUSZ GROMADA. All rights reserved.\n\nRedistribution and use in source and binary forms, with or without modification, are\npermitted provided that the following conditions are met:\n\n   1. Redistributions of source code must retain the above copyright notice, this list of\n      conditions and the following disclaimer.\n\n   2. Redistributions in binary form must reproduce the above copyright notice, this list\n      of conditions and the following disclaimer in the documentation and/or other materials\n      provided with the distribution.\n\nTHIS SOFTWARE IS PROVIDED BY MARIUSZ GROMADA ``AS IS'' AND ANY EXPRESS OR IMPLIED\nWARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND\nFITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL MARIUSZ GROMADA OR\nCONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR\nCONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR\nSERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON\nANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\nNEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF\nADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n\nThe views and conclusions contained in the software and documentation are those of the\nauthors and should not be interpreted as representing official policies, either expressed\nor implied, of MARIUSZ GROMADA.\n\nIf you have any questions/bugs feel free to contact:\n\n    Mariusz Gromada\n    mariuszgromada.org@gmail.com\n    http://mathspace.plt/\n    http://mathparser.org/\n    http://github.com/mariuszgromada/MathParser.org-mXparser\n    http://mariuszgromada.github.io/MathParser.org-mXparser/\n    http://mxparser.sourceforge.net/\n    http://bitbucket.org/mariuszgromada/mxparser/\n    http://mxparser.codeplex.com/\n    http://janetsudoku.mariuszgromada.org/\n");
        Expression e = new Expression(new PrimitiveElement[0]);
        mXparser.consolePrintln(e.getHelp());
        mXparser.consolePrintln();
        mXparser.consolePrintln(e.getHelp("sine"));
        mXparser.consolePrintln();
        mXparser.consolePrintln(e.getHelp("inver"));
        Expression e1 = new Expression("2+1", new PrimitiveElement[0]);
        mXparser.consolePrintln(e1.getExpressionString() + " = " + e1.calculate());
        e1.setExpressionString("2-1");
        mXparser.consolePrintln(e1.getExpressionString() + " = " + e1.calculate());
        Expression e2 = new Expression("2-(32-4)/(23+(4)/(5))-(2-4)*(4+6-98.2)+4", new PrimitiveElement[0]);
        mXparser.consolePrintln(e2.getExpressionString() + " = " + e2.calculate());
        Expression e3 = new Expression("2^3+2^(-3)+2^3^(-4)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e3.getExpressionString() + " = " + e3.calculate());
        Expression e4 = new Expression("2=3", new PrimitiveElement[0]);
        mXparser.consolePrintln(e4.getExpressionString() + " = " + e4.calculate());
        Expression e5 = new Expression("2<3", new PrimitiveElement[0]);
        mXparser.consolePrintln(e5.getExpressionString() + " = " + e5.calculate());
        Expression e6 = new Expression("(2=3) | (2<3)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e6.getExpressionString() + " = " + e6.calculate());
        Expression e7 = new Expression("(2=3) & (2<3)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e7.getExpressionString() + " = " + e7.calculate());
        Expression e8 = new Expression("sin(2)-cos(3)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e8.getExpressionString() + " = " + e8.calculate());
        Expression e9 = new Expression("min(3,4) + max(-2,-1)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e9.getExpressionString() + " = " + e9.calculate());
        Expression e10 = new Expression("C(10,5)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e10.getExpressionString() + " = " + e10.calculate());
        Expression e11 = new Expression("if(2<3,1,0)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e11.getExpressionString() + " = " + e11.calculate());
        Expression e12 = new Expression("if(3<2,1,0)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e12.getExpressionString() + " = " + e12.calculate());
        Expression e13 = new Expression("if(3<2, 1, if(1=1, 5, 0) )", new PrimitiveElement[0]);
        mXparser.consolePrintln(e13.getExpressionString() + " = " + e13.calculate());
        Argument x = new Argument("x=1", new PrimitiveElement[0]);
        Argument y = new Argument("y=2", new PrimitiveElement[0]);
        Argument z = new Argument("z", 3.0);
        Argument n = new Argument("n", 4.0);
        Expression e14 = new Expression("sin(x+y)-cos(y/z)", x, y, z);
        mXparser.consolePrintln(e14.getExpressionString() + " = " + e14.calculate());
        Expression e15 = new Expression("if(x>y, x-z, if(y<z, sin(x+y), cos(z)) )", x, y, z);
        mXparser.consolePrintln(e15.getExpressionString() + " = " + e15.calculate());
        x.setArgumentValue(5.0);
        mXparser.consolePrintln(x.getArgumentName() + " = " + x.getArgumentValue());
        y = new Argument("y", "2*x+5", x);
        mXparser.consolePrintln(y.getArgumentName() + " = " + y.getArgumentValue());
        y = new Argument("y", "sin(y)-z", y, z);
        mXparser.consolePrintln(y.getArgumentName() + " = " + y.getArgumentValue());
        y.setArgumentExpressionString("n*sin(y)-z");
        mXparser.consolePrintln(y.getArgumentName() + " = ... \n syntax = " + y.checkSyntax() + "\n message = \n" + y.getErrorMessage());
        y.addDefinitions(n);
        mXparser.consolePrintln(y.getArgumentName() + " = ... \n syntax = " + y.checkSyntax() + "\n message = \n" + y.getErrorMessage());
        mXparser.consolePrintln(y.getArgumentName() + " = " + y.getArgumentValue());
        Expression e16 = new Expression("sum(i,1,10,i)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e16.getExpressionString() + " = " + e16.calculate());
        Expression e17 = new Expression("sum(i,1,10,i,0.5)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e17.getExpressionString() + " = " + e17.calculate());
        Expression e18 = new Expression("prod(i,1,5,i)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e18.getExpressionString() + " = " + e18.calculate());
        Expression e19 = new Expression("prod(i,1,5,i,0.5)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e19.getExpressionString() + " = " + e19.calculate());
        Expression e20 = new Expression("sin(x)-sum(n,0,10,(-1)^n*(x^(2*n+1))/(2*n+1)!)", x);
        x.setArgumentValue(1.0);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e20.getExpressionString() + " = " + e20.calculate());
        x.setArgumentValue(5.0);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e20.getExpressionString() + " = " + e20.calculate());
        x.setArgumentValue(10.0);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e20.getExpressionString() + " = " + e20.calculate());
        Argument d = new Argument("d", 0.1);
        Expression e21 = new Expression("2*sum(x, -1, 1, d*sqrt(1-x^2), d)", d);
        mXparser.consolePrintln("d = " + d.getArgumentValue() + ", " + e21.getExpressionString() + " = " + e21.calculate());
        d.setArgumentValue(0.01);
        mXparser.consolePrintln("d = " + d.getArgumentValue() + ", " + e21.getExpressionString() + " = " + e21.calculate());
        Expression e22 = new Expression("cos(x)-der(sin(x), x)", x);
        mXparser.consolePrintln(e22.getExpressionString() + " = " + e22.calculate());
        x.setArgumentValue(0.0);
        Expression e23 = new Expression("der-(abs(x), x)", x);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e23.getExpressionString() + " = " + e23.calculate());
        Expression e24 = new Expression("der+(abs(x), x)", x);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e24.getExpressionString() + " = " + e24.calculate());
        x.setArgumentValue(1.0);
        Expression e25 = new Expression("cos(x)-der(sum(n,0,10,(-1)^n*(x^(2*n+1))/(2*n+1)!), x)", x);
        x.setArgumentValue(1.0);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e25.getExpressionString() + " = " + e25.calculate());
        x.setArgumentValue(5.0);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e25.getExpressionString() + " = " + e25.calculate());
        x.setArgumentValue(10.0);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e25.getExpressionString() + " = " + e25.calculate());
        Expression e26 = new Expression("2*int(sqrt(1-x^2), x, -1, 1)", new PrimitiveElement[0]);
        mXparser.consolePrintln(e26.getExpressionString() + " = " + e26.calculate());
        Expression e27 = new Expression("pi", new PrimitiveElement[0]);
        mXparser.consolePrintln(e27.getExpressionString() + " = " + e27.calculate());
        Expression e28 = new Expression("e", new PrimitiveElement[0]);
        mXparser.consolePrintln(e28.getExpressionString() + " = " + e28.calculate());
        Function f = new Function("f", "x^2", "x");
        Expression e29 = new Expression("f(2)", new PrimitiveElement[0]);
        e29.addDefinitions(f);
        mXparser.consolePrintln(e29.getExpressionString() + " = " + e29.calculate());
        f = new Function("f(a,b,c)=a+b+c", new PrimitiveElement[0]);
        Expression e30 = new Expression("f(1, 2, 3)", new PrimitiveElement[0]);
        e30.addDefinitions(f);
        mXparser.consolePrintln(e30.getExpressionString() + " = " + e30.calculate());
        f = new Function("f", "x^2", "x");
        Function g = new Function("g", "f(x)^2", "x");
        g.addDefinitions(f);
        mXparser.consolePrintln("g(2) = " + g.calculate(2.0));
        Expression e31 = new Expression("f(x)+g(2*x)", x);
        e31.addDefinitions(f, g);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e31.getExpressionString() + " = " + e31.calculate());
        x.setArgumentValue(2.0);
        Expression e32 = new Expression("der(g(x),x)", x);
        e32.addDefinitions(g);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e32.getExpressionString() + " = " + e32.calculate());
        f = new Function("f", "sin(x)", "x");
        Function F = new Function("F", "int(f(t), t, 0, x)", "x");
        F.addDefinitions(f);
        Expression e33 = new Expression("f(x) - der(F(x),x)", x);
        e33.addDefinitions(f, F);
        mXparser.consolePrintln("x = " + x.getArgumentValue() + ", " + e33.getExpressionString() + " = " + e33.calculate() + ", computing time : " + e33.getComputingTime() + " s.");
        n = new Argument("n", new PrimitiveElement[0]);
        RecursiveArgument fib1 = new RecursiveArgument("fib1", "fib1(n-1)+fib1(n-2)", n, new PrimitiveElement[0]);
        fib1.addBaseCase(0, 0.0);
        fib1.addBaseCase(1, 1.0);
        mXparser.consolePrintln("fib1: ");
        for (int i = 0; i <= 10; ++i) {
            mXparser.consolePrint(fib1.getArgumentValue(i) + ", ");
        }
        mXparser.consolePrintln();
        RecursiveArgument fib2 = new RecursiveArgument("fib2", "if( n>1, fib2(n-1)+fib2(n-2), if(n=1,1,0) )", n, new PrimitiveElement[0]);
        mXparser.consolePrintln("fib2: ");
        for (int i = 0; i <= 10; ++i) {
            mXparser.consolePrint(fib2.getArgumentValue(i) + ", ");
        }
        mXparser.consolePrintln();
        Expression e34 = new Expression("sum(i, 0, 10, fib1(i))", fib1);
        mXparser.consolePrintln(e34.getExpressionString() + " = " + e34.calculate() + ", computing time : " + e34.getComputingTime() + " s.");
        Expression e35 = new Expression("sum(i, 0, 10, fib2(i))", fib2);
        mXparser.consolePrintln(e35.getExpressionString() + " = " + e35.calculate() + ", computing time : " + e35.getComputingTime() + " s.");
        Function fib3 = new Function("fib3", "if(n>1, fib3(n-1)+fib3(n-2), if(n>0,1,0))", "n");
        mXparser.consolePrintln("fib2: ");
        for (int i = 0; i <= 10; ++i) {
            mXparser.consolePrint(fib3.calculate(i) + ", ");
        }
        mXparser.consolePrintln();
        Expression e36 = new Expression("sum(i, 0, 10, fib3(i))", new PrimitiveElement[0]);
        e36.addDefinitions(fib3);
        mXparser.consolePrintln(e36.getExpressionString() + " = " + e36.calculate() + ", computing time : " + e36.getComputingTime() + " s.");
        Function T = new Function("T", "if(n>1, 2*x*T(n-1,x)-T(n-2,x), if(n>0, x, 1) )", "n", "x");
        Argument k = new Argument("k", 5.0);
        Expression e37 = new Expression("T(k,x) - ( (x + sqrt(x^2-1))^k + (x - sqrt(x^2-1))^k)/2", k, x);
        e37.addDefinitions(T);
        mXparser.consolePrintln(e37.getExpressionString() + " = " + e37.calculate() + ", computing time : " + e37.getComputingTime() + " s.");
        Function Cnk = new Function("Cnk", "if( k>0, if( k<n, Cnk(n-1,k-1)+Cnk(n-1,k), 1), 1)", "n", "k");
        Expression e38 = new Expression("C(10,5) - Cnk(10,5)", new PrimitiveElement[0]);
        e38.addDefinitions(Cnk);
        mXparser.consolePrintln(e38.getExpressionString() + " = " + e38.calculate() + ", computing time : " + e38.getComputingTime() + " s.");
        Constant a = new Constant("a", 5.0);
        Constant b = new Constant("b", 10.0);
        Constant c = new Constant("c", 15.0);
        Expression e39 = new Expression("a+b+c", new PrimitiveElement[0]);
        e39.addDefinitions(a, b, c);
        e39.setVerboseMode();
        e39.checkSyntax();
        mXparser.consolePrintln();
        mXparser.consolePrintln(e39.getErrorMessage());
        mXparser.consolePrintln(e39.getExpressionString() + " = " + e39.calculate() + ", computing time : " + e39.getComputingTime() + " s.");
    }
}

