/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.modules.cep.system;

import java.math.BigDecimal;
import java.util.Date;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.marketcetera.core.ExpectedTestFailure;
import org.marketcetera.event.Event;
import org.marketcetera.event.EventTestBase;
import org.marketcetera.module.CopierModuleFactory;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.ModuleManager;
import org.marketcetera.module.ModuleState;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.module.RequestDataException;
import org.marketcetera.module.UnsupportedRequestParameterType;
import org.marketcetera.modules.cep.system.CEPSystemFactory;
import org.marketcetera.modules.cep.system.CEPTestBase;
import org.marketcetera.modules.cep.system.Messages;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.Factory;

public class CEPSystemProcessorTest
extends CEPTestBase {
    private static ModuleURN TEST_URN = new ModuleURN(CEPSystemFactory.PROVIDER_URN, "toli");

    @BeforeClass
    public static void setup() throws Exception {
        sFactory = Factory.getInstance();
    }

    @Override
    protected ModuleURN getModuleURN() {
        return TEST_URN;
    }

    @Override
    protected Class<?> getIncorrectQueryException() {
        return RequestDataException.class;
    }

    @Ignore
    public void info() throws Exception {
        CEPSystemProcessorTest.assertProviderInfo((ModuleManager)this.sManager, (ModuleURN)CEPSystemFactory.PROVIDER_URN, (String[])new String[0], (Class[])new Class[0], (String)Messages.PROVIDER_DESCRIPTION.getText(), (boolean)false, (boolean)false);
        CEPSystemProcessorTest.assertModuleInfo((ModuleManager)this.sManager, (ModuleURN)CEPSystemFactory.PROVIDER_URN, (ModuleState)ModuleState.STARTED, null, null, (boolean)false, (boolean)true, (boolean)false, (boolean)true, (boolean)false);
    }

    @Test(timeout=120000L)
    public void testBasicFlow() throws Exception {
        DataFlowID flowID = this.sManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)new Event[]{this.bid1, this.trade1, this.trade2}), new DataRequest(TEST_URN, (Object)"select * from trade")});
        Assert.assertSame((String)"Didn't receive right trade event", (Object)this.trade1, (Object)sSink.getNextData());
        Assert.assertSame((String)"Didn't receive right trade event", (Object)this.trade2, (Object)sSink.getNextData());
        Assert.assertEquals((String)"Wrong number of received events", (long)3L, (long)this.sManager.getDataFlowInfo(flowID).getFlowSteps()[1].getNumReceived());
        Assert.assertEquals((String)"Wrong number of emitted events", (long)2L, (long)this.sManager.getDataFlowInfo(flowID).getFlowSteps()[1].getNumEmitted());
        this.sManager.cancel(flowID);
    }

    @Test(timeout=120000L)
    public void testInvalidStringArrReqeust() throws Exception {
        new ExpectedTestFailure(UnsupportedRequestParameterType.class){

            protected void execute() throws Exception {
                CEPSystemProcessorTest.this.sManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)new Event[]{EventTestBase.generateEquityBidEvent((long)1L, (Date)new Date(2L), (Equity)new Equity("GOOG"), (String)"NYSE", (BigDecimal)new BigDecimal("300"), (BigDecimal)new BigDecimal("100"), (Date)new Date()), EventTestBase.generateEquityTradeEvent((long)3L, (Date)new Date(4L), (Equity)new Equity("IBM"), (String)"NYSE", (BigDecimal)new BigDecimal("85"), (BigDecimal)new BigDecimal("200"), (Date)new Date()), EventTestBase.generateEquityAskEvent((long)5L, (Date)new Date(6L), (Equity)new Equity("JAVA"), (String)"NASDAQ", (BigDecimal)new BigDecimal("1.23"), (BigDecimal)new BigDecimal("300"), (Date)new Date())}), new DataRequest(TEST_URN, (Object)new String[]{"select * from bob", "select * from fred"})});
            }
        }.run();
    }

    @Override
    @Test(timeout=120000L)
    public void testUnknownAlias() throws Exception {
        new ExpectedTestFailure(RequestDataException.class, Messages.UNSUPPORTED_TYPE.getText((Object)"bob")){

            protected void execute() throws Exception {
                CEPSystemProcessorTest.this.sManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)new Event[]{EventTestBase.generateEquityBidEvent((long)1L, (Date)new Date(2L), (Equity)new Equity("GOOG"), (String)"NYSE", (BigDecimal)new BigDecimal("300"), (BigDecimal)new BigDecimal("100"), (Date)new Date()), EventTestBase.generateEquityTradeEvent((long)3L, (Date)new Date(4L), (Equity)new Equity("IBM"), (String)"NYSE", (BigDecimal)new BigDecimal("85"), (BigDecimal)new BigDecimal("200"), (Date)new Date()), EventTestBase.generateEquityAskEvent((long)5L, (Date)new Date(6L), (Equity)new Equity("JAVA"), (String)"NASDAQ", (BigDecimal)new BigDecimal("1.23"), (BigDecimal)new BigDecimal("300"), (Date)new Date())}), new DataRequest(TEST_URN, (Object)"select * from bob")});
            }
        }.run();
    }
}

