// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("NAME_SHADOWING")

package org.matrix.rustcomponents.sdk;

// Common helper code.
//
// Ideally this would live in a separate .kt file where it can be unittested etc
// in isolation, and perhaps even published as a re-useable package.
//
// However, it's important that the detils of how this helper code works (e.g. the
// way that different builtin types are passed across the FFI) exactly match what's
// expected by the Rust code on the other side of the interface. In practice right
// now that means coming from the exact some version of `uniffi` that was used to
// compile the Rust component. The easiest way to ensure this is to bundle the Kotlin
// helpers directly inline like we're doing here.

import com.sun.jna.Library
import com.sun.jna.Native
import com.sun.jna.Pointer
import com.sun.jna.Structure
import com.sun.jna.Callback
import com.sun.jna.ptr.*
import java.nio.ByteBuffer
import java.nio.ByteOrder
import java.util.concurrent.ConcurrentHashMap
import java.util.concurrent.atomic.AtomicBoolean
import java.util.concurrent.atomic.AtomicLong
import java.util.concurrent.locks.ReentrantLock
import kotlin.concurrent.withLock

// This is a helper for safely working with byte buffers returned from the Rust code.
// A rust-owned buffer is represented by its capacity, its current length, and a
// pointer to the underlying data.

@Structure.FieldOrder("capacity", "len", "data")
open class RustBuffer : Structure() {
    @JvmField var capacity: Int = 0
    @JvmField var len: Int = 0
    @JvmField var data: Pointer? = null

    class ByValue: RustBuffer(), Structure.ByValue
    class ByReference: RustBuffer(), Structure.ByReference

    companion object {
        internal fun alloc(size: Int = 0) = rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_rustbuffer_alloc(size, status).also {
                if(it.data == null) {
                   throw RuntimeException("RustBuffer.alloc() returned null data pointer (size=${size})")
               }
            }
        }

        internal fun free(buf: RustBuffer.ByValue) = rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_rustbuffer_free(buf, status)
        }
    }

    @Suppress("TooGenericExceptionThrown")
    fun asByteBuffer() =
        this.data?.getByteBuffer(0, this.len.toLong())?.also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
}

/**
 * The equivalent of the `*mut RustBuffer` type.
 * Required for callbacks taking in an out pointer.
 *
 * Size is the sum of all values in the struct.
 */
class RustBufferByReference : ByReference(16) {
    /**
     * Set the pointed-to `RustBuffer` to the given value.
     */
    fun setValue(value: RustBuffer.ByValue) {
        // NOTE: The offsets are as they are in the C-like struct.
        val pointer = getPointer()
        pointer.setInt(0, value.capacity)
        pointer.setInt(4, value.len)
        pointer.setPointer(8, value.data)
    }

    /**
     * Get a `RustBuffer.ByValue` from this reference.
     */
    fun getValue(): RustBuffer.ByValue {
        val pointer = getPointer()
        val value = RustBuffer.ByValue()
        value.writeField("capacity", pointer.getInt(0))
        value.writeField("len", pointer.getInt(4))
        value.writeField("data", pointer.getPointer(8))

        return value
    }
}

// This is a helper for safely passing byte references into the rust code.
// It's not actually used at the moment, because there aren't many things that you
// can take a direct pointer to in the JVM, and if we're going to copy something
// then we might as well copy it into a `RustBuffer`. But it's here for API
// completeness.

@Structure.FieldOrder("len", "data")
open class ForeignBytes : Structure() {
    @JvmField var len: Int = 0
    @JvmField var data: Pointer? = null

    class ByValue : ForeignBytes(), Structure.ByValue
}

// The FfiConverter interface handles converter types to and from the FFI
//
// All implementing objects should be public to support external types.  When a
// type is external we need to import it's FfiConverter.
public interface FfiConverter<KotlinType, FfiType> {
    // Convert an FFI type to a Kotlin type
    fun lift(value: FfiType): KotlinType

    // Convert an Kotlin type to an FFI type
    fun lower(value: KotlinType): FfiType

    // Read a Kotlin type from a `ByteBuffer`
    fun read(buf: ByteBuffer): KotlinType

    // Calculate bytes to allocate when creating a `RustBuffer`
    //
    // This must return at least as many bytes as the write() function will
    // write. It can return more bytes than needed, for example when writing
    // Strings we can't know the exact bytes needed until we the UTF-8
    // encoding, so we pessimistically allocate the largest size possible (3
    // bytes per codepoint).  Allocating extra bytes is not really a big deal
    // because the `RustBuffer` is short-lived.
    fun allocationSize(value: KotlinType): Int

    // Write a Kotlin type to a `ByteBuffer`
    fun write(value: KotlinType, buf: ByteBuffer)

    // Lower a value into a `RustBuffer`
    //
    // This method lowers a value into a `RustBuffer` rather than the normal
    // FfiType.  It's used by the callback interface code.  Callback interface
    // returns are always serialized into a `RustBuffer` regardless of their
    // normal FFI type.
    fun lowerIntoRustBuffer(value: KotlinType): RustBuffer.ByValue {
        val rbuf = RustBuffer.alloc(allocationSize(value))
        try {
            val bbuf = rbuf.data!!.getByteBuffer(0, rbuf.capacity.toLong()).also {
                it.order(ByteOrder.BIG_ENDIAN)
            }
            write(value, bbuf)
            rbuf.writeField("len", bbuf.position())
            return rbuf
        } catch (e: Throwable) {
            RustBuffer.free(rbuf)
            throw e
        }
    }

    // Lift a value from a `RustBuffer`.
    //
    // This here mostly because of the symmetry with `lowerIntoRustBuffer()`.
    // It's currently only used by the `FfiConverterRustBuffer` class below.
    fun liftFromRustBuffer(rbuf: RustBuffer.ByValue): KotlinType {
        val byteBuf = rbuf.asByteBuffer()!!
        try {
           val item = read(byteBuf)
           if (byteBuf.hasRemaining()) {
               throw RuntimeException("junk remaining in buffer after lifting, something is very wrong!!")
           }
           return item
        } finally {
            RustBuffer.free(rbuf)
        }
    }
}

// FfiConverter that uses `RustBuffer` as the FfiType
public interface FfiConverterRustBuffer<KotlinType>: FfiConverter<KotlinType, RustBuffer.ByValue> {
    override fun lift(value: RustBuffer.ByValue) = liftFromRustBuffer(value)
    override fun lower(value: KotlinType) = lowerIntoRustBuffer(value)
}
// A handful of classes and functions to support the generated data structures.
// This would be a good candidate for isolating in its own ffi-support lib.
// Error runtime.
@Structure.FieldOrder("code", "error_buf")
internal open class RustCallStatus : Structure() {
    @JvmField var code: Int = 0
    @JvmField var error_buf: RustBuffer.ByValue = RustBuffer.ByValue()

    fun isSuccess(): Boolean {
        return code == 0
    }

    fun isError(): Boolean {
        return code == 1
    }

    fun isPanic(): Boolean {
        return code == 2
    }
}

class InternalException(message: String) : Exception(message)

// Each top-level error class has a companion object that can lift the error from the call status's rust buffer
interface CallStatusErrorHandler<E> {
    fun lift(error_buf: RustBuffer.ByValue): E;
}

// Helpers for calling Rust
// In practice we usually need to be synchronized to call this safely, so it doesn't
// synchronize itself

// Call a rust function that returns a Result<>.  Pass in the Error class companion that corresponds to the Err
private inline fun <U, E: Exception> rustCallWithError(errorHandler: CallStatusErrorHandler<E>, callback: (RustCallStatus) -> U): U {
    var status = RustCallStatus();
    val return_value = callback(status)
    if (status.isSuccess()) {
        return return_value
    } else if (status.isError()) {
        throw errorHandler.lift(status.error_buf)
    } else if (status.isPanic()) {
        // when the rust code sees a panic, it tries to construct a rustbuffer
        // with the message.  but if that code panics, then it just sends back
        // an empty buffer.
        if (status.error_buf.len > 0) {
            throw InternalException(FfiConverterString.lift(status.error_buf))
        } else {
            throw InternalException("Rust panic")
        }
    } else {
        throw InternalException("Unknown rust call status: $status.code")
    }
}

// CallStatusErrorHandler implementation for times when we don't expect a CALL_ERROR
object NullCallStatusErrorHandler: CallStatusErrorHandler<InternalException> {
    override fun lift(error_buf: RustBuffer.ByValue): InternalException {
        RustBuffer.free(error_buf)
        return InternalException("Unexpected CALL_ERROR")
    }
}

// Call a rust function that returns a plain value
private inline fun <U> rustCall(callback: (RustCallStatus) -> U): U {
    return rustCallWithError(NullCallStatusErrorHandler, callback);
}

// Contains loading, initialization code,
// and the FFI Function declarations in a com.sun.jna.Library.
@Synchronized
private fun findLibraryName(componentName: String): String {
    val libOverride = System.getProperty("uniffi.component.$componentName.libraryOverride")
    if (libOverride != null) {
        return libOverride
    }
    return "matrix_sdk_ffi"
}

private inline fun <reified Lib : Library> loadIndirect(
    componentName: String
): Lib {
    return Native.load<Lib>(findLibraryName(componentName), Lib::class.java)
}

// A JNA Library to expose the extern-C FFI definitions.
// This is an implementation detail which will be called internally by the public API.

internal interface _UniFFILib : Library {
    companion object {
        internal val INSTANCE: _UniFFILib by lazy {
            loadIndirect<_UniFFILib>(componentName = "matrix_sdk_ffi")
            .also { lib: _UniFFILib ->
                FfiConverterTypeClientDelegate.register(lib)
                FfiConverterTypeSessionVerificationControllerDelegate.register(lib)
                FfiConverterTypeSlidingSyncListRoomItemsObserver.register(lib)
                FfiConverterTypeSlidingSyncListRoomListObserver.register(lib)
                FfiConverterTypeSlidingSyncListRoomsCountObserver.register(lib)
                FfiConverterTypeSlidingSyncListStateObserver.register(lib)
                FfiConverterTypeSlidingSyncObserver.register(lib)
                FfiConverterTypeTimelineListener.register(lib)
                }
            
        }
    }

    
    fun ffi_matrix_sdk_ffi_a64_TaskHandle_object_free(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_TaskHandle_cancel_a65c(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_TaskHandle_is_finished_56b2(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Byte
    fun ffi_matrix_sdk_ffi_a64_SlidingSyncListBuilder_object_free(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_SlidingSyncListBuilder_new(
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun matrix_sdk_ffi_a64_SlidingSyncListBuilder_sync_mode(`ptr`: Pointer,`mode`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun matrix_sdk_ffi_a64_SlidingSyncListBuilder_build(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_add_range_2f2d(`ptr`: Pointer,`from`: Int,`to`: Int,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_batch_size_2b78(`ptr`: Pointer,`batchSize`: Int,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_filters_3274(`ptr`: Pointer,`filters`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_name_dfb(`ptr`: Pointer,`name`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_no_filters_3d7b(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_no_room_limit_9ab4(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_no_timeline_limit_1d0d(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_required_state_827b(`ptr`: Pointer,`requiredState`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_reset_ranges_5b71(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_room_limit_d39c(`ptr`: Pointer,`limit`: Int,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_sort_1272(`ptr`: Pointer,`sort`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_timeline_limit_554d(`ptr`: Pointer,`limit`: Int,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun ffi_matrix_sdk_ffi_a64_SlidingSyncList_object_free(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_SlidingSyncList_observe_room_list(`ptr`: Pointer,`observer`: Long,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun matrix_sdk_ffi_a64_SlidingSyncList_observe_rooms_count(`ptr`: Pointer,`observer`: Long,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun matrix_sdk_ffi_a64_SlidingSyncList_observe_state(`ptr`: Pointer,`observer`: Long,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncList_add_range_78e2(`ptr`: Pointer,`start`: Int,`end`: Int,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncList_current_room_count_8e0(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncList_current_room_list_34df(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncList_get_timeline_limit_486f(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncList_reset_ranges_7aea(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncList_set_range_d537(`ptr`: Pointer,`start`: Int,`end`: Int,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncList_set_timeline_limit_17e1(`ptr`: Pointer,`value`: Int,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncList_unset_timeline_limit_336e(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun ffi_matrix_sdk_ffi_a64_SlidingSyncRoom_object_free(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_SlidingSyncRoom_subscribe_and_add_timeline_listener(`ptr`: Pointer,`listener`: Long,`settings`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun matrix_sdk_ffi_a64_SlidingSyncRoom_add_timeline_listener(`ptr`: Pointer,`listener`: Long,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncRoom_avatar_url_5462(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncRoom_full_room_6ee7(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncRoom_has_unread_notifications_aad9(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Byte
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncRoom_is_dm_8047(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncRoom_is_initial_b79c(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncRoom_is_loading_more_98c9(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Byte
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncRoom_latest_room_message_d69d(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncRoom_name_6a4c(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncRoom_room_id_a4da(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncRoom_unread_notifications_4c16(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun ffi_matrix_sdk_ffi_a64_SlidingSync_object_free(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_SlidingSync_set_observer(`ptr`: Pointer,`observer`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_SlidingSync_subscribe(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`settings`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_SlidingSync_unsubscribe(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_SlidingSync_get_room(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun matrix_sdk_ffi_a64_SlidingSync_get_rooms(`ptr`: Pointer,`roomIds`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSync_add_common_extensions_6d8e(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSync_add_list_691f(`ptr`: Pointer,`list`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSync_get_list_535c(`ptr`: Pointer,`name`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSync_pop_list_c712(`ptr`: Pointer,`name`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSync_reset_lists_4375(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSync_sync_4bb(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun ffi_matrix_sdk_ffi_a64_ClientBuilder_object_free(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_ClientBuilder_new(
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun matrix_sdk_ffi_a64_ClientBuilder_build(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_ClientBuilder_base_path_a1af(`ptr`: Pointer,`path`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_ClientBuilder_homeserver_url_d5fa(`ptr`: Pointer,`url`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_ClientBuilder_passphrase_fa90(`ptr`: Pointer,`passphrase`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_ClientBuilder_server_name_3073(`ptr`: Pointer,`serverName`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_ClientBuilder_server_versions_366(`ptr`: Pointer,`versions`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_ClientBuilder_sliding_sync_proxy_fd67(`ptr`: Pointer,`slidingSyncProxy`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_ClientBuilder_user_agent_c34d(`ptr`: Pointer,`userAgent`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_ClientBuilder_username_6f74(`ptr`: Pointer,`username`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun ffi_matrix_sdk_ffi_a64_SlidingSyncBuilder_object_free(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_SlidingSyncBuilder_homeserver(`ptr`: Pointer,`url`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun matrix_sdk_ffi_a64_SlidingSyncBuilder_build(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncBuilder_add_list_2044(`ptr`: Pointer,`v`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncBuilder_storage_key_224b(`ptr`: Pointer,`name`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncBuilder_with_all_extensions_7e0f(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncBuilder_with_common_extensions_e90d(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncBuilder_without_account_data_extension_d3f5(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncBuilder_without_e2ee_extension_bc03(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncBuilder_without_receipt_extension_ea21(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncBuilder_without_to_device_extension_2502(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_SlidingSyncBuilder_without_typing_extension_96fe(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun ffi_matrix_sdk_ffi_a64_Client_object_free(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Client_set_delegate(`ptr`: Pointer,`delegate`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Client_login(`ptr`: Pointer,`username`: RustBuffer.ByValue,`password`: RustBuffer.ByValue,`initialDeviceName`: RustBuffer.ByValue,`deviceId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Client_get_media_file(`ptr`: Pointer,`source`: Pointer,`mimeType`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_Client_account_data_c0e2(`ptr`: Pointer,`eventType`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Client_avatar_url_dca2(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Client_cached_avatar_url_eafb(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Client_create_room_d94e(`ptr`: Pointer,`request`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Client_device_id_93f(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Client_display_name_39ad(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Client_get_dm_room_5342(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Client_get_media_content_2cc4(`ptr`: Pointer,`mediaSource`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Client_get_media_thumbnail_2f9e(`ptr`: Pointer,`mediaSource`: Pointer,`width`: Long,`height`: Long,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Client_get_profile_7f94(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Client_get_session_verification_controller_47cf(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_Client_homeserver_cb72(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Client_ignore_user_f636(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_Client_logout_e617(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_Client_restore_session_e586(`ptr`: Pointer,`session`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_Client_rooms_bbf1(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Client_search_users_f239(`ptr`: Pointer,`searchTerm`: RustBuffer.ByValue,`limit`: Long,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Client_session_3236(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Client_set_account_data_c63f(`ptr`: Pointer,`eventType`: RustBuffer.ByValue,`content`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_Client_set_display_name_1461(`ptr`: Pointer,`name`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_Client_set_pusher_40f8(`ptr`: Pointer,`identifiers`: RustBuffer.ByValue,`kind`: RustBuffer.ByValue,`appDisplayName`: RustBuffer.ByValue,`deviceDisplayName`: RustBuffer.ByValue,`profileTag`: RustBuffer.ByValue,`lang`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_Client_sliding_sync_3ce1(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_Client_unignore_user_e4ef(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_Client_upload_media_5801(`ptr`: Pointer,`mimeType`: RustBuffer.ByValue,`data`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Client_user_id_5c0b(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_a64_MediaFileHandle_object_free(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_MediaFileHandle_path(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_a64_RoomMember_object_free(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_RoomMember_avatar_url_4027(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_RoomMember_display_name_a28c(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_RoomMember_ignore_5349(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_RoomMember_is_account_user_22e7(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Byte
    fun _uniffi_matrix_sdk_ffi_impl_RoomMember_is_ignored_e9ed(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Byte
    fun _uniffi_matrix_sdk_ffi_impl_RoomMember_is_name_ambiguous_4eb9(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Byte
    fun _uniffi_matrix_sdk_ffi_impl_RoomMember_membership_8b7e(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_RoomMember_normalized_power_level_c46(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Long
    fun _uniffi_matrix_sdk_ffi_impl_RoomMember_power_level_e051(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Long
    fun _uniffi_matrix_sdk_ffi_impl_RoomMember_unignore_9d34(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_RoomMember_user_id_c970(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_a64_Room_object_free(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Room_display_name(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun matrix_sdk_ffi_a64_Room_is_encrypted(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Byte
    fun matrix_sdk_ffi_a64_Room_members(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun matrix_sdk_ffi_a64_Room_member_avatar_url(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun matrix_sdk_ffi_a64_Room_member_display_name(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun matrix_sdk_ffi_a64_Room_add_timeline_listener(`ptr`: Pointer,`listener`: Long,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun matrix_sdk_ffi_a64_Room_paginate_backwards(`ptr`: Pointer,`opts`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Room_send_read_receipt(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Room_send_read_marker(`ptr`: Pointer,`fullyReadEventId`: RustBuffer.ByValue,`readReceiptEventId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Room_send(`ptr`: Pointer,`msg`: Pointer,`txnId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Room_send_reply(`ptr`: Pointer,`msg`: RustBuffer.ByValue,`inReplyToEventId`: RustBuffer.ByValue,`txnId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Room_edit(`ptr`: Pointer,`newMsg`: RustBuffer.ByValue,`originalEventId`: RustBuffer.ByValue,`txnId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Room_redact(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,`reason`: RustBuffer.ByValue,`txnId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Room_report_content(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,`score`: RustBuffer.ByValue,`reason`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Room_ignore_user(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Room_send_reaction(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,`key`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Room_leave(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Room_reject_invitation(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Room_accept_invitation(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Room_set_topic(`ptr`: Pointer,`topic`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Room_upload_avatar(`ptr`: Pointer,`mimeType`: RustBuffer.ByValue,`data`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Room_remove_avatar(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Room_invite_user_by_id(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_Room_alternative_aliases_6756(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Room_avatar_url_723b(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Room_canonical_alias_6c5e(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Room_fetch_members_caf7(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_Room_id_8cb8(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Room_inviter_679(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Room_is_direct_5762(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Byte
    fun _uniffi_matrix_sdk_ffi_impl_Room_is_public_ea60(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Byte
    fun _uniffi_matrix_sdk_ffi_impl_Room_is_space_4eb2(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Byte
    fun _uniffi_matrix_sdk_ffi_impl_Room_is_tombstoned_649(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Byte
    fun _uniffi_matrix_sdk_ffi_impl_Room_membership_723(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Room_name_961e(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Room_remove_timeline_28b8(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_Room_retry_decryption_d3c(`ptr`: Pointer,`sessionIds`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_Room_topic_cc24(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_a64_TimelineItem_object_free(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_TimelineItem_as_event_9e04(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_TimelineItem_as_virtual_d72c(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_TimelineItem_fmt_debug_6d42(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_a64_TimelineDiff_object_free(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_TimelineDiff_append_c24b(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_TimelineDiff_change_6a6d(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_TimelineDiff_insert_b007(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_TimelineDiff_push_back_3aff(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_TimelineDiff_push_front_96a0(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_TimelineDiff_remove_d74f(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_TimelineDiff_reset_6b55(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_TimelineDiff_set_3cf2(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_a64_RoomMessageEventContent_object_free(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun ffi_matrix_sdk_ffi_a64_MediaSource_object_free(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_MediaSource_url(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_a64_AuthenticationService_object_free(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_AuthenticationService_new(`basePath`: RustBuffer.ByValue,`passphrase`: RustBuffer.ByValue,`customSlidingSyncProxy`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_AuthenticationService_configure_homeserver_5a2b(`ptr`: Pointer,`serverNameOrHomeserverUrl`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_AuthenticationService_homeserver_details_5a3d(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_AuthenticationService_login_e1b3(`ptr`: Pointer,`username`: RustBuffer.ByValue,`password`: RustBuffer.ByValue,`initialDeviceName`: RustBuffer.ByValue,`deviceId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_AuthenticationService_restore_with_access_token_1d43(`ptr`: Pointer,`token`: RustBuffer.ByValue,`deviceId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun ffi_matrix_sdk_ffi_a64_NotificationService_object_free(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_NotificationService_new(`basePath`: RustBuffer.ByValue,`userId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun matrix_sdk_ffi_a64_NotificationService_get_notification_item(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`eventId`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_a64_SessionVerificationEmoji_object_free(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_SessionVerificationEmoji_description_955f(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_SessionVerificationEmoji_symbol_89f7(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_a64_SessionVerificationController_object_free(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_SessionVerificationController_set_delegate(`ptr`: Pointer,`delegate`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_SessionVerificationController_request_verification(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_SessionVerificationController_start_sas_verification(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_SessionVerificationController_approve_verification(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_SessionVerificationController_decline_verification(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_SessionVerificationController_cancel_verification(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_SessionVerificationController_is_verified_e7e9(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Byte
    fun ffi_matrix_sdk_ffi_a64_Span_object_free(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun matrix_sdk_ffi_a64_Span_new(`file`: RustBuffer.ByValue,`line`: Int,`column`: Int,`level`: RustBuffer.ByValue,`target`: RustBuffer.ByValue,`name`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun matrix_sdk_ffi_a64_Span_current(
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_Span_enter_5cf(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_Span_exit_cea8(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_Span_is_none_e9e0(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Byte
    fun _uniffi_matrix_sdk_ffi_object_free_EventTimelineItem_46cf(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_EventTimelineItem_content_b878(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_impl_EventTimelineItem_debug_info_2597(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_EventTimelineItem_event_id_fd2e(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_EventTimelineItem_is_editable_b154(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Byte
    fun _uniffi_matrix_sdk_ffi_impl_EventTimelineItem_is_local_dd0d(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Byte
    fun _uniffi_matrix_sdk_ffi_impl_EventTimelineItem_is_own_1bd0(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Byte
    fun _uniffi_matrix_sdk_ffi_impl_EventTimelineItem_is_remote_2a3e(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Byte
    fun _uniffi_matrix_sdk_ffi_impl_EventTimelineItem_local_send_state_6078(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_EventTimelineItem_reactions_89f7(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_EventTimelineItem_sender_9be3(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_EventTimelineItem_sender_profile_382f(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_EventTimelineItem_timestamp_be48(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Long
    fun _uniffi_matrix_sdk_ffi_impl_EventTimelineItem_unique_identifier_91e7(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_object_free_HomeserverLoginDetails_2400(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_HomeserverLoginDetails_authentication_issuer_8e36(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_HomeserverLoginDetails_supports_password_login_db17(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Byte
    fun _uniffi_matrix_sdk_ffi_impl_HomeserverLoginDetails_url_e46d(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_object_free_Message_1ab4(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_Message_body_ad14(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Message_in_reply_to_1857(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_Message_is_edited_d878(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Byte
    fun _uniffi_matrix_sdk_ffi_impl_Message_msgtype_13c1(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_object_free_TimelineItemContent_2b31(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_TimelineItemContent_as_message_31df(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_impl_TimelineItemContent_kind_4894(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_object_free_UnreadNotificationsCount_b323(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_impl_UnreadNotificationsCount_has_notifications_72(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Byte
    fun _uniffi_matrix_sdk_ffi_impl_UnreadNotificationsCount_highlight_count_41b0(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Int
    fun _uniffi_matrix_sdk_ffi_impl_UnreadNotificationsCount_notification_count_1e7d(`ptr`: Pointer,
    _uniffi_out_err: RustCallStatus
    ): Int
    fun ffi_matrix_sdk_ffi_a64_ClientDelegate_init_callback(`callbackStub`: ForeignCallback,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun ffi_matrix_sdk_ffi_a64_SlidingSyncObserver_init_callback(`callbackStub`: ForeignCallback,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun ffi_matrix_sdk_ffi_a64_SlidingSyncListStateObserver_init_callback(`callbackStub`: ForeignCallback,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun ffi_matrix_sdk_ffi_a64_SlidingSyncListRoomListObserver_init_callback(`callbackStub`: ForeignCallback,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun ffi_matrix_sdk_ffi_a64_SlidingSyncListRoomsCountObserver_init_callback(`callbackStub`: ForeignCallback,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun ffi_matrix_sdk_ffi_a64_SlidingSyncListRoomItemsObserver_init_callback(`callbackStub`: ForeignCallback,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun ffi_matrix_sdk_ffi_a64_TimelineListener_init_callback(`callbackStub`: ForeignCallback,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun ffi_matrix_sdk_ffi_a64_SessionVerificationControllerDelegate_init_callback(`callbackStub`: ForeignCallback,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_gen_transaction_id_4593(
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun _uniffi_matrix_sdk_ffi_log_event_374d(`file`: RustBuffer.ByValue,`line`: Int,`column`: Int,`level`: RustBuffer.ByValue,`target`: RustBuffer.ByValue,`message`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_media_source_from_url_3a26(`url`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_message_event_content_from_markdown_df5b(`md`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Pointer
    fun _uniffi_matrix_sdk_ffi_setup_otlp_tracing_5801(`filter`: RustBuffer.ByValue,`clientName`: RustBuffer.ByValue,`user`: RustBuffer.ByValue,`password`: RustBuffer.ByValue,`otlpEndpoint`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun _uniffi_matrix_sdk_ffi_setup_tracing_ac08(`filter`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun ffi_matrix_sdk_ffi_a64_rustbuffer_alloc(`size`: Int,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_a64_rustbuffer_from_bytes(`bytes`: ForeignBytes.ByValue,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_a64_rustbuffer_free(`buf`: RustBuffer.ByValue,
    _uniffi_out_err: RustCallStatus
    ): Unit
    fun ffi_matrix_sdk_ffi_a64_rustbuffer_reserve(`buf`: RustBuffer.ByValue,`additional`: Int,
    _uniffi_out_err: RustCallStatus
    ): RustBuffer.ByValue
}

// Public interface members begin here.


public object FfiConverterUByte: FfiConverter<UByte, Byte> {
    override fun lift(value: Byte): UByte {
        return value.toUByte()
    }

    override fun read(buf: ByteBuffer): UByte {
        return lift(buf.get())
    }

    override fun lower(value: UByte): Byte {
        return value.toByte()
    }

    override fun allocationSize(value: UByte) = 1

    override fun write(value: UByte, buf: ByteBuffer) {
        buf.put(value.toByte())
    }
}

public object FfiConverterUShort: FfiConverter<UShort, Short> {
    override fun lift(value: Short): UShort {
        return value.toUShort()
    }

    override fun read(buf: ByteBuffer): UShort {
        return lift(buf.getShort())
    }

    override fun lower(value: UShort): Short {
        return value.toShort()
    }

    override fun allocationSize(value: UShort) = 2

    override fun write(value: UShort, buf: ByteBuffer) {
        buf.putShort(value.toShort())
    }
}

public object FfiConverterUInt: FfiConverter<UInt, Int> {
    override fun lift(value: Int): UInt {
        return value.toUInt()
    }

    override fun read(buf: ByteBuffer): UInt {
        return lift(buf.getInt())
    }

    override fun lower(value: UInt): Int {
        return value.toInt()
    }

    override fun allocationSize(value: UInt) = 4

    override fun write(value: UInt, buf: ByteBuffer) {
        buf.putInt(value.toInt())
    }
}

public object FfiConverterInt: FfiConverter<Int, Int> {
    override fun lift(value: Int): Int {
        return value
    }

    override fun read(buf: ByteBuffer): Int {
        return buf.getInt()
    }

    override fun lower(value: Int): Int {
        return value
    }

    override fun allocationSize(value: Int) = 4

    override fun write(value: Int, buf: ByteBuffer) {
        buf.putInt(value)
    }
}

public object FfiConverterULong: FfiConverter<ULong, Long> {
    override fun lift(value: Long): ULong {
        return value.toULong()
    }

    override fun read(buf: ByteBuffer): ULong {
        return lift(buf.getLong())
    }

    override fun lower(value: ULong): Long {
        return value.toLong()
    }

    override fun allocationSize(value: ULong) = 8

    override fun write(value: ULong, buf: ByteBuffer) {
        buf.putLong(value.toLong())
    }
}

public object FfiConverterLong: FfiConverter<Long, Long> {
    override fun lift(value: Long): Long {
        return value
    }

    override fun read(buf: ByteBuffer): Long {
        return buf.getLong()
    }

    override fun lower(value: Long): Long {
        return value
    }

    override fun allocationSize(value: Long) = 8

    override fun write(value: Long, buf: ByteBuffer) {
        buf.putLong(value)
    }
}

public object FfiConverterBoolean: FfiConverter<Boolean, Byte> {
    override fun lift(value: Byte): Boolean {
        return value.toInt() != 0
    }

    override fun read(buf: ByteBuffer): Boolean {
        return lift(buf.get())
    }

    override fun lower(value: Boolean): Byte {
        return if (value) 1.toByte() else 0.toByte()
    }

    override fun allocationSize(value: Boolean) = 1

    override fun write(value: Boolean, buf: ByteBuffer) {
        buf.put(lower(value))
    }
}

public object FfiConverterString: FfiConverter<String, RustBuffer.ByValue> {
    // Note: we don't inherit from FfiConverterRustBuffer, because we use a
    // special encoding when lowering/lifting.  We can use `RustBuffer.len` to
    // store our length and avoid writing it out to the buffer.
    override fun lift(value: RustBuffer.ByValue): String {
        try {
            val byteArr = ByteArray(value.len)
            value.asByteBuffer()!!.get(byteArr)
            return byteArr.toString(Charsets.UTF_8)
        } finally {
            RustBuffer.free(value)
        }
    }

    override fun read(buf: ByteBuffer): String {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr.toString(Charsets.UTF_8)
    }

    override fun lower(value: String): RustBuffer.ByValue {
        val byteArr = value.toByteArray(Charsets.UTF_8)
        // Ideally we'd pass these bytes to `ffi_bytebuffer_from_bytes`, but doing so would require us
        // to copy them into a JNA `Memory`. So we might as well directly copy them into a `RustBuffer`.
        val rbuf = RustBuffer.alloc(byteArr.size)
        rbuf.asByteBuffer()!!.put(byteArr)
        return rbuf
    }

    // We aren't sure exactly how many bytes our string will be once it's UTF-8
    // encoded.  Allocate 3 bytes per unicode codepoint which will always be
    // enough.
    override fun allocationSize(value: String): Int {
        val sizeForLength = 4
        val sizeForString = value.length * 3
        return sizeForLength + sizeForString
    }

    override fun write(value: String, buf: ByteBuffer) {
        val byteArr = value.toByteArray(Charsets.UTF_8)
        buf.putInt(byteArr.size)
        buf.put(byteArr)
    }
}


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }

// The base class for all UniFFI Object types.
//
// This class provides core operations for working with the Rust `Arc<T>` pointer to
// the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// the Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each `FFIObject` instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an `FFIObject` is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an `FFIObject` instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so will
//     leak the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each `FFIObject` an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// In the future we may be able to replace some of this with automatic finalization logic, such as using
// the new "Cleaner" functionaility in Java 9. The above scheme has been designed to work even if `destroy` is
// invoked by garbage-collection machinery rather than by calling code (which by the way, it's apparently also
// possible for the JVM to finalize an object while there is an in-flight call to one of its methods [1],
// so there would still be some complexity here).
//
// Sigh...all of this for want of a robust finalization mechanism.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//
abstract class FFIObject(
    protected val pointer: Pointer
): Disposable, AutoCloseable {

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    open protected fun freeRustArcPtr() {
        // To be overridden in subclasses.
    }

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                this.freeRustArcPtr()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.pointer)
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                this.freeRustArcPtr()
            }
        }
    }
}

public interface AuthenticationServiceInterface {
    @Throws(AuthenticationException::class)
    fun `configureHomeserver`(`serverNameOrHomeserverUrl`: String)
    fun `homeserverDetails`(): HomeserverLoginDetails?@Throws(AuthenticationException::class)
    fun `login`(`username`: String, `password`: String, `initialDeviceName`: String?, `deviceId`: String?): Client@Throws(AuthenticationException::class)
    fun `restoreWithAccessToken`(`token`: String, `deviceId`: String): Client
}

class AuthenticationService(
    pointer: Pointer
) : FFIObject(pointer), AuthenticationServiceInterface {
    constructor(`basePath`: String, `passphrase`: String?, `customSlidingSyncProxy`: String?) :
        this(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_AuthenticationService_new(FfiConverterString.lower(`basePath`), FfiConverterOptionalString.lower(`passphrase`), FfiConverterOptionalString.lower(`customSlidingSyncProxy`), _status)
})

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_AuthenticationService_object_free(this.pointer, status)
        }
    }

    
        @Throws(AuthenticationException::class)override fun `configureHomeserver`(`serverNameOrHomeserverUrl`: String) =
        callWithPointer {
    rustCallWithError(AuthenticationException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_AuthenticationService_configure_homeserver_5a2b(it, FfiConverterString.lower(`serverNameOrHomeserverUrl`),  _status)
}
        }
    
    
    override fun `homeserverDetails`(): HomeserverLoginDetails? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_AuthenticationService_homeserver_details_5a3d(it,  _status)
}
        }.let {
            FfiConverterOptionalTypeHomeserverLoginDetails.lift(it)
        }
    
    
        @Throws(AuthenticationException::class)override fun `login`(`username`: String, `password`: String, `initialDeviceName`: String?, `deviceId`: String?): Client =
        callWithPointer {
    rustCallWithError(AuthenticationException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_AuthenticationService_login_e1b3(it, FfiConverterString.lower(`username`), FfiConverterString.lower(`password`), FfiConverterOptionalString.lower(`initialDeviceName`), FfiConverterOptionalString.lower(`deviceId`),  _status)
}
        }.let {
            FfiConverterTypeClient.lift(it)
        }
    
    
        @Throws(AuthenticationException::class)override fun `restoreWithAccessToken`(`token`: String, `deviceId`: String): Client =
        callWithPointer {
    rustCallWithError(AuthenticationException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_AuthenticationService_restore_with_access_token_1d43(it, FfiConverterString.lower(`token`), FfiConverterString.lower(`deviceId`),  _status)
}
        }.let {
            FfiConverterTypeClient.lift(it)
        }
    
    

    
}

public object FfiConverterTypeAuthenticationService: FfiConverter<AuthenticationService, Pointer> {
    override fun lower(value: AuthenticationService): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): AuthenticationService {
        return AuthenticationService(value)
    }

    override fun read(buf: ByteBuffer): AuthenticationService {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: AuthenticationService) = 8

    override fun write(value: AuthenticationService, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface ClientInterface {
    
    fun `setDelegate`(`delegate`: ClientDelegate?)@Throws(ClientException::class)
    fun `login`(`username`: String, `password`: String, `initialDeviceName`: String?, `deviceId`: String?)@Throws(ClientException::class)
    fun `getMediaFile`(`source`: MediaSource, `mimeType`: String): MediaFileHandle@Throws(ClientException::class)
    fun `accountData`(`eventType`: String): String?@Throws(ClientException::class)
    fun `avatarUrl`(): String?@Throws(ClientException::class)
    fun `cachedAvatarUrl`(): String?@Throws(ClientException::class)
    fun `createRoom`(`request`: CreateRoomParameters): String@Throws(ClientException::class)
    fun `deviceId`(): String@Throws(ClientException::class)
    fun `displayName`(): String@Throws(ClientException::class)
    fun `getDmRoom`(`userId`: String): Room?@Throws(ClientException::class)
    fun `getMediaContent`(`mediaSource`: MediaSource): List<UByte>@Throws(ClientException::class)
    fun `getMediaThumbnail`(`mediaSource`: MediaSource, `width`: ULong, `height`: ULong): List<UByte>@Throws(ClientException::class)
    fun `getProfile`(`userId`: String): UserProfile@Throws(ClientException::class)
    fun `getSessionVerificationController`(): SessionVerificationController
    fun `homeserver`(): String@Throws(ClientException::class)
    fun `ignoreUser`(`userId`: String)@Throws(ClientException::class)
    fun `logout`()@Throws(ClientException::class)
    fun `restoreSession`(`session`: Session)
    fun `rooms`(): List<Room>@Throws(ClientException::class)
    fun `searchUsers`(`searchTerm`: String, `limit`: ULong): SearchUsersResults@Throws(ClientException::class)
    fun `session`(): Session@Throws(ClientException::class)
    fun `setAccountData`(`eventType`: String, `content`: String)@Throws(ClientException::class)
    fun `setDisplayName`(`name`: String)@Throws(ClientException::class)
    fun `setPusher`(`identifiers`: PusherIdentifiers, `kind`: PusherKind, `appDisplayName`: String, `deviceDisplayName`: String, `profileTag`: String?, `lang`: String)
    fun `slidingSync`(): SlidingSyncBuilder@Throws(ClientException::class)
    fun `unignoreUser`(`userId`: String)@Throws(ClientException::class)
    fun `uploadMedia`(`mimeType`: String, `data`: List<UByte>): String@Throws(ClientException::class)
    fun `userId`(): String
}

class Client(
    pointer: Pointer
) : FFIObject(pointer), ClientInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_Client_object_free(this.pointer, status)
        }
    }

    override fun `setDelegate`(`delegate`: ClientDelegate?) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Client_set_delegate(it, FfiConverterOptionalTypeClientDelegate.lower(`delegate`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `login`(`username`: String, `password`: String, `initialDeviceName`: String?, `deviceId`: String?) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Client_login(it, FfiConverterString.lower(`username`), FfiConverterString.lower(`password`), FfiConverterOptionalString.lower(`initialDeviceName`), FfiConverterOptionalString.lower(`deviceId`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `getMediaFile`(`source`: MediaSource, `mimeType`: String): MediaFileHandle =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Client_get_media_file(it, FfiConverterTypeMediaSource.lower(`source`), FfiConverterString.lower(`mimeType`),  _status)
}
        }.let {
            FfiConverterTypeMediaFileHandle.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `accountData`(`eventType`: String): String? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_account_data_c0e2(it, FfiConverterString.lower(`eventType`),  _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `avatarUrl`(): String? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_avatar_url_dca2(it,  _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `cachedAvatarUrl`(): String? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_cached_avatar_url_eafb(it,  _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `createRoom`(`request`: CreateRoomParameters): String =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_create_room_d94e(it, FfiConverterTypeCreateRoomParameters.lower(`request`),  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `deviceId`(): String =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_device_id_93f(it,  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `displayName`(): String =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_display_name_39ad(it,  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `getDmRoom`(`userId`: String): Room? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_get_dm_room_5342(it, FfiConverterString.lower(`userId`),  _status)
}
        }.let {
            FfiConverterOptionalTypeRoom.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `getMediaContent`(`mediaSource`: MediaSource): List<UByte> =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_get_media_content_2cc4(it, FfiConverterTypeMediaSource.lower(`mediaSource`),  _status)
}
        }.let {
            FfiConverterSequenceUByte.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `getMediaThumbnail`(`mediaSource`: MediaSource, `width`: ULong, `height`: ULong): List<UByte> =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_get_media_thumbnail_2f9e(it, FfiConverterTypeMediaSource.lower(`mediaSource`), FfiConverterULong.lower(`width`), FfiConverterULong.lower(`height`),  _status)
}
        }.let {
            FfiConverterSequenceUByte.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `getProfile`(`userId`: String): UserProfile =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_get_profile_7f94(it, FfiConverterString.lower(`userId`),  _status)
}
        }.let {
            FfiConverterTypeUserProfile.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `getSessionVerificationController`(): SessionVerificationController =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_get_session_verification_controller_47cf(it,  _status)
}
        }.let {
            FfiConverterTypeSessionVerificationController.lift(it)
        }
    
    override fun `homeserver`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_homeserver_cb72(it,  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `ignoreUser`(`userId`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_ignore_user_f636(it, FfiConverterString.lower(`userId`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `logout`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_logout_e617(it,  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `restoreSession`(`session`: Session) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_restore_session_e586(it, FfiConverterTypeSession.lower(`session`),  _status)
}
        }
    
    
    override fun `rooms`(): List<Room> =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_rooms_bbf1(it,  _status)
}
        }.let {
            FfiConverterSequenceTypeRoom.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `searchUsers`(`searchTerm`: String, `limit`: ULong): SearchUsersResults =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_search_users_f239(it, FfiConverterString.lower(`searchTerm`), FfiConverterULong.lower(`limit`),  _status)
}
        }.let {
            FfiConverterTypeSearchUsersResults.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `session`(): Session =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_session_3236(it,  _status)
}
        }.let {
            FfiConverterTypeSession.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `setAccountData`(`eventType`: String, `content`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_set_account_data_c63f(it, FfiConverterString.lower(`eventType`), FfiConverterString.lower(`content`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `setDisplayName`(`name`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_set_display_name_1461(it, FfiConverterString.lower(`name`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `setPusher`(`identifiers`: PusherIdentifiers, `kind`: PusherKind, `appDisplayName`: String, `deviceDisplayName`: String, `profileTag`: String?, `lang`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_set_pusher_40f8(it, FfiConverterTypePusherIdentifiers.lower(`identifiers`), FfiConverterTypePusherKind.lower(`kind`), FfiConverterString.lower(`appDisplayName`), FfiConverterString.lower(`deviceDisplayName`), FfiConverterOptionalString.lower(`profileTag`), FfiConverterString.lower(`lang`),  _status)
}
        }
    
    
    override fun `slidingSync`(): SlidingSyncBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_sliding_sync_3ce1(it,  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncBuilder.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `unignoreUser`(`userId`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_unignore_user_e4ef(it, FfiConverterString.lower(`userId`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `uploadMedia`(`mimeType`: String, `data`: List<UByte>): String =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_upload_media_5801(it, FfiConverterString.lower(`mimeType`), FfiConverterSequenceUByte.lower(`data`),  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `userId`(): String =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Client_user_id_5c0b(it,  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
}

public object FfiConverterTypeClient: FfiConverter<Client, Pointer> {
    override fun lower(value: Client): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): Client {
        return Client(value)
    }

    override fun read(buf: ByteBuffer): Client {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Client) = 8

    override fun write(value: Client, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface ClientBuilderInterface {
    @Throws(ClientException::class)
    fun `build`(): Client
    fun `basePath`(`path`: String): ClientBuilder
    fun `homeserverUrl`(`url`: String): ClientBuilder
    fun `passphrase`(`passphrase`: String?): ClientBuilder
    fun `serverName`(`serverName`: String): ClientBuilder
    fun `serverVersions`(`versions`: List<String>): ClientBuilder
    fun `slidingSyncProxy`(`slidingSyncProxy`: String?): ClientBuilder
    fun `userAgent`(`userAgent`: String): ClientBuilder
    fun `username`(`username`: String): ClientBuilder
}

class ClientBuilder(
    pointer: Pointer
) : FFIObject(pointer), ClientBuilderInterface {
    constructor() :
        this(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_ClientBuilder_new( _status)
})

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_ClientBuilder_object_free(this.pointer, status)
        }
    }

    
        @Throws(ClientException::class)override fun `build`(): Client =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_ClientBuilder_build(it,  _status)
}
        }.let {
            FfiConverterTypeClient.lift(it)
        }
    
    override fun `basePath`(`path`: String): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_ClientBuilder_base_path_a1af(it, FfiConverterString.lower(`path`),  _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `homeserverUrl`(`url`: String): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_ClientBuilder_homeserver_url_d5fa(it, FfiConverterString.lower(`url`),  _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `passphrase`(`passphrase`: String?): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_ClientBuilder_passphrase_fa90(it, FfiConverterOptionalString.lower(`passphrase`),  _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `serverName`(`serverName`: String): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_ClientBuilder_server_name_3073(it, FfiConverterString.lower(`serverName`),  _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `serverVersions`(`versions`: List<String>): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_ClientBuilder_server_versions_366(it, FfiConverterSequenceString.lower(`versions`),  _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `slidingSyncProxy`(`slidingSyncProxy`: String?): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_ClientBuilder_sliding_sync_proxy_fd67(it, FfiConverterOptionalString.lower(`slidingSyncProxy`),  _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `userAgent`(`userAgent`: String): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_ClientBuilder_user_agent_c34d(it, FfiConverterString.lower(`userAgent`),  _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `username`(`username`: String): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_ClientBuilder_username_6f74(it, FfiConverterString.lower(`username`),  _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    

    
}

public object FfiConverterTypeClientBuilder: FfiConverter<ClientBuilder, Pointer> {
    override fun lower(value: ClientBuilder): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): ClientBuilder {
        return ClientBuilder(value)
    }

    override fun read(buf: ByteBuffer): ClientBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: ClientBuilder) = 8

    override fun write(value: ClientBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface EventTimelineItemInterface {
    
    fun `content`(): TimelineItemContent
    fun `debugInfo`(): EventTimelineItemDebugInfo
    fun `eventId`(): String?
    fun `isEditable`(): Boolean
    fun `isLocal`(): Boolean
    fun `isOwn`(): Boolean
    fun `isRemote`(): Boolean
    fun `localSendState`(): EventSendState?
    fun `reactions`(): List<Reaction>
    fun `sender`(): String
    fun `senderProfile`(): ProfileDetails
    fun `timestamp`(): ULong
    fun `uniqueIdentifier`(): String
}

class EventTimelineItem(
    pointer: Pointer
) : FFIObject(pointer), EventTimelineItemInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_object_free_EventTimelineItem_46cf(this.pointer, status)
        }
    }

    override fun `content`(): TimelineItemContent =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_EventTimelineItem_content_b878(it,  _status)
}
        }.let {
            FfiConverterTypeTimelineItemContent.lift(it)
        }
    
    override fun `debugInfo`(): EventTimelineItemDebugInfo =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_EventTimelineItem_debug_info_2597(it,  _status)
}
        }.let {
            FfiConverterTypeEventTimelineItemDebugInfo.lift(it)
        }
    
    override fun `eventId`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_EventTimelineItem_event_id_fd2e(it,  _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    override fun `isEditable`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_EventTimelineItem_is_editable_b154(it,  _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isLocal`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_EventTimelineItem_is_local_dd0d(it,  _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isOwn`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_EventTimelineItem_is_own_1bd0(it,  _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isRemote`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_EventTimelineItem_is_remote_2a3e(it,  _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `localSendState`(): EventSendState? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_EventTimelineItem_local_send_state_6078(it,  _status)
}
        }.let {
            FfiConverterOptionalTypeEventSendState.lift(it)
        }
    
    override fun `reactions`(): List<Reaction> =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_EventTimelineItem_reactions_89f7(it,  _status)
}
        }.let {
            FfiConverterSequenceTypeReaction.lift(it)
        }
    
    override fun `sender`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_EventTimelineItem_sender_9be3(it,  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `senderProfile`(): ProfileDetails =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_EventTimelineItem_sender_profile_382f(it,  _status)
}
        }.let {
            FfiConverterTypeProfileDetails.lift(it)
        }
    
    override fun `timestamp`(): ULong =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_EventTimelineItem_timestamp_be48(it,  _status)
}
        }.let {
            FfiConverterULong.lift(it)
        }
    
    override fun `uniqueIdentifier`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_EventTimelineItem_unique_identifier_91e7(it,  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
}

public object FfiConverterTypeEventTimelineItem: FfiConverter<EventTimelineItem, Pointer> {
    override fun lower(value: EventTimelineItem): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): EventTimelineItem {
        return EventTimelineItem(value)
    }

    override fun read(buf: ByteBuffer): EventTimelineItem {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: EventTimelineItem) = 8

    override fun write(value: EventTimelineItem, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface HomeserverLoginDetailsInterface {
    
    fun `authenticationIssuer`(): String?
    fun `supportsPasswordLogin`(): Boolean
    fun `url`(): String
}

class HomeserverLoginDetails(
    pointer: Pointer
) : FFIObject(pointer), HomeserverLoginDetailsInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_object_free_HomeserverLoginDetails_2400(this.pointer, status)
        }
    }

    override fun `authenticationIssuer`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_HomeserverLoginDetails_authentication_issuer_8e36(it,  _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    override fun `supportsPasswordLogin`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_HomeserverLoginDetails_supports_password_login_db17(it,  _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `url`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_HomeserverLoginDetails_url_e46d(it,  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
}

public object FfiConverterTypeHomeserverLoginDetails: FfiConverter<HomeserverLoginDetails, Pointer> {
    override fun lower(value: HomeserverLoginDetails): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): HomeserverLoginDetails {
        return HomeserverLoginDetails(value)
    }

    override fun read(buf: ByteBuffer): HomeserverLoginDetails {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: HomeserverLoginDetails) = 8

    override fun write(value: HomeserverLoginDetails, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface MediaFileHandleInterface {
    
    fun `path`(): String
}

class MediaFileHandle(
    pointer: Pointer
) : FFIObject(pointer), MediaFileHandleInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_MediaFileHandle_object_free(this.pointer, status)
        }
    }

    override fun `path`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_MediaFileHandle_path(it,  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
}

public object FfiConverterTypeMediaFileHandle: FfiConverter<MediaFileHandle, Pointer> {
    override fun lower(value: MediaFileHandle): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): MediaFileHandle {
        return MediaFileHandle(value)
    }

    override fun read(buf: ByteBuffer): MediaFileHandle {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: MediaFileHandle) = 8

    override fun write(value: MediaFileHandle, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface MediaSourceInterface {
    
    fun `url`(): String
}

class MediaSource(
    pointer: Pointer
) : FFIObject(pointer), MediaSourceInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_MediaSource_object_free(this.pointer, status)
        }
    }

    override fun `url`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_MediaSource_url(it,  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
}

public object FfiConverterTypeMediaSource: FfiConverter<MediaSource, Pointer> {
    override fun lower(value: MediaSource): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): MediaSource {
        return MediaSource(value)
    }

    override fun read(buf: ByteBuffer): MediaSource {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: MediaSource) = 8

    override fun write(value: MediaSource, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface MessageInterface {
    
    fun `body`(): String
    fun `inReplyTo`(): InReplyToDetails?
    fun `isEdited`(): Boolean
    fun `msgtype`(): MessageType?
}

class Message(
    pointer: Pointer
) : FFIObject(pointer), MessageInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_object_free_Message_1ab4(this.pointer, status)
        }
    }

    override fun `body`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Message_body_ad14(it,  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `inReplyTo`(): InReplyToDetails? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Message_in_reply_to_1857(it,  _status)
}
        }.let {
            FfiConverterOptionalTypeInReplyToDetails.lift(it)
        }
    
    override fun `isEdited`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Message_is_edited_d878(it,  _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `msgtype`(): MessageType? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Message_msgtype_13c1(it,  _status)
}
        }.let {
            FfiConverterOptionalTypeMessageType.lift(it)
        }
    
    

    
}

public object FfiConverterTypeMessage: FfiConverter<Message, Pointer> {
    override fun lower(value: Message): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): Message {
        return Message(value)
    }

    override fun read(buf: ByteBuffer): Message {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Message) = 8

    override fun write(value: Message, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface NotificationServiceInterface {
    @Throws(ClientException::class)
    fun `getNotificationItem`(`roomId`: String, `eventId`: String): NotificationItem?
}

class NotificationService(
    pointer: Pointer
) : FFIObject(pointer), NotificationServiceInterface {
    constructor(`basePath`: String, `userId`: String) :
        this(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_NotificationService_new(FfiConverterString.lower(`basePath`), FfiConverterString.lower(`userId`), _status)
})

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_NotificationService_object_free(this.pointer, status)
        }
    }

    
        @Throws(ClientException::class)override fun `getNotificationItem`(`roomId`: String, `eventId`: String): NotificationItem? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_NotificationService_get_notification_item(it, FfiConverterString.lower(`roomId`), FfiConverterString.lower(`eventId`),  _status)
}
        }.let {
            FfiConverterOptionalTypeNotificationItem.lift(it)
        }
    
    

    
}

public object FfiConverterTypeNotificationService: FfiConverter<NotificationService, Pointer> {
    override fun lower(value: NotificationService): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): NotificationService {
        return NotificationService(value)
    }

    override fun read(buf: ByteBuffer): NotificationService {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: NotificationService) = 8

    override fun write(value: NotificationService, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface RoomInterface {
    @Throws(ClientException::class)
    fun `displayName`(): String@Throws(ClientException::class)
    fun `isEncrypted`(): Boolean@Throws(ClientException::class)
    fun `members`(): List<RoomMember>@Throws(ClientException::class)
    fun `memberAvatarUrl`(`userId`: String): String?@Throws(ClientException::class)
    fun `memberDisplayName`(`userId`: String): String?
    fun `addTimelineListener`(`listener`: TimelineListener): List<TimelineItem>@Throws(ClientException::class)
    fun `paginateBackwards`(`opts`: PaginationOptions)@Throws(ClientException::class)
    fun `sendReadReceipt`(`eventId`: String)@Throws(ClientException::class)
    fun `sendReadMarker`(`fullyReadEventId`: String, `readReceiptEventId`: String?)
    fun `send`(`msg`: RoomMessageEventContent, `txnId`: String?)@Throws(ClientException::class)
    fun `sendReply`(`msg`: String, `inReplyToEventId`: String, `txnId`: String?)@Throws(ClientException::class)
    fun `edit`(`newMsg`: String, `originalEventId`: String, `txnId`: String?)@Throws(ClientException::class)
    fun `redact`(`eventId`: String, `reason`: String?, `txnId`: String?)@Throws(ClientException::class)
    fun `reportContent`(`eventId`: String, `score`: Int?, `reason`: String?)@Throws(ClientException::class)
    fun `ignoreUser`(`userId`: String)@Throws(ClientException::class)
    fun `sendReaction`(`eventId`: String, `key`: String)@Throws(ClientException::class)
    fun `leave`()@Throws(ClientException::class)
    fun `rejectInvitation`()@Throws(ClientException::class)
    fun `acceptInvitation`()@Throws(ClientException::class)
    fun `setTopic`(`topic`: String)@Throws(ClientException::class)
    fun `uploadAvatar`(`mimeType`: String, `data`: List<UByte>)@Throws(ClientException::class)
    fun `removeAvatar`()@Throws(ClientException::class)
    fun `inviteUserById`(`userId`: String)
    fun `alternativeAliases`(): List<String>
    fun `avatarUrl`(): String?
    fun `canonicalAlias`(): String?
    fun `fetchMembers`()
    fun `id`(): String
    fun `inviter`(): RoomMember?
    fun `isDirect`(): Boolean
    fun `isPublic`(): Boolean
    fun `isSpace`(): Boolean
    fun `isTombstoned`(): Boolean
    fun `membership`(): Membership
    fun `name`(): String?
    fun `removeTimeline`()
    fun `retryDecryption`(`sessionIds`: List<String>)
    fun `topic`(): String?
}

class Room(
    pointer: Pointer
) : FFIObject(pointer), RoomInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_Room_object_free(this.pointer, status)
        }
    }

    
        @Throws(ClientException::class)override fun `displayName`(): String =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_display_name(it,  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `isEncrypted`(): Boolean =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_is_encrypted(it,  _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `members`(): List<RoomMember> =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_members(it,  _status)
}
        }.let {
            FfiConverterSequenceTypeRoomMember.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `memberAvatarUrl`(`userId`: String): String? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_member_avatar_url(it, FfiConverterString.lower(`userId`),  _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `memberDisplayName`(`userId`: String): String? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_member_display_name(it, FfiConverterString.lower(`userId`),  _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    override fun `addTimelineListener`(`listener`: TimelineListener): List<TimelineItem> =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_add_timeline_listener(it, FfiConverterTypeTimelineListener.lower(`listener`),  _status)
}
        }.let {
            FfiConverterSequenceTypeTimelineItem.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `paginateBackwards`(`opts`: PaginationOptions) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_paginate_backwards(it, FfiConverterTypePaginationOptions.lower(`opts`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `sendReadReceipt`(`eventId`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_send_read_receipt(it, FfiConverterString.lower(`eventId`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `sendReadMarker`(`fullyReadEventId`: String, `readReceiptEventId`: String?) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_send_read_marker(it, FfiConverterString.lower(`fullyReadEventId`), FfiConverterOptionalString.lower(`readReceiptEventId`),  _status)
}
        }
    
    
    override fun `send`(`msg`: RoomMessageEventContent, `txnId`: String?) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_send(it, FfiConverterTypeRoomMessageEventContent.lower(`msg`), FfiConverterOptionalString.lower(`txnId`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `sendReply`(`msg`: String, `inReplyToEventId`: String, `txnId`: String?) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_send_reply(it, FfiConverterString.lower(`msg`), FfiConverterString.lower(`inReplyToEventId`), FfiConverterOptionalString.lower(`txnId`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `edit`(`newMsg`: String, `originalEventId`: String, `txnId`: String?) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_edit(it, FfiConverterString.lower(`newMsg`), FfiConverterString.lower(`originalEventId`), FfiConverterOptionalString.lower(`txnId`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `redact`(`eventId`: String, `reason`: String?, `txnId`: String?) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_redact(it, FfiConverterString.lower(`eventId`), FfiConverterOptionalString.lower(`reason`), FfiConverterOptionalString.lower(`txnId`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `reportContent`(`eventId`: String, `score`: Int?, `reason`: String?) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_report_content(it, FfiConverterString.lower(`eventId`), FfiConverterOptionalInt.lower(`score`), FfiConverterOptionalString.lower(`reason`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `ignoreUser`(`userId`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_ignore_user(it, FfiConverterString.lower(`userId`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `sendReaction`(`eventId`: String, `key`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_send_reaction(it, FfiConverterString.lower(`eventId`), FfiConverterString.lower(`key`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `leave`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_leave(it,  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `rejectInvitation`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_reject_invitation(it,  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `acceptInvitation`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_accept_invitation(it,  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `setTopic`(`topic`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_set_topic(it, FfiConverterString.lower(`topic`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `uploadAvatar`(`mimeType`: String, `data`: List<UByte>) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_upload_avatar(it, FfiConverterString.lower(`mimeType`), FfiConverterSequenceUByte.lower(`data`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `removeAvatar`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_remove_avatar(it,  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `inviteUserById`(`userId`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Room_invite_user_by_id(it, FfiConverterString.lower(`userId`),  _status)
}
        }
    
    
    override fun `alternativeAliases`(): List<String> =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Room_alternative_aliases_6756(it,  _status)
}
        }.let {
            FfiConverterSequenceString.lift(it)
        }
    
    override fun `avatarUrl`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Room_avatar_url_723b(it,  _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    override fun `canonicalAlias`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Room_canonical_alias_6c5e(it,  _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    override fun `fetchMembers`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Room_fetch_members_caf7(it,  _status)
}
        }
    
    
    override fun `id`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Room_id_8cb8(it,  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `inviter`(): RoomMember? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Room_inviter_679(it,  _status)
}
        }.let {
            FfiConverterOptionalTypeRoomMember.lift(it)
        }
    
    override fun `isDirect`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Room_is_direct_5762(it,  _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isPublic`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Room_is_public_ea60(it,  _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isSpace`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Room_is_space_4eb2(it,  _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isTombstoned`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Room_is_tombstoned_649(it,  _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `membership`(): Membership =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Room_membership_723(it,  _status)
}
        }.let {
            FfiConverterTypeMembership.lift(it)
        }
    
    override fun `name`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Room_name_961e(it,  _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    override fun `removeTimeline`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Room_remove_timeline_28b8(it,  _status)
}
        }
    
    
    override fun `retryDecryption`(`sessionIds`: List<String>) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Room_retry_decryption_d3c(it, FfiConverterSequenceString.lower(`sessionIds`),  _status)
}
        }
    
    
    override fun `topic`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Room_topic_cc24(it,  _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    

    
}

public object FfiConverterTypeRoom: FfiConverter<Room, Pointer> {
    override fun lower(value: Room): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): Room {
        return Room(value)
    }

    override fun read(buf: ByteBuffer): Room {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Room) = 8

    override fun write(value: Room, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface RoomMemberInterface {
    
    fun `avatarUrl`(): String?
    fun `displayName`(): String?@Throws(ClientException::class)
    fun `ignore`()
    fun `isAccountUser`(): Boolean
    fun `isIgnored`(): Boolean
    fun `isNameAmbiguous`(): Boolean
    fun `membership`(): MembershipState
    fun `normalizedPowerLevel`(): Long
    fun `powerLevel`(): Long@Throws(ClientException::class)
    fun `unignore`()
    fun `userId`(): String
}

class RoomMember(
    pointer: Pointer
) : FFIObject(pointer), RoomMemberInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_RoomMember_object_free(this.pointer, status)
        }
    }

    override fun `avatarUrl`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_RoomMember_avatar_url_4027(it,  _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    override fun `displayName`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_RoomMember_display_name_a28c(it,  _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `ignore`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_RoomMember_ignore_5349(it,  _status)
}
        }
    
    
    override fun `isAccountUser`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_RoomMember_is_account_user_22e7(it,  _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isIgnored`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_RoomMember_is_ignored_e9ed(it,  _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isNameAmbiguous`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_RoomMember_is_name_ambiguous_4eb9(it,  _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `membership`(): MembershipState =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_RoomMember_membership_8b7e(it,  _status)
}
        }.let {
            FfiConverterTypeMembershipState.lift(it)
        }
    
    override fun `normalizedPowerLevel`(): Long =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_RoomMember_normalized_power_level_c46(it,  _status)
}
        }.let {
            FfiConverterLong.lift(it)
        }
    
    override fun `powerLevel`(): Long =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_RoomMember_power_level_e051(it,  _status)
}
        }.let {
            FfiConverterLong.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `unignore`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_RoomMember_unignore_9d34(it,  _status)
}
        }
    
    
    override fun `userId`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_RoomMember_user_id_c970(it,  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
}

public object FfiConverterTypeRoomMember: FfiConverter<RoomMember, Pointer> {
    override fun lower(value: RoomMember): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): RoomMember {
        return RoomMember(value)
    }

    override fun read(buf: ByteBuffer): RoomMember {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomMember) = 8

    override fun write(value: RoomMember, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface RoomMessageEventContentInterface {
    
}

class RoomMessageEventContent(
    pointer: Pointer
) : FFIObject(pointer), RoomMessageEventContentInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_RoomMessageEventContent_object_free(this.pointer, status)
        }
    }

    

    
}

public object FfiConverterTypeRoomMessageEventContent: FfiConverter<RoomMessageEventContent, Pointer> {
    override fun lower(value: RoomMessageEventContent): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): RoomMessageEventContent {
        return RoomMessageEventContent(value)
    }

    override fun read(buf: ByteBuffer): RoomMessageEventContent {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomMessageEventContent) = 8

    override fun write(value: RoomMessageEventContent, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface SessionVerificationControllerInterface {
    
    fun `setDelegate`(`delegate`: SessionVerificationControllerDelegate?)@Throws(ClientException::class)
    fun `requestVerification`()@Throws(ClientException::class)
    fun `startSasVerification`()@Throws(ClientException::class)
    fun `approveVerification`()@Throws(ClientException::class)
    fun `declineVerification`()@Throws(ClientException::class)
    fun `cancelVerification`()
    fun `isVerified`(): Boolean
}

class SessionVerificationController(
    pointer: Pointer
) : FFIObject(pointer), SessionVerificationControllerInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_SessionVerificationController_object_free(this.pointer, status)
        }
    }

    override fun `setDelegate`(`delegate`: SessionVerificationControllerDelegate?) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SessionVerificationController_set_delegate(it, FfiConverterOptionalTypeSessionVerificationControllerDelegate.lower(`delegate`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `requestVerification`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SessionVerificationController_request_verification(it,  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `startSasVerification`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SessionVerificationController_start_sas_verification(it,  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `approveVerification`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SessionVerificationController_approve_verification(it,  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `declineVerification`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SessionVerificationController_decline_verification(it,  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `cancelVerification`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SessionVerificationController_cancel_verification(it,  _status)
}
        }
    
    
    override fun `isVerified`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SessionVerificationController_is_verified_e7e9(it,  _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    

    
}

public object FfiConverterTypeSessionVerificationController: FfiConverter<SessionVerificationController, Pointer> {
    override fun lower(value: SessionVerificationController): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): SessionVerificationController {
        return SessionVerificationController(value)
    }

    override fun read(buf: ByteBuffer): SessionVerificationController {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SessionVerificationController) = 8

    override fun write(value: SessionVerificationController, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface SessionVerificationEmojiInterface {
    
    fun `description`(): String
    fun `symbol`(): String
}

class SessionVerificationEmoji(
    pointer: Pointer
) : FFIObject(pointer), SessionVerificationEmojiInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_SessionVerificationEmoji_object_free(this.pointer, status)
        }
    }

    override fun `description`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SessionVerificationEmoji_description_955f(it,  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `symbol`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SessionVerificationEmoji_symbol_89f7(it,  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
}

public object FfiConverterTypeSessionVerificationEmoji: FfiConverter<SessionVerificationEmoji, Pointer> {
    override fun lower(value: SessionVerificationEmoji): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): SessionVerificationEmoji {
        return SessionVerificationEmoji(value)
    }

    override fun read(buf: ByteBuffer): SessionVerificationEmoji {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SessionVerificationEmoji) = 8

    override fun write(value: SessionVerificationEmoji, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface SlidingSyncInterface {
    
    fun `setObserver`(`observer`: SlidingSyncObserver?)@Throws(ClientException::class)
    fun `subscribe`(`roomId`: String, `settings`: RoomSubscription?)@Throws(ClientException::class)
    fun `unsubscribe`(`roomId`: String)@Throws(ClientException::class)
    fun `getRoom`(`roomId`: String): SlidingSyncRoom?@Throws(ClientException::class)
    fun `getRooms`(`roomIds`: List<String>): List<SlidingSyncRoom?>
    fun `addCommonExtensions`()
    fun `addList`(`list`: SlidingSyncList): SlidingSyncList?
    fun `getList`(`name`: String): SlidingSyncList?
    fun `popList`(`name`: String): SlidingSyncList?
    fun `resetLists`()
    fun `sync`(): TaskHandle
}

class SlidingSync(
    pointer: Pointer
) : FFIObject(pointer), SlidingSyncInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_SlidingSync_object_free(this.pointer, status)
        }
    }

    override fun `setObserver`(`observer`: SlidingSyncObserver?) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SlidingSync_set_observer(it, FfiConverterOptionalTypeSlidingSyncObserver.lower(`observer`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `subscribe`(`roomId`: String, `settings`: RoomSubscription?) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SlidingSync_subscribe(it, FfiConverterString.lower(`roomId`), FfiConverterOptionalTypeRoomSubscription.lower(`settings`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `unsubscribe`(`roomId`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SlidingSync_unsubscribe(it, FfiConverterString.lower(`roomId`),  _status)
}
        }
    
    
    
        @Throws(ClientException::class)override fun `getRoom`(`roomId`: String): SlidingSyncRoom? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SlidingSync_get_room(it, FfiConverterString.lower(`roomId`),  _status)
}
        }.let {
            FfiConverterOptionalTypeSlidingSyncRoom.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `getRooms`(`roomIds`: List<String>): List<SlidingSyncRoom?> =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SlidingSync_get_rooms(it, FfiConverterSequenceString.lower(`roomIds`),  _status)
}
        }.let {
            FfiConverterSequenceOptionalTypeSlidingSyncRoom.lift(it)
        }
    
    override fun `addCommonExtensions`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSync_add_common_extensions_6d8e(it,  _status)
}
        }
    
    
    override fun `addList`(`list`: SlidingSyncList): SlidingSyncList? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSync_add_list_691f(it, FfiConverterTypeSlidingSyncList.lower(`list`),  _status)
}
        }.let {
            FfiConverterOptionalTypeSlidingSyncList.lift(it)
        }
    
    override fun `getList`(`name`: String): SlidingSyncList? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSync_get_list_535c(it, FfiConverterString.lower(`name`),  _status)
}
        }.let {
            FfiConverterOptionalTypeSlidingSyncList.lift(it)
        }
    
    override fun `popList`(`name`: String): SlidingSyncList? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSync_pop_list_c712(it, FfiConverterString.lower(`name`),  _status)
}
        }.let {
            FfiConverterOptionalTypeSlidingSyncList.lift(it)
        }
    
    override fun `resetLists`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSync_reset_lists_4375(it,  _status)
}
        }
    
    
    override fun `sync`(): TaskHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSync_sync_4bb(it,  _status)
}
        }.let {
            FfiConverterTypeTaskHandle.lift(it)
        }
    
    

    
}

public object FfiConverterTypeSlidingSync: FfiConverter<SlidingSync, Pointer> {
    override fun lower(value: SlidingSync): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): SlidingSync {
        return SlidingSync(value)
    }

    override fun read(buf: ByteBuffer): SlidingSync {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SlidingSync) = 8

    override fun write(value: SlidingSync, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface SlidingSyncBuilderInterface {
    @Throws(ClientException::class)
    fun `homeserver`(`url`: String): SlidingSyncBuilder@Throws(ClientException::class)
    fun `build`(): SlidingSync
    fun `addList`(`v`: SlidingSyncList): SlidingSyncBuilder
    fun `storageKey`(`name`: String?): SlidingSyncBuilder
    fun `withAllExtensions`(): SlidingSyncBuilder
    fun `withCommonExtensions`(): SlidingSyncBuilder
    fun `withoutAccountDataExtension`(): SlidingSyncBuilder
    fun `withoutE2eeExtension`(): SlidingSyncBuilder
    fun `withoutReceiptExtension`(): SlidingSyncBuilder
    fun `withoutToDeviceExtension`(): SlidingSyncBuilder
    fun `withoutTypingExtension`(): SlidingSyncBuilder
}

class SlidingSyncBuilder(
    pointer: Pointer
) : FFIObject(pointer), SlidingSyncBuilderInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_SlidingSyncBuilder_object_free(this.pointer, status)
        }
    }

    
        @Throws(ClientException::class)override fun `homeserver`(`url`: String): SlidingSyncBuilder =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SlidingSyncBuilder_homeserver(it, FfiConverterString.lower(`url`),  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncBuilder.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `build`(): SlidingSync =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SlidingSyncBuilder_build(it,  _status)
}
        }.let {
            FfiConverterTypeSlidingSync.lift(it)
        }
    
    override fun `addList`(`v`: SlidingSyncList): SlidingSyncBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncBuilder_add_list_2044(it, FfiConverterTypeSlidingSyncList.lower(`v`),  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncBuilder.lift(it)
        }
    
    override fun `storageKey`(`name`: String?): SlidingSyncBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncBuilder_storage_key_224b(it, FfiConverterOptionalString.lower(`name`),  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncBuilder.lift(it)
        }
    
    override fun `withAllExtensions`(): SlidingSyncBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncBuilder_with_all_extensions_7e0f(it,  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncBuilder.lift(it)
        }
    
    override fun `withCommonExtensions`(): SlidingSyncBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncBuilder_with_common_extensions_e90d(it,  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncBuilder.lift(it)
        }
    
    override fun `withoutAccountDataExtension`(): SlidingSyncBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncBuilder_without_account_data_extension_d3f5(it,  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncBuilder.lift(it)
        }
    
    override fun `withoutE2eeExtension`(): SlidingSyncBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncBuilder_without_e2ee_extension_bc03(it,  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncBuilder.lift(it)
        }
    
    override fun `withoutReceiptExtension`(): SlidingSyncBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncBuilder_without_receipt_extension_ea21(it,  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncBuilder.lift(it)
        }
    
    override fun `withoutToDeviceExtension`(): SlidingSyncBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncBuilder_without_to_device_extension_2502(it,  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncBuilder.lift(it)
        }
    
    override fun `withoutTypingExtension`(): SlidingSyncBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncBuilder_without_typing_extension_96fe(it,  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncBuilder.lift(it)
        }
    
    

    
}

public object FfiConverterTypeSlidingSyncBuilder: FfiConverter<SlidingSyncBuilder, Pointer> {
    override fun lower(value: SlidingSyncBuilder): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): SlidingSyncBuilder {
        return SlidingSyncBuilder(value)
    }

    override fun read(buf: ByteBuffer): SlidingSyncBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SlidingSyncBuilder) = 8

    override fun write(value: SlidingSyncBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface SlidingSyncListInterface {
    
    fun `observeRoomList`(`observer`: SlidingSyncListRoomListObserver): TaskHandle
    fun `observeRoomsCount`(`observer`: SlidingSyncListRoomsCountObserver): TaskHandle
    fun `observeState`(`observer`: SlidingSyncListStateObserver): TaskHandle@Throws(SlidingSyncException::class)
    fun `addRange`(`start`: UInt, `end`: UInt)
    fun `currentRoomCount`(): UInt?
    fun `currentRoomList`(): List<RoomListEntry>
    fun `getTimelineLimit`(): UInt?@Throws(SlidingSyncException::class)
    fun `resetRanges`()@Throws(SlidingSyncException::class)
    fun `setRange`(`start`: UInt, `end`: UInt)
    fun `setTimelineLimit`(`value`: UInt)
    fun `unsetTimelineLimit`()
}

class SlidingSyncList(
    pointer: Pointer
) : FFIObject(pointer), SlidingSyncListInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_SlidingSyncList_object_free(this.pointer, status)
        }
    }

    override fun `observeRoomList`(`observer`: SlidingSyncListRoomListObserver): TaskHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SlidingSyncList_observe_room_list(it, FfiConverterTypeSlidingSyncListRoomListObserver.lower(`observer`),  _status)
}
        }.let {
            FfiConverterTypeTaskHandle.lift(it)
        }
    
    override fun `observeRoomsCount`(`observer`: SlidingSyncListRoomsCountObserver): TaskHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SlidingSyncList_observe_rooms_count(it, FfiConverterTypeSlidingSyncListRoomsCountObserver.lower(`observer`),  _status)
}
        }.let {
            FfiConverterTypeTaskHandle.lift(it)
        }
    
    override fun `observeState`(`observer`: SlidingSyncListStateObserver): TaskHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SlidingSyncList_observe_state(it, FfiConverterTypeSlidingSyncListStateObserver.lower(`observer`),  _status)
}
        }.let {
            FfiConverterTypeTaskHandle.lift(it)
        }
    
    
        @Throws(SlidingSyncException::class)override fun `addRange`(`start`: UInt, `end`: UInt) =
        callWithPointer {
    rustCallWithError(SlidingSyncException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncList_add_range_78e2(it, FfiConverterUInt.lower(`start`), FfiConverterUInt.lower(`end`),  _status)
}
        }
    
    
    override fun `currentRoomCount`(): UInt? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncList_current_room_count_8e0(it,  _status)
}
        }.let {
            FfiConverterOptionalUInt.lift(it)
        }
    
    override fun `currentRoomList`(): List<RoomListEntry> =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncList_current_room_list_34df(it,  _status)
}
        }.let {
            FfiConverterSequenceTypeRoomListEntry.lift(it)
        }
    
    override fun `getTimelineLimit`(): UInt? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncList_get_timeline_limit_486f(it,  _status)
}
        }.let {
            FfiConverterOptionalUInt.lift(it)
        }
    
    
        @Throws(SlidingSyncException::class)override fun `resetRanges`() =
        callWithPointer {
    rustCallWithError(SlidingSyncException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncList_reset_ranges_7aea(it,  _status)
}
        }
    
    
    
        @Throws(SlidingSyncException::class)override fun `setRange`(`start`: UInt, `end`: UInt) =
        callWithPointer {
    rustCallWithError(SlidingSyncException) { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncList_set_range_d537(it, FfiConverterUInt.lower(`start`), FfiConverterUInt.lower(`end`),  _status)
}
        }
    
    
    override fun `setTimelineLimit`(`value`: UInt) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncList_set_timeline_limit_17e1(it, FfiConverterUInt.lower(`value`),  _status)
}
        }
    
    
    override fun `unsetTimelineLimit`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncList_unset_timeline_limit_336e(it,  _status)
}
        }
    
    
    

    
}

public object FfiConverterTypeSlidingSyncList: FfiConverter<SlidingSyncList, Pointer> {
    override fun lower(value: SlidingSyncList): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): SlidingSyncList {
        return SlidingSyncList(value)
    }

    override fun read(buf: ByteBuffer): SlidingSyncList {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SlidingSyncList) = 8

    override fun write(value: SlidingSyncList, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface SlidingSyncListBuilderInterface {
    
    fun `syncMode`(`mode`: SlidingSyncMode): SlidingSyncListBuilder@Throws(ClientException::class)
    fun `build`(): SlidingSyncList
    fun `addRange`(`from`: UInt, `to`: UInt): SlidingSyncListBuilder
    fun `batchSize`(`batchSize`: UInt): SlidingSyncListBuilder
    fun `filters`(`filters`: SlidingSyncRequestListFilters): SlidingSyncListBuilder
    fun `name`(`name`: String): SlidingSyncListBuilder
    fun `noFilters`(): SlidingSyncListBuilder
    fun `noRoomLimit`(): SlidingSyncListBuilder
    fun `noTimelineLimit`(): SlidingSyncListBuilder
    fun `requiredState`(`requiredState`: List<RequiredState>): SlidingSyncListBuilder
    fun `resetRanges`(): SlidingSyncListBuilder
    fun `roomLimit`(`limit`: UInt): SlidingSyncListBuilder
    fun `sort`(`sort`: List<String>): SlidingSyncListBuilder
    fun `timelineLimit`(`limit`: UInt): SlidingSyncListBuilder
}

class SlidingSyncListBuilder(
    pointer: Pointer
) : FFIObject(pointer), SlidingSyncListBuilderInterface {
    constructor() :
        this(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SlidingSyncListBuilder_new( _status)
})

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_SlidingSyncListBuilder_object_free(this.pointer, status)
        }
    }

    override fun `syncMode`(`mode`: SlidingSyncMode): SlidingSyncListBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SlidingSyncListBuilder_sync_mode(it, FfiConverterTypeSlidingSyncMode.lower(`mode`),  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncListBuilder.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `build`(): SlidingSyncList =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SlidingSyncListBuilder_build(it,  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncList.lift(it)
        }
    
    override fun `addRange`(`from`: UInt, `to`: UInt): SlidingSyncListBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_add_range_2f2d(it, FfiConverterUInt.lower(`from`), FfiConverterUInt.lower(`to`),  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncListBuilder.lift(it)
        }
    
    override fun `batchSize`(`batchSize`: UInt): SlidingSyncListBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_batch_size_2b78(it, FfiConverterUInt.lower(`batchSize`),  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncListBuilder.lift(it)
        }
    
    override fun `filters`(`filters`: SlidingSyncRequestListFilters): SlidingSyncListBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_filters_3274(it, FfiConverterTypeSlidingSyncRequestListFilters.lower(`filters`),  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncListBuilder.lift(it)
        }
    
    override fun `name`(`name`: String): SlidingSyncListBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_name_dfb(it, FfiConverterString.lower(`name`),  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncListBuilder.lift(it)
        }
    
    override fun `noFilters`(): SlidingSyncListBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_no_filters_3d7b(it,  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncListBuilder.lift(it)
        }
    
    override fun `noRoomLimit`(): SlidingSyncListBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_no_room_limit_9ab4(it,  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncListBuilder.lift(it)
        }
    
    override fun `noTimelineLimit`(): SlidingSyncListBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_no_timeline_limit_1d0d(it,  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncListBuilder.lift(it)
        }
    
    override fun `requiredState`(`requiredState`: List<RequiredState>): SlidingSyncListBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_required_state_827b(it, FfiConverterSequenceTypeRequiredState.lower(`requiredState`),  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncListBuilder.lift(it)
        }
    
    override fun `resetRanges`(): SlidingSyncListBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_reset_ranges_5b71(it,  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncListBuilder.lift(it)
        }
    
    override fun `roomLimit`(`limit`: UInt): SlidingSyncListBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_room_limit_d39c(it, FfiConverterUInt.lower(`limit`),  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncListBuilder.lift(it)
        }
    
    override fun `sort`(`sort`: List<String>): SlidingSyncListBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_sort_1272(it, FfiConverterSequenceString.lower(`sort`),  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncListBuilder.lift(it)
        }
    
    override fun `timelineLimit`(`limit`: UInt): SlidingSyncListBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncListBuilder_timeline_limit_554d(it, FfiConverterUInt.lower(`limit`),  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncListBuilder.lift(it)
        }
    
    

    
}

public object FfiConverterTypeSlidingSyncListBuilder: FfiConverter<SlidingSyncListBuilder, Pointer> {
    override fun lower(value: SlidingSyncListBuilder): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): SlidingSyncListBuilder {
        return SlidingSyncListBuilder(value)
    }

    override fun read(buf: ByteBuffer): SlidingSyncListBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SlidingSyncListBuilder) = 8

    override fun write(value: SlidingSyncListBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface SlidingSyncRoomInterface {
    @Throws(ClientException::class)
    fun `subscribeAndAddTimelineListener`(`listener`: TimelineListener, `settings`: RoomSubscription?): SlidingSyncSubscribeResult@Throws(ClientException::class)
    fun `addTimelineListener`(`listener`: TimelineListener): SlidingSyncSubscribeResult
    fun `avatarUrl`(): String?
    fun `fullRoom`(): Room?
    fun `hasUnreadNotifications`(): Boolean
    fun `isDm`(): Boolean?
    fun `isInitial`(): Boolean?
    fun `isLoadingMore`(): Boolean
    fun `latestRoomMessage`(): EventTimelineItem?
    fun `name`(): String?
    fun `roomId`(): String
    fun `unreadNotifications`(): UnreadNotificationsCount
}

class SlidingSyncRoom(
    pointer: Pointer
) : FFIObject(pointer), SlidingSyncRoomInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_SlidingSyncRoom_object_free(this.pointer, status)
        }
    }

    
        @Throws(ClientException::class)override fun `subscribeAndAddTimelineListener`(`listener`: TimelineListener, `settings`: RoomSubscription?): SlidingSyncSubscribeResult =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SlidingSyncRoom_subscribe_and_add_timeline_listener(it, FfiConverterTypeTimelineListener.lower(`listener`), FfiConverterOptionalTypeRoomSubscription.lower(`settings`),  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncSubscribeResult.lift(it)
        }
    
    
        @Throws(ClientException::class)override fun `addTimelineListener`(`listener`: TimelineListener): SlidingSyncSubscribeResult =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_SlidingSyncRoom_add_timeline_listener(it, FfiConverterTypeTimelineListener.lower(`listener`),  _status)
}
        }.let {
            FfiConverterTypeSlidingSyncSubscribeResult.lift(it)
        }
    
    override fun `avatarUrl`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncRoom_avatar_url_5462(it,  _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    override fun `fullRoom`(): Room? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncRoom_full_room_6ee7(it,  _status)
}
        }.let {
            FfiConverterOptionalTypeRoom.lift(it)
        }
    
    override fun `hasUnreadNotifications`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncRoom_has_unread_notifications_aad9(it,  _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isDm`(): Boolean? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncRoom_is_dm_8047(it,  _status)
}
        }.let {
            FfiConverterOptionalBoolean.lift(it)
        }
    
    override fun `isInitial`(): Boolean? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncRoom_is_initial_b79c(it,  _status)
}
        }.let {
            FfiConverterOptionalBoolean.lift(it)
        }
    
    override fun `isLoadingMore`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncRoom_is_loading_more_98c9(it,  _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `latestRoomMessage`(): EventTimelineItem? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncRoom_latest_room_message_d69d(it,  _status)
}
        }.let {
            FfiConverterOptionalTypeEventTimelineItem.lift(it)
        }
    
    override fun `name`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncRoom_name_6a4c(it,  _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    override fun `roomId`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncRoom_room_id_a4da(it,  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `unreadNotifications`(): UnreadNotificationsCount =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_SlidingSyncRoom_unread_notifications_4c16(it,  _status)
}
        }.let {
            FfiConverterTypeUnreadNotificationsCount.lift(it)
        }
    
    

    
}

public object FfiConverterTypeSlidingSyncRoom: FfiConverter<SlidingSyncRoom, Pointer> {
    override fun lower(value: SlidingSyncRoom): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): SlidingSyncRoom {
        return SlidingSyncRoom(value)
    }

    override fun read(buf: ByteBuffer): SlidingSyncRoom {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SlidingSyncRoom) = 8

    override fun write(value: SlidingSyncRoom, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface SpanInterface {
    
    fun `enter`()
    fun `exit`()
    fun `isNone`(): Boolean
}

class Span(
    pointer: Pointer
) : FFIObject(pointer), SpanInterface {
    constructor(`file`: String, `line`: UInt, `column`: UInt, `level`: LogLevel, `target`: String, `name`: String) :
        this(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Span_new(FfiConverterString.lower(`file`), FfiConverterUInt.lower(`line`), FfiConverterUInt.lower(`column`), FfiConverterTypeLogLevel.lower(`level`), FfiConverterString.lower(`target`), FfiConverterString.lower(`name`), _status)
})

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_Span_object_free(this.pointer, status)
        }
    }

    override fun `enter`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Span_enter_5cf(it,  _status)
}
        }
    
    
    override fun `exit`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Span_exit_cea8(it,  _status)
}
        }
    
    
    override fun `isNone`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_Span_is_none_e9e0(it,  _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    

    companion object {
        fun `current`(): Span =
            Span(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.matrix_sdk_ffi_a64_Span_current( _status)
})
        
    }
    
}

public object FfiConverterTypeSpan: FfiConverter<Span, Pointer> {
    override fun lower(value: Span): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): Span {
        return Span(value)
    }

    override fun read(buf: ByteBuffer): Span {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Span) = 8

    override fun write(value: Span, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface TaskHandleInterface {
    
    fun `cancel`()
    fun `isFinished`(): Boolean
}

class TaskHandle(
    pointer: Pointer
) : FFIObject(pointer), TaskHandleInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_TaskHandle_object_free(this.pointer, status)
        }
    }

    override fun `cancel`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_TaskHandle_cancel_a65c(it,  _status)
}
        }
    
    
    override fun `isFinished`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_TaskHandle_is_finished_56b2(it,  _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    

    
}

public object FfiConverterTypeTaskHandle: FfiConverter<TaskHandle, Pointer> {
    override fun lower(value: TaskHandle): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): TaskHandle {
        return TaskHandle(value)
    }

    override fun read(buf: ByteBuffer): TaskHandle {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: TaskHandle) = 8

    override fun write(value: TaskHandle, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface TimelineDiffInterface {
    
    fun `append`(): List<TimelineItem>?
    fun `change`(): TimelineChange
    fun `insert`(): InsertData?
    fun `pushBack`(): TimelineItem?
    fun `pushFront`(): TimelineItem?
    fun `remove`(): UInt?
    fun `reset`(): List<TimelineItem>?
    fun `set`(): SetData?
}

class TimelineDiff(
    pointer: Pointer
) : FFIObject(pointer), TimelineDiffInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_TimelineDiff_object_free(this.pointer, status)
        }
    }

    override fun `append`(): List<TimelineItem>? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_TimelineDiff_append_c24b(it,  _status)
}
        }.let {
            FfiConverterOptionalSequenceTypeTimelineItem.lift(it)
        }
    
    override fun `change`(): TimelineChange =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_TimelineDiff_change_6a6d(it,  _status)
}
        }.let {
            FfiConverterTypeTimelineChange.lift(it)
        }
    
    override fun `insert`(): InsertData? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_TimelineDiff_insert_b007(it,  _status)
}
        }.let {
            FfiConverterOptionalTypeInsertData.lift(it)
        }
    
    override fun `pushBack`(): TimelineItem? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_TimelineDiff_push_back_3aff(it,  _status)
}
        }.let {
            FfiConverterOptionalTypeTimelineItem.lift(it)
        }
    
    override fun `pushFront`(): TimelineItem? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_TimelineDiff_push_front_96a0(it,  _status)
}
        }.let {
            FfiConverterOptionalTypeTimelineItem.lift(it)
        }
    
    override fun `remove`(): UInt? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_TimelineDiff_remove_d74f(it,  _status)
}
        }.let {
            FfiConverterOptionalUInt.lift(it)
        }
    
    override fun `reset`(): List<TimelineItem>? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_TimelineDiff_reset_6b55(it,  _status)
}
        }.let {
            FfiConverterOptionalSequenceTypeTimelineItem.lift(it)
        }
    
    override fun `set`(): SetData? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_TimelineDiff_set_3cf2(it,  _status)
}
        }.let {
            FfiConverterOptionalTypeSetData.lift(it)
        }
    
    

    
}

public object FfiConverterTypeTimelineDiff: FfiConverter<TimelineDiff, Pointer> {
    override fun lower(value: TimelineDiff): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): TimelineDiff {
        return TimelineDiff(value)
    }

    override fun read(buf: ByteBuffer): TimelineDiff {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: TimelineDiff) = 8

    override fun write(value: TimelineDiff, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface TimelineItemInterface {
    
    fun `asEvent`(): EventTimelineItem?
    fun `asVirtual`(): VirtualTimelineItem?
    fun `fmtDebug`(): String
}

class TimelineItem(
    pointer: Pointer
) : FFIObject(pointer), TimelineItemInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_a64_TimelineItem_object_free(this.pointer, status)
        }
    }

    override fun `asEvent`(): EventTimelineItem? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_TimelineItem_as_event_9e04(it,  _status)
}
        }.let {
            FfiConverterOptionalTypeEventTimelineItem.lift(it)
        }
    
    override fun `asVirtual`(): VirtualTimelineItem? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_TimelineItem_as_virtual_d72c(it,  _status)
}
        }.let {
            FfiConverterOptionalTypeVirtualTimelineItem.lift(it)
        }
    
    override fun `fmtDebug`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_TimelineItem_fmt_debug_6d42(it,  _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
}

public object FfiConverterTypeTimelineItem: FfiConverter<TimelineItem, Pointer> {
    override fun lower(value: TimelineItem): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): TimelineItem {
        return TimelineItem(value)
    }

    override fun read(buf: ByteBuffer): TimelineItem {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: TimelineItem) = 8

    override fun write(value: TimelineItem, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface TimelineItemContentInterface {
    
    fun `asMessage`(): Message?
    fun `kind`(): TimelineItemContentKind
}

class TimelineItemContent(
    pointer: Pointer
) : FFIObject(pointer), TimelineItemContentInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_object_free_TimelineItemContent_2b31(this.pointer, status)
        }
    }

    override fun `asMessage`(): Message? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_TimelineItemContent_as_message_31df(it,  _status)
}
        }.let {
            FfiConverterOptionalTypeMessage.lift(it)
        }
    
    override fun `kind`(): TimelineItemContentKind =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_TimelineItemContent_kind_4894(it,  _status)
}
        }.let {
            FfiConverterTypeTimelineItemContentKind.lift(it)
        }
    
    

    
}

public object FfiConverterTypeTimelineItemContent: FfiConverter<TimelineItemContent, Pointer> {
    override fun lower(value: TimelineItemContent): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): TimelineItemContent {
        return TimelineItemContent(value)
    }

    override fun read(buf: ByteBuffer): TimelineItemContent {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: TimelineItemContent) = 8

    override fun write(value: TimelineItemContent, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface UnreadNotificationsCountInterface {
    
    fun `hasNotifications`(): Boolean
    fun `highlightCount`(): UInt
    fun `notificationCount`(): UInt
}

class UnreadNotificationsCount(
    pointer: Pointer
) : FFIObject(pointer), UnreadNotificationsCountInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_object_free_UnreadNotificationsCount_b323(this.pointer, status)
        }
    }

    override fun `hasNotifications`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_UnreadNotificationsCount_has_notifications_72(it,  _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `highlightCount`(): UInt =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_UnreadNotificationsCount_highlight_count_41b0(it,  _status)
}
        }.let {
            FfiConverterUInt.lift(it)
        }
    
    override fun `notificationCount`(): UInt =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_impl_UnreadNotificationsCount_notification_count_1e7d(it,  _status)
}
        }.let {
            FfiConverterUInt.lift(it)
        }
    
    

    
}

public object FfiConverterTypeUnreadNotificationsCount: FfiConverter<UnreadNotificationsCount, Pointer> {
    override fun lower(value: UnreadNotificationsCount): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): UnreadNotificationsCount {
        return UnreadNotificationsCount(value)
    }

    override fun read(buf: ByteBuffer): UnreadNotificationsCount {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: UnreadNotificationsCount) = 8

    override fun write(value: UnreadNotificationsCount, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




data class AudioInfo (
    var `duration`: ULong?, 
    var `size`: ULong?, 
    var `mimetype`: String?
) {
    
}

public object FfiConverterTypeAudioInfo: FfiConverterRustBuffer<AudioInfo> {
    override fun read(buf: ByteBuffer): AudioInfo {
        return AudioInfo(
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: AudioInfo) = (
            FfiConverterOptionalULong.allocationSize(value.`duration`) +
            FfiConverterOptionalULong.allocationSize(value.`size`) +
            FfiConverterOptionalString.allocationSize(value.`mimetype`)
    )

    override fun write(value: AudioInfo, buf: ByteBuffer) {
            FfiConverterOptionalULong.write(value.`duration`, buf)
            FfiConverterOptionalULong.write(value.`size`, buf)
            FfiConverterOptionalString.write(value.`mimetype`, buf)
    }
}




data class AudioMessageContent (
    var `body`: String, 
    var `source`: MediaSource, 
    var `info`: AudioInfo?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`body`, 
        this.`source`, 
        this.`info`)
    }
    
}

public object FfiConverterTypeAudioMessageContent: FfiConverterRustBuffer<AudioMessageContent> {
    override fun read(buf: ByteBuffer): AudioMessageContent {
        return AudioMessageContent(
            FfiConverterString.read(buf),
            FfiConverterTypeMediaSource.read(buf),
            FfiConverterOptionalTypeAudioInfo.read(buf),
        )
    }

    override fun allocationSize(value: AudioMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterTypeMediaSource.allocationSize(value.`source`) +
            FfiConverterOptionalTypeAudioInfo.allocationSize(value.`info`)
    )

    override fun write(value: AudioMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterTypeMediaSource.write(value.`source`, buf)
            FfiConverterOptionalTypeAudioInfo.write(value.`info`, buf)
    }
}




data class CreateRoomParameters (
    var `name`: String?, 
    var `topic`: String? = null, 
    var `isEncrypted`: Boolean, 
    var `isDirect`: Boolean = false, 
    var `visibility`: RoomVisibility, 
    var `preset`: RoomPreset, 
    var `invite`: List<String>? = null, 
    var `avatar`: String? = null
) {
    
}

public object FfiConverterTypeCreateRoomParameters: FfiConverterRustBuffer<CreateRoomParameters> {
    override fun read(buf: ByteBuffer): CreateRoomParameters {
        return CreateRoomParameters(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterTypeRoomVisibility.read(buf),
            FfiConverterTypeRoomPreset.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: CreateRoomParameters) = (
            FfiConverterOptionalString.allocationSize(value.`name`) +
            FfiConverterOptionalString.allocationSize(value.`topic`) +
            FfiConverterBoolean.allocationSize(value.`isEncrypted`) +
            FfiConverterBoolean.allocationSize(value.`isDirect`) +
            FfiConverterTypeRoomVisibility.allocationSize(value.`visibility`) +
            FfiConverterTypeRoomPreset.allocationSize(value.`preset`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`invite`) +
            FfiConverterOptionalString.allocationSize(value.`avatar`)
    )

    override fun write(value: CreateRoomParameters, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`name`, buf)
            FfiConverterOptionalString.write(value.`topic`, buf)
            FfiConverterBoolean.write(value.`isEncrypted`, buf)
            FfiConverterBoolean.write(value.`isDirect`, buf)
            FfiConverterTypeRoomVisibility.write(value.`visibility`, buf)
            FfiConverterTypeRoomPreset.write(value.`preset`, buf)
            FfiConverterOptionalSequenceString.write(value.`invite`, buf)
            FfiConverterOptionalString.write(value.`avatar`, buf)
    }
}




data class EmoteMessageContent (
    var `body`: String, 
    var `formatted`: FormattedBody?
) {
    
}

public object FfiConverterTypeEmoteMessageContent: FfiConverterRustBuffer<EmoteMessageContent> {
    override fun read(buf: ByteBuffer): EmoteMessageContent {
        return EmoteMessageContent(
            FfiConverterString.read(buf),
            FfiConverterOptionalTypeFormattedBody.read(buf),
        )
    }

    override fun allocationSize(value: EmoteMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterOptionalTypeFormattedBody.allocationSize(value.`formatted`)
    )

    override fun write(value: EmoteMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterOptionalTypeFormattedBody.write(value.`formatted`, buf)
    }
}




data class EventTimelineItemDebugInfo (
    var `model`: String, 
    var `originalJson`: String?, 
    var `latestEditJson`: String?
) {
    
}

public object FfiConverterTypeEventTimelineItemDebugInfo: FfiConverterRustBuffer<EventTimelineItemDebugInfo> {
    override fun read(buf: ByteBuffer): EventTimelineItemDebugInfo {
        return EventTimelineItemDebugInfo(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: EventTimelineItemDebugInfo) = (
            FfiConverterString.allocationSize(value.`model`) +
            FfiConverterOptionalString.allocationSize(value.`originalJson`) +
            FfiConverterOptionalString.allocationSize(value.`latestEditJson`)
    )

    override fun write(value: EventTimelineItemDebugInfo, buf: ByteBuffer) {
            FfiConverterString.write(value.`model`, buf)
            FfiConverterOptionalString.write(value.`originalJson`, buf)
            FfiConverterOptionalString.write(value.`latestEditJson`, buf)
    }
}




data class FileInfo (
    var `mimetype`: String?, 
    var `size`: ULong?, 
    var `thumbnailInfo`: ThumbnailInfo?, 
    var `thumbnailSource`: MediaSource?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`mimetype`, 
        this.`size`, 
        this.`thumbnailInfo`, 
        this.`thumbnailSource`)
    }
    
}

public object FfiConverterTypeFileInfo: FfiConverterRustBuffer<FileInfo> {
    override fun read(buf: ByteBuffer): FileInfo {
        return FileInfo(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalTypeThumbnailInfo.read(buf),
            FfiConverterOptionalTypeMediaSource.read(buf),
        )
    }

    override fun allocationSize(value: FileInfo) = (
            FfiConverterOptionalString.allocationSize(value.`mimetype`) +
            FfiConverterOptionalULong.allocationSize(value.`size`) +
            FfiConverterOptionalTypeThumbnailInfo.allocationSize(value.`thumbnailInfo`) +
            FfiConverterOptionalTypeMediaSource.allocationSize(value.`thumbnailSource`)
    )

    override fun write(value: FileInfo, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`mimetype`, buf)
            FfiConverterOptionalULong.write(value.`size`, buf)
            FfiConverterOptionalTypeThumbnailInfo.write(value.`thumbnailInfo`, buf)
            FfiConverterOptionalTypeMediaSource.write(value.`thumbnailSource`, buf)
    }
}




data class FileMessageContent (
    var `body`: String, 
    var `source`: MediaSource, 
    var `info`: FileInfo?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`body`, 
        this.`source`, 
        this.`info`)
    }
    
}

public object FfiConverterTypeFileMessageContent: FfiConverterRustBuffer<FileMessageContent> {
    override fun read(buf: ByteBuffer): FileMessageContent {
        return FileMessageContent(
            FfiConverterString.read(buf),
            FfiConverterTypeMediaSource.read(buf),
            FfiConverterOptionalTypeFileInfo.read(buf),
        )
    }

    override fun allocationSize(value: FileMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterTypeMediaSource.allocationSize(value.`source`) +
            FfiConverterOptionalTypeFileInfo.allocationSize(value.`info`)
    )

    override fun write(value: FileMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterTypeMediaSource.write(value.`source`, buf)
            FfiConverterOptionalTypeFileInfo.write(value.`info`, buf)
    }
}




data class FormattedBody (
    var `format`: MessageFormat, 
    var `body`: String
) {
    
}

public object FfiConverterTypeFormattedBody: FfiConverterRustBuffer<FormattedBody> {
    override fun read(buf: ByteBuffer): FormattedBody {
        return FormattedBody(
            FfiConverterTypeMessageFormat.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: FormattedBody) = (
            FfiConverterTypeMessageFormat.allocationSize(value.`format`) +
            FfiConverterString.allocationSize(value.`body`)
    )

    override fun write(value: FormattedBody, buf: ByteBuffer) {
            FfiConverterTypeMessageFormat.write(value.`format`, buf)
            FfiConverterString.write(value.`body`, buf)
    }
}




data class HttpPusherData (
    var `url`: String, 
    var `format`: PushFormat?, 
    var `defaultPayload`: String?
) {
    
}

public object FfiConverterTypeHttpPusherData: FfiConverterRustBuffer<HttpPusherData> {
    override fun read(buf: ByteBuffer): HttpPusherData {
        return HttpPusherData(
            FfiConverterString.read(buf),
            FfiConverterOptionalTypePushFormat.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: HttpPusherData) = (
            FfiConverterString.allocationSize(value.`url`) +
            FfiConverterOptionalTypePushFormat.allocationSize(value.`format`) +
            FfiConverterOptionalString.allocationSize(value.`defaultPayload`)
    )

    override fun write(value: HttpPusherData, buf: ByteBuffer) {
            FfiConverterString.write(value.`url`, buf)
            FfiConverterOptionalTypePushFormat.write(value.`format`, buf)
            FfiConverterOptionalString.write(value.`defaultPayload`, buf)
    }
}




data class ImageInfo (
    var `height`: ULong?, 
    var `width`: ULong?, 
    var `mimetype`: String?, 
    var `size`: ULong?, 
    var `thumbnailInfo`: ThumbnailInfo?, 
    var `thumbnailSource`: MediaSource?, 
    var `blurhash`: String?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`height`, 
        this.`width`, 
        this.`mimetype`, 
        this.`size`, 
        this.`thumbnailInfo`, 
        this.`thumbnailSource`, 
        this.`blurhash`)
    }
    
}

public object FfiConverterTypeImageInfo: FfiConverterRustBuffer<ImageInfo> {
    override fun read(buf: ByteBuffer): ImageInfo {
        return ImageInfo(
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalTypeThumbnailInfo.read(buf),
            FfiConverterOptionalTypeMediaSource.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: ImageInfo) = (
            FfiConverterOptionalULong.allocationSize(value.`height`) +
            FfiConverterOptionalULong.allocationSize(value.`width`) +
            FfiConverterOptionalString.allocationSize(value.`mimetype`) +
            FfiConverterOptionalULong.allocationSize(value.`size`) +
            FfiConverterOptionalTypeThumbnailInfo.allocationSize(value.`thumbnailInfo`) +
            FfiConverterOptionalTypeMediaSource.allocationSize(value.`thumbnailSource`) +
            FfiConverterOptionalString.allocationSize(value.`blurhash`)
    )

    override fun write(value: ImageInfo, buf: ByteBuffer) {
            FfiConverterOptionalULong.write(value.`height`, buf)
            FfiConverterOptionalULong.write(value.`width`, buf)
            FfiConverterOptionalString.write(value.`mimetype`, buf)
            FfiConverterOptionalULong.write(value.`size`, buf)
            FfiConverterOptionalTypeThumbnailInfo.write(value.`thumbnailInfo`, buf)
            FfiConverterOptionalTypeMediaSource.write(value.`thumbnailSource`, buf)
            FfiConverterOptionalString.write(value.`blurhash`, buf)
    }
}




data class ImageMessageContent (
    var `body`: String, 
    var `source`: MediaSource, 
    var `info`: ImageInfo?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`body`, 
        this.`source`, 
        this.`info`)
    }
    
}

public object FfiConverterTypeImageMessageContent: FfiConverterRustBuffer<ImageMessageContent> {
    override fun read(buf: ByteBuffer): ImageMessageContent {
        return ImageMessageContent(
            FfiConverterString.read(buf),
            FfiConverterTypeMediaSource.read(buf),
            FfiConverterOptionalTypeImageInfo.read(buf),
        )
    }

    override fun allocationSize(value: ImageMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterTypeMediaSource.allocationSize(value.`source`) +
            FfiConverterOptionalTypeImageInfo.allocationSize(value.`info`)
    )

    override fun write(value: ImageMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterTypeMediaSource.write(value.`source`, buf)
            FfiConverterOptionalTypeImageInfo.write(value.`info`, buf)
    }
}




data class InReplyToDetails (
    var `eventId`: String, 
    var `event`: RepliedToEventDetails
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`eventId`, 
        this.`event`)
    }
    
}

public object FfiConverterTypeInReplyToDetails: FfiConverterRustBuffer<InReplyToDetails> {
    override fun read(buf: ByteBuffer): InReplyToDetails {
        return InReplyToDetails(
            FfiConverterString.read(buf),
            FfiConverterTypeRepliedToEventDetails.read(buf),
        )
    }

    override fun allocationSize(value: InReplyToDetails) = (
            FfiConverterString.allocationSize(value.`eventId`) +
            FfiConverterTypeRepliedToEventDetails.allocationSize(value.`event`)
    )

    override fun write(value: InReplyToDetails, buf: ByteBuffer) {
            FfiConverterString.write(value.`eventId`, buf)
            FfiConverterTypeRepliedToEventDetails.write(value.`event`, buf)
    }
}




data class InsertData (
    var `index`: UInt, 
    var `item`: TimelineItem
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`index`, 
        this.`item`)
    }
    
}

public object FfiConverterTypeInsertData: FfiConverterRustBuffer<InsertData> {
    override fun read(buf: ByteBuffer): InsertData {
        return InsertData(
            FfiConverterUInt.read(buf),
            FfiConverterTypeTimelineItem.read(buf),
        )
    }

    override fun allocationSize(value: InsertData) = (
            FfiConverterUInt.allocationSize(value.`index`) +
            FfiConverterTypeTimelineItem.allocationSize(value.`item`)
    )

    override fun write(value: InsertData, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`index`, buf)
            FfiConverterTypeTimelineItem.write(value.`item`, buf)
    }
}




data class MoveData (
    var `oldIndex`: UInt, 
    var `newIndex`: UInt
) {
    
}

public object FfiConverterTypeMoveData: FfiConverterRustBuffer<MoveData> {
    override fun read(buf: ByteBuffer): MoveData {
        return MoveData(
            FfiConverterUInt.read(buf),
            FfiConverterUInt.read(buf),
        )
    }

    override fun allocationSize(value: MoveData) = (
            FfiConverterUInt.allocationSize(value.`oldIndex`) +
            FfiConverterUInt.allocationSize(value.`newIndex`)
    )

    override fun write(value: MoveData, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`oldIndex`, buf)
            FfiConverterUInt.write(value.`newIndex`, buf)
    }
}




data class NoticeMessageContent (
    var `body`: String, 
    var `formatted`: FormattedBody?
) {
    
}

public object FfiConverterTypeNoticeMessageContent: FfiConverterRustBuffer<NoticeMessageContent> {
    override fun read(buf: ByteBuffer): NoticeMessageContent {
        return NoticeMessageContent(
            FfiConverterString.read(buf),
            FfiConverterOptionalTypeFormattedBody.read(buf),
        )
    }

    override fun allocationSize(value: NoticeMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterOptionalTypeFormattedBody.allocationSize(value.`formatted`)
    )

    override fun write(value: NoticeMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterOptionalTypeFormattedBody.write(value.`formatted`, buf)
    }
}




data class NotificationItem (
    var `item`: TimelineItem, 
    var `title`: String, 
    var `subtitle`: String?, 
    var `isNoisy`: Boolean, 
    var `avatarUrl`: String?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`item`, 
        this.`title`, 
        this.`subtitle`, 
        this.`isNoisy`, 
        this.`avatarUrl`)
    }
    
}

public object FfiConverterTypeNotificationItem: FfiConverterRustBuffer<NotificationItem> {
    override fun read(buf: ByteBuffer): NotificationItem {
        return NotificationItem(
            FfiConverterTypeTimelineItem.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: NotificationItem) = (
            FfiConverterTypeTimelineItem.allocationSize(value.`item`) +
            FfiConverterString.allocationSize(value.`title`) +
            FfiConverterOptionalString.allocationSize(value.`subtitle`) +
            FfiConverterBoolean.allocationSize(value.`isNoisy`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`)
    )

    override fun write(value: NotificationItem, buf: ByteBuffer) {
            FfiConverterTypeTimelineItem.write(value.`item`, buf)
            FfiConverterString.write(value.`title`, buf)
            FfiConverterOptionalString.write(value.`subtitle`, buf)
            FfiConverterBoolean.write(value.`isNoisy`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
    }
}




data class PusherIdentifiers (
    var `pushkey`: String, 
    var `appId`: String
) {
    
}

public object FfiConverterTypePusherIdentifiers: FfiConverterRustBuffer<PusherIdentifiers> {
    override fun read(buf: ByteBuffer): PusherIdentifiers {
        return PusherIdentifiers(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: PusherIdentifiers) = (
            FfiConverterString.allocationSize(value.`pushkey`) +
            FfiConverterString.allocationSize(value.`appId`)
    )

    override fun write(value: PusherIdentifiers, buf: ByteBuffer) {
            FfiConverterString.write(value.`pushkey`, buf)
            FfiConverterString.write(value.`appId`, buf)
    }
}




data class Reaction (
    var `key`: String, 
    var `count`: ULong
) {
    
}

public object FfiConverterTypeReaction: FfiConverterRustBuffer<Reaction> {
    override fun read(buf: ByteBuffer): Reaction {
        return Reaction(
            FfiConverterString.read(buf),
            FfiConverterULong.read(buf),
        )
    }

    override fun allocationSize(value: Reaction) = (
            FfiConverterString.allocationSize(value.`key`) +
            FfiConverterULong.allocationSize(value.`count`)
    )

    override fun write(value: Reaction, buf: ByteBuffer) {
            FfiConverterString.write(value.`key`, buf)
            FfiConverterULong.write(value.`count`, buf)
    }
}




data class RequiredState (
    var `key`: String, 
    var `value`: String
) {
    
}

public object FfiConverterTypeRequiredState: FfiConverterRustBuffer<RequiredState> {
    override fun read(buf: ByteBuffer): RequiredState {
        return RequiredState(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: RequiredState) = (
            FfiConverterString.allocationSize(value.`key`) +
            FfiConverterString.allocationSize(value.`value`)
    )

    override fun write(value: RequiredState, buf: ByteBuffer) {
            FfiConverterString.write(value.`key`, buf)
            FfiConverterString.write(value.`value`, buf)
    }
}




data class RoomSubscription (
    var `requiredState`: List<RequiredState>?, 
    var `timelineLimit`: UInt?
) {
    
}

public object FfiConverterTypeRoomSubscription: FfiConverterRustBuffer<RoomSubscription> {
    override fun read(buf: ByteBuffer): RoomSubscription {
        return RoomSubscription(
            FfiConverterOptionalSequenceTypeRequiredState.read(buf),
            FfiConverterOptionalUInt.read(buf),
        )
    }

    override fun allocationSize(value: RoomSubscription) = (
            FfiConverterOptionalSequenceTypeRequiredState.allocationSize(value.`requiredState`) +
            FfiConverterOptionalUInt.allocationSize(value.`timelineLimit`)
    )

    override fun write(value: RoomSubscription, buf: ByteBuffer) {
            FfiConverterOptionalSequenceTypeRequiredState.write(value.`requiredState`, buf)
            FfiConverterOptionalUInt.write(value.`timelineLimit`, buf)
    }
}




data class SearchUsersResults (
    var `results`: List<UserProfile>, 
    var `limited`: Boolean
) {
    
}

public object FfiConverterTypeSearchUsersResults: FfiConverterRustBuffer<SearchUsersResults> {
    override fun read(buf: ByteBuffer): SearchUsersResults {
        return SearchUsersResults(
            FfiConverterSequenceTypeUserProfile.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: SearchUsersResults) = (
            FfiConverterSequenceTypeUserProfile.allocationSize(value.`results`) +
            FfiConverterBoolean.allocationSize(value.`limited`)
    )

    override fun write(value: SearchUsersResults, buf: ByteBuffer) {
            FfiConverterSequenceTypeUserProfile.write(value.`results`, buf)
            FfiConverterBoolean.write(value.`limited`, buf)
    }
}




data class Session (
    var `accessToken`: String, 
    var `refreshToken`: String?, 
    var `userId`: String, 
    var `deviceId`: String, 
    var `homeserverUrl`: String, 
    var `slidingSyncProxy`: String?
) {
    
}

public object FfiConverterTypeSession: FfiConverterRustBuffer<Session> {
    override fun read(buf: ByteBuffer): Session {
        return Session(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: Session) = (
            FfiConverterString.allocationSize(value.`accessToken`) +
            FfiConverterOptionalString.allocationSize(value.`refreshToken`) +
            FfiConverterString.allocationSize(value.`userId`) +
            FfiConverterString.allocationSize(value.`deviceId`) +
            FfiConverterString.allocationSize(value.`homeserverUrl`) +
            FfiConverterOptionalString.allocationSize(value.`slidingSyncProxy`)
    )

    override fun write(value: Session, buf: ByteBuffer) {
            FfiConverterString.write(value.`accessToken`, buf)
            FfiConverterOptionalString.write(value.`refreshToken`, buf)
            FfiConverterString.write(value.`userId`, buf)
            FfiConverterString.write(value.`deviceId`, buf)
            FfiConverterString.write(value.`homeserverUrl`, buf)
            FfiConverterOptionalString.write(value.`slidingSyncProxy`, buf)
    }
}




data class SetData (
    var `index`: UInt, 
    var `item`: TimelineItem
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`index`, 
        this.`item`)
    }
    
}

public object FfiConverterTypeSetData: FfiConverterRustBuffer<SetData> {
    override fun read(buf: ByteBuffer): SetData {
        return SetData(
            FfiConverterUInt.read(buf),
            FfiConverterTypeTimelineItem.read(buf),
        )
    }

    override fun allocationSize(value: SetData) = (
            FfiConverterUInt.allocationSize(value.`index`) +
            FfiConverterTypeTimelineItem.allocationSize(value.`item`)
    )

    override fun write(value: SetData, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`index`, buf)
            FfiConverterTypeTimelineItem.write(value.`item`, buf)
    }
}




data class SlidingSyncRequestListFilters (
    var `isDm`: Boolean?, 
    var `spaces`: List<String>, 
    var `isEncrypted`: Boolean?, 
    var `isInvite`: Boolean?, 
    var `isTombstoned`: Boolean?, 
    var `roomTypes`: List<String>, 
    var `notRoomTypes`: List<String>, 
    var `roomNameLike`: String?, 
    var `tags`: List<String>, 
    var `notTags`: List<String>
) {
    
}

public object FfiConverterTypeSlidingSyncRequestListFilters: FfiConverterRustBuffer<SlidingSyncRequestListFilters> {
    override fun read(buf: ByteBuffer): SlidingSyncRequestListFilters {
        return SlidingSyncRequestListFilters(
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterSequenceString.read(buf),
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterSequenceString.read(buf),
            FfiConverterSequenceString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterSequenceString.read(buf),
            FfiConverterSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: SlidingSyncRequestListFilters) = (
            FfiConverterOptionalBoolean.allocationSize(value.`isDm`) +
            FfiConverterSequenceString.allocationSize(value.`spaces`) +
            FfiConverterOptionalBoolean.allocationSize(value.`isEncrypted`) +
            FfiConverterOptionalBoolean.allocationSize(value.`isInvite`) +
            FfiConverterOptionalBoolean.allocationSize(value.`isTombstoned`) +
            FfiConverterSequenceString.allocationSize(value.`roomTypes`) +
            FfiConverterSequenceString.allocationSize(value.`notRoomTypes`) +
            FfiConverterOptionalString.allocationSize(value.`roomNameLike`) +
            FfiConverterSequenceString.allocationSize(value.`tags`) +
            FfiConverterSequenceString.allocationSize(value.`notTags`)
    )

    override fun write(value: SlidingSyncRequestListFilters, buf: ByteBuffer) {
            FfiConverterOptionalBoolean.write(value.`isDm`, buf)
            FfiConverterSequenceString.write(value.`spaces`, buf)
            FfiConverterOptionalBoolean.write(value.`isEncrypted`, buf)
            FfiConverterOptionalBoolean.write(value.`isInvite`, buf)
            FfiConverterOptionalBoolean.write(value.`isTombstoned`, buf)
            FfiConverterSequenceString.write(value.`roomTypes`, buf)
            FfiConverterSequenceString.write(value.`notRoomTypes`, buf)
            FfiConverterOptionalString.write(value.`roomNameLike`, buf)
            FfiConverterSequenceString.write(value.`tags`, buf)
            FfiConverterSequenceString.write(value.`notTags`, buf)
    }
}




data class SlidingSyncSubscribeResult (
    var `items`: List<TimelineItem>, 
    var `taskHandle`: TaskHandle
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`items`, 
        this.`taskHandle`)
    }
    
}

public object FfiConverterTypeSlidingSyncSubscribeResult: FfiConverterRustBuffer<SlidingSyncSubscribeResult> {
    override fun read(buf: ByteBuffer): SlidingSyncSubscribeResult {
        return SlidingSyncSubscribeResult(
            FfiConverterSequenceTypeTimelineItem.read(buf),
            FfiConverterTypeTaskHandle.read(buf),
        )
    }

    override fun allocationSize(value: SlidingSyncSubscribeResult) = (
            FfiConverterSequenceTypeTimelineItem.allocationSize(value.`items`) +
            FfiConverterTypeTaskHandle.allocationSize(value.`taskHandle`)
    )

    override fun write(value: SlidingSyncSubscribeResult, buf: ByteBuffer) {
            FfiConverterSequenceTypeTimelineItem.write(value.`items`, buf)
            FfiConverterTypeTaskHandle.write(value.`taskHandle`, buf)
    }
}




data class TextMessageContent (
    var `body`: String, 
    var `formatted`: FormattedBody?
) {
    
}

public object FfiConverterTypeTextMessageContent: FfiConverterRustBuffer<TextMessageContent> {
    override fun read(buf: ByteBuffer): TextMessageContent {
        return TextMessageContent(
            FfiConverterString.read(buf),
            FfiConverterOptionalTypeFormattedBody.read(buf),
        )
    }

    override fun allocationSize(value: TextMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterOptionalTypeFormattedBody.allocationSize(value.`formatted`)
    )

    override fun write(value: TextMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterOptionalTypeFormattedBody.write(value.`formatted`, buf)
    }
}




data class ThumbnailInfo (
    var `height`: ULong?, 
    var `width`: ULong?, 
    var `mimetype`: String?, 
    var `size`: ULong?
) {
    
}

public object FfiConverterTypeThumbnailInfo: FfiConverterRustBuffer<ThumbnailInfo> {
    override fun read(buf: ByteBuffer): ThumbnailInfo {
        return ThumbnailInfo(
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalULong.read(buf),
        )
    }

    override fun allocationSize(value: ThumbnailInfo) = (
            FfiConverterOptionalULong.allocationSize(value.`height`) +
            FfiConverterOptionalULong.allocationSize(value.`width`) +
            FfiConverterOptionalString.allocationSize(value.`mimetype`) +
            FfiConverterOptionalULong.allocationSize(value.`size`)
    )

    override fun write(value: ThumbnailInfo, buf: ByteBuffer) {
            FfiConverterOptionalULong.write(value.`height`, buf)
            FfiConverterOptionalULong.write(value.`width`, buf)
            FfiConverterOptionalString.write(value.`mimetype`, buf)
            FfiConverterOptionalULong.write(value.`size`, buf)
    }
}




data class UpdateSummary (
    var `lists`: List<String>, 
    var `rooms`: List<String>
) {
    
}

public object FfiConverterTypeUpdateSummary: FfiConverterRustBuffer<UpdateSummary> {
    override fun read(buf: ByteBuffer): UpdateSummary {
        return UpdateSummary(
            FfiConverterSequenceString.read(buf),
            FfiConverterSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: UpdateSummary) = (
            FfiConverterSequenceString.allocationSize(value.`lists`) +
            FfiConverterSequenceString.allocationSize(value.`rooms`)
    )

    override fun write(value: UpdateSummary, buf: ByteBuffer) {
            FfiConverterSequenceString.write(value.`lists`, buf)
            FfiConverterSequenceString.write(value.`rooms`, buf)
    }
}




data class UserProfile (
    var `userId`: String, 
    var `displayName`: String?, 
    var `avatarUrl`: String?
) {
    
}

public object FfiConverterTypeUserProfile: FfiConverterRustBuffer<UserProfile> {
    override fun read(buf: ByteBuffer): UserProfile {
        return UserProfile(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: UserProfile) = (
            FfiConverterString.allocationSize(value.`userId`) +
            FfiConverterOptionalString.allocationSize(value.`displayName`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`)
    )

    override fun write(value: UserProfile, buf: ByteBuffer) {
            FfiConverterString.write(value.`userId`, buf)
            FfiConverterOptionalString.write(value.`displayName`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
    }
}




data class VideoInfo (
    var `duration`: ULong?, 
    var `height`: ULong?, 
    var `width`: ULong?, 
    var `mimetype`: String?, 
    var `size`: ULong?, 
    var `thumbnailInfo`: ThumbnailInfo?, 
    var `thumbnailSource`: MediaSource?, 
    var `blurhash`: String?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`duration`, 
        this.`height`, 
        this.`width`, 
        this.`mimetype`, 
        this.`size`, 
        this.`thumbnailInfo`, 
        this.`thumbnailSource`, 
        this.`blurhash`)
    }
    
}

public object FfiConverterTypeVideoInfo: FfiConverterRustBuffer<VideoInfo> {
    override fun read(buf: ByteBuffer): VideoInfo {
        return VideoInfo(
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalTypeThumbnailInfo.read(buf),
            FfiConverterOptionalTypeMediaSource.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: VideoInfo) = (
            FfiConverterOptionalULong.allocationSize(value.`duration`) +
            FfiConverterOptionalULong.allocationSize(value.`height`) +
            FfiConverterOptionalULong.allocationSize(value.`width`) +
            FfiConverterOptionalString.allocationSize(value.`mimetype`) +
            FfiConverterOptionalULong.allocationSize(value.`size`) +
            FfiConverterOptionalTypeThumbnailInfo.allocationSize(value.`thumbnailInfo`) +
            FfiConverterOptionalTypeMediaSource.allocationSize(value.`thumbnailSource`) +
            FfiConverterOptionalString.allocationSize(value.`blurhash`)
    )

    override fun write(value: VideoInfo, buf: ByteBuffer) {
            FfiConverterOptionalULong.write(value.`duration`, buf)
            FfiConverterOptionalULong.write(value.`height`, buf)
            FfiConverterOptionalULong.write(value.`width`, buf)
            FfiConverterOptionalString.write(value.`mimetype`, buf)
            FfiConverterOptionalULong.write(value.`size`, buf)
            FfiConverterOptionalTypeThumbnailInfo.write(value.`thumbnailInfo`, buf)
            FfiConverterOptionalTypeMediaSource.write(value.`thumbnailSource`, buf)
            FfiConverterOptionalString.write(value.`blurhash`, buf)
    }
}




data class VideoMessageContent (
    var `body`: String, 
    var `source`: MediaSource, 
    var `info`: VideoInfo?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`body`, 
        this.`source`, 
        this.`info`)
    }
    
}

public object FfiConverterTypeVideoMessageContent: FfiConverterRustBuffer<VideoMessageContent> {
    override fun read(buf: ByteBuffer): VideoMessageContent {
        return VideoMessageContent(
            FfiConverterString.read(buf),
            FfiConverterTypeMediaSource.read(buf),
            FfiConverterOptionalTypeVideoInfo.read(buf),
        )
    }

    override fun allocationSize(value: VideoMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterTypeMediaSource.allocationSize(value.`source`) +
            FfiConverterOptionalTypeVideoInfo.allocationSize(value.`info`)
    )

    override fun write(value: VideoMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterTypeMediaSource.write(value.`source`, buf)
            FfiConverterOptionalTypeVideoInfo.write(value.`info`, buf)
    }
}




sealed class EncryptedMessage {
    data class OlmV1Curve25519AesSha2(
        val `senderKey`: String
        ) : EncryptedMessage()
    data class MegolmV1AesSha2(
        val `sessionId`: String
        ) : EncryptedMessage()
    object Unknown : EncryptedMessage()
    
    

    
}

public object FfiConverterTypeEncryptedMessage : FfiConverterRustBuffer<EncryptedMessage>{
    override fun read(buf: ByteBuffer): EncryptedMessage {
        return when(buf.getInt()) {
            1 -> EncryptedMessage.OlmV1Curve25519AesSha2(
                FfiConverterString.read(buf),
                )
            2 -> EncryptedMessage.MegolmV1AesSha2(
                FfiConverterString.read(buf),
                )
            3 -> EncryptedMessage.Unknown
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: EncryptedMessage) = when(value) {
        is EncryptedMessage.OlmV1Curve25519AesSha2 -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`senderKey`)
            )
        }
        is EncryptedMessage.MegolmV1AesSha2 -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`sessionId`)
            )
        }
        is EncryptedMessage.Unknown -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
    }

    override fun write(value: EncryptedMessage, buf: ByteBuffer) {
        when(value) {
            is EncryptedMessage.OlmV1Curve25519AesSha2 -> {
                buf.putInt(1)
                FfiConverterString.write(value.`senderKey`, buf)
                Unit
            }
            is EncryptedMessage.MegolmV1AesSha2 -> {
                buf.putInt(2)
                FfiConverterString.write(value.`sessionId`, buf)
                Unit
            }
            is EncryptedMessage.Unknown -> {
                buf.putInt(3)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class EventSendState {
    object NotSendYet : EventSendState()
    
    data class SendingFailed(
        val `error`: String
        ) : EventSendState()
    data class Sent(
        val `eventId`: String
        ) : EventSendState()
    

    
}

public object FfiConverterTypeEventSendState : FfiConverterRustBuffer<EventSendState>{
    override fun read(buf: ByteBuffer): EventSendState {
        return when(buf.getInt()) {
            1 -> EventSendState.NotSendYet
            2 -> EventSendState.SendingFailed(
                FfiConverterString.read(buf),
                )
            3 -> EventSendState.Sent(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: EventSendState) = when(value) {
        is EventSendState.NotSendYet -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is EventSendState.SendingFailed -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`error`)
            )
        }
        is EventSendState.Sent -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`eventId`)
            )
        }
    }

    override fun write(value: EventSendState, buf: ByteBuffer) {
        when(value) {
            is EventSendState.NotSendYet -> {
                buf.putInt(1)
                Unit
            }
            is EventSendState.SendingFailed -> {
                buf.putInt(2)
                FfiConverterString.write(value.`error`, buf)
                Unit
            }
            is EventSendState.Sent -> {
                buf.putInt(3)
                FfiConverterString.write(value.`eventId`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class LogLevel {
    ERROR,WARN,INFO,DEBUG,TRACE;
}

public object FfiConverterTypeLogLevel: FfiConverterRustBuffer<LogLevel> {
    override fun read(buf: ByteBuffer) = try {
        LogLevel.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: LogLevel) = 4

    override fun write(value: LogLevel, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class Membership {
    INVITED,JOINED,LEFT;
}

public object FfiConverterTypeMembership: FfiConverterRustBuffer<Membership> {
    override fun read(buf: ByteBuffer) = try {
        Membership.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: Membership) = 4

    override fun write(value: Membership, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class MembershipChange {
    NONE,ERROR,JOINED,LEFT,BANNED,UNBANNED,KICKED,INVITED,KICKED_AND_BANNED,INVITATION_ACCEPTED,INVITATION_REJECTED,INVITATION_REVOKED,KNOCKED,KNOCK_ACCEPTED,KNOCK_RETRACTED,KNOCK_DENIED,NOT_IMPLEMENTED;
}

public object FfiConverterTypeMembershipChange: FfiConverterRustBuffer<MembershipChange> {
    override fun read(buf: ByteBuffer) = try {
        MembershipChange.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: MembershipChange) = 4

    override fun write(value: MembershipChange, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class MembershipState {
    BAN,INVITE,JOIN,KNOCK,LEAVE;
}

public object FfiConverterTypeMembershipState: FfiConverterRustBuffer<MembershipState> {
    override fun read(buf: ByteBuffer) = try {
        MembershipState.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: MembershipState) = 4

    override fun write(value: MembershipState, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class MessageFormat {
    HTML,UNKNOWN;
}

public object FfiConverterTypeMessageFormat: FfiConverterRustBuffer<MessageFormat> {
    override fun read(buf: ByteBuffer) = try {
        MessageFormat.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: MessageFormat) = 4

    override fun write(value: MessageFormat, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






sealed class MessageType: Disposable  {
    data class Emote(
        val `content`: EmoteMessageContent
        ) : MessageType()
    data class Image(
        val `content`: ImageMessageContent
        ) : MessageType()
    data class Audio(
        val `content`: AudioMessageContent
        ) : MessageType()
    data class Video(
        val `content`: VideoMessageContent
        ) : MessageType()
    data class File(
        val `content`: FileMessageContent
        ) : MessageType()
    data class Notice(
        val `content`: NoticeMessageContent
        ) : MessageType()
    data class Text(
        val `content`: TextMessageContent
        ) : MessageType()
    

    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        when(this) {
            is MessageType.Emote -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.Image -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.Audio -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.Video -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.File -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.Notice -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.Text -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
    
}

public object FfiConverterTypeMessageType : FfiConverterRustBuffer<MessageType>{
    override fun read(buf: ByteBuffer): MessageType {
        return when(buf.getInt()) {
            1 -> MessageType.Emote(
                FfiConverterTypeEmoteMessageContent.read(buf),
                )
            2 -> MessageType.Image(
                FfiConverterTypeImageMessageContent.read(buf),
                )
            3 -> MessageType.Audio(
                FfiConverterTypeAudioMessageContent.read(buf),
                )
            4 -> MessageType.Video(
                FfiConverterTypeVideoMessageContent.read(buf),
                )
            5 -> MessageType.File(
                FfiConverterTypeFileMessageContent.read(buf),
                )
            6 -> MessageType.Notice(
                FfiConverterTypeNoticeMessageContent.read(buf),
                )
            7 -> MessageType.Text(
                FfiConverterTypeTextMessageContent.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: MessageType) = when(value) {
        is MessageType.Emote -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeEmoteMessageContent.allocationSize(value.`content`)
            )
        }
        is MessageType.Image -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeImageMessageContent.allocationSize(value.`content`)
            )
        }
        is MessageType.Audio -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeAudioMessageContent.allocationSize(value.`content`)
            )
        }
        is MessageType.Video -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeVideoMessageContent.allocationSize(value.`content`)
            )
        }
        is MessageType.File -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeFileMessageContent.allocationSize(value.`content`)
            )
        }
        is MessageType.Notice -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeNoticeMessageContent.allocationSize(value.`content`)
            )
        }
        is MessageType.Text -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeTextMessageContent.allocationSize(value.`content`)
            )
        }
    }

    override fun write(value: MessageType, buf: ByteBuffer) {
        when(value) {
            is MessageType.Emote -> {
                buf.putInt(1)
                FfiConverterTypeEmoteMessageContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.Image -> {
                buf.putInt(2)
                FfiConverterTypeImageMessageContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.Audio -> {
                buf.putInt(3)
                FfiConverterTypeAudioMessageContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.Video -> {
                buf.putInt(4)
                FfiConverterTypeVideoMessageContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.File -> {
                buf.putInt(5)
                FfiConverterTypeFileMessageContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.Notice -> {
                buf.putInt(6)
                FfiConverterTypeNoticeMessageContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.Text -> {
                buf.putInt(7)
                FfiConverterTypeTextMessageContent.write(value.`content`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class OtherState {
    object PolicyRuleRoom : OtherState()
    
    object PolicyRuleServer : OtherState()
    
    object PolicyRuleUser : OtherState()
    
    object RoomAliases : OtherState()
    
    data class RoomAvatar(
        val `url`: String?
        ) : OtherState()
    object RoomCanonicalAlias : OtherState()
    
    object RoomCreate : OtherState()
    
    object RoomEncryption : OtherState()
    
    object RoomGuestAccess : OtherState()
    
    object RoomHistoryVisibility : OtherState()
    
    object RoomJoinRules : OtherState()
    
    data class RoomName(
        val `name`: String?
        ) : OtherState()
    object RoomPinnedEvents : OtherState()
    
    object RoomPowerLevels : OtherState()
    
    object RoomServerAcl : OtherState()
    
    data class RoomThirdPartyInvite(
        val `displayName`: String?
        ) : OtherState()
    object RoomTombstone : OtherState()
    
    data class RoomTopic(
        val `topic`: String?
        ) : OtherState()
    object SpaceChild : OtherState()
    
    object SpaceParent : OtherState()
    
    data class Custom(
        val `eventType`: String
        ) : OtherState()
    

    
}

public object FfiConverterTypeOtherState : FfiConverterRustBuffer<OtherState>{
    override fun read(buf: ByteBuffer): OtherState {
        return when(buf.getInt()) {
            1 -> OtherState.PolicyRuleRoom
            2 -> OtherState.PolicyRuleServer
            3 -> OtherState.PolicyRuleUser
            4 -> OtherState.RoomAliases
            5 -> OtherState.RoomAvatar(
                FfiConverterOptionalString.read(buf),
                )
            6 -> OtherState.RoomCanonicalAlias
            7 -> OtherState.RoomCreate
            8 -> OtherState.RoomEncryption
            9 -> OtherState.RoomGuestAccess
            10 -> OtherState.RoomHistoryVisibility
            11 -> OtherState.RoomJoinRules
            12 -> OtherState.RoomName(
                FfiConverterOptionalString.read(buf),
                )
            13 -> OtherState.RoomPinnedEvents
            14 -> OtherState.RoomPowerLevels
            15 -> OtherState.RoomServerAcl
            16 -> OtherState.RoomThirdPartyInvite(
                FfiConverterOptionalString.read(buf),
                )
            17 -> OtherState.RoomTombstone
            18 -> OtherState.RoomTopic(
                FfiConverterOptionalString.read(buf),
                )
            19 -> OtherState.SpaceChild
            20 -> OtherState.SpaceParent
            21 -> OtherState.Custom(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: OtherState) = when(value) {
        is OtherState.PolicyRuleRoom -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.PolicyRuleServer -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.PolicyRuleUser -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomAliases -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomAvatar -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterOptionalString.allocationSize(value.`url`)
            )
        }
        is OtherState.RoomCanonicalAlias -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomCreate -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomEncryption -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomGuestAccess -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomHistoryVisibility -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomJoinRules -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomName -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterOptionalString.allocationSize(value.`name`)
            )
        }
        is OtherState.RoomPinnedEvents -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomPowerLevels -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomServerAcl -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomThirdPartyInvite -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterOptionalString.allocationSize(value.`displayName`)
            )
        }
        is OtherState.RoomTombstone -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomTopic -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterOptionalString.allocationSize(value.`topic`)
            )
        }
        is OtherState.SpaceChild -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.SpaceParent -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.Custom -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`eventType`)
            )
        }
    }

    override fun write(value: OtherState, buf: ByteBuffer) {
        when(value) {
            is OtherState.PolicyRuleRoom -> {
                buf.putInt(1)
                Unit
            }
            is OtherState.PolicyRuleServer -> {
                buf.putInt(2)
                Unit
            }
            is OtherState.PolicyRuleUser -> {
                buf.putInt(3)
                Unit
            }
            is OtherState.RoomAliases -> {
                buf.putInt(4)
                Unit
            }
            is OtherState.RoomAvatar -> {
                buf.putInt(5)
                FfiConverterOptionalString.write(value.`url`, buf)
                Unit
            }
            is OtherState.RoomCanonicalAlias -> {
                buf.putInt(6)
                Unit
            }
            is OtherState.RoomCreate -> {
                buf.putInt(7)
                Unit
            }
            is OtherState.RoomEncryption -> {
                buf.putInt(8)
                Unit
            }
            is OtherState.RoomGuestAccess -> {
                buf.putInt(9)
                Unit
            }
            is OtherState.RoomHistoryVisibility -> {
                buf.putInt(10)
                Unit
            }
            is OtherState.RoomJoinRules -> {
                buf.putInt(11)
                Unit
            }
            is OtherState.RoomName -> {
                buf.putInt(12)
                FfiConverterOptionalString.write(value.`name`, buf)
                Unit
            }
            is OtherState.RoomPinnedEvents -> {
                buf.putInt(13)
                Unit
            }
            is OtherState.RoomPowerLevels -> {
                buf.putInt(14)
                Unit
            }
            is OtherState.RoomServerAcl -> {
                buf.putInt(15)
                Unit
            }
            is OtherState.RoomThirdPartyInvite -> {
                buf.putInt(16)
                FfiConverterOptionalString.write(value.`displayName`, buf)
                Unit
            }
            is OtherState.RoomTombstone -> {
                buf.putInt(17)
                Unit
            }
            is OtherState.RoomTopic -> {
                buf.putInt(18)
                FfiConverterOptionalString.write(value.`topic`, buf)
                Unit
            }
            is OtherState.SpaceChild -> {
                buf.putInt(19)
                Unit
            }
            is OtherState.SpaceParent -> {
                buf.putInt(20)
                Unit
            }
            is OtherState.Custom -> {
                buf.putInt(21)
                FfiConverterString.write(value.`eventType`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class PaginationOptions {
    data class SingleRequest(
        val `eventLimit`: UShort
        ) : PaginationOptions()
    data class UntilNumItems(
        val `eventLimit`: UShort, 
        val `items`: UShort
        ) : PaginationOptions()
    

    
}

public object FfiConverterTypePaginationOptions : FfiConverterRustBuffer<PaginationOptions>{
    override fun read(buf: ByteBuffer): PaginationOptions {
        return when(buf.getInt()) {
            1 -> PaginationOptions.SingleRequest(
                FfiConverterUShort.read(buf),
                )
            2 -> PaginationOptions.UntilNumItems(
                FfiConverterUShort.read(buf),
                FfiConverterUShort.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: PaginationOptions) = when(value) {
        is PaginationOptions.SingleRequest -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterUShort.allocationSize(value.`eventLimit`)
            )
        }
        is PaginationOptions.UntilNumItems -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterUShort.allocationSize(value.`eventLimit`)
                + FfiConverterUShort.allocationSize(value.`items`)
            )
        }
    }

    override fun write(value: PaginationOptions, buf: ByteBuffer) {
        when(value) {
            is PaginationOptions.SingleRequest -> {
                buf.putInt(1)
                FfiConverterUShort.write(value.`eventLimit`, buf)
                Unit
            }
            is PaginationOptions.UntilNumItems -> {
                buf.putInt(2)
                FfiConverterUShort.write(value.`eventLimit`, buf)
                FfiConverterUShort.write(value.`items`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class ProfileDetails {
    object Unavailable : ProfileDetails()
    
    object Pending : ProfileDetails()
    
    data class Ready(
        val `displayName`: String?, 
        val `displayNameAmbiguous`: Boolean, 
        val `avatarUrl`: String?
        ) : ProfileDetails()
    data class Error(
        val `message`: String
        ) : ProfileDetails()
    

    
}

public object FfiConverterTypeProfileDetails : FfiConverterRustBuffer<ProfileDetails>{
    override fun read(buf: ByteBuffer): ProfileDetails {
        return when(buf.getInt()) {
            1 -> ProfileDetails.Unavailable
            2 -> ProfileDetails.Pending
            3 -> ProfileDetails.Ready(
                FfiConverterOptionalString.read(buf),
                FfiConverterBoolean.read(buf),
                FfiConverterOptionalString.read(buf),
                )
            4 -> ProfileDetails.Error(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: ProfileDetails) = when(value) {
        is ProfileDetails.Unavailable -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is ProfileDetails.Pending -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is ProfileDetails.Ready -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterOptionalString.allocationSize(value.`displayName`)
                + FfiConverterBoolean.allocationSize(value.`displayNameAmbiguous`)
                + FfiConverterOptionalString.allocationSize(value.`avatarUrl`)
            )
        }
        is ProfileDetails.Error -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`message`)
            )
        }
    }

    override fun write(value: ProfileDetails, buf: ByteBuffer) {
        when(value) {
            is ProfileDetails.Unavailable -> {
                buf.putInt(1)
                Unit
            }
            is ProfileDetails.Pending -> {
                buf.putInt(2)
                Unit
            }
            is ProfileDetails.Ready -> {
                buf.putInt(3)
                FfiConverterOptionalString.write(value.`displayName`, buf)
                FfiConverterBoolean.write(value.`displayNameAmbiguous`, buf)
                FfiConverterOptionalString.write(value.`avatarUrl`, buf)
                Unit
            }
            is ProfileDetails.Error -> {
                buf.putInt(4)
                FfiConverterString.write(value.`message`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class PushFormat {
    EVENT_ID_ONLY;
}

public object FfiConverterTypePushFormat: FfiConverterRustBuffer<PushFormat> {
    override fun read(buf: ByteBuffer) = try {
        PushFormat.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: PushFormat) = 4

    override fun write(value: PushFormat, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






sealed class PusherKind {
    data class Http(
        val `data`: HttpPusherData
        ) : PusherKind()
    object Email : PusherKind()
    
    

    
}

public object FfiConverterTypePusherKind : FfiConverterRustBuffer<PusherKind>{
    override fun read(buf: ByteBuffer): PusherKind {
        return when(buf.getInt()) {
            1 -> PusherKind.Http(
                FfiConverterTypeHttpPusherData.read(buf),
                )
            2 -> PusherKind.Email
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: PusherKind) = when(value) {
        is PusherKind.Http -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeHttpPusherData.allocationSize(value.`data`)
            )
        }
        is PusherKind.Email -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
    }

    override fun write(value: PusherKind, buf: ByteBuffer) {
        when(value) {
            is PusherKind.Http -> {
                buf.putInt(1)
                FfiConverterTypeHttpPusherData.write(value.`data`, buf)
                Unit
            }
            is PusherKind.Email -> {
                buf.putInt(2)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class RepliedToEventDetails: Disposable  {
    object Unavailable : RepliedToEventDetails()
    
    object Pending : RepliedToEventDetails()
    
    data class Ready(
        val `message`: Message, 
        val `sender`: String, 
        val `senderProfile`: ProfileDetails
        ) : RepliedToEventDetails()
    data class Error(
        val `message`: String
        ) : RepliedToEventDetails()
    

    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        when(this) {
            is RepliedToEventDetails.Unavailable -> {// Nothing to destroy
            }
            is RepliedToEventDetails.Pending -> {// Nothing to destroy
            }
            is RepliedToEventDetails.Ready -> {
                
    Disposable.destroy(
        this.`message`, 
        this.`sender`, 
        this.`senderProfile`)
                
            }
            is RepliedToEventDetails.Error -> {
                
    Disposable.destroy(
        this.`message`)
                
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
    
}

public object FfiConverterTypeRepliedToEventDetails : FfiConverterRustBuffer<RepliedToEventDetails>{
    override fun read(buf: ByteBuffer): RepliedToEventDetails {
        return when(buf.getInt()) {
            1 -> RepliedToEventDetails.Unavailable
            2 -> RepliedToEventDetails.Pending
            3 -> RepliedToEventDetails.Ready(
                FfiConverterTypeMessage.read(buf),
                FfiConverterString.read(buf),
                FfiConverterTypeProfileDetails.read(buf),
                )
            4 -> RepliedToEventDetails.Error(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: RepliedToEventDetails) = when(value) {
        is RepliedToEventDetails.Unavailable -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is RepliedToEventDetails.Pending -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is RepliedToEventDetails.Ready -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeMessage.allocationSize(value.`message`)
                + FfiConverterString.allocationSize(value.`sender`)
                + FfiConverterTypeProfileDetails.allocationSize(value.`senderProfile`)
            )
        }
        is RepliedToEventDetails.Error -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`message`)
            )
        }
    }

    override fun write(value: RepliedToEventDetails, buf: ByteBuffer) {
        when(value) {
            is RepliedToEventDetails.Unavailable -> {
                buf.putInt(1)
                Unit
            }
            is RepliedToEventDetails.Pending -> {
                buf.putInt(2)
                Unit
            }
            is RepliedToEventDetails.Ready -> {
                buf.putInt(3)
                FfiConverterTypeMessage.write(value.`message`, buf)
                FfiConverterString.write(value.`sender`, buf)
                FfiConverterTypeProfileDetails.write(value.`senderProfile`, buf)
                Unit
            }
            is RepliedToEventDetails.Error -> {
                buf.putInt(4)
                FfiConverterString.write(value.`message`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class RoomListEntry {
    object Empty : RoomListEntry()
    
    data class Invalidated(
        val `roomId`: String
        ) : RoomListEntry()
    data class Filled(
        val `roomId`: String
        ) : RoomListEntry()
    

    
}

public object FfiConverterTypeRoomListEntry : FfiConverterRustBuffer<RoomListEntry>{
    override fun read(buf: ByteBuffer): RoomListEntry {
        return when(buf.getInt()) {
            1 -> RoomListEntry.Empty
            2 -> RoomListEntry.Invalidated(
                FfiConverterString.read(buf),
                )
            3 -> RoomListEntry.Filled(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: RoomListEntry) = when(value) {
        is RoomListEntry.Empty -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is RoomListEntry.Invalidated -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`roomId`)
            )
        }
        is RoomListEntry.Filled -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`roomId`)
            )
        }
    }

    override fun write(value: RoomListEntry, buf: ByteBuffer) {
        when(value) {
            is RoomListEntry.Empty -> {
                buf.putInt(1)
                Unit
            }
            is RoomListEntry.Invalidated -> {
                buf.putInt(2)
                FfiConverterString.write(value.`roomId`, buf)
                Unit
            }
            is RoomListEntry.Filled -> {
                buf.putInt(3)
                FfiConverterString.write(value.`roomId`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class RoomPreset {
    PRIVATE_CHAT,PUBLIC_CHAT,TRUSTED_PRIVATE_CHAT;
}

public object FfiConverterTypeRoomPreset: FfiConverterRustBuffer<RoomPreset> {
    override fun read(buf: ByteBuffer) = try {
        RoomPreset.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: RoomPreset) = 4

    override fun write(value: RoomPreset, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class RoomVisibility {
    PUBLIC,PRIVATE;
}

public object FfiConverterTypeRoomVisibility: FfiConverterRustBuffer<RoomVisibility> {
    override fun read(buf: ByteBuffer) = try {
        RoomVisibility.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: RoomVisibility) = 4

    override fun write(value: RoomVisibility, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






sealed class SlidingSyncListRoomsListDiff {
    data class Append(
        val `values`: List<RoomListEntry>
        ) : SlidingSyncListRoomsListDiff()
    data class Insert(
        val `index`: UInt, 
        val `value`: RoomListEntry
        ) : SlidingSyncListRoomsListDiff()
    data class Set(
        val `index`: UInt, 
        val `value`: RoomListEntry
        ) : SlidingSyncListRoomsListDiff()
    data class Remove(
        val `index`: UInt
        ) : SlidingSyncListRoomsListDiff()
    data class PushBack(
        val `value`: RoomListEntry
        ) : SlidingSyncListRoomsListDiff()
    data class PushFront(
        val `value`: RoomListEntry
        ) : SlidingSyncListRoomsListDiff()
    object PopBack : SlidingSyncListRoomsListDiff()
    
    object PopFront : SlidingSyncListRoomsListDiff()
    
    object Clear : SlidingSyncListRoomsListDiff()
    
    data class Reset(
        val `values`: List<RoomListEntry>
        ) : SlidingSyncListRoomsListDiff()
    

    
}

public object FfiConverterTypeSlidingSyncListRoomsListDiff : FfiConverterRustBuffer<SlidingSyncListRoomsListDiff>{
    override fun read(buf: ByteBuffer): SlidingSyncListRoomsListDiff {
        return when(buf.getInt()) {
            1 -> SlidingSyncListRoomsListDiff.Append(
                FfiConverterSequenceTypeRoomListEntry.read(buf),
                )
            2 -> SlidingSyncListRoomsListDiff.Insert(
                FfiConverterUInt.read(buf),
                FfiConverterTypeRoomListEntry.read(buf),
                )
            3 -> SlidingSyncListRoomsListDiff.Set(
                FfiConverterUInt.read(buf),
                FfiConverterTypeRoomListEntry.read(buf),
                )
            4 -> SlidingSyncListRoomsListDiff.Remove(
                FfiConverterUInt.read(buf),
                )
            5 -> SlidingSyncListRoomsListDiff.PushBack(
                FfiConverterTypeRoomListEntry.read(buf),
                )
            6 -> SlidingSyncListRoomsListDiff.PushFront(
                FfiConverterTypeRoomListEntry.read(buf),
                )
            7 -> SlidingSyncListRoomsListDiff.PopBack
            8 -> SlidingSyncListRoomsListDiff.PopFront
            9 -> SlidingSyncListRoomsListDiff.Clear
            10 -> SlidingSyncListRoomsListDiff.Reset(
                FfiConverterSequenceTypeRoomListEntry.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: SlidingSyncListRoomsListDiff) = when(value) {
        is SlidingSyncListRoomsListDiff.Append -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterSequenceTypeRoomListEntry.allocationSize(value.`values`)
            )
        }
        is SlidingSyncListRoomsListDiff.Insert -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterUInt.allocationSize(value.`index`)
                + FfiConverterTypeRoomListEntry.allocationSize(value.`value`)
            )
        }
        is SlidingSyncListRoomsListDiff.Set -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterUInt.allocationSize(value.`index`)
                + FfiConverterTypeRoomListEntry.allocationSize(value.`value`)
            )
        }
        is SlidingSyncListRoomsListDiff.Remove -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterUInt.allocationSize(value.`index`)
            )
        }
        is SlidingSyncListRoomsListDiff.PushBack -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeRoomListEntry.allocationSize(value.`value`)
            )
        }
        is SlidingSyncListRoomsListDiff.PushFront -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeRoomListEntry.allocationSize(value.`value`)
            )
        }
        is SlidingSyncListRoomsListDiff.PopBack -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is SlidingSyncListRoomsListDiff.PopFront -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is SlidingSyncListRoomsListDiff.Clear -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is SlidingSyncListRoomsListDiff.Reset -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterSequenceTypeRoomListEntry.allocationSize(value.`values`)
            )
        }
    }

    override fun write(value: SlidingSyncListRoomsListDiff, buf: ByteBuffer) {
        when(value) {
            is SlidingSyncListRoomsListDiff.Append -> {
                buf.putInt(1)
                FfiConverterSequenceTypeRoomListEntry.write(value.`values`, buf)
                Unit
            }
            is SlidingSyncListRoomsListDiff.Insert -> {
                buf.putInt(2)
                FfiConverterUInt.write(value.`index`, buf)
                FfiConverterTypeRoomListEntry.write(value.`value`, buf)
                Unit
            }
            is SlidingSyncListRoomsListDiff.Set -> {
                buf.putInt(3)
                FfiConverterUInt.write(value.`index`, buf)
                FfiConverterTypeRoomListEntry.write(value.`value`, buf)
                Unit
            }
            is SlidingSyncListRoomsListDiff.Remove -> {
                buf.putInt(4)
                FfiConverterUInt.write(value.`index`, buf)
                Unit
            }
            is SlidingSyncListRoomsListDiff.PushBack -> {
                buf.putInt(5)
                FfiConverterTypeRoomListEntry.write(value.`value`, buf)
                Unit
            }
            is SlidingSyncListRoomsListDiff.PushFront -> {
                buf.putInt(6)
                FfiConverterTypeRoomListEntry.write(value.`value`, buf)
                Unit
            }
            is SlidingSyncListRoomsListDiff.PopBack -> {
                buf.putInt(7)
                Unit
            }
            is SlidingSyncListRoomsListDiff.PopFront -> {
                buf.putInt(8)
                Unit
            }
            is SlidingSyncListRoomsListDiff.Clear -> {
                buf.putInt(9)
                Unit
            }
            is SlidingSyncListRoomsListDiff.Reset -> {
                buf.putInt(10)
                FfiConverterSequenceTypeRoomListEntry.write(value.`values`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class SlidingSyncMode {
    PAGING,GROWING,SELECTIVE;
}

public object FfiConverterTypeSlidingSyncMode: FfiConverterRustBuffer<SlidingSyncMode> {
    override fun read(buf: ByteBuffer) = try {
        SlidingSyncMode.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: SlidingSyncMode) = 4

    override fun write(value: SlidingSyncMode, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class SlidingSyncState {
    NOT_LOADED,PRELOADED,PARTIALLY_LOADED,FULLY_LOADED;
}

public object FfiConverterTypeSlidingSyncState: FfiConverterRustBuffer<SlidingSyncState> {
    override fun read(buf: ByteBuffer) = try {
        SlidingSyncState.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: SlidingSyncState) = 4

    override fun write(value: SlidingSyncState, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class TimelineChange {
    APPEND,CLEAR,INSERT,SET,REMOVE,PUSH_BACK,PUSH_FRONT,POP_BACK,POP_FRONT,RESET;
}

public object FfiConverterTypeTimelineChange: FfiConverterRustBuffer<TimelineChange> {
    override fun read(buf: ByteBuffer) = try {
        TimelineChange.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: TimelineChange) = 4

    override fun write(value: TimelineChange, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






sealed class TimelineItemContentKind: Disposable  {
    object Message : TimelineItemContentKind()
    
    object RedactedMessage : TimelineItemContentKind()
    
    data class Sticker(
        val `body`: String, 
        val `info`: ImageInfo, 
        val `url`: String
        ) : TimelineItemContentKind()
    data class UnableToDecrypt(
        val `msg`: EncryptedMessage
        ) : TimelineItemContentKind()
    data class RoomMembership(
        val `userId`: String, 
        val `change`: MembershipChange?
        ) : TimelineItemContentKind()
    data class ProfileChange(
        val `displayName`: String?, 
        val `prevDisplayName`: String?, 
        val `avatarUrl`: String?, 
        val `prevAvatarUrl`: String?
        ) : TimelineItemContentKind()
    data class State(
        val `stateKey`: String, 
        val `content`: OtherState
        ) : TimelineItemContentKind()
    data class FailedToParseMessageLike(
        val `eventType`: String, 
        val `error`: String
        ) : TimelineItemContentKind()
    data class FailedToParseState(
        val `eventType`: String, 
        val `stateKey`: String, 
        val `error`: String
        ) : TimelineItemContentKind()
    

    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        when(this) {
            is TimelineItemContentKind.Message -> {// Nothing to destroy
            }
            is TimelineItemContentKind.RedactedMessage -> {// Nothing to destroy
            }
            is TimelineItemContentKind.Sticker -> {
                
    Disposable.destroy(
        this.`body`, 
        this.`info`, 
        this.`url`)
                
            }
            is TimelineItemContentKind.UnableToDecrypt -> {
                
    Disposable.destroy(
        this.`msg`)
                
            }
            is TimelineItemContentKind.RoomMembership -> {
                
    Disposable.destroy(
        this.`userId`, 
        this.`change`)
                
            }
            is TimelineItemContentKind.ProfileChange -> {
                
    Disposable.destroy(
        this.`displayName`, 
        this.`prevDisplayName`, 
        this.`avatarUrl`, 
        this.`prevAvatarUrl`)
                
            }
            is TimelineItemContentKind.State -> {
                
    Disposable.destroy(
        this.`stateKey`, 
        this.`content`)
                
            }
            is TimelineItemContentKind.FailedToParseMessageLike -> {
                
    Disposable.destroy(
        this.`eventType`, 
        this.`error`)
                
            }
            is TimelineItemContentKind.FailedToParseState -> {
                
    Disposable.destroy(
        this.`eventType`, 
        this.`stateKey`, 
        this.`error`)
                
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
    
}

public object FfiConverterTypeTimelineItemContentKind : FfiConverterRustBuffer<TimelineItemContentKind>{
    override fun read(buf: ByteBuffer): TimelineItemContentKind {
        return when(buf.getInt()) {
            1 -> TimelineItemContentKind.Message
            2 -> TimelineItemContentKind.RedactedMessage
            3 -> TimelineItemContentKind.Sticker(
                FfiConverterString.read(buf),
                FfiConverterTypeImageInfo.read(buf),
                FfiConverterString.read(buf),
                )
            4 -> TimelineItemContentKind.UnableToDecrypt(
                FfiConverterTypeEncryptedMessage.read(buf),
                )
            5 -> TimelineItemContentKind.RoomMembership(
                FfiConverterString.read(buf),
                FfiConverterOptionalTypeMembershipChange.read(buf),
                )
            6 -> TimelineItemContentKind.ProfileChange(
                FfiConverterOptionalString.read(buf),
                FfiConverterOptionalString.read(buf),
                FfiConverterOptionalString.read(buf),
                FfiConverterOptionalString.read(buf),
                )
            7 -> TimelineItemContentKind.State(
                FfiConverterString.read(buf),
                FfiConverterTypeOtherState.read(buf),
                )
            8 -> TimelineItemContentKind.FailedToParseMessageLike(
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                )
            9 -> TimelineItemContentKind.FailedToParseState(
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: TimelineItemContentKind) = when(value) {
        is TimelineItemContentKind.Message -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is TimelineItemContentKind.RedactedMessage -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is TimelineItemContentKind.Sticker -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`body`)
                + FfiConverterTypeImageInfo.allocationSize(value.`info`)
                + FfiConverterString.allocationSize(value.`url`)
            )
        }
        is TimelineItemContentKind.UnableToDecrypt -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeEncryptedMessage.allocationSize(value.`msg`)
            )
        }
        is TimelineItemContentKind.RoomMembership -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`userId`)
                + FfiConverterOptionalTypeMembershipChange.allocationSize(value.`change`)
            )
        }
        is TimelineItemContentKind.ProfileChange -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterOptionalString.allocationSize(value.`displayName`)
                + FfiConverterOptionalString.allocationSize(value.`prevDisplayName`)
                + FfiConverterOptionalString.allocationSize(value.`avatarUrl`)
                + FfiConverterOptionalString.allocationSize(value.`prevAvatarUrl`)
            )
        }
        is TimelineItemContentKind.State -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`stateKey`)
                + FfiConverterTypeOtherState.allocationSize(value.`content`)
            )
        }
        is TimelineItemContentKind.FailedToParseMessageLike -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`eventType`)
                + FfiConverterString.allocationSize(value.`error`)
            )
        }
        is TimelineItemContentKind.FailedToParseState -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`eventType`)
                + FfiConverterString.allocationSize(value.`stateKey`)
                + FfiConverterString.allocationSize(value.`error`)
            )
        }
    }

    override fun write(value: TimelineItemContentKind, buf: ByteBuffer) {
        when(value) {
            is TimelineItemContentKind.Message -> {
                buf.putInt(1)
                Unit
            }
            is TimelineItemContentKind.RedactedMessage -> {
                buf.putInt(2)
                Unit
            }
            is TimelineItemContentKind.Sticker -> {
                buf.putInt(3)
                FfiConverterString.write(value.`body`, buf)
                FfiConverterTypeImageInfo.write(value.`info`, buf)
                FfiConverterString.write(value.`url`, buf)
                Unit
            }
            is TimelineItemContentKind.UnableToDecrypt -> {
                buf.putInt(4)
                FfiConverterTypeEncryptedMessage.write(value.`msg`, buf)
                Unit
            }
            is TimelineItemContentKind.RoomMembership -> {
                buf.putInt(5)
                FfiConverterString.write(value.`userId`, buf)
                FfiConverterOptionalTypeMembershipChange.write(value.`change`, buf)
                Unit
            }
            is TimelineItemContentKind.ProfileChange -> {
                buf.putInt(6)
                FfiConverterOptionalString.write(value.`displayName`, buf)
                FfiConverterOptionalString.write(value.`prevDisplayName`, buf)
                FfiConverterOptionalString.write(value.`avatarUrl`, buf)
                FfiConverterOptionalString.write(value.`prevAvatarUrl`, buf)
                Unit
            }
            is TimelineItemContentKind.State -> {
                buf.putInt(7)
                FfiConverterString.write(value.`stateKey`, buf)
                FfiConverterTypeOtherState.write(value.`content`, buf)
                Unit
            }
            is TimelineItemContentKind.FailedToParseMessageLike -> {
                buf.putInt(8)
                FfiConverterString.write(value.`eventType`, buf)
                FfiConverterString.write(value.`error`, buf)
                Unit
            }
            is TimelineItemContentKind.FailedToParseState -> {
                buf.putInt(9)
                FfiConverterString.write(value.`eventType`, buf)
                FfiConverterString.write(value.`stateKey`, buf)
                FfiConverterString.write(value.`error`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class VirtualTimelineItem {
    data class DayDivider(
        val `ts`: ULong
        ) : VirtualTimelineItem()
    object ReadMarker : VirtualTimelineItem()
    
    object LoadingIndicator : VirtualTimelineItem()
    
    object TimelineStart : VirtualTimelineItem()
    
    

    
}

public object FfiConverterTypeVirtualTimelineItem : FfiConverterRustBuffer<VirtualTimelineItem>{
    override fun read(buf: ByteBuffer): VirtualTimelineItem {
        return when(buf.getInt()) {
            1 -> VirtualTimelineItem.DayDivider(
                FfiConverterULong.read(buf),
                )
            2 -> VirtualTimelineItem.ReadMarker
            3 -> VirtualTimelineItem.LoadingIndicator
            4 -> VirtualTimelineItem.TimelineStart
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: VirtualTimelineItem) = when(value) {
        is VirtualTimelineItem.DayDivider -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterULong.allocationSize(value.`ts`)
            )
        }
        is VirtualTimelineItem.ReadMarker -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is VirtualTimelineItem.LoadingIndicator -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is VirtualTimelineItem.TimelineStart -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
    }

    override fun write(value: VirtualTimelineItem, buf: ByteBuffer) {
        when(value) {
            is VirtualTimelineItem.DayDivider -> {
                buf.putInt(1)
                FfiConverterULong.write(value.`ts`, buf)
                Unit
            }
            is VirtualTimelineItem.ReadMarker -> {
                buf.putInt(2)
                Unit
            }
            is VirtualTimelineItem.LoadingIndicator -> {
                buf.putInt(3)
                Unit
            }
            is VirtualTimelineItem.TimelineStart -> {
                buf.putInt(4)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}







sealed class AuthenticationException(message: String): Exception(message) {
        // Each variant is a nested class
        // Flat enums carries a string error message, so no special implementation is necessary.
        class ClientMissing(message: String) : AuthenticationException(message)
        class InvalidServerName(message: String) : AuthenticationException(message)
        class SlidingSyncNotAvailable(message: String) : AuthenticationException(message)
        class SessionMissing(message: String) : AuthenticationException(message)
        class Generic(message: String) : AuthenticationException(message)
        

    companion object ErrorHandler : CallStatusErrorHandler<AuthenticationException> {
        override fun lift(error_buf: RustBuffer.ByValue): AuthenticationException = FfiConverterTypeAuthenticationError.lift(error_buf)
    }
}

public object FfiConverterTypeAuthenticationError : FfiConverterRustBuffer<AuthenticationException> {
    override fun read(buf: ByteBuffer): AuthenticationException {
        
            return when(buf.getInt()) {
            1 -> AuthenticationException.ClientMissing(FfiConverterString.read(buf))
            2 -> AuthenticationException.InvalidServerName(FfiConverterString.read(buf))
            3 -> AuthenticationException.SlidingSyncNotAvailable(FfiConverterString.read(buf))
            4 -> AuthenticationException.SessionMissing(FfiConverterString.read(buf))
            5 -> AuthenticationException.Generic(FfiConverterString.read(buf))
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
        
    }

    override fun allocationSize(value: AuthenticationException): Int {
        return 4
    }

    override fun write(value: AuthenticationException, buf: ByteBuffer) {
        when(value) {
            is AuthenticationException.ClientMissing -> {
                buf.putInt(1)
                Unit
            }
            is AuthenticationException.InvalidServerName -> {
                buf.putInt(2)
                Unit
            }
            is AuthenticationException.SlidingSyncNotAvailable -> {
                buf.putInt(3)
                Unit
            }
            is AuthenticationException.SessionMissing -> {
                buf.putInt(4)
                Unit
            }
            is AuthenticationException.Generic -> {
                buf.putInt(5)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}





sealed class ClientException: Exception() {
    // Each variant is a nested class
    
    class Generic(
        val `msg`: String
        ) : ClientException() {
        override val message
            get() = "msg=${ `msg` }"
    }
    

    companion object ErrorHandler : CallStatusErrorHandler<ClientException> {
        override fun lift(error_buf: RustBuffer.ByValue): ClientException = FfiConverterTypeClientError.lift(error_buf)
    }

    
}

public object FfiConverterTypeClientError : FfiConverterRustBuffer<ClientException> {
    override fun read(buf: ByteBuffer): ClientException {
        

        return when(buf.getInt()) {
            1 -> ClientException.Generic(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: ClientException): Int {
        return when(value) {
            is ClientException.Generic -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`msg`)
            )
        }
    }

    override fun write(value: ClientException, buf: ByteBuffer) {
        when(value) {
            is ClientException.Generic -> {
                buf.putInt(1)
                FfiConverterString.write(value.`msg`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}





sealed class SlidingSyncException: Exception() {
    // Each variant is a nested class
    
    class BadResponse(
        val `msg`: String
        ) : SlidingSyncException() {
        override val message
            get() = "msg=${ `msg` }"
    }
    
    class BuildMissingField(
        val `msg`: String
        ) : SlidingSyncException() {
        override val message
            get() = "msg=${ `msg` }"
    }
    
    class RequestGeneratorHasNotBeenInitialized(
        val `msg`: String
        ) : SlidingSyncException() {
        override val message
            get() = "msg=${ `msg` }"
    }
    
    class CannotModifyRanges(
        val `msg`: String
        ) : SlidingSyncException() {
        override val message
            get() = "msg=${ `msg` }"
    }
    
    class InvalidRange(
        val `start`: UInt, 
        val `end`: UInt
        ) : SlidingSyncException() {
        override val message
            get() = "start=${ `start` }, end=${ `end` }"
    }
    
    class Unknown(
        val `error`: String
        ) : SlidingSyncException() {
        override val message
            get() = "error=${ `error` }"
    }
    

    companion object ErrorHandler : CallStatusErrorHandler<SlidingSyncException> {
        override fun lift(error_buf: RustBuffer.ByValue): SlidingSyncException = FfiConverterTypeSlidingSyncError.lift(error_buf)
    }

    
}

public object FfiConverterTypeSlidingSyncError : FfiConverterRustBuffer<SlidingSyncException> {
    override fun read(buf: ByteBuffer): SlidingSyncException {
        

        return when(buf.getInt()) {
            1 -> SlidingSyncException.BadResponse(
                FfiConverterString.read(buf),
                )
            2 -> SlidingSyncException.BuildMissingField(
                FfiConverterString.read(buf),
                )
            3 -> SlidingSyncException.RequestGeneratorHasNotBeenInitialized(
                FfiConverterString.read(buf),
                )
            4 -> SlidingSyncException.CannotModifyRanges(
                FfiConverterString.read(buf),
                )
            5 -> SlidingSyncException.InvalidRange(
                FfiConverterUInt.read(buf),
                FfiConverterUInt.read(buf),
                )
            6 -> SlidingSyncException.Unknown(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: SlidingSyncException): Int {
        return when(value) {
            is SlidingSyncException.BadResponse -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`msg`)
            )
            is SlidingSyncException.BuildMissingField -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`msg`)
            )
            is SlidingSyncException.RequestGeneratorHasNotBeenInitialized -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`msg`)
            )
            is SlidingSyncException.CannotModifyRanges -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`msg`)
            )
            is SlidingSyncException.InvalidRange -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterUInt.allocationSize(value.`start`)
                + FfiConverterUInt.allocationSize(value.`end`)
            )
            is SlidingSyncException.Unknown -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`error`)
            )
        }
    }

    override fun write(value: SlidingSyncException, buf: ByteBuffer) {
        when(value) {
            is SlidingSyncException.BadResponse -> {
                buf.putInt(1)
                FfiConverterString.write(value.`msg`, buf)
                Unit
            }
            is SlidingSyncException.BuildMissingField -> {
                buf.putInt(2)
                FfiConverterString.write(value.`msg`, buf)
                Unit
            }
            is SlidingSyncException.RequestGeneratorHasNotBeenInitialized -> {
                buf.putInt(3)
                FfiConverterString.write(value.`msg`, buf)
                Unit
            }
            is SlidingSyncException.CannotModifyRanges -> {
                buf.putInt(4)
                FfiConverterString.write(value.`msg`, buf)
                Unit
            }
            is SlidingSyncException.InvalidRange -> {
                buf.putInt(5)
                FfiConverterUInt.write(value.`start`, buf)
                FfiConverterUInt.write(value.`end`, buf)
                Unit
            }
            is SlidingSyncException.Unknown -> {
                buf.putInt(6)
                FfiConverterString.write(value.`error`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




internal typealias Handle = Long
internal class ConcurrentHandleMap<T>(
    private val leftMap: MutableMap<Handle, T> = mutableMapOf(),
    private val rightMap: MutableMap<T, Handle> = mutableMapOf()
) {
    private val lock = java.util.concurrent.locks.ReentrantLock()
    private val currentHandle = AtomicLong(0L)
    private val stride = 1L

    fun insert(obj: T): Handle =
        lock.withLock {
            rightMap[obj] ?:
                currentHandle.getAndAdd(stride)
                    .also { handle ->
                        leftMap[handle] = obj
                        rightMap[obj] = handle
                    }
            }

    fun get(handle: Handle) = lock.withLock {
        leftMap[handle]
    }

    fun delete(handle: Handle) {
        this.remove(handle)
    }

    fun remove(handle: Handle): T? =
        lock.withLock {
            leftMap.remove(handle)?.let { obj ->
                rightMap.remove(obj)
                obj
            }
        }
}

interface ForeignCallback : com.sun.jna.Callback {
    public fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int
}

// Magic number for the Rust proxy to call using the same mechanism as every other method,
// to free the callback once it's dropped by Rust.
internal const val IDX_CALLBACK_FREE = 0
// Callback return codes
internal const val UNIFFI_CALLBACK_SUCCESS = 0
internal const val UNIFFI_CALLBACK_ERROR = 1
internal const val UNIFFI_CALLBACK_UNEXPECTED_ERROR = 2

public abstract class FfiConverterCallbackInterface<CallbackInterface>(
    protected val foreignCallback: ForeignCallback
): FfiConverter<CallbackInterface, Handle> {
    private val handleMap = ConcurrentHandleMap<CallbackInterface>()

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal abstract fun register(lib: _UniFFILib)

    fun drop(handle: Handle): RustBuffer.ByValue {
        return handleMap.remove(handle).let { RustBuffer.ByValue() }
    }

    override fun lift(value: Handle): CallbackInterface {
        return handleMap.get(value) ?: throw InternalException("No callback in handlemap; this is a Uniffi bug")
    }

    override fun read(buf: ByteBuffer) = lift(buf.getLong())

    override fun lower(value: CallbackInterface) =
        handleMap.insert(value).also {
            assert(handleMap.get(it) === value) { "Handle map is not returning the object we just placed there. This is a bug in the HandleMap." }
        }

    override fun allocationSize(value: CallbackInterface) = 8

    override fun write(value: CallbackInterface, buf: ByteBuffer) {
        buf.putLong(lower(value))
    }
}

// Declaration and FfiConverters for ClientDelegate Callback Interface

public interface ClientDelegate {
    fun `didReceiveAuthError`(`isSoftLogout`: Boolean)
    
}

// The ForeignCallback that is passed to Rust.
internal class ForeignCallbackTypeClientDelegate : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeClientDelegate.lift(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeClientDelegate.drop(handle)
                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidReceiveAuthError`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidReceiveAuthError`(kotlinCallbackInterface: ClientDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`didReceiveAuthError`(
                FfiConverterBoolean.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
}

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeClientDelegate: FfiConverterCallbackInterface<ClientDelegate>(
    foreignCallback = ForeignCallbackTypeClientDelegate()
) {
    override fun register(lib: _UniFFILib) {
        rustCall() { status ->
            lib.ffi_matrix_sdk_ffi_a64_ClientDelegate_init_callback(this.foreignCallback, status)
        }
    }
}






// Declaration and FfiConverters for SessionVerificationControllerDelegate Callback Interface

public interface SessionVerificationControllerDelegate {
    fun `didAcceptVerificationRequest`()
    fun `didStartSasVerification`()
    fun `didReceiveVerificationData`(`data`: List<SessionVerificationEmoji>)
    fun `didFail`()
    fun `didCancel`()
    fun `didFinish`()
    
}

// The ForeignCallback that is passed to Rust.
internal class ForeignCallbackTypeSessionVerificationControllerDelegate : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeSessionVerificationControllerDelegate.lift(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeSessionVerificationControllerDelegate.drop(handle)
                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidAcceptVerificationRequest`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            2 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidStartSasVerification`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            3 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidReceiveVerificationData`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            4 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidFail`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            5 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidCancel`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            6 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidFinish`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidAcceptVerificationRequest`(kotlinCallbackInterface: SessionVerificationControllerDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        fun makeCall() : Int {
            kotlinCallbackInterface.`didAcceptVerificationRequest`(
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidStartSasVerification`(kotlinCallbackInterface: SessionVerificationControllerDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        fun makeCall() : Int {
            kotlinCallbackInterface.`didStartSasVerification`(
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidReceiveVerificationData`(kotlinCallbackInterface: SessionVerificationControllerDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`didReceiveVerificationData`(
                FfiConverterSequenceTypeSessionVerificationEmoji.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidFail`(kotlinCallbackInterface: SessionVerificationControllerDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        fun makeCall() : Int {
            kotlinCallbackInterface.`didFail`(
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidCancel`(kotlinCallbackInterface: SessionVerificationControllerDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        fun makeCall() : Int {
            kotlinCallbackInterface.`didCancel`(
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidFinish`(kotlinCallbackInterface: SessionVerificationControllerDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        fun makeCall() : Int {
            kotlinCallbackInterface.`didFinish`(
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
}

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeSessionVerificationControllerDelegate: FfiConverterCallbackInterface<SessionVerificationControllerDelegate>(
    foreignCallback = ForeignCallbackTypeSessionVerificationControllerDelegate()
) {
    override fun register(lib: _UniFFILib) {
        rustCall() { status ->
            lib.ffi_matrix_sdk_ffi_a64_SessionVerificationControllerDelegate_init_callback(this.foreignCallback, status)
        }
    }
}






// Declaration and FfiConverters for SlidingSyncListRoomItemsObserver Callback Interface

public interface SlidingSyncListRoomItemsObserver {
    fun `didReceiveUpdate`()
    
}

// The ForeignCallback that is passed to Rust.
internal class ForeignCallbackTypeSlidingSyncListRoomItemsObserver : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeSlidingSyncListRoomItemsObserver.lift(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeSlidingSyncListRoomItemsObserver.drop(handle)
                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidReceiveUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidReceiveUpdate`(kotlinCallbackInterface: SlidingSyncListRoomItemsObserver, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        fun makeCall() : Int {
            kotlinCallbackInterface.`didReceiveUpdate`(
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
}

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeSlidingSyncListRoomItemsObserver: FfiConverterCallbackInterface<SlidingSyncListRoomItemsObserver>(
    foreignCallback = ForeignCallbackTypeSlidingSyncListRoomItemsObserver()
) {
    override fun register(lib: _UniFFILib) {
        rustCall() { status ->
            lib.ffi_matrix_sdk_ffi_a64_SlidingSyncListRoomItemsObserver_init_callback(this.foreignCallback, status)
        }
    }
}






// Declaration and FfiConverters for SlidingSyncListRoomListObserver Callback Interface

public interface SlidingSyncListRoomListObserver {
    fun `didReceiveUpdate`(`diff`: SlidingSyncListRoomsListDiff)
    
}

// The ForeignCallback that is passed to Rust.
internal class ForeignCallbackTypeSlidingSyncListRoomListObserver : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeSlidingSyncListRoomListObserver.lift(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeSlidingSyncListRoomListObserver.drop(handle)
                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidReceiveUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidReceiveUpdate`(kotlinCallbackInterface: SlidingSyncListRoomListObserver, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`didReceiveUpdate`(
                FfiConverterTypeSlidingSyncListRoomsListDiff.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
}

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeSlidingSyncListRoomListObserver: FfiConverterCallbackInterface<SlidingSyncListRoomListObserver>(
    foreignCallback = ForeignCallbackTypeSlidingSyncListRoomListObserver()
) {
    override fun register(lib: _UniFFILib) {
        rustCall() { status ->
            lib.ffi_matrix_sdk_ffi_a64_SlidingSyncListRoomListObserver_init_callback(this.foreignCallback, status)
        }
    }
}






// Declaration and FfiConverters for SlidingSyncListRoomsCountObserver Callback Interface

public interface SlidingSyncListRoomsCountObserver {
    fun `didReceiveUpdate`(`count`: UInt)
    
}

// The ForeignCallback that is passed to Rust.
internal class ForeignCallbackTypeSlidingSyncListRoomsCountObserver : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeSlidingSyncListRoomsCountObserver.lift(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeSlidingSyncListRoomsCountObserver.drop(handle)
                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidReceiveUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidReceiveUpdate`(kotlinCallbackInterface: SlidingSyncListRoomsCountObserver, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`didReceiveUpdate`(
                FfiConverterUInt.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
}

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeSlidingSyncListRoomsCountObserver: FfiConverterCallbackInterface<SlidingSyncListRoomsCountObserver>(
    foreignCallback = ForeignCallbackTypeSlidingSyncListRoomsCountObserver()
) {
    override fun register(lib: _UniFFILib) {
        rustCall() { status ->
            lib.ffi_matrix_sdk_ffi_a64_SlidingSyncListRoomsCountObserver_init_callback(this.foreignCallback, status)
        }
    }
}






// Declaration and FfiConverters for SlidingSyncListStateObserver Callback Interface

public interface SlidingSyncListStateObserver {
    fun `didReceiveUpdate`(`newState`: SlidingSyncState)
    
}

// The ForeignCallback that is passed to Rust.
internal class ForeignCallbackTypeSlidingSyncListStateObserver : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeSlidingSyncListStateObserver.lift(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeSlidingSyncListStateObserver.drop(handle)
                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidReceiveUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidReceiveUpdate`(kotlinCallbackInterface: SlidingSyncListStateObserver, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`didReceiveUpdate`(
                FfiConverterTypeSlidingSyncState.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
}

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeSlidingSyncListStateObserver: FfiConverterCallbackInterface<SlidingSyncListStateObserver>(
    foreignCallback = ForeignCallbackTypeSlidingSyncListStateObserver()
) {
    override fun register(lib: _UniFFILib) {
        rustCall() { status ->
            lib.ffi_matrix_sdk_ffi_a64_SlidingSyncListStateObserver_init_callback(this.foreignCallback, status)
        }
    }
}






// Declaration and FfiConverters for SlidingSyncObserver Callback Interface

public interface SlidingSyncObserver {
    fun `didReceiveSyncUpdate`(`summary`: UpdateSummary)
    
}

// The ForeignCallback that is passed to Rust.
internal class ForeignCallbackTypeSlidingSyncObserver : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeSlidingSyncObserver.lift(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeSlidingSyncObserver.drop(handle)
                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidReceiveSyncUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidReceiveSyncUpdate`(kotlinCallbackInterface: SlidingSyncObserver, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`didReceiveSyncUpdate`(
                FfiConverterTypeUpdateSummary.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
}

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeSlidingSyncObserver: FfiConverterCallbackInterface<SlidingSyncObserver>(
    foreignCallback = ForeignCallbackTypeSlidingSyncObserver()
) {
    override fun register(lib: _UniFFILib) {
        rustCall() { status ->
            lib.ffi_matrix_sdk_ffi_a64_SlidingSyncObserver_init_callback(this.foreignCallback, status)
        }
    }
}






// Declaration and FfiConverters for TimelineListener Callback Interface

public interface TimelineListener {
    fun `onUpdate`(`update`: TimelineDiff)
    
}

// The ForeignCallback that is passed to Rust.
internal class ForeignCallbackTypeTimelineListener : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeTimelineListener.lift(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeTimelineListener.drop(handle)
                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnUpdate`(kotlinCallbackInterface: TimelineListener, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`onUpdate`(
                FfiConverterTypeTimelineDiff.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
}

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeTimelineListener: FfiConverterCallbackInterface<TimelineListener>(
    foreignCallback = ForeignCallbackTypeTimelineListener()
) {
    override fun register(lib: _UniFFILib) {
        rustCall() { status ->
            lib.ffi_matrix_sdk_ffi_a64_TimelineListener_init_callback(this.foreignCallback, status)
        }
    }
}




public object FfiConverterOptionalUInt: FfiConverterRustBuffer<UInt?> {
    override fun read(buf: ByteBuffer): UInt? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterUInt.read(buf)
    }

    override fun allocationSize(value: UInt?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterUInt.allocationSize(value)
        }
    }

    override fun write(value: UInt?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterUInt.write(value, buf)
        }
    }
}




public object FfiConverterOptionalInt: FfiConverterRustBuffer<Int?> {
    override fun read(buf: ByteBuffer): Int? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterInt.read(buf)
    }

    override fun allocationSize(value: Int?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterInt.allocationSize(value)
        }
    }

    override fun write(value: Int?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterInt.write(value, buf)
        }
    }
}




public object FfiConverterOptionalULong: FfiConverterRustBuffer<ULong?> {
    override fun read(buf: ByteBuffer): ULong? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterULong.read(buf)
    }

    override fun allocationSize(value: ULong?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterULong.allocationSize(value)
        }
    }

    override fun write(value: ULong?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterULong.write(value, buf)
        }
    }
}




public object FfiConverterOptionalBoolean: FfiConverterRustBuffer<Boolean?> {
    override fun read(buf: ByteBuffer): Boolean? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterBoolean.read(buf)
    }

    override fun allocationSize(value: Boolean?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterBoolean.allocationSize(value)
        }
    }

    override fun write(value: Boolean?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterBoolean.write(value, buf)
        }
    }
}




public object FfiConverterOptionalString: FfiConverterRustBuffer<String?> {
    override fun read(buf: ByteBuffer): String? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterString.read(buf)
    }

    override fun allocationSize(value: String?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterString.allocationSize(value)
        }
    }

    override fun write(value: String?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterString.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeEventTimelineItem: FfiConverterRustBuffer<EventTimelineItem?> {
    override fun read(buf: ByteBuffer): EventTimelineItem? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeEventTimelineItem.read(buf)
    }

    override fun allocationSize(value: EventTimelineItem?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeEventTimelineItem.allocationSize(value)
        }
    }

    override fun write(value: EventTimelineItem?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeEventTimelineItem.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeHomeserverLoginDetails: FfiConverterRustBuffer<HomeserverLoginDetails?> {
    override fun read(buf: ByteBuffer): HomeserverLoginDetails? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeHomeserverLoginDetails.read(buf)
    }

    override fun allocationSize(value: HomeserverLoginDetails?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeHomeserverLoginDetails.allocationSize(value)
        }
    }

    override fun write(value: HomeserverLoginDetails?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeHomeserverLoginDetails.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeMediaSource: FfiConverterRustBuffer<MediaSource?> {
    override fun read(buf: ByteBuffer): MediaSource? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeMediaSource.read(buf)
    }

    override fun allocationSize(value: MediaSource?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeMediaSource.allocationSize(value)
        }
    }

    override fun write(value: MediaSource?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeMediaSource.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeMessage: FfiConverterRustBuffer<Message?> {
    override fun read(buf: ByteBuffer): Message? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeMessage.read(buf)
    }

    override fun allocationSize(value: Message?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeMessage.allocationSize(value)
        }
    }

    override fun write(value: Message?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeMessage.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeRoom: FfiConverterRustBuffer<Room?> {
    override fun read(buf: ByteBuffer): Room? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeRoom.read(buf)
    }

    override fun allocationSize(value: Room?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeRoom.allocationSize(value)
        }
    }

    override fun write(value: Room?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeRoom.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeRoomMember: FfiConverterRustBuffer<RoomMember?> {
    override fun read(buf: ByteBuffer): RoomMember? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeRoomMember.read(buf)
    }

    override fun allocationSize(value: RoomMember?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeRoomMember.allocationSize(value)
        }
    }

    override fun write(value: RoomMember?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeRoomMember.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeSlidingSyncList: FfiConverterRustBuffer<SlidingSyncList?> {
    override fun read(buf: ByteBuffer): SlidingSyncList? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeSlidingSyncList.read(buf)
    }

    override fun allocationSize(value: SlidingSyncList?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeSlidingSyncList.allocationSize(value)
        }
    }

    override fun write(value: SlidingSyncList?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeSlidingSyncList.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeSlidingSyncRoom: FfiConverterRustBuffer<SlidingSyncRoom?> {
    override fun read(buf: ByteBuffer): SlidingSyncRoom? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeSlidingSyncRoom.read(buf)
    }

    override fun allocationSize(value: SlidingSyncRoom?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeSlidingSyncRoom.allocationSize(value)
        }
    }

    override fun write(value: SlidingSyncRoom?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeSlidingSyncRoom.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeTimelineItem: FfiConverterRustBuffer<TimelineItem?> {
    override fun read(buf: ByteBuffer): TimelineItem? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeTimelineItem.read(buf)
    }

    override fun allocationSize(value: TimelineItem?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeTimelineItem.allocationSize(value)
        }
    }

    override fun write(value: TimelineItem?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeTimelineItem.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeAudioInfo: FfiConverterRustBuffer<AudioInfo?> {
    override fun read(buf: ByteBuffer): AudioInfo? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeAudioInfo.read(buf)
    }

    override fun allocationSize(value: AudioInfo?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeAudioInfo.allocationSize(value)
        }
    }

    override fun write(value: AudioInfo?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeAudioInfo.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeFileInfo: FfiConverterRustBuffer<FileInfo?> {
    override fun read(buf: ByteBuffer): FileInfo? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeFileInfo.read(buf)
    }

    override fun allocationSize(value: FileInfo?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeFileInfo.allocationSize(value)
        }
    }

    override fun write(value: FileInfo?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeFileInfo.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeFormattedBody: FfiConverterRustBuffer<FormattedBody?> {
    override fun read(buf: ByteBuffer): FormattedBody? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeFormattedBody.read(buf)
    }

    override fun allocationSize(value: FormattedBody?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeFormattedBody.allocationSize(value)
        }
    }

    override fun write(value: FormattedBody?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeFormattedBody.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeImageInfo: FfiConverterRustBuffer<ImageInfo?> {
    override fun read(buf: ByteBuffer): ImageInfo? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeImageInfo.read(buf)
    }

    override fun allocationSize(value: ImageInfo?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeImageInfo.allocationSize(value)
        }
    }

    override fun write(value: ImageInfo?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeImageInfo.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeInReplyToDetails: FfiConverterRustBuffer<InReplyToDetails?> {
    override fun read(buf: ByteBuffer): InReplyToDetails? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeInReplyToDetails.read(buf)
    }

    override fun allocationSize(value: InReplyToDetails?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeInReplyToDetails.allocationSize(value)
        }
    }

    override fun write(value: InReplyToDetails?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeInReplyToDetails.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeInsertData: FfiConverterRustBuffer<InsertData?> {
    override fun read(buf: ByteBuffer): InsertData? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeInsertData.read(buf)
    }

    override fun allocationSize(value: InsertData?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeInsertData.allocationSize(value)
        }
    }

    override fun write(value: InsertData?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeInsertData.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeNotificationItem: FfiConverterRustBuffer<NotificationItem?> {
    override fun read(buf: ByteBuffer): NotificationItem? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeNotificationItem.read(buf)
    }

    override fun allocationSize(value: NotificationItem?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeNotificationItem.allocationSize(value)
        }
    }

    override fun write(value: NotificationItem?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeNotificationItem.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeRoomSubscription: FfiConverterRustBuffer<RoomSubscription?> {
    override fun read(buf: ByteBuffer): RoomSubscription? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeRoomSubscription.read(buf)
    }

    override fun allocationSize(value: RoomSubscription?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeRoomSubscription.allocationSize(value)
        }
    }

    override fun write(value: RoomSubscription?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeRoomSubscription.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeSetData: FfiConverterRustBuffer<SetData?> {
    override fun read(buf: ByteBuffer): SetData? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeSetData.read(buf)
    }

    override fun allocationSize(value: SetData?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeSetData.allocationSize(value)
        }
    }

    override fun write(value: SetData?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeSetData.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeThumbnailInfo: FfiConverterRustBuffer<ThumbnailInfo?> {
    override fun read(buf: ByteBuffer): ThumbnailInfo? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeThumbnailInfo.read(buf)
    }

    override fun allocationSize(value: ThumbnailInfo?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeThumbnailInfo.allocationSize(value)
        }
    }

    override fun write(value: ThumbnailInfo?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeThumbnailInfo.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeVideoInfo: FfiConverterRustBuffer<VideoInfo?> {
    override fun read(buf: ByteBuffer): VideoInfo? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeVideoInfo.read(buf)
    }

    override fun allocationSize(value: VideoInfo?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeVideoInfo.allocationSize(value)
        }
    }

    override fun write(value: VideoInfo?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeVideoInfo.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeEventSendState: FfiConverterRustBuffer<EventSendState?> {
    override fun read(buf: ByteBuffer): EventSendState? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeEventSendState.read(buf)
    }

    override fun allocationSize(value: EventSendState?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeEventSendState.allocationSize(value)
        }
    }

    override fun write(value: EventSendState?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeEventSendState.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeMembershipChange: FfiConverterRustBuffer<MembershipChange?> {
    override fun read(buf: ByteBuffer): MembershipChange? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeMembershipChange.read(buf)
    }

    override fun allocationSize(value: MembershipChange?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeMembershipChange.allocationSize(value)
        }
    }

    override fun write(value: MembershipChange?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeMembershipChange.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeMessageType: FfiConverterRustBuffer<MessageType?> {
    override fun read(buf: ByteBuffer): MessageType? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeMessageType.read(buf)
    }

    override fun allocationSize(value: MessageType?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeMessageType.allocationSize(value)
        }
    }

    override fun write(value: MessageType?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeMessageType.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypePushFormat: FfiConverterRustBuffer<PushFormat?> {
    override fun read(buf: ByteBuffer): PushFormat? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypePushFormat.read(buf)
    }

    override fun allocationSize(value: PushFormat?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypePushFormat.allocationSize(value)
        }
    }

    override fun write(value: PushFormat?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypePushFormat.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeVirtualTimelineItem: FfiConverterRustBuffer<VirtualTimelineItem?> {
    override fun read(buf: ByteBuffer): VirtualTimelineItem? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeVirtualTimelineItem.read(buf)
    }

    override fun allocationSize(value: VirtualTimelineItem?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeVirtualTimelineItem.allocationSize(value)
        }
    }

    override fun write(value: VirtualTimelineItem?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeVirtualTimelineItem.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeClientDelegate: FfiConverterRustBuffer<ClientDelegate?> {
    override fun read(buf: ByteBuffer): ClientDelegate? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeClientDelegate.read(buf)
    }

    override fun allocationSize(value: ClientDelegate?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeClientDelegate.allocationSize(value)
        }
    }

    override fun write(value: ClientDelegate?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeClientDelegate.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeSessionVerificationControllerDelegate: FfiConverterRustBuffer<SessionVerificationControllerDelegate?> {
    override fun read(buf: ByteBuffer): SessionVerificationControllerDelegate? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeSessionVerificationControllerDelegate.read(buf)
    }

    override fun allocationSize(value: SessionVerificationControllerDelegate?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeSessionVerificationControllerDelegate.allocationSize(value)
        }
    }

    override fun write(value: SessionVerificationControllerDelegate?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeSessionVerificationControllerDelegate.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeSlidingSyncObserver: FfiConverterRustBuffer<SlidingSyncObserver?> {
    override fun read(buf: ByteBuffer): SlidingSyncObserver? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeSlidingSyncObserver.read(buf)
    }

    override fun allocationSize(value: SlidingSyncObserver?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeSlidingSyncObserver.allocationSize(value)
        }
    }

    override fun write(value: SlidingSyncObserver?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeSlidingSyncObserver.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceString: FfiConverterRustBuffer<List<String>?> {
    override fun read(buf: ByteBuffer): List<String>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceString.read(buf)
    }

    override fun allocationSize(value: List<String>?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterSequenceString.allocationSize(value)
        }
    }

    override fun write(value: List<String>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceString.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceTypeTimelineItem: FfiConverterRustBuffer<List<TimelineItem>?> {
    override fun read(buf: ByteBuffer): List<TimelineItem>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeTimelineItem.read(buf)
    }

    override fun allocationSize(value: List<TimelineItem>?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterSequenceTypeTimelineItem.allocationSize(value)
        }
    }

    override fun write(value: List<TimelineItem>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeTimelineItem.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceTypeRequiredState: FfiConverterRustBuffer<List<RequiredState>?> {
    override fun read(buf: ByteBuffer): List<RequiredState>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeRequiredState.read(buf)
    }

    override fun allocationSize(value: List<RequiredState>?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterSequenceTypeRequiredState.allocationSize(value)
        }
    }

    override fun write(value: List<RequiredState>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeRequiredState.write(value, buf)
        }
    }
}




public object FfiConverterSequenceUByte: FfiConverterRustBuffer<List<UByte>> {
    override fun read(buf: ByteBuffer): List<UByte> {
        val len = buf.getInt()
        return List<UByte>(len) {
            FfiConverterUByte.read(buf)
        }
    }

    override fun allocationSize(value: List<UByte>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterUByte.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<UByte>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterUByte.write(it, buf)
        }
    }
}




public object FfiConverterSequenceString: FfiConverterRustBuffer<List<String>> {
    override fun read(buf: ByteBuffer): List<String> {
        val len = buf.getInt()
        return List<String>(len) {
            FfiConverterString.read(buf)
        }
    }

    override fun allocationSize(value: List<String>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterString.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<String>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterString.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeRoom: FfiConverterRustBuffer<List<Room>> {
    override fun read(buf: ByteBuffer): List<Room> {
        val len = buf.getInt()
        return List<Room>(len) {
            FfiConverterTypeRoom.read(buf)
        }
    }

    override fun allocationSize(value: List<Room>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeRoom.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<Room>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeRoom.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeRoomMember: FfiConverterRustBuffer<List<RoomMember>> {
    override fun read(buf: ByteBuffer): List<RoomMember> {
        val len = buf.getInt()
        return List<RoomMember>(len) {
            FfiConverterTypeRoomMember.read(buf)
        }
    }

    override fun allocationSize(value: List<RoomMember>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeRoomMember.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<RoomMember>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeRoomMember.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeSessionVerificationEmoji: FfiConverterRustBuffer<List<SessionVerificationEmoji>> {
    override fun read(buf: ByteBuffer): List<SessionVerificationEmoji> {
        val len = buf.getInt()
        return List<SessionVerificationEmoji>(len) {
            FfiConverterTypeSessionVerificationEmoji.read(buf)
        }
    }

    override fun allocationSize(value: List<SessionVerificationEmoji>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeSessionVerificationEmoji.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<SessionVerificationEmoji>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeSessionVerificationEmoji.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeTimelineItem: FfiConverterRustBuffer<List<TimelineItem>> {
    override fun read(buf: ByteBuffer): List<TimelineItem> {
        val len = buf.getInt()
        return List<TimelineItem>(len) {
            FfiConverterTypeTimelineItem.read(buf)
        }
    }

    override fun allocationSize(value: List<TimelineItem>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeTimelineItem.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<TimelineItem>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeTimelineItem.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeReaction: FfiConverterRustBuffer<List<Reaction>> {
    override fun read(buf: ByteBuffer): List<Reaction> {
        val len = buf.getInt()
        return List<Reaction>(len) {
            FfiConverterTypeReaction.read(buf)
        }
    }

    override fun allocationSize(value: List<Reaction>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeReaction.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<Reaction>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeReaction.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeRequiredState: FfiConverterRustBuffer<List<RequiredState>> {
    override fun read(buf: ByteBuffer): List<RequiredState> {
        val len = buf.getInt()
        return List<RequiredState>(len) {
            FfiConverterTypeRequiredState.read(buf)
        }
    }

    override fun allocationSize(value: List<RequiredState>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeRequiredState.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<RequiredState>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeRequiredState.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeUserProfile: FfiConverterRustBuffer<List<UserProfile>> {
    override fun read(buf: ByteBuffer): List<UserProfile> {
        val len = buf.getInt()
        return List<UserProfile>(len) {
            FfiConverterTypeUserProfile.read(buf)
        }
    }

    override fun allocationSize(value: List<UserProfile>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeUserProfile.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<UserProfile>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeUserProfile.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeRoomListEntry: FfiConverterRustBuffer<List<RoomListEntry>> {
    override fun read(buf: ByteBuffer): List<RoomListEntry> {
        val len = buf.getInt()
        return List<RoomListEntry>(len) {
            FfiConverterTypeRoomListEntry.read(buf)
        }
    }

    override fun allocationSize(value: List<RoomListEntry>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeRoomListEntry.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<RoomListEntry>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeRoomListEntry.write(it, buf)
        }
    }
}




public object FfiConverterSequenceOptionalTypeSlidingSyncRoom: FfiConverterRustBuffer<List<SlidingSyncRoom?>> {
    override fun read(buf: ByteBuffer): List<SlidingSyncRoom?> {
        val len = buf.getInt()
        return List<SlidingSyncRoom?>(len) {
            FfiConverterOptionalTypeSlidingSyncRoom.read(buf)
        }
    }

    override fun allocationSize(value: List<SlidingSyncRoom?>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterOptionalTypeSlidingSyncRoom.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<SlidingSyncRoom?>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterOptionalTypeSlidingSyncRoom.write(it, buf)
        }
    }
}

        fun `genTransactionId`(): String {
            return FfiConverterString.lift(
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_gen_transaction_id_4593( _status)
})
        }
    

        fun `logEvent`(`file`: String, `line`: UInt, `column`: UInt, `level`: LogLevel, `target`: String, `message`: String) =
            
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_log_event_374d(FfiConverterString.lower(`file`), FfiConverterUInt.lower(`line`), FfiConverterUInt.lower(`column`), FfiConverterTypeLogLevel.lower(`level`), FfiConverterString.lower(`target`), FfiConverterString.lower(`message`), _status)
}

    

        fun `mediaSourceFromUrl`(`url`: String): MediaSource {
            return FfiConverterTypeMediaSource.lift(
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_media_source_from_url_3a26(FfiConverterString.lower(`url`), _status)
})
        }
    

        fun `messageEventContentFromMarkdown`(`md`: String): RoomMessageEventContent {
            return FfiConverterTypeRoomMessageEventContent.lift(
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_message_event_content_from_markdown_df5b(FfiConverterString.lower(`md`), _status)
})
        }
    

        fun `setupOtlpTracing`(`filter`: String, `clientName`: String, `user`: String, `password`: String, `otlpEndpoint`: String) =
            
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_setup_otlp_tracing_5801(FfiConverterString.lower(`filter`), FfiConverterString.lower(`clientName`), FfiConverterString.lower(`user`), FfiConverterString.lower(`password`), FfiConverterString.lower(`otlpEndpoint`), _status)
}

    

        fun `setupTracing`(`filter`: String) =
            
    rustCall() { _status ->
    _UniFFILib.INSTANCE._uniffi_matrix_sdk_ffi_setup_tracing_ac08(FfiConverterString.lower(`filter`), _status)
}

    

