// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("NAME_SHADOWING")

package org.matrix.rustcomponents.sdk;

// Common helper code.
//
// Ideally this would live in a separate .kt file where it can be unittested etc
// in isolation, and perhaps even published as a re-useable package.
//
// However, it's important that the detils of how this helper code works (e.g. the
// way that different builtin types are passed across the FFI) exactly match what's
// expected by the Rust code on the other side of the interface. In practice right
// now that means coming from the exact some version of `uniffi` that was used to
// compile the Rust component. The easiest way to ensure this is to bundle the Kotlin
// helpers directly inline like we're doing here.

import com.sun.jna.Library
import com.sun.jna.IntegerType
import com.sun.jna.Native
import com.sun.jna.Pointer
import com.sun.jna.Structure
import com.sun.jna.Callback
import com.sun.jna.ptr.*
import java.nio.ByteBuffer
import java.nio.ByteOrder
import java.util.concurrent.ConcurrentHashMap
import java.util.concurrent.atomic.AtomicBoolean
import java.util.concurrent.atomic.AtomicLong
import java.util.concurrent.locks.ReentrantLock
import kotlin.concurrent.withLock
import kotlin.coroutines.Continuation
import kotlin.coroutines.resume
import kotlin.coroutines.resumeWithException
import kotlin.coroutines.suspendCoroutine
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.coroutineScope
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

// This is a helper for safely working with byte buffers returned from the Rust code.
// A rust-owned buffer is represented by its capacity, its current length, and a
// pointer to the underlying data.

@Structure.FieldOrder("capacity", "len", "data")
open class RustBuffer : Structure() {
    @JvmField var capacity: Int = 0
    @JvmField var len: Int = 0
    @JvmField var data: Pointer? = null

    class ByValue: RustBuffer(), Structure.ByValue
    class ByReference: RustBuffer(), Structure.ByReference

    companion object {
        internal fun alloc(size: Int = 0) = rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rustbuffer_alloc(size, status).also {
                if(it.data == null) {
                   throw RuntimeException("RustBuffer.alloc() returned null data pointer (size=${size})")
               }
            }
        }

        internal fun free(buf: RustBuffer.ByValue) = rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rustbuffer_free(buf, status)
        }
    }

    @Suppress("TooGenericExceptionThrown")
    fun asByteBuffer() =
        this.data?.getByteBuffer(0, this.len.toLong())?.also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
}

/**
 * The equivalent of the `*mut RustBuffer` type.
 * Required for callbacks taking in an out pointer.
 *
 * Size is the sum of all values in the struct.
 */
class RustBufferByReference : ByReference(16) {
    /**
     * Set the pointed-to `RustBuffer` to the given value.
     */
    fun setValue(value: RustBuffer.ByValue) {
        // NOTE: The offsets are as they are in the C-like struct.
        val pointer = getPointer()
        pointer.setInt(0, value.capacity)
        pointer.setInt(4, value.len)
        pointer.setPointer(8, value.data)
    }

    /**
     * Get a `RustBuffer.ByValue` from this reference.
     */
    fun getValue(): RustBuffer.ByValue {
        val pointer = getPointer()
        val value = RustBuffer.ByValue()
        value.writeField("capacity", pointer.getInt(0))
        value.writeField("len", pointer.getInt(4))
        value.writeField("data", pointer.getPointer(8))

        return value
    }
}

// This is a helper for safely passing byte references into the rust code.
// It's not actually used at the moment, because there aren't many things that you
// can take a direct pointer to in the JVM, and if we're going to copy something
// then we might as well copy it into a `RustBuffer`. But it's here for API
// completeness.

@Structure.FieldOrder("len", "data")
open class ForeignBytes : Structure() {
    @JvmField var len: Int = 0
    @JvmField var data: Pointer? = null

    class ByValue : ForeignBytes(), Structure.ByValue
}
// The FfiConverter interface handles converter types to and from the FFI
//
// All implementing objects should be public to support external types.  When a
// type is external we need to import it's FfiConverter.
public interface FfiConverter<KotlinType, FfiType> {
    // Convert an FFI type to a Kotlin type
    fun lift(value: FfiType): KotlinType

    // Convert an Kotlin type to an FFI type
    fun lower(value: KotlinType): FfiType

    // Read a Kotlin type from a `ByteBuffer`
    fun read(buf: ByteBuffer): KotlinType

    // Calculate bytes to allocate when creating a `RustBuffer`
    //
    // This must return at least as many bytes as the write() function will
    // write. It can return more bytes than needed, for example when writing
    // Strings we can't know the exact bytes needed until we the UTF-8
    // encoding, so we pessimistically allocate the largest size possible (3
    // bytes per codepoint).  Allocating extra bytes is not really a big deal
    // because the `RustBuffer` is short-lived.
    fun allocationSize(value: KotlinType): Int

    // Write a Kotlin type to a `ByteBuffer`
    fun write(value: KotlinType, buf: ByteBuffer)

    // Lower a value into a `RustBuffer`
    //
    // This method lowers a value into a `RustBuffer` rather than the normal
    // FfiType.  It's used by the callback interface code.  Callback interface
    // returns are always serialized into a `RustBuffer` regardless of their
    // normal FFI type.
    fun lowerIntoRustBuffer(value: KotlinType): RustBuffer.ByValue {
        val rbuf = RustBuffer.alloc(allocationSize(value))
        try {
            val bbuf = rbuf.data!!.getByteBuffer(0, rbuf.capacity.toLong()).also {
                it.order(ByteOrder.BIG_ENDIAN)
            }
            write(value, bbuf)
            rbuf.writeField("len", bbuf.position())
            return rbuf
        } catch (e: Throwable) {
            RustBuffer.free(rbuf)
            throw e
        }
    }

    // Lift a value from a `RustBuffer`.
    //
    // This here mostly because of the symmetry with `lowerIntoRustBuffer()`.
    // It's currently only used by the `FfiConverterRustBuffer` class below.
    fun liftFromRustBuffer(rbuf: RustBuffer.ByValue): KotlinType {
        val byteBuf = rbuf.asByteBuffer()!!
        try {
           val item = read(byteBuf)
           if (byteBuf.hasRemaining()) {
               throw RuntimeException("junk remaining in buffer after lifting, something is very wrong!!")
           }
           return item
        } finally {
            RustBuffer.free(rbuf)
        }
    }
}

// FfiConverter that uses `RustBuffer` as the FfiType
public interface FfiConverterRustBuffer<KotlinType>: FfiConverter<KotlinType, RustBuffer.ByValue> {
    override fun lift(value: RustBuffer.ByValue) = liftFromRustBuffer(value)
    override fun lower(value: KotlinType) = lowerIntoRustBuffer(value)
}
// A handful of classes and functions to support the generated data structures.
// This would be a good candidate for isolating in its own ffi-support lib.
// Error runtime.
@Structure.FieldOrder("code", "error_buf")
internal open class RustCallStatus : Structure() {
    @JvmField var code: Byte = 0
    @JvmField var error_buf: RustBuffer.ByValue = RustBuffer.ByValue()

    class ByValue: RustCallStatus(), Structure.ByValue

    fun isSuccess(): Boolean {
        return code == 0.toByte()
    }

    fun isError(): Boolean {
        return code == 1.toByte()
    }

    fun isPanic(): Boolean {
        return code == 2.toByte()
    }
}

class InternalException(message: String) : Exception(message)

// Each top-level error class has a companion object that can lift the error from the call status's rust buffer
interface CallStatusErrorHandler<E> {
    fun lift(error_buf: RustBuffer.ByValue): E;
}

// Helpers for calling Rust
// In practice we usually need to be synchronized to call this safely, so it doesn't
// synchronize itself

// Call a rust function that returns a Result<>.  Pass in the Error class companion that corresponds to the Err
private inline fun <U, E: Exception> rustCallWithError(errorHandler: CallStatusErrorHandler<E>, callback: (RustCallStatus) -> U): U {
    var status = RustCallStatus();
    val return_value = callback(status)
    checkCallStatus(errorHandler, status)
    return return_value
}

// Check RustCallStatus and throw an error if the call wasn't successful
private fun<E: Exception> checkCallStatus(errorHandler: CallStatusErrorHandler<E>, status: RustCallStatus) {
    if (status.isSuccess()) {
        return
    } else if (status.isError()) {
        throw errorHandler.lift(status.error_buf)
    } else if (status.isPanic()) {
        // when the rust code sees a panic, it tries to construct a rustbuffer
        // with the message.  but if that code panics, then it just sends back
        // an empty buffer.
        if (status.error_buf.len > 0) {
            throw InternalException(FfiConverterString.lift(status.error_buf))
        } else {
            throw InternalException("Rust panic")
        }
    } else {
        throw InternalException("Unknown rust call status: $status.code")
    }
}

// CallStatusErrorHandler implementation for times when we don't expect a CALL_ERROR
object NullCallStatusErrorHandler: CallStatusErrorHandler<InternalException> {
    override fun lift(error_buf: RustBuffer.ByValue): InternalException {
        RustBuffer.free(error_buf)
        return InternalException("Unexpected CALL_ERROR")
    }
}

// Call a rust function that returns a plain value
private inline fun <U> rustCall(callback: (RustCallStatus) -> U): U {
    return rustCallWithError(NullCallStatusErrorHandler, callback);
}

// IntegerType that matches Rust's `usize` / C's `size_t`
public class USize(value: Long = 0) : IntegerType(Native.SIZE_T_SIZE, value, true) {
    // This is needed to fill in the gaps of IntegerType's implementation of Number for Kotlin.
    override fun toByte() = toInt().toByte()
    override fun toChar() = toInt().toChar()
    override fun toShort() = toInt().toShort()

    fun writeToBuffer(buf: ByteBuffer) {
        // Make sure we always write usize integers using native byte-order, since they may be
        // casted to pointer values
        buf.order(ByteOrder.nativeOrder())
        try {
            when (Native.SIZE_T_SIZE) {
                4 -> buf.putInt(toInt())
                8 -> buf.putLong(toLong())
                else -> throw RuntimeException("Invalid SIZE_T_SIZE: ${Native.SIZE_T_SIZE}")
            }
        } finally {
            buf.order(ByteOrder.BIG_ENDIAN)
        }
    }

    companion object {
        val size: Int
            get() = Native.SIZE_T_SIZE

        fun readFromBuffer(buf: ByteBuffer) : USize {
            // Make sure we always read usize integers using native byte-order, since they may be
            // casted from pointer values
            buf.order(ByteOrder.nativeOrder())
            try {
                return when (Native.SIZE_T_SIZE) {
                    4 -> USize(buf.getInt().toLong())
                    8 -> USize(buf.getLong())
                    else -> throw RuntimeException("Invalid SIZE_T_SIZE: ${Native.SIZE_T_SIZE}")
                }
            } finally {
                buf.order(ByteOrder.BIG_ENDIAN)
            }
        }
    }
}


// Map handles to objects
//
// This is used when the Rust code expects an opaque pointer to represent some foreign object.
// Normally we would pass a pointer to the object, but JNA doesn't support getting a pointer from an
// object reference , nor does it support leaking a reference to Rust.
//
// Instead, this class maps USize values to objects so that we can pass a pointer-sized type to
// Rust when it needs an opaque pointer.
//
// TODO: refactor callbacks to use this class
internal class UniFfiHandleMap<T: Any> {
    private val map = ConcurrentHashMap<USize, T>()
    // Use AtomicInteger for our counter, since we may be on a 32-bit system.  4 billion possible
    // values seems like enough. If somehow we generate 4 billion handles, then this will wrap
    // around back to zero and we can assume the first handle generated will have been dropped by
    // then.
    private val counter = java.util.concurrent.atomic.AtomicInteger(0)

    val size: Int
        get() = map.size

    fun insert(obj: T): USize {
        val handle = USize(counter.getAndAdd(1).toLong())
        map.put(handle, obj)
        return handle
    }

    fun get(handle: USize): T? {
        return map.get(handle)
    }

    fun remove(handle: USize) {
        map.remove(handle)
    }
}

// Contains loading, initialization code,
// and the FFI Function declarations in a com.sun.jna.Library.
@Synchronized
private fun findLibraryName(componentName: String): String {
    val libOverride = System.getProperty("uniffi.component.$componentName.libraryOverride")
    if (libOverride != null) {
        return libOverride
    }
    return "matrix_sdk_ffi"
}

private inline fun <reified Lib : Library> loadIndirect(
    componentName: String
): Lib {
    return Native.load<Lib>(findLibraryName(componentName), Lib::class.java)
}

// A JNA Library to expose the extern-C FFI definitions.
// This is an implementation detail which will be called internally by the public API.

internal interface _UniFFILib : Library {
    companion object {
        internal val INSTANCE: _UniFFILib by lazy {
            loadIndirect<_UniFFILib>(componentName = "matrix_sdk_ffi")
            .also { lib: _UniFFILib ->
                uniffiCheckContractApiVersion(lib)
                uniffiCheckApiChecksums(lib)
                FfiConverterForeignExecutor.register(lib)
                FfiConverterTypeBackPaginationStatusListener.register(lib)
                FfiConverterTypeClientDelegate.register(lib)
                FfiConverterTypeNotificationSettingsDelegate.register(lib)
                FfiConverterTypeProgressWatcher.register(lib)
                FfiConverterTypeRoomListEntriesListener.register(lib)
                FfiConverterTypeRoomListLoadingStateListener.register(lib)
                FfiConverterTypeRoomListServiceStateListener.register(lib)
                FfiConverterTypeSessionVerificationControllerDelegate.register(lib)
                FfiConverterTypeSyncServiceStateObserver.register(lib)
                FfiConverterTypeTimelineListener.register(lib)
                }
        }
    }

    fun uniffi_matrix_sdk_ffi_fn_free_mediasource(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_constructor_mediasource_from_json(`json`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_mediasource_to_json(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_mediasource_url(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_roommessageeventcontent(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_free_authenticationservice(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_constructor_authenticationservice_new(`basePath`: RustBuffer.ByValue,`passphrase`: RustBuffer.ByValue,`userAgent`: RustBuffer.ByValue,`customSlidingSyncProxy`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_authenticationservice_configure_homeserver(`ptr`: Pointer,`serverNameOrHomeserverUrl`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_authenticationservice_homeserver_details(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_authenticationservice_login(`ptr`: Pointer,`username`: RustBuffer.ByValue,`password`: RustBuffer.ByValue,`initialDeviceName`: RustBuffer.ByValue,`deviceId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_authenticationservice_restore_with_access_token(`ptr`: Pointer,`token`: RustBuffer.ByValue,`deviceId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_client(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_account_data(`ptr`: Pointer,`eventType`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_avatar_url(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_cached_avatar_url(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_create_room(`ptr`: Pointer,`request`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_device_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_display_name(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_dm_room(`ptr`: Pointer,`userId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_media_content(`ptr`: Pointer,`mediaSource`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_media_file(`ptr`: Pointer,`mediaSource`: Pointer,`body`: RustBuffer.ByValue,`mimeType`: RustBuffer.ByValue,`tempDir`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_media_thumbnail(`ptr`: Pointer,`mediaSource`: Pointer,`width`: Long,`height`: Long,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_notification_settings(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_profile(`ptr`: Pointer,`userId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_session_verification_controller(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_client_homeserver(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_ignore_user(`ptr`: Pointer,`userId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_login(`ptr`: Pointer,`username`: RustBuffer.ByValue,`password`: RustBuffer.ByValue,`initialDeviceName`: RustBuffer.ByValue,`deviceId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_logout(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_notification_client(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_client_restore_session(`ptr`: Pointer,`session`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_rooms(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_search_users(`ptr`: Pointer,`searchTerm`: RustBuffer.ByValue,`limit`: Long,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_session(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_set_account_data(`ptr`: Pointer,`eventType`: RustBuffer.ByValue,`content`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_set_delegate(`ptr`: Pointer,`delegate`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_set_display_name(`ptr`: Pointer,`name`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_set_pusher(`ptr`: Pointer,`identifiers`: RustBuffer.ByValue,`kind`: RustBuffer.ByValue,`appDisplayName`: RustBuffer.ByValue,`deviceDisplayName`: RustBuffer.ByValue,`profileTag`: RustBuffer.ByValue,`lang`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_sync_service(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_client_unignore_user(`ptr`: Pointer,`userId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_upload_media(`ptr`: Pointer,`mimeType`: RustBuffer.ByValue,`data`: RustBuffer.ByValue,`progressWatcher`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_user_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_clientbuilder(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_constructor_clientbuilder_new(_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_base_path(`ptr`: Pointer,`path`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_build(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_disable_ssl_verification(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_homeserver_url(`ptr`: Pointer,`url`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_passphrase(`ptr`: Pointer,`passphrase`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_proxy(`ptr`: Pointer,`url`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_server_name(`ptr`: Pointer,`serverName`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_server_versions(`ptr`: Pointer,`versions`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_sliding_sync_proxy(`ptr`: Pointer,`slidingSyncProxy`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_user_agent(`ptr`: Pointer,`userAgent`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_username(`ptr`: Pointer,`username`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_eventtimelineitem(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_content(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_debug_info(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_event_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_editable(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_local(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_own(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_remote(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_local_send_state(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_origin(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_reactions(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_read_receipts(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_sender(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_sender_profile(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_timestamp(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_transaction_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_homeserverlogindetails(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_homeserverlogindetails_authentication_issuer(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_homeserverlogindetails_supports_password_login(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_homeserverlogindetails_url(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_mediafilehandle(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_mediafilehandle_path(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_message(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_message_body(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_message_in_reply_to(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_message_is_edited(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_message_msgtype(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_notificationclient(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationclient_get_notification(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`eventId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_notificationclientbuilder(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationclientbuilder_filter_by_push_rules(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_notificationclientbuilder_finish(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_notificationclientbuilder_retry_decryption(`ptr`: Pointer,`withCrossProcessLock`: Byte,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_notificationsettings(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_contains_keywords_rules(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_get_default_room_notification_mode(`ptr`: Pointer,`isEncrypted`: Byte,`activeMembersCount`: Long,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_get_room_notification_settings(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`isEncrypted`: Byte,`activeMembersCount`: Long,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_call_enabled(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_room_mention_enabled(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_user_mention_enabled(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_restore_default_room_notification_mode(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_call_enabled(`ptr`: Pointer,`enabled`: Byte,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_delegate(`ptr`: Pointer,`delegate`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_room_mention_enabled(`ptr`: Pointer,`enabled`: Byte,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_room_notification_mode(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`mode`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_user_mention_enabled(`ptr`: Pointer,`enabled`: Byte,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_unmute_room(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`isEncrypted`: Byte,`membersCount`: Long,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_free_room(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_active_members_count(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_add_timeline_listener(`ptr`: Pointer,`listener`: Long,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_alternative_aliases(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_avatar_url(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_ban(`ptr`: Pointer,`userId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_invite(`ptr`: Pointer,`userId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_kick(`ptr`: Pointer,`userId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_redact(`ptr`: Pointer,`userId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_send_message(`ptr`: Pointer,`userId`: RustBuffer.ByValue,`message`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_send_state(`ptr`: Pointer,`userId`: RustBuffer.ByValue,`stateEvent`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_trigger_room_notification(`ptr`: Pointer,`userId`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_cancel_send(`ptr`: Pointer,`txnId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_canonical_alias(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_display_name(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_edit(`ptr`: Pointer,`newMsg`: RustBuffer.ByValue,`originalEventId`: RustBuffer.ByValue,`txnId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_fetch_details_for_event(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_fetch_members(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_get_timeline_event_content_by_event_id(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_ignore_user(`ptr`: Pointer,`userId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_invite_user_by_id(`ptr`: Pointer,`userId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_invited_members_count(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_inviter(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_is_direct(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_room_is_encrypted(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_room_is_public(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_room_is_space(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_room_is_tombstoned(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_room_join(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_joined_members_count(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_leave(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_member(`ptr`: Pointer,`userId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_member_avatar_url(`ptr`: Pointer,`userId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_member_display_name(`ptr`: Pointer,`userId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_members(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_membership(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_name(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_own_user_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_paginate_backwards(`ptr`: Pointer,`opts`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_redact(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,`reason`: RustBuffer.ByValue,`txnId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_remove_avatar(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_remove_timeline(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_report_content(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,`score`: RustBuffer.ByValue,`reason`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_retry_decryption(`ptr`: Pointer,`sessionIds`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_retry_send(`ptr`: Pointer,`txnId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_send(`ptr`: Pointer,`msg`: Pointer,`txnId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_send_audio(`ptr`: Pointer,`url`: RustBuffer.ByValue,`audioInfo`: RustBuffer.ByValue,`progressWatcher`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_send_file(`ptr`: Pointer,`url`: RustBuffer.ByValue,`fileInfo`: RustBuffer.ByValue,`progressWatcher`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_send_image(`ptr`: Pointer,`url`: RustBuffer.ByValue,`thumbnailUrl`: RustBuffer.ByValue,`imageInfo`: RustBuffer.ByValue,`progressWatcher`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_send_location(`ptr`: Pointer,`body`: RustBuffer.ByValue,`geoUri`: RustBuffer.ByValue,`description`: RustBuffer.ByValue,`zoomLevel`: RustBuffer.ByValue,`assetType`: RustBuffer.ByValue,`txnId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_send_read_marker(`ptr`: Pointer,`fullyReadEventId`: RustBuffer.ByValue,`readReceiptEventId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_send_read_receipt(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_send_reply(`ptr`: Pointer,`msg`: RustBuffer.ByValue,`inReplyToEventId`: RustBuffer.ByValue,`txnId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_send_video(`ptr`: Pointer,`url`: RustBuffer.ByValue,`thumbnailUrl`: RustBuffer.ByValue,`videoInfo`: RustBuffer.ByValue,`progressWatcher`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_set_name(`ptr`: Pointer,`name`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_set_topic(`ptr`: Pointer,`topic`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_subscribe_to_back_pagination_status(`ptr`: Pointer,`listener`: Long,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_toggle_reaction(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,`key`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_topic(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_upload_avatar(`ptr`: Pointer,`mimeType`: RustBuffer.ByValue,`data`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_free_roomlist(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlist_entries(`ptr`: Pointer,`listener`: Long,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roomlist_loading_state(`ptr`: Pointer,`listener`: Long,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roomlist_room(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_roomlistitem(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_avatar_url(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_canonical_alias(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_full_room(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_has_unread_notifications(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_is_direct(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_latest_event(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackRustBuffer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_name(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_subscribe(`ptr`: Pointer,`settings`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_unread_notifications(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_unsubscribe(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_free_roomlistservice(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistservice_all_rooms(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackPointer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistservice_apply_input(`ptr`: Pointer,`input`: RustBuffer.ByValue,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistservice_invites(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackPointer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistservice_room(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistservice_state(`ptr`: Pointer,`listener`: Long,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_roommember(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_avatar_url(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_can_ban(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_can_invite(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_can_kick(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_can_redact(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_can_send_message(`ptr`: Pointer,`event`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_can_send_state(`ptr`: Pointer,`stateEvent`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_can_trigger_room_notification(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_display_name(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_ignore(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_is_account_user(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_is_ignored(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_is_name_ambiguous(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_membership(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_normalized_power_level(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_power_level(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_unignore(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_user_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_sendattachmentjoinhandle(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_sendattachmentjoinhandle_cancel(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_sendattachmentjoinhandle_join(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_free_sessionverificationcontroller(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_approve_verification(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_cancel_verification(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_decline_verification(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_is_verified(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_request_verification(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_set_delegate(`ptr`: Pointer,`delegate`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_start_sas_verification(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_free_sessionverificationemoji(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationemoji_description(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationemoji_symbol(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_span(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_constructor_span_current(_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_constructor_span_new(`file`: RustBuffer.ByValue,`line`: Int,`column`: Int,`level`: RustBuffer.ByValue,`target`: RustBuffer.ByValue,`name`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_span_enter(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_span_exit(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_span_is_none(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_free_syncservice(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_syncservice_current_state(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_syncservice_pause(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_syncservice_room_list_service(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_syncservice_start(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackByte,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_syncservice_state(`ptr`: Pointer,`listener`: Long,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_syncservicebuilder(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_syncservicebuilder_finish(`ptr`: Pointer,`uniffiExecutor`: USize,`uniffiCallback`: UniFfiFutureCallbackPointer,`uniffiCallbackData`: USize,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_syncservicebuilder_with_encryption_sync(`ptr`: Pointer,`withCrossProcessLock`: Byte,`appIdentifier`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_taskhandle(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_taskhandle_cancel(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_taskhandle_is_finished(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_free_timelinediff(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_append(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_change(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_insert(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_push_back(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_push_front(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_remove(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_reset(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_set(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_timelineevent(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timelineevent_event_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineevent_event_type(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineevent_sender_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineevent_timestamp(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_free_timelineitem(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timelineitem_as_event(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineitem_as_virtual(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineitem_fmt_debug(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineitem_unique_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_free_timelineitemcontent(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timelineitemcontent_as_message(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineitemcontent_kind(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_unreadnotificationscount(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_unreadnotificationscount_has_notifications(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_unreadnotificationscount_highlight_count(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Int
    fun uniffi_matrix_sdk_ffi_fn_method_unreadnotificationscount_notification_count(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Int
    fun uniffi_matrix_sdk_ffi_fn_init_callback_backpaginationstatuslistener(`callbackStub`: ForeignCallback,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_clientdelegate(`callbackStub`: ForeignCallback,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_notificationsettingsdelegate(`callbackStub`: ForeignCallback,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_progresswatcher(`callbackStub`: ForeignCallback,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_roomlistentrieslistener(`callbackStub`: ForeignCallback,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_roomlistloadingstatelistener(`callbackStub`: ForeignCallback,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_roomlistservicestatelistener(`callbackStub`: ForeignCallback,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_sessionverificationcontrollerdelegate(`callbackStub`: ForeignCallback,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_syncservicestateobserver(`callbackStub`: ForeignCallback,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_timelinelistener(`callbackStub`: ForeignCallback,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_func_gen_transaction_id(_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_func_log_event(`file`: RustBuffer.ByValue,`line`: Int,`column`: Int,`level`: RustBuffer.ByValue,`target`: RustBuffer.ByValue,`message`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_func_media_source_from_url(`url`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_func_message_event_content_from_markdown(`md`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_func_message_event_content_new(`msgtype`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_func_sdk_git_sha(_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_func_setup_otlp_tracing(`filter`: RustBuffer.ByValue,`clientName`: RustBuffer.ByValue,`user`: RustBuffer.ByValue,`password`: RustBuffer.ByValue,`otlpEndpoint`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_func_setup_tracing(`filter`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun ffi_matrix_sdk_ffi_rustbuffer_alloc(`size`: Int,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_rustbuffer_from_bytes(`bytes`: ForeignBytes.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_rustbuffer_free(`buf`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun ffi_matrix_sdk_ffi_rustbuffer_reserve(`buf`: RustBuffer.ByValue,`additional`: Int,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_checksum_func_gen_transaction_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_log_event(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_media_source_from_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_message_event_content_from_markdown(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_message_event_content_new(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_sdk_git_sha(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_setup_otlp_tracing(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_setup_tracing(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_mediasource_to_json(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_mediasource_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_configure_homeserver(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_homeserver_details(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_login(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_restore_with_access_token(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_account_data(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_avatar_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_cached_avatar_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_create_room(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_device_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_display_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_dm_room(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_media_content(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_media_file(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_media_thumbnail(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_notification_settings(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_profile(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_session_verification_controller(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_homeserver(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_ignore_user(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_login(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_logout(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_notification_client(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_restore_session(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_rooms(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_search_users(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_session(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_set_account_data(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_set_delegate(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_set_display_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_set_pusher(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_sync_service(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_unignore_user(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_upload_media(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_user_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_base_path(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_build(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_disable_ssl_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_homeserver_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_passphrase(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_proxy(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_server_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_server_versions(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_sliding_sync_proxy(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_user_agent(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_username(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_content(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_debug_info(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_event_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_editable(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_local(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_own(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_remote(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_local_send_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_origin(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_reactions(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_read_receipts(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_sender(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_sender_profile(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_timestamp(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_transaction_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_homeserverlogindetails_authentication_issuer(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_homeserverlogindetails_supports_password_login(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_homeserverlogindetails_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_mediafilehandle_path(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_message_body(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_message_in_reply_to(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_message_is_edited(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_message_msgtype(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationclient_get_notification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationclientbuilder_filter_by_push_rules(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationclientbuilder_finish(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationclientbuilder_retry_decryption(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_contains_keywords_rules(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_get_default_room_notification_mode(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_get_room_notification_settings(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_call_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_room_mention_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_user_mention_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_restore_default_room_notification_mode(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_call_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_delegate(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_room_mention_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_room_notification_mode(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_user_mention_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_unmute_room(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_active_members_count(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_add_timeline_listener(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_alternative_aliases(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_avatar_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_ban(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_invite(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_kick(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_redact(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_send_message(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_send_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_trigger_room_notification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_cancel_send(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_canonical_alias(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_display_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_edit(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_fetch_details_for_event(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_fetch_members(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_get_timeline_event_content_by_event_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_ignore_user(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_invite_user_by_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_invited_members_count(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_inviter(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_is_direct(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_is_encrypted(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_is_public(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_is_space(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_is_tombstoned(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_join(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_joined_members_count(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_leave(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_member(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_member_avatar_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_member_display_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_members(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_membership(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_own_user_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_paginate_backwards(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_redact(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_remove_avatar(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_remove_timeline(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_report_content(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_retry_decryption(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_retry_send(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_send(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_send_audio(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_send_file(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_send_image(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_send_location(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_send_read_marker(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_send_read_receipt(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_send_reply(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_send_video(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_set_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_set_topic(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_subscribe_to_back_pagination_status(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_toggle_reaction(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_topic(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_upload_avatar(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlist_entries(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlist_loading_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlist_room(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_avatar_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_canonical_alias(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_full_room(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_has_unread_notifications(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_is_direct(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_latest_event(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_subscribe(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_unread_notifications(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_unsubscribe(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_all_rooms(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_apply_input(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_invites(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_room(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_avatar_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_can_ban(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_can_invite(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_can_kick(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_can_redact(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_can_send_message(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_can_send_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_can_trigger_room_notification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_display_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_ignore(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_is_account_user(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_is_ignored(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_is_name_ambiguous(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_membership(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_normalized_power_level(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_power_level(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_unignore(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_user_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sendattachmentjoinhandle_cancel(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sendattachmentjoinhandle_join(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_approve_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_cancel_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_decline_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_is_verified(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_request_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_set_delegate(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_start_sas_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationemoji_description(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationemoji_symbol(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_span_enter(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_span_exit(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_span_is_none(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservice_current_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservice_pause(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservice_room_list_service(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservice_start(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservice_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservicebuilder_finish(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservicebuilder_with_encryption_sync(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_taskhandle_cancel(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_taskhandle_is_finished(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_append(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_change(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_insert(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_push_back(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_push_front(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_remove(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_reset(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_set(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineevent_event_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineevent_event_type(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineevent_sender_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineevent_timestamp(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineitem_as_event(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineitem_as_virtual(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineitem_fmt_debug(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineitem_unique_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineitemcontent_as_message(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineitemcontent_kind(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_unreadnotificationscount_has_notifications(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_unreadnotificationscount_highlight_count(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_unreadnotificationscount_notification_count(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_constructor_mediasource_from_json(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_constructor_authenticationservice_new(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_constructor_clientbuilder_new(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_constructor_span_current(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_constructor_span_new(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_backpaginationstatuslistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientdelegate_did_receive_auth_error(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettingsdelegate_settings_did_change(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_progresswatcher_transmission_progress(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistentrieslistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistloadingstatelistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservicestatelistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_accept_verification_request(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_start_sas_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_receive_verification_data(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_fail(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_cancel(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_finish(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservicestateobserver_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinelistener_on_update(
    ): Short
    fun uniffi_foreign_executor_callback_set(`callback`: UniFfiForeignExecutorCallback,
    ): Unit
    fun ffi_matrix_sdk_ffi_uniffi_contract_version(
    ): Int
    
}

private fun uniffiCheckContractApiVersion(lib: _UniFFILib) {
    // Get the bindings contract version from our ComponentInterface
    val bindings_contract_version = 22
    // Get the scaffolding contract version by calling the into the dylib
    val scaffolding_contract_version = lib.ffi_matrix_sdk_ffi_uniffi_contract_version()
    if (bindings_contract_version != scaffolding_contract_version) {
        throw RuntimeException("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    }
}

@Suppress("UNUSED_PARAMETER")
private fun uniffiCheckApiChecksums(lib: _UniFFILib) {
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_gen_transaction_id() != 65533.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_log_event() != 48093.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_media_source_from_url() != 28929.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_message_event_content_from_markdown() != 14647.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_message_event_content_new() != 47224.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_sdk_git_sha() != 11183.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_setup_otlp_tracing() != 53941.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_setup_tracing() != 13500.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_mediasource_to_json() != 2998.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_mediasource_url() != 34026.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_configure_homeserver() != 20936.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_homeserver_details() != 30828.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_login() != 4340.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_restore_with_access_token() != 25167.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_account_data() != 37263.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_avatar_url() != 13474.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_cached_avatar_url() != 47976.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_create_room() != 9095.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_device_id() != 30759.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_display_name() != 57766.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_dm_room() != 2581.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_media_content() != 25167.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_media_file() != 23010.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_media_thumbnail() != 51889.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_notification_settings() != 43752.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_profile() != 11465.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_session_verification_controller() != 25701.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_homeserver() != 509.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_ignore_user() != 53606.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_login() != 62785.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_logout() != 37421.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_notification_client() != 43839.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_restore_session() != 19558.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_rooms() != 61954.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_search_users() != 1362.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_session() != 56470.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_set_account_data() != 32949.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_set_delegate() != 32036.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_set_display_name() != 45786.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_set_pusher() != 9540.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_sync_service() != 55738.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_unignore_user() != 6043.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_upload_media() != 20769.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_user_id() != 55803.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_base_path() != 13781.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_build() != 56797.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_disable_ssl_verification() != 1510.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_homeserver_url() != 43790.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_passphrase() != 25291.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_proxy() != 61852.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_server_name() != 46252.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_server_versions() != 64538.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_sliding_sync_proxy() != 37450.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_user_agent() != 42913.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_username() != 64379.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_content() != 1802.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_debug_info() != 45087.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_event_id() != 57306.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_editable() != 593.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_local() != 47845.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_own() != 18359.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_remote() != 17688.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_local_send_state() != 22720.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_origin() != 28263.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_reactions() != 64143.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_read_receipts() != 40784.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_sender() != 46892.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_sender_profile() != 42856.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_timestamp() != 481.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_transaction_id() != 36352.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_homeserverlogindetails_authentication_issuer() != 29919.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_homeserverlogindetails_supports_password_login() != 6028.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_homeserverlogindetails_url() != 40398.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_mediafilehandle_path() != 57070.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_message_body() != 2560.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_message_in_reply_to() != 1793.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_message_is_edited() != 3402.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_message_msgtype() != 50686.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationclient_get_notification() != 9907.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationclientbuilder_filter_by_push_rules() != 10529.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationclientbuilder_finish() != 12382.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationclientbuilder_retry_decryption() != 12777.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_contains_keywords_rules() != 42972.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_get_default_room_notification_mode() != 19726.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_get_room_notification_settings() != 6545.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_call_enabled() != 38110.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_room_mention_enabled() != 36336.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_user_mention_enabled() != 9844.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_restore_default_room_notification_mode() != 43578.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_call_enabled() != 61774.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_delegate() != 22622.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_room_mention_enabled() != 50730.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_room_notification_mode() != 21294.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_user_mention_enabled() != 63345.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_unmute_room() != 58029.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_active_members_count() != 62367.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_add_timeline_listener() != 2158.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_alternative_aliases() != 25219.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_avatar_url() != 38267.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_ban() != 47371.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_invite() != 62419.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_kick() != 47687.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_redact() != 54334.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_send_message() != 28210.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_send_state() != 54763.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_trigger_room_notification() != 8288.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_cancel_send() != 22141.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_canonical_alias() != 15084.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_display_name() != 38216.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_edit() != 9282.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_fetch_details_for_event() != 23233.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_fetch_members() != 63440.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_get_timeline_event_content_by_event_id() != 14169.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_id() != 27132.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_ignore_user() != 9941.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_invite_user_by_id() != 12569.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_invited_members_count() != 31452.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_inviter() != 8327.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_is_direct() != 46881.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_is_encrypted() != 29418.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_is_public() != 22937.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_is_space() != 8495.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_is_tombstoned() != 55887.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_join() != 4883.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_joined_members_count() != 44345.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_leave() != 11928.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_member() != 19441.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_member_avatar_url() != 5937.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_member_display_name() != 4559.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_members() != 48203.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_membership() != 17678.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_name() != 58791.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_own_user_id() != 26241.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_paginate_backwards() != 28035.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_redact() != 61747.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_remove_avatar() != 24698.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_remove_timeline() != 13720.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_report_content() != 58629.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_retry_decryption() != 17014.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_retry_send() != 39997.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_send() != 5240.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_send_audio() != 19498.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_send_file() != 54377.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_send_image() != 56510.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_send_location() != 43614.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_send_read_marker() != 53306.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_send_read_receipt() != 6919.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_send_reply() != 35692.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_send_video() != 38775.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_set_name() != 39725.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_set_topic() != 55348.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_subscribe_to_back_pagination_status() != 27757.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_toggle_reaction() != 25672.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_topic() != 23413.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_upload_avatar() != 33347.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlist_entries() != 65405.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlist_loading_state() != 54823.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlist_room() != 60000.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_avatar_url() != 23609.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_canonical_alias() != 56187.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_full_room() != 50213.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_has_unread_notifications() != 64858.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_id() != 35737.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_is_direct() != 24829.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_latest_event() != 44019.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_name() != 5949.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_subscribe() != 16638.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_unread_notifications() != 36955.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_unsubscribe() != 14844.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_all_rooms() != 37160.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_apply_input() != 46775.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_invites() != 56087.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_room() != 48446.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_state() != 7038.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_avatar_url() != 9148.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_can_ban() != 19267.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_can_invite() != 36172.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_can_kick() != 31109.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_can_redact() != 49727.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_can_send_message() != 14989.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_can_send_state() != 43889.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_can_trigger_room_notification() != 62393.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_display_name() != 28367.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_ignore() != 32455.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_is_account_user() != 37767.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_is_ignored() != 46154.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_is_name_ambiguous() != 65246.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_membership() != 34335.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_normalized_power_level() != 49076.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_power_level() != 17042.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_unignore() != 56817.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_user_id() != 19498.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sendattachmentjoinhandle_cancel() != 58929.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sendattachmentjoinhandle_join() != 31788.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_approve_verification() != 468.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_cancel_verification() != 63679.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_decline_verification() != 50627.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_is_verified() != 949.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_request_verification() != 51679.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_set_delegate() != 24735.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_start_sas_verification() != 3726.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationemoji_description() != 55458.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationemoji_symbol() != 1848.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_span_enter() != 56663.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_span_exit() != 6123.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_span_is_none() != 23839.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservice_current_state() != 18935.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservice_pause() != 2733.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservice_room_list_service() != 18295.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservice_start() != 31472.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservice_state() != 15048.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservicebuilder_finish() != 61604.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservicebuilder_with_encryption_sync() != 35198.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_taskhandle_cancel() != 59047.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_taskhandle_is_finished() != 3905.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_append() != 24298.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_change() != 50296.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_insert() != 10002.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_push_back() != 35483.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_push_front() != 40108.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_remove() != 13408.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_reset() != 34789.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_set() != 45340.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineevent_event_id() != 20444.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineevent_event_type() != 52643.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineevent_sender_id() != 9141.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineevent_timestamp() != 30335.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineitem_as_event() != 755.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineitem_as_virtual() != 10265.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineitem_fmt_debug() != 25731.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineitem_unique_id() != 27999.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineitemcontent_as_message() != 58545.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineitemcontent_kind() != 60128.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_unreadnotificationscount_has_notifications() != 38874.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_unreadnotificationscount_highlight_count() != 30763.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_unreadnotificationscount_notification_count() != 10233.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_constructor_mediasource_from_json() != 31512.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_constructor_authenticationservice_new() != 38984.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_constructor_clientbuilder_new() != 53567.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_constructor_span_current() != 47163.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_constructor_span_new() != 17142.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_backpaginationstatuslistener_on_update() != 2582.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientdelegate_did_receive_auth_error() != 54393.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettingsdelegate_settings_did_change() != 4921.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_progresswatcher_transmission_progress() != 12165.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistentrieslistener_on_update() != 36351.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistloadingstatelistener_on_update() != 53567.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservicestatelistener_on_update() != 27905.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_accept_verification_request() != 59777.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_start_sas_verification() != 15715.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_receive_verification_data() != 46941.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_fail() != 52235.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_cancel() != 52154.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_finish() != 45558.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservicestateobserver_on_update() != 52830.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinelistener_on_update() != 30798.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

// Public interface members begin here.


public object FfiConverterUByte: FfiConverter<UByte, Byte> {
    override fun lift(value: Byte): UByte {
        return value.toUByte()
    }

    override fun read(buf: ByteBuffer): UByte {
        return lift(buf.get())
    }

    override fun lower(value: UByte): Byte {
        return value.toByte()
    }

    override fun allocationSize(value: UByte) = 1

    override fun write(value: UByte, buf: ByteBuffer) {
        buf.put(value.toByte())
    }
}

public object FfiConverterUShort: FfiConverter<UShort, Short> {
    override fun lift(value: Short): UShort {
        return value.toUShort()
    }

    override fun read(buf: ByteBuffer): UShort {
        return lift(buf.getShort())
    }

    override fun lower(value: UShort): Short {
        return value.toShort()
    }

    override fun allocationSize(value: UShort) = 2

    override fun write(value: UShort, buf: ByteBuffer) {
        buf.putShort(value.toShort())
    }
}

public object FfiConverterUInt: FfiConverter<UInt, Int> {
    override fun lift(value: Int): UInt {
        return value.toUInt()
    }

    override fun read(buf: ByteBuffer): UInt {
        return lift(buf.getInt())
    }

    override fun lower(value: UInt): Int {
        return value.toInt()
    }

    override fun allocationSize(value: UInt) = 4

    override fun write(value: UInt, buf: ByteBuffer) {
        buf.putInt(value.toInt())
    }
}

public object FfiConverterInt: FfiConverter<Int, Int> {
    override fun lift(value: Int): Int {
        return value
    }

    override fun read(buf: ByteBuffer): Int {
        return buf.getInt()
    }

    override fun lower(value: Int): Int {
        return value
    }

    override fun allocationSize(value: Int) = 4

    override fun write(value: Int, buf: ByteBuffer) {
        buf.putInt(value)
    }
}

public object FfiConverterULong: FfiConverter<ULong, Long> {
    override fun lift(value: Long): ULong {
        return value.toULong()
    }

    override fun read(buf: ByteBuffer): ULong {
        return lift(buf.getLong())
    }

    override fun lower(value: ULong): Long {
        return value.toLong()
    }

    override fun allocationSize(value: ULong) = 8

    override fun write(value: ULong, buf: ByteBuffer) {
        buf.putLong(value.toLong())
    }
}

public object FfiConverterLong: FfiConverter<Long, Long> {
    override fun lift(value: Long): Long {
        return value
    }

    override fun read(buf: ByteBuffer): Long {
        return buf.getLong()
    }

    override fun lower(value: Long): Long {
        return value
    }

    override fun allocationSize(value: Long) = 8

    override fun write(value: Long, buf: ByteBuffer) {
        buf.putLong(value)
    }
}

public object FfiConverterBoolean: FfiConverter<Boolean, Byte> {
    override fun lift(value: Byte): Boolean {
        return value.toInt() != 0
    }

    override fun read(buf: ByteBuffer): Boolean {
        return lift(buf.get())
    }

    override fun lower(value: Boolean): Byte {
        return if (value) 1.toByte() else 0.toByte()
    }

    override fun allocationSize(value: Boolean) = 1

    override fun write(value: Boolean, buf: ByteBuffer) {
        buf.put(lower(value))
    }
}

public object FfiConverterString: FfiConverter<String, RustBuffer.ByValue> {
    // Note: we don't inherit from FfiConverterRustBuffer, because we use a
    // special encoding when lowering/lifting.  We can use `RustBuffer.len` to
    // store our length and avoid writing it out to the buffer.
    override fun lift(value: RustBuffer.ByValue): String {
        try {
            val byteArr = ByteArray(value.len)
            value.asByteBuffer()!!.get(byteArr)
            return byteArr.toString(Charsets.UTF_8)
        } finally {
            RustBuffer.free(value)
        }
    }

    override fun read(buf: ByteBuffer): String {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr.toString(Charsets.UTF_8)
    }

    override fun lower(value: String): RustBuffer.ByValue {
        val byteArr = value.toByteArray(Charsets.UTF_8)
        // Ideally we'd pass these bytes to `ffi_bytebuffer_from_bytes`, but doing so would require us
        // to copy them into a JNA `Memory`. So we might as well directly copy them into a `RustBuffer`.
        val rbuf = RustBuffer.alloc(byteArr.size)
        rbuf.asByteBuffer()!!.put(byteArr)
        return rbuf
    }

    // We aren't sure exactly how many bytes our string will be once it's UTF-8
    // encoded.  Allocate 3 bytes per unicode codepoint which will always be
    // enough.
    override fun allocationSize(value: String): Int {
        val sizeForLength = 4
        val sizeForString = value.length * 3
        return sizeForLength + sizeForString
    }

    override fun write(value: String, buf: ByteBuffer) {
        val byteArr = value.toByteArray(Charsets.UTF_8)
        buf.putInt(byteArr.size)
        buf.put(byteArr)
    }
}


public object FfiConverterDuration: FfiConverterRustBuffer<java.time.Duration> {
    override fun read(buf: ByteBuffer): java.time.Duration {
        // Type mismatch (should be u64) but we check for overflow/underflow below
        val seconds = buf.getLong()
        // Type mismatch (should be u32) but we check for overflow/underflow below
        val nanoseconds = buf.getInt().toLong()
        if (seconds < 0) {
            throw java.time.DateTimeException("Duration exceeds minimum or maximum value supported by uniffi")
        }
        if (nanoseconds < 0) {
            throw java.time.DateTimeException("Duration nanoseconds exceed minimum or maximum supported by uniffi")
        }
        return java.time.Duration.ofSeconds(seconds, nanoseconds)
    }

    // 8 bytes for seconds, 4 bytes for nanoseconds
    override fun allocationSize(value: java.time.Duration) = 12

    override fun write(value: java.time.Duration, buf: ByteBuffer) {
        if (value.seconds < 0) {
            // Rust does not support negative Durations
            throw IllegalArgumentException("Invalid duration, must be non-negative")
        }

        if (value.nano < 0) {
            // Java docs provide guarantee that nano will always be positive, so this should be impossible
            // See: https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html
            throw IllegalArgumentException("Invalid duration, nano value must be non-negative")
        }

        // Type mismatch (should be u64) but since Rust doesn't support negative durations we should be OK
        buf.putLong(value.seconds)
        // Type mismatch (should be u32) but since values will always be between 0 and 999,999,999 it should be OK
        buf.putInt(value.nano)
    }
}


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }

// The base class for all UniFFI Object types.
//
// This class provides core operations for working with the Rust `Arc<T>` pointer to
// the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// the Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each `FFIObject` instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an `FFIObject` is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an `FFIObject` instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so will
//     leak the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each `FFIObject` an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// In the future we may be able to replace some of this with automatic finalization logic, such as using
// the new "Cleaner" functionaility in Java 9. The above scheme has been designed to work even if `destroy` is
// invoked by garbage-collection machinery rather than by calling code (which by the way, it's apparently also
// possible for the JVM to finalize an object while there is an in-flight call to one of its methods [1],
// so there would still be some complexity here).
//
// Sigh...all of this for want of a robust finalization mechanism.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//
abstract class FFIObject(
    protected val pointer: Pointer
): Disposable, AutoCloseable {

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    open protected fun freeRustArcPtr() {
        // To be overridden in subclasses.
    }

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                this.freeRustArcPtr()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.pointer)
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                this.freeRustArcPtr()
            }
        }
    }
}

public interface AuthenticationServiceInterface {
    @Throws(AuthenticationException::class)
    fun `configureHomeserver`(`serverNameOrHomeserverUrl`: String)
    fun `homeserverDetails`(): HomeserverLoginDetails?@Throws(AuthenticationException::class)
    fun `login`(`username`: String, `password`: String, `initialDeviceName`: String?, `deviceId`: String?): Client@Throws(AuthenticationException::class)
    fun `restoreWithAccessToken`(`token`: String, `deviceId`: String): Client
}

class AuthenticationService(
    pointer: Pointer
) : FFIObject(pointer), AuthenticationServiceInterface {
    constructor(`basePath`: String, `passphrase`: String?, `userAgent`: String?, `customSlidingSyncProxy`: String?) :
        this(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_constructor_authenticationservice_new(FfiConverterString.lower(`basePath`),FfiConverterOptionalString.lower(`passphrase`),FfiConverterOptionalString.lower(`userAgent`),FfiConverterOptionalString.lower(`customSlidingSyncProxy`),_status)
})

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_authenticationservice(this.pointer, status)
        }
    }

    
    @Throws(AuthenticationException::class)override fun `configureHomeserver`(`serverNameOrHomeserverUrl`: String) =
        callWithPointer {
    rustCallWithError(AuthenticationException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_authenticationservice_configure_homeserver(it,
        FfiConverterString.lower(`serverNameOrHomeserverUrl`),
        _status)
}
        }
    
    
    override fun `homeserverDetails`(): HomeserverLoginDetails? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_authenticationservice_homeserver_details(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeHomeserverLoginDetails.lift(it)
        }
    
    
    @Throws(AuthenticationException::class)override fun `login`(`username`: String, `password`: String, `initialDeviceName`: String?, `deviceId`: String?): Client =
        callWithPointer {
    rustCallWithError(AuthenticationException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_authenticationservice_login(it,
        FfiConverterString.lower(`username`),FfiConverterString.lower(`password`),FfiConverterOptionalString.lower(`initialDeviceName`),FfiConverterOptionalString.lower(`deviceId`),
        _status)
}
        }.let {
            FfiConverterTypeClient.lift(it)
        }
    
    
    @Throws(AuthenticationException::class)override fun `restoreWithAccessToken`(`token`: String, `deviceId`: String): Client =
        callWithPointer {
    rustCallWithError(AuthenticationException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_authenticationservice_restore_with_access_token(it,
        FfiConverterString.lower(`token`),FfiConverterString.lower(`deviceId`),
        _status)
}
        }.let {
            FfiConverterTypeClient.lift(it)
        }
    
    

    
}

public object FfiConverterTypeAuthenticationService: FfiConverter<AuthenticationService, Pointer> {
    override fun lower(value: AuthenticationService): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): AuthenticationService {
        return AuthenticationService(value)
    }

    override fun read(buf: ByteBuffer): AuthenticationService {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: AuthenticationService) = 8

    override fun write(value: AuthenticationService, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface ClientInterface {
    @Throws(ClientException::class)
    fun `accountData`(`eventType`: String): String?@Throws(ClientException::class)
    fun `avatarUrl`(): String?@Throws(ClientException::class)
    fun `cachedAvatarUrl`(): String?@Throws(ClientException::class)
    fun `createRoom`(`request`: CreateRoomParameters): String@Throws(ClientException::class)
    fun `deviceId`(): String@Throws(ClientException::class)
    fun `displayName`(): String@Throws(ClientException::class)
    fun `getDmRoom`(`userId`: String): Room?@Throws(ClientException::class)
    fun `getMediaContent`(`mediaSource`: MediaSource): List<UByte>@Throws(ClientException::class)
    fun `getMediaFile`(`mediaSource`: MediaSource, `body`: String?, `mimeType`: String, `tempDir`: String?): MediaFileHandle@Throws(ClientException::class)
    fun `getMediaThumbnail`(`mediaSource`: MediaSource, `width`: ULong, `height`: ULong): List<UByte>
    fun `getNotificationSettings`(): NotificationSettings@Throws(ClientException::class)
    fun `getProfile`(`userId`: String): UserProfile@Throws(ClientException::class)
    fun `getSessionVerificationController`(): SessionVerificationController
    fun `homeserver`(): String@Throws(ClientException::class)
    fun `ignoreUser`(`userId`: String)@Throws(ClientException::class)
    fun `login`(`username`: String, `password`: String, `initialDeviceName`: String?, `deviceId`: String?)@Throws(ClientException::class)
    fun `logout`()@Throws(ClientException::class)
    fun `notificationClient`(): NotificationClientBuilder@Throws(ClientException::class)
    fun `restoreSession`(`session`: Session)
    fun `rooms`(): List<Room>@Throws(ClientException::class)
    fun `searchUsers`(`searchTerm`: String, `limit`: ULong): SearchUsersResults@Throws(ClientException::class)
    fun `session`(): Session@Throws(ClientException::class)
    fun `setAccountData`(`eventType`: String, `content`: String)
    fun `setDelegate`(`delegate`: ClientDelegate?)@Throws(ClientException::class)
    fun `setDisplayName`(`name`: String)@Throws(ClientException::class)
    fun `setPusher`(`identifiers`: PusherIdentifiers, `kind`: PusherKind, `appDisplayName`: String, `deviceDisplayName`: String, `profileTag`: String?, `lang`: String)
    fun `syncService`(): SyncServiceBuilder@Throws(ClientException::class)
    fun `unignoreUser`(`userId`: String)@Throws(ClientException::class)
    fun `uploadMedia`(`mimeType`: String, `data`: List<UByte>, `progressWatcher`: ProgressWatcher?): String@Throws(ClientException::class)
    fun `userId`(): String
}

class Client(
    pointer: Pointer
) : FFIObject(pointer), ClientInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_client(this.pointer, status)
        }
    }

    
    @Throws(ClientException::class)override fun `accountData`(`eventType`: String): String? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_account_data(it,
        FfiConverterString.lower(`eventType`),
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `avatarUrl`(): String? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_avatar_url(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `cachedAvatarUrl`(): String? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_cached_avatar_url(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `createRoom`(`request`: CreateRoomParameters): String =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_create_room(it,
        FfiConverterTypeCreateRoomParameters.lower(`request`),
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `deviceId`(): String =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_device_id(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `displayName`(): String =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_display_name(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `getDmRoom`(`userId`: String): Room? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_dm_room(it,
        FfiConverterString.lower(`userId`),
        _status)
}
        }.let {
            FfiConverterOptionalTypeRoom.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `getMediaContent`(`mediaSource`: MediaSource): List<UByte> =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_media_content(it,
        FfiConverterTypeMediaSource.lower(`mediaSource`),
        _status)
}
        }.let {
            FfiConverterSequenceUByte.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `getMediaFile`(`mediaSource`: MediaSource, `body`: String?, `mimeType`: String, `tempDir`: String?): MediaFileHandle =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_media_file(it,
        FfiConverterTypeMediaSource.lower(`mediaSource`),FfiConverterOptionalString.lower(`body`),FfiConverterString.lower(`mimeType`),FfiConverterOptionalString.lower(`tempDir`),
        _status)
}
        }.let {
            FfiConverterTypeMediaFileHandle.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `getMediaThumbnail`(`mediaSource`: MediaSource, `width`: ULong, `height`: ULong): List<UByte> =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_media_thumbnail(it,
        FfiConverterTypeMediaSource.lower(`mediaSource`),FfiConverterULong.lower(`width`),FfiConverterULong.lower(`height`),
        _status)
}
        }.let {
            FfiConverterSequenceUByte.lift(it)
        }
    
    override fun `getNotificationSettings`(): NotificationSettings =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_notification_settings(it,
        
        _status)
}
        }.let {
            FfiConverterTypeNotificationSettings.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `getProfile`(`userId`: String): UserProfile =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_profile(it,
        FfiConverterString.lower(`userId`),
        _status)
}
        }.let {
            FfiConverterTypeUserProfile.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `getSessionVerificationController`(): SessionVerificationController =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_session_verification_controller(it,
        
        _status)
}
        }.let {
            FfiConverterTypeSessionVerificationController.lift(it)
        }
    
    override fun `homeserver`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_homeserver(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `ignoreUser`(`userId`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_ignore_user(it,
        FfiConverterString.lower(`userId`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `login`(`username`: String, `password`: String, `initialDeviceName`: String?, `deviceId`: String?) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_login(it,
        FfiConverterString.lower(`username`),FfiConverterString.lower(`password`),FfiConverterOptionalString.lower(`initialDeviceName`),FfiConverterOptionalString.lower(`deviceId`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `logout`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_logout(it,
        
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `notificationClient`(): NotificationClientBuilder =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_notification_client(it,
        
        _status)
}
        }.let {
            FfiConverterTypeNotificationClientBuilder.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `restoreSession`(`session`: Session) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_restore_session(it,
        FfiConverterTypeSession.lower(`session`),
        _status)
}
        }
    
    
    override fun `rooms`(): List<Room> =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_rooms(it,
        
        _status)
}
        }.let {
            FfiConverterSequenceTypeRoom.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `searchUsers`(`searchTerm`: String, `limit`: ULong): SearchUsersResults =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_search_users(it,
        FfiConverterString.lower(`searchTerm`),FfiConverterULong.lower(`limit`),
        _status)
}
        }.let {
            FfiConverterTypeSearchUsersResults.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `session`(): Session =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_session(it,
        
        _status)
}
        }.let {
            FfiConverterTypeSession.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `setAccountData`(`eventType`: String, `content`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_set_account_data(it,
        FfiConverterString.lower(`eventType`),FfiConverterString.lower(`content`),
        _status)
}
        }
    
    
    override fun `setDelegate`(`delegate`: ClientDelegate?) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_set_delegate(it,
        FfiConverterOptionalTypeClientDelegate.lower(`delegate`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `setDisplayName`(`name`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_set_display_name(it,
        FfiConverterString.lower(`name`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `setPusher`(`identifiers`: PusherIdentifiers, `kind`: PusherKind, `appDisplayName`: String, `deviceDisplayName`: String, `profileTag`: String?, `lang`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_set_pusher(it,
        FfiConverterTypePusherIdentifiers.lower(`identifiers`),FfiConverterTypePusherKind.lower(`kind`),FfiConverterString.lower(`appDisplayName`),FfiConverterString.lower(`deviceDisplayName`),FfiConverterOptionalString.lower(`profileTag`),FfiConverterString.lower(`lang`),
        _status)
}
        }
    
    
    override fun `syncService`(): SyncServiceBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_sync_service(it,
        
        _status)
}
        }.let {
            FfiConverterTypeSyncServiceBuilder.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `unignoreUser`(`userId`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_unignore_user(it,
        FfiConverterString.lower(`userId`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `uploadMedia`(`mimeType`: String, `data`: List<UByte>, `progressWatcher`: ProgressWatcher?): String =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_upload_media(it,
        FfiConverterString.lower(`mimeType`),FfiConverterSequenceUByte.lower(`data`),FfiConverterOptionalTypeProgressWatcher.lower(`progressWatcher`),
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `userId`(): String =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_user_id(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
}

public object FfiConverterTypeClient: FfiConverter<Client, Pointer> {
    override fun lower(value: Client): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): Client {
        return Client(value)
    }

    override fun read(buf: ByteBuffer): Client {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Client) = 8

    override fun write(value: Client, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface ClientBuilderInterface {
    
    fun `basePath`(`path`: String): ClientBuilder@Throws(ClientException::class)
    fun `build`(): Client
    fun `disableSslVerification`(): ClientBuilder
    fun `homeserverUrl`(`url`: String): ClientBuilder
    fun `passphrase`(`passphrase`: String?): ClientBuilder
    fun `proxy`(`url`: String): ClientBuilder
    fun `serverName`(`serverName`: String): ClientBuilder
    fun `serverVersions`(`versions`: List<String>): ClientBuilder
    fun `slidingSyncProxy`(`slidingSyncProxy`: String?): ClientBuilder
    fun `userAgent`(`userAgent`: String): ClientBuilder
    fun `username`(`username`: String): ClientBuilder
}

class ClientBuilder(
    pointer: Pointer
) : FFIObject(pointer), ClientBuilderInterface {
    constructor() :
        this(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_constructor_clientbuilder_new(_status)
})

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_clientbuilder(this.pointer, status)
        }
    }

    override fun `basePath`(`path`: String): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_base_path(it,
        FfiConverterString.lower(`path`),
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `build`(): Client =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_build(it,
        
        _status)
}
        }.let {
            FfiConverterTypeClient.lift(it)
        }
    
    override fun `disableSslVerification`(): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_disable_ssl_verification(it,
        
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `homeserverUrl`(`url`: String): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_homeserver_url(it,
        FfiConverterString.lower(`url`),
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `passphrase`(`passphrase`: String?): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_passphrase(it,
        FfiConverterOptionalString.lower(`passphrase`),
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `proxy`(`url`: String): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_proxy(it,
        FfiConverterString.lower(`url`),
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `serverName`(`serverName`: String): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_server_name(it,
        FfiConverterString.lower(`serverName`),
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `serverVersions`(`versions`: List<String>): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_server_versions(it,
        FfiConverterSequenceString.lower(`versions`),
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `slidingSyncProxy`(`slidingSyncProxy`: String?): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_sliding_sync_proxy(it,
        FfiConverterOptionalString.lower(`slidingSyncProxy`),
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `userAgent`(`userAgent`: String): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_user_agent(it,
        FfiConverterString.lower(`userAgent`),
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `username`(`username`: String): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_username(it,
        FfiConverterString.lower(`username`),
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    

    
}

public object FfiConverterTypeClientBuilder: FfiConverter<ClientBuilder, Pointer> {
    override fun lower(value: ClientBuilder): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): ClientBuilder {
        return ClientBuilder(value)
    }

    override fun read(buf: ByteBuffer): ClientBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: ClientBuilder) = 8

    override fun write(value: ClientBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface EventTimelineItemInterface {
    
    fun `content`(): TimelineItemContent
    fun `debugInfo`(): EventTimelineItemDebugInfo
    fun `eventId`(): String?
    fun `isEditable`(): Boolean
    fun `isLocal`(): Boolean
    fun `isOwn`(): Boolean
    fun `isRemote`(): Boolean
    fun `localSendState`(): EventSendState?
    fun `origin`(): EventItemOrigin?
    fun `reactions`(): List<Reaction>
    fun `readReceipts`(): Map<String, Receipt>
    fun `sender`(): String
    fun `senderProfile`(): ProfileDetails
    fun `timestamp`(): ULong
    fun `transactionId`(): String?
}

class EventTimelineItem(
    pointer: Pointer
) : FFIObject(pointer), EventTimelineItemInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_eventtimelineitem(this.pointer, status)
        }
    }

    override fun `content`(): TimelineItemContent =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_content(it,
        
        _status)
}
        }.let {
            FfiConverterTypeTimelineItemContent.lift(it)
        }
    
    override fun `debugInfo`(): EventTimelineItemDebugInfo =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_debug_info(it,
        
        _status)
}
        }.let {
            FfiConverterTypeEventTimelineItemDebugInfo.lift(it)
        }
    
    override fun `eventId`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_event_id(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    override fun `isEditable`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_editable(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isLocal`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_local(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isOwn`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_own(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isRemote`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_remote(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `localSendState`(): EventSendState? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_local_send_state(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeEventSendState.lift(it)
        }
    
    override fun `origin`(): EventItemOrigin? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_origin(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeEventItemOrigin.lift(it)
        }
    
    override fun `reactions`(): List<Reaction> =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_reactions(it,
        
        _status)
}
        }.let {
            FfiConverterSequenceTypeReaction.lift(it)
        }
    
    override fun `readReceipts`(): Map<String, Receipt> =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_read_receipts(it,
        
        _status)
}
        }.let {
            FfiConverterMapStringTypeReceipt.lift(it)
        }
    
    override fun `sender`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_sender(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `senderProfile`(): ProfileDetails =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_sender_profile(it,
        
        _status)
}
        }.let {
            FfiConverterTypeProfileDetails.lift(it)
        }
    
    override fun `timestamp`(): ULong =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_timestamp(it,
        
        _status)
}
        }.let {
            FfiConverterULong.lift(it)
        }
    
    override fun `transactionId`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_transaction_id(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    

    
}

public object FfiConverterTypeEventTimelineItem: FfiConverter<EventTimelineItem, Pointer> {
    override fun lower(value: EventTimelineItem): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): EventTimelineItem {
        return EventTimelineItem(value)
    }

    override fun read(buf: ByteBuffer): EventTimelineItem {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: EventTimelineItem) = 8

    override fun write(value: EventTimelineItem, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface HomeserverLoginDetailsInterface {
    
    fun `authenticationIssuer`(): String?
    fun `supportsPasswordLogin`(): Boolean
    fun `url`(): String
}

class HomeserverLoginDetails(
    pointer: Pointer
) : FFIObject(pointer), HomeserverLoginDetailsInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_homeserverlogindetails(this.pointer, status)
        }
    }

    override fun `authenticationIssuer`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_homeserverlogindetails_authentication_issuer(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    override fun `supportsPasswordLogin`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_homeserverlogindetails_supports_password_login(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `url`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_homeserverlogindetails_url(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
}

public object FfiConverterTypeHomeserverLoginDetails: FfiConverter<HomeserverLoginDetails, Pointer> {
    override fun lower(value: HomeserverLoginDetails): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): HomeserverLoginDetails {
        return HomeserverLoginDetails(value)
    }

    override fun read(buf: ByteBuffer): HomeserverLoginDetails {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: HomeserverLoginDetails) = 8

    override fun write(value: HomeserverLoginDetails, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface MediaFileHandleInterface {
    
    fun `path`(): String
}

class MediaFileHandle(
    pointer: Pointer
) : FFIObject(pointer), MediaFileHandleInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_mediafilehandle(this.pointer, status)
        }
    }

    override fun `path`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_mediafilehandle_path(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
}

public object FfiConverterTypeMediaFileHandle: FfiConverter<MediaFileHandle, Pointer> {
    override fun lower(value: MediaFileHandle): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): MediaFileHandle {
        return MediaFileHandle(value)
    }

    override fun read(buf: ByteBuffer): MediaFileHandle {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: MediaFileHandle) = 8

    override fun write(value: MediaFileHandle, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface MediaSourceInterface {
    
    fun `toJson`(): String
    fun `url`(): String
}

class MediaSource(
    pointer: Pointer
) : FFIObject(pointer), MediaSourceInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_mediasource(this.pointer, status)
        }
    }

    override fun `toJson`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_mediasource_to_json(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `url`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_mediasource_url(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    companion object {
        fun `fromJson`(`json`: String): MediaSource =
            MediaSource(
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_constructor_mediasource_from_json(FfiConverterString.lower(`json`),_status)
})
        
    }
    
}

public object FfiConverterTypeMediaSource: FfiConverter<MediaSource, Pointer> {
    override fun lower(value: MediaSource): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): MediaSource {
        return MediaSource(value)
    }

    override fun read(buf: ByteBuffer): MediaSource {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: MediaSource) = 8

    override fun write(value: MediaSource, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface MessageInterface {
    
    fun `body`(): String
    fun `inReplyTo`(): InReplyToDetails?
    fun `isEdited`(): Boolean
    fun `msgtype`(): MessageType?
}

class Message(
    pointer: Pointer
) : FFIObject(pointer), MessageInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_message(this.pointer, status)
        }
    }

    override fun `body`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_message_body(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `inReplyTo`(): InReplyToDetails? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_message_in_reply_to(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeInReplyToDetails.lift(it)
        }
    
    override fun `isEdited`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_message_is_edited(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `msgtype`(): MessageType? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_message_msgtype(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeMessageType.lift(it)
        }
    
    

    
}

public object FfiConverterTypeMessage: FfiConverter<Message, Pointer> {
    override fun lower(value: Message): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): Message {
        return Message(value)
    }

    override fun read(buf: ByteBuffer): Message {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Message) = 8

    override fun write(value: Message, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface NotificationClientInterface {
    @Throws(ClientException::class)
    fun `getNotification`(`roomId`: String, `eventId`: String): NotificationItem?
}

class NotificationClient(
    pointer: Pointer
) : FFIObject(pointer), NotificationClientInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_notificationclient(this.pointer, status)
        }
    }

    
    @Throws(ClientException::class)override fun `getNotification`(`roomId`: String, `eventId`: String): NotificationItem? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationclient_get_notification(it,
        FfiConverterString.lower(`roomId`),FfiConverterString.lower(`eventId`),
        _status)
}
        }.let {
            FfiConverterOptionalTypeNotificationItem.lift(it)
        }
    
    

    
}

public object FfiConverterTypeNotificationClient: FfiConverter<NotificationClient, Pointer> {
    override fun lower(value: NotificationClient): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): NotificationClient {
        return NotificationClient(value)
    }

    override fun read(buf: ByteBuffer): NotificationClient {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: NotificationClient) = 8

    override fun write(value: NotificationClient, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface NotificationClientBuilderInterface {
    
    fun `filterByPushRules`(): NotificationClientBuilder
    fun `finish`(): NotificationClient
    fun `retryDecryption`(`withCrossProcessLock`: Boolean): NotificationClientBuilder
}

class NotificationClientBuilder(
    pointer: Pointer
) : FFIObject(pointer), NotificationClientBuilderInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_notificationclientbuilder(this.pointer, status)
        }
    }

    override fun `filterByPushRules`(): NotificationClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationclientbuilder_filter_by_push_rules(it,
        
        _status)
}
        }.let {
            FfiConverterTypeNotificationClientBuilder.lift(it)
        }
    
    override fun `finish`(): NotificationClient =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationclientbuilder_finish(it,
        
        _status)
}
        }.let {
            FfiConverterTypeNotificationClient.lift(it)
        }
    
    override fun `retryDecryption`(`withCrossProcessLock`: Boolean): NotificationClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationclientbuilder_retry_decryption(it,
        FfiConverterBoolean.lower(`withCrossProcessLock`),
        _status)
}
        }.let {
            FfiConverterTypeNotificationClientBuilder.lift(it)
        }
    
    

    
}

public object FfiConverterTypeNotificationClientBuilder: FfiConverter<NotificationClientBuilder, Pointer> {
    override fun lower(value: NotificationClientBuilder): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): NotificationClientBuilder {
        return NotificationClientBuilder(value)
    }

    override fun read(buf: ByteBuffer): NotificationClientBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: NotificationClientBuilder) = 8

    override fun write(value: NotificationClientBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface NotificationSettingsInterface {
    
    suspend fun `containsKeywordsRules`(): Boolean
    suspend fun `getDefaultRoomNotificationMode`(`isEncrypted`: Boolean, `activeMembersCount`: ULong): RoomNotificationMode@Throws(NotificationSettingsException::class)
    suspend fun `getRoomNotificationSettings`(`roomId`: String, `isEncrypted`: Boolean, `activeMembersCount`: ULong): RoomNotificationSettings@Throws(NotificationSettingsException::class)
    suspend fun `isCallEnabled`(): Boolean@Throws(NotificationSettingsException::class)
    suspend fun `isRoomMentionEnabled`(): Boolean@Throws(NotificationSettingsException::class)
    suspend fun `isUserMentionEnabled`(): Boolean@Throws(NotificationSettingsException::class)
    suspend fun `restoreDefaultRoomNotificationMode`(`roomId`: String)@Throws(NotificationSettingsException::class)
    suspend fun `setCallEnabled`(`enabled`: Boolean)
    fun `setDelegate`(`delegate`: NotificationSettingsDelegate?)@Throws(NotificationSettingsException::class)
    suspend fun `setRoomMentionEnabled`(`enabled`: Boolean)@Throws(NotificationSettingsException::class)
    suspend fun `setRoomNotificationMode`(`roomId`: String, `mode`: RoomNotificationMode)@Throws(NotificationSettingsException::class)
    suspend fun `setUserMentionEnabled`(`enabled`: Boolean)@Throws(NotificationSettingsException::class)
    suspend fun `unmuteRoom`(`roomId`: String, `isEncrypted`: Boolean, `membersCount`: ULong)
}

class NotificationSettings(
    pointer: Pointer
) : FFIObject(pointer), NotificationSettingsInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_notificationsettings(this.pointer, status)
        }
    }

    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `containsKeywordsRules`() : Boolean {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerBoolean? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerBoolean(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_contains_keywords_rules(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getDefaultRoomNotificationMode`(`isEncrypted`: Boolean, `activeMembersCount`: ULong) : RoomNotificationMode {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerTypeRoomNotificationMode? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeRoomNotificationMode(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_get_default_room_notification_mode(
                                thisPtr,
                                FfiConverterBoolean.lower(`isEncrypted`),FfiConverterULong.lower(`activeMembersCount`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getRoomNotificationSettings`(`roomId`: String, `isEncrypted`: Boolean, `activeMembersCount`: ULong) : RoomNotificationSettings {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerTypeRoomNotificationSettings_TypeNotificationSettingsError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeRoomNotificationSettings_TypeNotificationSettingsError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_get_room_notification_settings(
                                thisPtr,
                                FfiConverterString.lower(`roomId`),FfiConverterBoolean.lower(`isEncrypted`),FfiConverterULong.lower(`activeMembersCount`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `isCallEnabled`() : Boolean {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerBoolean_TypeNotificationSettingsError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerBoolean_TypeNotificationSettingsError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_call_enabled(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `isRoomMentionEnabled`() : Boolean {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerBoolean_TypeNotificationSettingsError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerBoolean_TypeNotificationSettingsError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_room_mention_enabled(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `isUserMentionEnabled`() : Boolean {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerBoolean_TypeNotificationSettingsError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerBoolean_TypeNotificationSettingsError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_user_mention_enabled(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `restoreDefaultRoomNotificationMode`(`roomId`: String) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerVoid_TypeNotificationSettingsError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeNotificationSettingsError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_restore_default_room_notification_mode(
                                thisPtr,
                                FfiConverterString.lower(`roomId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setCallEnabled`(`enabled`: Boolean) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerVoid_TypeNotificationSettingsError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeNotificationSettingsError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_call_enabled(
                                thisPtr,
                                FfiConverterBoolean.lower(`enabled`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    override fun `setDelegate`(`delegate`: NotificationSettingsDelegate?) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_delegate(it,
        FfiConverterOptionalTypeNotificationSettingsDelegate.lower(`delegate`),
        _status)
}
        }
    
    
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setRoomMentionEnabled`(`enabled`: Boolean) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerVoid_TypeNotificationSettingsError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeNotificationSettingsError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_room_mention_enabled(
                                thisPtr,
                                FfiConverterBoolean.lower(`enabled`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setRoomNotificationMode`(`roomId`: String, `mode`: RoomNotificationMode) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerVoid_TypeNotificationSettingsError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeNotificationSettingsError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_room_notification_mode(
                                thisPtr,
                                FfiConverterString.lower(`roomId`),FfiConverterTypeRoomNotificationMode.lower(`mode`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setUserMentionEnabled`(`enabled`: Boolean) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerVoid_TypeNotificationSettingsError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeNotificationSettingsError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_user_mention_enabled(
                                thisPtr,
                                FfiConverterBoolean.lower(`enabled`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `unmuteRoom`(`roomId`: String, `isEncrypted`: Boolean, `membersCount`: ULong) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerVoid_TypeNotificationSettingsError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeNotificationSettingsError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_unmute_room(
                                thisPtr,
                                FfiConverterString.lower(`roomId`),FfiConverterBoolean.lower(`isEncrypted`),FfiConverterULong.lower(`membersCount`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    

    
}

public object FfiConverterTypeNotificationSettings: FfiConverter<NotificationSettings, Pointer> {
    override fun lower(value: NotificationSettings): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): NotificationSettings {
        return NotificationSettings(value)
    }

    override fun read(buf: ByteBuffer): NotificationSettings {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: NotificationSettings) = 8

    override fun write(value: NotificationSettings, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface RoomInterface {
    
    fun `activeMembersCount`(): ULong
    fun `addTimelineListener`(`listener`: TimelineListener): RoomTimelineListenerResult
    fun `alternativeAliases`(): List<String>
    fun `avatarUrl`(): String?@Throws(ClientException::class)
    suspend fun `canUserBan`(`userId`: String): Boolean@Throws(ClientException::class)
    suspend fun `canUserInvite`(`userId`: String): Boolean@Throws(ClientException::class)
    suspend fun `canUserKick`(`userId`: String): Boolean@Throws(ClientException::class)
    suspend fun `canUserRedact`(`userId`: String): Boolean@Throws(ClientException::class)
    suspend fun `canUserSendMessage`(`userId`: String, `message`: MessageLikeEventType): Boolean@Throws(ClientException::class)
    suspend fun `canUserSendState`(`userId`: String, `stateEvent`: StateEventType): Boolean@Throws(ClientException::class)
    suspend fun `canUserTriggerRoomNotification`(`userId`: String): Boolean
    fun `cancelSend`(`txnId`: String)
    fun `canonicalAlias`(): String?@Throws(ClientException::class)
    fun `displayName`(): String@Throws(ClientException::class)
    fun `edit`(`newMsg`: String, `originalEventId`: String, `txnId`: String?)@Throws(ClientException::class)
    fun `fetchDetailsForEvent`(`eventId`: String)@Throws(ClientException::class)
    fun `fetchMembers`(): TaskHandle@Throws(ClientException::class)
    fun `getTimelineEventContentByEventId`(`eventId`: String): RoomMessageEventContent
    fun `id`(): String@Throws(ClientException::class)
    fun `ignoreUser`(`userId`: String)@Throws(ClientException::class)
    fun `inviteUserById`(`userId`: String)
    fun `invitedMembersCount`(): ULong
    fun `inviter`(): RoomMember?
    fun `isDirect`(): Boolean@Throws(ClientException::class)
    fun `isEncrypted`(): Boolean
    fun `isPublic`(): Boolean
    fun `isSpace`(): Boolean
    fun `isTombstoned`(): Boolean@Throws(ClientException::class)
    fun `join`()
    fun `joinedMembersCount`(): ULong@Throws(ClientException::class)
    fun `leave`()@Throws(ClientException::class)
    fun `member`(`userId`: String): RoomMember@Throws(ClientException::class)
    fun `memberAvatarUrl`(`userId`: String): String?@Throws(ClientException::class)
    fun `memberDisplayName`(`userId`: String): String?@Throws(ClientException::class)
    fun `members`(): List<RoomMember>
    fun `membership`(): Membership
    fun `name`(): String?
    fun `ownUserId`(): String@Throws(ClientException::class)
    fun `paginateBackwards`(`opts`: PaginationOptions)@Throws(ClientException::class)
    fun `redact`(`eventId`: String, `reason`: String?, `txnId`: String?)@Throws(ClientException::class)
    fun `removeAvatar`()
    fun `removeTimeline`()@Throws(ClientException::class)
    fun `reportContent`(`eventId`: String, `score`: Int?, `reason`: String?)
    fun `retryDecryption`(`sessionIds`: List<String>)
    fun `retrySend`(`txnId`: String)
    fun `send`(`msg`: RoomMessageEventContent, `txnId`: String?)
    fun `sendAudio`(`url`: String, `audioInfo`: AudioInfo, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle
    fun `sendFile`(`url`: String, `fileInfo`: FileInfo, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle
    fun `sendImage`(`url`: String, `thumbnailUrl`: String, `imageInfo`: ImageInfo, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle
    fun `sendLocation`(`body`: String, `geoUri`: String, `description`: String?, `zoomLevel`: UByte?, `assetType`: AssetType?, `txnId`: String?)@Throws(ClientException::class)
    fun `sendReadMarker`(`fullyReadEventId`: String, `readReceiptEventId`: String?)@Throws(ClientException::class)
    fun `sendReadReceipt`(`eventId`: String)@Throws(ClientException::class)
    fun `sendReply`(`msg`: String, `inReplyToEventId`: String, `txnId`: String?)
    fun `sendVideo`(`url`: String, `thumbnailUrl`: String, `videoInfo`: VideoInfo, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle@Throws(ClientException::class)
    fun `setName`(`name`: String?)@Throws(ClientException::class)
    fun `setTopic`(`topic`: String)@Throws(ClientException::class)
    fun `subscribeToBackPaginationStatus`(`listener`: BackPaginationStatusListener): TaskHandle@Throws(ClientException::class)
    fun `toggleReaction`(`eventId`: String, `key`: String)
    fun `topic`(): String?@Throws(ClientException::class)
    fun `uploadAvatar`(`mimeType`: String, `data`: List<UByte>)
}

class Room(
    pointer: Pointer
) : FFIObject(pointer), RoomInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_room(this.pointer, status)
        }
    }

    override fun `activeMembersCount`(): ULong =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_active_members_count(it,
        
        _status)
}
        }.let {
            FfiConverterULong.lift(it)
        }
    
    override fun `addTimelineListener`(`listener`: TimelineListener): RoomTimelineListenerResult =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_add_timeline_listener(it,
        FfiConverterTypeTimelineListener.lower(`listener`),
        _status)
}
        }.let {
            FfiConverterTypeRoomTimelineListenerResult.lift(it)
        }
    
    override fun `alternativeAliases`(): List<String> =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_alternative_aliases(it,
        
        _status)
}
        }.let {
            FfiConverterSequenceString.lift(it)
        }
    
    override fun `avatarUrl`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_avatar_url(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserBan`(`userId`: String) : Boolean {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerBoolean_TypeClientError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerBoolean_TypeClientError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_ban(
                                thisPtr,
                                FfiConverterString.lower(`userId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserInvite`(`userId`: String) : Boolean {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerBoolean_TypeClientError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerBoolean_TypeClientError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_invite(
                                thisPtr,
                                FfiConverterString.lower(`userId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserKick`(`userId`: String) : Boolean {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerBoolean_TypeClientError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerBoolean_TypeClientError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_kick(
                                thisPtr,
                                FfiConverterString.lower(`userId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserRedact`(`userId`: String) : Boolean {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerBoolean_TypeClientError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerBoolean_TypeClientError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_redact(
                                thisPtr,
                                FfiConverterString.lower(`userId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserSendMessage`(`userId`: String, `message`: MessageLikeEventType) : Boolean {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerBoolean_TypeClientError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerBoolean_TypeClientError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_send_message(
                                thisPtr,
                                FfiConverterString.lower(`userId`),FfiConverterTypeMessageLikeEventType.lower(`message`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserSendState`(`userId`: String, `stateEvent`: StateEventType) : Boolean {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerBoolean_TypeClientError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerBoolean_TypeClientError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_send_state(
                                thisPtr,
                                FfiConverterString.lower(`userId`),FfiConverterTypeStateEventType.lower(`stateEvent`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserTriggerRoomNotification`(`userId`: String) : Boolean {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerBoolean_TypeClientError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerBoolean_TypeClientError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_trigger_room_notification(
                                thisPtr,
                                FfiConverterString.lower(`userId`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    override fun `cancelSend`(`txnId`: String) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_cancel_send(it,
        FfiConverterString.lower(`txnId`),
        _status)
}
        }
    
    
    override fun `canonicalAlias`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_canonical_alias(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `displayName`(): String =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_display_name(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `edit`(`newMsg`: String, `originalEventId`: String, `txnId`: String?) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_edit(it,
        FfiConverterString.lower(`newMsg`),FfiConverterString.lower(`originalEventId`),FfiConverterOptionalString.lower(`txnId`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `fetchDetailsForEvent`(`eventId`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_fetch_details_for_event(it,
        FfiConverterString.lower(`eventId`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `fetchMembers`(): TaskHandle =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_fetch_members(it,
        
        _status)
}
        }.let {
            FfiConverterTypeTaskHandle.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `getTimelineEventContentByEventId`(`eventId`: String): RoomMessageEventContent =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_get_timeline_event_content_by_event_id(it,
        FfiConverterString.lower(`eventId`),
        _status)
}
        }.let {
            FfiConverterTypeRoomMessageEventContent.lift(it)
        }
    
    override fun `id`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_id(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `ignoreUser`(`userId`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_ignore_user(it,
        FfiConverterString.lower(`userId`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `inviteUserById`(`userId`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_invite_user_by_id(it,
        FfiConverterString.lower(`userId`),
        _status)
}
        }
    
    
    override fun `invitedMembersCount`(): ULong =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_invited_members_count(it,
        
        _status)
}
        }.let {
            FfiConverterULong.lift(it)
        }
    
    override fun `inviter`(): RoomMember? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_inviter(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeRoomMember.lift(it)
        }
    
    override fun `isDirect`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_is_direct(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `isEncrypted`(): Boolean =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_is_encrypted(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isPublic`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_is_public(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isSpace`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_is_space(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isTombstoned`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_is_tombstoned(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `join`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_join(it,
        
        _status)
}
        }
    
    
    override fun `joinedMembersCount`(): ULong =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_joined_members_count(it,
        
        _status)
}
        }.let {
            FfiConverterULong.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `leave`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_leave(it,
        
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `member`(`userId`: String): RoomMember =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_member(it,
        FfiConverterString.lower(`userId`),
        _status)
}
        }.let {
            FfiConverterTypeRoomMember.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `memberAvatarUrl`(`userId`: String): String? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_member_avatar_url(it,
        FfiConverterString.lower(`userId`),
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `memberDisplayName`(`userId`: String): String? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_member_display_name(it,
        FfiConverterString.lower(`userId`),
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `members`(): List<RoomMember> =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_members(it,
        
        _status)
}
        }.let {
            FfiConverterSequenceTypeRoomMember.lift(it)
        }
    
    override fun `membership`(): Membership =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_membership(it,
        
        _status)
}
        }.let {
            FfiConverterTypeMembership.lift(it)
        }
    
    override fun `name`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_name(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    override fun `ownUserId`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_own_user_id(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `paginateBackwards`(`opts`: PaginationOptions) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_paginate_backwards(it,
        FfiConverterTypePaginationOptions.lower(`opts`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `redact`(`eventId`: String, `reason`: String?, `txnId`: String?) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_redact(it,
        FfiConverterString.lower(`eventId`),FfiConverterOptionalString.lower(`reason`),FfiConverterOptionalString.lower(`txnId`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `removeAvatar`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_remove_avatar(it,
        
        _status)
}
        }
    
    
    override fun `removeTimeline`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_remove_timeline(it,
        
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `reportContent`(`eventId`: String, `score`: Int?, `reason`: String?) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_report_content(it,
        FfiConverterString.lower(`eventId`),FfiConverterOptionalInt.lower(`score`),FfiConverterOptionalString.lower(`reason`),
        _status)
}
        }
    
    
    override fun `retryDecryption`(`sessionIds`: List<String>) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_retry_decryption(it,
        FfiConverterSequenceString.lower(`sessionIds`),
        _status)
}
        }
    
    
    override fun `retrySend`(`txnId`: String) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_retry_send(it,
        FfiConverterString.lower(`txnId`),
        _status)
}
        }
    
    
    override fun `send`(`msg`: RoomMessageEventContent, `txnId`: String?) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_send(it,
        FfiConverterTypeRoomMessageEventContent.lower(`msg`),FfiConverterOptionalString.lower(`txnId`),
        _status)
}
        }
    
    
    override fun `sendAudio`(`url`: String, `audioInfo`: AudioInfo, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_send_audio(it,
        FfiConverterString.lower(`url`),FfiConverterTypeAudioInfo.lower(`audioInfo`),FfiConverterOptionalTypeProgressWatcher.lower(`progressWatcher`),
        _status)
}
        }.let {
            FfiConverterTypeSendAttachmentJoinHandle.lift(it)
        }
    
    override fun `sendFile`(`url`: String, `fileInfo`: FileInfo, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_send_file(it,
        FfiConverterString.lower(`url`),FfiConverterTypeFileInfo.lower(`fileInfo`),FfiConverterOptionalTypeProgressWatcher.lower(`progressWatcher`),
        _status)
}
        }.let {
            FfiConverterTypeSendAttachmentJoinHandle.lift(it)
        }
    
    override fun `sendImage`(`url`: String, `thumbnailUrl`: String, `imageInfo`: ImageInfo, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_send_image(it,
        FfiConverterString.lower(`url`),FfiConverterString.lower(`thumbnailUrl`),FfiConverterTypeImageInfo.lower(`imageInfo`),FfiConverterOptionalTypeProgressWatcher.lower(`progressWatcher`),
        _status)
}
        }.let {
            FfiConverterTypeSendAttachmentJoinHandle.lift(it)
        }
    
    override fun `sendLocation`(`body`: String, `geoUri`: String, `description`: String?, `zoomLevel`: UByte?, `assetType`: AssetType?, `txnId`: String?) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_send_location(it,
        FfiConverterString.lower(`body`),FfiConverterString.lower(`geoUri`),FfiConverterOptionalString.lower(`description`),FfiConverterOptionalUByte.lower(`zoomLevel`),FfiConverterOptionalTypeAssetType.lower(`assetType`),FfiConverterOptionalString.lower(`txnId`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `sendReadMarker`(`fullyReadEventId`: String, `readReceiptEventId`: String?) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_send_read_marker(it,
        FfiConverterString.lower(`fullyReadEventId`),FfiConverterOptionalString.lower(`readReceiptEventId`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `sendReadReceipt`(`eventId`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_send_read_receipt(it,
        FfiConverterString.lower(`eventId`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `sendReply`(`msg`: String, `inReplyToEventId`: String, `txnId`: String?) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_send_reply(it,
        FfiConverterString.lower(`msg`),FfiConverterString.lower(`inReplyToEventId`),FfiConverterOptionalString.lower(`txnId`),
        _status)
}
        }
    
    
    override fun `sendVideo`(`url`: String, `thumbnailUrl`: String, `videoInfo`: VideoInfo, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_send_video(it,
        FfiConverterString.lower(`url`),FfiConverterString.lower(`thumbnailUrl`),FfiConverterTypeVideoInfo.lower(`videoInfo`),FfiConverterOptionalTypeProgressWatcher.lower(`progressWatcher`),
        _status)
}
        }.let {
            FfiConverterTypeSendAttachmentJoinHandle.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `setName`(`name`: String?) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_set_name(it,
        FfiConverterOptionalString.lower(`name`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `setTopic`(`topic`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_set_topic(it,
        FfiConverterString.lower(`topic`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `subscribeToBackPaginationStatus`(`listener`: BackPaginationStatusListener): TaskHandle =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_subscribe_to_back_pagination_status(it,
        FfiConverterTypeBackPaginationStatusListener.lower(`listener`),
        _status)
}
        }.let {
            FfiConverterTypeTaskHandle.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `toggleReaction`(`eventId`: String, `key`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_toggle_reaction(it,
        FfiConverterString.lower(`eventId`),FfiConverterString.lower(`key`),
        _status)
}
        }
    
    
    override fun `topic`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_topic(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `uploadAvatar`(`mimeType`: String, `data`: List<UByte>) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_upload_avatar(it,
        FfiConverterString.lower(`mimeType`),FfiConverterSequenceUByte.lower(`data`),
        _status)
}
        }
    
    
    

    
}

public object FfiConverterTypeRoom: FfiConverter<Room, Pointer> {
    override fun lower(value: Room): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): Room {
        return Room(value)
    }

    override fun read(buf: ByteBuffer): Room {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Room) = 8

    override fun write(value: Room, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface RoomListInterface {
    @Throws(RoomListException::class)
    fun `entries`(`listener`: RoomListEntriesListener): RoomListEntriesResult@Throws(RoomListException::class)
    fun `loadingState`(`listener`: RoomListLoadingStateListener): RoomListLoadingStateResult@Throws(RoomListException::class)
    fun `room`(`roomId`: String): RoomListItem
}

class RoomList(
    pointer: Pointer
) : FFIObject(pointer), RoomListInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_roomlist(this.pointer, status)
        }
    }

    
    @Throws(RoomListException::class)override fun `entries`(`listener`: RoomListEntriesListener): RoomListEntriesResult =
        callWithPointer {
    rustCallWithError(RoomListException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlist_entries(it,
        FfiConverterTypeRoomListEntriesListener.lower(`listener`),
        _status)
}
        }.let {
            FfiConverterTypeRoomListEntriesResult.lift(it)
        }
    
    
    @Throws(RoomListException::class)override fun `loadingState`(`listener`: RoomListLoadingStateListener): RoomListLoadingStateResult =
        callWithPointer {
    rustCallWithError(RoomListException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlist_loading_state(it,
        FfiConverterTypeRoomListLoadingStateListener.lower(`listener`),
        _status)
}
        }.let {
            FfiConverterTypeRoomListLoadingStateResult.lift(it)
        }
    
    
    @Throws(RoomListException::class)override fun `room`(`roomId`: String): RoomListItem =
        callWithPointer {
    rustCallWithError(RoomListException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlist_room(it,
        FfiConverterString.lower(`roomId`),
        _status)
}
        }.let {
            FfiConverterTypeRoomListItem.lift(it)
        }
    
    

    
}

public object FfiConverterTypeRoomList: FfiConverter<RoomList, Pointer> {
    override fun lower(value: RoomList): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): RoomList {
        return RoomList(value)
    }

    override fun read(buf: ByteBuffer): RoomList {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomList) = 8

    override fun write(value: RoomList, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface RoomListItemInterface {
    
    fun `avatarUrl`(): String?
    fun `canonicalAlias`(): String?
    fun `fullRoom`(): Room
    fun `hasUnreadNotifications`(): Boolean
    fun `id`(): String
    fun `isDirect`(): Boolean
    suspend fun `latestEvent`(): EventTimelineItem?
    fun `name`(): String?
    fun `subscribe`(`settings`: RoomSubscription?)
    fun `unreadNotifications`(): UnreadNotificationsCount
    fun `unsubscribe`()
}

class RoomListItem(
    pointer: Pointer
) : FFIObject(pointer), RoomListItemInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_roomlistitem(this.pointer, status)
        }
    }

    override fun `avatarUrl`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_avatar_url(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    override fun `canonicalAlias`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_canonical_alias(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    override fun `fullRoom`(): Room =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_full_room(it,
        
        _status)
}
        }.let {
            FfiConverterTypeRoom.lift(it)
        }
    
    override fun `hasUnreadNotifications`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_has_unread_notifications(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `id`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_id(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `isDirect`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_is_direct(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `latestEvent`() : EventTimelineItem? {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerOptionalTypeEventTimelineItem? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerOptionalTypeEventTimelineItem(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_latest_event(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    override fun `name`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_name(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    override fun `subscribe`(`settings`: RoomSubscription?) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_subscribe(it,
        FfiConverterOptionalTypeRoomSubscription.lower(`settings`),
        _status)
}
        }
    
    
    override fun `unreadNotifications`(): UnreadNotificationsCount =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_unread_notifications(it,
        
        _status)
}
        }.let {
            FfiConverterTypeUnreadNotificationsCount.lift(it)
        }
    
    override fun `unsubscribe`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_unsubscribe(it,
        
        _status)
}
        }
    
    
    

    
}

public object FfiConverterTypeRoomListItem: FfiConverter<RoomListItem, Pointer> {
    override fun lower(value: RoomListItem): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): RoomListItem {
        return RoomListItem(value)
    }

    override fun read(buf: ByteBuffer): RoomListItem {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomListItem) = 8

    override fun write(value: RoomListItem, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface RoomListServiceInterface {
    @Throws(RoomListException::class)
    suspend fun `allRooms`(): RoomList@Throws(RoomListException::class)
    suspend fun `applyInput`(`input`: RoomListInput)@Throws(RoomListException::class)
    suspend fun `invites`(): RoomList@Throws(RoomListException::class)
    fun `room`(`roomId`: String): RoomListItem
    fun `state`(`listener`: RoomListServiceStateListener): TaskHandle
}

class RoomListService(
    pointer: Pointer
) : FFIObject(pointer), RoomListServiceInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_roomlistservice(this.pointer, status)
        }
    }

    
    @Throws(RoomListException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `allRooms`() : RoomList {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerTypeRoomList_TypeRoomListError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeRoomList_TypeRoomListError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistservice_all_rooms(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(RoomListException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `applyInput`(`input`: RoomListInput) {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerVoid_TypeRoomListError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeRoomListError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistservice_apply_input(
                                thisPtr,
                                FfiConverterTypeRoomListInput.lower(`input`),
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(RoomListException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `invites`() : RoomList {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerTypeRoomList_TypeRoomListError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeRoomList_TypeRoomListError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistservice_invites(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(RoomListException::class)override fun `room`(`roomId`: String): RoomListItem =
        callWithPointer {
    rustCallWithError(RoomListException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistservice_room(it,
        FfiConverterString.lower(`roomId`),
        _status)
}
        }.let {
            FfiConverterTypeRoomListItem.lift(it)
        }
    
    override fun `state`(`listener`: RoomListServiceStateListener): TaskHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistservice_state(it,
        FfiConverterTypeRoomListServiceStateListener.lower(`listener`),
        _status)
}
        }.let {
            FfiConverterTypeTaskHandle.lift(it)
        }
    
    

    
}

public object FfiConverterTypeRoomListService: FfiConverter<RoomListService, Pointer> {
    override fun lower(value: RoomListService): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): RoomListService {
        return RoomListService(value)
    }

    override fun read(buf: ByteBuffer): RoomListService {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomListService) = 8

    override fun write(value: RoomListService, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface RoomMemberInterface {
    
    fun `avatarUrl`(): String?
    fun `canBan`(): Boolean
    fun `canInvite`(): Boolean
    fun `canKick`(): Boolean
    fun `canRedact`(): Boolean
    fun `canSendMessage`(`event`: MessageLikeEventType): Boolean
    fun `canSendState`(`stateEvent`: StateEventType): Boolean
    fun `canTriggerRoomNotification`(): Boolean
    fun `displayName`(): String?@Throws(ClientException::class)
    fun `ignore`()
    fun `isAccountUser`(): Boolean
    fun `isIgnored`(): Boolean
    fun `isNameAmbiguous`(): Boolean
    fun `membership`(): MembershipState
    fun `normalizedPowerLevel`(): Long
    fun `powerLevel`(): Long@Throws(ClientException::class)
    fun `unignore`()
    fun `userId`(): String
}

class RoomMember(
    pointer: Pointer
) : FFIObject(pointer), RoomMemberInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_roommember(this.pointer, status)
        }
    }

    override fun `avatarUrl`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_avatar_url(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    override fun `canBan`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_can_ban(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `canInvite`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_can_invite(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `canKick`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_can_kick(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `canRedact`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_can_redact(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `canSendMessage`(`event`: MessageLikeEventType): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_can_send_message(it,
        FfiConverterTypeMessageLikeEventType.lower(`event`),
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `canSendState`(`stateEvent`: StateEventType): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_can_send_state(it,
        FfiConverterTypeStateEventType.lower(`stateEvent`),
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `canTriggerRoomNotification`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_can_trigger_room_notification(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `displayName`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_display_name(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `ignore`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_ignore(it,
        
        _status)
}
        }
    
    
    override fun `isAccountUser`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_is_account_user(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isIgnored`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_is_ignored(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isNameAmbiguous`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_is_name_ambiguous(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `membership`(): MembershipState =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_membership(it,
        
        _status)
}
        }.let {
            FfiConverterTypeMembershipState.lift(it)
        }
    
    override fun `normalizedPowerLevel`(): Long =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_normalized_power_level(it,
        
        _status)
}
        }.let {
            FfiConverterLong.lift(it)
        }
    
    override fun `powerLevel`(): Long =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_power_level(it,
        
        _status)
}
        }.let {
            FfiConverterLong.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `unignore`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_unignore(it,
        
        _status)
}
        }
    
    
    override fun `userId`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_user_id(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
}

public object FfiConverterTypeRoomMember: FfiConverter<RoomMember, Pointer> {
    override fun lower(value: RoomMember): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): RoomMember {
        return RoomMember(value)
    }

    override fun read(buf: ByteBuffer): RoomMember {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomMember) = 8

    override fun write(value: RoomMember, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface RoomMessageEventContentInterface {
    
}

class RoomMessageEventContent(
    pointer: Pointer
) : FFIObject(pointer), RoomMessageEventContentInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_roommessageeventcontent(this.pointer, status)
        }
    }

    

    
}

public object FfiConverterTypeRoomMessageEventContent: FfiConverter<RoomMessageEventContent, Pointer> {
    override fun lower(value: RoomMessageEventContent): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): RoomMessageEventContent {
        return RoomMessageEventContent(value)
    }

    override fun read(buf: ByteBuffer): RoomMessageEventContent {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomMessageEventContent) = 8

    override fun write(value: RoomMessageEventContent, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface SendAttachmentJoinHandleInterface {
    
    fun `cancel`()@Throws(RoomException::class)
    fun `join`()
}

class SendAttachmentJoinHandle(
    pointer: Pointer
) : FFIObject(pointer), SendAttachmentJoinHandleInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_sendattachmentjoinhandle(this.pointer, status)
        }
    }

    override fun `cancel`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sendattachmentjoinhandle_cancel(it,
        
        _status)
}
        }
    
    
    
    @Throws(RoomException::class)override fun `join`() =
        callWithPointer {
    rustCallWithError(RoomException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sendattachmentjoinhandle_join(it,
        
        _status)
}
        }
    
    
    

    
}

public object FfiConverterTypeSendAttachmentJoinHandle: FfiConverter<SendAttachmentJoinHandle, Pointer> {
    override fun lower(value: SendAttachmentJoinHandle): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): SendAttachmentJoinHandle {
        return SendAttachmentJoinHandle(value)
    }

    override fun read(buf: ByteBuffer): SendAttachmentJoinHandle {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SendAttachmentJoinHandle) = 8

    override fun write(value: SendAttachmentJoinHandle, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface SessionVerificationControllerInterface {
    @Throws(ClientException::class)
    suspend fun `approveVerification`()@Throws(ClientException::class)
    suspend fun `cancelVerification`()@Throws(ClientException::class)
    suspend fun `declineVerification`()
    fun `isVerified`(): Boolean@Throws(ClientException::class)
    suspend fun `requestVerification`()
    fun `setDelegate`(`delegate`: SessionVerificationControllerDelegate?)@Throws(ClientException::class)
    suspend fun `startSasVerification`()
}

class SessionVerificationController(
    pointer: Pointer
) : FFIObject(pointer), SessionVerificationControllerInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_sessionverificationcontroller(this.pointer, status)
        }
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `approveVerification`() {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerVoid_TypeClientError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeClientError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_approve_verification(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `cancelVerification`() {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerVoid_TypeClientError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeClientError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_cancel_verification(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `declineVerification`() {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerVoid_TypeClientError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeClientError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_decline_verification(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    override fun `isVerified`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_is_verified(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `requestVerification`() {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerVoid_TypeClientError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeClientError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_request_verification(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    override fun `setDelegate`(`delegate`: SessionVerificationControllerDelegate?) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_set_delegate(it,
        FfiConverterOptionalTypeSessionVerificationControllerDelegate.lower(`delegate`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `startSasVerification`() {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerVoid_TypeClientError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeClientError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_start_sas_verification(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    

    
}

public object FfiConverterTypeSessionVerificationController: FfiConverter<SessionVerificationController, Pointer> {
    override fun lower(value: SessionVerificationController): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): SessionVerificationController {
        return SessionVerificationController(value)
    }

    override fun read(buf: ByteBuffer): SessionVerificationController {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SessionVerificationController) = 8

    override fun write(value: SessionVerificationController, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface SessionVerificationEmojiInterface {
    
    fun `description`(): String
    fun `symbol`(): String
}

class SessionVerificationEmoji(
    pointer: Pointer
) : FFIObject(pointer), SessionVerificationEmojiInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_sessionverificationemoji(this.pointer, status)
        }
    }

    override fun `description`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationemoji_description(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `symbol`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationemoji_symbol(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
}

public object FfiConverterTypeSessionVerificationEmoji: FfiConverter<SessionVerificationEmoji, Pointer> {
    override fun lower(value: SessionVerificationEmoji): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): SessionVerificationEmoji {
        return SessionVerificationEmoji(value)
    }

    override fun read(buf: ByteBuffer): SessionVerificationEmoji {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SessionVerificationEmoji) = 8

    override fun write(value: SessionVerificationEmoji, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface SpanInterface {
    
    fun `enter`()
    fun `exit`()
    fun `isNone`(): Boolean
}

class Span(
    pointer: Pointer
) : FFIObject(pointer), SpanInterface {
    constructor(`file`: String, `line`: UInt, `column`: UInt, `level`: LogLevel, `target`: String, `name`: String) :
        this(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_constructor_span_new(FfiConverterString.lower(`file`),FfiConverterUInt.lower(`line`),FfiConverterUInt.lower(`column`),FfiConverterTypeLogLevel.lower(`level`),FfiConverterString.lower(`target`),FfiConverterString.lower(`name`),_status)
})

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_span(this.pointer, status)
        }
    }

    override fun `enter`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_span_enter(it,
        
        _status)
}
        }
    
    
    override fun `exit`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_span_exit(it,
        
        _status)
}
        }
    
    
    override fun `isNone`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_span_is_none(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    

    companion object {
        fun `current`(): Span =
            Span(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_constructor_span_current(_status)
})
        
    }
    
}

public object FfiConverterTypeSpan: FfiConverter<Span, Pointer> {
    override fun lower(value: Span): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): Span {
        return Span(value)
    }

    override fun read(buf: ByteBuffer): Span {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Span) = 8

    override fun write(value: Span, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface SyncServiceInterface {
    
    fun `currentState`(): SyncServiceState@Throws(ClientException::class)
    fun `pause`()
    fun `roomListService`(): RoomListService@Throws(ClientException::class)
    suspend fun `start`()
    fun `state`(`listener`: SyncServiceStateObserver): TaskHandle
}

class SyncService(
    pointer: Pointer
) : FFIObject(pointer), SyncServiceInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_syncservice(this.pointer, status)
        }
    }

    override fun `currentState`(): SyncServiceState =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_syncservice_current_state(it,
        
        _status)
}
        }.let {
            FfiConverterTypeSyncServiceState.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `pause`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_syncservice_pause(it,
        
        _status)
}
        }
    
    
    override fun `roomListService`(): RoomListService =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_syncservice_room_list_service(it,
        
        _status)
}
        }.let {
            FfiConverterTypeRoomListService.lift(it)
        }
    
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `start`() {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerVoid_TypeClientError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerVoid_TypeClientError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_syncservice_start(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    override fun `state`(`listener`: SyncServiceStateObserver): TaskHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_syncservice_state(it,
        FfiConverterTypeSyncServiceStateObserver.lower(`listener`),
        _status)
}
        }.let {
            FfiConverterTypeTaskHandle.lift(it)
        }
    
    

    
}

public object FfiConverterTypeSyncService: FfiConverter<SyncService, Pointer> {
    override fun lower(value: SyncService): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): SyncService {
        return SyncService(value)
    }

    override fun read(buf: ByteBuffer): SyncService {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SyncService) = 8

    override fun write(value: SyncService, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface SyncServiceBuilderInterface {
    @Throws(ClientException::class)
    suspend fun `finish`(): SyncService
    fun `withEncryptionSync`(`withCrossProcessLock`: Boolean, `appIdentifier`: String?): SyncServiceBuilder
}

class SyncServiceBuilder(
    pointer: Pointer
) : FFIObject(pointer), SyncServiceBuilderInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_syncservicebuilder(this.pointer, status)
        }
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `finish`() : SyncService {
        // Create a new `CoroutineScope` for this operation, suspend the coroutine, and call the
        // scaffolding function, passing it one of the callback handlers from `AsyncTypes.kt`.
        //
        // Make sure to retain a reference to the callback handler to ensure that it's not GCed before
        // it's invoked
        var callbackHolder: UniFfiFutureCallbackHandlerTypeSyncService_TypeClientError? = null
        return coroutineScope {
            val scope = this
            return@coroutineScope suspendCoroutine { continuation ->
                try {
                    val callback = UniFfiFutureCallbackHandlerTypeSyncService_TypeClientError(continuation)
                    callbackHolder = callback
                    callWithPointer { thisPtr ->
                        rustCall { status ->
                            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_syncservicebuilder_finish(
                                thisPtr,
                                
                                FfiConverterForeignExecutor.lower(scope),
                                callback,
                                USize(0),
                                status,
                            )
                        }
                    }
                } catch (e: Exception) {
                    continuation.resumeWithException(e)
                }
            }
        }
    }
    override fun `withEncryptionSync`(`withCrossProcessLock`: Boolean, `appIdentifier`: String?): SyncServiceBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_syncservicebuilder_with_encryption_sync(it,
        FfiConverterBoolean.lower(`withCrossProcessLock`),FfiConverterOptionalString.lower(`appIdentifier`),
        _status)
}
        }.let {
            FfiConverterTypeSyncServiceBuilder.lift(it)
        }
    
    

    
}

public object FfiConverterTypeSyncServiceBuilder: FfiConverter<SyncServiceBuilder, Pointer> {
    override fun lower(value: SyncServiceBuilder): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): SyncServiceBuilder {
        return SyncServiceBuilder(value)
    }

    override fun read(buf: ByteBuffer): SyncServiceBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SyncServiceBuilder) = 8

    override fun write(value: SyncServiceBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface TaskHandleInterface {
    
    fun `cancel`()
    fun `isFinished`(): Boolean
}

class TaskHandle(
    pointer: Pointer
) : FFIObject(pointer), TaskHandleInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_taskhandle(this.pointer, status)
        }
    }

    override fun `cancel`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_taskhandle_cancel(it,
        
        _status)
}
        }
    
    
    override fun `isFinished`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_taskhandle_is_finished(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    

    
}

public object FfiConverterTypeTaskHandle: FfiConverter<TaskHandle, Pointer> {
    override fun lower(value: TaskHandle): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): TaskHandle {
        return TaskHandle(value)
    }

    override fun read(buf: ByteBuffer): TaskHandle {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: TaskHandle) = 8

    override fun write(value: TaskHandle, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface TimelineDiffInterface {
    
    fun `append`(): List<TimelineItem>?
    fun `change`(): TimelineChange
    fun `insert`(): InsertData?
    fun `pushBack`(): TimelineItem?
    fun `pushFront`(): TimelineItem?
    fun `remove`(): UInt?
    fun `reset`(): List<TimelineItem>?
    fun `set`(): SetData?
}

class TimelineDiff(
    pointer: Pointer
) : FFIObject(pointer), TimelineDiffInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_timelinediff(this.pointer, status)
        }
    }

    override fun `append`(): List<TimelineItem>? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_append(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalSequenceTypeTimelineItem.lift(it)
        }
    
    override fun `change`(): TimelineChange =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_change(it,
        
        _status)
}
        }.let {
            FfiConverterTypeTimelineChange.lift(it)
        }
    
    override fun `insert`(): InsertData? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_insert(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeInsertData.lift(it)
        }
    
    override fun `pushBack`(): TimelineItem? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_push_back(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeTimelineItem.lift(it)
        }
    
    override fun `pushFront`(): TimelineItem? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_push_front(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeTimelineItem.lift(it)
        }
    
    override fun `remove`(): UInt? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_remove(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalUInt.lift(it)
        }
    
    override fun `reset`(): List<TimelineItem>? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_reset(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalSequenceTypeTimelineItem.lift(it)
        }
    
    override fun `set`(): SetData? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_set(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeSetData.lift(it)
        }
    
    

    
}

public object FfiConverterTypeTimelineDiff: FfiConverter<TimelineDiff, Pointer> {
    override fun lower(value: TimelineDiff): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): TimelineDiff {
        return TimelineDiff(value)
    }

    override fun read(buf: ByteBuffer): TimelineDiff {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: TimelineDiff) = 8

    override fun write(value: TimelineDiff, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface TimelineEventInterface {
    
    fun `eventId`(): String@Throws(ClientException::class)
    fun `eventType`(): TimelineEventType
    fun `senderId`(): String
    fun `timestamp`(): ULong
}

class TimelineEvent(
    pointer: Pointer
) : FFIObject(pointer), TimelineEventInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_timelineevent(this.pointer, status)
        }
    }

    override fun `eventId`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineevent_event_id(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `eventType`(): TimelineEventType =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineevent_event_type(it,
        
        _status)
}
        }.let {
            FfiConverterTypeTimelineEventType.lift(it)
        }
    
    override fun `senderId`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineevent_sender_id(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `timestamp`(): ULong =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineevent_timestamp(it,
        
        _status)
}
        }.let {
            FfiConverterULong.lift(it)
        }
    
    

    
}

public object FfiConverterTypeTimelineEvent: FfiConverter<TimelineEvent, Pointer> {
    override fun lower(value: TimelineEvent): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): TimelineEvent {
        return TimelineEvent(value)
    }

    override fun read(buf: ByteBuffer): TimelineEvent {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: TimelineEvent) = 8

    override fun write(value: TimelineEvent, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface TimelineItemInterface {
    
    fun `asEvent`(): EventTimelineItem?
    fun `asVirtual`(): VirtualTimelineItem?
    fun `fmtDebug`(): String
    fun `uniqueId`(): ULong
}

class TimelineItem(
    pointer: Pointer
) : FFIObject(pointer), TimelineItemInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_timelineitem(this.pointer, status)
        }
    }

    override fun `asEvent`(): EventTimelineItem? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineitem_as_event(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeEventTimelineItem.lift(it)
        }
    
    override fun `asVirtual`(): VirtualTimelineItem? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineitem_as_virtual(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeVirtualTimelineItem.lift(it)
        }
    
    override fun `fmtDebug`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineitem_fmt_debug(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `uniqueId`(): ULong =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineitem_unique_id(it,
        
        _status)
}
        }.let {
            FfiConverterULong.lift(it)
        }
    
    

    
}

public object FfiConverterTypeTimelineItem: FfiConverter<TimelineItem, Pointer> {
    override fun lower(value: TimelineItem): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): TimelineItem {
        return TimelineItem(value)
    }

    override fun read(buf: ByteBuffer): TimelineItem {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: TimelineItem) = 8

    override fun write(value: TimelineItem, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface TimelineItemContentInterface {
    
    fun `asMessage`(): Message?
    fun `kind`(): TimelineItemContentKind
}

class TimelineItemContent(
    pointer: Pointer
) : FFIObject(pointer), TimelineItemContentInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_timelineitemcontent(this.pointer, status)
        }
    }

    override fun `asMessage`(): Message? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineitemcontent_as_message(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeMessage.lift(it)
        }
    
    override fun `kind`(): TimelineItemContentKind =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineitemcontent_kind(it,
        
        _status)
}
        }.let {
            FfiConverterTypeTimelineItemContentKind.lift(it)
        }
    
    

    
}

public object FfiConverterTypeTimelineItemContent: FfiConverter<TimelineItemContent, Pointer> {
    override fun lower(value: TimelineItemContent): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): TimelineItemContent {
        return TimelineItemContent(value)
    }

    override fun read(buf: ByteBuffer): TimelineItemContent {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: TimelineItemContent) = 8

    override fun write(value: TimelineItemContent, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface UnreadNotificationsCountInterface {
    
    fun `hasNotifications`(): Boolean
    fun `highlightCount`(): UInt
    fun `notificationCount`(): UInt
}

class UnreadNotificationsCount(
    pointer: Pointer
) : FFIObject(pointer), UnreadNotificationsCountInterface {

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        rustCall() { status ->
            _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_unreadnotificationscount(this.pointer, status)
        }
    }

    override fun `hasNotifications`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_unreadnotificationscount_has_notifications(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `highlightCount`(): UInt =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_unreadnotificationscount_highlight_count(it,
        
        _status)
}
        }.let {
            FfiConverterUInt.lift(it)
        }
    
    override fun `notificationCount`(): UInt =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_unreadnotificationscount_notification_count(it,
        
        _status)
}
        }.let {
            FfiConverterUInt.lift(it)
        }
    
    

    
}

public object FfiConverterTypeUnreadNotificationsCount: FfiConverter<UnreadNotificationsCount, Pointer> {
    override fun lower(value: UnreadNotificationsCount): Pointer = value.callWithPointer { it }

    override fun lift(value: Pointer): UnreadNotificationsCount {
        return UnreadNotificationsCount(value)
    }

    override fun read(buf: ByteBuffer): UnreadNotificationsCount {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: UnreadNotificationsCount) = 8

    override fun write(value: UnreadNotificationsCount, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}






// Callback function to execute a Rust task.  The Kotlin code schedules these in a coroutine then
// invokes them.
internal interface UniFfiRustTaskCallback : com.sun.jna.Callback {
    fun invoke(rustTaskData: Pointer?)
}

object UniFfiForeignExecutorCallback : com.sun.jna.Callback {
    internal fun invoke(handle: USize, delayMs: Int, rustTask: UniFfiRustTaskCallback?, rustTaskData: Pointer?) {
        if (rustTask == null) {
            FfiConverterForeignExecutor.drop(handle)
        } else {
            val coroutineScope = FfiConverterForeignExecutor.lift(handle)
            coroutineScope.launch {
                if (delayMs > 0) {
                    delay(delayMs.toLong())
                }
                rustTask.invoke(rustTaskData)
            }
        }
    }
}

public object FfiConverterForeignExecutor: FfiConverter<CoroutineScope, USize> {
    internal val handleMap = UniFfiHandleMap<CoroutineScope>()

    internal fun drop(handle: USize) {
        handleMap.remove(handle)
    }

    internal fun register(lib: _UniFFILib) {
        lib.uniffi_foreign_executor_callback_set(UniFfiForeignExecutorCallback)
    }

    // Number of live handles, exposed so we can test the memory management
    public fun handleCount() : Int {
        return handleMap.size
    }

    override fun allocationSize(value: CoroutineScope) = USize.size

    override fun lift(value: USize): CoroutineScope {
        return handleMap.get(value) ?: throw RuntimeException("unknown handle in FfiConverterForeignExecutor.lift")
    }

    override fun read(buf: ByteBuffer): CoroutineScope {
        return lift(USize.readFromBuffer(buf))
    }

    override fun lower(value: CoroutineScope): USize {
        return handleMap.insert(value)
    }

    override fun write(value: CoroutineScope, buf: ByteBuffer) {
        lower(value).writeToBuffer(buf)
    }
}




data class AudioInfo (
    var `duration`: java.time.Duration?, 
    var `size`: ULong?, 
    var `mimetype`: String?
) {
    
}

public object FfiConverterTypeAudioInfo: FfiConverterRustBuffer<AudioInfo> {
    override fun read(buf: ByteBuffer): AudioInfo {
        return AudioInfo(
            FfiConverterOptionalDuration.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: AudioInfo) = (
            FfiConverterOptionalDuration.allocationSize(value.`duration`) +
            FfiConverterOptionalULong.allocationSize(value.`size`) +
            FfiConverterOptionalString.allocationSize(value.`mimetype`)
    )

    override fun write(value: AudioInfo, buf: ByteBuffer) {
            FfiConverterOptionalDuration.write(value.`duration`, buf)
            FfiConverterOptionalULong.write(value.`size`, buf)
            FfiConverterOptionalString.write(value.`mimetype`, buf)
    }
}




data class AudioMessageContent (
    var `body`: String, 
    var `source`: MediaSource, 
    var `info`: AudioInfo?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`body`, 
        this.`source`, 
        this.`info`)
    }
    
}

public object FfiConverterTypeAudioMessageContent: FfiConverterRustBuffer<AudioMessageContent> {
    override fun read(buf: ByteBuffer): AudioMessageContent {
        return AudioMessageContent(
            FfiConverterString.read(buf),
            FfiConverterTypeMediaSource.read(buf),
            FfiConverterOptionalTypeAudioInfo.read(buf),
        )
    }

    override fun allocationSize(value: AudioMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterTypeMediaSource.allocationSize(value.`source`) +
            FfiConverterOptionalTypeAudioInfo.allocationSize(value.`info`)
    )

    override fun write(value: AudioMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterTypeMediaSource.write(value.`source`, buf)
            FfiConverterOptionalTypeAudioInfo.write(value.`info`, buf)
    }
}




data class CreateRoomParameters (
    var `name`: String?, 
    var `topic`: String? = null, 
    var `isEncrypted`: Boolean, 
    var `isDirect`: Boolean = false, 
    var `visibility`: RoomVisibility, 
    var `preset`: RoomPreset, 
    var `invite`: List<String>? = null, 
    var `avatar`: String? = null
) {
    
}

public object FfiConverterTypeCreateRoomParameters: FfiConverterRustBuffer<CreateRoomParameters> {
    override fun read(buf: ByteBuffer): CreateRoomParameters {
        return CreateRoomParameters(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterTypeRoomVisibility.read(buf),
            FfiConverterTypeRoomPreset.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: CreateRoomParameters) = (
            FfiConverterOptionalString.allocationSize(value.`name`) +
            FfiConverterOptionalString.allocationSize(value.`topic`) +
            FfiConverterBoolean.allocationSize(value.`isEncrypted`) +
            FfiConverterBoolean.allocationSize(value.`isDirect`) +
            FfiConverterTypeRoomVisibility.allocationSize(value.`visibility`) +
            FfiConverterTypeRoomPreset.allocationSize(value.`preset`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`invite`) +
            FfiConverterOptionalString.allocationSize(value.`avatar`)
    )

    override fun write(value: CreateRoomParameters, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`name`, buf)
            FfiConverterOptionalString.write(value.`topic`, buf)
            FfiConverterBoolean.write(value.`isEncrypted`, buf)
            FfiConverterBoolean.write(value.`isDirect`, buf)
            FfiConverterTypeRoomVisibility.write(value.`visibility`, buf)
            FfiConverterTypeRoomPreset.write(value.`preset`, buf)
            FfiConverterOptionalSequenceString.write(value.`invite`, buf)
            FfiConverterOptionalString.write(value.`avatar`, buf)
    }
}




data class EmoteMessageContent (
    var `body`: String, 
    var `formatted`: FormattedBody?
) {
    
}

public object FfiConverterTypeEmoteMessageContent: FfiConverterRustBuffer<EmoteMessageContent> {
    override fun read(buf: ByteBuffer): EmoteMessageContent {
        return EmoteMessageContent(
            FfiConverterString.read(buf),
            FfiConverterOptionalTypeFormattedBody.read(buf),
        )
    }

    override fun allocationSize(value: EmoteMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterOptionalTypeFormattedBody.allocationSize(value.`formatted`)
    )

    override fun write(value: EmoteMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterOptionalTypeFormattedBody.write(value.`formatted`, buf)
    }
}




data class EventTimelineItemDebugInfo (
    var `model`: String, 
    var `originalJson`: String?, 
    var `latestEditJson`: String?
) {
    
}

public object FfiConverterTypeEventTimelineItemDebugInfo: FfiConverterRustBuffer<EventTimelineItemDebugInfo> {
    override fun read(buf: ByteBuffer): EventTimelineItemDebugInfo {
        return EventTimelineItemDebugInfo(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: EventTimelineItemDebugInfo) = (
            FfiConverterString.allocationSize(value.`model`) +
            FfiConverterOptionalString.allocationSize(value.`originalJson`) +
            FfiConverterOptionalString.allocationSize(value.`latestEditJson`)
    )

    override fun write(value: EventTimelineItemDebugInfo, buf: ByteBuffer) {
            FfiConverterString.write(value.`model`, buf)
            FfiConverterOptionalString.write(value.`originalJson`, buf)
            FfiConverterOptionalString.write(value.`latestEditJson`, buf)
    }
}




data class FileInfo (
    var `mimetype`: String?, 
    var `size`: ULong?, 
    var `thumbnailInfo`: ThumbnailInfo?, 
    var `thumbnailSource`: MediaSource?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`mimetype`, 
        this.`size`, 
        this.`thumbnailInfo`, 
        this.`thumbnailSource`)
    }
    
}

public object FfiConverterTypeFileInfo: FfiConverterRustBuffer<FileInfo> {
    override fun read(buf: ByteBuffer): FileInfo {
        return FileInfo(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalTypeThumbnailInfo.read(buf),
            FfiConverterOptionalTypeMediaSource.read(buf),
        )
    }

    override fun allocationSize(value: FileInfo) = (
            FfiConverterOptionalString.allocationSize(value.`mimetype`) +
            FfiConverterOptionalULong.allocationSize(value.`size`) +
            FfiConverterOptionalTypeThumbnailInfo.allocationSize(value.`thumbnailInfo`) +
            FfiConverterOptionalTypeMediaSource.allocationSize(value.`thumbnailSource`)
    )

    override fun write(value: FileInfo, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`mimetype`, buf)
            FfiConverterOptionalULong.write(value.`size`, buf)
            FfiConverterOptionalTypeThumbnailInfo.write(value.`thumbnailInfo`, buf)
            FfiConverterOptionalTypeMediaSource.write(value.`thumbnailSource`, buf)
    }
}




data class FileMessageContent (
    var `body`: String, 
    var `filename`: String?, 
    var `source`: MediaSource, 
    var `info`: FileInfo?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`body`, 
        this.`filename`, 
        this.`source`, 
        this.`info`)
    }
    
}

public object FfiConverterTypeFileMessageContent: FfiConverterRustBuffer<FileMessageContent> {
    override fun read(buf: ByteBuffer): FileMessageContent {
        return FileMessageContent(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterTypeMediaSource.read(buf),
            FfiConverterOptionalTypeFileInfo.read(buf),
        )
    }

    override fun allocationSize(value: FileMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterOptionalString.allocationSize(value.`filename`) +
            FfiConverterTypeMediaSource.allocationSize(value.`source`) +
            FfiConverterOptionalTypeFileInfo.allocationSize(value.`info`)
    )

    override fun write(value: FileMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterOptionalString.write(value.`filename`, buf)
            FfiConverterTypeMediaSource.write(value.`source`, buf)
            FfiConverterOptionalTypeFileInfo.write(value.`info`, buf)
    }
}




data class FormattedBody (
    var `format`: MessageFormat, 
    var `body`: String
) {
    
}

public object FfiConverterTypeFormattedBody: FfiConverterRustBuffer<FormattedBody> {
    override fun read(buf: ByteBuffer): FormattedBody {
        return FormattedBody(
            FfiConverterTypeMessageFormat.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: FormattedBody) = (
            FfiConverterTypeMessageFormat.allocationSize(value.`format`) +
            FfiConverterString.allocationSize(value.`body`)
    )

    override fun write(value: FormattedBody, buf: ByteBuffer) {
            FfiConverterTypeMessageFormat.write(value.`format`, buf)
            FfiConverterString.write(value.`body`, buf)
    }
}




data class HttpPusherData (
    var `url`: String, 
    var `format`: PushFormat?, 
    var `defaultPayload`: String?
) {
    
}

public object FfiConverterTypeHttpPusherData: FfiConverterRustBuffer<HttpPusherData> {
    override fun read(buf: ByteBuffer): HttpPusherData {
        return HttpPusherData(
            FfiConverterString.read(buf),
            FfiConverterOptionalTypePushFormat.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: HttpPusherData) = (
            FfiConverterString.allocationSize(value.`url`) +
            FfiConverterOptionalTypePushFormat.allocationSize(value.`format`) +
            FfiConverterOptionalString.allocationSize(value.`defaultPayload`)
    )

    override fun write(value: HttpPusherData, buf: ByteBuffer) {
            FfiConverterString.write(value.`url`, buf)
            FfiConverterOptionalTypePushFormat.write(value.`format`, buf)
            FfiConverterOptionalString.write(value.`defaultPayload`, buf)
    }
}




data class ImageInfo (
    var `height`: ULong?, 
    var `width`: ULong?, 
    var `mimetype`: String?, 
    var `size`: ULong?, 
    var `thumbnailInfo`: ThumbnailInfo?, 
    var `thumbnailSource`: MediaSource?, 
    var `blurhash`: String?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`height`, 
        this.`width`, 
        this.`mimetype`, 
        this.`size`, 
        this.`thumbnailInfo`, 
        this.`thumbnailSource`, 
        this.`blurhash`)
    }
    
}

public object FfiConverterTypeImageInfo: FfiConverterRustBuffer<ImageInfo> {
    override fun read(buf: ByteBuffer): ImageInfo {
        return ImageInfo(
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalTypeThumbnailInfo.read(buf),
            FfiConverterOptionalTypeMediaSource.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: ImageInfo) = (
            FfiConverterOptionalULong.allocationSize(value.`height`) +
            FfiConverterOptionalULong.allocationSize(value.`width`) +
            FfiConverterOptionalString.allocationSize(value.`mimetype`) +
            FfiConverterOptionalULong.allocationSize(value.`size`) +
            FfiConverterOptionalTypeThumbnailInfo.allocationSize(value.`thumbnailInfo`) +
            FfiConverterOptionalTypeMediaSource.allocationSize(value.`thumbnailSource`) +
            FfiConverterOptionalString.allocationSize(value.`blurhash`)
    )

    override fun write(value: ImageInfo, buf: ByteBuffer) {
            FfiConverterOptionalULong.write(value.`height`, buf)
            FfiConverterOptionalULong.write(value.`width`, buf)
            FfiConverterOptionalString.write(value.`mimetype`, buf)
            FfiConverterOptionalULong.write(value.`size`, buf)
            FfiConverterOptionalTypeThumbnailInfo.write(value.`thumbnailInfo`, buf)
            FfiConverterOptionalTypeMediaSource.write(value.`thumbnailSource`, buf)
            FfiConverterOptionalString.write(value.`blurhash`, buf)
    }
}




data class ImageMessageContent (
    var `body`: String, 
    var `source`: MediaSource, 
    var `info`: ImageInfo?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`body`, 
        this.`source`, 
        this.`info`)
    }
    
}

public object FfiConverterTypeImageMessageContent: FfiConverterRustBuffer<ImageMessageContent> {
    override fun read(buf: ByteBuffer): ImageMessageContent {
        return ImageMessageContent(
            FfiConverterString.read(buf),
            FfiConverterTypeMediaSource.read(buf),
            FfiConverterOptionalTypeImageInfo.read(buf),
        )
    }

    override fun allocationSize(value: ImageMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterTypeMediaSource.allocationSize(value.`source`) +
            FfiConverterOptionalTypeImageInfo.allocationSize(value.`info`)
    )

    override fun write(value: ImageMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterTypeMediaSource.write(value.`source`, buf)
            FfiConverterOptionalTypeImageInfo.write(value.`info`, buf)
    }
}




data class InReplyToDetails (
    var `eventId`: String, 
    var `event`: RepliedToEventDetails
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`eventId`, 
        this.`event`)
    }
    
}

public object FfiConverterTypeInReplyToDetails: FfiConverterRustBuffer<InReplyToDetails> {
    override fun read(buf: ByteBuffer): InReplyToDetails {
        return InReplyToDetails(
            FfiConverterString.read(buf),
            FfiConverterTypeRepliedToEventDetails.read(buf),
        )
    }

    override fun allocationSize(value: InReplyToDetails) = (
            FfiConverterString.allocationSize(value.`eventId`) +
            FfiConverterTypeRepliedToEventDetails.allocationSize(value.`event`)
    )

    override fun write(value: InReplyToDetails, buf: ByteBuffer) {
            FfiConverterString.write(value.`eventId`, buf)
            FfiConverterTypeRepliedToEventDetails.write(value.`event`, buf)
    }
}




data class InsertData (
    var `index`: UInt, 
    var `item`: TimelineItem
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`index`, 
        this.`item`)
    }
    
}

public object FfiConverterTypeInsertData: FfiConverterRustBuffer<InsertData> {
    override fun read(buf: ByteBuffer): InsertData {
        return InsertData(
            FfiConverterUInt.read(buf),
            FfiConverterTypeTimelineItem.read(buf),
        )
    }

    override fun allocationSize(value: InsertData) = (
            FfiConverterUInt.allocationSize(value.`index`) +
            FfiConverterTypeTimelineItem.allocationSize(value.`item`)
    )

    override fun write(value: InsertData, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`index`, buf)
            FfiConverterTypeTimelineItem.write(value.`item`, buf)
    }
}




data class LocationContent (
    var `body`: String, 
    var `geoUri`: String, 
    var `description`: String?, 
    var `zoomLevel`: UByte?, 
    var `asset`: AssetType?
) {
    
}

public object FfiConverterTypeLocationContent: FfiConverterRustBuffer<LocationContent> {
    override fun read(buf: ByteBuffer): LocationContent {
        return LocationContent(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalUByte.read(buf),
            FfiConverterOptionalTypeAssetType.read(buf),
        )
    }

    override fun allocationSize(value: LocationContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterString.allocationSize(value.`geoUri`) +
            FfiConverterOptionalString.allocationSize(value.`description`) +
            FfiConverterOptionalUByte.allocationSize(value.`zoomLevel`) +
            FfiConverterOptionalTypeAssetType.allocationSize(value.`asset`)
    )

    override fun write(value: LocationContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterString.write(value.`geoUri`, buf)
            FfiConverterOptionalString.write(value.`description`, buf)
            FfiConverterOptionalUByte.write(value.`zoomLevel`, buf)
            FfiConverterOptionalTypeAssetType.write(value.`asset`, buf)
    }
}




data class NoticeMessageContent (
    var `body`: String, 
    var `formatted`: FormattedBody?
) {
    
}

public object FfiConverterTypeNoticeMessageContent: FfiConverterRustBuffer<NoticeMessageContent> {
    override fun read(buf: ByteBuffer): NoticeMessageContent {
        return NoticeMessageContent(
            FfiConverterString.read(buf),
            FfiConverterOptionalTypeFormattedBody.read(buf),
        )
    }

    override fun allocationSize(value: NoticeMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterOptionalTypeFormattedBody.allocationSize(value.`formatted`)
    )

    override fun write(value: NoticeMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterOptionalTypeFormattedBody.write(value.`formatted`, buf)
    }
}




data class NotificationItem (
    var `event`: NotificationEvent, 
    var `senderInfo`: NotificationSenderInfo, 
    var `roomInfo`: NotificationRoomInfo, 
    var `isNoisy`: Boolean?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`event`, 
        this.`senderInfo`, 
        this.`roomInfo`, 
        this.`isNoisy`)
    }
    
}

public object FfiConverterTypeNotificationItem: FfiConverterRustBuffer<NotificationItem> {
    override fun read(buf: ByteBuffer): NotificationItem {
        return NotificationItem(
            FfiConverterTypeNotificationEvent.read(buf),
            FfiConverterTypeNotificationSenderInfo.read(buf),
            FfiConverterTypeNotificationRoomInfo.read(buf),
            FfiConverterOptionalBoolean.read(buf),
        )
    }

    override fun allocationSize(value: NotificationItem) = (
            FfiConverterTypeNotificationEvent.allocationSize(value.`event`) +
            FfiConverterTypeNotificationSenderInfo.allocationSize(value.`senderInfo`) +
            FfiConverterTypeNotificationRoomInfo.allocationSize(value.`roomInfo`) +
            FfiConverterOptionalBoolean.allocationSize(value.`isNoisy`)
    )

    override fun write(value: NotificationItem, buf: ByteBuffer) {
            FfiConverterTypeNotificationEvent.write(value.`event`, buf)
            FfiConverterTypeNotificationSenderInfo.write(value.`senderInfo`, buf)
            FfiConverterTypeNotificationRoomInfo.write(value.`roomInfo`, buf)
            FfiConverterOptionalBoolean.write(value.`isNoisy`, buf)
    }
}




data class NotificationRoomInfo (
    var `displayName`: String, 
    var `avatarUrl`: String?, 
    var `canonicalAlias`: String?, 
    var `joinedMembersCount`: ULong, 
    var `isEncrypted`: Boolean?, 
    var `isDirect`: Boolean
) {
    
}

public object FfiConverterTypeNotificationRoomInfo: FfiConverterRustBuffer<NotificationRoomInfo> {
    override fun read(buf: ByteBuffer): NotificationRoomInfo {
        return NotificationRoomInfo(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: NotificationRoomInfo) = (
            FfiConverterString.allocationSize(value.`displayName`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`) +
            FfiConverterOptionalString.allocationSize(value.`canonicalAlias`) +
            FfiConverterULong.allocationSize(value.`joinedMembersCount`) +
            FfiConverterOptionalBoolean.allocationSize(value.`isEncrypted`) +
            FfiConverterBoolean.allocationSize(value.`isDirect`)
    )

    override fun write(value: NotificationRoomInfo, buf: ByteBuffer) {
            FfiConverterString.write(value.`displayName`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
            FfiConverterOptionalString.write(value.`canonicalAlias`, buf)
            FfiConverterULong.write(value.`joinedMembersCount`, buf)
            FfiConverterOptionalBoolean.write(value.`isEncrypted`, buf)
            FfiConverterBoolean.write(value.`isDirect`, buf)
    }
}




data class NotificationSenderInfo (
    var `senderId`: String, 
    var `displayName`: String?, 
    var `avatarUrl`: String?
) {
    
}

public object FfiConverterTypeNotificationSenderInfo: FfiConverterRustBuffer<NotificationSenderInfo> {
    override fun read(buf: ByteBuffer): NotificationSenderInfo {
        return NotificationSenderInfo(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: NotificationSenderInfo) = (
            FfiConverterString.allocationSize(value.`senderId`) +
            FfiConverterOptionalString.allocationSize(value.`displayName`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`)
    )

    override fun write(value: NotificationSenderInfo, buf: ByteBuffer) {
            FfiConverterString.write(value.`senderId`, buf)
            FfiConverterOptionalString.write(value.`displayName`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
    }
}




data class PollAnswer (
    var `id`: String, 
    var `text`: String
) {
    
}

public object FfiConverterTypePollAnswer: FfiConverterRustBuffer<PollAnswer> {
    override fun read(buf: ByteBuffer): PollAnswer {
        return PollAnswer(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: PollAnswer) = (
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterString.allocationSize(value.`text`)
    )

    override fun write(value: PollAnswer, buf: ByteBuffer) {
            FfiConverterString.write(value.`id`, buf)
            FfiConverterString.write(value.`text`, buf)
    }
}




data class PusherIdentifiers (
    var `pushkey`: String, 
    var `appId`: String
) {
    
}

public object FfiConverterTypePusherIdentifiers: FfiConverterRustBuffer<PusherIdentifiers> {
    override fun read(buf: ByteBuffer): PusherIdentifiers {
        return PusherIdentifiers(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: PusherIdentifiers) = (
            FfiConverterString.allocationSize(value.`pushkey`) +
            FfiConverterString.allocationSize(value.`appId`)
    )

    override fun write(value: PusherIdentifiers, buf: ByteBuffer) {
            FfiConverterString.write(value.`pushkey`, buf)
            FfiConverterString.write(value.`appId`, buf)
    }
}




data class Reaction (
    var `key`: String, 
    var `count`: ULong, 
    var `senders`: List<ReactionSenderData>
) {
    
}

public object FfiConverterTypeReaction: FfiConverterRustBuffer<Reaction> {
    override fun read(buf: ByteBuffer): Reaction {
        return Reaction(
            FfiConverterString.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterSequenceTypeReactionSenderData.read(buf),
        )
    }

    override fun allocationSize(value: Reaction) = (
            FfiConverterString.allocationSize(value.`key`) +
            FfiConverterULong.allocationSize(value.`count`) +
            FfiConverterSequenceTypeReactionSenderData.allocationSize(value.`senders`)
    )

    override fun write(value: Reaction, buf: ByteBuffer) {
            FfiConverterString.write(value.`key`, buf)
            FfiConverterULong.write(value.`count`, buf)
            FfiConverterSequenceTypeReactionSenderData.write(value.`senders`, buf)
    }
}




data class ReactionSenderData (
    var `senderId`: String, 
    var `timestamp`: ULong
) {
    
}

public object FfiConverterTypeReactionSenderData: FfiConverterRustBuffer<ReactionSenderData> {
    override fun read(buf: ByteBuffer): ReactionSenderData {
        return ReactionSenderData(
            FfiConverterString.read(buf),
            FfiConverterULong.read(buf),
        )
    }

    override fun allocationSize(value: ReactionSenderData) = (
            FfiConverterString.allocationSize(value.`senderId`) +
            FfiConverterULong.allocationSize(value.`timestamp`)
    )

    override fun write(value: ReactionSenderData, buf: ByteBuffer) {
            FfiConverterString.write(value.`senderId`, buf)
            FfiConverterULong.write(value.`timestamp`, buf)
    }
}




data class Receipt (
    var `timestamp`: ULong?
) {
    
}

public object FfiConverterTypeReceipt: FfiConverterRustBuffer<Receipt> {
    override fun read(buf: ByteBuffer): Receipt {
        return Receipt(
            FfiConverterOptionalULong.read(buf),
        )
    }

    override fun allocationSize(value: Receipt) = (
            FfiConverterOptionalULong.allocationSize(value.`timestamp`)
    )

    override fun write(value: Receipt, buf: ByteBuffer) {
            FfiConverterOptionalULong.write(value.`timestamp`, buf)
    }
}




data class RequiredState (
    var `key`: String, 
    var `value`: String
) {
    
}

public object FfiConverterTypeRequiredState: FfiConverterRustBuffer<RequiredState> {
    override fun read(buf: ByteBuffer): RequiredState {
        return RequiredState(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: RequiredState) = (
            FfiConverterString.allocationSize(value.`key`) +
            FfiConverterString.allocationSize(value.`value`)
    )

    override fun write(value: RequiredState, buf: ByteBuffer) {
            FfiConverterString.write(value.`key`, buf)
            FfiConverterString.write(value.`value`, buf)
    }
}




data class RoomListEntriesResult (
    var `entries`: List<RoomListEntry>, 
    var `entriesStream`: TaskHandle
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`entries`, 
        this.`entriesStream`)
    }
    
}

public object FfiConverterTypeRoomListEntriesResult: FfiConverterRustBuffer<RoomListEntriesResult> {
    override fun read(buf: ByteBuffer): RoomListEntriesResult {
        return RoomListEntriesResult(
            FfiConverterSequenceTypeRoomListEntry.read(buf),
            FfiConverterTypeTaskHandle.read(buf),
        )
    }

    override fun allocationSize(value: RoomListEntriesResult) = (
            FfiConverterSequenceTypeRoomListEntry.allocationSize(value.`entries`) +
            FfiConverterTypeTaskHandle.allocationSize(value.`entriesStream`)
    )

    override fun write(value: RoomListEntriesResult, buf: ByteBuffer) {
            FfiConverterSequenceTypeRoomListEntry.write(value.`entries`, buf)
            FfiConverterTypeTaskHandle.write(value.`entriesStream`, buf)
    }
}




data class RoomListLoadingStateResult (
    var `state`: RoomListLoadingState, 
    var `stateStream`: TaskHandle
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`state`, 
        this.`stateStream`)
    }
    
}

public object FfiConverterTypeRoomListLoadingStateResult: FfiConverterRustBuffer<RoomListLoadingStateResult> {
    override fun read(buf: ByteBuffer): RoomListLoadingStateResult {
        return RoomListLoadingStateResult(
            FfiConverterTypeRoomListLoadingState.read(buf),
            FfiConverterTypeTaskHandle.read(buf),
        )
    }

    override fun allocationSize(value: RoomListLoadingStateResult) = (
            FfiConverterTypeRoomListLoadingState.allocationSize(value.`state`) +
            FfiConverterTypeTaskHandle.allocationSize(value.`stateStream`)
    )

    override fun write(value: RoomListLoadingStateResult, buf: ByteBuffer) {
            FfiConverterTypeRoomListLoadingState.write(value.`state`, buf)
            FfiConverterTypeTaskHandle.write(value.`stateStream`, buf)
    }
}




data class RoomListRange (
    var `start`: UInt, 
    var `endInclusive`: UInt
) {
    
}

public object FfiConverterTypeRoomListRange: FfiConverterRustBuffer<RoomListRange> {
    override fun read(buf: ByteBuffer): RoomListRange {
        return RoomListRange(
            FfiConverterUInt.read(buf),
            FfiConverterUInt.read(buf),
        )
    }

    override fun allocationSize(value: RoomListRange) = (
            FfiConverterUInt.allocationSize(value.`start`) +
            FfiConverterUInt.allocationSize(value.`endInclusive`)
    )

    override fun write(value: RoomListRange, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`start`, buf)
            FfiConverterUInt.write(value.`endInclusive`, buf)
    }
}




data class RoomNotificationSettings (
    var `mode`: RoomNotificationMode, 
    var `isDefault`: Boolean
) {
    
}

public object FfiConverterTypeRoomNotificationSettings: FfiConverterRustBuffer<RoomNotificationSettings> {
    override fun read(buf: ByteBuffer): RoomNotificationSettings {
        return RoomNotificationSettings(
            FfiConverterTypeRoomNotificationMode.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: RoomNotificationSettings) = (
            FfiConverterTypeRoomNotificationMode.allocationSize(value.`mode`) +
            FfiConverterBoolean.allocationSize(value.`isDefault`)
    )

    override fun write(value: RoomNotificationSettings, buf: ByteBuffer) {
            FfiConverterTypeRoomNotificationMode.write(value.`mode`, buf)
            FfiConverterBoolean.write(value.`isDefault`, buf)
    }
}




data class RoomSubscription (
    var `requiredState`: List<RequiredState>?, 
    var `timelineLimit`: UInt?
) {
    
}

public object FfiConverterTypeRoomSubscription: FfiConverterRustBuffer<RoomSubscription> {
    override fun read(buf: ByteBuffer): RoomSubscription {
        return RoomSubscription(
            FfiConverterOptionalSequenceTypeRequiredState.read(buf),
            FfiConverterOptionalUInt.read(buf),
        )
    }

    override fun allocationSize(value: RoomSubscription) = (
            FfiConverterOptionalSequenceTypeRequiredState.allocationSize(value.`requiredState`) +
            FfiConverterOptionalUInt.allocationSize(value.`timelineLimit`)
    )

    override fun write(value: RoomSubscription, buf: ByteBuffer) {
            FfiConverterOptionalSequenceTypeRequiredState.write(value.`requiredState`, buf)
            FfiConverterOptionalUInt.write(value.`timelineLimit`, buf)
    }
}




data class RoomTimelineListenerResult (
    var `items`: List<TimelineItem>, 
    var `itemsStream`: TaskHandle
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`items`, 
        this.`itemsStream`)
    }
    
}

public object FfiConverterTypeRoomTimelineListenerResult: FfiConverterRustBuffer<RoomTimelineListenerResult> {
    override fun read(buf: ByteBuffer): RoomTimelineListenerResult {
        return RoomTimelineListenerResult(
            FfiConverterSequenceTypeTimelineItem.read(buf),
            FfiConverterTypeTaskHandle.read(buf),
        )
    }

    override fun allocationSize(value: RoomTimelineListenerResult) = (
            FfiConverterSequenceTypeTimelineItem.allocationSize(value.`items`) +
            FfiConverterTypeTaskHandle.allocationSize(value.`itemsStream`)
    )

    override fun write(value: RoomTimelineListenerResult, buf: ByteBuffer) {
            FfiConverterSequenceTypeTimelineItem.write(value.`items`, buf)
            FfiConverterTypeTaskHandle.write(value.`itemsStream`, buf)
    }
}




data class SearchUsersResults (
    var `results`: List<UserProfile>, 
    var `limited`: Boolean
) {
    
}

public object FfiConverterTypeSearchUsersResults: FfiConverterRustBuffer<SearchUsersResults> {
    override fun read(buf: ByteBuffer): SearchUsersResults {
        return SearchUsersResults(
            FfiConverterSequenceTypeUserProfile.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: SearchUsersResults) = (
            FfiConverterSequenceTypeUserProfile.allocationSize(value.`results`) +
            FfiConverterBoolean.allocationSize(value.`limited`)
    )

    override fun write(value: SearchUsersResults, buf: ByteBuffer) {
            FfiConverterSequenceTypeUserProfile.write(value.`results`, buf)
            FfiConverterBoolean.write(value.`limited`, buf)
    }
}




data class Session (
    var `accessToken`: String, 
    var `refreshToken`: String?, 
    var `userId`: String, 
    var `deviceId`: String, 
    var `homeserverUrl`: String, 
    var `slidingSyncProxy`: String?
) {
    
}

public object FfiConverterTypeSession: FfiConverterRustBuffer<Session> {
    override fun read(buf: ByteBuffer): Session {
        return Session(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: Session) = (
            FfiConverterString.allocationSize(value.`accessToken`) +
            FfiConverterOptionalString.allocationSize(value.`refreshToken`) +
            FfiConverterString.allocationSize(value.`userId`) +
            FfiConverterString.allocationSize(value.`deviceId`) +
            FfiConverterString.allocationSize(value.`homeserverUrl`) +
            FfiConverterOptionalString.allocationSize(value.`slidingSyncProxy`)
    )

    override fun write(value: Session, buf: ByteBuffer) {
            FfiConverterString.write(value.`accessToken`, buf)
            FfiConverterOptionalString.write(value.`refreshToken`, buf)
            FfiConverterString.write(value.`userId`, buf)
            FfiConverterString.write(value.`deviceId`, buf)
            FfiConverterString.write(value.`homeserverUrl`, buf)
            FfiConverterOptionalString.write(value.`slidingSyncProxy`, buf)
    }
}




data class SetData (
    var `index`: UInt, 
    var `item`: TimelineItem
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`index`, 
        this.`item`)
    }
    
}

public object FfiConverterTypeSetData: FfiConverterRustBuffer<SetData> {
    override fun read(buf: ByteBuffer): SetData {
        return SetData(
            FfiConverterUInt.read(buf),
            FfiConverterTypeTimelineItem.read(buf),
        )
    }

    override fun allocationSize(value: SetData) = (
            FfiConverterUInt.allocationSize(value.`index`) +
            FfiConverterTypeTimelineItem.allocationSize(value.`item`)
    )

    override fun write(value: SetData, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`index`, buf)
            FfiConverterTypeTimelineItem.write(value.`item`, buf)
    }
}




data class TextMessageContent (
    var `body`: String, 
    var `formatted`: FormattedBody?
) {
    
}

public object FfiConverterTypeTextMessageContent: FfiConverterRustBuffer<TextMessageContent> {
    override fun read(buf: ByteBuffer): TextMessageContent {
        return TextMessageContent(
            FfiConverterString.read(buf),
            FfiConverterOptionalTypeFormattedBody.read(buf),
        )
    }

    override fun allocationSize(value: TextMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterOptionalTypeFormattedBody.allocationSize(value.`formatted`)
    )

    override fun write(value: TextMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterOptionalTypeFormattedBody.write(value.`formatted`, buf)
    }
}




data class ThumbnailInfo (
    var `height`: ULong?, 
    var `width`: ULong?, 
    var `mimetype`: String?, 
    var `size`: ULong?
) {
    
}

public object FfiConverterTypeThumbnailInfo: FfiConverterRustBuffer<ThumbnailInfo> {
    override fun read(buf: ByteBuffer): ThumbnailInfo {
        return ThumbnailInfo(
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalULong.read(buf),
        )
    }

    override fun allocationSize(value: ThumbnailInfo) = (
            FfiConverterOptionalULong.allocationSize(value.`height`) +
            FfiConverterOptionalULong.allocationSize(value.`width`) +
            FfiConverterOptionalString.allocationSize(value.`mimetype`) +
            FfiConverterOptionalULong.allocationSize(value.`size`)
    )

    override fun write(value: ThumbnailInfo, buf: ByteBuffer) {
            FfiConverterOptionalULong.write(value.`height`, buf)
            FfiConverterOptionalULong.write(value.`width`, buf)
            FfiConverterOptionalString.write(value.`mimetype`, buf)
            FfiConverterOptionalULong.write(value.`size`, buf)
    }
}




data class TransmissionProgress (
    var `current`: ULong, 
    var `total`: ULong
) {
    
}

public object FfiConverterTypeTransmissionProgress: FfiConverterRustBuffer<TransmissionProgress> {
    override fun read(buf: ByteBuffer): TransmissionProgress {
        return TransmissionProgress(
            FfiConverterULong.read(buf),
            FfiConverterULong.read(buf),
        )
    }

    override fun allocationSize(value: TransmissionProgress) = (
            FfiConverterULong.allocationSize(value.`current`) +
            FfiConverterULong.allocationSize(value.`total`)
    )

    override fun write(value: TransmissionProgress, buf: ByteBuffer) {
            FfiConverterULong.write(value.`current`, buf)
            FfiConverterULong.write(value.`total`, buf)
    }
}




data class UserProfile (
    var `userId`: String, 
    var `displayName`: String?, 
    var `avatarUrl`: String?
) {
    
}

public object FfiConverterTypeUserProfile: FfiConverterRustBuffer<UserProfile> {
    override fun read(buf: ByteBuffer): UserProfile {
        return UserProfile(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: UserProfile) = (
            FfiConverterString.allocationSize(value.`userId`) +
            FfiConverterOptionalString.allocationSize(value.`displayName`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`)
    )

    override fun write(value: UserProfile, buf: ByteBuffer) {
            FfiConverterString.write(value.`userId`, buf)
            FfiConverterOptionalString.write(value.`displayName`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
    }
}




data class VideoInfo (
    var `duration`: java.time.Duration?, 
    var `height`: ULong?, 
    var `width`: ULong?, 
    var `mimetype`: String?, 
    var `size`: ULong?, 
    var `thumbnailInfo`: ThumbnailInfo?, 
    var `thumbnailSource`: MediaSource?, 
    var `blurhash`: String?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`duration`, 
        this.`height`, 
        this.`width`, 
        this.`mimetype`, 
        this.`size`, 
        this.`thumbnailInfo`, 
        this.`thumbnailSource`, 
        this.`blurhash`)
    }
    
}

public object FfiConverterTypeVideoInfo: FfiConverterRustBuffer<VideoInfo> {
    override fun read(buf: ByteBuffer): VideoInfo {
        return VideoInfo(
            FfiConverterOptionalDuration.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalTypeThumbnailInfo.read(buf),
            FfiConverterOptionalTypeMediaSource.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: VideoInfo) = (
            FfiConverterOptionalDuration.allocationSize(value.`duration`) +
            FfiConverterOptionalULong.allocationSize(value.`height`) +
            FfiConverterOptionalULong.allocationSize(value.`width`) +
            FfiConverterOptionalString.allocationSize(value.`mimetype`) +
            FfiConverterOptionalULong.allocationSize(value.`size`) +
            FfiConverterOptionalTypeThumbnailInfo.allocationSize(value.`thumbnailInfo`) +
            FfiConverterOptionalTypeMediaSource.allocationSize(value.`thumbnailSource`) +
            FfiConverterOptionalString.allocationSize(value.`blurhash`)
    )

    override fun write(value: VideoInfo, buf: ByteBuffer) {
            FfiConverterOptionalDuration.write(value.`duration`, buf)
            FfiConverterOptionalULong.write(value.`height`, buf)
            FfiConverterOptionalULong.write(value.`width`, buf)
            FfiConverterOptionalString.write(value.`mimetype`, buf)
            FfiConverterOptionalULong.write(value.`size`, buf)
            FfiConverterOptionalTypeThumbnailInfo.write(value.`thumbnailInfo`, buf)
            FfiConverterOptionalTypeMediaSource.write(value.`thumbnailSource`, buf)
            FfiConverterOptionalString.write(value.`blurhash`, buf)
    }
}




data class VideoMessageContent (
    var `body`: String, 
    var `source`: MediaSource, 
    var `info`: VideoInfo?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`body`, 
        this.`source`, 
        this.`info`)
    }
    
}

public object FfiConverterTypeVideoMessageContent: FfiConverterRustBuffer<VideoMessageContent> {
    override fun read(buf: ByteBuffer): VideoMessageContent {
        return VideoMessageContent(
            FfiConverterString.read(buf),
            FfiConverterTypeMediaSource.read(buf),
            FfiConverterOptionalTypeVideoInfo.read(buf),
        )
    }

    override fun allocationSize(value: VideoMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterTypeMediaSource.allocationSize(value.`source`) +
            FfiConverterOptionalTypeVideoInfo.allocationSize(value.`info`)
    )

    override fun write(value: VideoMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterTypeMediaSource.write(value.`source`, buf)
            FfiConverterOptionalTypeVideoInfo.write(value.`info`, buf)
    }
}




enum class AssetType {
    SENDER,PIN;
}

public object FfiConverterTypeAssetType: FfiConverterRustBuffer<AssetType> {
    override fun read(buf: ByteBuffer) = try {
        AssetType.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: AssetType) = 4

    override fun write(value: AssetType, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}







sealed class AuthenticationException(message: String): Exception(message) {
        // Each variant is a nested class
        // Flat enums carries a string error message, so no special implementation is necessary.
        class ClientMissing(message: String) : AuthenticationException(message)
        class InvalidServerName(message: String) : AuthenticationException(message)
        class SlidingSyncNotAvailable(message: String) : AuthenticationException(message)
        class SessionMissing(message: String) : AuthenticationException(message)
        class Generic(message: String) : AuthenticationException(message)
        

    companion object ErrorHandler : CallStatusErrorHandler<AuthenticationException> {
        override fun lift(error_buf: RustBuffer.ByValue): AuthenticationException = FfiConverterTypeAuthenticationError.lift(error_buf)
    }
}

public object FfiConverterTypeAuthenticationError : FfiConverterRustBuffer<AuthenticationException> {
    override fun read(buf: ByteBuffer): AuthenticationException {
        
            return when(buf.getInt()) {
            1 -> AuthenticationException.ClientMissing(FfiConverterString.read(buf))
            2 -> AuthenticationException.InvalidServerName(FfiConverterString.read(buf))
            3 -> AuthenticationException.SlidingSyncNotAvailable(FfiConverterString.read(buf))
            4 -> AuthenticationException.SessionMissing(FfiConverterString.read(buf))
            5 -> AuthenticationException.Generic(FfiConverterString.read(buf))
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
        
    }

    override fun allocationSize(value: AuthenticationException): Int {
        return 4
    }

    override fun write(value: AuthenticationException, buf: ByteBuffer) {
        when(value) {
            is AuthenticationException.ClientMissing -> {
                buf.putInt(1)
                Unit
            }
            is AuthenticationException.InvalidServerName -> {
                buf.putInt(2)
                Unit
            }
            is AuthenticationException.SlidingSyncNotAvailable -> {
                buf.putInt(3)
                Unit
            }
            is AuthenticationException.SessionMissing -> {
                buf.putInt(4)
                Unit
            }
            is AuthenticationException.Generic -> {
                buf.putInt(5)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




enum class BackPaginationStatus {
    IDLE,PAGINATING,TIMELINE_START_REACHED;
}

public object FfiConverterTypeBackPaginationStatus: FfiConverterRustBuffer<BackPaginationStatus> {
    override fun read(buf: ByteBuffer) = try {
        BackPaginationStatus.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: BackPaginationStatus) = 4

    override fun write(value: BackPaginationStatus, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}







sealed class ClientException: Exception() {
    // Each variant is a nested class
    
    class Generic(
        val `msg`: String
        ) : ClientException() {
        override val message
            get() = "msg=${ `msg` }"
    }
    

    companion object ErrorHandler : CallStatusErrorHandler<ClientException> {
        override fun lift(error_buf: RustBuffer.ByValue): ClientException = FfiConverterTypeClientError.lift(error_buf)
    }

    
}

public object FfiConverterTypeClientError : FfiConverterRustBuffer<ClientException> {
    override fun read(buf: ByteBuffer): ClientException {
        

        return when(buf.getInt()) {
            1 -> ClientException.Generic(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: ClientException): Int {
        return when(value) {
            is ClientException.Generic -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`msg`)
            )
        }
    }

    override fun write(value: ClientException, buf: ByteBuffer) {
        when(value) {
            is ClientException.Generic -> {
                buf.putInt(1)
                FfiConverterString.write(value.`msg`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




sealed class EncryptedMessage {
    data class OlmV1Curve25519AesSha2(
        val `senderKey`: String
        ) : EncryptedMessage()
    data class MegolmV1AesSha2(
        val `sessionId`: String
        ) : EncryptedMessage()
    object Unknown : EncryptedMessage()
    
    

    
}

public object FfiConverterTypeEncryptedMessage : FfiConverterRustBuffer<EncryptedMessage>{
    override fun read(buf: ByteBuffer): EncryptedMessage {
        return when(buf.getInt()) {
            1 -> EncryptedMessage.OlmV1Curve25519AesSha2(
                FfiConverterString.read(buf),
                )
            2 -> EncryptedMessage.MegolmV1AesSha2(
                FfiConverterString.read(buf),
                )
            3 -> EncryptedMessage.Unknown
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: EncryptedMessage) = when(value) {
        is EncryptedMessage.OlmV1Curve25519AesSha2 -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`senderKey`)
            )
        }
        is EncryptedMessage.MegolmV1AesSha2 -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`sessionId`)
            )
        }
        is EncryptedMessage.Unknown -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
    }

    override fun write(value: EncryptedMessage, buf: ByteBuffer) {
        when(value) {
            is EncryptedMessage.OlmV1Curve25519AesSha2 -> {
                buf.putInt(1)
                FfiConverterString.write(value.`senderKey`, buf)
                Unit
            }
            is EncryptedMessage.MegolmV1AesSha2 -> {
                buf.putInt(2)
                FfiConverterString.write(value.`sessionId`, buf)
                Unit
            }
            is EncryptedMessage.Unknown -> {
                buf.putInt(3)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class EventItemOrigin {
    LOCAL,SYNC,PAGINATION;
}

public object FfiConverterTypeEventItemOrigin: FfiConverterRustBuffer<EventItemOrigin> {
    override fun read(buf: ByteBuffer) = try {
        EventItemOrigin.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: EventItemOrigin) = 4

    override fun write(value: EventItemOrigin, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






sealed class EventSendState {
    object NotSentYet : EventSendState()
    
    data class SendingFailed(
        val `error`: String
        ) : EventSendState()
    object Cancelled : EventSendState()
    
    data class Sent(
        val `eventId`: String
        ) : EventSendState()
    

    
}

public object FfiConverterTypeEventSendState : FfiConverterRustBuffer<EventSendState>{
    override fun read(buf: ByteBuffer): EventSendState {
        return when(buf.getInt()) {
            1 -> EventSendState.NotSentYet
            2 -> EventSendState.SendingFailed(
                FfiConverterString.read(buf),
                )
            3 -> EventSendState.Cancelled
            4 -> EventSendState.Sent(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: EventSendState) = when(value) {
        is EventSendState.NotSentYet -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is EventSendState.SendingFailed -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`error`)
            )
        }
        is EventSendState.Cancelled -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is EventSendState.Sent -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`eventId`)
            )
        }
    }

    override fun write(value: EventSendState, buf: ByteBuffer) {
        when(value) {
            is EventSendState.NotSentYet -> {
                buf.putInt(1)
                Unit
            }
            is EventSendState.SendingFailed -> {
                buf.putInt(2)
                FfiConverterString.write(value.`error`, buf)
                Unit
            }
            is EventSendState.Cancelled -> {
                buf.putInt(3)
                Unit
            }
            is EventSendState.Sent -> {
                buf.putInt(4)
                FfiConverterString.write(value.`eventId`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class LogLevel {
    ERROR,WARN,INFO,DEBUG,TRACE;
}

public object FfiConverterTypeLogLevel: FfiConverterRustBuffer<LogLevel> {
    override fun read(buf: ByteBuffer) = try {
        LogLevel.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: LogLevel) = 4

    override fun write(value: LogLevel, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class Membership {
    INVITED,JOINED,LEFT;
}

public object FfiConverterTypeMembership: FfiConverterRustBuffer<Membership> {
    override fun read(buf: ByteBuffer) = try {
        Membership.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: Membership) = 4

    override fun write(value: Membership, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class MembershipChange {
    NONE,ERROR,JOINED,LEFT,BANNED,UNBANNED,KICKED,INVITED,KICKED_AND_BANNED,INVITATION_ACCEPTED,INVITATION_REJECTED,INVITATION_REVOKED,KNOCKED,KNOCK_ACCEPTED,KNOCK_RETRACTED,KNOCK_DENIED,NOT_IMPLEMENTED;
}

public object FfiConverterTypeMembershipChange: FfiConverterRustBuffer<MembershipChange> {
    override fun read(buf: ByteBuffer) = try {
        MembershipChange.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: MembershipChange) = 4

    override fun write(value: MembershipChange, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class MembershipState {
    BAN,INVITE,JOIN,KNOCK,LEAVE;
}

public object FfiConverterTypeMembershipState: FfiConverterRustBuffer<MembershipState> {
    override fun read(buf: ByteBuffer) = try {
        MembershipState.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: MembershipState) = 4

    override fun write(value: MembershipState, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






sealed class MessageFormat {
    object Html : MessageFormat()
    
    data class Unknown(
        val `format`: String
        ) : MessageFormat()
    

    
}

public object FfiConverterTypeMessageFormat : FfiConverterRustBuffer<MessageFormat>{
    override fun read(buf: ByteBuffer): MessageFormat {
        return when(buf.getInt()) {
            1 -> MessageFormat.Html
            2 -> MessageFormat.Unknown(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: MessageFormat) = when(value) {
        is MessageFormat.Html -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageFormat.Unknown -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`format`)
            )
        }
    }

    override fun write(value: MessageFormat, buf: ByteBuffer) {
        when(value) {
            is MessageFormat.Html -> {
                buf.putInt(1)
                Unit
            }
            is MessageFormat.Unknown -> {
                buf.putInt(2)
                FfiConverterString.write(value.`format`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class MessageLikeEventContent: Disposable  {
    object CallAnswer : MessageLikeEventContent()
    
    object CallInvite : MessageLikeEventContent()
    
    object CallHangup : MessageLikeEventContent()
    
    object CallCandidates : MessageLikeEventContent()
    
    object KeyVerificationReady : MessageLikeEventContent()
    
    object KeyVerificationStart : MessageLikeEventContent()
    
    object KeyVerificationCancel : MessageLikeEventContent()
    
    object KeyVerificationAccept : MessageLikeEventContent()
    
    object KeyVerificationKey : MessageLikeEventContent()
    
    object KeyVerificationMac : MessageLikeEventContent()
    
    object KeyVerificationDone : MessageLikeEventContent()
    
    data class ReactionContent(
        val `relatedEventId`: String
        ) : MessageLikeEventContent()
    object RoomEncrypted : MessageLikeEventContent()
    
    data class RoomMessage(
        val `messageType`: MessageType
        ) : MessageLikeEventContent()
    object RoomRedaction : MessageLikeEventContent()
    
    object Sticker : MessageLikeEventContent()
    
    

    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        when(this) {
            is MessageLikeEventContent.CallAnswer -> {// Nothing to destroy
            }
            is MessageLikeEventContent.CallInvite -> {// Nothing to destroy
            }
            is MessageLikeEventContent.CallHangup -> {// Nothing to destroy
            }
            is MessageLikeEventContent.CallCandidates -> {// Nothing to destroy
            }
            is MessageLikeEventContent.KeyVerificationReady -> {// Nothing to destroy
            }
            is MessageLikeEventContent.KeyVerificationStart -> {// Nothing to destroy
            }
            is MessageLikeEventContent.KeyVerificationCancel -> {// Nothing to destroy
            }
            is MessageLikeEventContent.KeyVerificationAccept -> {// Nothing to destroy
            }
            is MessageLikeEventContent.KeyVerificationKey -> {// Nothing to destroy
            }
            is MessageLikeEventContent.KeyVerificationMac -> {// Nothing to destroy
            }
            is MessageLikeEventContent.KeyVerificationDone -> {// Nothing to destroy
            }
            is MessageLikeEventContent.ReactionContent -> {
                
    Disposable.destroy(
        this.`relatedEventId`)
                
            }
            is MessageLikeEventContent.RoomEncrypted -> {// Nothing to destroy
            }
            is MessageLikeEventContent.RoomMessage -> {
                
    Disposable.destroy(
        this.`messageType`)
                
            }
            is MessageLikeEventContent.RoomRedaction -> {// Nothing to destroy
            }
            is MessageLikeEventContent.Sticker -> {// Nothing to destroy
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
    
}

public object FfiConverterTypeMessageLikeEventContent : FfiConverterRustBuffer<MessageLikeEventContent>{
    override fun read(buf: ByteBuffer): MessageLikeEventContent {
        return when(buf.getInt()) {
            1 -> MessageLikeEventContent.CallAnswer
            2 -> MessageLikeEventContent.CallInvite
            3 -> MessageLikeEventContent.CallHangup
            4 -> MessageLikeEventContent.CallCandidates
            5 -> MessageLikeEventContent.KeyVerificationReady
            6 -> MessageLikeEventContent.KeyVerificationStart
            7 -> MessageLikeEventContent.KeyVerificationCancel
            8 -> MessageLikeEventContent.KeyVerificationAccept
            9 -> MessageLikeEventContent.KeyVerificationKey
            10 -> MessageLikeEventContent.KeyVerificationMac
            11 -> MessageLikeEventContent.KeyVerificationDone
            12 -> MessageLikeEventContent.ReactionContent(
                FfiConverterString.read(buf),
                )
            13 -> MessageLikeEventContent.RoomEncrypted
            14 -> MessageLikeEventContent.RoomMessage(
                FfiConverterTypeMessageType.read(buf),
                )
            15 -> MessageLikeEventContent.RoomRedaction
            16 -> MessageLikeEventContent.Sticker
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: MessageLikeEventContent) = when(value) {
        is MessageLikeEventContent.CallAnswer -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.CallInvite -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.CallHangup -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.CallCandidates -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.KeyVerificationReady -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.KeyVerificationStart -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.KeyVerificationCancel -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.KeyVerificationAccept -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.KeyVerificationKey -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.KeyVerificationMac -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.KeyVerificationDone -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.ReactionContent -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`relatedEventId`)
            )
        }
        is MessageLikeEventContent.RoomEncrypted -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.RoomMessage -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeMessageType.allocationSize(value.`messageType`)
            )
        }
        is MessageLikeEventContent.RoomRedaction -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.Sticker -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
    }

    override fun write(value: MessageLikeEventContent, buf: ByteBuffer) {
        when(value) {
            is MessageLikeEventContent.CallAnswer -> {
                buf.putInt(1)
                Unit
            }
            is MessageLikeEventContent.CallInvite -> {
                buf.putInt(2)
                Unit
            }
            is MessageLikeEventContent.CallHangup -> {
                buf.putInt(3)
                Unit
            }
            is MessageLikeEventContent.CallCandidates -> {
                buf.putInt(4)
                Unit
            }
            is MessageLikeEventContent.KeyVerificationReady -> {
                buf.putInt(5)
                Unit
            }
            is MessageLikeEventContent.KeyVerificationStart -> {
                buf.putInt(6)
                Unit
            }
            is MessageLikeEventContent.KeyVerificationCancel -> {
                buf.putInt(7)
                Unit
            }
            is MessageLikeEventContent.KeyVerificationAccept -> {
                buf.putInt(8)
                Unit
            }
            is MessageLikeEventContent.KeyVerificationKey -> {
                buf.putInt(9)
                Unit
            }
            is MessageLikeEventContent.KeyVerificationMac -> {
                buf.putInt(10)
                Unit
            }
            is MessageLikeEventContent.KeyVerificationDone -> {
                buf.putInt(11)
                Unit
            }
            is MessageLikeEventContent.ReactionContent -> {
                buf.putInt(12)
                FfiConverterString.write(value.`relatedEventId`, buf)
                Unit
            }
            is MessageLikeEventContent.RoomEncrypted -> {
                buf.putInt(13)
                Unit
            }
            is MessageLikeEventContent.RoomMessage -> {
                buf.putInt(14)
                FfiConverterTypeMessageType.write(value.`messageType`, buf)
                Unit
            }
            is MessageLikeEventContent.RoomRedaction -> {
                buf.putInt(15)
                Unit
            }
            is MessageLikeEventContent.Sticker -> {
                buf.putInt(16)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class MessageLikeEventType {
    CALL_ANSWER,CALL_INVITE,CALL_HANGUP,CALL_CANDIDATES,KEY_VERIFICATION_READY,KEY_VERIFICATION_START,KEY_VERIFICATION_CANCEL,KEY_VERIFICATION_ACCEPT,KEY_VERIFICATION_KEY,KEY_VERIFICATION_MAC,KEY_VERIFICATION_DONE,REACTION_SENT,ROOM_ENCRYPTED,ROOM_MESSAGE,ROOM_REDACTION,STICKER;
}

public object FfiConverterTypeMessageLikeEventType: FfiConverterRustBuffer<MessageLikeEventType> {
    override fun read(buf: ByteBuffer) = try {
        MessageLikeEventType.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: MessageLikeEventType) = 4

    override fun write(value: MessageLikeEventType, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






sealed class MessageType: Disposable  {
    data class Emote(
        val `content`: EmoteMessageContent
        ) : MessageType()
    data class Image(
        val `content`: ImageMessageContent
        ) : MessageType()
    data class Audio(
        val `content`: AudioMessageContent
        ) : MessageType()
    data class Video(
        val `content`: VideoMessageContent
        ) : MessageType()
    data class File(
        val `content`: FileMessageContent
        ) : MessageType()
    data class Notice(
        val `content`: NoticeMessageContent
        ) : MessageType()
    data class Text(
        val `content`: TextMessageContent
        ) : MessageType()
    data class Location(
        val `content`: LocationContent
        ) : MessageType()
    

    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        when(this) {
            is MessageType.Emote -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.Image -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.Audio -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.Video -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.File -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.Notice -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.Text -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.Location -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
    
}

public object FfiConverterTypeMessageType : FfiConverterRustBuffer<MessageType>{
    override fun read(buf: ByteBuffer): MessageType {
        return when(buf.getInt()) {
            1 -> MessageType.Emote(
                FfiConverterTypeEmoteMessageContent.read(buf),
                )
            2 -> MessageType.Image(
                FfiConverterTypeImageMessageContent.read(buf),
                )
            3 -> MessageType.Audio(
                FfiConverterTypeAudioMessageContent.read(buf),
                )
            4 -> MessageType.Video(
                FfiConverterTypeVideoMessageContent.read(buf),
                )
            5 -> MessageType.File(
                FfiConverterTypeFileMessageContent.read(buf),
                )
            6 -> MessageType.Notice(
                FfiConverterTypeNoticeMessageContent.read(buf),
                )
            7 -> MessageType.Text(
                FfiConverterTypeTextMessageContent.read(buf),
                )
            8 -> MessageType.Location(
                FfiConverterTypeLocationContent.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: MessageType) = when(value) {
        is MessageType.Emote -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeEmoteMessageContent.allocationSize(value.`content`)
            )
        }
        is MessageType.Image -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeImageMessageContent.allocationSize(value.`content`)
            )
        }
        is MessageType.Audio -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeAudioMessageContent.allocationSize(value.`content`)
            )
        }
        is MessageType.Video -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeVideoMessageContent.allocationSize(value.`content`)
            )
        }
        is MessageType.File -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeFileMessageContent.allocationSize(value.`content`)
            )
        }
        is MessageType.Notice -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeNoticeMessageContent.allocationSize(value.`content`)
            )
        }
        is MessageType.Text -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeTextMessageContent.allocationSize(value.`content`)
            )
        }
        is MessageType.Location -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeLocationContent.allocationSize(value.`content`)
            )
        }
    }

    override fun write(value: MessageType, buf: ByteBuffer) {
        when(value) {
            is MessageType.Emote -> {
                buf.putInt(1)
                FfiConverterTypeEmoteMessageContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.Image -> {
                buf.putInt(2)
                FfiConverterTypeImageMessageContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.Audio -> {
                buf.putInt(3)
                FfiConverterTypeAudioMessageContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.Video -> {
                buf.putInt(4)
                FfiConverterTypeVideoMessageContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.File -> {
                buf.putInt(5)
                FfiConverterTypeFileMessageContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.Notice -> {
                buf.putInt(6)
                FfiConverterTypeNoticeMessageContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.Text -> {
                buf.putInt(7)
                FfiConverterTypeTextMessageContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.Location -> {
                buf.putInt(8)
                FfiConverterTypeLocationContent.write(value.`content`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class NotificationEvent: Disposable  {
    data class Timeline(
        val `event`: TimelineEventType
        ) : NotificationEvent()
    object Invite : NotificationEvent()
    
    

    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        when(this) {
            is NotificationEvent.Timeline -> {
                
    Disposable.destroy(
        this.`event`)
                
            }
            is NotificationEvent.Invite -> {// Nothing to destroy
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
    
}

public object FfiConverterTypeNotificationEvent : FfiConverterRustBuffer<NotificationEvent>{
    override fun read(buf: ByteBuffer): NotificationEvent {
        return when(buf.getInt()) {
            1 -> NotificationEvent.Timeline(
                FfiConverterTypeTimelineEventType.read(buf),
                )
            2 -> NotificationEvent.Invite
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: NotificationEvent) = when(value) {
        is NotificationEvent.Timeline -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeTimelineEventType.allocationSize(value.`event`)
            )
        }
        is NotificationEvent.Invite -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
    }

    override fun write(value: NotificationEvent, buf: ByteBuffer) {
        when(value) {
            is NotificationEvent.Timeline -> {
                buf.putInt(1)
                FfiConverterTypeTimelineEventType.write(value.`event`, buf)
                Unit
            }
            is NotificationEvent.Invite -> {
                buf.putInt(2)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}







sealed class NotificationSettingsException(message: String): Exception(message) {
        // Each variant is a nested class
        // Flat enums carries a string error message, so no special implementation is necessary.
        class Generic(message: String) : NotificationSettingsException(message)
        class InvalidParameter(message: String) : NotificationSettingsException(message)
        class InvalidRoomId(message: String) : NotificationSettingsException(message)
        class RuleNotFound(message: String) : NotificationSettingsException(message)
        class UnableToAddPushRule(message: String) : NotificationSettingsException(message)
        class UnableToRemovePushRule(message: String) : NotificationSettingsException(message)
        class UnableToSavePushRules(message: String) : NotificationSettingsException(message)
        class UnableToUpdatePushRule(message: String) : NotificationSettingsException(message)
        

    companion object ErrorHandler : CallStatusErrorHandler<NotificationSettingsException> {
        override fun lift(error_buf: RustBuffer.ByValue): NotificationSettingsException = FfiConverterTypeNotificationSettingsError.lift(error_buf)
    }
}

public object FfiConverterTypeNotificationSettingsError : FfiConverterRustBuffer<NotificationSettingsException> {
    override fun read(buf: ByteBuffer): NotificationSettingsException {
        
            return when(buf.getInt()) {
            1 -> NotificationSettingsException.Generic(FfiConverterString.read(buf))
            2 -> NotificationSettingsException.InvalidParameter(FfiConverterString.read(buf))
            3 -> NotificationSettingsException.InvalidRoomId(FfiConverterString.read(buf))
            4 -> NotificationSettingsException.RuleNotFound(FfiConverterString.read(buf))
            5 -> NotificationSettingsException.UnableToAddPushRule(FfiConverterString.read(buf))
            6 -> NotificationSettingsException.UnableToRemovePushRule(FfiConverterString.read(buf))
            7 -> NotificationSettingsException.UnableToSavePushRules(FfiConverterString.read(buf))
            8 -> NotificationSettingsException.UnableToUpdatePushRule(FfiConverterString.read(buf))
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
        
    }

    override fun allocationSize(value: NotificationSettingsException): Int {
        return 4
    }

    override fun write(value: NotificationSettingsException, buf: ByteBuffer) {
        when(value) {
            is NotificationSettingsException.Generic -> {
                buf.putInt(1)
                Unit
            }
            is NotificationSettingsException.InvalidParameter -> {
                buf.putInt(2)
                Unit
            }
            is NotificationSettingsException.InvalidRoomId -> {
                buf.putInt(3)
                Unit
            }
            is NotificationSettingsException.RuleNotFound -> {
                buf.putInt(4)
                Unit
            }
            is NotificationSettingsException.UnableToAddPushRule -> {
                buf.putInt(5)
                Unit
            }
            is NotificationSettingsException.UnableToRemovePushRule -> {
                buf.putInt(6)
                Unit
            }
            is NotificationSettingsException.UnableToSavePushRules -> {
                buf.putInt(7)
                Unit
            }
            is NotificationSettingsException.UnableToUpdatePushRule -> {
                buf.putInt(8)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




sealed class OtherState {
    object PolicyRuleRoom : OtherState()
    
    object PolicyRuleServer : OtherState()
    
    object PolicyRuleUser : OtherState()
    
    object RoomAliases : OtherState()
    
    data class RoomAvatar(
        val `url`: String?
        ) : OtherState()
    object RoomCanonicalAlias : OtherState()
    
    object RoomCreate : OtherState()
    
    object RoomEncryption : OtherState()
    
    object RoomGuestAccess : OtherState()
    
    object RoomHistoryVisibility : OtherState()
    
    object RoomJoinRules : OtherState()
    
    data class RoomName(
        val `name`: String?
        ) : OtherState()
    object RoomPinnedEvents : OtherState()
    
    object RoomPowerLevels : OtherState()
    
    object RoomServerAcl : OtherState()
    
    data class RoomThirdPartyInvite(
        val `displayName`: String?
        ) : OtherState()
    object RoomTombstone : OtherState()
    
    data class RoomTopic(
        val `topic`: String?
        ) : OtherState()
    object SpaceChild : OtherState()
    
    object SpaceParent : OtherState()
    
    data class Custom(
        val `eventType`: String
        ) : OtherState()
    

    
}

public object FfiConverterTypeOtherState : FfiConverterRustBuffer<OtherState>{
    override fun read(buf: ByteBuffer): OtherState {
        return when(buf.getInt()) {
            1 -> OtherState.PolicyRuleRoom
            2 -> OtherState.PolicyRuleServer
            3 -> OtherState.PolicyRuleUser
            4 -> OtherState.RoomAliases
            5 -> OtherState.RoomAvatar(
                FfiConverterOptionalString.read(buf),
                )
            6 -> OtherState.RoomCanonicalAlias
            7 -> OtherState.RoomCreate
            8 -> OtherState.RoomEncryption
            9 -> OtherState.RoomGuestAccess
            10 -> OtherState.RoomHistoryVisibility
            11 -> OtherState.RoomJoinRules
            12 -> OtherState.RoomName(
                FfiConverterOptionalString.read(buf),
                )
            13 -> OtherState.RoomPinnedEvents
            14 -> OtherState.RoomPowerLevels
            15 -> OtherState.RoomServerAcl
            16 -> OtherState.RoomThirdPartyInvite(
                FfiConverterOptionalString.read(buf),
                )
            17 -> OtherState.RoomTombstone
            18 -> OtherState.RoomTopic(
                FfiConverterOptionalString.read(buf),
                )
            19 -> OtherState.SpaceChild
            20 -> OtherState.SpaceParent
            21 -> OtherState.Custom(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: OtherState) = when(value) {
        is OtherState.PolicyRuleRoom -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.PolicyRuleServer -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.PolicyRuleUser -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomAliases -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomAvatar -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterOptionalString.allocationSize(value.`url`)
            )
        }
        is OtherState.RoomCanonicalAlias -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomCreate -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomEncryption -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomGuestAccess -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomHistoryVisibility -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomJoinRules -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomName -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterOptionalString.allocationSize(value.`name`)
            )
        }
        is OtherState.RoomPinnedEvents -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomPowerLevels -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomServerAcl -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomThirdPartyInvite -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterOptionalString.allocationSize(value.`displayName`)
            )
        }
        is OtherState.RoomTombstone -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomTopic -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterOptionalString.allocationSize(value.`topic`)
            )
        }
        is OtherState.SpaceChild -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.SpaceParent -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.Custom -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`eventType`)
            )
        }
    }

    override fun write(value: OtherState, buf: ByteBuffer) {
        when(value) {
            is OtherState.PolicyRuleRoom -> {
                buf.putInt(1)
                Unit
            }
            is OtherState.PolicyRuleServer -> {
                buf.putInt(2)
                Unit
            }
            is OtherState.PolicyRuleUser -> {
                buf.putInt(3)
                Unit
            }
            is OtherState.RoomAliases -> {
                buf.putInt(4)
                Unit
            }
            is OtherState.RoomAvatar -> {
                buf.putInt(5)
                FfiConverterOptionalString.write(value.`url`, buf)
                Unit
            }
            is OtherState.RoomCanonicalAlias -> {
                buf.putInt(6)
                Unit
            }
            is OtherState.RoomCreate -> {
                buf.putInt(7)
                Unit
            }
            is OtherState.RoomEncryption -> {
                buf.putInt(8)
                Unit
            }
            is OtherState.RoomGuestAccess -> {
                buf.putInt(9)
                Unit
            }
            is OtherState.RoomHistoryVisibility -> {
                buf.putInt(10)
                Unit
            }
            is OtherState.RoomJoinRules -> {
                buf.putInt(11)
                Unit
            }
            is OtherState.RoomName -> {
                buf.putInt(12)
                FfiConverterOptionalString.write(value.`name`, buf)
                Unit
            }
            is OtherState.RoomPinnedEvents -> {
                buf.putInt(13)
                Unit
            }
            is OtherState.RoomPowerLevels -> {
                buf.putInt(14)
                Unit
            }
            is OtherState.RoomServerAcl -> {
                buf.putInt(15)
                Unit
            }
            is OtherState.RoomThirdPartyInvite -> {
                buf.putInt(16)
                FfiConverterOptionalString.write(value.`displayName`, buf)
                Unit
            }
            is OtherState.RoomTombstone -> {
                buf.putInt(17)
                Unit
            }
            is OtherState.RoomTopic -> {
                buf.putInt(18)
                FfiConverterOptionalString.write(value.`topic`, buf)
                Unit
            }
            is OtherState.SpaceChild -> {
                buf.putInt(19)
                Unit
            }
            is OtherState.SpaceParent -> {
                buf.putInt(20)
                Unit
            }
            is OtherState.Custom -> {
                buf.putInt(21)
                FfiConverterString.write(value.`eventType`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class PaginationOptions {
    data class SingleRequest(
        val `eventLimit`: UShort, 
        val `waitForToken`: Boolean
        ) : PaginationOptions()
    data class UntilNumItems(
        val `eventLimit`: UShort, 
        val `items`: UShort, 
        val `waitForToken`: Boolean
        ) : PaginationOptions()
    

    
}

public object FfiConverterTypePaginationOptions : FfiConverterRustBuffer<PaginationOptions>{
    override fun read(buf: ByteBuffer): PaginationOptions {
        return when(buf.getInt()) {
            1 -> PaginationOptions.SingleRequest(
                FfiConverterUShort.read(buf),
                FfiConverterBoolean.read(buf),
                )
            2 -> PaginationOptions.UntilNumItems(
                FfiConverterUShort.read(buf),
                FfiConverterUShort.read(buf),
                FfiConverterBoolean.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: PaginationOptions) = when(value) {
        is PaginationOptions.SingleRequest -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterUShort.allocationSize(value.`eventLimit`)
                + FfiConverterBoolean.allocationSize(value.`waitForToken`)
            )
        }
        is PaginationOptions.UntilNumItems -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterUShort.allocationSize(value.`eventLimit`)
                + FfiConverterUShort.allocationSize(value.`items`)
                + FfiConverterBoolean.allocationSize(value.`waitForToken`)
            )
        }
    }

    override fun write(value: PaginationOptions, buf: ByteBuffer) {
        when(value) {
            is PaginationOptions.SingleRequest -> {
                buf.putInt(1)
                FfiConverterUShort.write(value.`eventLimit`, buf)
                FfiConverterBoolean.write(value.`waitForToken`, buf)
                Unit
            }
            is PaginationOptions.UntilNumItems -> {
                buf.putInt(2)
                FfiConverterUShort.write(value.`eventLimit`, buf)
                FfiConverterUShort.write(value.`items`, buf)
                FfiConverterBoolean.write(value.`waitForToken`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class PollKind {
    DISCLOSED,UNDISCLOSED;
}

public object FfiConverterTypePollKind: FfiConverterRustBuffer<PollKind> {
    override fun read(buf: ByteBuffer) = try {
        PollKind.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: PollKind) = 4

    override fun write(value: PollKind, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






sealed class ProfileDetails {
    object Unavailable : ProfileDetails()
    
    object Pending : ProfileDetails()
    
    data class Ready(
        val `displayName`: String?, 
        val `displayNameAmbiguous`: Boolean, 
        val `avatarUrl`: String?
        ) : ProfileDetails()
    data class Error(
        val `message`: String
        ) : ProfileDetails()
    

    
}

public object FfiConverterTypeProfileDetails : FfiConverterRustBuffer<ProfileDetails>{
    override fun read(buf: ByteBuffer): ProfileDetails {
        return when(buf.getInt()) {
            1 -> ProfileDetails.Unavailable
            2 -> ProfileDetails.Pending
            3 -> ProfileDetails.Ready(
                FfiConverterOptionalString.read(buf),
                FfiConverterBoolean.read(buf),
                FfiConverterOptionalString.read(buf),
                )
            4 -> ProfileDetails.Error(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: ProfileDetails) = when(value) {
        is ProfileDetails.Unavailable -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is ProfileDetails.Pending -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is ProfileDetails.Ready -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterOptionalString.allocationSize(value.`displayName`)
                + FfiConverterBoolean.allocationSize(value.`displayNameAmbiguous`)
                + FfiConverterOptionalString.allocationSize(value.`avatarUrl`)
            )
        }
        is ProfileDetails.Error -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`message`)
            )
        }
    }

    override fun write(value: ProfileDetails, buf: ByteBuffer) {
        when(value) {
            is ProfileDetails.Unavailable -> {
                buf.putInt(1)
                Unit
            }
            is ProfileDetails.Pending -> {
                buf.putInt(2)
                Unit
            }
            is ProfileDetails.Ready -> {
                buf.putInt(3)
                FfiConverterOptionalString.write(value.`displayName`, buf)
                FfiConverterBoolean.write(value.`displayNameAmbiguous`, buf)
                FfiConverterOptionalString.write(value.`avatarUrl`, buf)
                Unit
            }
            is ProfileDetails.Error -> {
                buf.putInt(4)
                FfiConverterString.write(value.`message`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class PushFormat {
    EVENT_ID_ONLY;
}

public object FfiConverterTypePushFormat: FfiConverterRustBuffer<PushFormat> {
    override fun read(buf: ByteBuffer) = try {
        PushFormat.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: PushFormat) = 4

    override fun write(value: PushFormat, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






sealed class PusherKind {
    data class Http(
        val `data`: HttpPusherData
        ) : PusherKind()
    object Email : PusherKind()
    
    

    
}

public object FfiConverterTypePusherKind : FfiConverterRustBuffer<PusherKind>{
    override fun read(buf: ByteBuffer): PusherKind {
        return when(buf.getInt()) {
            1 -> PusherKind.Http(
                FfiConverterTypeHttpPusherData.read(buf),
                )
            2 -> PusherKind.Email
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: PusherKind) = when(value) {
        is PusherKind.Http -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeHttpPusherData.allocationSize(value.`data`)
            )
        }
        is PusherKind.Email -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
    }

    override fun write(value: PusherKind, buf: ByteBuffer) {
        when(value) {
            is PusherKind.Http -> {
                buf.putInt(1)
                FfiConverterTypeHttpPusherData.write(value.`data`, buf)
                Unit
            }
            is PusherKind.Email -> {
                buf.putInt(2)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class RepliedToEventDetails: Disposable  {
    object Unavailable : RepliedToEventDetails()
    
    object Pending : RepliedToEventDetails()
    
    data class Ready(
        val `content`: TimelineItemContent, 
        val `sender`: String, 
        val `senderProfile`: ProfileDetails
        ) : RepliedToEventDetails()
    data class Error(
        val `message`: String
        ) : RepliedToEventDetails()
    

    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        when(this) {
            is RepliedToEventDetails.Unavailable -> {// Nothing to destroy
            }
            is RepliedToEventDetails.Pending -> {// Nothing to destroy
            }
            is RepliedToEventDetails.Ready -> {
                
    Disposable.destroy(
        this.`content`, 
        this.`sender`, 
        this.`senderProfile`)
                
            }
            is RepliedToEventDetails.Error -> {
                
    Disposable.destroy(
        this.`message`)
                
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
    
}

public object FfiConverterTypeRepliedToEventDetails : FfiConverterRustBuffer<RepliedToEventDetails>{
    override fun read(buf: ByteBuffer): RepliedToEventDetails {
        return when(buf.getInt()) {
            1 -> RepliedToEventDetails.Unavailable
            2 -> RepliedToEventDetails.Pending
            3 -> RepliedToEventDetails.Ready(
                FfiConverterTypeTimelineItemContent.read(buf),
                FfiConverterString.read(buf),
                FfiConverterTypeProfileDetails.read(buf),
                )
            4 -> RepliedToEventDetails.Error(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: RepliedToEventDetails) = when(value) {
        is RepliedToEventDetails.Unavailable -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is RepliedToEventDetails.Pending -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is RepliedToEventDetails.Ready -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeTimelineItemContent.allocationSize(value.`content`)
                + FfiConverterString.allocationSize(value.`sender`)
                + FfiConverterTypeProfileDetails.allocationSize(value.`senderProfile`)
            )
        }
        is RepliedToEventDetails.Error -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`message`)
            )
        }
    }

    override fun write(value: RepliedToEventDetails, buf: ByteBuffer) {
        when(value) {
            is RepliedToEventDetails.Unavailable -> {
                buf.putInt(1)
                Unit
            }
            is RepliedToEventDetails.Pending -> {
                buf.putInt(2)
                Unit
            }
            is RepliedToEventDetails.Ready -> {
                buf.putInt(3)
                FfiConverterTypeTimelineItemContent.write(value.`content`, buf)
                FfiConverterString.write(value.`sender`, buf)
                FfiConverterTypeProfileDetails.write(value.`senderProfile`, buf)
                Unit
            }
            is RepliedToEventDetails.Error -> {
                buf.putInt(4)
                FfiConverterString.write(value.`message`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}







sealed class RoomException(message: String): Exception(message) {
        // Each variant is a nested class
        // Flat enums carries a string error message, so no special implementation is necessary.
        class InvalidAttachmentData(message: String) : RoomException(message)
        class InvalidAttachmentMimeType(message: String) : RoomException(message)
        class TimelineUnavailable(message: String) : RoomException(message)
        class InvalidThumbnailData(message: String) : RoomException(message)
        class FailedSendingAttachment(message: String) : RoomException(message)
        

    companion object ErrorHandler : CallStatusErrorHandler<RoomException> {
        override fun lift(error_buf: RustBuffer.ByValue): RoomException = FfiConverterTypeRoomError.lift(error_buf)
    }
}

public object FfiConverterTypeRoomError : FfiConverterRustBuffer<RoomException> {
    override fun read(buf: ByteBuffer): RoomException {
        
            return when(buf.getInt()) {
            1 -> RoomException.InvalidAttachmentData(FfiConverterString.read(buf))
            2 -> RoomException.InvalidAttachmentMimeType(FfiConverterString.read(buf))
            3 -> RoomException.TimelineUnavailable(FfiConverterString.read(buf))
            4 -> RoomException.InvalidThumbnailData(FfiConverterString.read(buf))
            5 -> RoomException.FailedSendingAttachment(FfiConverterString.read(buf))
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
        
    }

    override fun allocationSize(value: RoomException): Int {
        return 4
    }

    override fun write(value: RoomException, buf: ByteBuffer) {
        when(value) {
            is RoomException.InvalidAttachmentData -> {
                buf.putInt(1)
                Unit
            }
            is RoomException.InvalidAttachmentMimeType -> {
                buf.putInt(2)
                Unit
            }
            is RoomException.TimelineUnavailable -> {
                buf.putInt(3)
                Unit
            }
            is RoomException.InvalidThumbnailData -> {
                buf.putInt(4)
                Unit
            }
            is RoomException.FailedSendingAttachment -> {
                buf.putInt(5)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




sealed class RoomListEntriesUpdate {
    data class Append(
        val `values`: List<RoomListEntry>
        ) : RoomListEntriesUpdate()
    object Clear : RoomListEntriesUpdate()
    
    data class PushFront(
        val `value`: RoomListEntry
        ) : RoomListEntriesUpdate()
    data class PushBack(
        val `value`: RoomListEntry
        ) : RoomListEntriesUpdate()
    object PopFront : RoomListEntriesUpdate()
    
    object PopBack : RoomListEntriesUpdate()
    
    data class Insert(
        val `index`: UInt, 
        val `value`: RoomListEntry
        ) : RoomListEntriesUpdate()
    data class Set(
        val `index`: UInt, 
        val `value`: RoomListEntry
        ) : RoomListEntriesUpdate()
    data class Remove(
        val `index`: UInt
        ) : RoomListEntriesUpdate()
    data class Reset(
        val `values`: List<RoomListEntry>
        ) : RoomListEntriesUpdate()
    

    
}

public object FfiConverterTypeRoomListEntriesUpdate : FfiConverterRustBuffer<RoomListEntriesUpdate>{
    override fun read(buf: ByteBuffer): RoomListEntriesUpdate {
        return when(buf.getInt()) {
            1 -> RoomListEntriesUpdate.Append(
                FfiConverterSequenceTypeRoomListEntry.read(buf),
                )
            2 -> RoomListEntriesUpdate.Clear
            3 -> RoomListEntriesUpdate.PushFront(
                FfiConverterTypeRoomListEntry.read(buf),
                )
            4 -> RoomListEntriesUpdate.PushBack(
                FfiConverterTypeRoomListEntry.read(buf),
                )
            5 -> RoomListEntriesUpdate.PopFront
            6 -> RoomListEntriesUpdate.PopBack
            7 -> RoomListEntriesUpdate.Insert(
                FfiConverterUInt.read(buf),
                FfiConverterTypeRoomListEntry.read(buf),
                )
            8 -> RoomListEntriesUpdate.Set(
                FfiConverterUInt.read(buf),
                FfiConverterTypeRoomListEntry.read(buf),
                )
            9 -> RoomListEntriesUpdate.Remove(
                FfiConverterUInt.read(buf),
                )
            10 -> RoomListEntriesUpdate.Reset(
                FfiConverterSequenceTypeRoomListEntry.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: RoomListEntriesUpdate) = when(value) {
        is RoomListEntriesUpdate.Append -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterSequenceTypeRoomListEntry.allocationSize(value.`values`)
            )
        }
        is RoomListEntriesUpdate.Clear -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is RoomListEntriesUpdate.PushFront -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeRoomListEntry.allocationSize(value.`value`)
            )
        }
        is RoomListEntriesUpdate.PushBack -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeRoomListEntry.allocationSize(value.`value`)
            )
        }
        is RoomListEntriesUpdate.PopFront -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is RoomListEntriesUpdate.PopBack -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is RoomListEntriesUpdate.Insert -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterUInt.allocationSize(value.`index`)
                + FfiConverterTypeRoomListEntry.allocationSize(value.`value`)
            )
        }
        is RoomListEntriesUpdate.Set -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterUInt.allocationSize(value.`index`)
                + FfiConverterTypeRoomListEntry.allocationSize(value.`value`)
            )
        }
        is RoomListEntriesUpdate.Remove -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterUInt.allocationSize(value.`index`)
            )
        }
        is RoomListEntriesUpdate.Reset -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterSequenceTypeRoomListEntry.allocationSize(value.`values`)
            )
        }
    }

    override fun write(value: RoomListEntriesUpdate, buf: ByteBuffer) {
        when(value) {
            is RoomListEntriesUpdate.Append -> {
                buf.putInt(1)
                FfiConverterSequenceTypeRoomListEntry.write(value.`values`, buf)
                Unit
            }
            is RoomListEntriesUpdate.Clear -> {
                buf.putInt(2)
                Unit
            }
            is RoomListEntriesUpdate.PushFront -> {
                buf.putInt(3)
                FfiConverterTypeRoomListEntry.write(value.`value`, buf)
                Unit
            }
            is RoomListEntriesUpdate.PushBack -> {
                buf.putInt(4)
                FfiConverterTypeRoomListEntry.write(value.`value`, buf)
                Unit
            }
            is RoomListEntriesUpdate.PopFront -> {
                buf.putInt(5)
                Unit
            }
            is RoomListEntriesUpdate.PopBack -> {
                buf.putInt(6)
                Unit
            }
            is RoomListEntriesUpdate.Insert -> {
                buf.putInt(7)
                FfiConverterUInt.write(value.`index`, buf)
                FfiConverterTypeRoomListEntry.write(value.`value`, buf)
                Unit
            }
            is RoomListEntriesUpdate.Set -> {
                buf.putInt(8)
                FfiConverterUInt.write(value.`index`, buf)
                FfiConverterTypeRoomListEntry.write(value.`value`, buf)
                Unit
            }
            is RoomListEntriesUpdate.Remove -> {
                buf.putInt(9)
                FfiConverterUInt.write(value.`index`, buf)
                Unit
            }
            is RoomListEntriesUpdate.Reset -> {
                buf.putInt(10)
                FfiConverterSequenceTypeRoomListEntry.write(value.`values`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class RoomListEntry {
    object Empty : RoomListEntry()
    
    data class Invalidated(
        val `roomId`: String
        ) : RoomListEntry()
    data class Filled(
        val `roomId`: String
        ) : RoomListEntry()
    

    
}

public object FfiConverterTypeRoomListEntry : FfiConverterRustBuffer<RoomListEntry>{
    override fun read(buf: ByteBuffer): RoomListEntry {
        return when(buf.getInt()) {
            1 -> RoomListEntry.Empty
            2 -> RoomListEntry.Invalidated(
                FfiConverterString.read(buf),
                )
            3 -> RoomListEntry.Filled(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: RoomListEntry) = when(value) {
        is RoomListEntry.Empty -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is RoomListEntry.Invalidated -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`roomId`)
            )
        }
        is RoomListEntry.Filled -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`roomId`)
            )
        }
    }

    override fun write(value: RoomListEntry, buf: ByteBuffer) {
        when(value) {
            is RoomListEntry.Empty -> {
                buf.putInt(1)
                Unit
            }
            is RoomListEntry.Invalidated -> {
                buf.putInt(2)
                FfiConverterString.write(value.`roomId`, buf)
                Unit
            }
            is RoomListEntry.Filled -> {
                buf.putInt(3)
                FfiConverterString.write(value.`roomId`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}







sealed class RoomListException: Exception() {
    // Each variant is a nested class
    
    class SlidingSync(
        val `error`: String
        ) : RoomListException() {
        override val message
            get() = "error=${ `error` }"
    }
    
    class UnknownList(
        val `listName`: String
        ) : RoomListException() {
        override val message
            get() = "listName=${ `listName` }"
    }
    
    class InputCannotBeApplied(
        ) : RoomListException() {
        override val message
            get() = ""
    }
    
    class RoomNotFound(
        val `roomName`: String
        ) : RoomListException() {
        override val message
            get() = "roomName=${ `roomName` }"
    }
    
    class InvalidRoomId(
        val `error`: String
        ) : RoomListException() {
        override val message
            get() = "error=${ `error` }"
    }
    

    companion object ErrorHandler : CallStatusErrorHandler<RoomListException> {
        override fun lift(error_buf: RustBuffer.ByValue): RoomListException = FfiConverterTypeRoomListError.lift(error_buf)
    }

    
}

public object FfiConverterTypeRoomListError : FfiConverterRustBuffer<RoomListException> {
    override fun read(buf: ByteBuffer): RoomListException {
        

        return when(buf.getInt()) {
            1 -> RoomListException.SlidingSync(
                FfiConverterString.read(buf),
                )
            2 -> RoomListException.UnknownList(
                FfiConverterString.read(buf),
                )
            3 -> RoomListException.InputCannotBeApplied()
            4 -> RoomListException.RoomNotFound(
                FfiConverterString.read(buf),
                )
            5 -> RoomListException.InvalidRoomId(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: RoomListException): Int {
        return when(value) {
            is RoomListException.SlidingSync -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`error`)
            )
            is RoomListException.UnknownList -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`listName`)
            )
            is RoomListException.InputCannotBeApplied -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
            )
            is RoomListException.RoomNotFound -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`roomName`)
            )
            is RoomListException.InvalidRoomId -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`error`)
            )
        }
    }

    override fun write(value: RoomListException, buf: ByteBuffer) {
        when(value) {
            is RoomListException.SlidingSync -> {
                buf.putInt(1)
                FfiConverterString.write(value.`error`, buf)
                Unit
            }
            is RoomListException.UnknownList -> {
                buf.putInt(2)
                FfiConverterString.write(value.`listName`, buf)
                Unit
            }
            is RoomListException.InputCannotBeApplied -> {
                buf.putInt(3)
                Unit
            }
            is RoomListException.RoomNotFound -> {
                buf.putInt(4)
                FfiConverterString.write(value.`roomName`, buf)
                Unit
            }
            is RoomListException.InvalidRoomId -> {
                buf.putInt(5)
                FfiConverterString.write(value.`error`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




sealed class RoomListInput {
    data class Viewport(
        val `ranges`: List<RoomListRange>
        ) : RoomListInput()
    

    
}

public object FfiConverterTypeRoomListInput : FfiConverterRustBuffer<RoomListInput>{
    override fun read(buf: ByteBuffer): RoomListInput {
        return when(buf.getInt()) {
            1 -> RoomListInput.Viewport(
                FfiConverterSequenceTypeRoomListRange.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: RoomListInput) = when(value) {
        is RoomListInput.Viewport -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterSequenceTypeRoomListRange.allocationSize(value.`ranges`)
            )
        }
    }

    override fun write(value: RoomListInput, buf: ByteBuffer) {
        when(value) {
            is RoomListInput.Viewport -> {
                buf.putInt(1)
                FfiConverterSequenceTypeRoomListRange.write(value.`ranges`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class RoomListLoadingState {
    object NotLoaded : RoomListLoadingState()
    
    data class Loaded(
        val `maximumNumberOfRooms`: UInt?
        ) : RoomListLoadingState()
    

    
}

public object FfiConverterTypeRoomListLoadingState : FfiConverterRustBuffer<RoomListLoadingState>{
    override fun read(buf: ByteBuffer): RoomListLoadingState {
        return when(buf.getInt()) {
            1 -> RoomListLoadingState.NotLoaded
            2 -> RoomListLoadingState.Loaded(
                FfiConverterOptionalUInt.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: RoomListLoadingState) = when(value) {
        is RoomListLoadingState.NotLoaded -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is RoomListLoadingState.Loaded -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterOptionalUInt.allocationSize(value.`maximumNumberOfRooms`)
            )
        }
    }

    override fun write(value: RoomListLoadingState, buf: ByteBuffer) {
        when(value) {
            is RoomListLoadingState.NotLoaded -> {
                buf.putInt(1)
                Unit
            }
            is RoomListLoadingState.Loaded -> {
                buf.putInt(2)
                FfiConverterOptionalUInt.write(value.`maximumNumberOfRooms`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class RoomListServiceState {
    INIT,SETTING_UP,RUNNING,ERROR,TERMINATED;
}

public object FfiConverterTypeRoomListServiceState: FfiConverterRustBuffer<RoomListServiceState> {
    override fun read(buf: ByteBuffer) = try {
        RoomListServiceState.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: RoomListServiceState) = 4

    override fun write(value: RoomListServiceState, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class RoomNotificationMode {
    ALL_MESSAGES,MENTIONS_AND_KEYWORDS_ONLY,MUTE;
}

public object FfiConverterTypeRoomNotificationMode: FfiConverterRustBuffer<RoomNotificationMode> {
    override fun read(buf: ByteBuffer) = try {
        RoomNotificationMode.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: RoomNotificationMode) = 4

    override fun write(value: RoomNotificationMode, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class RoomPreset {
    PRIVATE_CHAT,PUBLIC_CHAT,TRUSTED_PRIVATE_CHAT;
}

public object FfiConverterTypeRoomPreset: FfiConverterRustBuffer<RoomPreset> {
    override fun read(buf: ByteBuffer) = try {
        RoomPreset.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: RoomPreset) = 4

    override fun write(value: RoomPreset, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class RoomVisibility {
    PUBLIC,PRIVATE;
}

public object FfiConverterTypeRoomVisibility: FfiConverterRustBuffer<RoomVisibility> {
    override fun read(buf: ByteBuffer) = try {
        RoomVisibility.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: RoomVisibility) = 4

    override fun write(value: RoomVisibility, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






sealed class StateEventContent {
    object PolicyRuleRoom : StateEventContent()
    
    object PolicyRuleServer : StateEventContent()
    
    object PolicyRuleUser : StateEventContent()
    
    object RoomAliases : StateEventContent()
    
    object RoomAvatar : StateEventContent()
    
    object RoomCanonicalAlias : StateEventContent()
    
    object RoomCreate : StateEventContent()
    
    object RoomEncryption : StateEventContent()
    
    object RoomGuestAccess : StateEventContent()
    
    object RoomHistoryVisibility : StateEventContent()
    
    object RoomJoinRules : StateEventContent()
    
    data class RoomMemberContent(
        val `userId`: String, 
        val `membershipState`: MembershipState
        ) : StateEventContent()
    object RoomName : StateEventContent()
    
    object RoomPinnedEvents : StateEventContent()
    
    object RoomPowerLevels : StateEventContent()
    
    object RoomServerAcl : StateEventContent()
    
    object RoomThirdPartyInvite : StateEventContent()
    
    object RoomTombstone : StateEventContent()
    
    object RoomTopic : StateEventContent()
    
    object SpaceChild : StateEventContent()
    
    object SpaceParent : StateEventContent()
    
    

    
}

public object FfiConverterTypeStateEventContent : FfiConverterRustBuffer<StateEventContent>{
    override fun read(buf: ByteBuffer): StateEventContent {
        return when(buf.getInt()) {
            1 -> StateEventContent.PolicyRuleRoom
            2 -> StateEventContent.PolicyRuleServer
            3 -> StateEventContent.PolicyRuleUser
            4 -> StateEventContent.RoomAliases
            5 -> StateEventContent.RoomAvatar
            6 -> StateEventContent.RoomCanonicalAlias
            7 -> StateEventContent.RoomCreate
            8 -> StateEventContent.RoomEncryption
            9 -> StateEventContent.RoomGuestAccess
            10 -> StateEventContent.RoomHistoryVisibility
            11 -> StateEventContent.RoomJoinRules
            12 -> StateEventContent.RoomMemberContent(
                FfiConverterString.read(buf),
                FfiConverterTypeMembershipState.read(buf),
                )
            13 -> StateEventContent.RoomName
            14 -> StateEventContent.RoomPinnedEvents
            15 -> StateEventContent.RoomPowerLevels
            16 -> StateEventContent.RoomServerAcl
            17 -> StateEventContent.RoomThirdPartyInvite
            18 -> StateEventContent.RoomTombstone
            19 -> StateEventContent.RoomTopic
            20 -> StateEventContent.SpaceChild
            21 -> StateEventContent.SpaceParent
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: StateEventContent) = when(value) {
        is StateEventContent.PolicyRuleRoom -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.PolicyRuleServer -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.PolicyRuleUser -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomAliases -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomAvatar -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomCanonicalAlias -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomCreate -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomEncryption -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomGuestAccess -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomHistoryVisibility -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomJoinRules -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomMemberContent -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`userId`)
                + FfiConverterTypeMembershipState.allocationSize(value.`membershipState`)
            )
        }
        is StateEventContent.RoomName -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomPinnedEvents -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomPowerLevels -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomServerAcl -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomThirdPartyInvite -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomTombstone -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomTopic -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.SpaceChild -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.SpaceParent -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
    }

    override fun write(value: StateEventContent, buf: ByteBuffer) {
        when(value) {
            is StateEventContent.PolicyRuleRoom -> {
                buf.putInt(1)
                Unit
            }
            is StateEventContent.PolicyRuleServer -> {
                buf.putInt(2)
                Unit
            }
            is StateEventContent.PolicyRuleUser -> {
                buf.putInt(3)
                Unit
            }
            is StateEventContent.RoomAliases -> {
                buf.putInt(4)
                Unit
            }
            is StateEventContent.RoomAvatar -> {
                buf.putInt(5)
                Unit
            }
            is StateEventContent.RoomCanonicalAlias -> {
                buf.putInt(6)
                Unit
            }
            is StateEventContent.RoomCreate -> {
                buf.putInt(7)
                Unit
            }
            is StateEventContent.RoomEncryption -> {
                buf.putInt(8)
                Unit
            }
            is StateEventContent.RoomGuestAccess -> {
                buf.putInt(9)
                Unit
            }
            is StateEventContent.RoomHistoryVisibility -> {
                buf.putInt(10)
                Unit
            }
            is StateEventContent.RoomJoinRules -> {
                buf.putInt(11)
                Unit
            }
            is StateEventContent.RoomMemberContent -> {
                buf.putInt(12)
                FfiConverterString.write(value.`userId`, buf)
                FfiConverterTypeMembershipState.write(value.`membershipState`, buf)
                Unit
            }
            is StateEventContent.RoomName -> {
                buf.putInt(13)
                Unit
            }
            is StateEventContent.RoomPinnedEvents -> {
                buf.putInt(14)
                Unit
            }
            is StateEventContent.RoomPowerLevels -> {
                buf.putInt(15)
                Unit
            }
            is StateEventContent.RoomServerAcl -> {
                buf.putInt(16)
                Unit
            }
            is StateEventContent.RoomThirdPartyInvite -> {
                buf.putInt(17)
                Unit
            }
            is StateEventContent.RoomTombstone -> {
                buf.putInt(18)
                Unit
            }
            is StateEventContent.RoomTopic -> {
                buf.putInt(19)
                Unit
            }
            is StateEventContent.SpaceChild -> {
                buf.putInt(20)
                Unit
            }
            is StateEventContent.SpaceParent -> {
                buf.putInt(21)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class StateEventType {
    POLICY_RULE_ROOM,POLICY_RULE_SERVER,POLICY_RULE_USER,ROOM_ALIASES,ROOM_AVATAR,ROOM_CANONICAL_ALIAS,ROOM_CREATE,ROOM_ENCRYPTION,ROOM_GUEST_ACCESS,ROOM_HISTORY_VISIBILITY,ROOM_JOIN_RULES,ROOM_MEMBER_EVENT,ROOM_NAME,ROOM_PINNED_EVENTS,ROOM_POWER_LEVELS,ROOM_SERVER_ACL,ROOM_THIRD_PARTY_INVITE,ROOM_TOMBSTONE,ROOM_TOPIC,SPACE_CHILD,SPACE_PARENT;
}

public object FfiConverterTypeStateEventType: FfiConverterRustBuffer<StateEventType> {
    override fun read(buf: ByteBuffer) = try {
        StateEventType.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: StateEventType) = 4

    override fun write(value: StateEventType, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class SyncServiceState {
    IDLE,RUNNING,TERMINATED,ERROR;
}

public object FfiConverterTypeSyncServiceState: FfiConverterRustBuffer<SyncServiceState> {
    override fun read(buf: ByteBuffer) = try {
        SyncServiceState.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: SyncServiceState) = 4

    override fun write(value: SyncServiceState, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class TimelineChange {
    APPEND,CLEAR,INSERT,SET,REMOVE,PUSH_BACK,PUSH_FRONT,POP_BACK,POP_FRONT,RESET;
}

public object FfiConverterTypeTimelineChange: FfiConverterRustBuffer<TimelineChange> {
    override fun read(buf: ByteBuffer) = try {
        TimelineChange.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: TimelineChange) = 4

    override fun write(value: TimelineChange, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}







sealed class TimelineException(message: String): Exception(message) {
        // Each variant is a nested class
        // Flat enums carries a string error message, so no special implementation is necessary.
        class MissingMediaInfoField(message: String) : TimelineException(message)
        class InvalidMediaInfoField(message: String) : TimelineException(message)
        

    companion object ErrorHandler : CallStatusErrorHandler<TimelineException> {
        override fun lift(error_buf: RustBuffer.ByValue): TimelineException = FfiConverterTypeTimelineError.lift(error_buf)
    }
}

public object FfiConverterTypeTimelineError : FfiConverterRustBuffer<TimelineException> {
    override fun read(buf: ByteBuffer): TimelineException {
        
            return when(buf.getInt()) {
            1 -> TimelineException.MissingMediaInfoField(FfiConverterString.read(buf))
            2 -> TimelineException.InvalidMediaInfoField(FfiConverterString.read(buf))
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
        
    }

    override fun allocationSize(value: TimelineException): Int {
        return 4
    }

    override fun write(value: TimelineException, buf: ByteBuffer) {
        when(value) {
            is TimelineException.MissingMediaInfoField -> {
                buf.putInt(1)
                Unit
            }
            is TimelineException.InvalidMediaInfoField -> {
                buf.putInt(2)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




sealed class TimelineEventType: Disposable  {
    data class MessageLike(
        val `content`: MessageLikeEventContent
        ) : TimelineEventType()
    data class State(
        val `content`: StateEventContent
        ) : TimelineEventType()
    

    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        when(this) {
            is TimelineEventType.MessageLike -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is TimelineEventType.State -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
    
}

public object FfiConverterTypeTimelineEventType : FfiConverterRustBuffer<TimelineEventType>{
    override fun read(buf: ByteBuffer): TimelineEventType {
        return when(buf.getInt()) {
            1 -> TimelineEventType.MessageLike(
                FfiConverterTypeMessageLikeEventContent.read(buf),
                )
            2 -> TimelineEventType.State(
                FfiConverterTypeStateEventContent.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: TimelineEventType) = when(value) {
        is TimelineEventType.MessageLike -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeMessageLikeEventContent.allocationSize(value.`content`)
            )
        }
        is TimelineEventType.State -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeStateEventContent.allocationSize(value.`content`)
            )
        }
    }

    override fun write(value: TimelineEventType, buf: ByteBuffer) {
        when(value) {
            is TimelineEventType.MessageLike -> {
                buf.putInt(1)
                FfiConverterTypeMessageLikeEventContent.write(value.`content`, buf)
                Unit
            }
            is TimelineEventType.State -> {
                buf.putInt(2)
                FfiConverterTypeStateEventContent.write(value.`content`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class TimelineItemContentKind: Disposable  {
    object Message : TimelineItemContentKind()
    
    object RedactedMessage : TimelineItemContentKind()
    
    data class Sticker(
        val `body`: String, 
        val `info`: ImageInfo, 
        val `url`: String
        ) : TimelineItemContentKind()
    data class Poll(
        val `question`: String, 
        val `kind`: PollKind, 
        val `maxSelections`: ULong, 
        val `answers`: List<PollAnswer>, 
        val `votes`: Map<String, List<String>>, 
        val `endTime`: ULong?
        ) : TimelineItemContentKind()
    data class PollEnd(
        val `startEventId`: String
        ) : TimelineItemContentKind()
    data class UnableToDecrypt(
        val `msg`: EncryptedMessage
        ) : TimelineItemContentKind()
    data class RoomMembership(
        val `userId`: String, 
        val `change`: MembershipChange?
        ) : TimelineItemContentKind()
    data class ProfileChange(
        val `displayName`: String?, 
        val `prevDisplayName`: String?, 
        val `avatarUrl`: String?, 
        val `prevAvatarUrl`: String?
        ) : TimelineItemContentKind()
    data class State(
        val `stateKey`: String, 
        val `content`: OtherState
        ) : TimelineItemContentKind()
    data class FailedToParseMessageLike(
        val `eventType`: String, 
        val `error`: String
        ) : TimelineItemContentKind()
    data class FailedToParseState(
        val `eventType`: String, 
        val `stateKey`: String, 
        val `error`: String
        ) : TimelineItemContentKind()
    

    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        when(this) {
            is TimelineItemContentKind.Message -> {// Nothing to destroy
            }
            is TimelineItemContentKind.RedactedMessage -> {// Nothing to destroy
            }
            is TimelineItemContentKind.Sticker -> {
                
    Disposable.destroy(
        this.`body`, 
        this.`info`, 
        this.`url`)
                
            }
            is TimelineItemContentKind.Poll -> {
                
    Disposable.destroy(
        this.`question`, 
        this.`kind`, 
        this.`maxSelections`, 
        this.`answers`, 
        this.`votes`, 
        this.`endTime`)
                
            }
            is TimelineItemContentKind.PollEnd -> {
                
    Disposable.destroy(
        this.`startEventId`)
                
            }
            is TimelineItemContentKind.UnableToDecrypt -> {
                
    Disposable.destroy(
        this.`msg`)
                
            }
            is TimelineItemContentKind.RoomMembership -> {
                
    Disposable.destroy(
        this.`userId`, 
        this.`change`)
                
            }
            is TimelineItemContentKind.ProfileChange -> {
                
    Disposable.destroy(
        this.`displayName`, 
        this.`prevDisplayName`, 
        this.`avatarUrl`, 
        this.`prevAvatarUrl`)
                
            }
            is TimelineItemContentKind.State -> {
                
    Disposable.destroy(
        this.`stateKey`, 
        this.`content`)
                
            }
            is TimelineItemContentKind.FailedToParseMessageLike -> {
                
    Disposable.destroy(
        this.`eventType`, 
        this.`error`)
                
            }
            is TimelineItemContentKind.FailedToParseState -> {
                
    Disposable.destroy(
        this.`eventType`, 
        this.`stateKey`, 
        this.`error`)
                
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
    
}

public object FfiConverterTypeTimelineItemContentKind : FfiConverterRustBuffer<TimelineItemContentKind>{
    override fun read(buf: ByteBuffer): TimelineItemContentKind {
        return when(buf.getInt()) {
            1 -> TimelineItemContentKind.Message
            2 -> TimelineItemContentKind.RedactedMessage
            3 -> TimelineItemContentKind.Sticker(
                FfiConverterString.read(buf),
                FfiConverterTypeImageInfo.read(buf),
                FfiConverterString.read(buf),
                )
            4 -> TimelineItemContentKind.Poll(
                FfiConverterString.read(buf),
                FfiConverterTypePollKind.read(buf),
                FfiConverterULong.read(buf),
                FfiConverterSequenceTypePollAnswer.read(buf),
                FfiConverterMapStringSequenceString.read(buf),
                FfiConverterOptionalULong.read(buf),
                )
            5 -> TimelineItemContentKind.PollEnd(
                FfiConverterString.read(buf),
                )
            6 -> TimelineItemContentKind.UnableToDecrypt(
                FfiConverterTypeEncryptedMessage.read(buf),
                )
            7 -> TimelineItemContentKind.RoomMembership(
                FfiConverterString.read(buf),
                FfiConverterOptionalTypeMembershipChange.read(buf),
                )
            8 -> TimelineItemContentKind.ProfileChange(
                FfiConverterOptionalString.read(buf),
                FfiConverterOptionalString.read(buf),
                FfiConverterOptionalString.read(buf),
                FfiConverterOptionalString.read(buf),
                )
            9 -> TimelineItemContentKind.State(
                FfiConverterString.read(buf),
                FfiConverterTypeOtherState.read(buf),
                )
            10 -> TimelineItemContentKind.FailedToParseMessageLike(
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                )
            11 -> TimelineItemContentKind.FailedToParseState(
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: TimelineItemContentKind) = when(value) {
        is TimelineItemContentKind.Message -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is TimelineItemContentKind.RedactedMessage -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is TimelineItemContentKind.Sticker -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`body`)
                + FfiConverterTypeImageInfo.allocationSize(value.`info`)
                + FfiConverterString.allocationSize(value.`url`)
            )
        }
        is TimelineItemContentKind.Poll -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`question`)
                + FfiConverterTypePollKind.allocationSize(value.`kind`)
                + FfiConverterULong.allocationSize(value.`maxSelections`)
                + FfiConverterSequenceTypePollAnswer.allocationSize(value.`answers`)
                + FfiConverterMapStringSequenceString.allocationSize(value.`votes`)
                + FfiConverterOptionalULong.allocationSize(value.`endTime`)
            )
        }
        is TimelineItemContentKind.PollEnd -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`startEventId`)
            )
        }
        is TimelineItemContentKind.UnableToDecrypt -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeEncryptedMessage.allocationSize(value.`msg`)
            )
        }
        is TimelineItemContentKind.RoomMembership -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`userId`)
                + FfiConverterOptionalTypeMembershipChange.allocationSize(value.`change`)
            )
        }
        is TimelineItemContentKind.ProfileChange -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterOptionalString.allocationSize(value.`displayName`)
                + FfiConverterOptionalString.allocationSize(value.`prevDisplayName`)
                + FfiConverterOptionalString.allocationSize(value.`avatarUrl`)
                + FfiConverterOptionalString.allocationSize(value.`prevAvatarUrl`)
            )
        }
        is TimelineItemContentKind.State -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`stateKey`)
                + FfiConverterTypeOtherState.allocationSize(value.`content`)
            )
        }
        is TimelineItemContentKind.FailedToParseMessageLike -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`eventType`)
                + FfiConverterString.allocationSize(value.`error`)
            )
        }
        is TimelineItemContentKind.FailedToParseState -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`eventType`)
                + FfiConverterString.allocationSize(value.`stateKey`)
                + FfiConverterString.allocationSize(value.`error`)
            )
        }
    }

    override fun write(value: TimelineItemContentKind, buf: ByteBuffer) {
        when(value) {
            is TimelineItemContentKind.Message -> {
                buf.putInt(1)
                Unit
            }
            is TimelineItemContentKind.RedactedMessage -> {
                buf.putInt(2)
                Unit
            }
            is TimelineItemContentKind.Sticker -> {
                buf.putInt(3)
                FfiConverterString.write(value.`body`, buf)
                FfiConverterTypeImageInfo.write(value.`info`, buf)
                FfiConverterString.write(value.`url`, buf)
                Unit
            }
            is TimelineItemContentKind.Poll -> {
                buf.putInt(4)
                FfiConverterString.write(value.`question`, buf)
                FfiConverterTypePollKind.write(value.`kind`, buf)
                FfiConverterULong.write(value.`maxSelections`, buf)
                FfiConverterSequenceTypePollAnswer.write(value.`answers`, buf)
                FfiConverterMapStringSequenceString.write(value.`votes`, buf)
                FfiConverterOptionalULong.write(value.`endTime`, buf)
                Unit
            }
            is TimelineItemContentKind.PollEnd -> {
                buf.putInt(5)
                FfiConverterString.write(value.`startEventId`, buf)
                Unit
            }
            is TimelineItemContentKind.UnableToDecrypt -> {
                buf.putInt(6)
                FfiConverterTypeEncryptedMessage.write(value.`msg`, buf)
                Unit
            }
            is TimelineItemContentKind.RoomMembership -> {
                buf.putInt(7)
                FfiConverterString.write(value.`userId`, buf)
                FfiConverterOptionalTypeMembershipChange.write(value.`change`, buf)
                Unit
            }
            is TimelineItemContentKind.ProfileChange -> {
                buf.putInt(8)
                FfiConverterOptionalString.write(value.`displayName`, buf)
                FfiConverterOptionalString.write(value.`prevDisplayName`, buf)
                FfiConverterOptionalString.write(value.`avatarUrl`, buf)
                FfiConverterOptionalString.write(value.`prevAvatarUrl`, buf)
                Unit
            }
            is TimelineItemContentKind.State -> {
                buf.putInt(9)
                FfiConverterString.write(value.`stateKey`, buf)
                FfiConverterTypeOtherState.write(value.`content`, buf)
                Unit
            }
            is TimelineItemContentKind.FailedToParseMessageLike -> {
                buf.putInt(10)
                FfiConverterString.write(value.`eventType`, buf)
                FfiConverterString.write(value.`error`, buf)
                Unit
            }
            is TimelineItemContentKind.FailedToParseState -> {
                buf.putInt(11)
                FfiConverterString.write(value.`eventType`, buf)
                FfiConverterString.write(value.`stateKey`, buf)
                FfiConverterString.write(value.`error`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class VirtualTimelineItem {
    data class DayDivider(
        val `ts`: ULong
        ) : VirtualTimelineItem()
    object ReadMarker : VirtualTimelineItem()
    
    

    
}

public object FfiConverterTypeVirtualTimelineItem : FfiConverterRustBuffer<VirtualTimelineItem>{
    override fun read(buf: ByteBuffer): VirtualTimelineItem {
        return when(buf.getInt()) {
            1 -> VirtualTimelineItem.DayDivider(
                FfiConverterULong.read(buf),
                )
            2 -> VirtualTimelineItem.ReadMarker
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: VirtualTimelineItem) = when(value) {
        is VirtualTimelineItem.DayDivider -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterULong.allocationSize(value.`ts`)
            )
        }
        is VirtualTimelineItem.ReadMarker -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
    }

    override fun write(value: VirtualTimelineItem, buf: ByteBuffer) {
        when(value) {
            is VirtualTimelineItem.DayDivider -> {
                buf.putInt(1)
                FfiConverterULong.write(value.`ts`, buf)
                Unit
            }
            is VirtualTimelineItem.ReadMarker -> {
                buf.putInt(2)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






internal typealias Handle = Long
internal class ConcurrentHandleMap<T>(
    private val leftMap: MutableMap<Handle, T> = mutableMapOf(),
    private val rightMap: MutableMap<T, Handle> = mutableMapOf()
) {
    private val lock = java.util.concurrent.locks.ReentrantLock()
    private val currentHandle = AtomicLong(0L)
    private val stride = 1L

    fun insert(obj: T): Handle =
        lock.withLock {
            rightMap[obj] ?:
                currentHandle.getAndAdd(stride)
                    .also { handle ->
                        leftMap[handle] = obj
                        rightMap[obj] = handle
                    }
            }

    fun get(handle: Handle) = lock.withLock {
        leftMap[handle]
    }

    fun delete(handle: Handle) {
        this.remove(handle)
    }

    fun remove(handle: Handle): T? =
        lock.withLock {
            leftMap.remove(handle)?.let { obj ->
                rightMap.remove(obj)
                obj
            }
        }
}

interface ForeignCallback : com.sun.jna.Callback {
    public fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int
}

// Magic number for the Rust proxy to call using the same mechanism as every other method,
// to free the callback once it's dropped by Rust.
internal const val IDX_CALLBACK_FREE = 0
// Callback return codes
internal const val UNIFFI_CALLBACK_SUCCESS = 0
internal const val UNIFFI_CALLBACK_ERROR = 1
internal const val UNIFFI_CALLBACK_UNEXPECTED_ERROR = 2

public abstract class FfiConverterCallbackInterface<CallbackInterface>(
    protected val foreignCallback: ForeignCallback
): FfiConverter<CallbackInterface, Handle> {
    private val handleMap = ConcurrentHandleMap<CallbackInterface>()

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal abstract fun register(lib: _UniFFILib)

    fun drop(handle: Handle): RustBuffer.ByValue {
        return handleMap.remove(handle).let { RustBuffer.ByValue() }
    }

    override fun lift(value: Handle): CallbackInterface {
        return handleMap.get(value) ?: throw InternalException("No callback in handlemap; this is a Uniffi bug")
    }

    override fun read(buf: ByteBuffer) = lift(buf.getLong())

    override fun lower(value: CallbackInterface) =
        handleMap.insert(value).also {
            assert(handleMap.get(it) === value) { "Handle map is not returning the object we just placed there. This is a bug in the HandleMap." }
        }

    override fun allocationSize(value: CallbackInterface) = 8

    override fun write(value: CallbackInterface, buf: ByteBuffer) {
        buf.putLong(lower(value))
    }
}

// Declaration and FfiConverters for BackPaginationStatusListener Callback Interface

public interface BackPaginationStatusListener {
    fun `onUpdate`(`status`: BackPaginationStatus)
    
}

// The ForeignCallback that is passed to Rust.
internal class ForeignCallbackTypeBackPaginationStatusListener : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeBackPaginationStatusListener.lift(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeBackPaginationStatusListener.drop(handle)
                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnUpdate`(kotlinCallbackInterface: BackPaginationStatusListener, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`onUpdate`(
                FfiConverterTypeBackPaginationStatus.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
}

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeBackPaginationStatusListener: FfiConverterCallbackInterface<BackPaginationStatusListener>(
    foreignCallback = ForeignCallbackTypeBackPaginationStatusListener()
) {
    override fun register(lib: _UniFFILib) {
        rustCall() { status ->
            lib.uniffi_matrix_sdk_ffi_fn_init_callback_backpaginationstatuslistener(this.foreignCallback, status)
        }
    }
}






// Declaration and FfiConverters for ClientDelegate Callback Interface

public interface ClientDelegate {
    fun `didReceiveAuthError`(`isSoftLogout`: Boolean)
    
}

// The ForeignCallback that is passed to Rust.
internal class ForeignCallbackTypeClientDelegate : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeClientDelegate.lift(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeClientDelegate.drop(handle)
                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidReceiveAuthError`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidReceiveAuthError`(kotlinCallbackInterface: ClientDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`didReceiveAuthError`(
                FfiConverterBoolean.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
}

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeClientDelegate: FfiConverterCallbackInterface<ClientDelegate>(
    foreignCallback = ForeignCallbackTypeClientDelegate()
) {
    override fun register(lib: _UniFFILib) {
        rustCall() { status ->
            lib.uniffi_matrix_sdk_ffi_fn_init_callback_clientdelegate(this.foreignCallback, status)
        }
    }
}






// Declaration and FfiConverters for NotificationSettingsDelegate Callback Interface

public interface NotificationSettingsDelegate {
    fun `settingsDidChange`()
    
}

// The ForeignCallback that is passed to Rust.
internal class ForeignCallbackTypeNotificationSettingsDelegate : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeNotificationSettingsDelegate.lift(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeNotificationSettingsDelegate.drop(handle)
                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeSettingsDidChange`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeSettingsDidChange`(kotlinCallbackInterface: NotificationSettingsDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        fun makeCall() : Int {
            kotlinCallbackInterface.`settingsDidChange`(
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
}

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeNotificationSettingsDelegate: FfiConverterCallbackInterface<NotificationSettingsDelegate>(
    foreignCallback = ForeignCallbackTypeNotificationSettingsDelegate()
) {
    override fun register(lib: _UniFFILib) {
        rustCall() { status ->
            lib.uniffi_matrix_sdk_ffi_fn_init_callback_notificationsettingsdelegate(this.foreignCallback, status)
        }
    }
}






// Declaration and FfiConverters for ProgressWatcher Callback Interface

public interface ProgressWatcher {
    fun `transmissionProgress`(`progress`: TransmissionProgress)
    
}

// The ForeignCallback that is passed to Rust.
internal class ForeignCallbackTypeProgressWatcher : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeProgressWatcher.lift(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeProgressWatcher.drop(handle)
                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeTransmissionProgress`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeTransmissionProgress`(kotlinCallbackInterface: ProgressWatcher, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`transmissionProgress`(
                FfiConverterTypeTransmissionProgress.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
}

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeProgressWatcher: FfiConverterCallbackInterface<ProgressWatcher>(
    foreignCallback = ForeignCallbackTypeProgressWatcher()
) {
    override fun register(lib: _UniFFILib) {
        rustCall() { status ->
            lib.uniffi_matrix_sdk_ffi_fn_init_callback_progresswatcher(this.foreignCallback, status)
        }
    }
}






// Declaration and FfiConverters for RoomListEntriesListener Callback Interface

public interface RoomListEntriesListener {
    fun `onUpdate`(`roomEntriesUpdate`: List<RoomListEntriesUpdate>)
    
}

// The ForeignCallback that is passed to Rust.
internal class ForeignCallbackTypeRoomListEntriesListener : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeRoomListEntriesListener.lift(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeRoomListEntriesListener.drop(handle)
                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnUpdate`(kotlinCallbackInterface: RoomListEntriesListener, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`onUpdate`(
                FfiConverterSequenceTypeRoomListEntriesUpdate.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
}

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeRoomListEntriesListener: FfiConverterCallbackInterface<RoomListEntriesListener>(
    foreignCallback = ForeignCallbackTypeRoomListEntriesListener()
) {
    override fun register(lib: _UniFFILib) {
        rustCall() { status ->
            lib.uniffi_matrix_sdk_ffi_fn_init_callback_roomlistentrieslistener(this.foreignCallback, status)
        }
    }
}






// Declaration and FfiConverters for RoomListLoadingStateListener Callback Interface

public interface RoomListLoadingStateListener {
    fun `onUpdate`(`state`: RoomListLoadingState)
    
}

// The ForeignCallback that is passed to Rust.
internal class ForeignCallbackTypeRoomListLoadingStateListener : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeRoomListLoadingStateListener.lift(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeRoomListLoadingStateListener.drop(handle)
                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnUpdate`(kotlinCallbackInterface: RoomListLoadingStateListener, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`onUpdate`(
                FfiConverterTypeRoomListLoadingState.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
}

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeRoomListLoadingStateListener: FfiConverterCallbackInterface<RoomListLoadingStateListener>(
    foreignCallback = ForeignCallbackTypeRoomListLoadingStateListener()
) {
    override fun register(lib: _UniFFILib) {
        rustCall() { status ->
            lib.uniffi_matrix_sdk_ffi_fn_init_callback_roomlistloadingstatelistener(this.foreignCallback, status)
        }
    }
}






// Declaration and FfiConverters for RoomListServiceStateListener Callback Interface

public interface RoomListServiceStateListener {
    fun `onUpdate`(`state`: RoomListServiceState)
    
}

// The ForeignCallback that is passed to Rust.
internal class ForeignCallbackTypeRoomListServiceStateListener : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeRoomListServiceStateListener.lift(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeRoomListServiceStateListener.drop(handle)
                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnUpdate`(kotlinCallbackInterface: RoomListServiceStateListener, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`onUpdate`(
                FfiConverterTypeRoomListServiceState.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
}

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeRoomListServiceStateListener: FfiConverterCallbackInterface<RoomListServiceStateListener>(
    foreignCallback = ForeignCallbackTypeRoomListServiceStateListener()
) {
    override fun register(lib: _UniFFILib) {
        rustCall() { status ->
            lib.uniffi_matrix_sdk_ffi_fn_init_callback_roomlistservicestatelistener(this.foreignCallback, status)
        }
    }
}






// Declaration and FfiConverters for SessionVerificationControllerDelegate Callback Interface

public interface SessionVerificationControllerDelegate {
    fun `didAcceptVerificationRequest`()
    fun `didStartSasVerification`()
    fun `didReceiveVerificationData`(`data`: List<SessionVerificationEmoji>)
    fun `didFail`()
    fun `didCancel`()
    fun `didFinish`()
    
}

// The ForeignCallback that is passed to Rust.
internal class ForeignCallbackTypeSessionVerificationControllerDelegate : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeSessionVerificationControllerDelegate.lift(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeSessionVerificationControllerDelegate.drop(handle)
                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidAcceptVerificationRequest`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            2 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidStartSasVerification`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            3 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidReceiveVerificationData`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            4 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidFail`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            5 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidCancel`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            6 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidFinish`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidAcceptVerificationRequest`(kotlinCallbackInterface: SessionVerificationControllerDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        fun makeCall() : Int {
            kotlinCallbackInterface.`didAcceptVerificationRequest`(
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidStartSasVerification`(kotlinCallbackInterface: SessionVerificationControllerDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        fun makeCall() : Int {
            kotlinCallbackInterface.`didStartSasVerification`(
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidReceiveVerificationData`(kotlinCallbackInterface: SessionVerificationControllerDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`didReceiveVerificationData`(
                FfiConverterSequenceTypeSessionVerificationEmoji.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidFail`(kotlinCallbackInterface: SessionVerificationControllerDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        fun makeCall() : Int {
            kotlinCallbackInterface.`didFail`(
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidCancel`(kotlinCallbackInterface: SessionVerificationControllerDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        fun makeCall() : Int {
            kotlinCallbackInterface.`didCancel`(
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidFinish`(kotlinCallbackInterface: SessionVerificationControllerDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        fun makeCall() : Int {
            kotlinCallbackInterface.`didFinish`(
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
}

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeSessionVerificationControllerDelegate: FfiConverterCallbackInterface<SessionVerificationControllerDelegate>(
    foreignCallback = ForeignCallbackTypeSessionVerificationControllerDelegate()
) {
    override fun register(lib: _UniFFILib) {
        rustCall() { status ->
            lib.uniffi_matrix_sdk_ffi_fn_init_callback_sessionverificationcontrollerdelegate(this.foreignCallback, status)
        }
    }
}






// Declaration and FfiConverters for SyncServiceStateObserver Callback Interface

public interface SyncServiceStateObserver {
    fun `onUpdate`(`state`: SyncServiceState)
    
}

// The ForeignCallback that is passed to Rust.
internal class ForeignCallbackTypeSyncServiceStateObserver : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeSyncServiceStateObserver.lift(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeSyncServiceStateObserver.drop(handle)
                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnUpdate`(kotlinCallbackInterface: SyncServiceStateObserver, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`onUpdate`(
                FfiConverterTypeSyncServiceState.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
}

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeSyncServiceStateObserver: FfiConverterCallbackInterface<SyncServiceStateObserver>(
    foreignCallback = ForeignCallbackTypeSyncServiceStateObserver()
) {
    override fun register(lib: _UniFFILib) {
        rustCall() { status ->
            lib.uniffi_matrix_sdk_ffi_fn_init_callback_syncservicestateobserver(this.foreignCallback, status)
        }
    }
}






// Declaration and FfiConverters for TimelineListener Callback Interface

public interface TimelineListener {
    fun `onUpdate`(`diff`: TimelineDiff)
    
}

// The ForeignCallback that is passed to Rust.
internal class ForeignCallbackTypeTimelineListener : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeTimelineListener.lift(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeTimelineListener.drop(handle)
                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnUpdate`(kotlinCallbackInterface: TimelineListener, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`onUpdate`(
                FfiConverterTypeTimelineDiff.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
}

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeTimelineListener: FfiConverterCallbackInterface<TimelineListener>(
    foreignCallback = ForeignCallbackTypeTimelineListener()
) {
    override fun register(lib: _UniFFILib) {
        rustCall() { status ->
            lib.uniffi_matrix_sdk_ffi_fn_init_callback_timelinelistener(this.foreignCallback, status)
        }
    }
}




public object FfiConverterOptionalUByte: FfiConverterRustBuffer<UByte?> {
    override fun read(buf: ByteBuffer): UByte? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterUByte.read(buf)
    }

    override fun allocationSize(value: UByte?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterUByte.allocationSize(value)
        }
    }

    override fun write(value: UByte?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterUByte.write(value, buf)
        }
    }
}




public object FfiConverterOptionalUInt: FfiConverterRustBuffer<UInt?> {
    override fun read(buf: ByteBuffer): UInt? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterUInt.read(buf)
    }

    override fun allocationSize(value: UInt?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterUInt.allocationSize(value)
        }
    }

    override fun write(value: UInt?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterUInt.write(value, buf)
        }
    }
}




public object FfiConverterOptionalInt: FfiConverterRustBuffer<Int?> {
    override fun read(buf: ByteBuffer): Int? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterInt.read(buf)
    }

    override fun allocationSize(value: Int?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterInt.allocationSize(value)
        }
    }

    override fun write(value: Int?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterInt.write(value, buf)
        }
    }
}




public object FfiConverterOptionalULong: FfiConverterRustBuffer<ULong?> {
    override fun read(buf: ByteBuffer): ULong? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterULong.read(buf)
    }

    override fun allocationSize(value: ULong?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterULong.allocationSize(value)
        }
    }

    override fun write(value: ULong?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterULong.write(value, buf)
        }
    }
}




public object FfiConverterOptionalBoolean: FfiConverterRustBuffer<Boolean?> {
    override fun read(buf: ByteBuffer): Boolean? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterBoolean.read(buf)
    }

    override fun allocationSize(value: Boolean?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterBoolean.allocationSize(value)
        }
    }

    override fun write(value: Boolean?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterBoolean.write(value, buf)
        }
    }
}




public object FfiConverterOptionalString: FfiConverterRustBuffer<String?> {
    override fun read(buf: ByteBuffer): String? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterString.read(buf)
    }

    override fun allocationSize(value: String?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterString.allocationSize(value)
        }
    }

    override fun write(value: String?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterString.write(value, buf)
        }
    }
}




public object FfiConverterOptionalDuration: FfiConverterRustBuffer<java.time.Duration?> {
    override fun read(buf: ByteBuffer): java.time.Duration? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterDuration.read(buf)
    }

    override fun allocationSize(value: java.time.Duration?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterDuration.allocationSize(value)
        }
    }

    override fun write(value: java.time.Duration?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterDuration.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeEventTimelineItem: FfiConverterRustBuffer<EventTimelineItem?> {
    override fun read(buf: ByteBuffer): EventTimelineItem? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeEventTimelineItem.read(buf)
    }

    override fun allocationSize(value: EventTimelineItem?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeEventTimelineItem.allocationSize(value)
        }
    }

    override fun write(value: EventTimelineItem?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeEventTimelineItem.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeHomeserverLoginDetails: FfiConverterRustBuffer<HomeserverLoginDetails?> {
    override fun read(buf: ByteBuffer): HomeserverLoginDetails? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeHomeserverLoginDetails.read(buf)
    }

    override fun allocationSize(value: HomeserverLoginDetails?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeHomeserverLoginDetails.allocationSize(value)
        }
    }

    override fun write(value: HomeserverLoginDetails?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeHomeserverLoginDetails.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeMediaSource: FfiConverterRustBuffer<MediaSource?> {
    override fun read(buf: ByteBuffer): MediaSource? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeMediaSource.read(buf)
    }

    override fun allocationSize(value: MediaSource?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeMediaSource.allocationSize(value)
        }
    }

    override fun write(value: MediaSource?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeMediaSource.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeMessage: FfiConverterRustBuffer<Message?> {
    override fun read(buf: ByteBuffer): Message? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeMessage.read(buf)
    }

    override fun allocationSize(value: Message?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeMessage.allocationSize(value)
        }
    }

    override fun write(value: Message?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeMessage.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeRoom: FfiConverterRustBuffer<Room?> {
    override fun read(buf: ByteBuffer): Room? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeRoom.read(buf)
    }

    override fun allocationSize(value: Room?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeRoom.allocationSize(value)
        }
    }

    override fun write(value: Room?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeRoom.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeRoomMember: FfiConverterRustBuffer<RoomMember?> {
    override fun read(buf: ByteBuffer): RoomMember? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeRoomMember.read(buf)
    }

    override fun allocationSize(value: RoomMember?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeRoomMember.allocationSize(value)
        }
    }

    override fun write(value: RoomMember?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeRoomMember.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeTimelineItem: FfiConverterRustBuffer<TimelineItem?> {
    override fun read(buf: ByteBuffer): TimelineItem? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeTimelineItem.read(buf)
    }

    override fun allocationSize(value: TimelineItem?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeTimelineItem.allocationSize(value)
        }
    }

    override fun write(value: TimelineItem?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeTimelineItem.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeAudioInfo: FfiConverterRustBuffer<AudioInfo?> {
    override fun read(buf: ByteBuffer): AudioInfo? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeAudioInfo.read(buf)
    }

    override fun allocationSize(value: AudioInfo?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeAudioInfo.allocationSize(value)
        }
    }

    override fun write(value: AudioInfo?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeAudioInfo.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeFileInfo: FfiConverterRustBuffer<FileInfo?> {
    override fun read(buf: ByteBuffer): FileInfo? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeFileInfo.read(buf)
    }

    override fun allocationSize(value: FileInfo?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeFileInfo.allocationSize(value)
        }
    }

    override fun write(value: FileInfo?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeFileInfo.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeFormattedBody: FfiConverterRustBuffer<FormattedBody?> {
    override fun read(buf: ByteBuffer): FormattedBody? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeFormattedBody.read(buf)
    }

    override fun allocationSize(value: FormattedBody?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeFormattedBody.allocationSize(value)
        }
    }

    override fun write(value: FormattedBody?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeFormattedBody.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeImageInfo: FfiConverterRustBuffer<ImageInfo?> {
    override fun read(buf: ByteBuffer): ImageInfo? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeImageInfo.read(buf)
    }

    override fun allocationSize(value: ImageInfo?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeImageInfo.allocationSize(value)
        }
    }

    override fun write(value: ImageInfo?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeImageInfo.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeInReplyToDetails: FfiConverterRustBuffer<InReplyToDetails?> {
    override fun read(buf: ByteBuffer): InReplyToDetails? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeInReplyToDetails.read(buf)
    }

    override fun allocationSize(value: InReplyToDetails?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeInReplyToDetails.allocationSize(value)
        }
    }

    override fun write(value: InReplyToDetails?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeInReplyToDetails.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeInsertData: FfiConverterRustBuffer<InsertData?> {
    override fun read(buf: ByteBuffer): InsertData? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeInsertData.read(buf)
    }

    override fun allocationSize(value: InsertData?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeInsertData.allocationSize(value)
        }
    }

    override fun write(value: InsertData?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeInsertData.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeNotificationItem: FfiConverterRustBuffer<NotificationItem?> {
    override fun read(buf: ByteBuffer): NotificationItem? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeNotificationItem.read(buf)
    }

    override fun allocationSize(value: NotificationItem?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeNotificationItem.allocationSize(value)
        }
    }

    override fun write(value: NotificationItem?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeNotificationItem.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeRoomSubscription: FfiConverterRustBuffer<RoomSubscription?> {
    override fun read(buf: ByteBuffer): RoomSubscription? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeRoomSubscription.read(buf)
    }

    override fun allocationSize(value: RoomSubscription?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeRoomSubscription.allocationSize(value)
        }
    }

    override fun write(value: RoomSubscription?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeRoomSubscription.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeSetData: FfiConverterRustBuffer<SetData?> {
    override fun read(buf: ByteBuffer): SetData? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeSetData.read(buf)
    }

    override fun allocationSize(value: SetData?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeSetData.allocationSize(value)
        }
    }

    override fun write(value: SetData?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeSetData.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeThumbnailInfo: FfiConverterRustBuffer<ThumbnailInfo?> {
    override fun read(buf: ByteBuffer): ThumbnailInfo? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeThumbnailInfo.read(buf)
    }

    override fun allocationSize(value: ThumbnailInfo?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeThumbnailInfo.allocationSize(value)
        }
    }

    override fun write(value: ThumbnailInfo?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeThumbnailInfo.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeVideoInfo: FfiConverterRustBuffer<VideoInfo?> {
    override fun read(buf: ByteBuffer): VideoInfo? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeVideoInfo.read(buf)
    }

    override fun allocationSize(value: VideoInfo?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeVideoInfo.allocationSize(value)
        }
    }

    override fun write(value: VideoInfo?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeVideoInfo.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeAssetType: FfiConverterRustBuffer<AssetType?> {
    override fun read(buf: ByteBuffer): AssetType? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeAssetType.read(buf)
    }

    override fun allocationSize(value: AssetType?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeAssetType.allocationSize(value)
        }
    }

    override fun write(value: AssetType?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeAssetType.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeEventItemOrigin: FfiConverterRustBuffer<EventItemOrigin?> {
    override fun read(buf: ByteBuffer): EventItemOrigin? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeEventItemOrigin.read(buf)
    }

    override fun allocationSize(value: EventItemOrigin?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeEventItemOrigin.allocationSize(value)
        }
    }

    override fun write(value: EventItemOrigin?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeEventItemOrigin.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeEventSendState: FfiConverterRustBuffer<EventSendState?> {
    override fun read(buf: ByteBuffer): EventSendState? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeEventSendState.read(buf)
    }

    override fun allocationSize(value: EventSendState?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeEventSendState.allocationSize(value)
        }
    }

    override fun write(value: EventSendState?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeEventSendState.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeMembershipChange: FfiConverterRustBuffer<MembershipChange?> {
    override fun read(buf: ByteBuffer): MembershipChange? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeMembershipChange.read(buf)
    }

    override fun allocationSize(value: MembershipChange?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeMembershipChange.allocationSize(value)
        }
    }

    override fun write(value: MembershipChange?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeMembershipChange.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeMessageType: FfiConverterRustBuffer<MessageType?> {
    override fun read(buf: ByteBuffer): MessageType? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeMessageType.read(buf)
    }

    override fun allocationSize(value: MessageType?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeMessageType.allocationSize(value)
        }
    }

    override fun write(value: MessageType?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeMessageType.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypePushFormat: FfiConverterRustBuffer<PushFormat?> {
    override fun read(buf: ByteBuffer): PushFormat? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypePushFormat.read(buf)
    }

    override fun allocationSize(value: PushFormat?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypePushFormat.allocationSize(value)
        }
    }

    override fun write(value: PushFormat?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypePushFormat.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeVirtualTimelineItem: FfiConverterRustBuffer<VirtualTimelineItem?> {
    override fun read(buf: ByteBuffer): VirtualTimelineItem? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeVirtualTimelineItem.read(buf)
    }

    override fun allocationSize(value: VirtualTimelineItem?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeVirtualTimelineItem.allocationSize(value)
        }
    }

    override fun write(value: VirtualTimelineItem?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeVirtualTimelineItem.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeClientDelegate: FfiConverterRustBuffer<ClientDelegate?> {
    override fun read(buf: ByteBuffer): ClientDelegate? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeClientDelegate.read(buf)
    }

    override fun allocationSize(value: ClientDelegate?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeClientDelegate.allocationSize(value)
        }
    }

    override fun write(value: ClientDelegate?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeClientDelegate.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeNotificationSettingsDelegate: FfiConverterRustBuffer<NotificationSettingsDelegate?> {
    override fun read(buf: ByteBuffer): NotificationSettingsDelegate? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeNotificationSettingsDelegate.read(buf)
    }

    override fun allocationSize(value: NotificationSettingsDelegate?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeNotificationSettingsDelegate.allocationSize(value)
        }
    }

    override fun write(value: NotificationSettingsDelegate?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeNotificationSettingsDelegate.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeProgressWatcher: FfiConverterRustBuffer<ProgressWatcher?> {
    override fun read(buf: ByteBuffer): ProgressWatcher? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeProgressWatcher.read(buf)
    }

    override fun allocationSize(value: ProgressWatcher?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeProgressWatcher.allocationSize(value)
        }
    }

    override fun write(value: ProgressWatcher?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeProgressWatcher.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeSessionVerificationControllerDelegate: FfiConverterRustBuffer<SessionVerificationControllerDelegate?> {
    override fun read(buf: ByteBuffer): SessionVerificationControllerDelegate? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeSessionVerificationControllerDelegate.read(buf)
    }

    override fun allocationSize(value: SessionVerificationControllerDelegate?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeSessionVerificationControllerDelegate.allocationSize(value)
        }
    }

    override fun write(value: SessionVerificationControllerDelegate?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeSessionVerificationControllerDelegate.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceString: FfiConverterRustBuffer<List<String>?> {
    override fun read(buf: ByteBuffer): List<String>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceString.read(buf)
    }

    override fun allocationSize(value: List<String>?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterSequenceString.allocationSize(value)
        }
    }

    override fun write(value: List<String>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceString.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceTypeTimelineItem: FfiConverterRustBuffer<List<TimelineItem>?> {
    override fun read(buf: ByteBuffer): List<TimelineItem>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeTimelineItem.read(buf)
    }

    override fun allocationSize(value: List<TimelineItem>?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterSequenceTypeTimelineItem.allocationSize(value)
        }
    }

    override fun write(value: List<TimelineItem>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeTimelineItem.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceTypeRequiredState: FfiConverterRustBuffer<List<RequiredState>?> {
    override fun read(buf: ByteBuffer): List<RequiredState>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeRequiredState.read(buf)
    }

    override fun allocationSize(value: List<RequiredState>?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterSequenceTypeRequiredState.allocationSize(value)
        }
    }

    override fun write(value: List<RequiredState>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeRequiredState.write(value, buf)
        }
    }
}




public object FfiConverterSequenceUByte: FfiConverterRustBuffer<List<UByte>> {
    override fun read(buf: ByteBuffer): List<UByte> {
        val len = buf.getInt()
        return List<UByte>(len) {
            FfiConverterUByte.read(buf)
        }
    }

    override fun allocationSize(value: List<UByte>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterUByte.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<UByte>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterUByte.write(it, buf)
        }
    }
}




public object FfiConverterSequenceString: FfiConverterRustBuffer<List<String>> {
    override fun read(buf: ByteBuffer): List<String> {
        val len = buf.getInt()
        return List<String>(len) {
            FfiConverterString.read(buf)
        }
    }

    override fun allocationSize(value: List<String>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterString.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<String>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterString.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeRoom: FfiConverterRustBuffer<List<Room>> {
    override fun read(buf: ByteBuffer): List<Room> {
        val len = buf.getInt()
        return List<Room>(len) {
            FfiConverterTypeRoom.read(buf)
        }
    }

    override fun allocationSize(value: List<Room>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeRoom.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<Room>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeRoom.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeRoomMember: FfiConverterRustBuffer<List<RoomMember>> {
    override fun read(buf: ByteBuffer): List<RoomMember> {
        val len = buf.getInt()
        return List<RoomMember>(len) {
            FfiConverterTypeRoomMember.read(buf)
        }
    }

    override fun allocationSize(value: List<RoomMember>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeRoomMember.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<RoomMember>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeRoomMember.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeSessionVerificationEmoji: FfiConverterRustBuffer<List<SessionVerificationEmoji>> {
    override fun read(buf: ByteBuffer): List<SessionVerificationEmoji> {
        val len = buf.getInt()
        return List<SessionVerificationEmoji>(len) {
            FfiConverterTypeSessionVerificationEmoji.read(buf)
        }
    }

    override fun allocationSize(value: List<SessionVerificationEmoji>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeSessionVerificationEmoji.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<SessionVerificationEmoji>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeSessionVerificationEmoji.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeTimelineItem: FfiConverterRustBuffer<List<TimelineItem>> {
    override fun read(buf: ByteBuffer): List<TimelineItem> {
        val len = buf.getInt()
        return List<TimelineItem>(len) {
            FfiConverterTypeTimelineItem.read(buf)
        }
    }

    override fun allocationSize(value: List<TimelineItem>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeTimelineItem.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<TimelineItem>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeTimelineItem.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypePollAnswer: FfiConverterRustBuffer<List<PollAnswer>> {
    override fun read(buf: ByteBuffer): List<PollAnswer> {
        val len = buf.getInt()
        return List<PollAnswer>(len) {
            FfiConverterTypePollAnswer.read(buf)
        }
    }

    override fun allocationSize(value: List<PollAnswer>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypePollAnswer.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<PollAnswer>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypePollAnswer.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeReaction: FfiConverterRustBuffer<List<Reaction>> {
    override fun read(buf: ByteBuffer): List<Reaction> {
        val len = buf.getInt()
        return List<Reaction>(len) {
            FfiConverterTypeReaction.read(buf)
        }
    }

    override fun allocationSize(value: List<Reaction>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeReaction.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<Reaction>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeReaction.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeReactionSenderData: FfiConverterRustBuffer<List<ReactionSenderData>> {
    override fun read(buf: ByteBuffer): List<ReactionSenderData> {
        val len = buf.getInt()
        return List<ReactionSenderData>(len) {
            FfiConverterTypeReactionSenderData.read(buf)
        }
    }

    override fun allocationSize(value: List<ReactionSenderData>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeReactionSenderData.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<ReactionSenderData>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeReactionSenderData.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeRequiredState: FfiConverterRustBuffer<List<RequiredState>> {
    override fun read(buf: ByteBuffer): List<RequiredState> {
        val len = buf.getInt()
        return List<RequiredState>(len) {
            FfiConverterTypeRequiredState.read(buf)
        }
    }

    override fun allocationSize(value: List<RequiredState>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeRequiredState.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<RequiredState>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeRequiredState.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeRoomListRange: FfiConverterRustBuffer<List<RoomListRange>> {
    override fun read(buf: ByteBuffer): List<RoomListRange> {
        val len = buf.getInt()
        return List<RoomListRange>(len) {
            FfiConverterTypeRoomListRange.read(buf)
        }
    }

    override fun allocationSize(value: List<RoomListRange>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeRoomListRange.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<RoomListRange>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeRoomListRange.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeUserProfile: FfiConverterRustBuffer<List<UserProfile>> {
    override fun read(buf: ByteBuffer): List<UserProfile> {
        val len = buf.getInt()
        return List<UserProfile>(len) {
            FfiConverterTypeUserProfile.read(buf)
        }
    }

    override fun allocationSize(value: List<UserProfile>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeUserProfile.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<UserProfile>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeUserProfile.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeRoomListEntriesUpdate: FfiConverterRustBuffer<List<RoomListEntriesUpdate>> {
    override fun read(buf: ByteBuffer): List<RoomListEntriesUpdate> {
        val len = buf.getInt()
        return List<RoomListEntriesUpdate>(len) {
            FfiConverterTypeRoomListEntriesUpdate.read(buf)
        }
    }

    override fun allocationSize(value: List<RoomListEntriesUpdate>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeRoomListEntriesUpdate.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<RoomListEntriesUpdate>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeRoomListEntriesUpdate.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeRoomListEntry: FfiConverterRustBuffer<List<RoomListEntry>> {
    override fun read(buf: ByteBuffer): List<RoomListEntry> {
        val len = buf.getInt()
        return List<RoomListEntry>(len) {
            FfiConverterTypeRoomListEntry.read(buf)
        }
    }

    override fun allocationSize(value: List<RoomListEntry>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeRoomListEntry.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<RoomListEntry>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeRoomListEntry.write(it, buf)
        }
    }
}



public object FfiConverterMapStringTypeReceipt: FfiConverterRustBuffer<Map<String, Receipt>> {
    override fun read(buf: ByteBuffer): Map<String, Receipt> {
        // TODO: Once Kotlin's `buildMap` API is stabilized we should use it here.
        val items : MutableMap<String, Receipt> = mutableMapOf()
        val len = buf.getInt()
        repeat(len) {
            val k = FfiConverterString.read(buf)
            val v = FfiConverterTypeReceipt.read(buf)
            items[k] = v
        }
        return items
    }

    override fun allocationSize(value: Map<String, Receipt>): Int {
        val spaceForMapSize = 4
        val spaceForChildren = value.map { (k, v) ->
            FfiConverterString.allocationSize(k) +
            FfiConverterTypeReceipt.allocationSize(v)
        }.sum()
        return spaceForMapSize + spaceForChildren
    }

    override fun write(value: Map<String, Receipt>, buf: ByteBuffer) {
        buf.putInt(value.size)
        // The parens on `(k, v)` here ensure we're calling the right method,
        // which is important for compatibility with older android devices.
        // Ref https://blog.danlew.net/2017/03/16/kotlin-puzzler-whose-line-is-it-anyways/
        value.forEach { (k, v) ->
            FfiConverterString.write(k, buf)
            FfiConverterTypeReceipt.write(v, buf)
        }
    }
}



public object FfiConverterMapStringSequenceString: FfiConverterRustBuffer<Map<String, List<String>>> {
    override fun read(buf: ByteBuffer): Map<String, List<String>> {
        // TODO: Once Kotlin's `buildMap` API is stabilized we should use it here.
        val items : MutableMap<String, List<String>> = mutableMapOf()
        val len = buf.getInt()
        repeat(len) {
            val k = FfiConverterString.read(buf)
            val v = FfiConverterSequenceString.read(buf)
            items[k] = v
        }
        return items
    }

    override fun allocationSize(value: Map<String, List<String>>): Int {
        val spaceForMapSize = 4
        val spaceForChildren = value.map { (k, v) ->
            FfiConverterString.allocationSize(k) +
            FfiConverterSequenceString.allocationSize(v)
        }.sum()
        return spaceForMapSize + spaceForChildren
    }

    override fun write(value: Map<String, List<String>>, buf: ByteBuffer) {
        buf.putInt(value.size)
        // The parens on `(k, v)` here ensure we're calling the right method,
        // which is important for compatibility with older android devices.
        // Ref https://blog.danlew.net/2017/03/16/kotlin-puzzler-whose-line-is-it-anyways/
        value.forEach { (k, v) ->
            FfiConverterString.write(k, buf)
            FfiConverterSequenceString.write(v, buf)
        }
    }
}
// Async return type handlers











// FFI type for callback handlers
internal interface UniFfiFutureCallbackByte : com.sun.jna.Callback {
    // Note: callbackData is always 0.  We could pass Rust a pointer/usize to represent the
    // continuation, but with JNA it's easier to just store it in the callback handler.
    fun invoke(_callbackData: USize, returnValue: Byte?, callStatus: RustCallStatus.ByValue);
}
internal interface UniFfiFutureCallbackInt : com.sun.jna.Callback {
    // Note: callbackData is always 0.  We could pass Rust a pointer/usize to represent the
    // continuation, but with JNA it's easier to just store it in the callback handler.
    fun invoke(_callbackData: USize, returnValue: Int?, callStatus: RustCallStatus.ByValue);
}
internal interface UniFfiFutureCallbackLong : com.sun.jna.Callback {
    // Note: callbackData is always 0.  We could pass Rust a pointer/usize to represent the
    // continuation, but with JNA it's easier to just store it in the callback handler.
    fun invoke(_callbackData: USize, returnValue: Long?, callStatus: RustCallStatus.ByValue);
}
internal interface UniFfiFutureCallbackPointer : com.sun.jna.Callback {
    // Note: callbackData is always 0.  We could pass Rust a pointer/usize to represent the
    // continuation, but with JNA it's easier to just store it in the callback handler.
    fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue);
}
internal interface UniFfiFutureCallbackRustBuffer : com.sun.jna.Callback {
    // Note: callbackData is always 0.  We could pass Rust a pointer/usize to represent the
    // continuation, but with JNA it's easier to just store it in the callback handler.
    fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue);
}

// Callback handlers for an async call.  These are invoked by Rust when the future is ready.  They
// lift the return value or error and resume the suspended function.

internal class UniFfiFutureCallbackHandlerVoid(val continuation: Continuation<Unit>)
    : UniFfiFutureCallbackByte {
    override fun invoke(_callbackData: USize, returnValue: Byte?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(Unit)
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerVoid_TypeAuthenticationError(val continuation: Continuation<Unit>)
    : UniFfiFutureCallbackByte {
    override fun invoke(_callbackData: USize, returnValue: Byte?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(AuthenticationException, callStatus)
            continuation.resume(Unit)
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerVoid_TypeClientError(val continuation: Continuation<Unit>)
    : UniFfiFutureCallbackByte {
    override fun invoke(_callbackData: USize, returnValue: Byte?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(Unit)
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerVoid_TypeNotificationSettingsError(val continuation: Continuation<Unit>)
    : UniFfiFutureCallbackByte {
    override fun invoke(_callbackData: USize, returnValue: Byte?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NotificationSettingsException, callStatus)
            continuation.resume(Unit)
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerVoid_TypeRoomError(val continuation: Continuation<Unit>)
    : UniFfiFutureCallbackByte {
    override fun invoke(_callbackData: USize, returnValue: Byte?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(RoomException, callStatus)
            continuation.resume(Unit)
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerVoid_TypeRoomListError(val continuation: Continuation<Unit>)
    : UniFfiFutureCallbackByte {
    override fun invoke(_callbackData: USize, returnValue: Byte?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(RoomListException, callStatus)
            continuation.resume(Unit)
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerUInt(val continuation: Continuation<UInt>)
    : UniFfiFutureCallbackInt {
    override fun invoke(_callbackData: USize, returnValue: Int?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterUInt.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerULong(val continuation: Continuation<ULong>)
    : UniFfiFutureCallbackLong {
    override fun invoke(_callbackData: USize, returnValue: Long?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterULong.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerLong(val continuation: Continuation<Long>)
    : UniFfiFutureCallbackLong {
    override fun invoke(_callbackData: USize, returnValue: Long?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterLong.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerBoolean(val continuation: Continuation<Boolean>)
    : UniFfiFutureCallbackByte {
    override fun invoke(_callbackData: USize, returnValue: Byte?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterBoolean.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerBoolean_TypeClientError(val continuation: Continuation<Boolean>)
    : UniFfiFutureCallbackByte {
    override fun invoke(_callbackData: USize, returnValue: Byte?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(FfiConverterBoolean.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerBoolean_TypeNotificationSettingsError(val continuation: Continuation<Boolean>)
    : UniFfiFutureCallbackByte {
    override fun invoke(_callbackData: USize, returnValue: Byte?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NotificationSettingsException, callStatus)
            continuation.resume(FfiConverterBoolean.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerString(val continuation: Continuation<String>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterString.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerString_TypeClientError(val continuation: Continuation<String>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(FfiConverterString.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeAuthenticationService(val continuation: Continuation<AuthenticationService>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeAuthenticationService.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeClient_TypeAuthenticationError(val continuation: Continuation<Client>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(AuthenticationException, callStatus)
            continuation.resume(FfiConverterTypeClient.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeClient_TypeClientError(val continuation: Continuation<Client>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(FfiConverterTypeClient.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeClientBuilder(val continuation: Continuation<ClientBuilder>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeClientBuilder.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeMediaFileHandle_TypeClientError(val continuation: Continuation<MediaFileHandle>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(FfiConverterTypeMediaFileHandle.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeMediaSource(val continuation: Continuation<MediaSource>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeMediaSource.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeMediaSource_TypeClientError(val continuation: Continuation<MediaSource>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(FfiConverterTypeMediaSource.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeNotificationClient(val continuation: Continuation<NotificationClient>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeNotificationClient.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeNotificationClientBuilder(val continuation: Continuation<NotificationClientBuilder>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeNotificationClientBuilder.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeNotificationClientBuilder_TypeClientError(val continuation: Continuation<NotificationClientBuilder>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(FfiConverterTypeNotificationClientBuilder.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeNotificationSettings(val continuation: Continuation<NotificationSettings>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeNotificationSettings.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeRoom(val continuation: Continuation<Room>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeRoom.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeRoomList_TypeRoomListError(val continuation: Continuation<RoomList>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(RoomListException, callStatus)
            continuation.resume(FfiConverterTypeRoomList.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeRoomListItem_TypeRoomListError(val continuation: Continuation<RoomListItem>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(RoomListException, callStatus)
            continuation.resume(FfiConverterTypeRoomListItem.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeRoomListService(val continuation: Continuation<RoomListService>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeRoomListService.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeRoomMember_TypeClientError(val continuation: Continuation<RoomMember>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(FfiConverterTypeRoomMember.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeRoomMessageEventContent(val continuation: Continuation<RoomMessageEventContent>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeRoomMessageEventContent.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeRoomMessageEventContent_TypeClientError(val continuation: Continuation<RoomMessageEventContent>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(FfiConverterTypeRoomMessageEventContent.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeSendAttachmentJoinHandle(val continuation: Continuation<SendAttachmentJoinHandle>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeSendAttachmentJoinHandle.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeSessionVerificationController_TypeClientError(val continuation: Continuation<SessionVerificationController>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(FfiConverterTypeSessionVerificationController.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeSpan(val continuation: Continuation<Span>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeSpan.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeSyncService_TypeClientError(val continuation: Continuation<SyncService>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(FfiConverterTypeSyncService.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeSyncServiceBuilder(val continuation: Continuation<SyncServiceBuilder>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeSyncServiceBuilder.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeTaskHandle(val continuation: Continuation<TaskHandle>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeTaskHandle.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeTaskHandle_TypeClientError(val continuation: Continuation<TaskHandle>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(FfiConverterTypeTaskHandle.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeTimelineItemContent(val continuation: Continuation<TimelineItemContent>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeTimelineItemContent.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeUnreadNotificationsCount(val continuation: Continuation<UnreadNotificationsCount>)
    : UniFfiFutureCallbackPointer {
    override fun invoke(_callbackData: USize, returnValue: Pointer?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeUnreadNotificationsCount.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeEventTimelineItemDebugInfo(val continuation: Continuation<EventTimelineItemDebugInfo>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeEventTimelineItemDebugInfo.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeRoomListEntriesResult_TypeRoomListError(val continuation: Continuation<RoomListEntriesResult>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(RoomListException, callStatus)
            continuation.resume(FfiConverterTypeRoomListEntriesResult.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeRoomListLoadingStateResult_TypeRoomListError(val continuation: Continuation<RoomListLoadingStateResult>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(RoomListException, callStatus)
            continuation.resume(FfiConverterTypeRoomListLoadingStateResult.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeRoomNotificationSettings_TypeNotificationSettingsError(val continuation: Continuation<RoomNotificationSettings>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NotificationSettingsException, callStatus)
            continuation.resume(FfiConverterTypeRoomNotificationSettings.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeRoomTimelineListenerResult(val continuation: Continuation<RoomTimelineListenerResult>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeRoomTimelineListenerResult.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeSearchUsersResults_TypeClientError(val continuation: Continuation<SearchUsersResults>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(FfiConverterTypeSearchUsersResults.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeSession_TypeClientError(val continuation: Continuation<Session>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(FfiConverterTypeSession.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeUserProfile_TypeClientError(val continuation: Continuation<UserProfile>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(FfiConverterTypeUserProfile.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeMembership(val continuation: Continuation<Membership>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeMembership.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeMembershipState(val continuation: Continuation<MembershipState>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeMembershipState.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeProfileDetails(val continuation: Continuation<ProfileDetails>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeProfileDetails.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeRoomNotificationMode(val continuation: Continuation<RoomNotificationMode>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeRoomNotificationMode.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeSyncServiceState(val continuation: Continuation<SyncServiceState>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeSyncServiceState.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeTimelineChange(val continuation: Continuation<TimelineChange>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeTimelineChange.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeTimelineEventType_TypeClientError(val continuation: Continuation<TimelineEventType>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(FfiConverterTypeTimelineEventType.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerTypeTimelineItemContentKind(val continuation: Continuation<TimelineItemContentKind>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterTypeTimelineItemContentKind.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalUInt(val continuation: Continuation<UInt?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterOptionalUInt.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalString(val continuation: Continuation<String?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterOptionalString.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalString_TypeClientError(val continuation: Continuation<String?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(FfiConverterOptionalString.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalTypeEventTimelineItem(val continuation: Continuation<EventTimelineItem?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterOptionalTypeEventTimelineItem.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalTypeHomeserverLoginDetails(val continuation: Continuation<HomeserverLoginDetails?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterOptionalTypeHomeserverLoginDetails.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalTypeMessage(val continuation: Continuation<Message?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterOptionalTypeMessage.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalTypeRoom_TypeClientError(val continuation: Continuation<Room?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(FfiConverterOptionalTypeRoom.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalTypeRoomMember(val continuation: Continuation<RoomMember?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterOptionalTypeRoomMember.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalTypeTimelineItem(val continuation: Continuation<TimelineItem?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterOptionalTypeTimelineItem.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalTypeInReplyToDetails(val continuation: Continuation<InReplyToDetails?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterOptionalTypeInReplyToDetails.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalTypeInsertData(val continuation: Continuation<InsertData?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterOptionalTypeInsertData.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalTypeNotificationItem_TypeClientError(val continuation: Continuation<NotificationItem?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(FfiConverterOptionalTypeNotificationItem.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalTypeSetData(val continuation: Continuation<SetData?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterOptionalTypeSetData.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalTypeEventItemOrigin(val continuation: Continuation<EventItemOrigin?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterOptionalTypeEventItemOrigin.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalTypeEventSendState(val continuation: Continuation<EventSendState?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterOptionalTypeEventSendState.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalTypeMessageType(val continuation: Continuation<MessageType?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterOptionalTypeMessageType.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalTypeVirtualTimelineItem(val continuation: Continuation<VirtualTimelineItem?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterOptionalTypeVirtualTimelineItem.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerOptionalSequenceTypeTimelineItem(val continuation: Continuation<List<TimelineItem>?>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterOptionalSequenceTypeTimelineItem.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerSequenceUByte_TypeClientError(val continuation: Continuation<List<UByte>>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(FfiConverterSequenceUByte.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerSequenceString(val continuation: Continuation<List<String>>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterSequenceString.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerSequenceTypeRoom(val continuation: Continuation<List<Room>>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterSequenceTypeRoom.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerSequenceTypeRoomMember_TypeClientError(val continuation: Continuation<List<RoomMember>>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(ClientException, callStatus)
            continuation.resume(FfiConverterSequenceTypeRoomMember.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerSequenceTypeReaction(val continuation: Continuation<List<Reaction>>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterSequenceTypeReaction.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

internal class UniFfiFutureCallbackHandlerMapStringTypeReceipt(val continuation: Continuation<Map<String, Receipt>>)
    : UniFfiFutureCallbackRustBuffer {
    override fun invoke(_callbackData: USize, returnValue: RustBuffer.ByValue?, callStatus: RustCallStatus.ByValue) {
        try {
            checkCallStatus(NullCallStatusErrorHandler, callStatus)
            continuation.resume(FfiConverterMapStringTypeReceipt.lift(returnValue!!))
        } catch (e: Throwable) {
            continuation.resumeWithException(e)
        }
    }
}

fun `genTransactionId`(): String {
    return FfiConverterString.lift(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_gen_transaction_id(_status)
})
}


fun `logEvent`(`file`: String, `line`: UInt, `column`: UInt, `level`: LogLevel, `target`: String, `message`: String) =
    
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_log_event(FfiConverterString.lower(`file`),FfiConverterUInt.lower(`line`),FfiConverterUInt.lower(`column`),FfiConverterTypeLogLevel.lower(`level`),FfiConverterString.lower(`target`),FfiConverterString.lower(`message`),_status)
}



fun `mediaSourceFromUrl`(`url`: String): MediaSource {
    return FfiConverterTypeMediaSource.lift(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_media_source_from_url(FfiConverterString.lower(`url`),_status)
})
}


fun `messageEventContentFromMarkdown`(`md`: String): RoomMessageEventContent {
    return FfiConverterTypeRoomMessageEventContent.lift(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_message_event_content_from_markdown(FfiConverterString.lower(`md`),_status)
})
}


fun `messageEventContentNew`(`msgtype`: MessageType): RoomMessageEventContent {
    return FfiConverterTypeRoomMessageEventContent.lift(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_message_event_content_new(FfiConverterTypeMessageType.lower(`msgtype`),_status)
})
}


fun `sdkGitSha`(): String {
    return FfiConverterString.lift(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_sdk_git_sha(_status)
})
}


fun `setupOtlpTracing`(`filter`: String, `clientName`: String, `user`: String, `password`: String, `otlpEndpoint`: String) =
    
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_setup_otlp_tracing(FfiConverterString.lower(`filter`),FfiConverterString.lower(`clientName`),FfiConverterString.lower(`user`),FfiConverterString.lower(`password`),FfiConverterString.lower(`otlpEndpoint`),_status)
}



fun `setupTracing`(`filter`: String) =
    
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_setup_tracing(FfiConverterString.lower(`filter`),_status)
}



