// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("NAME_SHADOWING")

package org.matrix.rustcomponents.sdk;

// Common helper code.
//
// Ideally this would live in a separate .kt file where it can be unittested etc
// in isolation, and perhaps even published as a re-useable package.
//
// However, it's important that the details of how this helper code works (e.g. the
// way that different builtin types are passed across the FFI) exactly match what's
// expected by the Rust code on the other side of the interface. In practice right
// now that means coming from the exact some version of `uniffi` that was used to
// compile the Rust component. The easiest way to ensure this is to bundle the Kotlin
// helpers directly inline like we're doing here.

import com.sun.jna.Library
import com.sun.jna.IntegerType
import com.sun.jna.Native
import com.sun.jna.Pointer
import com.sun.jna.Structure
import com.sun.jna.Callback
import com.sun.jna.ptr.*
import java.nio.ByteBuffer
import java.nio.ByteOrder
import java.nio.CharBuffer
import java.nio.charset.CodingErrorAction
import java.util.concurrent.ConcurrentHashMap
import java.util.concurrent.atomic.AtomicBoolean
import java.util.concurrent.atomic.AtomicLong
import java.util.concurrent.locks.ReentrantLock
import kotlin.concurrent.withLock
import kotlin.coroutines.resume
import kotlinx.coroutines.CancellableContinuation
import kotlinx.coroutines.suspendCancellableCoroutine

// This is a helper for safely working with byte buffers returned from the Rust code.
// A rust-owned buffer is represented by its capacity, its current length, and a
// pointer to the underlying data.

@Structure.FieldOrder("capacity", "len", "data")
open class RustBuffer : Structure() {
    @JvmField var capacity: Int = 0
    @JvmField var len: Int = 0
    @JvmField var data: Pointer? = null

    class ByValue: RustBuffer(), Structure.ByValue
    class ByReference: RustBuffer(), Structure.ByReference

    companion object {
        internal fun alloc(size: Int = 0) = rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rustbuffer_alloc(size, status)
        }.also {
            if(it.data == null) {
               throw RuntimeException("RustBuffer.alloc() returned null data pointer (size=${size})")
           }
        }

        internal fun create(capacity: Int, len: Int, data: Pointer?): RustBuffer.ByValue {
            var buf = RustBuffer.ByValue()
            buf.capacity = capacity
            buf.len = len
            buf.data = data
            return buf
        }

        internal fun free(buf: RustBuffer.ByValue) = rustCall() { status ->
            _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rustbuffer_free(buf, status)
        }
    }

    @Suppress("TooGenericExceptionThrown")
    fun asByteBuffer() =
        this.data?.getByteBuffer(0, this.len.toLong())?.also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
}

/**
 * The equivalent of the `*mut RustBuffer` type.
 * Required for callbacks taking in an out pointer.
 *
 * Size is the sum of all values in the struct.
 */
class RustBufferByReference : ByReference(16) {
    /**
     * Set the pointed-to `RustBuffer` to the given value.
     */
    fun setValue(value: RustBuffer.ByValue) {
        // NOTE: The offsets are as they are in the C-like struct.
        val pointer = getPointer()
        pointer.setInt(0, value.capacity)
        pointer.setInt(4, value.len)
        pointer.setPointer(8, value.data)
    }

    /**
     * Get a `RustBuffer.ByValue` from this reference.
     */
    fun getValue(): RustBuffer.ByValue {
        val pointer = getPointer()
        val value = RustBuffer.ByValue()
        value.writeField("capacity", pointer.getInt(0))
        value.writeField("len", pointer.getInt(4))
        value.writeField("data", pointer.getPointer(8))

        return value
    }
}

// This is a helper for safely passing byte references into the rust code.
// It's not actually used at the moment, because there aren't many things that you
// can take a direct pointer to in the JVM, and if we're going to copy something
// then we might as well copy it into a `RustBuffer`. But it's here for API
// completeness.

@Structure.FieldOrder("len", "data")
open class ForeignBytes : Structure() {
    @JvmField var len: Int = 0
    @JvmField var data: Pointer? = null

    class ByValue : ForeignBytes(), Structure.ByValue
}
// The FfiConverter interface handles converter types to and from the FFI
//
// All implementing objects should be public to support external types.  When a
// type is external we need to import it's FfiConverter.
public interface FfiConverter<KotlinType, FfiType> {
    // Convert an FFI type to a Kotlin type
    fun lift(value: FfiType): KotlinType

    // Convert an Kotlin type to an FFI type
    fun lower(value: KotlinType): FfiType

    // Read a Kotlin type from a `ByteBuffer`
    fun read(buf: ByteBuffer): KotlinType

    // Calculate bytes to allocate when creating a `RustBuffer`
    //
    // This must return at least as many bytes as the write() function will
    // write. It can return more bytes than needed, for example when writing
    // Strings we can't know the exact bytes needed until we the UTF-8
    // encoding, so we pessimistically allocate the largest size possible (3
    // bytes per codepoint).  Allocating extra bytes is not really a big deal
    // because the `RustBuffer` is short-lived.
    fun allocationSize(value: KotlinType): Int

    // Write a Kotlin type to a `ByteBuffer`
    fun write(value: KotlinType, buf: ByteBuffer)

    // Lower a value into a `RustBuffer`
    //
    // This method lowers a value into a `RustBuffer` rather than the normal
    // FfiType.  It's used by the callback interface code.  Callback interface
    // returns are always serialized into a `RustBuffer` regardless of their
    // normal FFI type.
    fun lowerIntoRustBuffer(value: KotlinType): RustBuffer.ByValue {
        val rbuf = RustBuffer.alloc(allocationSize(value))
        try {
            val bbuf = rbuf.data!!.getByteBuffer(0, rbuf.capacity.toLong()).also {
                it.order(ByteOrder.BIG_ENDIAN)
            }
            write(value, bbuf)
            rbuf.writeField("len", bbuf.position())
            return rbuf
        } catch (e: Throwable) {
            RustBuffer.free(rbuf)
            throw e
        }
    }

    // Lift a value from a `RustBuffer`.
    //
    // This here mostly because of the symmetry with `lowerIntoRustBuffer()`.
    // It's currently only used by the `FfiConverterRustBuffer` class below.
    fun liftFromRustBuffer(rbuf: RustBuffer.ByValue): KotlinType {
        val byteBuf = rbuf.asByteBuffer()!!
        try {
           val item = read(byteBuf)
           if (byteBuf.hasRemaining()) {
               throw RuntimeException("junk remaining in buffer after lifting, something is very wrong!!")
           }
           return item
        } finally {
            RustBuffer.free(rbuf)
        }
    }
}

// FfiConverter that uses `RustBuffer` as the FfiType
public interface FfiConverterRustBuffer<KotlinType>: FfiConverter<KotlinType, RustBuffer.ByValue> {
    override fun lift(value: RustBuffer.ByValue) = liftFromRustBuffer(value)
    override fun lower(value: KotlinType) = lowerIntoRustBuffer(value)
}
// A handful of classes and functions to support the generated data structures.
// This would be a good candidate for isolating in its own ffi-support lib.
// Error runtime.
@Structure.FieldOrder("code", "error_buf")
internal open class RustCallStatus : Structure() {
    @JvmField var code: Byte = 0
    @JvmField var error_buf: RustBuffer.ByValue = RustBuffer.ByValue()

    class ByValue: RustCallStatus(), Structure.ByValue

    fun isSuccess(): Boolean {
        return code == 0.toByte()
    }

    fun isError(): Boolean {
        return code == 1.toByte()
    }

    fun isPanic(): Boolean {
        return code == 2.toByte()
    }
}

class InternalException(message: String) : Exception(message)

// Each top-level error class has a companion object that can lift the error from the call status's rust buffer
interface CallStatusErrorHandler<E> {
    fun lift(error_buf: RustBuffer.ByValue): E;
}

// Helpers for calling Rust
// In practice we usually need to be synchronized to call this safely, so it doesn't
// synchronize itself

// Call a rust function that returns a Result<>.  Pass in the Error class companion that corresponds to the Err
private inline fun <U, E: Exception> rustCallWithError(errorHandler: CallStatusErrorHandler<E>, callback: (RustCallStatus) -> U): U {
    var status = RustCallStatus();
    val return_value = callback(status)
    checkCallStatus(errorHandler, status)
    return return_value
}

// Check RustCallStatus and throw an error if the call wasn't successful
private fun<E: Exception> checkCallStatus(errorHandler: CallStatusErrorHandler<E>, status: RustCallStatus) {
    if (status.isSuccess()) {
        return
    } else if (status.isError()) {
        throw errorHandler.lift(status.error_buf)
    } else if (status.isPanic()) {
        // when the rust code sees a panic, it tries to construct a rustbuffer
        // with the message.  but if that code panics, then it just sends back
        // an empty buffer.
        if (status.error_buf.len > 0) {
            throw InternalException(FfiConverterString.lift(status.error_buf))
        } else {
            throw InternalException("Rust panic")
        }
    } else {
        throw InternalException("Unknown rust call status: $status.code")
    }
}

// CallStatusErrorHandler implementation for times when we don't expect a CALL_ERROR
object NullCallStatusErrorHandler: CallStatusErrorHandler<InternalException> {
    override fun lift(error_buf: RustBuffer.ByValue): InternalException {
        RustBuffer.free(error_buf)
        return InternalException("Unexpected CALL_ERROR")
    }
}

// Call a rust function that returns a plain value
private inline fun <U> rustCall(callback: (RustCallStatus) -> U): U {
    return rustCallWithError(NullCallStatusErrorHandler, callback);
}

// IntegerType that matches Rust's `usize` / C's `size_t`
public class USize(value: Long = 0) : IntegerType(Native.SIZE_T_SIZE, value, true) {
    // This is needed to fill in the gaps of IntegerType's implementation of Number for Kotlin.
    override fun toByte() = toInt().toByte()
    // Needed until https://youtrack.jetbrains.com/issue/KT-47902 is fixed.
    @Deprecated("`toInt().toChar()` is deprecated")
    override fun toChar() = toInt().toChar()
    override fun toShort() = toInt().toShort()

    fun writeToBuffer(buf: ByteBuffer) {
        // Make sure we always write usize integers using native byte-order, since they may be
        // casted to pointer values
        buf.order(ByteOrder.nativeOrder())
        try {
            when (Native.SIZE_T_SIZE) {
                4 -> buf.putInt(toInt())
                8 -> buf.putLong(toLong())
                else -> throw RuntimeException("Invalid SIZE_T_SIZE: ${Native.SIZE_T_SIZE}")
            }
        } finally {
            buf.order(ByteOrder.BIG_ENDIAN)
        }
    }

    companion object {
        val size: Int
            get() = Native.SIZE_T_SIZE

        fun readFromBuffer(buf: ByteBuffer) : USize {
            // Make sure we always read usize integers using native byte-order, since they may be
            // casted from pointer values
            buf.order(ByteOrder.nativeOrder())
            try {
                return when (Native.SIZE_T_SIZE) {
                    4 -> USize(buf.getInt().toLong())
                    8 -> USize(buf.getLong())
                    else -> throw RuntimeException("Invalid SIZE_T_SIZE: ${Native.SIZE_T_SIZE}")
                }
            } finally {
                buf.order(ByteOrder.BIG_ENDIAN)
            }
        }
    }
}


// Map handles to objects
//
// This is used when the Rust code expects an opaque pointer to represent some foreign object.
// Normally we would pass a pointer to the object, but JNA doesn't support getting a pointer from an
// object reference , nor does it support leaking a reference to Rust.
//
// Instead, this class maps USize values to objects so that we can pass a pointer-sized type to
// Rust when it needs an opaque pointer.
//
// TODO: refactor callbacks to use this class
internal class UniFfiHandleMap<T: Any> {
    private val map = ConcurrentHashMap<USize, T>()
    // Use AtomicInteger for our counter, since we may be on a 32-bit system.  4 billion possible
    // values seems like enough. If somehow we generate 4 billion handles, then this will wrap
    // around back to zero and we can assume the first handle generated will have been dropped by
    // then.
    private val counter = java.util.concurrent.atomic.AtomicInteger(0)

    val size: Int
        get() = map.size

    fun insert(obj: T): USize {
        val handle = USize(counter.getAndAdd(1).toLong())
        map.put(handle, obj)
        return handle
    }

    fun get(handle: USize): T? {
        return map.get(handle)
    }

    fun remove(handle: USize): T? {
        return map.remove(handle)
    }
}

// FFI type for Rust future continuations
internal interface UniFffiRustFutureContinuationCallbackType : com.sun.jna.Callback {
    fun callback(continuationHandle: USize, pollResult: Short);
}

// Contains loading, initialization code,
// and the FFI Function declarations in a com.sun.jna.Library.
@Synchronized
private fun findLibraryName(componentName: String): String {
    val libOverride = System.getProperty("uniffi.component.$componentName.libraryOverride")
    if (libOverride != null) {
        return libOverride
    }
    return "matrix_sdk_ffi"
}

private inline fun <reified Lib : Library> loadIndirect(
    componentName: String
): Lib {
    return Native.load<Lib>(findLibraryName(componentName), Lib::class.java)
}

// A JNA Library to expose the extern-C FFI definitions.
// This is an implementation detail which will be called internally by the public API.

internal interface _UniFFILib : Library {
    companion object {
        internal val INSTANCE: _UniFFILib by lazy {
            loadIndirect<_UniFFILib>(componentName = "matrix_sdk_ffi")
            .also { lib: _UniFFILib ->
                uniffiCheckContractApiVersion(lib)
                uniffiCheckApiChecksums(lib)
                uniffiCallbackInterfaceBackPaginationStatusListener.register(lib)
                uniffiCallbackInterfaceBackupStateListener.register(lib)
                uniffiCallbackInterfaceBackupSteadyStateListener.register(lib)
                uniffiCallbackInterfaceClientDelegate.register(lib)
                uniffiCallbackInterfaceClientSessionDelegate.register(lib)
                uniffiCallbackInterfaceEnableRecoveryProgressListener.register(lib)
                uniffiCallbackInterfaceNotificationSettingsDelegate.register(lib)
                uniffiCallbackInterfaceProgressWatcher.register(lib)
                uniffiCallbackInterfaceRecoveryStateListener.register(lib)
                uniffiCallbackInterfaceRoomInfoListener.register(lib)
                uniffiCallbackInterfaceRoomListEntriesListener.register(lib)
                uniffiCallbackInterfaceRoomListLoadingStateListener.register(lib)
                uniffiCallbackInterfaceRoomListServiceStateListener.register(lib)
                uniffiCallbackInterfaceRoomListServiceSyncIndicatorListener.register(lib)
                uniffiCallbackInterfaceSessionVerificationControllerDelegate.register(lib)
                uniffiCallbackInterfaceSyncServiceStateObserver.register(lib)
                uniffiCallbackInterfaceTimelineListener.register(lib)
                uniffiCallbackInterfaceWidgetCapabilitiesProvider.register(lib)
                }
        }
    }

    fun uniffi_matrix_sdk_ffi_fn_free_mediasource(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_constructor_mediasource_from_json(`json`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_mediasource_to_json(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_mediasource_url(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_roommessageeventcontentwithoutrelation(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roommessageeventcontentwithoutrelation_with_mentions(`ptr`: Pointer,`mentions`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_authenticationservice(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_constructor_authenticationservice_new(`basePath`: RustBuffer.ByValue,`passphrase`: RustBuffer.ByValue,`userAgent`: RustBuffer.ByValue,`oidcConfiguration`: RustBuffer.ByValue,`customSlidingSyncProxy`: RustBuffer.ByValue,`sessionDelegate`: RustBuffer.ByValue,`crossProcessRefreshLockId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_authenticationservice_configure_homeserver(`ptr`: Pointer,`serverNameOrHomeserverUrl`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_authenticationservice_homeserver_details(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_authenticationservice_login(`ptr`: Pointer,`username`: RustBuffer.ByValue,`password`: RustBuffer.ByValue,`initialDeviceName`: RustBuffer.ByValue,`deviceId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_authenticationservice_login_with_oidc_callback(`ptr`: Pointer,`authenticationData`: Pointer,`callbackUrl`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_authenticationservice_url_for_oidc_login(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_client(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_account_data(`ptr`: Pointer,`eventType`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_account_url(`ptr`: Pointer,`action`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_avatar_url(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_cached_avatar_url(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_create_room(`ptr`: Pointer,`request`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_device_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_display_name(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_encryption(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_dm_room(`ptr`: Pointer,`userId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_media_content(`ptr`: Pointer,`mediaSource`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_media_file(`ptr`: Pointer,`mediaSource`: Pointer,`body`: RustBuffer.ByValue,`mimeType`: RustBuffer.ByValue,`useCache`: Byte,`tempDir`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_media_thumbnail(`ptr`: Pointer,`mediaSource`: Pointer,`width`: Long,`height`: Long,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_notification_settings(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_profile(`ptr`: Pointer,`userId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_session_verification_controller(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_client_homeserver(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_ignore_user(`ptr`: Pointer,`userId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_login(`ptr`: Pointer,`username`: RustBuffer.ByValue,`password`: RustBuffer.ByValue,`initialDeviceName`: RustBuffer.ByValue,`deviceId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_logout(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_notification_client(`ptr`: Pointer,`processSetup`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_client_remove_avatar(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_restore_session(`ptr`: Pointer,`session`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_rooms(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_search_users(`ptr`: Pointer,`searchTerm`: RustBuffer.ByValue,`limit`: Long,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_session(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_set_account_data(`ptr`: Pointer,`eventType`: RustBuffer.ByValue,`content`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_set_delegate(`ptr`: Pointer,`delegate`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_set_display_name(`ptr`: Pointer,`name`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_set_pusher(`ptr`: Pointer,`identifiers`: RustBuffer.ByValue,`kind`: RustBuffer.ByValue,`appDisplayName`: RustBuffer.ByValue,`deviceDisplayName`: RustBuffer.ByValue,`profileTag`: RustBuffer.ByValue,`lang`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_sync_service(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_client_unignore_user(`ptr`: Pointer,`userId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_upload_avatar(`ptr`: Pointer,`mimeType`: RustBuffer.ByValue,`data`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_upload_media(`ptr`: Pointer,`mimeType`: RustBuffer.ByValue,`data`: RustBuffer.ByValue,`progressWatcher`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_user_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_clientbuilder(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_constructor_clientbuilder_new(_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_base_path(`ptr`: Pointer,`path`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_build(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_disable_automatic_token_refresh(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_disable_ssl_verification(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_enable_cross_process_refresh_lock(`ptr`: Pointer,`processId`: RustBuffer.ByValue,`sessionDelegate`: Long,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_homeserver_url(`ptr`: Pointer,`url`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_passphrase(`ptr`: Pointer,`passphrase`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_proxy(`ptr`: Pointer,`url`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_server_name(`ptr`: Pointer,`serverName`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_server_versions(`ptr`: Pointer,`versions`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_set_session_delegate(`ptr`: Pointer,`sessionDelegate`: Long,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_sliding_sync_proxy(`ptr`: Pointer,`slidingSyncProxy`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_user_agent(`ptr`: Pointer,`userAgent`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_username(`ptr`: Pointer,`username`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_encryption(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_backup_exists_on_server(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_backup_state(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_backup_state_listener(`ptr`: Pointer,`listener`: Long,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_disable_recovery(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_enable_backups(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_enable_recovery(`ptr`: Pointer,`waitForBackupsToUpload`: Byte,`progressListener`: Long,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_is_last_device(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_recover(`ptr`: Pointer,`recoveryKey`: RustBuffer.ByValue,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_recover_and_reset(`ptr`: Pointer,`oldRecoveryKey`: RustBuffer.ByValue,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_recovery_state(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_recovery_state_listener(`ptr`: Pointer,`listener`: Long,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_reset_recovery_key(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_wait_for_backup_upload_steady_state(`ptr`: Pointer,`progressListener`: RustBuffer.ByValue,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_eventtimelineitem(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_can_be_replied_to(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_content(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_debug_info(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_event_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_editable(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_local(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_own(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_remote(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_local_send_state(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_origin(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_reactions(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_read_receipts(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_sender(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_sender_profile(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_timestamp(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_transaction_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_homeserverlogindetails(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_homeserverlogindetails_supports_oidc_login(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_homeserverlogindetails_supports_password_login(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_homeserverlogindetails_url(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_mediafilehandle(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_mediafilehandle_path(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_mediafilehandle_persist(`ptr`: Pointer,`path`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_free_message(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_message_body(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_message_in_reply_to(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_message_is_edited(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_message_is_threaded(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_message_msgtype(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_notificationclient(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationclient_get_notification(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`eventId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_notificationclientbuilder(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationclientbuilder_filter_by_push_rules(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_notificationclientbuilder_finish(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_notificationsettings(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_can_homeserver_push_encrypted_event_to_device(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_contains_keywords_rules(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_get_default_room_notification_mode(`ptr`: Pointer,`isEncrypted`: Byte,`isOneToOne`: Byte,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_get_room_notification_settings(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`isEncrypted`: Byte,`isOneToOne`: Byte,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_get_rooms_with_user_defined_rules(`ptr`: Pointer,`enabled`: RustBuffer.ByValue,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_get_user_defined_room_notification_mode(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_call_enabled(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_invite_for_me_enabled(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_room_mention_enabled(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_user_mention_enabled(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_restore_default_room_notification_mode(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_call_enabled(`ptr`: Pointer,`enabled`: Byte,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_default_room_notification_mode(`ptr`: Pointer,`isEncrypted`: Byte,`isOneToOne`: Byte,`mode`: RustBuffer.ByValue,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_delegate(`ptr`: Pointer,`delegate`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_invite_for_me_enabled(`ptr`: Pointer,`enabled`: Byte,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_room_mention_enabled(`ptr`: Pointer,`enabled`: Byte,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_room_notification_mode(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`mode`: RustBuffer.ByValue,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_user_mention_enabled(`ptr`: Pointer,`enabled`: Byte,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_unmute_room(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`isEncrypted`: Byte,`isOneToOne`: Byte,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_oidcauthenticationdata(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_oidcauthenticationdata_login_url(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_room(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_active_members_count(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_active_room_call_participants(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_alternative_aliases(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_avatar_url(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_ban(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_invite(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_kick(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_redact(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_send_message(`ptr`: Pointer,`userId`: RustBuffer.ByValue,`message`: RustBuffer.ByValue,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_send_state(`ptr`: Pointer,`userId`: RustBuffer.ByValue,`stateEvent`: RustBuffer.ByValue,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_trigger_room_notification(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_canonical_alias(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_display_name(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_has_active_room_call(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_room_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_ignore_user(`ptr`: Pointer,`userId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_invite_user_by_id(`ptr`: Pointer,`userId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_invited_members_count(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_inviter(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_is_direct(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_room_is_encrypted(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_room_is_public(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_room_is_space(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_room_is_tombstoned(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_room_join(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_joined_members_count(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_leave(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_member(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_member_avatar_url(`ptr`: Pointer,`userId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_member_display_name(`ptr`: Pointer,`userId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_members(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_membership(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_name(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_own_user_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_poll_history(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_redact(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,`reason`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_remove_avatar(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_report_content(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,`score`: RustBuffer.ByValue,`reason`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_room_info(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_set_name(`ptr`: Pointer,`name`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_set_topic(`ptr`: Pointer,`topic`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_subscribe_to_room_info_updates(`ptr`: Pointer,`listener`: Long,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_timeline(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_topic(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_typing_notice(`ptr`: Pointer,`isTyping`: Byte,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_upload_avatar(`ptr`: Pointer,`mimeType`: RustBuffer.ByValue,`data`: RustBuffer.ByValue,`mediaInfo`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_free_roomlist(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlist_entries(`ptr`: Pointer,`listener`: Long,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roomlist_entries_with_dynamic_adapters(`ptr`: Pointer,`pageSize`: Int,`listener`: Long,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roomlist_loading_state(`ptr`: Pointer,`listener`: Long,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roomlist_room(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_roomlistdynamicentriescontroller(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistdynamicentriescontroller_add_one_page(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistdynamicentriescontroller_reset_to_one_page(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistdynamicentriescontroller_set_filter(`ptr`: Pointer,`kind`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_free_roomlistitem(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_avatar_url(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_canonical_alias(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_full_room(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_full_room_blocking(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_has_unread_notifications(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_is_direct(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_latest_event(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_name(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_room_info(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_subscribe(`ptr`: Pointer,`settings`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_unread_notifications(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_unsubscribe(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_free_roomlistservice(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistservice_all_rooms(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistservice_apply_input(`ptr`: Pointer,`input`: RustBuffer.ByValue,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistservice_invites(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistservice_room(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistservice_state(`ptr`: Pointer,`listener`: Long,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistservice_sync_indicator(`ptr`: Pointer,`delayBeforeShowingInMs`: Int,`delayBeforeHidingInMs`: Int,`listener`: Long,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_roommember(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_avatar_url(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_can_ban(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_can_invite(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_can_kick(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_can_redact(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_can_send_message(`ptr`: Pointer,`event`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_can_send_state(`ptr`: Pointer,`stateEvent`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_can_trigger_room_notification(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_display_name(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_ignore(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_is_account_user(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_is_ignored(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_is_name_ambiguous(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_membership(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_normalized_power_level(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_power_level(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_unignore(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roommember_user_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_roommembersiterator(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roommembersiterator_len(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Int
    fun uniffi_matrix_sdk_ffi_fn_method_roommembersiterator_next_chunk(`ptr`: Pointer,`chunkSize`: Int,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_sendattachmentjoinhandle(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_sendattachmentjoinhandle_cancel(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_sendattachmentjoinhandle_join(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_sessionverificationcontroller(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_approve_verification(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_cancel_verification(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_decline_verification(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_is_verified(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_request_verification(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_set_delegate(`ptr`: Pointer,`delegate`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_start_sas_verification(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_sessionverificationemoji(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationemoji_description(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationemoji_symbol(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_span(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_constructor_span_current(_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_constructor_span_new(`file`: RustBuffer.ByValue,`line`: RustBuffer.ByValue,`level`: RustBuffer.ByValue,`target`: RustBuffer.ByValue,`name`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_span_enter(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_span_exit(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_span_is_none(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_free_syncservice(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_syncservice_room_list_service(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_syncservice_start(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_syncservice_state(`ptr`: Pointer,`listener`: Long,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_syncservice_stop(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_syncservicebuilder(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_syncservicebuilder_finish(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_syncservicebuilder_with_cross_process_lock(`ptr`: Pointer,`appIdentifier`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_taskhandle(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_taskhandle_cancel(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_taskhandle_is_finished(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_free_timeline(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_add_listener(`ptr`: Pointer,`listener`: Long,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_cancel_send(`ptr`: Pointer,`txnId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_create_poll(`ptr`: Pointer,`question`: RustBuffer.ByValue,`answers`: RustBuffer.ByValue,`maxSelections`: Byte,`pollKind`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_edit(`ptr`: Pointer,`newContent`: Pointer,`editItem`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_edit_poll(`ptr`: Pointer,`question`: RustBuffer.ByValue,`answers`: RustBuffer.ByValue,`maxSelections`: Byte,`pollKind`: RustBuffer.ByValue,`editItem`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_end_poll(`ptr`: Pointer,`pollStartId`: RustBuffer.ByValue,`text`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_fetch_details_for_event(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_fetch_members(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_get_event_timeline_item_by_event_id(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_get_timeline_event_content_by_event_id(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_paginate_backwards(`ptr`: Pointer,`opts`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_retry_decryption(`ptr`: Pointer,`sessionIds`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_retry_send(`ptr`: Pointer,`txnId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_send(`ptr`: Pointer,`msg`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_send_audio(`ptr`: Pointer,`url`: RustBuffer.ByValue,`audioInfo`: RustBuffer.ByValue,`progressWatcher`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_send_file(`ptr`: Pointer,`url`: RustBuffer.ByValue,`fileInfo`: RustBuffer.ByValue,`progressWatcher`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_send_image(`ptr`: Pointer,`url`: RustBuffer.ByValue,`thumbnailUrl`: RustBuffer.ByValue,`imageInfo`: RustBuffer.ByValue,`progressWatcher`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_send_location(`ptr`: Pointer,`body`: RustBuffer.ByValue,`geoUri`: RustBuffer.ByValue,`description`: RustBuffer.ByValue,`zoomLevel`: RustBuffer.ByValue,`assetType`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_send_poll_response(`ptr`: Pointer,`pollStartId`: RustBuffer.ByValue,`answers`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_send_read_receipt(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_send_reply(`ptr`: Pointer,`msg`: Pointer,`replyItem`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_send_video(`ptr`: Pointer,`url`: RustBuffer.ByValue,`thumbnailUrl`: RustBuffer.ByValue,`videoInfo`: RustBuffer.ByValue,`progressWatcher`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_send_voice_message(`ptr`: Pointer,`url`: RustBuffer.ByValue,`audioInfo`: RustBuffer.ByValue,`waveform`: RustBuffer.ByValue,`progressWatcher`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_subscribe_to_back_pagination_status(`ptr`: Pointer,`listener`: Long,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_toggle_reaction(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,`key`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_free_timelinediff(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_append(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_change(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_insert(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_push_back(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_push_front(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_remove(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_reset(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_set(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_timelineevent(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timelineevent_event_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineevent_event_type(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineevent_sender_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineevent_timestamp(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_free_timelineitem(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timelineitem_as_event(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineitem_as_virtual(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineitem_fmt_debug(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineitem_unique_id(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_free_timelineitemcontent(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timelineitemcontent_as_message(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineitemcontent_kind(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_free_unreadnotificationscount(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_unreadnotificationscount_has_notifications(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_unreadnotificationscount_highlight_count(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Int
    fun uniffi_matrix_sdk_ffi_fn_method_unreadnotificationscount_notification_count(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Int
    fun uniffi_matrix_sdk_ffi_fn_free_widgetdriver(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_widgetdriver_run(`ptr`: Pointer,`room`: Pointer,`capabilitiesProvider`: Long,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_widgetdriverhandle(`ptr`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_widgetdriverhandle_recv(`ptr`: Pointer,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_widgetdriverhandle_send(`ptr`: Pointer,`msg`: RustBuffer.ByValue,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_init_callback_backpaginationstatuslistener(`handle`: ForeignCallback,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_backupstatelistener(`handle`: ForeignCallback,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_backupsteadystatelistener(`handle`: ForeignCallback,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_clientdelegate(`handle`: ForeignCallback,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_clientsessiondelegate(`handle`: ForeignCallback,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_enablerecoveryprogresslistener(`handle`: ForeignCallback,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_notificationsettingsdelegate(`handle`: ForeignCallback,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_progresswatcher(`handle`: ForeignCallback,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_recoverystatelistener(`handle`: ForeignCallback,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_roominfolistener(`handle`: ForeignCallback,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_roomlistentrieslistener(`handle`: ForeignCallback,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_roomlistloadingstatelistener(`handle`: ForeignCallback,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_roomlistservicestatelistener(`handle`: ForeignCallback,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_roomlistservicesyncindicatorlistener(`handle`: ForeignCallback,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_sessionverificationcontrollerdelegate(`handle`: ForeignCallback,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_syncservicestateobserver(`handle`: ForeignCallback,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_timelinelistener(`handle`: ForeignCallback,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_widgetcapabilitiesprovider(`handle`: ForeignCallback,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_func_gen_transaction_id(_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_func_generate_webview_url(`widgetSettings`: RustBuffer.ByValue,`room`: Pointer,`props`: RustBuffer.ByValue,
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_func_get_element_call_required_permissions(_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_func_log_event(`file`: RustBuffer.ByValue,`line`: RustBuffer.ByValue,`level`: RustBuffer.ByValue,`target`: RustBuffer.ByValue,`message`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_func_make_widget_driver(`settings`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_func_media_source_from_url(`url`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_func_message_event_content_from_html(`body`: RustBuffer.ByValue,`htmlBody`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_func_message_event_content_from_html_as_emote(`body`: RustBuffer.ByValue,`htmlBody`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_func_message_event_content_from_markdown(`md`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_func_message_event_content_from_markdown_as_emote(`md`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_func_message_event_content_new(`msgtype`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_func_new_virtual_element_call_widget(`props`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_func_sdk_git_sha(_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_func_setup_otlp_tracing(`config`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_func_setup_tracing(`config`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun ffi_matrix_sdk_ffi_rustbuffer_alloc(`size`: Int,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_rustbuffer_from_bytes(`bytes`: ForeignBytes.ByValue,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_rustbuffer_free(`buf`: RustBuffer.ByValue,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun ffi_matrix_sdk_ffi_rustbuffer_reserve(`buf`: RustBuffer.ByValue,`additional`: Int,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_rust_future_poll_u8(`handle`: Pointer,`callback`: UniFffiRustFutureContinuationCallbackType,`callbackData`: USize,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_u8(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_u8(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_u8(`handle`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun ffi_matrix_sdk_ffi_rust_future_poll_i8(`handle`: Pointer,`callback`: UniFffiRustFutureContinuationCallbackType,`callbackData`: USize,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_i8(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_i8(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_i8(`handle`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Byte
    fun ffi_matrix_sdk_ffi_rust_future_poll_u16(`handle`: Pointer,`callback`: UniFffiRustFutureContinuationCallbackType,`callbackData`: USize,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_u16(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_u16(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_u16(`handle`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Short
    fun ffi_matrix_sdk_ffi_rust_future_poll_i16(`handle`: Pointer,`callback`: UniFffiRustFutureContinuationCallbackType,`callbackData`: USize,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_i16(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_i16(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_i16(`handle`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Short
    fun ffi_matrix_sdk_ffi_rust_future_poll_u32(`handle`: Pointer,`callback`: UniFffiRustFutureContinuationCallbackType,`callbackData`: USize,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_u32(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_u32(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_u32(`handle`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Int
    fun ffi_matrix_sdk_ffi_rust_future_poll_i32(`handle`: Pointer,`callback`: UniFffiRustFutureContinuationCallbackType,`callbackData`: USize,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_i32(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_i32(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_i32(`handle`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Int
    fun ffi_matrix_sdk_ffi_rust_future_poll_u64(`handle`: Pointer,`callback`: UniFffiRustFutureContinuationCallbackType,`callbackData`: USize,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_u64(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_u64(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_u64(`handle`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Long
    fun ffi_matrix_sdk_ffi_rust_future_poll_i64(`handle`: Pointer,`callback`: UniFffiRustFutureContinuationCallbackType,`callbackData`: USize,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_i64(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_i64(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_i64(`handle`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Long
    fun ffi_matrix_sdk_ffi_rust_future_poll_f32(`handle`: Pointer,`callback`: UniFffiRustFutureContinuationCallbackType,`callbackData`: USize,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_f32(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_f32(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_f32(`handle`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Float
    fun ffi_matrix_sdk_ffi_rust_future_poll_f64(`handle`: Pointer,`callback`: UniFffiRustFutureContinuationCallbackType,`callbackData`: USize,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_f64(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_f64(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_f64(`handle`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Double
    fun ffi_matrix_sdk_ffi_rust_future_poll_pointer(`handle`: Pointer,`callback`: UniFffiRustFutureContinuationCallbackType,`callbackData`: USize,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_pointer(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_pointer(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_pointer(`handle`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Pointer
    fun ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(`handle`: Pointer,`callback`: UniFffiRustFutureContinuationCallbackType,`callbackData`: USize,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_rust_buffer(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(`handle`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_rust_future_poll_void(`handle`: Pointer,`callback`: UniFffiRustFutureContinuationCallbackType,`callbackData`: USize,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_void(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_void(`handle`: Pointer,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_void(`handle`: Pointer,_uniffi_out_err: RustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_checksum_func_gen_transaction_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_generate_webview_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_get_element_call_required_permissions(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_log_event(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_make_widget_driver(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_media_source_from_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_message_event_content_from_html(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_message_event_content_from_html_as_emote(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_message_event_content_from_markdown(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_message_event_content_from_markdown_as_emote(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_message_event_content_new(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_new_virtual_element_call_widget(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_sdk_git_sha(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_setup_otlp_tracing(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_setup_tracing(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_mediasource_to_json(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_mediasource_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommessageeventcontentwithoutrelation_with_mentions(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_configure_homeserver(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_homeserver_details(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_login(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_login_with_oidc_callback(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_url_for_oidc_login(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_account_data(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_account_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_avatar_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_cached_avatar_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_create_room(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_device_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_display_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_encryption(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_dm_room(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_media_content(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_media_file(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_media_thumbnail(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_notification_settings(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_profile(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_session_verification_controller(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_homeserver(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_ignore_user(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_login(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_logout(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_notification_client(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_remove_avatar(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_restore_session(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_rooms(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_search_users(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_session(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_set_account_data(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_set_delegate(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_set_display_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_set_pusher(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_sync_service(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_unignore_user(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_upload_avatar(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_upload_media(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_user_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_base_path(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_build(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_disable_automatic_token_refresh(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_disable_ssl_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_enable_cross_process_refresh_lock(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_homeserver_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_passphrase(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_proxy(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_server_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_server_versions(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_set_session_delegate(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_sliding_sync_proxy(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_user_agent(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_username(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_backup_exists_on_server(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_backup_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_backup_state_listener(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_disable_recovery(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_enable_backups(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_enable_recovery(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_is_last_device(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_recover(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_recover_and_reset(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_recovery_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_recovery_state_listener(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_reset_recovery_key(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_wait_for_backup_upload_steady_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_can_be_replied_to(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_content(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_debug_info(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_event_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_editable(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_local(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_own(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_remote(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_local_send_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_origin(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_reactions(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_read_receipts(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_sender(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_sender_profile(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_timestamp(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_transaction_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_homeserverlogindetails_supports_oidc_login(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_homeserverlogindetails_supports_password_login(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_homeserverlogindetails_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_mediafilehandle_path(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_mediafilehandle_persist(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_message_body(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_message_in_reply_to(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_message_is_edited(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_message_is_threaded(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_message_msgtype(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationclient_get_notification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationclientbuilder_filter_by_push_rules(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationclientbuilder_finish(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_can_homeserver_push_encrypted_event_to_device(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_contains_keywords_rules(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_get_default_room_notification_mode(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_get_room_notification_settings(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_get_rooms_with_user_defined_rules(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_get_user_defined_room_notification_mode(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_call_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_invite_for_me_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_room_mention_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_user_mention_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_restore_default_room_notification_mode(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_call_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_default_room_notification_mode(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_delegate(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_invite_for_me_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_room_mention_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_room_notification_mode(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_user_mention_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_unmute_room(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_oidcauthenticationdata_login_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_active_members_count(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_active_room_call_participants(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_alternative_aliases(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_avatar_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_ban(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_invite(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_kick(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_redact(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_send_message(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_send_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_trigger_room_notification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_canonical_alias(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_display_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_has_active_room_call(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_ignore_user(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_invite_user_by_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_invited_members_count(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_inviter(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_is_direct(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_is_encrypted(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_is_public(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_is_space(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_is_tombstoned(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_join(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_joined_members_count(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_leave(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_member(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_member_avatar_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_member_display_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_members(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_membership(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_own_user_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_poll_history(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_redact(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_remove_avatar(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_report_content(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_room_info(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_set_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_set_topic(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_subscribe_to_room_info_updates(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_timeline(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_topic(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_typing_notice(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_upload_avatar(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlist_entries(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlist_entries_with_dynamic_adapters(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlist_loading_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlist_room(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistdynamicentriescontroller_add_one_page(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistdynamicentriescontroller_reset_to_one_page(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistdynamicentriescontroller_set_filter(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_avatar_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_canonical_alias(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_full_room(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_full_room_blocking(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_has_unread_notifications(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_is_direct(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_latest_event(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_room_info(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_subscribe(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_unread_notifications(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_unsubscribe(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_all_rooms(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_apply_input(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_invites(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_room(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_sync_indicator(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_avatar_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_can_ban(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_can_invite(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_can_kick(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_can_redact(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_can_send_message(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_can_send_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_can_trigger_room_notification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_display_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_ignore(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_is_account_user(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_is_ignored(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_is_name_ambiguous(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_membership(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_normalized_power_level(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_power_level(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_unignore(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommember_user_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommembersiterator_len(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommembersiterator_next_chunk(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sendattachmentjoinhandle_cancel(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sendattachmentjoinhandle_join(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_approve_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_cancel_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_decline_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_is_verified(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_request_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_set_delegate(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_start_sas_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationemoji_description(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationemoji_symbol(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_span_enter(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_span_exit(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_span_is_none(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservice_room_list_service(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservice_start(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservice_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservice_stop(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservicebuilder_finish(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservicebuilder_with_cross_process_lock(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_taskhandle_cancel(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_taskhandle_is_finished(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_add_listener(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_cancel_send(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_create_poll(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_edit(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_edit_poll(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_end_poll(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_fetch_details_for_event(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_fetch_members(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_get_event_timeline_item_by_event_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_get_timeline_event_content_by_event_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_paginate_backwards(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_retry_decryption(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_retry_send(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_send(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_send_audio(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_send_file(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_send_image(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_send_location(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_send_poll_response(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_send_read_receipt(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_send_reply(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_send_video(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_send_voice_message(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_subscribe_to_back_pagination_status(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_toggle_reaction(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_append(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_change(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_insert(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_push_back(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_push_front(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_remove(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_reset(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_set(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineevent_event_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineevent_event_type(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineevent_sender_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineevent_timestamp(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineitem_as_event(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineitem_as_virtual(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineitem_fmt_debug(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineitem_unique_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineitemcontent_as_message(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineitemcontent_kind(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_unreadnotificationscount_has_notifications(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_unreadnotificationscount_highlight_count(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_unreadnotificationscount_notification_count(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_widgetdriver_run(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_widgetdriverhandle_recv(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_widgetdriverhandle_send(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_constructor_mediasource_from_json(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_constructor_authenticationservice_new(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_constructor_clientbuilder_new(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_constructor_span_current(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_constructor_span_new(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_backpaginationstatuslistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_backupstatelistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_backupsteadystatelistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientdelegate_did_receive_auth_error(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientdelegate_did_refresh_tokens(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientsessiondelegate_retrieve_session_from_keychain(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientsessiondelegate_save_session_in_keychain(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_enablerecoveryprogresslistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettingsdelegate_settings_did_change(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_progresswatcher_transmission_progress(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_recoverystatelistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roominfolistener_call(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistentrieslistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistloadingstatelistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservicestatelistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservicesyncindicatorlistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_accept_verification_request(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_start_sas_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_receive_verification_data(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_fail(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_cancel(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_finish(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservicestateobserver_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinelistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_widgetcapabilitiesprovider_acquire_capabilities(
    ): Short
    fun ffi_matrix_sdk_ffi_uniffi_contract_version(
    ): Int
    
}

private fun uniffiCheckContractApiVersion(lib: _UniFFILib) {
    // Get the bindings contract version from our ComponentInterface
    val bindings_contract_version = 25
    // Get the scaffolding contract version by calling the into the dylib
    val scaffolding_contract_version = lib.ffi_matrix_sdk_ffi_uniffi_contract_version()
    if (bindings_contract_version != scaffolding_contract_version) {
        throw RuntimeException("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    }
}

@Suppress("UNUSED_PARAMETER")
private fun uniffiCheckApiChecksums(lib: _UniFFILib) {
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_gen_transaction_id() != 65533.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_generate_webview_url() != 16581.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_get_element_call_required_permissions() != 51289.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_log_event() != 58164.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_make_widget_driver() != 16217.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_media_source_from_url() != 28929.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_message_event_content_from_html() != 48173.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_message_event_content_from_html_as_emote() != 30627.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_message_event_content_from_markdown() != 5412.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_message_event_content_from_markdown_as_emote() != 16575.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_message_event_content_new() != 60536.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_new_virtual_element_call_widget() != 13275.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_sdk_git_sha() != 11183.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_setup_otlp_tracing() != 57774.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_setup_tracing() != 48899.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_mediasource_to_json() != 2998.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_mediasource_url() != 34026.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommessageeventcontentwithoutrelation_with_mentions() != 48900.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_configure_homeserver() != 20936.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_homeserver_details() != 30828.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_login() != 4340.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_login_with_oidc_callback() != 25443.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_url_for_oidc_login() != 6390.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_account_data() != 37263.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_account_url() != 57664.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_avatar_url() != 13474.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_cached_avatar_url() != 47976.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_create_room() != 9095.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_device_id() != 30759.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_display_name() != 57766.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_encryption() != 55944.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_dm_room() != 2581.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_media_content() != 25167.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_media_file() != 60005.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_media_thumbnail() != 51889.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_notification_settings() != 43752.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_profile() != 11465.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_session_verification_controller() != 25701.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_homeserver() != 509.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_ignore_user() != 53606.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_login() != 62785.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_logout() != 16841.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_notification_client() != 16860.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_remove_avatar() != 41701.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_restore_session() != 19558.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_rooms() != 61954.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_search_users() != 1362.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_session() != 56470.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_set_account_data() != 32949.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_set_delegate() != 29180.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_set_display_name() != 45786.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_set_pusher() != 9540.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_sync_service() != 55738.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_unignore_user() != 6043.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_upload_avatar() != 65133.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_upload_media() != 20769.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_user_id() != 55803.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_base_path() != 13781.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_build() != 56797.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_disable_automatic_token_refresh() != 50220.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_disable_ssl_verification() != 1510.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_enable_cross_process_refresh_lock() != 39606.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_homeserver_url() != 43790.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_passphrase() != 25291.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_proxy() != 61852.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_server_name() != 46252.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_server_versions() != 64538.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_set_session_delegate() != 7269.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_sliding_sync_proxy() != 37450.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_user_agent() != 42913.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_username() != 64379.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_backup_exists_on_server() != 17130.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_backup_state() != 13611.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_backup_state_listener() != 29.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_disable_recovery() != 38729.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_enable_backups() != 30690.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_enable_recovery() != 60849.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_is_last_device() != 34446.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_recover() != 34668.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_recover_and_reset() != 52410.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_recovery_state() != 7187.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_recovery_state_listener() != 11439.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_reset_recovery_key() != 40510.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_wait_for_backup_upload_steady_state() != 37083.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_can_be_replied_to() != 42286.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_content() != 1802.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_debug_info() != 45087.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_event_id() != 57306.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_editable() != 593.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_local() != 47845.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_own() != 18359.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_remote() != 17688.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_local_send_state() != 22720.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_origin() != 28263.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_reactions() != 64143.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_read_receipts() != 40784.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_sender() != 46892.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_sender_profile() != 42856.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_timestamp() != 481.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_transaction_id() != 36352.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_homeserverlogindetails_supports_oidc_login() != 51854.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_homeserverlogindetails_supports_password_login() != 6028.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_homeserverlogindetails_url() != 40398.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_mediafilehandle_path() != 2500.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_mediafilehandle_persist() != 4346.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_message_body() != 2560.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_message_in_reply_to() != 1793.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_message_is_edited() != 3402.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_message_is_threaded() != 29945.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_message_msgtype() != 35166.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationclient_get_notification() != 9907.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationclientbuilder_filter_by_push_rules() != 10529.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationclientbuilder_finish() != 12382.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_can_homeserver_push_encrypted_event_to_device() != 22382.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_contains_keywords_rules() != 42972.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_get_default_room_notification_mode() != 7288.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_get_room_notification_settings() != 654.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_get_rooms_with_user_defined_rules() != 687.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_get_user_defined_room_notification_mode() != 40224.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_call_enabled() != 38110.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_invite_for_me_enabled() != 50408.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_room_mention_enabled() != 36336.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_user_mention_enabled() != 9844.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_restore_default_room_notification_mode() != 43578.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_call_enabled() != 61774.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_default_room_notification_mode() != 64886.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_delegate() != 22622.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_invite_for_me_enabled() != 7240.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_room_mention_enabled() != 50730.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_room_notification_mode() != 21294.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_user_mention_enabled() != 63345.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_unmute_room() != 33146.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_oidcauthenticationdata_login_url() != 2455.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_active_members_count() != 62367.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_active_room_call_participants() != 5256.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_alternative_aliases() != 25219.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_avatar_url() != 38267.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_ban() != 47371.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_invite() != 62419.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_kick() != 47687.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_redact() != 54334.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_send_message() != 28210.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_send_state() != 54763.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_trigger_room_notification() != 8288.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_canonical_alias() != 15084.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_display_name() != 38216.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_has_active_room_call() != 59850.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_id() != 27132.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_ignore_user() != 9941.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_invite_user_by_id() != 12569.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_invited_members_count() != 31452.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_inviter() != 8327.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_is_direct() != 46881.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_is_encrypted() != 29418.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_is_public() != 22937.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_is_space() != 8495.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_is_tombstoned() != 55887.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_join() != 4883.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_joined_members_count() != 44345.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_leave() != 11928.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_member() != 4975.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_member_avatar_url() != 5937.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_member_display_name() != 4559.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_members() != 6390.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_membership() != 17678.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_name() != 58791.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_own_user_id() != 26241.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_poll_history() != 58381.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_redact() != 12809.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_remove_avatar() != 24698.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_report_content() != 58629.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_room_info() != 45186.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_set_name() != 56429.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_set_topic() != 55348.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_subscribe_to_room_info_updates() != 43609.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_timeline() != 49618.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_topic() != 23413.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_typing_notice() != 46496.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_upload_avatar() != 46437.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlist_entries() != 27911.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlist_entries_with_dynamic_adapters() != 30316.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlist_loading_state() != 54823.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlist_room() != 60000.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistdynamicentriescontroller_add_one_page() != 1980.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistdynamicentriescontroller_reset_to_one_page() != 48285.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistdynamicentriescontroller_set_filter() != 20071.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_avatar_url() != 23609.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_canonical_alias() != 56187.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_full_room() != 12614.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_full_room_blocking() != 53631.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_has_unread_notifications() != 64858.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_id() != 35737.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_is_direct() != 24829.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_latest_event() != 44019.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_name() != 5949.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_room_info() != 17731.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_subscribe() != 16638.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_unread_notifications() != 36955.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_unsubscribe() != 14844.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_all_rooms() != 37160.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_apply_input() != 46775.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_invites() != 56087.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_room() != 48446.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_state() != 7038.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_sync_indicator() != 5536.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_avatar_url() != 9148.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_can_ban() != 19267.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_can_invite() != 36172.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_can_kick() != 31109.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_can_redact() != 49727.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_can_send_message() != 14989.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_can_send_state() != 43889.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_can_trigger_room_notification() != 62393.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_display_name() != 28367.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_ignore() != 32455.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_is_account_user() != 37767.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_is_ignored() != 46154.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_is_name_ambiguous() != 65246.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_membership() != 34335.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_normalized_power_level() != 49076.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_power_level() != 17042.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_unignore() != 56817.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommember_user_id() != 19498.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommembersiterator_len() != 32977.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommembersiterator_next_chunk() != 35645.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sendattachmentjoinhandle_cancel() != 58929.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sendattachmentjoinhandle_join() != 25237.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_approve_verification() != 468.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_cancel_verification() != 63679.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_decline_verification() != 50627.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_is_verified() != 3866.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_request_verification() != 51679.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_set_delegate() != 24735.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_start_sas_verification() != 3726.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationemoji_description() != 55458.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationemoji_symbol() != 1848.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_span_enter() != 56663.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_span_exit() != 6123.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_span_is_none() != 23839.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservice_room_list_service() != 18295.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservice_start() != 4435.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservice_state() != 15048.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservice_stop() != 39770.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservicebuilder_finish() != 61604.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservicebuilder_with_cross_process_lock() != 29139.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_taskhandle_cancel() != 59047.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_taskhandle_is_finished() != 3905.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_add_listener() != 48101.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_cancel_send() != 51132.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_create_poll() != 38825.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_edit() != 58303.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_edit_poll() != 54368.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_end_poll() != 53347.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_fetch_details_for_event() != 20642.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_fetch_members() != 11365.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_get_event_timeline_item_by_event_id() != 62347.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_get_timeline_event_content_by_event_id() != 56265.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_paginate_backwards() != 50423.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_retry_decryption() != 26528.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_retry_send() != 51479.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_send() != 36960.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_send_audio() != 25012.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_send_file() != 34478.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_send_image() != 36106.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_send_location() != 61646.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_send_poll_response() != 51038.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_send_read_receipt() != 32920.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_send_reply() != 11052.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_send_video() != 29712.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_send_voice_message() != 7512.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_subscribe_to_back_pagination_status() != 38905.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_toggle_reaction() != 32033.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_append() != 24298.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_change() != 50296.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_insert() != 10002.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_push_back() != 35483.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_push_front() != 40108.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_remove() != 13408.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_reset() != 34789.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_set() != 45340.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineevent_event_id() != 20444.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineevent_event_type() != 52643.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineevent_sender_id() != 9141.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineevent_timestamp() != 30335.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineitem_as_event() != 755.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineitem_as_virtual() != 10265.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineitem_fmt_debug() != 25731.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineitem_unique_id() != 27999.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineitemcontent_as_message() != 58545.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineitemcontent_kind() != 60128.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_unreadnotificationscount_has_notifications() != 38874.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_unreadnotificationscount_highlight_count() != 30763.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_unreadnotificationscount_notification_count() != 10233.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_widgetdriver_run() != 39250.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_widgetdriverhandle_recv() != 25974.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_widgetdriverhandle_send() != 32739.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_constructor_mediasource_from_json() != 31512.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_constructor_authenticationservice_new() != 41347.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_constructor_clientbuilder_new() != 53567.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_constructor_span_current() != 47163.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_constructor_span_new() != 47854.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_backpaginationstatuslistener_on_update() != 2582.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_backupstatelistener_on_update() != 32936.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_backupsteadystatelistener_on_update() != 21611.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientdelegate_did_receive_auth_error() != 54393.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientdelegate_did_refresh_tokens() != 32841.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientsessiondelegate_retrieve_session_from_keychain() != 8049.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientsessiondelegate_save_session_in_keychain() != 30188.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_enablerecoveryprogresslistener_on_update() != 5434.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettingsdelegate_settings_did_change() != 4921.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_progresswatcher_transmission_progress() != 12165.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_recoverystatelistener_on_update() != 3601.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roominfolistener_call() != 567.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistentrieslistener_on_update() != 36351.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistloadingstatelistener_on_update() != 53567.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservicestatelistener_on_update() != 27905.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservicesyncindicatorlistener_on_update() != 63691.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_accept_verification_request() != 59777.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_start_sas_verification() != 15715.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_receive_verification_data() != 37461.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_fail() != 52235.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_cancel() != 52154.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_finish() != 45558.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservicestateobserver_on_update() != 52830.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinelistener_on_update() != 974.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_widgetcapabilitiesprovider_acquire_capabilities() != 47314.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

// Async support
// Async return type handlers

internal const val UNIFFI_RUST_FUTURE_POLL_READY = 0.toShort()
internal const val UNIFFI_RUST_FUTURE_POLL_MAYBE_READY = 1.toShort()

internal val uniffiContinuationHandleMap = UniFfiHandleMap<CancellableContinuation<Short>>()

// FFI type for Rust future continuations
internal object uniffiRustFutureContinuationCallback: UniFffiRustFutureContinuationCallbackType {
    override fun callback(continuationHandle: USize, pollResult: Short) {
        uniffiContinuationHandleMap.remove(continuationHandle)?.resume(pollResult)
    }
}

internal suspend fun<T, F, E: Exception> uniffiRustCallAsync(
    rustFuture: Pointer,
    pollFunc: (Pointer, UniFffiRustFutureContinuationCallbackType, USize) -> Unit,
    completeFunc: (Pointer, RustCallStatus) -> F,
    freeFunc: (Pointer) -> Unit,
    liftFunc: (F) -> T,
    errorHandler: CallStatusErrorHandler<E>
): T {
    try {
        do {
            val pollResult = suspendCancellableCoroutine<Short> { continuation ->
                pollFunc(
                    rustFuture,
                    uniffiRustFutureContinuationCallback,
                    uniffiContinuationHandleMap.insert(continuation)
                )
            }
        } while (pollResult != UNIFFI_RUST_FUTURE_POLL_READY);

        return liftFunc(
            rustCallWithError(errorHandler, { status -> completeFunc(rustFuture, status) })
        )
    } finally {
        freeFunc(rustFuture)
    }
}

// Public interface members begin here.


public object FfiConverterUByte: FfiConverter<UByte, Byte> {
    override fun lift(value: Byte): UByte {
        return value.toUByte()
    }

    override fun read(buf: ByteBuffer): UByte {
        return lift(buf.get())
    }

    override fun lower(value: UByte): Byte {
        return value.toByte()
    }

    override fun allocationSize(value: UByte) = 1

    override fun write(value: UByte, buf: ByteBuffer) {
        buf.put(value.toByte())
    }
}

public object FfiConverterUShort: FfiConverter<UShort, Short> {
    override fun lift(value: Short): UShort {
        return value.toUShort()
    }

    override fun read(buf: ByteBuffer): UShort {
        return lift(buf.getShort())
    }

    override fun lower(value: UShort): Short {
        return value.toShort()
    }

    override fun allocationSize(value: UShort) = 2

    override fun write(value: UShort, buf: ByteBuffer) {
        buf.putShort(value.toShort())
    }
}

public object FfiConverterUInt: FfiConverter<UInt, Int> {
    override fun lift(value: Int): UInt {
        return value.toUInt()
    }

    override fun read(buf: ByteBuffer): UInt {
        return lift(buf.getInt())
    }

    override fun lower(value: UInt): Int {
        return value.toInt()
    }

    override fun allocationSize(value: UInt) = 4

    override fun write(value: UInt, buf: ByteBuffer) {
        buf.putInt(value.toInt())
    }
}

public object FfiConverterInt: FfiConverter<Int, Int> {
    override fun lift(value: Int): Int {
        return value
    }

    override fun read(buf: ByteBuffer): Int {
        return buf.getInt()
    }

    override fun lower(value: Int): Int {
        return value
    }

    override fun allocationSize(value: Int) = 4

    override fun write(value: Int, buf: ByteBuffer) {
        buf.putInt(value)
    }
}

public object FfiConverterULong: FfiConverter<ULong, Long> {
    override fun lift(value: Long): ULong {
        return value.toULong()
    }

    override fun read(buf: ByteBuffer): ULong {
        return lift(buf.getLong())
    }

    override fun lower(value: ULong): Long {
        return value.toLong()
    }

    override fun allocationSize(value: ULong) = 8

    override fun write(value: ULong, buf: ByteBuffer) {
        buf.putLong(value.toLong())
    }
}

public object FfiConverterLong: FfiConverter<Long, Long> {
    override fun lift(value: Long): Long {
        return value
    }

    override fun read(buf: ByteBuffer): Long {
        return buf.getLong()
    }

    override fun lower(value: Long): Long {
        return value
    }

    override fun allocationSize(value: Long) = 8

    override fun write(value: Long, buf: ByteBuffer) {
        buf.putLong(value)
    }
}

public object FfiConverterDouble: FfiConverter<Double, Double> {
    override fun lift(value: Double): Double {
        return value
    }

    override fun read(buf: ByteBuffer): Double {
        return buf.getDouble()
    }

    override fun lower(value: Double): Double {
        return value
    }

    override fun allocationSize(value: Double) = 8

    override fun write(value: Double, buf: ByteBuffer) {
        buf.putDouble(value)
    }
}

public object FfiConverterBoolean: FfiConverter<Boolean, Byte> {
    override fun lift(value: Byte): Boolean {
        return value.toInt() != 0
    }

    override fun read(buf: ByteBuffer): Boolean {
        return lift(buf.get())
    }

    override fun lower(value: Boolean): Byte {
        return if (value) 1.toByte() else 0.toByte()
    }

    override fun allocationSize(value: Boolean) = 1

    override fun write(value: Boolean, buf: ByteBuffer) {
        buf.put(lower(value))
    }
}

public object FfiConverterString: FfiConverter<String, RustBuffer.ByValue> {
    // Note: we don't inherit from FfiConverterRustBuffer, because we use a
    // special encoding when lowering/lifting.  We can use `RustBuffer.len` to
    // store our length and avoid writing it out to the buffer.
    override fun lift(value: RustBuffer.ByValue): String {
        try {
            val byteArr = ByteArray(value.len)
            value.asByteBuffer()!!.get(byteArr)
            return byteArr.toString(Charsets.UTF_8)
        } finally {
            RustBuffer.free(value)
        }
    }

    override fun read(buf: ByteBuffer): String {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr.toString(Charsets.UTF_8)
    }

    fun toUtf8(value: String): ByteBuffer {
        // Make sure we don't have invalid UTF-16, check for lone surrogates.
        return Charsets.UTF_8.newEncoder().run {
            onMalformedInput(CodingErrorAction.REPORT)
            encode(CharBuffer.wrap(value))
        }
    }

    override fun lower(value: String): RustBuffer.ByValue {
        val byteBuf = toUtf8(value)
        // Ideally we'd pass these bytes to `ffi_bytebuffer_from_bytes`, but doing so would require us
        // to copy them into a JNA `Memory`. So we might as well directly copy them into a `RustBuffer`.
        val rbuf = RustBuffer.alloc(byteBuf.limit())
        rbuf.asByteBuffer()!!.put(byteBuf)
        return rbuf
    }

    // We aren't sure exactly how many bytes our string will be once it's UTF-8
    // encoded.  Allocate 3 bytes per UTF-16 code unit which will always be
    // enough.
    override fun allocationSize(value: String): Int {
        val sizeForLength = 4
        val sizeForString = value.length * 3
        return sizeForLength + sizeForString
    }

    override fun write(value: String, buf: ByteBuffer) {
        val byteBuf = toUtf8(value)
        buf.putInt(byteBuf.limit())
        buf.put(byteBuf)
    }
}

public object FfiConverterByteArray: FfiConverterRustBuffer<ByteArray> {
    override fun read(buf: ByteBuffer): ByteArray {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr
    }
    override fun allocationSize(value: ByteArray): Int {
        return 4 + value.size
    }
    override fun write(value: ByteArray, buf: ByteBuffer) {
        buf.putInt(value.size)
        buf.put(value)
    }
}


public object FfiConverterDuration: FfiConverterRustBuffer<java.time.Duration> {
    override fun read(buf: ByteBuffer): java.time.Duration {
        // Type mismatch (should be u64) but we check for overflow/underflow below
        val seconds = buf.getLong()
        // Type mismatch (should be u32) but we check for overflow/underflow below
        val nanoseconds = buf.getInt().toLong()
        if (seconds < 0) {
            throw java.time.DateTimeException("Duration exceeds minimum or maximum value supported by uniffi")
        }
        if (nanoseconds < 0) {
            throw java.time.DateTimeException("Duration nanoseconds exceed minimum or maximum supported by uniffi")
        }
        return java.time.Duration.ofSeconds(seconds, nanoseconds)
    }

    // 8 bytes for seconds, 4 bytes for nanoseconds
    override fun allocationSize(value: java.time.Duration) = 12

    override fun write(value: java.time.Duration, buf: ByteBuffer) {
        if (value.seconds < 0) {
            // Rust does not support negative Durations
            throw IllegalArgumentException("Invalid duration, must be non-negative")
        }

        if (value.nano < 0) {
            // Java docs provide guarantee that nano will always be positive, so this should be impossible
            // See: https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html
            throw IllegalArgumentException("Invalid duration, nano value must be non-negative")
        }

        // Type mismatch (should be u64) but since Rust doesn't support negative durations we should be OK
        buf.putLong(value.seconds)
        // Type mismatch (should be u32) but since values will always be between 0 and 999,999,999 it should be OK
        buf.putInt(value.nano)
    }
}



// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }

// The base class for all UniFFI Object types.
//
// This class provides core operations for working with the Rust `Arc<T>` pointer to
// the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// the Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each `FFIObject` instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an `FFIObject` is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an `FFIObject` instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so will
//     leak the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each `FFIObject` an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// In the future we may be able to replace some of this with automatic finalization logic, such as using
// the new "Cleaner" functionaility in Java 9. The above scheme has been designed to work even if `destroy` is
// invoked by garbage-collection machinery rather than by calling code (which by the way, it's apparently also
// possible for the JVM to finalize an object while there is an in-flight call to one of its methods [1],
// so there would still be some complexity here).
//
// Sigh...all of this for want of a robust finalization mechanism.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//
abstract class FFIObject: Disposable, AutoCloseable {

    constructor(pointer: Pointer) {
        this.pointer = pointer
    }

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
    }

    protected val pointer: Pointer?

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    open protected fun freeRustArcPtr() {
        // To be overridden in subclasses.
    }

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                this.freeRustArcPtr()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.pointer!!)
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                this.freeRustArcPtr()
            }
        }
    }
}

/** Used to instantiate a [FFIObject] without an actual pointer, for fakes in tests, mostly. */
object NoPointer

public interface AuthenticationServiceInterface {
    fun `configureHomeserver`(`serverNameOrHomeserverUrl`: String)
    fun `homeserverDetails`(): HomeserverLoginDetails?
    fun `login`(`username`: String, `password`: String, `initialDeviceName`: String?, `deviceId`: String?): Client
    fun `loginWithOidcCallback`(`authenticationData`: OidcAuthenticationData, `callbackUrl`: String): Client
    fun `urlForOidcLogin`(): OidcAuthenticationData
    
    companion object
}

open class AuthenticationService : FFIObject, AuthenticationServiceInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)
    constructor(`basePath`: String, `passphrase`: String?, `userAgent`: String?, `oidcConfiguration`: OidcConfiguration?, `customSlidingSyncProxy`: String?, `sessionDelegate`: ClientSessionDelegate?, `crossProcessRefreshLockId`: String?) :
        this(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_constructor_authenticationservice_new(FfiConverterString.lower(`basePath`),FfiConverterOptionalString.lower(`passphrase`),FfiConverterOptionalString.lower(`userAgent`),FfiConverterOptionalTypeOidcConfiguration.lower(`oidcConfiguration`),FfiConverterOptionalString.lower(`customSlidingSyncProxy`),FfiConverterOptionalTypeClientSessionDelegate.lower(`sessionDelegate`),FfiConverterOptionalString.lower(`crossProcessRefreshLockId`),_status)
})

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_authenticationservice(ptr, status)
            }
        }
    }

    
    @Throws(AuthenticationException::class)override fun `configureHomeserver`(`serverNameOrHomeserverUrl`: String) =
        callWithPointer {
    rustCallWithError(AuthenticationException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_authenticationservice_configure_homeserver(it,
        FfiConverterString.lower(`serverNameOrHomeserverUrl`),
        _status)
}
        }
    
    
    override fun `homeserverDetails`(): HomeserverLoginDetails? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_authenticationservice_homeserver_details(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeHomeserverLoginDetails.lift(it)
        }
    
    
    @Throws(AuthenticationException::class)override fun `login`(`username`: String, `password`: String, `initialDeviceName`: String?, `deviceId`: String?): Client =
        callWithPointer {
    rustCallWithError(AuthenticationException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_authenticationservice_login(it,
        FfiConverterString.lower(`username`),FfiConverterString.lower(`password`),FfiConverterOptionalString.lower(`initialDeviceName`),FfiConverterOptionalString.lower(`deviceId`),
        _status)
}
        }.let {
            FfiConverterTypeClient.lift(it)
        }
    
    
    @Throws(AuthenticationException::class)override fun `loginWithOidcCallback`(`authenticationData`: OidcAuthenticationData, `callbackUrl`: String): Client =
        callWithPointer {
    rustCallWithError(AuthenticationException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_authenticationservice_login_with_oidc_callback(it,
        FfiConverterTypeOidcAuthenticationData.lower(`authenticationData`),FfiConverterString.lower(`callbackUrl`),
        _status)
}
        }.let {
            FfiConverterTypeClient.lift(it)
        }
    
    
    @Throws(AuthenticationException::class)override fun `urlForOidcLogin`(): OidcAuthenticationData =
        callWithPointer {
    rustCallWithError(AuthenticationException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_authenticationservice_url_for_oidc_login(it,
        
        _status)
}
        }.let {
            FfiConverterTypeOidcAuthenticationData.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeAuthenticationService: FfiConverter<AuthenticationService, Pointer> {

    override fun lower(value: AuthenticationService): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): AuthenticationService {
        return AuthenticationService(value)
    }

    override fun read(buf: ByteBuffer): AuthenticationService {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: AuthenticationService) = 8

    override fun write(value: AuthenticationService, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface ClientInterface {
    fun `accountData`(`eventType`: String): String?
    fun `accountUrl`(`action`: AccountManagementAction?): String?
    fun `avatarUrl`(): String?
    fun `cachedAvatarUrl`(): String?
    fun `createRoom`(`request`: CreateRoomParameters): String
    fun `deviceId`(): String
    fun `displayName`(): String
    fun `encryption`(): Encryption
    fun `getDmRoom`(`userId`: String): Room?
    fun `getMediaContent`(`mediaSource`: MediaSource): ByteArray
    fun `getMediaFile`(`mediaSource`: MediaSource, `body`: String?, `mimeType`: String, `useCache`: Boolean, `tempDir`: String?): MediaFileHandle
    fun `getMediaThumbnail`(`mediaSource`: MediaSource, `width`: ULong, `height`: ULong): ByteArray
    fun `getNotificationSettings`(): NotificationSettings
    fun `getProfile`(`userId`: String): UserProfile
    fun `getSessionVerificationController`(): SessionVerificationController
    fun `homeserver`(): String
    fun `ignoreUser`(`userId`: String)
    fun `login`(`username`: String, `password`: String, `initialDeviceName`: String?, `deviceId`: String?)
    fun `logout`(): String?
    fun `notificationClient`(`processSetup`: NotificationProcessSetup): NotificationClientBuilder
    fun `removeAvatar`()
    fun `restoreSession`(`session`: Session)
    fun `rooms`(): List<Room>
    fun `searchUsers`(`searchTerm`: String, `limit`: ULong): SearchUsersResults
    fun `session`(): Session
    fun `setAccountData`(`eventType`: String, `content`: String)
    fun `setDelegate`(`delegate`: ClientDelegate?): TaskHandle?
    fun `setDisplayName`(`name`: String)
    fun `setPusher`(`identifiers`: PusherIdentifiers, `kind`: PusherKind, `appDisplayName`: String, `deviceDisplayName`: String, `profileTag`: String?, `lang`: String)
    fun `syncService`(): SyncServiceBuilder
    fun `unignoreUser`(`userId`: String)
    fun `uploadAvatar`(`mimeType`: String, `data`: ByteArray)
    fun `uploadMedia`(`mimeType`: String, `data`: ByteArray, `progressWatcher`: ProgressWatcher?): String
    fun `userId`(): String
    
    companion object
}

open class Client : FFIObject, ClientInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_client(ptr, status)
            }
        }
    }

    
    @Throws(ClientException::class)override fun `accountData`(`eventType`: String): String? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_account_data(it,
        FfiConverterString.lower(`eventType`),
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `accountUrl`(`action`: AccountManagementAction?): String? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_account_url(it,
        FfiConverterOptionalTypeAccountManagementAction.lower(`action`),
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `avatarUrl`(): String? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_avatar_url(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `cachedAvatarUrl`(): String? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_cached_avatar_url(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `createRoom`(`request`: CreateRoomParameters): String =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_create_room(it,
        FfiConverterTypeCreateRoomParameters.lower(`request`),
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `deviceId`(): String =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_device_id(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `displayName`(): String =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_display_name(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `encryption`(): Encryption =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_encryption(it,
        
        _status)
}
        }.let {
            FfiConverterTypeEncryption.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `getDmRoom`(`userId`: String): Room? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_dm_room(it,
        FfiConverterString.lower(`userId`),
        _status)
}
        }.let {
            FfiConverterOptionalTypeRoom.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `getMediaContent`(`mediaSource`: MediaSource): ByteArray =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_media_content(it,
        FfiConverterTypeMediaSource.lower(`mediaSource`),
        _status)
}
        }.let {
            FfiConverterByteArray.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `getMediaFile`(`mediaSource`: MediaSource, `body`: String?, `mimeType`: String, `useCache`: Boolean, `tempDir`: String?): MediaFileHandle =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_media_file(it,
        FfiConverterTypeMediaSource.lower(`mediaSource`),FfiConverterOptionalString.lower(`body`),FfiConverterString.lower(`mimeType`),FfiConverterBoolean.lower(`useCache`),FfiConverterOptionalString.lower(`tempDir`),
        _status)
}
        }.let {
            FfiConverterTypeMediaFileHandle.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `getMediaThumbnail`(`mediaSource`: MediaSource, `width`: ULong, `height`: ULong): ByteArray =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_media_thumbnail(it,
        FfiConverterTypeMediaSource.lower(`mediaSource`),FfiConverterULong.lower(`width`),FfiConverterULong.lower(`height`),
        _status)
}
        }.let {
            FfiConverterByteArray.lift(it)
        }
    
    override fun `getNotificationSettings`(): NotificationSettings =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_notification_settings(it,
        
        _status)
}
        }.let {
            FfiConverterTypeNotificationSettings.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `getProfile`(`userId`: String): UserProfile =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_profile(it,
        FfiConverterString.lower(`userId`),
        _status)
}
        }.let {
            FfiConverterTypeUserProfile.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `getSessionVerificationController`(): SessionVerificationController =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_session_verification_controller(it,
        
        _status)
}
        }.let {
            FfiConverterTypeSessionVerificationController.lift(it)
        }
    
    override fun `homeserver`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_homeserver(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `ignoreUser`(`userId`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_ignore_user(it,
        FfiConverterString.lower(`userId`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `login`(`username`: String, `password`: String, `initialDeviceName`: String?, `deviceId`: String?) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_login(it,
        FfiConverterString.lower(`username`),FfiConverterString.lower(`password`),FfiConverterOptionalString.lower(`initialDeviceName`),FfiConverterOptionalString.lower(`deviceId`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `logout`(): String? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_logout(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `notificationClient`(`processSetup`: NotificationProcessSetup): NotificationClientBuilder =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_notification_client(it,
        FfiConverterTypeNotificationProcessSetup.lower(`processSetup`),
        _status)
}
        }.let {
            FfiConverterTypeNotificationClientBuilder.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `removeAvatar`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_remove_avatar(it,
        
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `restoreSession`(`session`: Session) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_restore_session(it,
        FfiConverterTypeSession.lower(`session`),
        _status)
}
        }
    
    
    override fun `rooms`(): List<Room> =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_rooms(it,
        
        _status)
}
        }.let {
            FfiConverterSequenceTypeRoom.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `searchUsers`(`searchTerm`: String, `limit`: ULong): SearchUsersResults =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_search_users(it,
        FfiConverterString.lower(`searchTerm`),FfiConverterULong.lower(`limit`),
        _status)
}
        }.let {
            FfiConverterTypeSearchUsersResults.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `session`(): Session =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_session(it,
        
        _status)
}
        }.let {
            FfiConverterTypeSession.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `setAccountData`(`eventType`: String, `content`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_set_account_data(it,
        FfiConverterString.lower(`eventType`),FfiConverterString.lower(`content`),
        _status)
}
        }
    
    
    override fun `setDelegate`(`delegate`: ClientDelegate?): TaskHandle? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_set_delegate(it,
        FfiConverterOptionalTypeClientDelegate.lower(`delegate`),
        _status)
}
        }.let {
            FfiConverterOptionalTypeTaskHandle.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `setDisplayName`(`name`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_set_display_name(it,
        FfiConverterString.lower(`name`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `setPusher`(`identifiers`: PusherIdentifiers, `kind`: PusherKind, `appDisplayName`: String, `deviceDisplayName`: String, `profileTag`: String?, `lang`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_set_pusher(it,
        FfiConverterTypePusherIdentifiers.lower(`identifiers`),FfiConverterTypePusherKind.lower(`kind`),FfiConverterString.lower(`appDisplayName`),FfiConverterString.lower(`deviceDisplayName`),FfiConverterOptionalString.lower(`profileTag`),FfiConverterString.lower(`lang`),
        _status)
}
        }
    
    
    override fun `syncService`(): SyncServiceBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_sync_service(it,
        
        _status)
}
        }.let {
            FfiConverterTypeSyncServiceBuilder.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `unignoreUser`(`userId`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_unignore_user(it,
        FfiConverterString.lower(`userId`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `uploadAvatar`(`mimeType`: String, `data`: ByteArray) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_upload_avatar(it,
        FfiConverterString.lower(`mimeType`),FfiConverterByteArray.lower(`data`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `uploadMedia`(`mimeType`: String, `data`: ByteArray, `progressWatcher`: ProgressWatcher?): String =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_upload_media(it,
        FfiConverterString.lower(`mimeType`),FfiConverterByteArray.lower(`data`),FfiConverterOptionalTypeProgressWatcher.lower(`progressWatcher`),
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `userId`(): String =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_user_id(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeClient: FfiConverter<Client, Pointer> {

    override fun lower(value: Client): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): Client {
        return Client(value)
    }

    override fun read(buf: ByteBuffer): Client {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Client) = 8

    override fun write(value: Client, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface ClientBuilderInterface {
    fun `basePath`(`path`: String): ClientBuilder
    fun `build`(): Client
    fun `disableAutomaticTokenRefresh`(): ClientBuilder
    fun `disableSslVerification`(): ClientBuilder
    fun `enableCrossProcessRefreshLock`(`processId`: String, `sessionDelegate`: ClientSessionDelegate): ClientBuilder
    fun `homeserverUrl`(`url`: String): ClientBuilder
    fun `passphrase`(`passphrase`: String?): ClientBuilder
    fun `proxy`(`url`: String): ClientBuilder
    fun `serverName`(`serverName`: String): ClientBuilder
    fun `serverVersions`(`versions`: List<String>): ClientBuilder
    fun `setSessionDelegate`(`sessionDelegate`: ClientSessionDelegate): ClientBuilder
    fun `slidingSyncProxy`(`slidingSyncProxy`: String?): ClientBuilder
    fun `userAgent`(`userAgent`: String): ClientBuilder
    fun `username`(`username`: String): ClientBuilder
    
    companion object
}

open class ClientBuilder : FFIObject, ClientBuilderInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)
    constructor() :
        this(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_constructor_clientbuilder_new(_status)
})

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_clientbuilder(ptr, status)
            }
        }
    }

    override fun `basePath`(`path`: String): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_base_path(it,
        FfiConverterString.lower(`path`),
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `build`(): Client =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_build(it,
        
        _status)
}
        }.let {
            FfiConverterTypeClient.lift(it)
        }
    
    override fun `disableAutomaticTokenRefresh`(): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_disable_automatic_token_refresh(it,
        
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `disableSslVerification`(): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_disable_ssl_verification(it,
        
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `enableCrossProcessRefreshLock`(`processId`: String, `sessionDelegate`: ClientSessionDelegate): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_enable_cross_process_refresh_lock(it,
        FfiConverterString.lower(`processId`),FfiConverterTypeClientSessionDelegate.lower(`sessionDelegate`),
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `homeserverUrl`(`url`: String): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_homeserver_url(it,
        FfiConverterString.lower(`url`),
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `passphrase`(`passphrase`: String?): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_passphrase(it,
        FfiConverterOptionalString.lower(`passphrase`),
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `proxy`(`url`: String): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_proxy(it,
        FfiConverterString.lower(`url`),
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `serverName`(`serverName`: String): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_server_name(it,
        FfiConverterString.lower(`serverName`),
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `serverVersions`(`versions`: List<String>): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_server_versions(it,
        FfiConverterSequenceString.lower(`versions`),
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `setSessionDelegate`(`sessionDelegate`: ClientSessionDelegate): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_set_session_delegate(it,
        FfiConverterTypeClientSessionDelegate.lower(`sessionDelegate`),
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `slidingSyncProxy`(`slidingSyncProxy`: String?): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_sliding_sync_proxy(it,
        FfiConverterOptionalString.lower(`slidingSyncProxy`),
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `userAgent`(`userAgent`: String): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_user_agent(it,
        FfiConverterString.lower(`userAgent`),
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    override fun `username`(`username`: String): ClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_username(it,
        FfiConverterString.lower(`username`),
        _status)
}
        }.let {
            FfiConverterTypeClientBuilder.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeClientBuilder: FfiConverter<ClientBuilder, Pointer> {

    override fun lower(value: ClientBuilder): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): ClientBuilder {
        return ClientBuilder(value)
    }

    override fun read(buf: ByteBuffer): ClientBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: ClientBuilder) = 8

    override fun write(value: ClientBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface EncryptionInterface {
    suspend fun `backupExistsOnServer`(): Boolean
    fun `backupState`(): BackupState
    fun `backupStateListener`(`listener`: BackupStateListener): TaskHandle
    suspend fun `disableRecovery`()
    suspend fun `enableBackups`()
    suspend fun `enableRecovery`(`waitForBackupsToUpload`: Boolean, `progressListener`: EnableRecoveryProgressListener): String
    suspend fun `isLastDevice`(): Boolean
    suspend fun `recover`(`recoveryKey`: String)
    suspend fun `recoverAndReset`(`oldRecoveryKey`: String): String
    fun `recoveryState`(): RecoveryState
    fun `recoveryStateListener`(`listener`: RecoveryStateListener): TaskHandle
    suspend fun `resetRecoveryKey`(): String
    suspend fun `waitForBackupUploadSteadyState`(`progressListener`: BackupSteadyStateListener?)
    
    companion object
}

open class Encryption : FFIObject, EncryptionInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_encryption(ptr, status)
            }
        }
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `backupExistsOnServer`() : Boolean {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_backup_exists_on_server(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
            // lift function
            { FfiConverterBoolean.lift(it) },
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    override fun `backupState`(): BackupState =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_backup_state(it,
        
        _status)
}
        }.let {
            FfiConverterTypeBackupState.lift(it)
        }
    
    override fun `backupStateListener`(`listener`: BackupStateListener): TaskHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_backup_state_listener(it,
        FfiConverterTypeBackupStateListener.lower(`listener`),
        _status)
}
        }.let {
            FfiConverterTypeTaskHandle.lift(it)
        }
    
    
    @Throws(RecoveryException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `disableRecovery`() {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_disable_recovery(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            RecoveryException.ErrorHandler,
        )
    }
    
    @Throws(RecoveryException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `enableBackups`() {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_enable_backups(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            RecoveryException.ErrorHandler,
        )
    }
    
    @Throws(RecoveryException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `enableRecovery`(`waitForBackupsToUpload`: Boolean, `progressListener`: EnableRecoveryProgressListener) : String {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_enable_recovery(
                    thisPtr,
                    FfiConverterBoolean.lower(`waitForBackupsToUpload`),FfiConverterTypeEnableRecoveryProgressListener.lower(`progressListener`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterString.lift(it) },
            // Error FFI converter
            RecoveryException.ErrorHandler,
        )
    }
    
    @Throws(RecoveryException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `isLastDevice`() : Boolean {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_is_last_device(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
            // lift function
            { FfiConverterBoolean.lift(it) },
            // Error FFI converter
            RecoveryException.ErrorHandler,
        )
    }
    
    @Throws(RecoveryException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `recover`(`recoveryKey`: String) {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_recover(
                    thisPtr,
                    FfiConverterString.lower(`recoveryKey`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            RecoveryException.ErrorHandler,
        )
    }
    
    @Throws(RecoveryException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `recoverAndReset`(`oldRecoveryKey`: String) : String {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_recover_and_reset(
                    thisPtr,
                    FfiConverterString.lower(`oldRecoveryKey`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterString.lift(it) },
            // Error FFI converter
            RecoveryException.ErrorHandler,
        )
    }
    override fun `recoveryState`(): RecoveryState =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_recovery_state(it,
        
        _status)
}
        }.let {
            FfiConverterTypeRecoveryState.lift(it)
        }
    
    override fun `recoveryStateListener`(`listener`: RecoveryStateListener): TaskHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_recovery_state_listener(it,
        FfiConverterTypeRecoveryStateListener.lower(`listener`),
        _status)
}
        }.let {
            FfiConverterTypeTaskHandle.lift(it)
        }
    
    
    @Throws(RecoveryException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `resetRecoveryKey`() : String {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_reset_recovery_key(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterString.lift(it) },
            // Error FFI converter
            RecoveryException.ErrorHandler,
        )
    }
    
    @Throws(SteadyStateException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `waitForBackupUploadSteadyState`(`progressListener`: BackupSteadyStateListener?) {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_wait_for_backup_upload_steady_state(
                    thisPtr,
                    FfiConverterOptionalTypeBackupSteadyStateListener.lower(`progressListener`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            SteadyStateException.ErrorHandler,
        )
    }
    

    
    companion object
    
}

public object FfiConverterTypeEncryption: FfiConverter<Encryption, Pointer> {

    override fun lower(value: Encryption): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): Encryption {
        return Encryption(value)
    }

    override fun read(buf: ByteBuffer): Encryption {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Encryption) = 8

    override fun write(value: Encryption, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface EventTimelineItemInterface {
    fun `canBeRepliedTo`(): Boolean
    fun `content`(): TimelineItemContent
    fun `debugInfo`(): EventTimelineItemDebugInfo
    fun `eventId`(): String?
    fun `isEditable`(): Boolean
    fun `isLocal`(): Boolean
    fun `isOwn`(): Boolean
    fun `isRemote`(): Boolean
    fun `localSendState`(): EventSendState?
    fun `origin`(): EventItemOrigin?
    fun `reactions`(): List<Reaction>
    fun `readReceipts`(): Map<String, Receipt>
    fun `sender`(): String
    fun `senderProfile`(): ProfileDetails
    fun `timestamp`(): ULong
    fun `transactionId`(): String?
    
    companion object
}

open class EventTimelineItem : FFIObject, EventTimelineItemInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_eventtimelineitem(ptr, status)
            }
        }
    }

    override fun `canBeRepliedTo`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_can_be_replied_to(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `content`(): TimelineItemContent =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_content(it,
        
        _status)
}
        }.let {
            FfiConverterTypeTimelineItemContent.lift(it)
        }
    
    override fun `debugInfo`(): EventTimelineItemDebugInfo =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_debug_info(it,
        
        _status)
}
        }.let {
            FfiConverterTypeEventTimelineItemDebugInfo.lift(it)
        }
    
    override fun `eventId`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_event_id(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    override fun `isEditable`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_editable(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isLocal`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_local(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isOwn`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_own(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isRemote`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_remote(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `localSendState`(): EventSendState? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_local_send_state(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeEventSendState.lift(it)
        }
    
    override fun `origin`(): EventItemOrigin? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_origin(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeEventItemOrigin.lift(it)
        }
    
    override fun `reactions`(): List<Reaction> =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_reactions(it,
        
        _status)
}
        }.let {
            FfiConverterSequenceTypeReaction.lift(it)
        }
    
    override fun `readReceipts`(): Map<String, Receipt> =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_read_receipts(it,
        
        _status)
}
        }.let {
            FfiConverterMapStringTypeReceipt.lift(it)
        }
    
    override fun `sender`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_sender(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `senderProfile`(): ProfileDetails =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_sender_profile(it,
        
        _status)
}
        }.let {
            FfiConverterTypeProfileDetails.lift(it)
        }
    
    override fun `timestamp`(): ULong =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_timestamp(it,
        
        _status)
}
        }.let {
            FfiConverterULong.lift(it)
        }
    
    override fun `transactionId`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_transaction_id(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeEventTimelineItem: FfiConverter<EventTimelineItem, Pointer> {

    override fun lower(value: EventTimelineItem): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): EventTimelineItem {
        return EventTimelineItem(value)
    }

    override fun read(buf: ByteBuffer): EventTimelineItem {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: EventTimelineItem) = 8

    override fun write(value: EventTimelineItem, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface HomeserverLoginDetailsInterface {
    fun `supportsOidcLogin`(): Boolean
    fun `supportsPasswordLogin`(): Boolean
    fun `url`(): String
    
    companion object
}

open class HomeserverLoginDetails : FFIObject, HomeserverLoginDetailsInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_homeserverlogindetails(ptr, status)
            }
        }
    }

    override fun `supportsOidcLogin`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_homeserverlogindetails_supports_oidc_login(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `supportsPasswordLogin`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_homeserverlogindetails_supports_password_login(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `url`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_homeserverlogindetails_url(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeHomeserverLoginDetails: FfiConverter<HomeserverLoginDetails, Pointer> {

    override fun lower(value: HomeserverLoginDetails): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): HomeserverLoginDetails {
        return HomeserverLoginDetails(value)
    }

    override fun read(buf: ByteBuffer): HomeserverLoginDetails {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: HomeserverLoginDetails) = 8

    override fun write(value: HomeserverLoginDetails, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface MediaFileHandleInterface {
    fun `path`(): String
    fun `persist`(`path`: String): Boolean
    
    companion object
}

open class MediaFileHandle : FFIObject, MediaFileHandleInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_mediafilehandle(ptr, status)
            }
        }
    }

    
    @Throws(ClientException::class)override fun `path`(): String =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_mediafilehandle_path(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `persist`(`path`: String): Boolean =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_mediafilehandle_persist(it,
        FfiConverterString.lower(`path`),
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeMediaFileHandle: FfiConverter<MediaFileHandle, Pointer> {

    override fun lower(value: MediaFileHandle): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): MediaFileHandle {
        return MediaFileHandle(value)
    }

    override fun read(buf: ByteBuffer): MediaFileHandle {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: MediaFileHandle) = 8

    override fun write(value: MediaFileHandle, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface MediaSourceInterface {
    fun `toJson`(): String
    fun `url`(): String
    
    companion object
}

open class MediaSource : FFIObject, MediaSourceInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_mediasource(ptr, status)
            }
        }
    }

    override fun `toJson`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_mediasource_to_json(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `url`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_mediasource_url(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    companion object {
        fun `fromJson`(`json`: String): MediaSource =
            MediaSource(
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_constructor_mediasource_from_json(FfiConverterString.lower(`json`),_status)
})
        
    }
    
}

public object FfiConverterTypeMediaSource: FfiConverter<MediaSource, Pointer> {

    override fun lower(value: MediaSource): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): MediaSource {
        return MediaSource(value)
    }

    override fun read(buf: ByteBuffer): MediaSource {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: MediaSource) = 8

    override fun write(value: MediaSource, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface MessageInterface {
    fun `body`(): String
    fun `inReplyTo`(): InReplyToDetails?
    fun `isEdited`(): Boolean
    fun `isThreaded`(): Boolean
    fun `msgtype`(): MessageType
    
    companion object
}

open class Message : FFIObject, MessageInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_message(ptr, status)
            }
        }
    }

    override fun `body`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_message_body(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `inReplyTo`(): InReplyToDetails? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_message_in_reply_to(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeInReplyToDetails.lift(it)
        }
    
    override fun `isEdited`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_message_is_edited(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isThreaded`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_message_is_threaded(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `msgtype`(): MessageType =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_message_msgtype(it,
        
        _status)
}
        }.let {
            FfiConverterTypeMessageType.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeMessage: FfiConverter<Message, Pointer> {

    override fun lower(value: Message): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): Message {
        return Message(value)
    }

    override fun read(buf: ByteBuffer): Message {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Message) = 8

    override fun write(value: Message, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface NotificationClientInterface {
    fun `getNotification`(`roomId`: String, `eventId`: String): NotificationItem?
    
    companion object
}

open class NotificationClient : FFIObject, NotificationClientInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_notificationclient(ptr, status)
            }
        }
    }

    
    @Throws(ClientException::class)override fun `getNotification`(`roomId`: String, `eventId`: String): NotificationItem? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationclient_get_notification(it,
        FfiConverterString.lower(`roomId`),FfiConverterString.lower(`eventId`),
        _status)
}
        }.let {
            FfiConverterOptionalTypeNotificationItem.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeNotificationClient: FfiConverter<NotificationClient, Pointer> {

    override fun lower(value: NotificationClient): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): NotificationClient {
        return NotificationClient(value)
    }

    override fun read(buf: ByteBuffer): NotificationClient {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: NotificationClient) = 8

    override fun write(value: NotificationClient, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface NotificationClientBuilderInterface {
    fun `filterByPushRules`(): NotificationClientBuilder
    fun `finish`(): NotificationClient
    
    companion object
}

open class NotificationClientBuilder : FFIObject, NotificationClientBuilderInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_notificationclientbuilder(ptr, status)
            }
        }
    }

    override fun `filterByPushRules`(): NotificationClientBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationclientbuilder_filter_by_push_rules(it,
        
        _status)
}
        }.let {
            FfiConverterTypeNotificationClientBuilder.lift(it)
        }
    
    override fun `finish`(): NotificationClient =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationclientbuilder_finish(it,
        
        _status)
}
        }.let {
            FfiConverterTypeNotificationClient.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeNotificationClientBuilder: FfiConverter<NotificationClientBuilder, Pointer> {

    override fun lower(value: NotificationClientBuilder): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): NotificationClientBuilder {
        return NotificationClientBuilder(value)
    }

    override fun read(buf: ByteBuffer): NotificationClientBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: NotificationClientBuilder) = 8

    override fun write(value: NotificationClientBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface NotificationSettingsInterface {
    suspend fun `canHomeserverPushEncryptedEventToDevice`(): Boolean
    suspend fun `containsKeywordsRules`(): Boolean
    suspend fun `getDefaultRoomNotificationMode`(`isEncrypted`: Boolean, `isOneToOne`: Boolean): RoomNotificationMode
    suspend fun `getRoomNotificationSettings`(`roomId`: String, `isEncrypted`: Boolean, `isOneToOne`: Boolean): RoomNotificationSettings
    suspend fun `getRoomsWithUserDefinedRules`(`enabled`: Boolean?): List<String>
    suspend fun `getUserDefinedRoomNotificationMode`(`roomId`: String): RoomNotificationMode?
    suspend fun `isCallEnabled`(): Boolean
    suspend fun `isInviteForMeEnabled`(): Boolean
    suspend fun `isRoomMentionEnabled`(): Boolean
    suspend fun `isUserMentionEnabled`(): Boolean
    suspend fun `restoreDefaultRoomNotificationMode`(`roomId`: String)
    suspend fun `setCallEnabled`(`enabled`: Boolean)
    suspend fun `setDefaultRoomNotificationMode`(`isEncrypted`: Boolean, `isOneToOne`: Boolean, `mode`: RoomNotificationMode)
    fun `setDelegate`(`delegate`: NotificationSettingsDelegate?)
    suspend fun `setInviteForMeEnabled`(`enabled`: Boolean)
    suspend fun `setRoomMentionEnabled`(`enabled`: Boolean)
    suspend fun `setRoomNotificationMode`(`roomId`: String, `mode`: RoomNotificationMode)
    suspend fun `setUserMentionEnabled`(`enabled`: Boolean)
    suspend fun `unmuteRoom`(`roomId`: String, `isEncrypted`: Boolean, `isOneToOne`: Boolean)
    
    companion object
}

open class NotificationSettings : FFIObject, NotificationSettingsInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_notificationsettings(ptr, status)
            }
        }
    }

    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canHomeserverPushEncryptedEventToDevice`() : Boolean {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_can_homeserver_push_encrypted_event_to_device(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
            // lift function
            { FfiConverterBoolean.lift(it) },
            // Error FFI converter
            NullCallStatusErrorHandler,
        )
    }
    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `containsKeywordsRules`() : Boolean {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_contains_keywords_rules(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
            // lift function
            { FfiConverterBoolean.lift(it) },
            // Error FFI converter
            NullCallStatusErrorHandler,
        )
    }
    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getDefaultRoomNotificationMode`(`isEncrypted`: Boolean, `isOneToOne`: Boolean) : RoomNotificationMode {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_get_default_room_notification_mode(
                    thisPtr,
                    FfiConverterBoolean.lower(`isEncrypted`),FfiConverterBoolean.lower(`isOneToOne`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterTypeRoomNotificationMode.lift(it) },
            // Error FFI converter
            NullCallStatusErrorHandler,
        )
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getRoomNotificationSettings`(`roomId`: String, `isEncrypted`: Boolean, `isOneToOne`: Boolean) : RoomNotificationSettings {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_get_room_notification_settings(
                    thisPtr,
                    FfiConverterString.lower(`roomId`),FfiConverterBoolean.lower(`isEncrypted`),FfiConverterBoolean.lower(`isOneToOne`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterTypeRoomNotificationSettings.lift(it) },
            // Error FFI converter
            NotificationSettingsException.ErrorHandler,
        )
    }
    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getRoomsWithUserDefinedRules`(`enabled`: Boolean?) : List<String> {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_get_rooms_with_user_defined_rules(
                    thisPtr,
                    FfiConverterOptionalBoolean.lower(`enabled`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterSequenceString.lift(it) },
            // Error FFI converter
            NullCallStatusErrorHandler,
        )
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getUserDefinedRoomNotificationMode`(`roomId`: String) : RoomNotificationMode? {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_get_user_defined_room_notification_mode(
                    thisPtr,
                    FfiConverterString.lower(`roomId`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterOptionalTypeRoomNotificationMode.lift(it) },
            // Error FFI converter
            NotificationSettingsException.ErrorHandler,
        )
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `isCallEnabled`() : Boolean {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_call_enabled(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
            // lift function
            { FfiConverterBoolean.lift(it) },
            // Error FFI converter
            NotificationSettingsException.ErrorHandler,
        )
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `isInviteForMeEnabled`() : Boolean {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_invite_for_me_enabled(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
            // lift function
            { FfiConverterBoolean.lift(it) },
            // Error FFI converter
            NotificationSettingsException.ErrorHandler,
        )
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `isRoomMentionEnabled`() : Boolean {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_room_mention_enabled(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
            // lift function
            { FfiConverterBoolean.lift(it) },
            // Error FFI converter
            NotificationSettingsException.ErrorHandler,
        )
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `isUserMentionEnabled`() : Boolean {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_user_mention_enabled(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
            // lift function
            { FfiConverterBoolean.lift(it) },
            // Error FFI converter
            NotificationSettingsException.ErrorHandler,
        )
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `restoreDefaultRoomNotificationMode`(`roomId`: String) {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_restore_default_room_notification_mode(
                    thisPtr,
                    FfiConverterString.lower(`roomId`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            NotificationSettingsException.ErrorHandler,
        )
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setCallEnabled`(`enabled`: Boolean) {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_call_enabled(
                    thisPtr,
                    FfiConverterBoolean.lower(`enabled`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            NotificationSettingsException.ErrorHandler,
        )
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setDefaultRoomNotificationMode`(`isEncrypted`: Boolean, `isOneToOne`: Boolean, `mode`: RoomNotificationMode) {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_default_room_notification_mode(
                    thisPtr,
                    FfiConverterBoolean.lower(`isEncrypted`),FfiConverterBoolean.lower(`isOneToOne`),FfiConverterTypeRoomNotificationMode.lower(`mode`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            NotificationSettingsException.ErrorHandler,
        )
    }
    override fun `setDelegate`(`delegate`: NotificationSettingsDelegate?) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_delegate(it,
        FfiConverterOptionalTypeNotificationSettingsDelegate.lower(`delegate`),
        _status)
}
        }
    
    
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setInviteForMeEnabled`(`enabled`: Boolean) {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_invite_for_me_enabled(
                    thisPtr,
                    FfiConverterBoolean.lower(`enabled`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            NotificationSettingsException.ErrorHandler,
        )
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setRoomMentionEnabled`(`enabled`: Boolean) {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_room_mention_enabled(
                    thisPtr,
                    FfiConverterBoolean.lower(`enabled`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            NotificationSettingsException.ErrorHandler,
        )
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setRoomNotificationMode`(`roomId`: String, `mode`: RoomNotificationMode) {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_room_notification_mode(
                    thisPtr,
                    FfiConverterString.lower(`roomId`),FfiConverterTypeRoomNotificationMode.lower(`mode`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            NotificationSettingsException.ErrorHandler,
        )
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setUserMentionEnabled`(`enabled`: Boolean) {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_user_mention_enabled(
                    thisPtr,
                    FfiConverterBoolean.lower(`enabled`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            NotificationSettingsException.ErrorHandler,
        )
    }
    
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `unmuteRoom`(`roomId`: String, `isEncrypted`: Boolean, `isOneToOne`: Boolean) {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_unmute_room(
                    thisPtr,
                    FfiConverterString.lower(`roomId`),FfiConverterBoolean.lower(`isEncrypted`),FfiConverterBoolean.lower(`isOneToOne`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            NotificationSettingsException.ErrorHandler,
        )
    }
    

    
    companion object
    
}

public object FfiConverterTypeNotificationSettings: FfiConverter<NotificationSettings, Pointer> {

    override fun lower(value: NotificationSettings): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): NotificationSettings {
        return NotificationSettings(value)
    }

    override fun read(buf: ByteBuffer): NotificationSettings {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: NotificationSettings) = 8

    override fun write(value: NotificationSettings, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface OidcAuthenticationDataInterface {
    fun `loginUrl`(): String
    
    companion object
}

open class OidcAuthenticationData : FFIObject, OidcAuthenticationDataInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_oidcauthenticationdata(ptr, status)
            }
        }
    }

    override fun `loginUrl`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_oidcauthenticationdata_login_url(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeOidcAuthenticationData: FfiConverter<OidcAuthenticationData, Pointer> {

    override fun lower(value: OidcAuthenticationData): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): OidcAuthenticationData {
        return OidcAuthenticationData(value)
    }

    override fun read(buf: ByteBuffer): OidcAuthenticationData {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: OidcAuthenticationData) = 8

    override fun write(value: OidcAuthenticationData, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface RoomInterface {
    fun `activeMembersCount`(): ULong
    fun `activeRoomCallParticipants`(): List<String>
    fun `alternativeAliases`(): List<String>
    fun `avatarUrl`(): String?
    suspend fun `canUserBan`(`userId`: String): Boolean
    suspend fun `canUserInvite`(`userId`: String): Boolean
    suspend fun `canUserKick`(`userId`: String): Boolean
    suspend fun `canUserRedact`(`userId`: String): Boolean
    suspend fun `canUserSendMessage`(`userId`: String, `message`: MessageLikeEventType): Boolean
    suspend fun `canUserSendState`(`userId`: String, `stateEvent`: StateEventType): Boolean
    suspend fun `canUserTriggerRoomNotification`(`userId`: String): Boolean
    fun `canonicalAlias`(): String?
    fun `displayName`(): String
    fun `hasActiveRoomCall`(): Boolean
    fun `id`(): String
    fun `ignoreUser`(`userId`: String)
    fun `inviteUserById`(`userId`: String)
    fun `invitedMembersCount`(): ULong
    fun `inviter`(): RoomMember?
    fun `isDirect`(): Boolean
    fun `isEncrypted`(): Boolean
    fun `isPublic`(): Boolean
    fun `isSpace`(): Boolean
    fun `isTombstoned`(): Boolean
    fun `join`()
    fun `joinedMembersCount`(): ULong
    fun `leave`()
    suspend fun `member`(`userId`: String): RoomMember
    fun `memberAvatarUrl`(`userId`: String): String?
    fun `memberDisplayName`(`userId`: String): String?
    suspend fun `members`(): RoomMembersIterator
    fun `membership`(): Membership
    fun `name`(): String?
    fun `ownUserId`(): String
    suspend fun `pollHistory`(): Timeline
    fun `redact`(`eventId`: String, `reason`: String?)
    fun `removeAvatar`()
    fun `reportContent`(`eventId`: String, `score`: Int?, `reason`: String?)
    suspend fun `roomInfo`(): RoomInfo
    fun `setName`(`name`: String)
    fun `setTopic`(`topic`: String)
    fun `subscribeToRoomInfoUpdates`(`listener`: RoomInfoListener): TaskHandle
    suspend fun `timeline`(): Timeline
    fun `topic`(): String?
    suspend fun `typingNotice`(`isTyping`: Boolean)
    fun `uploadAvatar`(`mimeType`: String, `data`: ByteArray, `mediaInfo`: ImageInfo?)
    
    companion object
}

open class Room : FFIObject, RoomInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_room(ptr, status)
            }
        }
    }

    override fun `activeMembersCount`(): ULong =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_active_members_count(it,
        
        _status)
}
        }.let {
            FfiConverterULong.lift(it)
        }
    
    override fun `activeRoomCallParticipants`(): List<String> =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_active_room_call_participants(it,
        
        _status)
}
        }.let {
            FfiConverterSequenceString.lift(it)
        }
    
    override fun `alternativeAliases`(): List<String> =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_alternative_aliases(it,
        
        _status)
}
        }.let {
            FfiConverterSequenceString.lift(it)
        }
    
    override fun `avatarUrl`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_avatar_url(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserBan`(`userId`: String) : Boolean {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_ban(
                    thisPtr,
                    FfiConverterString.lower(`userId`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
            // lift function
            { FfiConverterBoolean.lift(it) },
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserInvite`(`userId`: String) : Boolean {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_invite(
                    thisPtr,
                    FfiConverterString.lower(`userId`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
            // lift function
            { FfiConverterBoolean.lift(it) },
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserKick`(`userId`: String) : Boolean {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_kick(
                    thisPtr,
                    FfiConverterString.lower(`userId`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
            // lift function
            { FfiConverterBoolean.lift(it) },
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserRedact`(`userId`: String) : Boolean {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_redact(
                    thisPtr,
                    FfiConverterString.lower(`userId`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
            // lift function
            { FfiConverterBoolean.lift(it) },
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserSendMessage`(`userId`: String, `message`: MessageLikeEventType) : Boolean {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_send_message(
                    thisPtr,
                    FfiConverterString.lower(`userId`),FfiConverterTypeMessageLikeEventType.lower(`message`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
            // lift function
            { FfiConverterBoolean.lift(it) },
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserSendState`(`userId`: String, `stateEvent`: StateEventType) : Boolean {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_send_state(
                    thisPtr,
                    FfiConverterString.lower(`userId`),FfiConverterTypeStateEventType.lower(`stateEvent`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
            // lift function
            { FfiConverterBoolean.lift(it) },
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserTriggerRoomNotification`(`userId`: String) : Boolean {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_trigger_room_notification(
                    thisPtr,
                    FfiConverterString.lower(`userId`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
            // lift function
            { FfiConverterBoolean.lift(it) },
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    override fun `canonicalAlias`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_canonical_alias(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `displayName`(): String =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_display_name(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `hasActiveRoomCall`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_has_active_room_call(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `id`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_id(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `ignoreUser`(`userId`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_ignore_user(it,
        FfiConverterString.lower(`userId`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `inviteUserById`(`userId`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_invite_user_by_id(it,
        FfiConverterString.lower(`userId`),
        _status)
}
        }
    
    
    override fun `invitedMembersCount`(): ULong =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_invited_members_count(it,
        
        _status)
}
        }.let {
            FfiConverterULong.lift(it)
        }
    
    override fun `inviter`(): RoomMember? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_inviter(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeRoomMember.lift(it)
        }
    
    override fun `isDirect`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_is_direct(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `isEncrypted`(): Boolean =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_is_encrypted(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isPublic`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_is_public(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isSpace`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_is_space(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isTombstoned`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_is_tombstoned(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `join`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_join(it,
        
        _status)
}
        }
    
    
    override fun `joinedMembersCount`(): ULong =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_joined_members_count(it,
        
        _status)
}
        }.let {
            FfiConverterULong.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `leave`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_leave(it,
        
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `member`(`userId`: String) : RoomMember {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_member(
                    thisPtr,
                    FfiConverterString.lower(`userId`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
            // lift function
            { FfiConverterTypeRoomMember.lift(it) },
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    
    @Throws(ClientException::class)override fun `memberAvatarUrl`(`userId`: String): String? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_member_avatar_url(it,
        FfiConverterString.lower(`userId`),
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `memberDisplayName`(`userId`: String): String? =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_member_display_name(it,
        FfiConverterString.lower(`userId`),
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `members`() : RoomMembersIterator {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_members(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
            // lift function
            { FfiConverterTypeRoomMembersIterator.lift(it) },
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    override fun `membership`(): Membership =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_membership(it,
        
        _status)
}
        }.let {
            FfiConverterTypeMembership.lift(it)
        }
    
    override fun `name`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_name(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    override fun `ownUserId`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_own_user_id(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `pollHistory`() : Timeline {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_poll_history(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
            // lift function
            { FfiConverterTypeTimeline.lift(it) },
            // Error FFI converter
            NullCallStatusErrorHandler,
        )
    }
    
    @Throws(ClientException::class)override fun `redact`(`eventId`: String, `reason`: String?) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_redact(it,
        FfiConverterString.lower(`eventId`),FfiConverterOptionalString.lower(`reason`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `removeAvatar`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_remove_avatar(it,
        
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `reportContent`(`eventId`: String, `score`: Int?, `reason`: String?) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_report_content(it,
        FfiConverterString.lower(`eventId`),FfiConverterOptionalInt.lower(`score`),FfiConverterOptionalString.lower(`reason`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `roomInfo`() : RoomInfo {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_room_info(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterTypeRoomInfo.lift(it) },
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    
    @Throws(ClientException::class)override fun `setName`(`name`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_set_name(it,
        FfiConverterString.lower(`name`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `setTopic`(`topic`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_set_topic(it,
        FfiConverterString.lower(`topic`),
        _status)
}
        }
    
    
    override fun `subscribeToRoomInfoUpdates`(`listener`: RoomInfoListener): TaskHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_subscribe_to_room_info_updates(it,
        FfiConverterTypeRoomInfoListener.lower(`listener`),
        _status)
}
        }.let {
            FfiConverterTypeTaskHandle.lift(it)
        }
    
    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `timeline`() : Timeline {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_timeline(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
            // lift function
            { FfiConverterTypeTimeline.lift(it) },
            // Error FFI converter
            NullCallStatusErrorHandler,
        )
    }
    override fun `topic`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_topic(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `typingNotice`(`isTyping`: Boolean) {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_typing_notice(
                    thisPtr,
                    FfiConverterBoolean.lower(`isTyping`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    
    @Throws(ClientException::class)override fun `uploadAvatar`(`mimeType`: String, `data`: ByteArray, `mediaInfo`: ImageInfo?) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_upload_avatar(it,
        FfiConverterString.lower(`mimeType`),FfiConverterByteArray.lower(`data`),FfiConverterOptionalTypeImageInfo.lower(`mediaInfo`),
        _status)
}
        }
    
    
    

    
    companion object
    
}

public object FfiConverterTypeRoom: FfiConverter<Room, Pointer> {

    override fun lower(value: Room): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): Room {
        return Room(value)
    }

    override fun read(buf: ByteBuffer): Room {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Room) = 8

    override fun write(value: Room, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface RoomListInterface {
    fun `entries`(`listener`: RoomListEntriesListener): RoomListEntriesResult
    fun `entriesWithDynamicAdapters`(`pageSize`: UInt, `listener`: RoomListEntriesListener): RoomListEntriesWithDynamicAdaptersResult
    fun `loadingState`(`listener`: RoomListLoadingStateListener): RoomListLoadingStateResult
    fun `room`(`roomId`: String): RoomListItem
    
    companion object
}

open class RoomList : FFIObject, RoomListInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_roomlist(ptr, status)
            }
        }
    }

    override fun `entries`(`listener`: RoomListEntriesListener): RoomListEntriesResult =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlist_entries(it,
        FfiConverterTypeRoomListEntriesListener.lower(`listener`),
        _status)
}
        }.let {
            FfiConverterTypeRoomListEntriesResult.lift(it)
        }
    
    override fun `entriesWithDynamicAdapters`(`pageSize`: UInt, `listener`: RoomListEntriesListener): RoomListEntriesWithDynamicAdaptersResult =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlist_entries_with_dynamic_adapters(it,
        FfiConverterUInt.lower(`pageSize`),FfiConverterTypeRoomListEntriesListener.lower(`listener`),
        _status)
}
        }.let {
            FfiConverterTypeRoomListEntriesWithDynamicAdaptersResult.lift(it)
        }
    
    
    @Throws(RoomListException::class)override fun `loadingState`(`listener`: RoomListLoadingStateListener): RoomListLoadingStateResult =
        callWithPointer {
    rustCallWithError(RoomListException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlist_loading_state(it,
        FfiConverterTypeRoomListLoadingStateListener.lower(`listener`),
        _status)
}
        }.let {
            FfiConverterTypeRoomListLoadingStateResult.lift(it)
        }
    
    
    @Throws(RoomListException::class)override fun `room`(`roomId`: String): RoomListItem =
        callWithPointer {
    rustCallWithError(RoomListException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlist_room(it,
        FfiConverterString.lower(`roomId`),
        _status)
}
        }.let {
            FfiConverterTypeRoomListItem.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeRoomList: FfiConverter<RoomList, Pointer> {

    override fun lower(value: RoomList): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): RoomList {
        return RoomList(value)
    }

    override fun read(buf: ByteBuffer): RoomList {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomList) = 8

    override fun write(value: RoomList, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface RoomListDynamicEntriesControllerInterface {
    fun `addOnePage`()
    fun `resetToOnePage`()
    fun `setFilter`(`kind`: RoomListEntriesDynamicFilterKind): Boolean
    
    companion object
}

open class RoomListDynamicEntriesController : FFIObject, RoomListDynamicEntriesControllerInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_roomlistdynamicentriescontroller(ptr, status)
            }
        }
    }

    override fun `addOnePage`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistdynamicentriescontroller_add_one_page(it,
        
        _status)
}
        }
    
    
    override fun `resetToOnePage`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistdynamicentriescontroller_reset_to_one_page(it,
        
        _status)
}
        }
    
    
    override fun `setFilter`(`kind`: RoomListEntriesDynamicFilterKind): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistdynamicentriescontroller_set_filter(it,
        FfiConverterTypeRoomListEntriesDynamicFilterKind.lower(`kind`),
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeRoomListDynamicEntriesController: FfiConverter<RoomListDynamicEntriesController, Pointer> {

    override fun lower(value: RoomListDynamicEntriesController): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): RoomListDynamicEntriesController {
        return RoomListDynamicEntriesController(value)
    }

    override fun read(buf: ByteBuffer): RoomListDynamicEntriesController {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomListDynamicEntriesController) = 8

    override fun write(value: RoomListDynamicEntriesController, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface RoomListItemInterface {
    fun `avatarUrl`(): String?
    fun `canonicalAlias`(): String?
    suspend fun `fullRoom`(): Room
    fun `fullRoomBlocking`(): Room
    fun `hasUnreadNotifications`(): Boolean
    fun `id`(): String
    fun `isDirect`(): Boolean
    suspend fun `latestEvent`(): EventTimelineItem?
    fun `name`(): String?
    suspend fun `roomInfo`(): RoomInfo
    fun `subscribe`(`settings`: RoomSubscription?)
    fun `unreadNotifications`(): UnreadNotificationsCount
    fun `unsubscribe`()
    
    companion object
}

open class RoomListItem : FFIObject, RoomListItemInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_roomlistitem(ptr, status)
            }
        }
    }

    override fun `avatarUrl`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_avatar_url(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    override fun `canonicalAlias`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_canonical_alias(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `fullRoom`() : Room {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_full_room(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
            // lift function
            { FfiConverterTypeRoom.lift(it) },
            // Error FFI converter
            NullCallStatusErrorHandler,
        )
    }
    override fun `fullRoomBlocking`(): Room =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_full_room_blocking(it,
        
        _status)
}
        }.let {
            FfiConverterTypeRoom.lift(it)
        }
    
    override fun `hasUnreadNotifications`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_has_unread_notifications(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `id`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_id(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `isDirect`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_is_direct(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `latestEvent`() : EventTimelineItem? {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_latest_event(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterOptionalTypeEventTimelineItem.lift(it) },
            // Error FFI converter
            NullCallStatusErrorHandler,
        )
    }
    override fun `name`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_name(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `roomInfo`() : RoomInfo {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_room_info(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterTypeRoomInfo.lift(it) },
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    override fun `subscribe`(`settings`: RoomSubscription?) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_subscribe(it,
        FfiConverterOptionalTypeRoomSubscription.lower(`settings`),
        _status)
}
        }
    
    
    override fun `unreadNotifications`(): UnreadNotificationsCount =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_unread_notifications(it,
        
        _status)
}
        }.let {
            FfiConverterTypeUnreadNotificationsCount.lift(it)
        }
    
    override fun `unsubscribe`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_unsubscribe(it,
        
        _status)
}
        }
    
    
    

    
    companion object
    
}

public object FfiConverterTypeRoomListItem: FfiConverter<RoomListItem, Pointer> {

    override fun lower(value: RoomListItem): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): RoomListItem {
        return RoomListItem(value)
    }

    override fun read(buf: ByteBuffer): RoomListItem {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomListItem) = 8

    override fun write(value: RoomListItem, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface RoomListServiceInterface {
    suspend fun `allRooms`(): RoomList
    suspend fun `applyInput`(`input`: RoomListInput)
    suspend fun `invites`(): RoomList
    fun `room`(`roomId`: String): RoomListItem
    fun `state`(`listener`: RoomListServiceStateListener): TaskHandle
    fun `syncIndicator`(`delayBeforeShowingInMs`: UInt, `delayBeforeHidingInMs`: UInt, `listener`: RoomListServiceSyncIndicatorListener): TaskHandle
    
    companion object
}

open class RoomListService : FFIObject, RoomListServiceInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_roomlistservice(ptr, status)
            }
        }
    }

    
    @Throws(RoomListException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `allRooms`() : RoomList {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistservice_all_rooms(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
            // lift function
            { FfiConverterTypeRoomList.lift(it) },
            // Error FFI converter
            RoomListException.ErrorHandler,
        )
    }
    
    @Throws(RoomListException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `applyInput`(`input`: RoomListInput) {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistservice_apply_input(
                    thisPtr,
                    FfiConverterTypeRoomListInput.lower(`input`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            RoomListException.ErrorHandler,
        )
    }
    
    @Throws(RoomListException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `invites`() : RoomList {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistservice_invites(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
            // lift function
            { FfiConverterTypeRoomList.lift(it) },
            // Error FFI converter
            RoomListException.ErrorHandler,
        )
    }
    
    @Throws(RoomListException::class)override fun `room`(`roomId`: String): RoomListItem =
        callWithPointer {
    rustCallWithError(RoomListException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistservice_room(it,
        FfiConverterString.lower(`roomId`),
        _status)
}
        }.let {
            FfiConverterTypeRoomListItem.lift(it)
        }
    
    override fun `state`(`listener`: RoomListServiceStateListener): TaskHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistservice_state(it,
        FfiConverterTypeRoomListServiceStateListener.lower(`listener`),
        _status)
}
        }.let {
            FfiConverterTypeTaskHandle.lift(it)
        }
    
    override fun `syncIndicator`(`delayBeforeShowingInMs`: UInt, `delayBeforeHidingInMs`: UInt, `listener`: RoomListServiceSyncIndicatorListener): TaskHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistservice_sync_indicator(it,
        FfiConverterUInt.lower(`delayBeforeShowingInMs`),FfiConverterUInt.lower(`delayBeforeHidingInMs`),FfiConverterTypeRoomListServiceSyncIndicatorListener.lower(`listener`),
        _status)
}
        }.let {
            FfiConverterTypeTaskHandle.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeRoomListService: FfiConverter<RoomListService, Pointer> {

    override fun lower(value: RoomListService): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): RoomListService {
        return RoomListService(value)
    }

    override fun read(buf: ByteBuffer): RoomListService {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomListService) = 8

    override fun write(value: RoomListService, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface RoomMemberInterface {
    fun `avatarUrl`(): String?
    fun `canBan`(): Boolean
    fun `canInvite`(): Boolean
    fun `canKick`(): Boolean
    fun `canRedact`(): Boolean
    fun `canSendMessage`(`event`: MessageLikeEventType): Boolean
    fun `canSendState`(`stateEvent`: StateEventType): Boolean
    fun `canTriggerRoomNotification`(): Boolean
    fun `displayName`(): String?
    fun `ignore`()
    fun `isAccountUser`(): Boolean
    fun `isIgnored`(): Boolean
    fun `isNameAmbiguous`(): Boolean
    fun `membership`(): MembershipState
    fun `normalizedPowerLevel`(): Long
    fun `powerLevel`(): Long
    fun `unignore`()
    fun `userId`(): String
    
    companion object
}

open class RoomMember : FFIObject, RoomMemberInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_roommember(ptr, status)
            }
        }
    }

    override fun `avatarUrl`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_avatar_url(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    override fun `canBan`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_can_ban(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `canInvite`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_can_invite(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `canKick`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_can_kick(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `canRedact`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_can_redact(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `canSendMessage`(`event`: MessageLikeEventType): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_can_send_message(it,
        FfiConverterTypeMessageLikeEventType.lower(`event`),
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `canSendState`(`stateEvent`: StateEventType): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_can_send_state(it,
        FfiConverterTypeStateEventType.lower(`stateEvent`),
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `canTriggerRoomNotification`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_can_trigger_room_notification(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `displayName`(): String? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_display_name(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `ignore`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_ignore(it,
        
        _status)
}
        }
    
    
    override fun `isAccountUser`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_is_account_user(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isIgnored`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_is_ignored(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `isNameAmbiguous`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_is_name_ambiguous(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `membership`(): MembershipState =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_membership(it,
        
        _status)
}
        }.let {
            FfiConverterTypeMembershipState.lift(it)
        }
    
    override fun `normalizedPowerLevel`(): Long =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_normalized_power_level(it,
        
        _status)
}
        }.let {
            FfiConverterLong.lift(it)
        }
    
    override fun `powerLevel`(): Long =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_power_level(it,
        
        _status)
}
        }.let {
            FfiConverterLong.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `unignore`() =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_unignore(it,
        
        _status)
}
        }
    
    
    override fun `userId`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommember_user_id(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeRoomMember: FfiConverter<RoomMember, Pointer> {

    override fun lower(value: RoomMember): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): RoomMember {
        return RoomMember(value)
    }

    override fun read(buf: ByteBuffer): RoomMember {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomMember) = 8

    override fun write(value: RoomMember, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface RoomMembersIteratorInterface {
    fun `len`(): UInt
    fun `nextChunk`(`chunkSize`: UInt): List<RoomMember>?
    
    companion object
}

open class RoomMembersIterator : FFIObject, RoomMembersIteratorInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_roommembersiterator(ptr, status)
            }
        }
    }

    override fun `len`(): UInt =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommembersiterator_len(it,
        
        _status)
}
        }.let {
            FfiConverterUInt.lift(it)
        }
    
    override fun `nextChunk`(`chunkSize`: UInt): List<RoomMember>? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommembersiterator_next_chunk(it,
        FfiConverterUInt.lower(`chunkSize`),
        _status)
}
        }.let {
            FfiConverterOptionalSequenceTypeRoomMember.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeRoomMembersIterator: FfiConverter<RoomMembersIterator, Pointer> {

    override fun lower(value: RoomMembersIterator): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): RoomMembersIterator {
        return RoomMembersIterator(value)
    }

    override fun read(buf: ByteBuffer): RoomMembersIterator {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomMembersIterator) = 8

    override fun write(value: RoomMembersIterator, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface RoomMessageEventContentWithoutRelationInterface {
    fun `withMentions`(`mentions`: Mentions): RoomMessageEventContentWithoutRelation
    
    companion object
}

open class RoomMessageEventContentWithoutRelation : FFIObject, RoomMessageEventContentWithoutRelationInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_roommessageeventcontentwithoutrelation(ptr, status)
            }
        }
    }

    override fun `withMentions`(`mentions`: Mentions): RoomMessageEventContentWithoutRelation =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommessageeventcontentwithoutrelation_with_mentions(it,
        FfiConverterTypeMentions.lower(`mentions`),
        _status)
}
        }.let {
            FfiConverterTypeRoomMessageEventContentWithoutRelation.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeRoomMessageEventContentWithoutRelation: FfiConverter<RoomMessageEventContentWithoutRelation, Pointer> {

    override fun lower(value: RoomMessageEventContentWithoutRelation): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): RoomMessageEventContentWithoutRelation {
        return RoomMessageEventContentWithoutRelation(value)
    }

    override fun read(buf: ByteBuffer): RoomMessageEventContentWithoutRelation {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomMessageEventContentWithoutRelation) = 8

    override fun write(value: RoomMessageEventContentWithoutRelation, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface SendAttachmentJoinHandleInterface {
    fun `cancel`()
    suspend fun `join`()
    
    companion object
}

open class SendAttachmentJoinHandle : FFIObject, SendAttachmentJoinHandleInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_sendattachmentjoinhandle(ptr, status)
            }
        }
    }

    override fun `cancel`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sendattachmentjoinhandle_cancel(it,
        
        _status)
}
        }
    
    
    
    @Throws(RoomException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `join`() {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sendattachmentjoinhandle_join(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            RoomException.ErrorHandler,
        )
    }
    

    
    companion object
    
}

public object FfiConverterTypeSendAttachmentJoinHandle: FfiConverter<SendAttachmentJoinHandle, Pointer> {

    override fun lower(value: SendAttachmentJoinHandle): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): SendAttachmentJoinHandle {
        return SendAttachmentJoinHandle(value)
    }

    override fun read(buf: ByteBuffer): SendAttachmentJoinHandle {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SendAttachmentJoinHandle) = 8

    override fun write(value: SendAttachmentJoinHandle, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface SessionVerificationControllerInterface {
    suspend fun `approveVerification`()
    suspend fun `cancelVerification`()
    suspend fun `declineVerification`()
    suspend fun `isVerified`(): Boolean
    suspend fun `requestVerification`()
    fun `setDelegate`(`delegate`: SessionVerificationControllerDelegate?)
    suspend fun `startSasVerification`()
    
    companion object
}

open class SessionVerificationController : FFIObject, SessionVerificationControllerInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_sessionverificationcontroller(ptr, status)
            }
        }
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `approveVerification`() {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_approve_verification(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `cancelVerification`() {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_cancel_verification(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `declineVerification`() {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_decline_verification(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `isVerified`() : Boolean {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_is_verified(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
            // lift function
            { FfiConverterBoolean.lift(it) },
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `requestVerification`() {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_request_verification(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    override fun `setDelegate`(`delegate`: SessionVerificationControllerDelegate?) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_set_delegate(it,
        FfiConverterOptionalTypeSessionVerificationControllerDelegate.lower(`delegate`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `startSasVerification`() {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_start_sas_verification(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    

    
    companion object
    
}

public object FfiConverterTypeSessionVerificationController: FfiConverter<SessionVerificationController, Pointer> {

    override fun lower(value: SessionVerificationController): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): SessionVerificationController {
        return SessionVerificationController(value)
    }

    override fun read(buf: ByteBuffer): SessionVerificationController {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SessionVerificationController) = 8

    override fun write(value: SessionVerificationController, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface SessionVerificationEmojiInterface {
    fun `description`(): String
    fun `symbol`(): String
    
    companion object
}

open class SessionVerificationEmoji : FFIObject, SessionVerificationEmojiInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_sessionverificationemoji(ptr, status)
            }
        }
    }

    override fun `description`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationemoji_description(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `symbol`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationemoji_symbol(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeSessionVerificationEmoji: FfiConverter<SessionVerificationEmoji, Pointer> {

    override fun lower(value: SessionVerificationEmoji): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): SessionVerificationEmoji {
        return SessionVerificationEmoji(value)
    }

    override fun read(buf: ByteBuffer): SessionVerificationEmoji {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SessionVerificationEmoji) = 8

    override fun write(value: SessionVerificationEmoji, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface SpanInterface {
    fun `enter`()
    fun `exit`()
    fun `isNone`(): Boolean
    
    companion object
}

open class Span : FFIObject, SpanInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)
    constructor(`file`: String, `line`: UInt?, `level`: LogLevel, `target`: String, `name`: String) :
        this(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_constructor_span_new(FfiConverterString.lower(`file`),FfiConverterOptionalUInt.lower(`line`),FfiConverterTypeLogLevel.lower(`level`),FfiConverterString.lower(`target`),FfiConverterString.lower(`name`),_status)
})

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_span(ptr, status)
            }
        }
    }

    override fun `enter`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_span_enter(it,
        
        _status)
}
        }
    
    
    override fun `exit`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_span_exit(it,
        
        _status)
}
        }
    
    
    override fun `isNone`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_span_is_none(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    

    companion object {
        fun `current`(): Span =
            Span(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_constructor_span_current(_status)
})
        
    }
    
}

public object FfiConverterTypeSpan: FfiConverter<Span, Pointer> {

    override fun lower(value: Span): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): Span {
        return Span(value)
    }

    override fun read(buf: ByteBuffer): Span {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Span) = 8

    override fun write(value: Span, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface SyncServiceInterface {
    fun `roomListService`(): RoomListService
    suspend fun `start`()
    fun `state`(`listener`: SyncServiceStateObserver): TaskHandle
    suspend fun `stop`()
    
    companion object
}

open class SyncService : FFIObject, SyncServiceInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_syncservice(ptr, status)
            }
        }
    }

    override fun `roomListService`(): RoomListService =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_syncservice_room_list_service(it,
        
        _status)
}
        }.let {
            FfiConverterTypeRoomListService.lift(it)
        }
    
    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `start`() {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_syncservice_start(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            NullCallStatusErrorHandler,
        )
    }
    override fun `state`(`listener`: SyncServiceStateObserver): TaskHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_syncservice_state(it,
        FfiConverterTypeSyncServiceStateObserver.lower(`listener`),
        _status)
}
        }.let {
            FfiConverterTypeTaskHandle.lift(it)
        }
    
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `stop`() {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_syncservice_stop(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    

    
    companion object
    
}

public object FfiConverterTypeSyncService: FfiConverter<SyncService, Pointer> {

    override fun lower(value: SyncService): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): SyncService {
        return SyncService(value)
    }

    override fun read(buf: ByteBuffer): SyncService {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SyncService) = 8

    override fun write(value: SyncService, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface SyncServiceBuilderInterface {
    suspend fun `finish`(): SyncService
    fun `withCrossProcessLock`(`appIdentifier`: String?): SyncServiceBuilder
    
    companion object
}

open class SyncServiceBuilder : FFIObject, SyncServiceBuilderInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_syncservicebuilder(ptr, status)
            }
        }
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `finish`() : SyncService {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_syncservicebuilder_finish(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
            // lift function
            { FfiConverterTypeSyncService.lift(it) },
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    override fun `withCrossProcessLock`(`appIdentifier`: String?): SyncServiceBuilder =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_syncservicebuilder_with_cross_process_lock(it,
        FfiConverterOptionalString.lower(`appIdentifier`),
        _status)
}
        }.let {
            FfiConverterTypeSyncServiceBuilder.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeSyncServiceBuilder: FfiConverter<SyncServiceBuilder, Pointer> {

    override fun lower(value: SyncServiceBuilder): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): SyncServiceBuilder {
        return SyncServiceBuilder(value)
    }

    override fun read(buf: ByteBuffer): SyncServiceBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SyncServiceBuilder) = 8

    override fun write(value: SyncServiceBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface TaskHandleInterface {
    fun `cancel`()
    fun `isFinished`(): Boolean
    
    companion object
}

open class TaskHandle : FFIObject, TaskHandleInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_taskhandle(ptr, status)
            }
        }
    }

    override fun `cancel`() =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_taskhandle_cancel(it,
        
        _status)
}
        }
    
    
    override fun `isFinished`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_taskhandle_is_finished(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeTaskHandle: FfiConverter<TaskHandle, Pointer> {

    override fun lower(value: TaskHandle): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): TaskHandle {
        return TaskHandle(value)
    }

    override fun read(buf: ByteBuffer): TaskHandle {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: TaskHandle) = 8

    override fun write(value: TaskHandle, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface TimelineInterface {
    suspend fun `addListener`(`listener`: TimelineListener): RoomTimelineListenerResult
    fun `cancelSend`(`txnId`: String)
    fun `createPoll`(`question`: String, `answers`: List<String>, `maxSelections`: UByte, `pollKind`: PollKind)
    fun `edit`(`newContent`: RoomMessageEventContentWithoutRelation, `editItem`: EventTimelineItem)
    suspend fun `editPoll`(`question`: String, `answers`: List<String>, `maxSelections`: UByte, `pollKind`: PollKind, `editItem`: EventTimelineItem)
    fun `endPoll`(`pollStartId`: String, `text`: String)
    fun `fetchDetailsForEvent`(`eventId`: String)
    suspend fun `fetchMembers`()
    fun `getEventTimelineItemByEventId`(`eventId`: String): EventTimelineItem
    fun `getTimelineEventContentByEventId`(`eventId`: String): RoomMessageEventContentWithoutRelation
    fun `paginateBackwards`(`opts`: PaginationOptions)
    fun `retryDecryption`(`sessionIds`: List<String>)
    fun `retrySend`(`txnId`: String)
    fun `send`(`msg`: RoomMessageEventContentWithoutRelation)
    fun `sendAudio`(`url`: String, `audioInfo`: AudioInfo, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle
    fun `sendFile`(`url`: String, `fileInfo`: FileInfo, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle
    fun `sendImage`(`url`: String, `thumbnailUrl`: String, `imageInfo`: ImageInfo, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle
    fun `sendLocation`(`body`: String, `geoUri`: String, `description`: String?, `zoomLevel`: UByte?, `assetType`: AssetType?)
    fun `sendPollResponse`(`pollStartId`: String, `answers`: List<String>)
    fun `sendReadReceipt`(`eventId`: String)
    fun `sendReply`(`msg`: RoomMessageEventContentWithoutRelation, `replyItem`: EventTimelineItem)
    fun `sendVideo`(`url`: String, `thumbnailUrl`: String, `videoInfo`: VideoInfo, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle
    fun `sendVoiceMessage`(`url`: String, `audioInfo`: AudioInfo, `waveform`: List<UShort>, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle
    fun `subscribeToBackPaginationStatus`(`listener`: BackPaginationStatusListener): TaskHandle
    fun `toggleReaction`(`eventId`: String, `key`: String)
    
    companion object
}

open class Timeline : FFIObject, TimelineInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_timeline(ptr, status)
            }
        }
    }

    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `addListener`(`listener`: TimelineListener) : RoomTimelineListenerResult {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_add_listener(
                    thisPtr,
                    FfiConverterTypeTimelineListener.lower(`listener`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterTypeRoomTimelineListenerResult.lift(it) },
            // Error FFI converter
            NullCallStatusErrorHandler,
        )
    }
    override fun `cancelSend`(`txnId`: String) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_cancel_send(it,
        FfiConverterString.lower(`txnId`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `createPoll`(`question`: String, `answers`: List<String>, `maxSelections`: UByte, `pollKind`: PollKind) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_create_poll(it,
        FfiConverterString.lower(`question`),FfiConverterSequenceString.lower(`answers`),FfiConverterUByte.lower(`maxSelections`),FfiConverterTypePollKind.lower(`pollKind`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `edit`(`newContent`: RoomMessageEventContentWithoutRelation, `editItem`: EventTimelineItem) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_edit(it,
        FfiConverterTypeRoomMessageEventContentWithoutRelation.lower(`newContent`),FfiConverterTypeEventTimelineItem.lower(`editItem`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `editPoll`(`question`: String, `answers`: List<String>, `maxSelections`: UByte, `pollKind`: PollKind, `editItem`: EventTimelineItem) {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_edit_poll(
                    thisPtr,
                    FfiConverterString.lower(`question`),FfiConverterSequenceString.lower(`answers`),FfiConverterUByte.lower(`maxSelections`),FfiConverterTypePollKind.lower(`pollKind`),FfiConverterTypeEventTimelineItem.lower(`editItem`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            ClientException.ErrorHandler,
        )
    }
    
    @Throws(ClientException::class)override fun `endPoll`(`pollStartId`: String, `text`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_end_poll(it,
        FfiConverterString.lower(`pollStartId`),FfiConverterString.lower(`text`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `fetchDetailsForEvent`(`eventId`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_fetch_details_for_event(it,
        FfiConverterString.lower(`eventId`),
        _status)
}
        }
    
    
    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `fetchMembers`() {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_fetch_members(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            NullCallStatusErrorHandler,
        )
    }
    
    @Throws(ClientException::class)override fun `getEventTimelineItemByEventId`(`eventId`: String): EventTimelineItem =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_get_event_timeline_item_by_event_id(it,
        FfiConverterString.lower(`eventId`),
        _status)
}
        }.let {
            FfiConverterTypeEventTimelineItem.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `getTimelineEventContentByEventId`(`eventId`: String): RoomMessageEventContentWithoutRelation =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_get_timeline_event_content_by_event_id(it,
        FfiConverterString.lower(`eventId`),
        _status)
}
        }.let {
            FfiConverterTypeRoomMessageEventContentWithoutRelation.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `paginateBackwards`(`opts`: PaginationOptions) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_paginate_backwards(it,
        FfiConverterTypePaginationOptions.lower(`opts`),
        _status)
}
        }
    
    
    override fun `retryDecryption`(`sessionIds`: List<String>) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_retry_decryption(it,
        FfiConverterSequenceString.lower(`sessionIds`),
        _status)
}
        }
    
    
    override fun `retrySend`(`txnId`: String) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_retry_send(it,
        FfiConverterString.lower(`txnId`),
        _status)
}
        }
    
    
    override fun `send`(`msg`: RoomMessageEventContentWithoutRelation) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_send(it,
        FfiConverterTypeRoomMessageEventContentWithoutRelation.lower(`msg`),
        _status)
}
        }
    
    
    override fun `sendAudio`(`url`: String, `audioInfo`: AudioInfo, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_send_audio(it,
        FfiConverterString.lower(`url`),FfiConverterTypeAudioInfo.lower(`audioInfo`),FfiConverterOptionalTypeProgressWatcher.lower(`progressWatcher`),
        _status)
}
        }.let {
            FfiConverterTypeSendAttachmentJoinHandle.lift(it)
        }
    
    override fun `sendFile`(`url`: String, `fileInfo`: FileInfo, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_send_file(it,
        FfiConverterString.lower(`url`),FfiConverterTypeFileInfo.lower(`fileInfo`),FfiConverterOptionalTypeProgressWatcher.lower(`progressWatcher`),
        _status)
}
        }.let {
            FfiConverterTypeSendAttachmentJoinHandle.lift(it)
        }
    
    override fun `sendImage`(`url`: String, `thumbnailUrl`: String, `imageInfo`: ImageInfo, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_send_image(it,
        FfiConverterString.lower(`url`),FfiConverterString.lower(`thumbnailUrl`),FfiConverterTypeImageInfo.lower(`imageInfo`),FfiConverterOptionalTypeProgressWatcher.lower(`progressWatcher`),
        _status)
}
        }.let {
            FfiConverterTypeSendAttachmentJoinHandle.lift(it)
        }
    
    override fun `sendLocation`(`body`: String, `geoUri`: String, `description`: String?, `zoomLevel`: UByte?, `assetType`: AssetType?) =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_send_location(it,
        FfiConverterString.lower(`body`),FfiConverterString.lower(`geoUri`),FfiConverterOptionalString.lower(`description`),FfiConverterOptionalUByte.lower(`zoomLevel`),FfiConverterOptionalTypeAssetType.lower(`assetType`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `sendPollResponse`(`pollStartId`: String, `answers`: List<String>) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_send_poll_response(it,
        FfiConverterString.lower(`pollStartId`),FfiConverterSequenceString.lower(`answers`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `sendReadReceipt`(`eventId`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_send_read_receipt(it,
        FfiConverterString.lower(`eventId`),
        _status)
}
        }
    
    
    
    @Throws(ClientException::class)override fun `sendReply`(`msg`: RoomMessageEventContentWithoutRelation, `replyItem`: EventTimelineItem) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_send_reply(it,
        FfiConverterTypeRoomMessageEventContentWithoutRelation.lower(`msg`),FfiConverterTypeEventTimelineItem.lower(`replyItem`),
        _status)
}
        }
    
    
    override fun `sendVideo`(`url`: String, `thumbnailUrl`: String, `videoInfo`: VideoInfo, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_send_video(it,
        FfiConverterString.lower(`url`),FfiConverterString.lower(`thumbnailUrl`),FfiConverterTypeVideoInfo.lower(`videoInfo`),FfiConverterOptionalTypeProgressWatcher.lower(`progressWatcher`),
        _status)
}
        }.let {
            FfiConverterTypeSendAttachmentJoinHandle.lift(it)
        }
    
    override fun `sendVoiceMessage`(`url`: String, `audioInfo`: AudioInfo, `waveform`: List<UShort>, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_send_voice_message(it,
        FfiConverterString.lower(`url`),FfiConverterTypeAudioInfo.lower(`audioInfo`),FfiConverterSequenceUShort.lower(`waveform`),FfiConverterOptionalTypeProgressWatcher.lower(`progressWatcher`),
        _status)
}
        }.let {
            FfiConverterTypeSendAttachmentJoinHandle.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `subscribeToBackPaginationStatus`(`listener`: BackPaginationStatusListener): TaskHandle =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_subscribe_to_back_pagination_status(it,
        FfiConverterTypeBackPaginationStatusListener.lower(`listener`),
        _status)
}
        }.let {
            FfiConverterTypeTaskHandle.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `toggleReaction`(`eventId`: String, `key`: String) =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_toggle_reaction(it,
        FfiConverterString.lower(`eventId`),FfiConverterString.lower(`key`),
        _status)
}
        }
    
    
    

    
    companion object
    
}

public object FfiConverterTypeTimeline: FfiConverter<Timeline, Pointer> {

    override fun lower(value: Timeline): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): Timeline {
        return Timeline(value)
    }

    override fun read(buf: ByteBuffer): Timeline {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Timeline) = 8

    override fun write(value: Timeline, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface TimelineDiffInterface {
    fun `append`(): List<TimelineItem>?
    fun `change`(): TimelineChange
    fun `insert`(): InsertData?
    fun `pushBack`(): TimelineItem?
    fun `pushFront`(): TimelineItem?
    fun `remove`(): UInt?
    fun `reset`(): List<TimelineItem>?
    fun `set`(): SetData?
    
    companion object
}

open class TimelineDiff : FFIObject, TimelineDiffInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_timelinediff(ptr, status)
            }
        }
    }

    override fun `append`(): List<TimelineItem>? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_append(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalSequenceTypeTimelineItem.lift(it)
        }
    
    override fun `change`(): TimelineChange =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_change(it,
        
        _status)
}
        }.let {
            FfiConverterTypeTimelineChange.lift(it)
        }
    
    override fun `insert`(): InsertData? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_insert(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeInsertData.lift(it)
        }
    
    override fun `pushBack`(): TimelineItem? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_push_back(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeTimelineItem.lift(it)
        }
    
    override fun `pushFront`(): TimelineItem? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_push_front(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeTimelineItem.lift(it)
        }
    
    override fun `remove`(): UInt? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_remove(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalUInt.lift(it)
        }
    
    override fun `reset`(): List<TimelineItem>? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_reset(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalSequenceTypeTimelineItem.lift(it)
        }
    
    override fun `set`(): SetData? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_set(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeSetData.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeTimelineDiff: FfiConverter<TimelineDiff, Pointer> {

    override fun lower(value: TimelineDiff): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): TimelineDiff {
        return TimelineDiff(value)
    }

    override fun read(buf: ByteBuffer): TimelineDiff {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: TimelineDiff) = 8

    override fun write(value: TimelineDiff, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface TimelineEventInterface {
    fun `eventId`(): String
    fun `eventType`(): TimelineEventType
    fun `senderId`(): String
    fun `timestamp`(): ULong
    
    companion object
}

open class TimelineEvent : FFIObject, TimelineEventInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_timelineevent(ptr, status)
            }
        }
    }

    override fun `eventId`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineevent_event_id(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    
    @Throws(ClientException::class)override fun `eventType`(): TimelineEventType =
        callWithPointer {
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineevent_event_type(it,
        
        _status)
}
        }.let {
            FfiConverterTypeTimelineEventType.lift(it)
        }
    
    override fun `senderId`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineevent_sender_id(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `timestamp`(): ULong =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineevent_timestamp(it,
        
        _status)
}
        }.let {
            FfiConverterULong.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeTimelineEvent: FfiConverter<TimelineEvent, Pointer> {

    override fun lower(value: TimelineEvent): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): TimelineEvent {
        return TimelineEvent(value)
    }

    override fun read(buf: ByteBuffer): TimelineEvent {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: TimelineEvent) = 8

    override fun write(value: TimelineEvent, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface TimelineItemInterface {
    fun `asEvent`(): EventTimelineItem?
    fun `asVirtual`(): VirtualTimelineItem?
    fun `fmtDebug`(): String
    fun `uniqueId`(): ULong
    
    companion object
}

open class TimelineItem : FFIObject, TimelineItemInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_timelineitem(ptr, status)
            }
        }
    }

    override fun `asEvent`(): EventTimelineItem? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineitem_as_event(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeEventTimelineItem.lift(it)
        }
    
    override fun `asVirtual`(): VirtualTimelineItem? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineitem_as_virtual(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeVirtualTimelineItem.lift(it)
        }
    
    override fun `fmtDebug`(): String =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineitem_fmt_debug(it,
        
        _status)
}
        }.let {
            FfiConverterString.lift(it)
        }
    
    override fun `uniqueId`(): ULong =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineitem_unique_id(it,
        
        _status)
}
        }.let {
            FfiConverterULong.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeTimelineItem: FfiConverter<TimelineItem, Pointer> {

    override fun lower(value: TimelineItem): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): TimelineItem {
        return TimelineItem(value)
    }

    override fun read(buf: ByteBuffer): TimelineItem {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: TimelineItem) = 8

    override fun write(value: TimelineItem, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface TimelineItemContentInterface {
    fun `asMessage`(): Message?
    fun `kind`(): TimelineItemContentKind
    
    companion object
}

open class TimelineItemContent : FFIObject, TimelineItemContentInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_timelineitemcontent(ptr, status)
            }
        }
    }

    override fun `asMessage`(): Message? =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineitemcontent_as_message(it,
        
        _status)
}
        }.let {
            FfiConverterOptionalTypeMessage.lift(it)
        }
    
    override fun `kind`(): TimelineItemContentKind =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineitemcontent_kind(it,
        
        _status)
}
        }.let {
            FfiConverterTypeTimelineItemContentKind.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeTimelineItemContent: FfiConverter<TimelineItemContent, Pointer> {

    override fun lower(value: TimelineItemContent): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): TimelineItemContent {
        return TimelineItemContent(value)
    }

    override fun read(buf: ByteBuffer): TimelineItemContent {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: TimelineItemContent) = 8

    override fun write(value: TimelineItemContent, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface UnreadNotificationsCountInterface {
    fun `hasNotifications`(): Boolean
    fun `highlightCount`(): UInt
    fun `notificationCount`(): UInt
    
    companion object
}

open class UnreadNotificationsCount : FFIObject, UnreadNotificationsCountInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_unreadnotificationscount(ptr, status)
            }
        }
    }

    override fun `hasNotifications`(): Boolean =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_unreadnotificationscount_has_notifications(it,
        
        _status)
}
        }.let {
            FfiConverterBoolean.lift(it)
        }
    
    override fun `highlightCount`(): UInt =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_unreadnotificationscount_highlight_count(it,
        
        _status)
}
        }.let {
            FfiConverterUInt.lift(it)
        }
    
    override fun `notificationCount`(): UInt =
        callWithPointer {
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_unreadnotificationscount_notification_count(it,
        
        _status)
}
        }.let {
            FfiConverterUInt.lift(it)
        }
    
    

    
    companion object
    
}

public object FfiConverterTypeUnreadNotificationsCount: FfiConverter<UnreadNotificationsCount, Pointer> {

    override fun lower(value: UnreadNotificationsCount): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): UnreadNotificationsCount {
        return UnreadNotificationsCount(value)
    }

    override fun read(buf: ByteBuffer): UnreadNotificationsCount {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: UnreadNotificationsCount) = 8

    override fun write(value: UnreadNotificationsCount, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface WidgetDriverInterface {
    suspend fun `run`(`room`: Room, `capabilitiesProvider`: WidgetCapabilitiesProvider)
    
    companion object
}

open class WidgetDriver : FFIObject, WidgetDriverInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_widgetdriver(ptr, status)
            }
        }
    }

    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `run`(`room`: Room, `capabilitiesProvider`: WidgetCapabilitiesProvider) {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_widgetdriver_run(
                    thisPtr,
                    FfiConverterTypeRoom.lower(`room`),FfiConverterTypeWidgetCapabilitiesProvider.lower(`capabilitiesProvider`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
            // lift function
            { Unit },
            
            // Error FFI converter
            NullCallStatusErrorHandler,
        )
    }
    

    
    companion object
    
}

public object FfiConverterTypeWidgetDriver: FfiConverter<WidgetDriver, Pointer> {

    override fun lower(value: WidgetDriver): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): WidgetDriver {
        return WidgetDriver(value)
    }

    override fun read(buf: ByteBuffer): WidgetDriver {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: WidgetDriver) = 8

    override fun write(value: WidgetDriver, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}




public interface WidgetDriverHandleInterface {
    suspend fun `recv`(): String?
    suspend fun `send`(`msg`: String): Boolean
    
    companion object
}

open class WidgetDriverHandle : FFIObject, WidgetDriverHandleInterface {

    constructor(pointer: Pointer): super(pointer)

    /**
     * This constructor can be used to instantiate a fake object.
     *
     * **WARNING: Any object instantiated with this constructor cannot be passed to an actual Rust-backed object.**
     * Since there isn't a backing [Pointer] the FFI lower functions will crash.
     * @param noPointer Placeholder value so we can have a constructor separate from the default empty one that may be
     *   implemented for classes extending [FFIObject].
     */
    constructor(noPointer: NoPointer): super(noPointer)

    /**
     * Disconnect the object from the underlying Rust object.
     *
     * It can be called more than once, but once called, interacting with the object
     * causes an `IllegalStateException`.
     *
     * Clients **must** call this method once done with the object, or cause a memory leak.
     */
    override protected fun freeRustArcPtr() {
        this.pointer?.let { ptr ->
            rustCall() { status ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_widgetdriverhandle(ptr, status)
            }
        }
    }

    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `recv`() : String? {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_widgetdriverhandle_recv(
                    thisPtr,
                    
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
            // lift function
            { FfiConverterOptionalString.lift(it) },
            // Error FFI converter
            NullCallStatusErrorHandler,
        )
    }
    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `send`(`msg`: String) : Boolean {
        return uniffiRustCallAsync(
            callWithPointer { thisPtr ->
                _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_widgetdriverhandle_send(
                    thisPtr,
                    FfiConverterString.lower(`msg`),
                )
            },
            { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
            { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
            { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
            // lift function
            { FfiConverterBoolean.lift(it) },
            // Error FFI converter
            NullCallStatusErrorHandler,
        )
    }
    

    
    companion object
    
}

public object FfiConverterTypeWidgetDriverHandle: FfiConverter<WidgetDriverHandle, Pointer> {

    override fun lower(value: WidgetDriverHandle): Pointer {
        return value.callWithPointer { it }
    }

    override fun lift(value: Pointer): WidgetDriverHandle {
        return WidgetDriverHandle(value)
    }

    override fun read(buf: ByteBuffer): WidgetDriverHandle {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: WidgetDriverHandle) = 8

    override fun write(value: WidgetDriverHandle, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}



data class AudioInfo (
    var `duration`: java.time.Duration?, 
    var `size`: ULong?, 
    var `mimetype`: String?
) {
    
    companion object
}

public object FfiConverterTypeAudioInfo: FfiConverterRustBuffer<AudioInfo> {
    override fun read(buf: ByteBuffer): AudioInfo {
        return AudioInfo(
            FfiConverterOptionalDuration.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: AudioInfo) = (
            FfiConverterOptionalDuration.allocationSize(value.`duration`) +
            FfiConverterOptionalULong.allocationSize(value.`size`) +
            FfiConverterOptionalString.allocationSize(value.`mimetype`)
    )

    override fun write(value: AudioInfo, buf: ByteBuffer) {
            FfiConverterOptionalDuration.write(value.`duration`, buf)
            FfiConverterOptionalULong.write(value.`size`, buf)
            FfiConverterOptionalString.write(value.`mimetype`, buf)
    }
}



data class AudioMessageContent (
    var `body`: String, 
    var `source`: MediaSource, 
    var `info`: AudioInfo?, 
    var `audio`: UnstableAudioDetailsContent?, 
    var `voice`: UnstableVoiceContent?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`body`, 
        this.`source`, 
        this.`info`, 
        this.`audio`, 
        this.`voice`)
    }
    
    companion object
}

public object FfiConverterTypeAudioMessageContent: FfiConverterRustBuffer<AudioMessageContent> {
    override fun read(buf: ByteBuffer): AudioMessageContent {
        return AudioMessageContent(
            FfiConverterString.read(buf),
            FfiConverterTypeMediaSource.read(buf),
            FfiConverterOptionalTypeAudioInfo.read(buf),
            FfiConverterOptionalTypeUnstableAudioDetailsContent.read(buf),
            FfiConverterOptionalTypeUnstableVoiceContent.read(buf),
        )
    }

    override fun allocationSize(value: AudioMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterTypeMediaSource.allocationSize(value.`source`) +
            FfiConverterOptionalTypeAudioInfo.allocationSize(value.`info`) +
            FfiConverterOptionalTypeUnstableAudioDetailsContent.allocationSize(value.`audio`) +
            FfiConverterOptionalTypeUnstableVoiceContent.allocationSize(value.`voice`)
    )

    override fun write(value: AudioMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterTypeMediaSource.write(value.`source`, buf)
            FfiConverterOptionalTypeAudioInfo.write(value.`info`, buf)
            FfiConverterOptionalTypeUnstableAudioDetailsContent.write(value.`audio`, buf)
            FfiConverterOptionalTypeUnstableVoiceContent.write(value.`voice`, buf)
    }
}



data class ClientProperties (
    var `clientId`: String, 
    var `languageTag`: String?, 
    var `theme`: String?
) {
    
    companion object
}

public object FfiConverterTypeClientProperties: FfiConverterRustBuffer<ClientProperties> {
    override fun read(buf: ByteBuffer): ClientProperties {
        return ClientProperties(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: ClientProperties) = (
            FfiConverterString.allocationSize(value.`clientId`) +
            FfiConverterOptionalString.allocationSize(value.`languageTag`) +
            FfiConverterOptionalString.allocationSize(value.`theme`)
    )

    override fun write(value: ClientProperties, buf: ByteBuffer) {
            FfiConverterString.write(value.`clientId`, buf)
            FfiConverterOptionalString.write(value.`languageTag`, buf)
            FfiConverterOptionalString.write(value.`theme`, buf)
    }
}



data class CreateRoomParameters (
    var `name`: String?, 
    var `topic`: String? = null, 
    var `isEncrypted`: Boolean, 
    var `isDirect`: Boolean = false, 
    var `visibility`: RoomVisibility, 
    var `preset`: RoomPreset, 
    var `invite`: List<String>? = null, 
    var `avatar`: String? = null, 
    var `powerLevelContentOverride`: PowerLevels? = null
) {
    
    companion object
}

public object FfiConverterTypeCreateRoomParameters: FfiConverterRustBuffer<CreateRoomParameters> {
    override fun read(buf: ByteBuffer): CreateRoomParameters {
        return CreateRoomParameters(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterTypeRoomVisibility.read(buf),
            FfiConverterTypeRoomPreset.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalTypePowerLevels.read(buf),
        )
    }

    override fun allocationSize(value: CreateRoomParameters) = (
            FfiConverterOptionalString.allocationSize(value.`name`) +
            FfiConverterOptionalString.allocationSize(value.`topic`) +
            FfiConverterBoolean.allocationSize(value.`isEncrypted`) +
            FfiConverterBoolean.allocationSize(value.`isDirect`) +
            FfiConverterTypeRoomVisibility.allocationSize(value.`visibility`) +
            FfiConverterTypeRoomPreset.allocationSize(value.`preset`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`invite`) +
            FfiConverterOptionalString.allocationSize(value.`avatar`) +
            FfiConverterOptionalTypePowerLevels.allocationSize(value.`powerLevelContentOverride`)
    )

    override fun write(value: CreateRoomParameters, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`name`, buf)
            FfiConverterOptionalString.write(value.`topic`, buf)
            FfiConverterBoolean.write(value.`isEncrypted`, buf)
            FfiConverterBoolean.write(value.`isDirect`, buf)
            FfiConverterTypeRoomVisibility.write(value.`visibility`, buf)
            FfiConverterTypeRoomPreset.write(value.`preset`, buf)
            FfiConverterOptionalSequenceString.write(value.`invite`, buf)
            FfiConverterOptionalString.write(value.`avatar`, buf)
            FfiConverterOptionalTypePowerLevels.write(value.`powerLevelContentOverride`, buf)
    }
}



data class EmoteMessageContent (
    var `body`: String, 
    var `formatted`: FormattedBody?
) {
    
    companion object
}

public object FfiConverterTypeEmoteMessageContent: FfiConverterRustBuffer<EmoteMessageContent> {
    override fun read(buf: ByteBuffer): EmoteMessageContent {
        return EmoteMessageContent(
            FfiConverterString.read(buf),
            FfiConverterOptionalTypeFormattedBody.read(buf),
        )
    }

    override fun allocationSize(value: EmoteMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterOptionalTypeFormattedBody.allocationSize(value.`formatted`)
    )

    override fun write(value: EmoteMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterOptionalTypeFormattedBody.write(value.`formatted`, buf)
    }
}



data class EventTimelineItemDebugInfo (
    var `model`: String, 
    var `originalJson`: String?, 
    var `latestEditJson`: String?
) {
    
    companion object
}

public object FfiConverterTypeEventTimelineItemDebugInfo: FfiConverterRustBuffer<EventTimelineItemDebugInfo> {
    override fun read(buf: ByteBuffer): EventTimelineItemDebugInfo {
        return EventTimelineItemDebugInfo(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: EventTimelineItemDebugInfo) = (
            FfiConverterString.allocationSize(value.`model`) +
            FfiConverterOptionalString.allocationSize(value.`originalJson`) +
            FfiConverterOptionalString.allocationSize(value.`latestEditJson`)
    )

    override fun write(value: EventTimelineItemDebugInfo, buf: ByteBuffer) {
            FfiConverterString.write(value.`model`, buf)
            FfiConverterOptionalString.write(value.`originalJson`, buf)
            FfiConverterOptionalString.write(value.`latestEditJson`, buf)
    }
}



data class FileInfo (
    var `mimetype`: String?, 
    var `size`: ULong?, 
    var `thumbnailInfo`: ThumbnailInfo?, 
    var `thumbnailSource`: MediaSource?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`mimetype`, 
        this.`size`, 
        this.`thumbnailInfo`, 
        this.`thumbnailSource`)
    }
    
    companion object
}

public object FfiConverterTypeFileInfo: FfiConverterRustBuffer<FileInfo> {
    override fun read(buf: ByteBuffer): FileInfo {
        return FileInfo(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalTypeThumbnailInfo.read(buf),
            FfiConverterOptionalTypeMediaSource.read(buf),
        )
    }

    override fun allocationSize(value: FileInfo) = (
            FfiConverterOptionalString.allocationSize(value.`mimetype`) +
            FfiConverterOptionalULong.allocationSize(value.`size`) +
            FfiConverterOptionalTypeThumbnailInfo.allocationSize(value.`thumbnailInfo`) +
            FfiConverterOptionalTypeMediaSource.allocationSize(value.`thumbnailSource`)
    )

    override fun write(value: FileInfo, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`mimetype`, buf)
            FfiConverterOptionalULong.write(value.`size`, buf)
            FfiConverterOptionalTypeThumbnailInfo.write(value.`thumbnailInfo`, buf)
            FfiConverterOptionalTypeMediaSource.write(value.`thumbnailSource`, buf)
    }
}



data class FileMessageContent (
    var `body`: String, 
    var `filename`: String?, 
    var `source`: MediaSource, 
    var `info`: FileInfo?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`body`, 
        this.`filename`, 
        this.`source`, 
        this.`info`)
    }
    
    companion object
}

public object FfiConverterTypeFileMessageContent: FfiConverterRustBuffer<FileMessageContent> {
    override fun read(buf: ByteBuffer): FileMessageContent {
        return FileMessageContent(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterTypeMediaSource.read(buf),
            FfiConverterOptionalTypeFileInfo.read(buf),
        )
    }

    override fun allocationSize(value: FileMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterOptionalString.allocationSize(value.`filename`) +
            FfiConverterTypeMediaSource.allocationSize(value.`source`) +
            FfiConverterOptionalTypeFileInfo.allocationSize(value.`info`)
    )

    override fun write(value: FileMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterOptionalString.write(value.`filename`, buf)
            FfiConverterTypeMediaSource.write(value.`source`, buf)
            FfiConverterOptionalTypeFileInfo.write(value.`info`, buf)
    }
}



data class FormattedBody (
    var `format`: MessageFormat, 
    var `body`: String
) {
    
    companion object
}

public object FfiConverterTypeFormattedBody: FfiConverterRustBuffer<FormattedBody> {
    override fun read(buf: ByteBuffer): FormattedBody {
        return FormattedBody(
            FfiConverterTypeMessageFormat.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: FormattedBody) = (
            FfiConverterTypeMessageFormat.allocationSize(value.`format`) +
            FfiConverterString.allocationSize(value.`body`)
    )

    override fun write(value: FormattedBody, buf: ByteBuffer) {
            FfiConverterTypeMessageFormat.write(value.`format`, buf)
            FfiConverterString.write(value.`body`, buf)
    }
}



data class HttpPusherData (
    var `url`: String, 
    var `format`: PushFormat?, 
    var `defaultPayload`: String?
) {
    
    companion object
}

public object FfiConverterTypeHttpPusherData: FfiConverterRustBuffer<HttpPusherData> {
    override fun read(buf: ByteBuffer): HttpPusherData {
        return HttpPusherData(
            FfiConverterString.read(buf),
            FfiConverterOptionalTypePushFormat.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: HttpPusherData) = (
            FfiConverterString.allocationSize(value.`url`) +
            FfiConverterOptionalTypePushFormat.allocationSize(value.`format`) +
            FfiConverterOptionalString.allocationSize(value.`defaultPayload`)
    )

    override fun write(value: HttpPusherData, buf: ByteBuffer) {
            FfiConverterString.write(value.`url`, buf)
            FfiConverterOptionalTypePushFormat.write(value.`format`, buf)
            FfiConverterOptionalString.write(value.`defaultPayload`, buf)
    }
}



data class ImageInfo (
    var `height`: ULong?, 
    var `width`: ULong?, 
    var `mimetype`: String?, 
    var `size`: ULong?, 
    var `thumbnailInfo`: ThumbnailInfo?, 
    var `thumbnailSource`: MediaSource?, 
    var `blurhash`: String?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`height`, 
        this.`width`, 
        this.`mimetype`, 
        this.`size`, 
        this.`thumbnailInfo`, 
        this.`thumbnailSource`, 
        this.`blurhash`)
    }
    
    companion object
}

public object FfiConverterTypeImageInfo: FfiConverterRustBuffer<ImageInfo> {
    override fun read(buf: ByteBuffer): ImageInfo {
        return ImageInfo(
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalTypeThumbnailInfo.read(buf),
            FfiConverterOptionalTypeMediaSource.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: ImageInfo) = (
            FfiConverterOptionalULong.allocationSize(value.`height`) +
            FfiConverterOptionalULong.allocationSize(value.`width`) +
            FfiConverterOptionalString.allocationSize(value.`mimetype`) +
            FfiConverterOptionalULong.allocationSize(value.`size`) +
            FfiConverterOptionalTypeThumbnailInfo.allocationSize(value.`thumbnailInfo`) +
            FfiConverterOptionalTypeMediaSource.allocationSize(value.`thumbnailSource`) +
            FfiConverterOptionalString.allocationSize(value.`blurhash`)
    )

    override fun write(value: ImageInfo, buf: ByteBuffer) {
            FfiConverterOptionalULong.write(value.`height`, buf)
            FfiConverterOptionalULong.write(value.`width`, buf)
            FfiConverterOptionalString.write(value.`mimetype`, buf)
            FfiConverterOptionalULong.write(value.`size`, buf)
            FfiConverterOptionalTypeThumbnailInfo.write(value.`thumbnailInfo`, buf)
            FfiConverterOptionalTypeMediaSource.write(value.`thumbnailSource`, buf)
            FfiConverterOptionalString.write(value.`blurhash`, buf)
    }
}



data class ImageMessageContent (
    var `body`: String, 
    var `source`: MediaSource, 
    var `info`: ImageInfo?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`body`, 
        this.`source`, 
        this.`info`)
    }
    
    companion object
}

public object FfiConverterTypeImageMessageContent: FfiConverterRustBuffer<ImageMessageContent> {
    override fun read(buf: ByteBuffer): ImageMessageContent {
        return ImageMessageContent(
            FfiConverterString.read(buf),
            FfiConverterTypeMediaSource.read(buf),
            FfiConverterOptionalTypeImageInfo.read(buf),
        )
    }

    override fun allocationSize(value: ImageMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterTypeMediaSource.allocationSize(value.`source`) +
            FfiConverterOptionalTypeImageInfo.allocationSize(value.`info`)
    )

    override fun write(value: ImageMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterTypeMediaSource.write(value.`source`, buf)
            FfiConverterOptionalTypeImageInfo.write(value.`info`, buf)
    }
}



data class InReplyToDetails (
    var `eventId`: String, 
    var `event`: RepliedToEventDetails
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`eventId`, 
        this.`event`)
    }
    
    companion object
}

public object FfiConverterTypeInReplyToDetails: FfiConverterRustBuffer<InReplyToDetails> {
    override fun read(buf: ByteBuffer): InReplyToDetails {
        return InReplyToDetails(
            FfiConverterString.read(buf),
            FfiConverterTypeRepliedToEventDetails.read(buf),
        )
    }

    override fun allocationSize(value: InReplyToDetails) = (
            FfiConverterString.allocationSize(value.`eventId`) +
            FfiConverterTypeRepliedToEventDetails.allocationSize(value.`event`)
    )

    override fun write(value: InReplyToDetails, buf: ByteBuffer) {
            FfiConverterString.write(value.`eventId`, buf)
            FfiConverterTypeRepliedToEventDetails.write(value.`event`, buf)
    }
}



data class InsertData (
    var `index`: UInt, 
    var `item`: TimelineItem
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`index`, 
        this.`item`)
    }
    
    companion object
}

public object FfiConverterTypeInsertData: FfiConverterRustBuffer<InsertData> {
    override fun read(buf: ByteBuffer): InsertData {
        return InsertData(
            FfiConverterUInt.read(buf),
            FfiConverterTypeTimelineItem.read(buf),
        )
    }

    override fun allocationSize(value: InsertData) = (
            FfiConverterUInt.allocationSize(value.`index`) +
            FfiConverterTypeTimelineItem.allocationSize(value.`item`)
    )

    override fun write(value: InsertData, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`index`, buf)
            FfiConverterTypeTimelineItem.write(value.`item`, buf)
    }
}



data class LocationContent (
    var `body`: String, 
    var `geoUri`: String, 
    var `description`: String?, 
    var `zoomLevel`: UByte?, 
    var `asset`: AssetType?
) {
    
    companion object
}

public object FfiConverterTypeLocationContent: FfiConverterRustBuffer<LocationContent> {
    override fun read(buf: ByteBuffer): LocationContent {
        return LocationContent(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalUByte.read(buf),
            FfiConverterOptionalTypeAssetType.read(buf),
        )
    }

    override fun allocationSize(value: LocationContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterString.allocationSize(value.`geoUri`) +
            FfiConverterOptionalString.allocationSize(value.`description`) +
            FfiConverterOptionalUByte.allocationSize(value.`zoomLevel`) +
            FfiConverterOptionalTypeAssetType.allocationSize(value.`asset`)
    )

    override fun write(value: LocationContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterString.write(value.`geoUri`, buf)
            FfiConverterOptionalString.write(value.`description`, buf)
            FfiConverterOptionalUByte.write(value.`zoomLevel`, buf)
            FfiConverterOptionalTypeAssetType.write(value.`asset`, buf)
    }
}



data class Mentions (
    var `userIds`: List<String>, 
    var `room`: Boolean
) {
    
    companion object
}

public object FfiConverterTypeMentions: FfiConverterRustBuffer<Mentions> {
    override fun read(buf: ByteBuffer): Mentions {
        return Mentions(
            FfiConverterSequenceString.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: Mentions) = (
            FfiConverterSequenceString.allocationSize(value.`userIds`) +
            FfiConverterBoolean.allocationSize(value.`room`)
    )

    override fun write(value: Mentions, buf: ByteBuffer) {
            FfiConverterSequenceString.write(value.`userIds`, buf)
            FfiConverterBoolean.write(value.`room`, buf)
    }
}



data class NoticeMessageContent (
    var `body`: String, 
    var `formatted`: FormattedBody?
) {
    
    companion object
}

public object FfiConverterTypeNoticeMessageContent: FfiConverterRustBuffer<NoticeMessageContent> {
    override fun read(buf: ByteBuffer): NoticeMessageContent {
        return NoticeMessageContent(
            FfiConverterString.read(buf),
            FfiConverterOptionalTypeFormattedBody.read(buf),
        )
    }

    override fun allocationSize(value: NoticeMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterOptionalTypeFormattedBody.allocationSize(value.`formatted`)
    )

    override fun write(value: NoticeMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterOptionalTypeFormattedBody.write(value.`formatted`, buf)
    }
}



data class NotificationItem (
    var `event`: NotificationEvent, 
    var `senderInfo`: NotificationSenderInfo, 
    var `roomInfo`: NotificationRoomInfo, 
    var `isNoisy`: Boolean?, 
    var `hasMention`: Boolean?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`event`, 
        this.`senderInfo`, 
        this.`roomInfo`, 
        this.`isNoisy`, 
        this.`hasMention`)
    }
    
    companion object
}

public object FfiConverterTypeNotificationItem: FfiConverterRustBuffer<NotificationItem> {
    override fun read(buf: ByteBuffer): NotificationItem {
        return NotificationItem(
            FfiConverterTypeNotificationEvent.read(buf),
            FfiConverterTypeNotificationSenderInfo.read(buf),
            FfiConverterTypeNotificationRoomInfo.read(buf),
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterOptionalBoolean.read(buf),
        )
    }

    override fun allocationSize(value: NotificationItem) = (
            FfiConverterTypeNotificationEvent.allocationSize(value.`event`) +
            FfiConverterTypeNotificationSenderInfo.allocationSize(value.`senderInfo`) +
            FfiConverterTypeNotificationRoomInfo.allocationSize(value.`roomInfo`) +
            FfiConverterOptionalBoolean.allocationSize(value.`isNoisy`) +
            FfiConverterOptionalBoolean.allocationSize(value.`hasMention`)
    )

    override fun write(value: NotificationItem, buf: ByteBuffer) {
            FfiConverterTypeNotificationEvent.write(value.`event`, buf)
            FfiConverterTypeNotificationSenderInfo.write(value.`senderInfo`, buf)
            FfiConverterTypeNotificationRoomInfo.write(value.`roomInfo`, buf)
            FfiConverterOptionalBoolean.write(value.`isNoisy`, buf)
            FfiConverterOptionalBoolean.write(value.`hasMention`, buf)
    }
}



data class NotificationPowerLevels (
    var `room`: Int
) {
    
    companion object
}

public object FfiConverterTypeNotificationPowerLevels: FfiConverterRustBuffer<NotificationPowerLevels> {
    override fun read(buf: ByteBuffer): NotificationPowerLevels {
        return NotificationPowerLevels(
            FfiConverterInt.read(buf),
        )
    }

    override fun allocationSize(value: NotificationPowerLevels) = (
            FfiConverterInt.allocationSize(value.`room`)
    )

    override fun write(value: NotificationPowerLevels, buf: ByteBuffer) {
            FfiConverterInt.write(value.`room`, buf)
    }
}



data class NotificationRoomInfo (
    var `displayName`: String, 
    var `avatarUrl`: String?, 
    var `canonicalAlias`: String?, 
    var `joinedMembersCount`: ULong, 
    var `isEncrypted`: Boolean?, 
    var `isDirect`: Boolean
) {
    
    companion object
}

public object FfiConverterTypeNotificationRoomInfo: FfiConverterRustBuffer<NotificationRoomInfo> {
    override fun read(buf: ByteBuffer): NotificationRoomInfo {
        return NotificationRoomInfo(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: NotificationRoomInfo) = (
            FfiConverterString.allocationSize(value.`displayName`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`) +
            FfiConverterOptionalString.allocationSize(value.`canonicalAlias`) +
            FfiConverterULong.allocationSize(value.`joinedMembersCount`) +
            FfiConverterOptionalBoolean.allocationSize(value.`isEncrypted`) +
            FfiConverterBoolean.allocationSize(value.`isDirect`)
    )

    override fun write(value: NotificationRoomInfo, buf: ByteBuffer) {
            FfiConverterString.write(value.`displayName`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
            FfiConverterOptionalString.write(value.`canonicalAlias`, buf)
            FfiConverterULong.write(value.`joinedMembersCount`, buf)
            FfiConverterOptionalBoolean.write(value.`isEncrypted`, buf)
            FfiConverterBoolean.write(value.`isDirect`, buf)
    }
}



data class NotificationSenderInfo (
    var `displayName`: String?, 
    var `avatarUrl`: String?
) {
    
    companion object
}

public object FfiConverterTypeNotificationSenderInfo: FfiConverterRustBuffer<NotificationSenderInfo> {
    override fun read(buf: ByteBuffer): NotificationSenderInfo {
        return NotificationSenderInfo(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: NotificationSenderInfo) = (
            FfiConverterOptionalString.allocationSize(value.`displayName`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`)
    )

    override fun write(value: NotificationSenderInfo, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`displayName`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
    }
}



data class OidcConfiguration (
    var `clientName`: String?, 
    var `redirectUri`: String, 
    var `clientUri`: String?, 
    var `logoUri`: String?, 
    var `tosUri`: String?, 
    var `policyUri`: String?, 
    var `contacts`: List<String>?, 
    var `staticRegistrations`: Map<String, String>
) {
    
    companion object
}

public object FfiConverterTypeOidcConfiguration: FfiConverterRustBuffer<OidcConfiguration> {
    override fun read(buf: ByteBuffer): OidcConfiguration {
        return OidcConfiguration(
            FfiConverterOptionalString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterMapStringString.read(buf),
        )
    }

    override fun allocationSize(value: OidcConfiguration) = (
            FfiConverterOptionalString.allocationSize(value.`clientName`) +
            FfiConverterString.allocationSize(value.`redirectUri`) +
            FfiConverterOptionalString.allocationSize(value.`clientUri`) +
            FfiConverterOptionalString.allocationSize(value.`logoUri`) +
            FfiConverterOptionalString.allocationSize(value.`tosUri`) +
            FfiConverterOptionalString.allocationSize(value.`policyUri`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`contacts`) +
            FfiConverterMapStringString.allocationSize(value.`staticRegistrations`)
    )

    override fun write(value: OidcConfiguration, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`clientName`, buf)
            FfiConverterString.write(value.`redirectUri`, buf)
            FfiConverterOptionalString.write(value.`clientUri`, buf)
            FfiConverterOptionalString.write(value.`logoUri`, buf)
            FfiConverterOptionalString.write(value.`tosUri`, buf)
            FfiConverterOptionalString.write(value.`policyUri`, buf)
            FfiConverterOptionalSequenceString.write(value.`contacts`, buf)
            FfiConverterMapStringString.write(value.`staticRegistrations`, buf)
    }
}



data class OtlpTracingConfiguration (
    var `clientName`: String, 
    var `user`: String, 
    var `password`: String, 
    var `otlpEndpoint`: String, 
    var `filter`: String, 
    var `writeToStdoutOrSystem`: Boolean, 
    var `writeToFiles`: TracingFileConfiguration?
) {
    
    companion object
}

public object FfiConverterTypeOtlpTracingConfiguration: FfiConverterRustBuffer<OtlpTracingConfiguration> {
    override fun read(buf: ByteBuffer): OtlpTracingConfiguration {
        return OtlpTracingConfiguration(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterOptionalTypeTracingFileConfiguration.read(buf),
        )
    }

    override fun allocationSize(value: OtlpTracingConfiguration) = (
            FfiConverterString.allocationSize(value.`clientName`) +
            FfiConverterString.allocationSize(value.`user`) +
            FfiConverterString.allocationSize(value.`password`) +
            FfiConverterString.allocationSize(value.`otlpEndpoint`) +
            FfiConverterString.allocationSize(value.`filter`) +
            FfiConverterBoolean.allocationSize(value.`writeToStdoutOrSystem`) +
            FfiConverterOptionalTypeTracingFileConfiguration.allocationSize(value.`writeToFiles`)
    )

    override fun write(value: OtlpTracingConfiguration, buf: ByteBuffer) {
            FfiConverterString.write(value.`clientName`, buf)
            FfiConverterString.write(value.`user`, buf)
            FfiConverterString.write(value.`password`, buf)
            FfiConverterString.write(value.`otlpEndpoint`, buf)
            FfiConverterString.write(value.`filter`, buf)
            FfiConverterBoolean.write(value.`writeToStdoutOrSystem`, buf)
            FfiConverterOptionalTypeTracingFileConfiguration.write(value.`writeToFiles`, buf)
    }
}



data class PollAnswer (
    var `id`: String, 
    var `text`: String
) {
    
    companion object
}

public object FfiConverterTypePollAnswer: FfiConverterRustBuffer<PollAnswer> {
    override fun read(buf: ByteBuffer): PollAnswer {
        return PollAnswer(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: PollAnswer) = (
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterString.allocationSize(value.`text`)
    )

    override fun write(value: PollAnswer, buf: ByteBuffer) {
            FfiConverterString.write(value.`id`, buf)
            FfiConverterString.write(value.`text`, buf)
    }
}



data class PowerLevels (
    var `usersDefault`: Int?, 
    var `eventsDefault`: Int?, 
    var `stateDefault`: Int?, 
    var `ban`: Int?, 
    var `kick`: Int?, 
    var `redact`: Int?, 
    var `invite`: Int?, 
    var `notifications`: NotificationPowerLevels?, 
    var `users`: Map<String, Int>, 
    var `events`: Map<String, Int>
) {
    
    companion object
}

public object FfiConverterTypePowerLevels: FfiConverterRustBuffer<PowerLevels> {
    override fun read(buf: ByteBuffer): PowerLevels {
        return PowerLevels(
            FfiConverterOptionalInt.read(buf),
            FfiConverterOptionalInt.read(buf),
            FfiConverterOptionalInt.read(buf),
            FfiConverterOptionalInt.read(buf),
            FfiConverterOptionalInt.read(buf),
            FfiConverterOptionalInt.read(buf),
            FfiConverterOptionalInt.read(buf),
            FfiConverterOptionalTypeNotificationPowerLevels.read(buf),
            FfiConverterMapStringInt.read(buf),
            FfiConverterMapStringInt.read(buf),
        )
    }

    override fun allocationSize(value: PowerLevels) = (
            FfiConverterOptionalInt.allocationSize(value.`usersDefault`) +
            FfiConverterOptionalInt.allocationSize(value.`eventsDefault`) +
            FfiConverterOptionalInt.allocationSize(value.`stateDefault`) +
            FfiConverterOptionalInt.allocationSize(value.`ban`) +
            FfiConverterOptionalInt.allocationSize(value.`kick`) +
            FfiConverterOptionalInt.allocationSize(value.`redact`) +
            FfiConverterOptionalInt.allocationSize(value.`invite`) +
            FfiConverterOptionalTypeNotificationPowerLevels.allocationSize(value.`notifications`) +
            FfiConverterMapStringInt.allocationSize(value.`users`) +
            FfiConverterMapStringInt.allocationSize(value.`events`)
    )

    override fun write(value: PowerLevels, buf: ByteBuffer) {
            FfiConverterOptionalInt.write(value.`usersDefault`, buf)
            FfiConverterOptionalInt.write(value.`eventsDefault`, buf)
            FfiConverterOptionalInt.write(value.`stateDefault`, buf)
            FfiConverterOptionalInt.write(value.`ban`, buf)
            FfiConverterOptionalInt.write(value.`kick`, buf)
            FfiConverterOptionalInt.write(value.`redact`, buf)
            FfiConverterOptionalInt.write(value.`invite`, buf)
            FfiConverterOptionalTypeNotificationPowerLevels.write(value.`notifications`, buf)
            FfiConverterMapStringInt.write(value.`users`, buf)
            FfiConverterMapStringInt.write(value.`events`, buf)
    }
}



data class PusherIdentifiers (
    var `pushkey`: String, 
    var `appId`: String
) {
    
    companion object
}

public object FfiConverterTypePusherIdentifiers: FfiConverterRustBuffer<PusherIdentifiers> {
    override fun read(buf: ByteBuffer): PusherIdentifiers {
        return PusherIdentifiers(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: PusherIdentifiers) = (
            FfiConverterString.allocationSize(value.`pushkey`) +
            FfiConverterString.allocationSize(value.`appId`)
    )

    override fun write(value: PusherIdentifiers, buf: ByteBuffer) {
            FfiConverterString.write(value.`pushkey`, buf)
            FfiConverterString.write(value.`appId`, buf)
    }
}



data class Reaction (
    var `key`: String, 
    var `count`: ULong, 
    var `senders`: List<ReactionSenderData>
) {
    
    companion object
}

public object FfiConverterTypeReaction: FfiConverterRustBuffer<Reaction> {
    override fun read(buf: ByteBuffer): Reaction {
        return Reaction(
            FfiConverterString.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterSequenceTypeReactionSenderData.read(buf),
        )
    }

    override fun allocationSize(value: Reaction) = (
            FfiConverterString.allocationSize(value.`key`) +
            FfiConverterULong.allocationSize(value.`count`) +
            FfiConverterSequenceTypeReactionSenderData.allocationSize(value.`senders`)
    )

    override fun write(value: Reaction, buf: ByteBuffer) {
            FfiConverterString.write(value.`key`, buf)
            FfiConverterULong.write(value.`count`, buf)
            FfiConverterSequenceTypeReactionSenderData.write(value.`senders`, buf)
    }
}



data class ReactionSenderData (
    var `senderId`: String, 
    var `timestamp`: ULong
) {
    
    companion object
}

public object FfiConverterTypeReactionSenderData: FfiConverterRustBuffer<ReactionSenderData> {
    override fun read(buf: ByteBuffer): ReactionSenderData {
        return ReactionSenderData(
            FfiConverterString.read(buf),
            FfiConverterULong.read(buf),
        )
    }

    override fun allocationSize(value: ReactionSenderData) = (
            FfiConverterString.allocationSize(value.`senderId`) +
            FfiConverterULong.allocationSize(value.`timestamp`)
    )

    override fun write(value: ReactionSenderData, buf: ByteBuffer) {
            FfiConverterString.write(value.`senderId`, buf)
            FfiConverterULong.write(value.`timestamp`, buf)
    }
}



data class Receipt (
    var `timestamp`: ULong?
) {
    
    companion object
}

public object FfiConverterTypeReceipt: FfiConverterRustBuffer<Receipt> {
    override fun read(buf: ByteBuffer): Receipt {
        return Receipt(
            FfiConverterOptionalULong.read(buf),
        )
    }

    override fun allocationSize(value: Receipt) = (
            FfiConverterOptionalULong.allocationSize(value.`timestamp`)
    )

    override fun write(value: Receipt, buf: ByteBuffer) {
            FfiConverterOptionalULong.write(value.`timestamp`, buf)
    }
}



data class RequiredState (
    var `key`: String, 
    var `value`: String
) {
    
    companion object
}

public object FfiConverterTypeRequiredState: FfiConverterRustBuffer<RequiredState> {
    override fun read(buf: ByteBuffer): RequiredState {
        return RequiredState(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: RequiredState) = (
            FfiConverterString.allocationSize(value.`key`) +
            FfiConverterString.allocationSize(value.`value`)
    )

    override fun write(value: RequiredState, buf: ByteBuffer) {
            FfiConverterString.write(value.`key`, buf)
            FfiConverterString.write(value.`value`, buf)
    }
}



data class RoomInfo (
    var `id`: String, 
    var `name`: String?, 
    var `topic`: String?, 
    var `avatarUrl`: String?, 
    var `isDirect`: Boolean, 
    var `isPublic`: Boolean, 
    var `isSpace`: Boolean, 
    var `isTombstoned`: Boolean, 
    var `canonicalAlias`: String?, 
    var `alternativeAliases`: List<String>, 
    var `membership`: Membership, 
    var `latestEvent`: EventTimelineItem?, 
    var `inviter`: RoomMember?, 
    var `activeMembersCount`: ULong, 
    var `invitedMembersCount`: ULong, 
    var `joinedMembersCount`: ULong, 
    var `highlightCount`: ULong, 
    var `notificationCount`: ULong, 
    var `userDefinedNotificationMode`: RoomNotificationMode?, 
    var `hasRoomCall`: Boolean, 
    var `activeRoomCallParticipants`: List<String>
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`id`, 
        this.`name`, 
        this.`topic`, 
        this.`avatarUrl`, 
        this.`isDirect`, 
        this.`isPublic`, 
        this.`isSpace`, 
        this.`isTombstoned`, 
        this.`canonicalAlias`, 
        this.`alternativeAliases`, 
        this.`membership`, 
        this.`latestEvent`, 
        this.`inviter`, 
        this.`activeMembersCount`, 
        this.`invitedMembersCount`, 
        this.`joinedMembersCount`, 
        this.`highlightCount`, 
        this.`notificationCount`, 
        this.`userDefinedNotificationMode`, 
        this.`hasRoomCall`, 
        this.`activeRoomCallParticipants`)
    }
    
    companion object
}

public object FfiConverterTypeRoomInfo: FfiConverterRustBuffer<RoomInfo> {
    override fun read(buf: ByteBuffer): RoomInfo {
        return RoomInfo(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterSequenceString.read(buf),
            FfiConverterTypeMembership.read(buf),
            FfiConverterOptionalTypeEventTimelineItem.read(buf),
            FfiConverterOptionalTypeRoomMember.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterOptionalTypeRoomNotificationMode.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: RoomInfo) = (
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterOptionalString.allocationSize(value.`name`) +
            FfiConverterOptionalString.allocationSize(value.`topic`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`) +
            FfiConverterBoolean.allocationSize(value.`isDirect`) +
            FfiConverterBoolean.allocationSize(value.`isPublic`) +
            FfiConverterBoolean.allocationSize(value.`isSpace`) +
            FfiConverterBoolean.allocationSize(value.`isTombstoned`) +
            FfiConverterOptionalString.allocationSize(value.`canonicalAlias`) +
            FfiConverterSequenceString.allocationSize(value.`alternativeAliases`) +
            FfiConverterTypeMembership.allocationSize(value.`membership`) +
            FfiConverterOptionalTypeEventTimelineItem.allocationSize(value.`latestEvent`) +
            FfiConverterOptionalTypeRoomMember.allocationSize(value.`inviter`) +
            FfiConverterULong.allocationSize(value.`activeMembersCount`) +
            FfiConverterULong.allocationSize(value.`invitedMembersCount`) +
            FfiConverterULong.allocationSize(value.`joinedMembersCount`) +
            FfiConverterULong.allocationSize(value.`highlightCount`) +
            FfiConverterULong.allocationSize(value.`notificationCount`) +
            FfiConverterOptionalTypeRoomNotificationMode.allocationSize(value.`userDefinedNotificationMode`) +
            FfiConverterBoolean.allocationSize(value.`hasRoomCall`) +
            FfiConverterSequenceString.allocationSize(value.`activeRoomCallParticipants`)
    )

    override fun write(value: RoomInfo, buf: ByteBuffer) {
            FfiConverterString.write(value.`id`, buf)
            FfiConverterOptionalString.write(value.`name`, buf)
            FfiConverterOptionalString.write(value.`topic`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
            FfiConverterBoolean.write(value.`isDirect`, buf)
            FfiConverterBoolean.write(value.`isPublic`, buf)
            FfiConverterBoolean.write(value.`isSpace`, buf)
            FfiConverterBoolean.write(value.`isTombstoned`, buf)
            FfiConverterOptionalString.write(value.`canonicalAlias`, buf)
            FfiConverterSequenceString.write(value.`alternativeAliases`, buf)
            FfiConverterTypeMembership.write(value.`membership`, buf)
            FfiConverterOptionalTypeEventTimelineItem.write(value.`latestEvent`, buf)
            FfiConverterOptionalTypeRoomMember.write(value.`inviter`, buf)
            FfiConverterULong.write(value.`activeMembersCount`, buf)
            FfiConverterULong.write(value.`invitedMembersCount`, buf)
            FfiConverterULong.write(value.`joinedMembersCount`, buf)
            FfiConverterULong.write(value.`highlightCount`, buf)
            FfiConverterULong.write(value.`notificationCount`, buf)
            FfiConverterOptionalTypeRoomNotificationMode.write(value.`userDefinedNotificationMode`, buf)
            FfiConverterBoolean.write(value.`hasRoomCall`, buf)
            FfiConverterSequenceString.write(value.`activeRoomCallParticipants`, buf)
    }
}



data class RoomListEntriesResult (
    var `entries`: List<RoomListEntry>, 
    var `entriesStream`: TaskHandle
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`entries`, 
        this.`entriesStream`)
    }
    
    companion object
}

public object FfiConverterTypeRoomListEntriesResult: FfiConverterRustBuffer<RoomListEntriesResult> {
    override fun read(buf: ByteBuffer): RoomListEntriesResult {
        return RoomListEntriesResult(
            FfiConverterSequenceTypeRoomListEntry.read(buf),
            FfiConverterTypeTaskHandle.read(buf),
        )
    }

    override fun allocationSize(value: RoomListEntriesResult) = (
            FfiConverterSequenceTypeRoomListEntry.allocationSize(value.`entries`) +
            FfiConverterTypeTaskHandle.allocationSize(value.`entriesStream`)
    )

    override fun write(value: RoomListEntriesResult, buf: ByteBuffer) {
            FfiConverterSequenceTypeRoomListEntry.write(value.`entries`, buf)
            FfiConverterTypeTaskHandle.write(value.`entriesStream`, buf)
    }
}



data class RoomListEntriesWithDynamicAdaptersResult (
    var `controller`: RoomListDynamicEntriesController, 
    var `entriesStream`: TaskHandle
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`controller`, 
        this.`entriesStream`)
    }
    
    companion object
}

public object FfiConverterTypeRoomListEntriesWithDynamicAdaptersResult: FfiConverterRustBuffer<RoomListEntriesWithDynamicAdaptersResult> {
    override fun read(buf: ByteBuffer): RoomListEntriesWithDynamicAdaptersResult {
        return RoomListEntriesWithDynamicAdaptersResult(
            FfiConverterTypeRoomListDynamicEntriesController.read(buf),
            FfiConverterTypeTaskHandle.read(buf),
        )
    }

    override fun allocationSize(value: RoomListEntriesWithDynamicAdaptersResult) = (
            FfiConverterTypeRoomListDynamicEntriesController.allocationSize(value.`controller`) +
            FfiConverterTypeTaskHandle.allocationSize(value.`entriesStream`)
    )

    override fun write(value: RoomListEntriesWithDynamicAdaptersResult, buf: ByteBuffer) {
            FfiConverterTypeRoomListDynamicEntriesController.write(value.`controller`, buf)
            FfiConverterTypeTaskHandle.write(value.`entriesStream`, buf)
    }
}



data class RoomListLoadingStateResult (
    var `state`: RoomListLoadingState, 
    var `stateStream`: TaskHandle
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`state`, 
        this.`stateStream`)
    }
    
    companion object
}

public object FfiConverterTypeRoomListLoadingStateResult: FfiConverterRustBuffer<RoomListLoadingStateResult> {
    override fun read(buf: ByteBuffer): RoomListLoadingStateResult {
        return RoomListLoadingStateResult(
            FfiConverterTypeRoomListLoadingState.read(buf),
            FfiConverterTypeTaskHandle.read(buf),
        )
    }

    override fun allocationSize(value: RoomListLoadingStateResult) = (
            FfiConverterTypeRoomListLoadingState.allocationSize(value.`state`) +
            FfiConverterTypeTaskHandle.allocationSize(value.`stateStream`)
    )

    override fun write(value: RoomListLoadingStateResult, buf: ByteBuffer) {
            FfiConverterTypeRoomListLoadingState.write(value.`state`, buf)
            FfiConverterTypeTaskHandle.write(value.`stateStream`, buf)
    }
}



data class RoomListRange (
    var `start`: UInt, 
    var `endInclusive`: UInt
) {
    
    companion object
}

public object FfiConverterTypeRoomListRange: FfiConverterRustBuffer<RoomListRange> {
    override fun read(buf: ByteBuffer): RoomListRange {
        return RoomListRange(
            FfiConverterUInt.read(buf),
            FfiConverterUInt.read(buf),
        )
    }

    override fun allocationSize(value: RoomListRange) = (
            FfiConverterUInt.allocationSize(value.`start`) +
            FfiConverterUInt.allocationSize(value.`endInclusive`)
    )

    override fun write(value: RoomListRange, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`start`, buf)
            FfiConverterUInt.write(value.`endInclusive`, buf)
    }
}



data class RoomNotificationSettings (
    var `mode`: RoomNotificationMode, 
    var `isDefault`: Boolean
) {
    
    companion object
}

public object FfiConverterTypeRoomNotificationSettings: FfiConverterRustBuffer<RoomNotificationSettings> {
    override fun read(buf: ByteBuffer): RoomNotificationSettings {
        return RoomNotificationSettings(
            FfiConverterTypeRoomNotificationMode.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: RoomNotificationSettings) = (
            FfiConverterTypeRoomNotificationMode.allocationSize(value.`mode`) +
            FfiConverterBoolean.allocationSize(value.`isDefault`)
    )

    override fun write(value: RoomNotificationSettings, buf: ByteBuffer) {
            FfiConverterTypeRoomNotificationMode.write(value.`mode`, buf)
            FfiConverterBoolean.write(value.`isDefault`, buf)
    }
}



data class RoomSubscription (
    var `requiredState`: List<RequiredState>?, 
    var `timelineLimit`: UInt?
) {
    
    companion object
}

public object FfiConverterTypeRoomSubscription: FfiConverterRustBuffer<RoomSubscription> {
    override fun read(buf: ByteBuffer): RoomSubscription {
        return RoomSubscription(
            FfiConverterOptionalSequenceTypeRequiredState.read(buf),
            FfiConverterOptionalUInt.read(buf),
        )
    }

    override fun allocationSize(value: RoomSubscription) = (
            FfiConverterOptionalSequenceTypeRequiredState.allocationSize(value.`requiredState`) +
            FfiConverterOptionalUInt.allocationSize(value.`timelineLimit`)
    )

    override fun write(value: RoomSubscription, buf: ByteBuffer) {
            FfiConverterOptionalSequenceTypeRequiredState.write(value.`requiredState`, buf)
            FfiConverterOptionalUInt.write(value.`timelineLimit`, buf)
    }
}



data class RoomTimelineListenerResult (
    var `items`: List<TimelineItem>, 
    var `itemsStream`: TaskHandle
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`items`, 
        this.`itemsStream`)
    }
    
    companion object
}

public object FfiConverterTypeRoomTimelineListenerResult: FfiConverterRustBuffer<RoomTimelineListenerResult> {
    override fun read(buf: ByteBuffer): RoomTimelineListenerResult {
        return RoomTimelineListenerResult(
            FfiConverterSequenceTypeTimelineItem.read(buf),
            FfiConverterTypeTaskHandle.read(buf),
        )
    }

    override fun allocationSize(value: RoomTimelineListenerResult) = (
            FfiConverterSequenceTypeTimelineItem.allocationSize(value.`items`) +
            FfiConverterTypeTaskHandle.allocationSize(value.`itemsStream`)
    )

    override fun write(value: RoomTimelineListenerResult, buf: ByteBuffer) {
            FfiConverterSequenceTypeTimelineItem.write(value.`items`, buf)
            FfiConverterTypeTaskHandle.write(value.`itemsStream`, buf)
    }
}



data class SearchUsersResults (
    var `results`: List<UserProfile>, 
    var `limited`: Boolean
) {
    
    companion object
}

public object FfiConverterTypeSearchUsersResults: FfiConverterRustBuffer<SearchUsersResults> {
    override fun read(buf: ByteBuffer): SearchUsersResults {
        return SearchUsersResults(
            FfiConverterSequenceTypeUserProfile.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: SearchUsersResults) = (
            FfiConverterSequenceTypeUserProfile.allocationSize(value.`results`) +
            FfiConverterBoolean.allocationSize(value.`limited`)
    )

    override fun write(value: SearchUsersResults, buf: ByteBuffer) {
            FfiConverterSequenceTypeUserProfile.write(value.`results`, buf)
            FfiConverterBoolean.write(value.`limited`, buf)
    }
}



data class Session (
    var `accessToken`: String, 
    var `refreshToken`: String?, 
    var `userId`: String, 
    var `deviceId`: String, 
    var `homeserverUrl`: String, 
    var `oidcData`: String?, 
    var `slidingSyncProxy`: String?
) {
    
    companion object
}

public object FfiConverterTypeSession: FfiConverterRustBuffer<Session> {
    override fun read(buf: ByteBuffer): Session {
        return Session(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: Session) = (
            FfiConverterString.allocationSize(value.`accessToken`) +
            FfiConverterOptionalString.allocationSize(value.`refreshToken`) +
            FfiConverterString.allocationSize(value.`userId`) +
            FfiConverterString.allocationSize(value.`deviceId`) +
            FfiConverterString.allocationSize(value.`homeserverUrl`) +
            FfiConverterOptionalString.allocationSize(value.`oidcData`) +
            FfiConverterOptionalString.allocationSize(value.`slidingSyncProxy`)
    )

    override fun write(value: Session, buf: ByteBuffer) {
            FfiConverterString.write(value.`accessToken`, buf)
            FfiConverterOptionalString.write(value.`refreshToken`, buf)
            FfiConverterString.write(value.`userId`, buf)
            FfiConverterString.write(value.`deviceId`, buf)
            FfiConverterString.write(value.`homeserverUrl`, buf)
            FfiConverterOptionalString.write(value.`oidcData`, buf)
            FfiConverterOptionalString.write(value.`slidingSyncProxy`, buf)
    }
}



data class SetData (
    var `index`: UInt, 
    var `item`: TimelineItem
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`index`, 
        this.`item`)
    }
    
    companion object
}

public object FfiConverterTypeSetData: FfiConverterRustBuffer<SetData> {
    override fun read(buf: ByteBuffer): SetData {
        return SetData(
            FfiConverterUInt.read(buf),
            FfiConverterTypeTimelineItem.read(buf),
        )
    }

    override fun allocationSize(value: SetData) = (
            FfiConverterUInt.allocationSize(value.`index`) +
            FfiConverterTypeTimelineItem.allocationSize(value.`item`)
    )

    override fun write(value: SetData, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`index`, buf)
            FfiConverterTypeTimelineItem.write(value.`item`, buf)
    }
}



data class TextMessageContent (
    var `body`: String, 
    var `formatted`: FormattedBody?
) {
    
    companion object
}

public object FfiConverterTypeTextMessageContent: FfiConverterRustBuffer<TextMessageContent> {
    override fun read(buf: ByteBuffer): TextMessageContent {
        return TextMessageContent(
            FfiConverterString.read(buf),
            FfiConverterOptionalTypeFormattedBody.read(buf),
        )
    }

    override fun allocationSize(value: TextMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterOptionalTypeFormattedBody.allocationSize(value.`formatted`)
    )

    override fun write(value: TextMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterOptionalTypeFormattedBody.write(value.`formatted`, buf)
    }
}



data class ThumbnailInfo (
    var `height`: ULong?, 
    var `width`: ULong?, 
    var `mimetype`: String?, 
    var `size`: ULong?
) {
    
    companion object
}

public object FfiConverterTypeThumbnailInfo: FfiConverterRustBuffer<ThumbnailInfo> {
    override fun read(buf: ByteBuffer): ThumbnailInfo {
        return ThumbnailInfo(
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalULong.read(buf),
        )
    }

    override fun allocationSize(value: ThumbnailInfo) = (
            FfiConverterOptionalULong.allocationSize(value.`height`) +
            FfiConverterOptionalULong.allocationSize(value.`width`) +
            FfiConverterOptionalString.allocationSize(value.`mimetype`) +
            FfiConverterOptionalULong.allocationSize(value.`size`)
    )

    override fun write(value: ThumbnailInfo, buf: ByteBuffer) {
            FfiConverterOptionalULong.write(value.`height`, buf)
            FfiConverterOptionalULong.write(value.`width`, buf)
            FfiConverterOptionalString.write(value.`mimetype`, buf)
            FfiConverterOptionalULong.write(value.`size`, buf)
    }
}



data class TracingConfiguration (
    var `filter`: String, 
    var `writeToStdoutOrSystem`: Boolean, 
    var `writeToFiles`: TracingFileConfiguration?
) {
    
    companion object
}

public object FfiConverterTypeTracingConfiguration: FfiConverterRustBuffer<TracingConfiguration> {
    override fun read(buf: ByteBuffer): TracingConfiguration {
        return TracingConfiguration(
            FfiConverterString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterOptionalTypeTracingFileConfiguration.read(buf),
        )
    }

    override fun allocationSize(value: TracingConfiguration) = (
            FfiConverterString.allocationSize(value.`filter`) +
            FfiConverterBoolean.allocationSize(value.`writeToStdoutOrSystem`) +
            FfiConverterOptionalTypeTracingFileConfiguration.allocationSize(value.`writeToFiles`)
    )

    override fun write(value: TracingConfiguration, buf: ByteBuffer) {
            FfiConverterString.write(value.`filter`, buf)
            FfiConverterBoolean.write(value.`writeToStdoutOrSystem`, buf)
            FfiConverterOptionalTypeTracingFileConfiguration.write(value.`writeToFiles`, buf)
    }
}



data class TracingFileConfiguration (
    var `path`: String, 
    var `filePrefix`: String
) {
    
    companion object
}

public object FfiConverterTypeTracingFileConfiguration: FfiConverterRustBuffer<TracingFileConfiguration> {
    override fun read(buf: ByteBuffer): TracingFileConfiguration {
        return TracingFileConfiguration(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: TracingFileConfiguration) = (
            FfiConverterString.allocationSize(value.`path`) +
            FfiConverterString.allocationSize(value.`filePrefix`)
    )

    override fun write(value: TracingFileConfiguration, buf: ByteBuffer) {
            FfiConverterString.write(value.`path`, buf)
            FfiConverterString.write(value.`filePrefix`, buf)
    }
}



data class TransmissionProgress (
    var `current`: ULong, 
    var `total`: ULong
) {
    
    companion object
}

public object FfiConverterTypeTransmissionProgress: FfiConverterRustBuffer<TransmissionProgress> {
    override fun read(buf: ByteBuffer): TransmissionProgress {
        return TransmissionProgress(
            FfiConverterULong.read(buf),
            FfiConverterULong.read(buf),
        )
    }

    override fun allocationSize(value: TransmissionProgress) = (
            FfiConverterULong.allocationSize(value.`current`) +
            FfiConverterULong.allocationSize(value.`total`)
    )

    override fun write(value: TransmissionProgress, buf: ByteBuffer) {
            FfiConverterULong.write(value.`current`, buf)
            FfiConverterULong.write(value.`total`, buf)
    }
}



data class UnstableAudioDetailsContent (
    var `duration`: java.time.Duration, 
    var `waveform`: List<UShort>
) {
    
    companion object
}

public object FfiConverterTypeUnstableAudioDetailsContent: FfiConverterRustBuffer<UnstableAudioDetailsContent> {
    override fun read(buf: ByteBuffer): UnstableAudioDetailsContent {
        return UnstableAudioDetailsContent(
            FfiConverterDuration.read(buf),
            FfiConverterSequenceUShort.read(buf),
        )
    }

    override fun allocationSize(value: UnstableAudioDetailsContent) = (
            FfiConverterDuration.allocationSize(value.`duration`) +
            FfiConverterSequenceUShort.allocationSize(value.`waveform`)
    )

    override fun write(value: UnstableAudioDetailsContent, buf: ByteBuffer) {
            FfiConverterDuration.write(value.`duration`, buf)
            FfiConverterSequenceUShort.write(value.`waveform`, buf)
    }
}


class UnstableVoiceContent {
    override fun equals(other: Any?): Boolean {
        return other is UnstableVoiceContent
    }

    override fun hashCode(): Int {
        return javaClass.hashCode()
    }

    companion object
}

public object FfiConverterTypeUnstableVoiceContent: FfiConverterRustBuffer<UnstableVoiceContent> {
    override fun read(buf: ByteBuffer): UnstableVoiceContent {
        return UnstableVoiceContent()
    }

    override fun allocationSize(value: UnstableVoiceContent) = 0

    override fun write(value: UnstableVoiceContent, buf: ByteBuffer) {
    }
}



data class UserProfile (
    var `userId`: String, 
    var `displayName`: String?, 
    var `avatarUrl`: String?
) {
    
    companion object
}

public object FfiConverterTypeUserProfile: FfiConverterRustBuffer<UserProfile> {
    override fun read(buf: ByteBuffer): UserProfile {
        return UserProfile(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: UserProfile) = (
            FfiConverterString.allocationSize(value.`userId`) +
            FfiConverterOptionalString.allocationSize(value.`displayName`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`)
    )

    override fun write(value: UserProfile, buf: ByteBuffer) {
            FfiConverterString.write(value.`userId`, buf)
            FfiConverterOptionalString.write(value.`displayName`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
    }
}



data class VideoInfo (
    var `duration`: java.time.Duration?, 
    var `height`: ULong?, 
    var `width`: ULong?, 
    var `mimetype`: String?, 
    var `size`: ULong?, 
    var `thumbnailInfo`: ThumbnailInfo?, 
    var `thumbnailSource`: MediaSource?, 
    var `blurhash`: String?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`duration`, 
        this.`height`, 
        this.`width`, 
        this.`mimetype`, 
        this.`size`, 
        this.`thumbnailInfo`, 
        this.`thumbnailSource`, 
        this.`blurhash`)
    }
    
    companion object
}

public object FfiConverterTypeVideoInfo: FfiConverterRustBuffer<VideoInfo> {
    override fun read(buf: ByteBuffer): VideoInfo {
        return VideoInfo(
            FfiConverterOptionalDuration.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalTypeThumbnailInfo.read(buf),
            FfiConverterOptionalTypeMediaSource.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: VideoInfo) = (
            FfiConverterOptionalDuration.allocationSize(value.`duration`) +
            FfiConverterOptionalULong.allocationSize(value.`height`) +
            FfiConverterOptionalULong.allocationSize(value.`width`) +
            FfiConverterOptionalString.allocationSize(value.`mimetype`) +
            FfiConverterOptionalULong.allocationSize(value.`size`) +
            FfiConverterOptionalTypeThumbnailInfo.allocationSize(value.`thumbnailInfo`) +
            FfiConverterOptionalTypeMediaSource.allocationSize(value.`thumbnailSource`) +
            FfiConverterOptionalString.allocationSize(value.`blurhash`)
    )

    override fun write(value: VideoInfo, buf: ByteBuffer) {
            FfiConverterOptionalDuration.write(value.`duration`, buf)
            FfiConverterOptionalULong.write(value.`height`, buf)
            FfiConverterOptionalULong.write(value.`width`, buf)
            FfiConverterOptionalString.write(value.`mimetype`, buf)
            FfiConverterOptionalULong.write(value.`size`, buf)
            FfiConverterOptionalTypeThumbnailInfo.write(value.`thumbnailInfo`, buf)
            FfiConverterOptionalTypeMediaSource.write(value.`thumbnailSource`, buf)
            FfiConverterOptionalString.write(value.`blurhash`, buf)
    }
}



data class VideoMessageContent (
    var `body`: String, 
    var `source`: MediaSource, 
    var `info`: VideoInfo?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`body`, 
        this.`source`, 
        this.`info`)
    }
    
    companion object
}

public object FfiConverterTypeVideoMessageContent: FfiConverterRustBuffer<VideoMessageContent> {
    override fun read(buf: ByteBuffer): VideoMessageContent {
        return VideoMessageContent(
            FfiConverterString.read(buf),
            FfiConverterTypeMediaSource.read(buf),
            FfiConverterOptionalTypeVideoInfo.read(buf),
        )
    }

    override fun allocationSize(value: VideoMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterTypeMediaSource.allocationSize(value.`source`) +
            FfiConverterOptionalTypeVideoInfo.allocationSize(value.`info`)
    )

    override fun write(value: VideoMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterTypeMediaSource.write(value.`source`, buf)
            FfiConverterOptionalTypeVideoInfo.write(value.`info`, buf)
    }
}



data class VirtualElementCallWidgetOptions (
    var `elementCallUrl`: String, 
    var `widgetId`: String, 
    var `parentUrl`: String?, 
    var `hideHeader`: Boolean?, 
    var `preload`: Boolean?, 
    var `fontScale`: Double?, 
    var `appPrompt`: Boolean?, 
    var `skipLobby`: Boolean?, 
    var `confineToRoom`: Boolean?, 
    var `font`: String?, 
    var `analyticsId`: String?, 
    var `encryption`: EncryptionSystem
) {
    
    companion object
}

public object FfiConverterTypeVirtualElementCallWidgetOptions: FfiConverterRustBuffer<VirtualElementCallWidgetOptions> {
    override fun read(buf: ByteBuffer): VirtualElementCallWidgetOptions {
        return VirtualElementCallWidgetOptions(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterOptionalDouble.read(buf),
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterTypeEncryptionSystem.read(buf),
        )
    }

    override fun allocationSize(value: VirtualElementCallWidgetOptions) = (
            FfiConverterString.allocationSize(value.`elementCallUrl`) +
            FfiConverterString.allocationSize(value.`widgetId`) +
            FfiConverterOptionalString.allocationSize(value.`parentUrl`) +
            FfiConverterOptionalBoolean.allocationSize(value.`hideHeader`) +
            FfiConverterOptionalBoolean.allocationSize(value.`preload`) +
            FfiConverterOptionalDouble.allocationSize(value.`fontScale`) +
            FfiConverterOptionalBoolean.allocationSize(value.`appPrompt`) +
            FfiConverterOptionalBoolean.allocationSize(value.`skipLobby`) +
            FfiConverterOptionalBoolean.allocationSize(value.`confineToRoom`) +
            FfiConverterOptionalString.allocationSize(value.`font`) +
            FfiConverterOptionalString.allocationSize(value.`analyticsId`) +
            FfiConverterTypeEncryptionSystem.allocationSize(value.`encryption`)
    )

    override fun write(value: VirtualElementCallWidgetOptions, buf: ByteBuffer) {
            FfiConverterString.write(value.`elementCallUrl`, buf)
            FfiConverterString.write(value.`widgetId`, buf)
            FfiConverterOptionalString.write(value.`parentUrl`, buf)
            FfiConverterOptionalBoolean.write(value.`hideHeader`, buf)
            FfiConverterOptionalBoolean.write(value.`preload`, buf)
            FfiConverterOptionalDouble.write(value.`fontScale`, buf)
            FfiConverterOptionalBoolean.write(value.`appPrompt`, buf)
            FfiConverterOptionalBoolean.write(value.`skipLobby`, buf)
            FfiConverterOptionalBoolean.write(value.`confineToRoom`, buf)
            FfiConverterOptionalString.write(value.`font`, buf)
            FfiConverterOptionalString.write(value.`analyticsId`, buf)
            FfiConverterTypeEncryptionSystem.write(value.`encryption`, buf)
    }
}



data class WidgetCapabilities (
    var `read`: List<WidgetEventFilter>, 
    var `send`: List<WidgetEventFilter>, 
    var `requiresClient`: Boolean
) {
    
    companion object
}

public object FfiConverterTypeWidgetCapabilities: FfiConverterRustBuffer<WidgetCapabilities> {
    override fun read(buf: ByteBuffer): WidgetCapabilities {
        return WidgetCapabilities(
            FfiConverterSequenceTypeWidgetEventFilter.read(buf),
            FfiConverterSequenceTypeWidgetEventFilter.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: WidgetCapabilities) = (
            FfiConverterSequenceTypeWidgetEventFilter.allocationSize(value.`read`) +
            FfiConverterSequenceTypeWidgetEventFilter.allocationSize(value.`send`) +
            FfiConverterBoolean.allocationSize(value.`requiresClient`)
    )

    override fun write(value: WidgetCapabilities, buf: ByteBuffer) {
            FfiConverterSequenceTypeWidgetEventFilter.write(value.`read`, buf)
            FfiConverterSequenceTypeWidgetEventFilter.write(value.`send`, buf)
            FfiConverterBoolean.write(value.`requiresClient`, buf)
    }
}



data class WidgetDriverAndHandle (
    var `driver`: WidgetDriver, 
    var `handle`: WidgetDriverHandle
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`driver`, 
        this.`handle`)
    }
    
    companion object
}

public object FfiConverterTypeWidgetDriverAndHandle: FfiConverterRustBuffer<WidgetDriverAndHandle> {
    override fun read(buf: ByteBuffer): WidgetDriverAndHandle {
        return WidgetDriverAndHandle(
            FfiConverterTypeWidgetDriver.read(buf),
            FfiConverterTypeWidgetDriverHandle.read(buf),
        )
    }

    override fun allocationSize(value: WidgetDriverAndHandle) = (
            FfiConverterTypeWidgetDriver.allocationSize(value.`driver`) +
            FfiConverterTypeWidgetDriverHandle.allocationSize(value.`handle`)
    )

    override fun write(value: WidgetDriverAndHandle, buf: ByteBuffer) {
            FfiConverterTypeWidgetDriver.write(value.`driver`, buf)
            FfiConverterTypeWidgetDriverHandle.write(value.`handle`, buf)
    }
}



data class WidgetSettings (
    var `widgetId`: String, 
    var `initAfterContentLoad`: Boolean, 
    var `rawUrl`: String
) {
    
    companion object
}

public object FfiConverterTypeWidgetSettings: FfiConverterRustBuffer<WidgetSettings> {
    override fun read(buf: ByteBuffer): WidgetSettings {
        return WidgetSettings(
            FfiConverterString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: WidgetSettings) = (
            FfiConverterString.allocationSize(value.`widgetId`) +
            FfiConverterBoolean.allocationSize(value.`initAfterContentLoad`) +
            FfiConverterString.allocationSize(value.`rawUrl`)
    )

    override fun write(value: WidgetSettings, buf: ByteBuffer) {
            FfiConverterString.write(value.`widgetId`, buf)
            FfiConverterBoolean.write(value.`initAfterContentLoad`, buf)
            FfiConverterString.write(value.`rawUrl`, buf)
    }
}




sealed class AccountManagementAction {
    object Profile : AccountManagementAction()
    
    object SessionsList : AccountManagementAction()
    
    data class SessionView(
        val `deviceId`: String
        ) : AccountManagementAction() {
        companion object
    }
    data class SessionEnd(
        val `deviceId`: String
        ) : AccountManagementAction() {
        companion object
    }
    

    
    companion object
}

public object FfiConverterTypeAccountManagementAction : FfiConverterRustBuffer<AccountManagementAction>{
    override fun read(buf: ByteBuffer): AccountManagementAction {
        return when(buf.getInt()) {
            1 -> AccountManagementAction.Profile
            2 -> AccountManagementAction.SessionsList
            3 -> AccountManagementAction.SessionView(
                FfiConverterString.read(buf),
                )
            4 -> AccountManagementAction.SessionEnd(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: AccountManagementAction) = when(value) {
        is AccountManagementAction.Profile -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is AccountManagementAction.SessionsList -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is AccountManagementAction.SessionView -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`deviceId`)
            )
        }
        is AccountManagementAction.SessionEnd -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`deviceId`)
            )
        }
    }

    override fun write(value: AccountManagementAction, buf: ByteBuffer) {
        when(value) {
            is AccountManagementAction.Profile -> {
                buf.putInt(1)
                Unit
            }
            is AccountManagementAction.SessionsList -> {
                buf.putInt(2)
                Unit
            }
            is AccountManagementAction.SessionView -> {
                buf.putInt(3)
                FfiConverterString.write(value.`deviceId`, buf)
                Unit
            }
            is AccountManagementAction.SessionEnd -> {
                buf.putInt(4)
                FfiConverterString.write(value.`deviceId`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class AssetType {
    SENDER,PIN;
    companion object
}

public object FfiConverterTypeAssetType: FfiConverterRustBuffer<AssetType> {
    override fun read(buf: ByteBuffer) = try {
        AssetType.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: AssetType) = 4

    override fun write(value: AssetType, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}







sealed class AuthenticationException(message: String): Exception(message) {
        // Each variant is a nested class
        // Flat enums carries a string error message, so no special implementation is necessary.
        class ClientMissing(message: String) : AuthenticationException(message)
        class InvalidServerName(message: String) : AuthenticationException(message)
        class SlidingSyncNotAvailable(message: String) : AuthenticationException(message)
        class SessionMissing(message: String) : AuthenticationException(message)
        class InvalidBasePath(message: String) : AuthenticationException(message)
        class OidcNotSupported(message: String) : AuthenticationException(message)
        class OidcMetadataMissing(message: String) : AuthenticationException(message)
        class OidcMetadataInvalid(message: String) : AuthenticationException(message)
        class OidcCallbackUrlInvalid(message: String) : AuthenticationException(message)
        class OidcCancelled(message: String) : AuthenticationException(message)
        class OidcException(message: String) : AuthenticationException(message)
        class Generic(message: String) : AuthenticationException(message)
        

    companion object ErrorHandler : CallStatusErrorHandler<AuthenticationException> {
        override fun lift(error_buf: RustBuffer.ByValue): AuthenticationException = FfiConverterTypeAuthenticationError.lift(error_buf)
    }
}

public object FfiConverterTypeAuthenticationError : FfiConverterRustBuffer<AuthenticationException> {
    override fun read(buf: ByteBuffer): AuthenticationException {
        
            return when(buf.getInt()) {
            1 -> AuthenticationException.ClientMissing(FfiConverterString.read(buf))
            2 -> AuthenticationException.InvalidServerName(FfiConverterString.read(buf))
            3 -> AuthenticationException.SlidingSyncNotAvailable(FfiConverterString.read(buf))
            4 -> AuthenticationException.SessionMissing(FfiConverterString.read(buf))
            5 -> AuthenticationException.InvalidBasePath(FfiConverterString.read(buf))
            6 -> AuthenticationException.OidcNotSupported(FfiConverterString.read(buf))
            7 -> AuthenticationException.OidcMetadataMissing(FfiConverterString.read(buf))
            8 -> AuthenticationException.OidcMetadataInvalid(FfiConverterString.read(buf))
            9 -> AuthenticationException.OidcCallbackUrlInvalid(FfiConverterString.read(buf))
            10 -> AuthenticationException.OidcCancelled(FfiConverterString.read(buf))
            11 -> AuthenticationException.OidcException(FfiConverterString.read(buf))
            12 -> AuthenticationException.Generic(FfiConverterString.read(buf))
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
        
    }

    override fun allocationSize(value: AuthenticationException): Int {
        return 4
    }

    override fun write(value: AuthenticationException, buf: ByteBuffer) {
        when(value) {
            is AuthenticationException.ClientMissing -> {
                buf.putInt(1)
                Unit
            }
            is AuthenticationException.InvalidServerName -> {
                buf.putInt(2)
                Unit
            }
            is AuthenticationException.SlidingSyncNotAvailable -> {
                buf.putInt(3)
                Unit
            }
            is AuthenticationException.SessionMissing -> {
                buf.putInt(4)
                Unit
            }
            is AuthenticationException.InvalidBasePath -> {
                buf.putInt(5)
                Unit
            }
            is AuthenticationException.OidcNotSupported -> {
                buf.putInt(6)
                Unit
            }
            is AuthenticationException.OidcMetadataMissing -> {
                buf.putInt(7)
                Unit
            }
            is AuthenticationException.OidcMetadataInvalid -> {
                buf.putInt(8)
                Unit
            }
            is AuthenticationException.OidcCallbackUrlInvalid -> {
                buf.putInt(9)
                Unit
            }
            is AuthenticationException.OidcCancelled -> {
                buf.putInt(10)
                Unit
            }
            is AuthenticationException.OidcException -> {
                buf.putInt(11)
                Unit
            }
            is AuthenticationException.Generic -> {
                buf.putInt(12)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




enum class BackPaginationStatus {
    IDLE,PAGINATING,TIMELINE_START_REACHED;
    companion object
}

public object FfiConverterTypeBackPaginationStatus: FfiConverterRustBuffer<BackPaginationStatus> {
    override fun read(buf: ByteBuffer) = try {
        BackPaginationStatus.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: BackPaginationStatus) = 4

    override fun write(value: BackPaginationStatus, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class BackupState {
    UNKNOWN,CREATING,ENABLING,RESUMING,ENABLED,DOWNLOADING,DISABLING;
    companion object
}

public object FfiConverterTypeBackupState: FfiConverterRustBuffer<BackupState> {
    override fun read(buf: ByteBuffer) = try {
        BackupState.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: BackupState) = 4

    override fun write(value: BackupState, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






sealed class BackupUploadState {
    object Waiting : BackupUploadState()
    
    data class Uploading(
        val `backedUpCount`: UInt, 
        val `totalCount`: UInt
        ) : BackupUploadState() {
        companion object
    }
    object Error : BackupUploadState()
    
    object Done : BackupUploadState()
    
    

    
    companion object
}

public object FfiConverterTypeBackupUploadState : FfiConverterRustBuffer<BackupUploadState>{
    override fun read(buf: ByteBuffer): BackupUploadState {
        return when(buf.getInt()) {
            1 -> BackupUploadState.Waiting
            2 -> BackupUploadState.Uploading(
                FfiConverterUInt.read(buf),
                FfiConverterUInt.read(buf),
                )
            3 -> BackupUploadState.Error
            4 -> BackupUploadState.Done
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: BackupUploadState) = when(value) {
        is BackupUploadState.Waiting -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is BackupUploadState.Uploading -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterUInt.allocationSize(value.`backedUpCount`)
                + FfiConverterUInt.allocationSize(value.`totalCount`)
            )
        }
        is BackupUploadState.Error -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is BackupUploadState.Done -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
    }

    override fun write(value: BackupUploadState, buf: ByteBuffer) {
        when(value) {
            is BackupUploadState.Waiting -> {
                buf.putInt(1)
                Unit
            }
            is BackupUploadState.Uploading -> {
                buf.putInt(2)
                FfiConverterUInt.write(value.`backedUpCount`, buf)
                FfiConverterUInt.write(value.`totalCount`, buf)
                Unit
            }
            is BackupUploadState.Error -> {
                buf.putInt(3)
                Unit
            }
            is BackupUploadState.Done -> {
                buf.putInt(4)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}







sealed class ClientException: Exception() {
    // Each variant is a nested class
    
    class Generic(
        val `msg`: String
        ) : ClientException() {
        override val message
            get() = "msg=${ `msg` }"
    }
    

    companion object ErrorHandler : CallStatusErrorHandler<ClientException> {
        override fun lift(error_buf: RustBuffer.ByValue): ClientException = FfiConverterTypeClientError.lift(error_buf)
    }

    
}

public object FfiConverterTypeClientError : FfiConverterRustBuffer<ClientException> {
    override fun read(buf: ByteBuffer): ClientException {
        

        return when(buf.getInt()) {
            1 -> ClientException.Generic(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: ClientException): Int {
        return when(value) {
            is ClientException.Generic -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`msg`)
            )
        }
    }

    override fun write(value: ClientException, buf: ByteBuffer) {
        when(value) {
            is ClientException.Generic -> {
                buf.putInt(1)
                FfiConverterString.write(value.`msg`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




sealed class EnableRecoveryProgress {
    object Starting : EnableRecoveryProgress()
    
    object CreatingBackup : EnableRecoveryProgress()
    
    object CreatingRecoveryKey : EnableRecoveryProgress()
    
    data class BackingUp(
        val `backedUpCount`: UInt, 
        val `totalCount`: UInt
        ) : EnableRecoveryProgress() {
        companion object
    }
    object RoomKeyUploadError : EnableRecoveryProgress()
    
    data class Done(
        val `recoveryKey`: String
        ) : EnableRecoveryProgress() {
        companion object
    }
    

    
    companion object
}

public object FfiConverterTypeEnableRecoveryProgress : FfiConverterRustBuffer<EnableRecoveryProgress>{
    override fun read(buf: ByteBuffer): EnableRecoveryProgress {
        return when(buf.getInt()) {
            1 -> EnableRecoveryProgress.Starting
            2 -> EnableRecoveryProgress.CreatingBackup
            3 -> EnableRecoveryProgress.CreatingRecoveryKey
            4 -> EnableRecoveryProgress.BackingUp(
                FfiConverterUInt.read(buf),
                FfiConverterUInt.read(buf),
                )
            5 -> EnableRecoveryProgress.RoomKeyUploadError
            6 -> EnableRecoveryProgress.Done(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: EnableRecoveryProgress) = when(value) {
        is EnableRecoveryProgress.Starting -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is EnableRecoveryProgress.CreatingBackup -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is EnableRecoveryProgress.CreatingRecoveryKey -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is EnableRecoveryProgress.BackingUp -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterUInt.allocationSize(value.`backedUpCount`)
                + FfiConverterUInt.allocationSize(value.`totalCount`)
            )
        }
        is EnableRecoveryProgress.RoomKeyUploadError -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is EnableRecoveryProgress.Done -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`recoveryKey`)
            )
        }
    }

    override fun write(value: EnableRecoveryProgress, buf: ByteBuffer) {
        when(value) {
            is EnableRecoveryProgress.Starting -> {
                buf.putInt(1)
                Unit
            }
            is EnableRecoveryProgress.CreatingBackup -> {
                buf.putInt(2)
                Unit
            }
            is EnableRecoveryProgress.CreatingRecoveryKey -> {
                buf.putInt(3)
                Unit
            }
            is EnableRecoveryProgress.BackingUp -> {
                buf.putInt(4)
                FfiConverterUInt.write(value.`backedUpCount`, buf)
                FfiConverterUInt.write(value.`totalCount`, buf)
                Unit
            }
            is EnableRecoveryProgress.RoomKeyUploadError -> {
                buf.putInt(5)
                Unit
            }
            is EnableRecoveryProgress.Done -> {
                buf.putInt(6)
                FfiConverterString.write(value.`recoveryKey`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class EncryptedMessage {
    data class OlmV1Curve25519AesSha2(
        val `senderKey`: String
        ) : EncryptedMessage() {
        companion object
    }
    data class MegolmV1AesSha2(
        val `sessionId`: String
        ) : EncryptedMessage() {
        companion object
    }
    object Unknown : EncryptedMessage()
    
    

    
    companion object
}

public object FfiConverterTypeEncryptedMessage : FfiConverterRustBuffer<EncryptedMessage>{
    override fun read(buf: ByteBuffer): EncryptedMessage {
        return when(buf.getInt()) {
            1 -> EncryptedMessage.OlmV1Curve25519AesSha2(
                FfiConverterString.read(buf),
                )
            2 -> EncryptedMessage.MegolmV1AesSha2(
                FfiConverterString.read(buf),
                )
            3 -> EncryptedMessage.Unknown
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: EncryptedMessage) = when(value) {
        is EncryptedMessage.OlmV1Curve25519AesSha2 -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`senderKey`)
            )
        }
        is EncryptedMessage.MegolmV1AesSha2 -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`sessionId`)
            )
        }
        is EncryptedMessage.Unknown -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
    }

    override fun write(value: EncryptedMessage, buf: ByteBuffer) {
        when(value) {
            is EncryptedMessage.OlmV1Curve25519AesSha2 -> {
                buf.putInt(1)
                FfiConverterString.write(value.`senderKey`, buf)
                Unit
            }
            is EncryptedMessage.MegolmV1AesSha2 -> {
                buf.putInt(2)
                FfiConverterString.write(value.`sessionId`, buf)
                Unit
            }
            is EncryptedMessage.Unknown -> {
                buf.putInt(3)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class EncryptionSystem {
    object Unencrypted : EncryptionSystem()
    
    object PerParticipantKeys : EncryptionSystem()
    
    data class SharedSecret(
        val `secret`: String
        ) : EncryptionSystem() {
        companion object
    }
    

    
    companion object
}

public object FfiConverterTypeEncryptionSystem : FfiConverterRustBuffer<EncryptionSystem>{
    override fun read(buf: ByteBuffer): EncryptionSystem {
        return when(buf.getInt()) {
            1 -> EncryptionSystem.Unencrypted
            2 -> EncryptionSystem.PerParticipantKeys
            3 -> EncryptionSystem.SharedSecret(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: EncryptionSystem) = when(value) {
        is EncryptionSystem.Unencrypted -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is EncryptionSystem.PerParticipantKeys -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is EncryptionSystem.SharedSecret -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`secret`)
            )
        }
    }

    override fun write(value: EncryptionSystem, buf: ByteBuffer) {
        when(value) {
            is EncryptionSystem.Unencrypted -> {
                buf.putInt(1)
                Unit
            }
            is EncryptionSystem.PerParticipantKeys -> {
                buf.putInt(2)
                Unit
            }
            is EncryptionSystem.SharedSecret -> {
                buf.putInt(3)
                FfiConverterString.write(value.`secret`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class EventItemOrigin {
    LOCAL,SYNC,PAGINATION;
    companion object
}

public object FfiConverterTypeEventItemOrigin: FfiConverterRustBuffer<EventItemOrigin> {
    override fun read(buf: ByteBuffer) = try {
        EventItemOrigin.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: EventItemOrigin) = 4

    override fun write(value: EventItemOrigin, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






sealed class EventSendState {
    object NotSentYet : EventSendState()
    
    data class SendingFailed(
        val `error`: String
        ) : EventSendState() {
        companion object
    }
    object Cancelled : EventSendState()
    
    data class Sent(
        val `eventId`: String
        ) : EventSendState() {
        companion object
    }
    

    
    companion object
}

public object FfiConverterTypeEventSendState : FfiConverterRustBuffer<EventSendState>{
    override fun read(buf: ByteBuffer): EventSendState {
        return when(buf.getInt()) {
            1 -> EventSendState.NotSentYet
            2 -> EventSendState.SendingFailed(
                FfiConverterString.read(buf),
                )
            3 -> EventSendState.Cancelled
            4 -> EventSendState.Sent(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: EventSendState) = when(value) {
        is EventSendState.NotSentYet -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is EventSendState.SendingFailed -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`error`)
            )
        }
        is EventSendState.Cancelled -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is EventSendState.Sent -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`eventId`)
            )
        }
    }

    override fun write(value: EventSendState, buf: ByteBuffer) {
        when(value) {
            is EventSendState.NotSentYet -> {
                buf.putInt(1)
                Unit
            }
            is EventSendState.SendingFailed -> {
                buf.putInt(2)
                FfiConverterString.write(value.`error`, buf)
                Unit
            }
            is EventSendState.Cancelled -> {
                buf.putInt(3)
                Unit
            }
            is EventSendState.Sent -> {
                buf.putInt(4)
                FfiConverterString.write(value.`eventId`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class LogLevel {
    ERROR,WARN,INFO,DEBUG,TRACE;
    companion object
}

public object FfiConverterTypeLogLevel: FfiConverterRustBuffer<LogLevel> {
    override fun read(buf: ByteBuffer) = try {
        LogLevel.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: LogLevel) = 4

    override fun write(value: LogLevel, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}







sealed class MediaInfoException(message: String): Exception(message) {
        // Each variant is a nested class
        // Flat enums carries a string error message, so no special implementation is necessary.
        class MissingField(message: String) : MediaInfoException(message)
        class InvalidField(message: String) : MediaInfoException(message)
        

    companion object ErrorHandler : CallStatusErrorHandler<MediaInfoException> {
        override fun lift(error_buf: RustBuffer.ByValue): MediaInfoException = FfiConverterTypeMediaInfoError.lift(error_buf)
    }
}

public object FfiConverterTypeMediaInfoError : FfiConverterRustBuffer<MediaInfoException> {
    override fun read(buf: ByteBuffer): MediaInfoException {
        
            return when(buf.getInt()) {
            1 -> MediaInfoException.MissingField(FfiConverterString.read(buf))
            2 -> MediaInfoException.InvalidField(FfiConverterString.read(buf))
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
        
    }

    override fun allocationSize(value: MediaInfoException): Int {
        return 4
    }

    override fun write(value: MediaInfoException, buf: ByteBuffer) {
        when(value) {
            is MediaInfoException.MissingField -> {
                buf.putInt(1)
                Unit
            }
            is MediaInfoException.InvalidField -> {
                buf.putInt(2)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




enum class Membership {
    INVITED,JOINED,LEFT;
    companion object
}

public object FfiConverterTypeMembership: FfiConverterRustBuffer<Membership> {
    override fun read(buf: ByteBuffer) = try {
        Membership.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: Membership) = 4

    override fun write(value: Membership, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class MembershipChange {
    NONE,ERROR,JOINED,LEFT,BANNED,UNBANNED,KICKED,INVITED,KICKED_AND_BANNED,INVITATION_ACCEPTED,INVITATION_REJECTED,INVITATION_REVOKED,KNOCKED,KNOCK_ACCEPTED,KNOCK_RETRACTED,KNOCK_DENIED,NOT_IMPLEMENTED;
    companion object
}

public object FfiConverterTypeMembershipChange: FfiConverterRustBuffer<MembershipChange> {
    override fun read(buf: ByteBuffer) = try {
        MembershipChange.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: MembershipChange) = 4

    override fun write(value: MembershipChange, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class MembershipState {
    BAN,INVITE,JOIN,KNOCK,LEAVE;
    companion object
}

public object FfiConverterTypeMembershipState: FfiConverterRustBuffer<MembershipState> {
    override fun read(buf: ByteBuffer) = try {
        MembershipState.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: MembershipState) = 4

    override fun write(value: MembershipState, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






sealed class MessageFormat {
    object Html : MessageFormat()
    
    data class Unknown(
        val `format`: String
        ) : MessageFormat() {
        companion object
    }
    

    
    companion object
}

public object FfiConverterTypeMessageFormat : FfiConverterRustBuffer<MessageFormat>{
    override fun read(buf: ByteBuffer): MessageFormat {
        return when(buf.getInt()) {
            1 -> MessageFormat.Html
            2 -> MessageFormat.Unknown(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: MessageFormat) = when(value) {
        is MessageFormat.Html -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageFormat.Unknown -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`format`)
            )
        }
    }

    override fun write(value: MessageFormat, buf: ByteBuffer) {
        when(value) {
            is MessageFormat.Html -> {
                buf.putInt(1)
                Unit
            }
            is MessageFormat.Unknown -> {
                buf.putInt(2)
                FfiConverterString.write(value.`format`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class MessageLikeEventContent: Disposable  {
    object CallAnswer : MessageLikeEventContent()
    
    object CallInvite : MessageLikeEventContent()
    
    object CallHangup : MessageLikeEventContent()
    
    object CallCandidates : MessageLikeEventContent()
    
    object KeyVerificationReady : MessageLikeEventContent()
    
    object KeyVerificationStart : MessageLikeEventContent()
    
    object KeyVerificationCancel : MessageLikeEventContent()
    
    object KeyVerificationAccept : MessageLikeEventContent()
    
    object KeyVerificationKey : MessageLikeEventContent()
    
    object KeyVerificationMac : MessageLikeEventContent()
    
    object KeyVerificationDone : MessageLikeEventContent()
    
    data class Poll(
        val `question`: String
        ) : MessageLikeEventContent() {
        companion object
    }
    data class ReactionContent(
        val `relatedEventId`: String
        ) : MessageLikeEventContent() {
        companion object
    }
    object RoomEncrypted : MessageLikeEventContent()
    
    data class RoomMessage(
        val `messageType`: MessageType, 
        val `inReplyToEventId`: String?
        ) : MessageLikeEventContent() {
        companion object
    }
    object RoomRedaction : MessageLikeEventContent()
    
    object Sticker : MessageLikeEventContent()
    
    

    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        when(this) {
            is MessageLikeEventContent.CallAnswer -> {// Nothing to destroy
            }
            is MessageLikeEventContent.CallInvite -> {// Nothing to destroy
            }
            is MessageLikeEventContent.CallHangup -> {// Nothing to destroy
            }
            is MessageLikeEventContent.CallCandidates -> {// Nothing to destroy
            }
            is MessageLikeEventContent.KeyVerificationReady -> {// Nothing to destroy
            }
            is MessageLikeEventContent.KeyVerificationStart -> {// Nothing to destroy
            }
            is MessageLikeEventContent.KeyVerificationCancel -> {// Nothing to destroy
            }
            is MessageLikeEventContent.KeyVerificationAccept -> {// Nothing to destroy
            }
            is MessageLikeEventContent.KeyVerificationKey -> {// Nothing to destroy
            }
            is MessageLikeEventContent.KeyVerificationMac -> {// Nothing to destroy
            }
            is MessageLikeEventContent.KeyVerificationDone -> {// Nothing to destroy
            }
            is MessageLikeEventContent.Poll -> {
                
    Disposable.destroy(
        this.`question`)
                
            }
            is MessageLikeEventContent.ReactionContent -> {
                
    Disposable.destroy(
        this.`relatedEventId`)
                
            }
            is MessageLikeEventContent.RoomEncrypted -> {// Nothing to destroy
            }
            is MessageLikeEventContent.RoomMessage -> {
                
    Disposable.destroy(
        this.`messageType`, 
        this.`inReplyToEventId`)
                
            }
            is MessageLikeEventContent.RoomRedaction -> {// Nothing to destroy
            }
            is MessageLikeEventContent.Sticker -> {// Nothing to destroy
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
    
    companion object
}

public object FfiConverterTypeMessageLikeEventContent : FfiConverterRustBuffer<MessageLikeEventContent>{
    override fun read(buf: ByteBuffer): MessageLikeEventContent {
        return when(buf.getInt()) {
            1 -> MessageLikeEventContent.CallAnswer
            2 -> MessageLikeEventContent.CallInvite
            3 -> MessageLikeEventContent.CallHangup
            4 -> MessageLikeEventContent.CallCandidates
            5 -> MessageLikeEventContent.KeyVerificationReady
            6 -> MessageLikeEventContent.KeyVerificationStart
            7 -> MessageLikeEventContent.KeyVerificationCancel
            8 -> MessageLikeEventContent.KeyVerificationAccept
            9 -> MessageLikeEventContent.KeyVerificationKey
            10 -> MessageLikeEventContent.KeyVerificationMac
            11 -> MessageLikeEventContent.KeyVerificationDone
            12 -> MessageLikeEventContent.Poll(
                FfiConverterString.read(buf),
                )
            13 -> MessageLikeEventContent.ReactionContent(
                FfiConverterString.read(buf),
                )
            14 -> MessageLikeEventContent.RoomEncrypted
            15 -> MessageLikeEventContent.RoomMessage(
                FfiConverterTypeMessageType.read(buf),
                FfiConverterOptionalString.read(buf),
                )
            16 -> MessageLikeEventContent.RoomRedaction
            17 -> MessageLikeEventContent.Sticker
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: MessageLikeEventContent) = when(value) {
        is MessageLikeEventContent.CallAnswer -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.CallInvite -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.CallHangup -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.CallCandidates -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.KeyVerificationReady -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.KeyVerificationStart -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.KeyVerificationCancel -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.KeyVerificationAccept -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.KeyVerificationKey -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.KeyVerificationMac -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.KeyVerificationDone -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.Poll -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`question`)
            )
        }
        is MessageLikeEventContent.ReactionContent -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`relatedEventId`)
            )
        }
        is MessageLikeEventContent.RoomEncrypted -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.RoomMessage -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeMessageType.allocationSize(value.`messageType`)
                + FfiConverterOptionalString.allocationSize(value.`inReplyToEventId`)
            )
        }
        is MessageLikeEventContent.RoomRedaction -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is MessageLikeEventContent.Sticker -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
    }

    override fun write(value: MessageLikeEventContent, buf: ByteBuffer) {
        when(value) {
            is MessageLikeEventContent.CallAnswer -> {
                buf.putInt(1)
                Unit
            }
            is MessageLikeEventContent.CallInvite -> {
                buf.putInt(2)
                Unit
            }
            is MessageLikeEventContent.CallHangup -> {
                buf.putInt(3)
                Unit
            }
            is MessageLikeEventContent.CallCandidates -> {
                buf.putInt(4)
                Unit
            }
            is MessageLikeEventContent.KeyVerificationReady -> {
                buf.putInt(5)
                Unit
            }
            is MessageLikeEventContent.KeyVerificationStart -> {
                buf.putInt(6)
                Unit
            }
            is MessageLikeEventContent.KeyVerificationCancel -> {
                buf.putInt(7)
                Unit
            }
            is MessageLikeEventContent.KeyVerificationAccept -> {
                buf.putInt(8)
                Unit
            }
            is MessageLikeEventContent.KeyVerificationKey -> {
                buf.putInt(9)
                Unit
            }
            is MessageLikeEventContent.KeyVerificationMac -> {
                buf.putInt(10)
                Unit
            }
            is MessageLikeEventContent.KeyVerificationDone -> {
                buf.putInt(11)
                Unit
            }
            is MessageLikeEventContent.Poll -> {
                buf.putInt(12)
                FfiConverterString.write(value.`question`, buf)
                Unit
            }
            is MessageLikeEventContent.ReactionContent -> {
                buf.putInt(13)
                FfiConverterString.write(value.`relatedEventId`, buf)
                Unit
            }
            is MessageLikeEventContent.RoomEncrypted -> {
                buf.putInt(14)
                Unit
            }
            is MessageLikeEventContent.RoomMessage -> {
                buf.putInt(15)
                FfiConverterTypeMessageType.write(value.`messageType`, buf)
                FfiConverterOptionalString.write(value.`inReplyToEventId`, buf)
                Unit
            }
            is MessageLikeEventContent.RoomRedaction -> {
                buf.putInt(16)
                Unit
            }
            is MessageLikeEventContent.Sticker -> {
                buf.putInt(17)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class MessageLikeEventType {
    CALL_ANSWER,CALL_INVITE,CALL_HANGUP,CALL_CANDIDATES,KEY_VERIFICATION_READY,KEY_VERIFICATION_START,KEY_VERIFICATION_CANCEL,KEY_VERIFICATION_ACCEPT,KEY_VERIFICATION_KEY,KEY_VERIFICATION_MAC,KEY_VERIFICATION_DONE,REACTION_SENT,ROOM_ENCRYPTED,ROOM_MESSAGE,ROOM_REDACTION,STICKER;
    companion object
}

public object FfiConverterTypeMessageLikeEventType: FfiConverterRustBuffer<MessageLikeEventType> {
    override fun read(buf: ByteBuffer) = try {
        MessageLikeEventType.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: MessageLikeEventType) = 4

    override fun write(value: MessageLikeEventType, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






sealed class MessageType: Disposable  {
    data class Emote(
        val `content`: EmoteMessageContent
        ) : MessageType() {
        companion object
    }
    data class Image(
        val `content`: ImageMessageContent
        ) : MessageType() {
        companion object
    }
    data class Audio(
        val `content`: AudioMessageContent
        ) : MessageType() {
        companion object
    }
    data class Video(
        val `content`: VideoMessageContent
        ) : MessageType() {
        companion object
    }
    data class File(
        val `content`: FileMessageContent
        ) : MessageType() {
        companion object
    }
    data class Notice(
        val `content`: NoticeMessageContent
        ) : MessageType() {
        companion object
    }
    data class Text(
        val `content`: TextMessageContent
        ) : MessageType() {
        companion object
    }
    data class Location(
        val `content`: LocationContent
        ) : MessageType() {
        companion object
    }
    data class Other(
        val `msgtype`: String, 
        val `body`: String
        ) : MessageType() {
        companion object
    }
    

    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        when(this) {
            is MessageType.Emote -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.Image -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.Audio -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.Video -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.File -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.Notice -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.Text -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.Location -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is MessageType.Other -> {
                
    Disposable.destroy(
        this.`msgtype`, 
        this.`body`)
                
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
    
    companion object
}

public object FfiConverterTypeMessageType : FfiConverterRustBuffer<MessageType>{
    override fun read(buf: ByteBuffer): MessageType {
        return when(buf.getInt()) {
            1 -> MessageType.Emote(
                FfiConverterTypeEmoteMessageContent.read(buf),
                )
            2 -> MessageType.Image(
                FfiConverterTypeImageMessageContent.read(buf),
                )
            3 -> MessageType.Audio(
                FfiConverterTypeAudioMessageContent.read(buf),
                )
            4 -> MessageType.Video(
                FfiConverterTypeVideoMessageContent.read(buf),
                )
            5 -> MessageType.File(
                FfiConverterTypeFileMessageContent.read(buf),
                )
            6 -> MessageType.Notice(
                FfiConverterTypeNoticeMessageContent.read(buf),
                )
            7 -> MessageType.Text(
                FfiConverterTypeTextMessageContent.read(buf),
                )
            8 -> MessageType.Location(
                FfiConverterTypeLocationContent.read(buf),
                )
            9 -> MessageType.Other(
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: MessageType) = when(value) {
        is MessageType.Emote -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeEmoteMessageContent.allocationSize(value.`content`)
            )
        }
        is MessageType.Image -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeImageMessageContent.allocationSize(value.`content`)
            )
        }
        is MessageType.Audio -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeAudioMessageContent.allocationSize(value.`content`)
            )
        }
        is MessageType.Video -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeVideoMessageContent.allocationSize(value.`content`)
            )
        }
        is MessageType.File -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeFileMessageContent.allocationSize(value.`content`)
            )
        }
        is MessageType.Notice -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeNoticeMessageContent.allocationSize(value.`content`)
            )
        }
        is MessageType.Text -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeTextMessageContent.allocationSize(value.`content`)
            )
        }
        is MessageType.Location -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeLocationContent.allocationSize(value.`content`)
            )
        }
        is MessageType.Other -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`msgtype`)
                + FfiConverterString.allocationSize(value.`body`)
            )
        }
    }

    override fun write(value: MessageType, buf: ByteBuffer) {
        when(value) {
            is MessageType.Emote -> {
                buf.putInt(1)
                FfiConverterTypeEmoteMessageContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.Image -> {
                buf.putInt(2)
                FfiConverterTypeImageMessageContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.Audio -> {
                buf.putInt(3)
                FfiConverterTypeAudioMessageContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.Video -> {
                buf.putInt(4)
                FfiConverterTypeVideoMessageContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.File -> {
                buf.putInt(5)
                FfiConverterTypeFileMessageContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.Notice -> {
                buf.putInt(6)
                FfiConverterTypeNoticeMessageContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.Text -> {
                buf.putInt(7)
                FfiConverterTypeTextMessageContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.Location -> {
                buf.putInt(8)
                FfiConverterTypeLocationContent.write(value.`content`, buf)
                Unit
            }
            is MessageType.Other -> {
                buf.putInt(9)
                FfiConverterString.write(value.`msgtype`, buf)
                FfiConverterString.write(value.`body`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class NotificationEvent: Disposable  {
    data class Timeline(
        val `event`: TimelineEvent
        ) : NotificationEvent() {
        companion object
    }
    data class Invite(
        val `sender`: String
        ) : NotificationEvent() {
        companion object
    }
    

    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        when(this) {
            is NotificationEvent.Timeline -> {
                
    Disposable.destroy(
        this.`event`)
                
            }
            is NotificationEvent.Invite -> {
                
    Disposable.destroy(
        this.`sender`)
                
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
    
    companion object
}

public object FfiConverterTypeNotificationEvent : FfiConverterRustBuffer<NotificationEvent>{
    override fun read(buf: ByteBuffer): NotificationEvent {
        return when(buf.getInt()) {
            1 -> NotificationEvent.Timeline(
                FfiConverterTypeTimelineEvent.read(buf),
                )
            2 -> NotificationEvent.Invite(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: NotificationEvent) = when(value) {
        is NotificationEvent.Timeline -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeTimelineEvent.allocationSize(value.`event`)
            )
        }
        is NotificationEvent.Invite -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`sender`)
            )
        }
    }

    override fun write(value: NotificationEvent, buf: ByteBuffer) {
        when(value) {
            is NotificationEvent.Timeline -> {
                buf.putInt(1)
                FfiConverterTypeTimelineEvent.write(value.`event`, buf)
                Unit
            }
            is NotificationEvent.Invite -> {
                buf.putInt(2)
                FfiConverterString.write(value.`sender`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class NotificationProcessSetup: Disposable  {
    object MultipleProcesses : NotificationProcessSetup()
    
    data class SingleProcess(
        val `syncService`: SyncService
        ) : NotificationProcessSetup() {
        companion object
    }
    

    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        when(this) {
            is NotificationProcessSetup.MultipleProcesses -> {// Nothing to destroy
            }
            is NotificationProcessSetup.SingleProcess -> {
                
    Disposable.destroy(
        this.`syncService`)
                
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
    
    companion object
}

public object FfiConverterTypeNotificationProcessSetup : FfiConverterRustBuffer<NotificationProcessSetup>{
    override fun read(buf: ByteBuffer): NotificationProcessSetup {
        return when(buf.getInt()) {
            1 -> NotificationProcessSetup.MultipleProcesses
            2 -> NotificationProcessSetup.SingleProcess(
                FfiConverterTypeSyncService.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: NotificationProcessSetup) = when(value) {
        is NotificationProcessSetup.MultipleProcesses -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is NotificationProcessSetup.SingleProcess -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeSyncService.allocationSize(value.`syncService`)
            )
        }
    }

    override fun write(value: NotificationProcessSetup, buf: ByteBuffer) {
        when(value) {
            is NotificationProcessSetup.MultipleProcesses -> {
                buf.putInt(1)
                Unit
            }
            is NotificationProcessSetup.SingleProcess -> {
                buf.putInt(2)
                FfiConverterTypeSyncService.write(value.`syncService`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}







sealed class NotificationSettingsException: Exception() {
    // Each variant is a nested class
    
    class Generic(
        val `msg`: String
        ) : NotificationSettingsException() {
        override val message
            get() = "msg=${ `msg` }"
    }
    
    class InvalidParameter(
        val `msg`: String
        ) : NotificationSettingsException() {
        override val message
            get() = "msg=${ `msg` }"
    }
    
    class InvalidRoomId(
        val `roomId`: String
        ) : NotificationSettingsException() {
        override val message
            get() = "roomId=${ `roomId` }"
    }
    
    class RuleNotFound(
        val `ruleId`: String
        ) : NotificationSettingsException() {
        override val message
            get() = "ruleId=${ `ruleId` }"
    }
    
    class UnableToAddPushRule(
        ) : NotificationSettingsException() {
        override val message
            get() = ""
    }
    
    class UnableToRemovePushRule(
        ) : NotificationSettingsException() {
        override val message
            get() = ""
    }
    
    class UnableToSavePushRules(
        ) : NotificationSettingsException() {
        override val message
            get() = ""
    }
    
    class UnableToUpdatePushRule(
        ) : NotificationSettingsException() {
        override val message
            get() = ""
    }
    

    companion object ErrorHandler : CallStatusErrorHandler<NotificationSettingsException> {
        override fun lift(error_buf: RustBuffer.ByValue): NotificationSettingsException = FfiConverterTypeNotificationSettingsError.lift(error_buf)
    }

    
}

public object FfiConverterTypeNotificationSettingsError : FfiConverterRustBuffer<NotificationSettingsException> {
    override fun read(buf: ByteBuffer): NotificationSettingsException {
        

        return when(buf.getInt()) {
            1 -> NotificationSettingsException.Generic(
                FfiConverterString.read(buf),
                )
            2 -> NotificationSettingsException.InvalidParameter(
                FfiConverterString.read(buf),
                )
            3 -> NotificationSettingsException.InvalidRoomId(
                FfiConverterString.read(buf),
                )
            4 -> NotificationSettingsException.RuleNotFound(
                FfiConverterString.read(buf),
                )
            5 -> NotificationSettingsException.UnableToAddPushRule()
            6 -> NotificationSettingsException.UnableToRemovePushRule()
            7 -> NotificationSettingsException.UnableToSavePushRules()
            8 -> NotificationSettingsException.UnableToUpdatePushRule()
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: NotificationSettingsException): Int {
        return when(value) {
            is NotificationSettingsException.Generic -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`msg`)
            )
            is NotificationSettingsException.InvalidParameter -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`msg`)
            )
            is NotificationSettingsException.InvalidRoomId -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`roomId`)
            )
            is NotificationSettingsException.RuleNotFound -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`ruleId`)
            )
            is NotificationSettingsException.UnableToAddPushRule -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
            )
            is NotificationSettingsException.UnableToRemovePushRule -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
            )
            is NotificationSettingsException.UnableToSavePushRules -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
            )
            is NotificationSettingsException.UnableToUpdatePushRule -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
            )
        }
    }

    override fun write(value: NotificationSettingsException, buf: ByteBuffer) {
        when(value) {
            is NotificationSettingsException.Generic -> {
                buf.putInt(1)
                FfiConverterString.write(value.`msg`, buf)
                Unit
            }
            is NotificationSettingsException.InvalidParameter -> {
                buf.putInt(2)
                FfiConverterString.write(value.`msg`, buf)
                Unit
            }
            is NotificationSettingsException.InvalidRoomId -> {
                buf.putInt(3)
                FfiConverterString.write(value.`roomId`, buf)
                Unit
            }
            is NotificationSettingsException.RuleNotFound -> {
                buf.putInt(4)
                FfiConverterString.write(value.`ruleId`, buf)
                Unit
            }
            is NotificationSettingsException.UnableToAddPushRule -> {
                buf.putInt(5)
                Unit
            }
            is NotificationSettingsException.UnableToRemovePushRule -> {
                buf.putInt(6)
                Unit
            }
            is NotificationSettingsException.UnableToSavePushRules -> {
                buf.putInt(7)
                Unit
            }
            is NotificationSettingsException.UnableToUpdatePushRule -> {
                buf.putInt(8)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




sealed class OtherState {
    object PolicyRuleRoom : OtherState()
    
    object PolicyRuleServer : OtherState()
    
    object PolicyRuleUser : OtherState()
    
    object RoomAliases : OtherState()
    
    data class RoomAvatar(
        val `url`: String?
        ) : OtherState() {
        companion object
    }
    object RoomCanonicalAlias : OtherState()
    
    object RoomCreate : OtherState()
    
    object RoomEncryption : OtherState()
    
    object RoomGuestAccess : OtherState()
    
    object RoomHistoryVisibility : OtherState()
    
    object RoomJoinRules : OtherState()
    
    data class RoomName(
        val `name`: String?
        ) : OtherState() {
        companion object
    }
    object RoomPinnedEvents : OtherState()
    
    object RoomPowerLevels : OtherState()
    
    object RoomServerAcl : OtherState()
    
    data class RoomThirdPartyInvite(
        val `displayName`: String?
        ) : OtherState() {
        companion object
    }
    object RoomTombstone : OtherState()
    
    data class RoomTopic(
        val `topic`: String?
        ) : OtherState() {
        companion object
    }
    object SpaceChild : OtherState()
    
    object SpaceParent : OtherState()
    
    data class Custom(
        val `eventType`: String
        ) : OtherState() {
        companion object
    }
    

    
    companion object
}

public object FfiConverterTypeOtherState : FfiConverterRustBuffer<OtherState>{
    override fun read(buf: ByteBuffer): OtherState {
        return when(buf.getInt()) {
            1 -> OtherState.PolicyRuleRoom
            2 -> OtherState.PolicyRuleServer
            3 -> OtherState.PolicyRuleUser
            4 -> OtherState.RoomAliases
            5 -> OtherState.RoomAvatar(
                FfiConverterOptionalString.read(buf),
                )
            6 -> OtherState.RoomCanonicalAlias
            7 -> OtherState.RoomCreate
            8 -> OtherState.RoomEncryption
            9 -> OtherState.RoomGuestAccess
            10 -> OtherState.RoomHistoryVisibility
            11 -> OtherState.RoomJoinRules
            12 -> OtherState.RoomName(
                FfiConverterOptionalString.read(buf),
                )
            13 -> OtherState.RoomPinnedEvents
            14 -> OtherState.RoomPowerLevels
            15 -> OtherState.RoomServerAcl
            16 -> OtherState.RoomThirdPartyInvite(
                FfiConverterOptionalString.read(buf),
                )
            17 -> OtherState.RoomTombstone
            18 -> OtherState.RoomTopic(
                FfiConverterOptionalString.read(buf),
                )
            19 -> OtherState.SpaceChild
            20 -> OtherState.SpaceParent
            21 -> OtherState.Custom(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: OtherState) = when(value) {
        is OtherState.PolicyRuleRoom -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.PolicyRuleServer -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.PolicyRuleUser -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomAliases -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomAvatar -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterOptionalString.allocationSize(value.`url`)
            )
        }
        is OtherState.RoomCanonicalAlias -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomCreate -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomEncryption -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomGuestAccess -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomHistoryVisibility -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomJoinRules -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomName -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterOptionalString.allocationSize(value.`name`)
            )
        }
        is OtherState.RoomPinnedEvents -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomPowerLevels -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomServerAcl -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomThirdPartyInvite -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterOptionalString.allocationSize(value.`displayName`)
            )
        }
        is OtherState.RoomTombstone -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.RoomTopic -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterOptionalString.allocationSize(value.`topic`)
            )
        }
        is OtherState.SpaceChild -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.SpaceParent -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is OtherState.Custom -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`eventType`)
            )
        }
    }

    override fun write(value: OtherState, buf: ByteBuffer) {
        when(value) {
            is OtherState.PolicyRuleRoom -> {
                buf.putInt(1)
                Unit
            }
            is OtherState.PolicyRuleServer -> {
                buf.putInt(2)
                Unit
            }
            is OtherState.PolicyRuleUser -> {
                buf.putInt(3)
                Unit
            }
            is OtherState.RoomAliases -> {
                buf.putInt(4)
                Unit
            }
            is OtherState.RoomAvatar -> {
                buf.putInt(5)
                FfiConverterOptionalString.write(value.`url`, buf)
                Unit
            }
            is OtherState.RoomCanonicalAlias -> {
                buf.putInt(6)
                Unit
            }
            is OtherState.RoomCreate -> {
                buf.putInt(7)
                Unit
            }
            is OtherState.RoomEncryption -> {
                buf.putInt(8)
                Unit
            }
            is OtherState.RoomGuestAccess -> {
                buf.putInt(9)
                Unit
            }
            is OtherState.RoomHistoryVisibility -> {
                buf.putInt(10)
                Unit
            }
            is OtherState.RoomJoinRules -> {
                buf.putInt(11)
                Unit
            }
            is OtherState.RoomName -> {
                buf.putInt(12)
                FfiConverterOptionalString.write(value.`name`, buf)
                Unit
            }
            is OtherState.RoomPinnedEvents -> {
                buf.putInt(13)
                Unit
            }
            is OtherState.RoomPowerLevels -> {
                buf.putInt(14)
                Unit
            }
            is OtherState.RoomServerAcl -> {
                buf.putInt(15)
                Unit
            }
            is OtherState.RoomThirdPartyInvite -> {
                buf.putInt(16)
                FfiConverterOptionalString.write(value.`displayName`, buf)
                Unit
            }
            is OtherState.RoomTombstone -> {
                buf.putInt(17)
                Unit
            }
            is OtherState.RoomTopic -> {
                buf.putInt(18)
                FfiConverterOptionalString.write(value.`topic`, buf)
                Unit
            }
            is OtherState.SpaceChild -> {
                buf.putInt(19)
                Unit
            }
            is OtherState.SpaceParent -> {
                buf.putInt(20)
                Unit
            }
            is OtherState.Custom -> {
                buf.putInt(21)
                FfiConverterString.write(value.`eventType`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class PaginationOptions {
    data class SimpleRequest(
        val `eventLimit`: UShort, 
        val `waitForToken`: Boolean
        ) : PaginationOptions() {
        companion object
    }
    data class UntilNumItems(
        val `eventLimit`: UShort, 
        val `items`: UShort, 
        val `waitForToken`: Boolean
        ) : PaginationOptions() {
        companion object
    }
    

    
    companion object
}

public object FfiConverterTypePaginationOptions : FfiConverterRustBuffer<PaginationOptions>{
    override fun read(buf: ByteBuffer): PaginationOptions {
        return when(buf.getInt()) {
            1 -> PaginationOptions.SimpleRequest(
                FfiConverterUShort.read(buf),
                FfiConverterBoolean.read(buf),
                )
            2 -> PaginationOptions.UntilNumItems(
                FfiConverterUShort.read(buf),
                FfiConverterUShort.read(buf),
                FfiConverterBoolean.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: PaginationOptions) = when(value) {
        is PaginationOptions.SimpleRequest -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterUShort.allocationSize(value.`eventLimit`)
                + FfiConverterBoolean.allocationSize(value.`waitForToken`)
            )
        }
        is PaginationOptions.UntilNumItems -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterUShort.allocationSize(value.`eventLimit`)
                + FfiConverterUShort.allocationSize(value.`items`)
                + FfiConverterBoolean.allocationSize(value.`waitForToken`)
            )
        }
    }

    override fun write(value: PaginationOptions, buf: ByteBuffer) {
        when(value) {
            is PaginationOptions.SimpleRequest -> {
                buf.putInt(1)
                FfiConverterUShort.write(value.`eventLimit`, buf)
                FfiConverterBoolean.write(value.`waitForToken`, buf)
                Unit
            }
            is PaginationOptions.UntilNumItems -> {
                buf.putInt(2)
                FfiConverterUShort.write(value.`eventLimit`, buf)
                FfiConverterUShort.write(value.`items`, buf)
                FfiConverterBoolean.write(value.`waitForToken`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}







sealed class ParseException(message: String): Exception(message) {
        // Each variant is a nested class
        // Flat enums carries a string error message, so no special implementation is necessary.
        class EmptyHost(message: String) : ParseException(message)
        class IdnaException(message: String) : ParseException(message)
        class InvalidPort(message: String) : ParseException(message)
        class InvalidIpv4Address(message: String) : ParseException(message)
        class InvalidIpv6Address(message: String) : ParseException(message)
        class InvalidDomainCharacter(message: String) : ParseException(message)
        class RelativeUrlWithoutBase(message: String) : ParseException(message)
        class RelativeUrlWithCannotBeABaseBase(message: String) : ParseException(message)
        class SetHostOnCannotBeABaseUrl(message: String) : ParseException(message)
        class Overflow(message: String) : ParseException(message)
        class Other(message: String) : ParseException(message)
        

    companion object ErrorHandler : CallStatusErrorHandler<ParseException> {
        override fun lift(error_buf: RustBuffer.ByValue): ParseException = FfiConverterTypeParseError.lift(error_buf)
    }
}

public object FfiConverterTypeParseError : FfiConverterRustBuffer<ParseException> {
    override fun read(buf: ByteBuffer): ParseException {
        
            return when(buf.getInt()) {
            1 -> ParseException.EmptyHost(FfiConverterString.read(buf))
            2 -> ParseException.IdnaException(FfiConverterString.read(buf))
            3 -> ParseException.InvalidPort(FfiConverterString.read(buf))
            4 -> ParseException.InvalidIpv4Address(FfiConverterString.read(buf))
            5 -> ParseException.InvalidIpv6Address(FfiConverterString.read(buf))
            6 -> ParseException.InvalidDomainCharacter(FfiConverterString.read(buf))
            7 -> ParseException.RelativeUrlWithoutBase(FfiConverterString.read(buf))
            8 -> ParseException.RelativeUrlWithCannotBeABaseBase(FfiConverterString.read(buf))
            9 -> ParseException.SetHostOnCannotBeABaseUrl(FfiConverterString.read(buf))
            10 -> ParseException.Overflow(FfiConverterString.read(buf))
            11 -> ParseException.Other(FfiConverterString.read(buf))
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
        
    }

    override fun allocationSize(value: ParseException): Int {
        return 4
    }

    override fun write(value: ParseException, buf: ByteBuffer) {
        when(value) {
            is ParseException.EmptyHost -> {
                buf.putInt(1)
                Unit
            }
            is ParseException.IdnaException -> {
                buf.putInt(2)
                Unit
            }
            is ParseException.InvalidPort -> {
                buf.putInt(3)
                Unit
            }
            is ParseException.InvalidIpv4Address -> {
                buf.putInt(4)
                Unit
            }
            is ParseException.InvalidIpv6Address -> {
                buf.putInt(5)
                Unit
            }
            is ParseException.InvalidDomainCharacter -> {
                buf.putInt(6)
                Unit
            }
            is ParseException.RelativeUrlWithoutBase -> {
                buf.putInt(7)
                Unit
            }
            is ParseException.RelativeUrlWithCannotBeABaseBase -> {
                buf.putInt(8)
                Unit
            }
            is ParseException.SetHostOnCannotBeABaseUrl -> {
                buf.putInt(9)
                Unit
            }
            is ParseException.Overflow -> {
                buf.putInt(10)
                Unit
            }
            is ParseException.Other -> {
                buf.putInt(11)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




enum class PollKind {
    DISCLOSED,UNDISCLOSED;
    companion object
}

public object FfiConverterTypePollKind: FfiConverterRustBuffer<PollKind> {
    override fun read(buf: ByteBuffer) = try {
        PollKind.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: PollKind) = 4

    override fun write(value: PollKind, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






sealed class ProfileDetails {
    object Unavailable : ProfileDetails()
    
    object Pending : ProfileDetails()
    
    data class Ready(
        val `displayName`: String?, 
        val `displayNameAmbiguous`: Boolean, 
        val `avatarUrl`: String?
        ) : ProfileDetails() {
        companion object
    }
    data class Error(
        val `message`: String
        ) : ProfileDetails() {
        companion object
    }
    

    
    companion object
}

public object FfiConverterTypeProfileDetails : FfiConverterRustBuffer<ProfileDetails>{
    override fun read(buf: ByteBuffer): ProfileDetails {
        return when(buf.getInt()) {
            1 -> ProfileDetails.Unavailable
            2 -> ProfileDetails.Pending
            3 -> ProfileDetails.Ready(
                FfiConverterOptionalString.read(buf),
                FfiConverterBoolean.read(buf),
                FfiConverterOptionalString.read(buf),
                )
            4 -> ProfileDetails.Error(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: ProfileDetails) = when(value) {
        is ProfileDetails.Unavailable -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is ProfileDetails.Pending -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is ProfileDetails.Ready -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterOptionalString.allocationSize(value.`displayName`)
                + FfiConverterBoolean.allocationSize(value.`displayNameAmbiguous`)
                + FfiConverterOptionalString.allocationSize(value.`avatarUrl`)
            )
        }
        is ProfileDetails.Error -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`message`)
            )
        }
    }

    override fun write(value: ProfileDetails, buf: ByteBuffer) {
        when(value) {
            is ProfileDetails.Unavailable -> {
                buf.putInt(1)
                Unit
            }
            is ProfileDetails.Pending -> {
                buf.putInt(2)
                Unit
            }
            is ProfileDetails.Ready -> {
                buf.putInt(3)
                FfiConverterOptionalString.write(value.`displayName`, buf)
                FfiConverterBoolean.write(value.`displayNameAmbiguous`, buf)
                FfiConverterOptionalString.write(value.`avatarUrl`, buf)
                Unit
            }
            is ProfileDetails.Error -> {
                buf.putInt(4)
                FfiConverterString.write(value.`message`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class PushFormat {
    EVENT_ID_ONLY;
    companion object
}

public object FfiConverterTypePushFormat: FfiConverterRustBuffer<PushFormat> {
    override fun read(buf: ByteBuffer) = try {
        PushFormat.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: PushFormat) = 4

    override fun write(value: PushFormat, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






sealed class PusherKind {
    data class Http(
        val `data`: HttpPusherData
        ) : PusherKind() {
        companion object
    }
    object Email : PusherKind()
    
    

    
    companion object
}

public object FfiConverterTypePusherKind : FfiConverterRustBuffer<PusherKind>{
    override fun read(buf: ByteBuffer): PusherKind {
        return when(buf.getInt()) {
            1 -> PusherKind.Http(
                FfiConverterTypeHttpPusherData.read(buf),
                )
            2 -> PusherKind.Email
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: PusherKind) = when(value) {
        is PusherKind.Http -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeHttpPusherData.allocationSize(value.`data`)
            )
        }
        is PusherKind.Email -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
    }

    override fun write(value: PusherKind, buf: ByteBuffer) {
        when(value) {
            is PusherKind.Http -> {
                buf.putInt(1)
                FfiConverterTypeHttpPusherData.write(value.`data`, buf)
                Unit
            }
            is PusherKind.Email -> {
                buf.putInt(2)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}







sealed class RecoveryException: Exception() {
    // Each variant is a nested class
    
    class BackupExistsOnServer(
        ) : RecoveryException() {
        override val message
            get() = ""
    }
    
    class Client(
        val `source`: ClientException
        ) : RecoveryException() {
        override val message
            get() = "source=${ `source` }"
    }
    
    class SecretStorage(
        val `errorMessage`: String
        ) : RecoveryException() {
        override val message
            get() = "errorMessage=${ `errorMessage` }"
    }
    

    companion object ErrorHandler : CallStatusErrorHandler<RecoveryException> {
        override fun lift(error_buf: RustBuffer.ByValue): RecoveryException = FfiConverterTypeRecoveryError.lift(error_buf)
    }

    
}

public object FfiConverterTypeRecoveryError : FfiConverterRustBuffer<RecoveryException> {
    override fun read(buf: ByteBuffer): RecoveryException {
        

        return when(buf.getInt()) {
            1 -> RecoveryException.BackupExistsOnServer()
            2 -> RecoveryException.Client(
                FfiConverterTypeClientError.read(buf),
                )
            3 -> RecoveryException.SecretStorage(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: RecoveryException): Int {
        return when(value) {
            is RecoveryException.BackupExistsOnServer -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
            )
            is RecoveryException.Client -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterTypeClientError.allocationSize(value.`source`)
            )
            is RecoveryException.SecretStorage -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`errorMessage`)
            )
        }
    }

    override fun write(value: RecoveryException, buf: ByteBuffer) {
        when(value) {
            is RecoveryException.BackupExistsOnServer -> {
                buf.putInt(1)
                Unit
            }
            is RecoveryException.Client -> {
                buf.putInt(2)
                FfiConverterTypeClientError.write(value.`source`, buf)
                Unit
            }
            is RecoveryException.SecretStorage -> {
                buf.putInt(3)
                FfiConverterString.write(value.`errorMessage`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




enum class RecoveryState {
    UNKNOWN,ENABLED,DISABLED,INCOMPLETE;
    companion object
}

public object FfiConverterTypeRecoveryState: FfiConverterRustBuffer<RecoveryState> {
    override fun read(buf: ByteBuffer) = try {
        RecoveryState.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: RecoveryState) = 4

    override fun write(value: RecoveryState, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






sealed class RepliedToEventDetails: Disposable  {
    object Unavailable : RepliedToEventDetails()
    
    object Pending : RepliedToEventDetails()
    
    data class Ready(
        val `content`: TimelineItemContent, 
        val `sender`: String, 
        val `senderProfile`: ProfileDetails
        ) : RepliedToEventDetails() {
        companion object
    }
    data class Error(
        val `message`: String
        ) : RepliedToEventDetails() {
        companion object
    }
    

    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        when(this) {
            is RepliedToEventDetails.Unavailable -> {// Nothing to destroy
            }
            is RepliedToEventDetails.Pending -> {// Nothing to destroy
            }
            is RepliedToEventDetails.Ready -> {
                
    Disposable.destroy(
        this.`content`, 
        this.`sender`, 
        this.`senderProfile`)
                
            }
            is RepliedToEventDetails.Error -> {
                
    Disposable.destroy(
        this.`message`)
                
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
    
    companion object
}

public object FfiConverterTypeRepliedToEventDetails : FfiConverterRustBuffer<RepliedToEventDetails>{
    override fun read(buf: ByteBuffer): RepliedToEventDetails {
        return when(buf.getInt()) {
            1 -> RepliedToEventDetails.Unavailable
            2 -> RepliedToEventDetails.Pending
            3 -> RepliedToEventDetails.Ready(
                FfiConverterTypeTimelineItemContent.read(buf),
                FfiConverterString.read(buf),
                FfiConverterTypeProfileDetails.read(buf),
                )
            4 -> RepliedToEventDetails.Error(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: RepliedToEventDetails) = when(value) {
        is RepliedToEventDetails.Unavailable -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is RepliedToEventDetails.Pending -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is RepliedToEventDetails.Ready -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeTimelineItemContent.allocationSize(value.`content`)
                + FfiConverterString.allocationSize(value.`sender`)
                + FfiConverterTypeProfileDetails.allocationSize(value.`senderProfile`)
            )
        }
        is RepliedToEventDetails.Error -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`message`)
            )
        }
    }

    override fun write(value: RepliedToEventDetails, buf: ByteBuffer) {
        when(value) {
            is RepliedToEventDetails.Unavailable -> {
                buf.putInt(1)
                Unit
            }
            is RepliedToEventDetails.Pending -> {
                buf.putInt(2)
                Unit
            }
            is RepliedToEventDetails.Ready -> {
                buf.putInt(3)
                FfiConverterTypeTimelineItemContent.write(value.`content`, buf)
                FfiConverterString.write(value.`sender`, buf)
                FfiConverterTypeProfileDetails.write(value.`senderProfile`, buf)
                Unit
            }
            is RepliedToEventDetails.Error -> {
                buf.putInt(4)
                FfiConverterString.write(value.`message`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}







sealed class RoomException(message: String): Exception(message) {
        // Each variant is a nested class
        // Flat enums carries a string error message, so no special implementation is necessary.
        class InvalidAttachmentData(message: String) : RoomException(message)
        class InvalidAttachmentMimeType(message: String) : RoomException(message)
        class InvalidMediaInfo(message: String) : RoomException(message)
        class TimelineUnavailable(message: String) : RoomException(message)
        class InvalidThumbnailData(message: String) : RoomException(message)
        class FailedSendingAttachment(message: String) : RoomException(message)
        

    companion object ErrorHandler : CallStatusErrorHandler<RoomException> {
        override fun lift(error_buf: RustBuffer.ByValue): RoomException = FfiConverterTypeRoomError.lift(error_buf)
    }
}

public object FfiConverterTypeRoomError : FfiConverterRustBuffer<RoomException> {
    override fun read(buf: ByteBuffer): RoomException {
        
            return when(buf.getInt()) {
            1 -> RoomException.InvalidAttachmentData(FfiConverterString.read(buf))
            2 -> RoomException.InvalidAttachmentMimeType(FfiConverterString.read(buf))
            3 -> RoomException.InvalidMediaInfo(FfiConverterString.read(buf))
            4 -> RoomException.TimelineUnavailable(FfiConverterString.read(buf))
            5 -> RoomException.InvalidThumbnailData(FfiConverterString.read(buf))
            6 -> RoomException.FailedSendingAttachment(FfiConverterString.read(buf))
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
        
    }

    override fun allocationSize(value: RoomException): Int {
        return 4
    }

    override fun write(value: RoomException, buf: ByteBuffer) {
        when(value) {
            is RoomException.InvalidAttachmentData -> {
                buf.putInt(1)
                Unit
            }
            is RoomException.InvalidAttachmentMimeType -> {
                buf.putInt(2)
                Unit
            }
            is RoomException.InvalidMediaInfo -> {
                buf.putInt(3)
                Unit
            }
            is RoomException.TimelineUnavailable -> {
                buf.putInt(4)
                Unit
            }
            is RoomException.InvalidThumbnailData -> {
                buf.putInt(5)
                Unit
            }
            is RoomException.FailedSendingAttachment -> {
                buf.putInt(6)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




sealed class RoomListEntriesDynamicFilterKind {
    object All : RoomListEntriesDynamicFilterKind()
    
    object AllNonLeft : RoomListEntriesDynamicFilterKind()
    
    object None : RoomListEntriesDynamicFilterKind()
    
    data class NormalizedMatchRoomName(
        val `pattern`: String
        ) : RoomListEntriesDynamicFilterKind() {
        companion object
    }
    data class FuzzyMatchRoomName(
        val `pattern`: String
        ) : RoomListEntriesDynamicFilterKind() {
        companion object
    }
    

    
    companion object
}

public object FfiConverterTypeRoomListEntriesDynamicFilterKind : FfiConverterRustBuffer<RoomListEntriesDynamicFilterKind>{
    override fun read(buf: ByteBuffer): RoomListEntriesDynamicFilterKind {
        return when(buf.getInt()) {
            1 -> RoomListEntriesDynamicFilterKind.All
            2 -> RoomListEntriesDynamicFilterKind.AllNonLeft
            3 -> RoomListEntriesDynamicFilterKind.None
            4 -> RoomListEntriesDynamicFilterKind.NormalizedMatchRoomName(
                FfiConverterString.read(buf),
                )
            5 -> RoomListEntriesDynamicFilterKind.FuzzyMatchRoomName(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: RoomListEntriesDynamicFilterKind) = when(value) {
        is RoomListEntriesDynamicFilterKind.All -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is RoomListEntriesDynamicFilterKind.AllNonLeft -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is RoomListEntriesDynamicFilterKind.None -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is RoomListEntriesDynamicFilterKind.NormalizedMatchRoomName -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`pattern`)
            )
        }
        is RoomListEntriesDynamicFilterKind.FuzzyMatchRoomName -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`pattern`)
            )
        }
    }

    override fun write(value: RoomListEntriesDynamicFilterKind, buf: ByteBuffer) {
        when(value) {
            is RoomListEntriesDynamicFilterKind.All -> {
                buf.putInt(1)
                Unit
            }
            is RoomListEntriesDynamicFilterKind.AllNonLeft -> {
                buf.putInt(2)
                Unit
            }
            is RoomListEntriesDynamicFilterKind.None -> {
                buf.putInt(3)
                Unit
            }
            is RoomListEntriesDynamicFilterKind.NormalizedMatchRoomName -> {
                buf.putInt(4)
                FfiConverterString.write(value.`pattern`, buf)
                Unit
            }
            is RoomListEntriesDynamicFilterKind.FuzzyMatchRoomName -> {
                buf.putInt(5)
                FfiConverterString.write(value.`pattern`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class RoomListEntriesUpdate {
    data class Append(
        val `values`: List<RoomListEntry>
        ) : RoomListEntriesUpdate() {
        companion object
    }
    object Clear : RoomListEntriesUpdate()
    
    data class PushFront(
        val `value`: RoomListEntry
        ) : RoomListEntriesUpdate() {
        companion object
    }
    data class PushBack(
        val `value`: RoomListEntry
        ) : RoomListEntriesUpdate() {
        companion object
    }
    object PopFront : RoomListEntriesUpdate()
    
    object PopBack : RoomListEntriesUpdate()
    
    data class Insert(
        val `index`: UInt, 
        val `value`: RoomListEntry
        ) : RoomListEntriesUpdate() {
        companion object
    }
    data class Set(
        val `index`: UInt, 
        val `value`: RoomListEntry
        ) : RoomListEntriesUpdate() {
        companion object
    }
    data class Remove(
        val `index`: UInt
        ) : RoomListEntriesUpdate() {
        companion object
    }
    data class Truncate(
        val `length`: UInt
        ) : RoomListEntriesUpdate() {
        companion object
    }
    data class Reset(
        val `values`: List<RoomListEntry>
        ) : RoomListEntriesUpdate() {
        companion object
    }
    

    
    companion object
}

public object FfiConverterTypeRoomListEntriesUpdate : FfiConverterRustBuffer<RoomListEntriesUpdate>{
    override fun read(buf: ByteBuffer): RoomListEntriesUpdate {
        return when(buf.getInt()) {
            1 -> RoomListEntriesUpdate.Append(
                FfiConverterSequenceTypeRoomListEntry.read(buf),
                )
            2 -> RoomListEntriesUpdate.Clear
            3 -> RoomListEntriesUpdate.PushFront(
                FfiConverterTypeRoomListEntry.read(buf),
                )
            4 -> RoomListEntriesUpdate.PushBack(
                FfiConverterTypeRoomListEntry.read(buf),
                )
            5 -> RoomListEntriesUpdate.PopFront
            6 -> RoomListEntriesUpdate.PopBack
            7 -> RoomListEntriesUpdate.Insert(
                FfiConverterUInt.read(buf),
                FfiConverterTypeRoomListEntry.read(buf),
                )
            8 -> RoomListEntriesUpdate.Set(
                FfiConverterUInt.read(buf),
                FfiConverterTypeRoomListEntry.read(buf),
                )
            9 -> RoomListEntriesUpdate.Remove(
                FfiConverterUInt.read(buf),
                )
            10 -> RoomListEntriesUpdate.Truncate(
                FfiConverterUInt.read(buf),
                )
            11 -> RoomListEntriesUpdate.Reset(
                FfiConverterSequenceTypeRoomListEntry.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: RoomListEntriesUpdate) = when(value) {
        is RoomListEntriesUpdate.Append -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterSequenceTypeRoomListEntry.allocationSize(value.`values`)
            )
        }
        is RoomListEntriesUpdate.Clear -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is RoomListEntriesUpdate.PushFront -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeRoomListEntry.allocationSize(value.`value`)
            )
        }
        is RoomListEntriesUpdate.PushBack -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeRoomListEntry.allocationSize(value.`value`)
            )
        }
        is RoomListEntriesUpdate.PopFront -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is RoomListEntriesUpdate.PopBack -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is RoomListEntriesUpdate.Insert -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterUInt.allocationSize(value.`index`)
                + FfiConverterTypeRoomListEntry.allocationSize(value.`value`)
            )
        }
        is RoomListEntriesUpdate.Set -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterUInt.allocationSize(value.`index`)
                + FfiConverterTypeRoomListEntry.allocationSize(value.`value`)
            )
        }
        is RoomListEntriesUpdate.Remove -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterUInt.allocationSize(value.`index`)
            )
        }
        is RoomListEntriesUpdate.Truncate -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterUInt.allocationSize(value.`length`)
            )
        }
        is RoomListEntriesUpdate.Reset -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterSequenceTypeRoomListEntry.allocationSize(value.`values`)
            )
        }
    }

    override fun write(value: RoomListEntriesUpdate, buf: ByteBuffer) {
        when(value) {
            is RoomListEntriesUpdate.Append -> {
                buf.putInt(1)
                FfiConverterSequenceTypeRoomListEntry.write(value.`values`, buf)
                Unit
            }
            is RoomListEntriesUpdate.Clear -> {
                buf.putInt(2)
                Unit
            }
            is RoomListEntriesUpdate.PushFront -> {
                buf.putInt(3)
                FfiConverterTypeRoomListEntry.write(value.`value`, buf)
                Unit
            }
            is RoomListEntriesUpdate.PushBack -> {
                buf.putInt(4)
                FfiConverterTypeRoomListEntry.write(value.`value`, buf)
                Unit
            }
            is RoomListEntriesUpdate.PopFront -> {
                buf.putInt(5)
                Unit
            }
            is RoomListEntriesUpdate.PopBack -> {
                buf.putInt(6)
                Unit
            }
            is RoomListEntriesUpdate.Insert -> {
                buf.putInt(7)
                FfiConverterUInt.write(value.`index`, buf)
                FfiConverterTypeRoomListEntry.write(value.`value`, buf)
                Unit
            }
            is RoomListEntriesUpdate.Set -> {
                buf.putInt(8)
                FfiConverterUInt.write(value.`index`, buf)
                FfiConverterTypeRoomListEntry.write(value.`value`, buf)
                Unit
            }
            is RoomListEntriesUpdate.Remove -> {
                buf.putInt(9)
                FfiConverterUInt.write(value.`index`, buf)
                Unit
            }
            is RoomListEntriesUpdate.Truncate -> {
                buf.putInt(10)
                FfiConverterUInt.write(value.`length`, buf)
                Unit
            }
            is RoomListEntriesUpdate.Reset -> {
                buf.putInt(11)
                FfiConverterSequenceTypeRoomListEntry.write(value.`values`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class RoomListEntry {
    object Empty : RoomListEntry()
    
    data class Invalidated(
        val `roomId`: String
        ) : RoomListEntry() {
        companion object
    }
    data class Filled(
        val `roomId`: String
        ) : RoomListEntry() {
        companion object
    }
    

    
    companion object
}

public object FfiConverterTypeRoomListEntry : FfiConverterRustBuffer<RoomListEntry>{
    override fun read(buf: ByteBuffer): RoomListEntry {
        return when(buf.getInt()) {
            1 -> RoomListEntry.Empty
            2 -> RoomListEntry.Invalidated(
                FfiConverterString.read(buf),
                )
            3 -> RoomListEntry.Filled(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: RoomListEntry) = when(value) {
        is RoomListEntry.Empty -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is RoomListEntry.Invalidated -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`roomId`)
            )
        }
        is RoomListEntry.Filled -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`roomId`)
            )
        }
    }

    override fun write(value: RoomListEntry, buf: ByteBuffer) {
        when(value) {
            is RoomListEntry.Empty -> {
                buf.putInt(1)
                Unit
            }
            is RoomListEntry.Invalidated -> {
                buf.putInt(2)
                FfiConverterString.write(value.`roomId`, buf)
                Unit
            }
            is RoomListEntry.Filled -> {
                buf.putInt(3)
                FfiConverterString.write(value.`roomId`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}







sealed class RoomListException: Exception() {
    // Each variant is a nested class
    
    class SlidingSync(
        val `error`: String
        ) : RoomListException() {
        override val message
            get() = "error=${ `error` }"
    }
    
    class UnknownList(
        val `listName`: String
        ) : RoomListException() {
        override val message
            get() = "listName=${ `listName` }"
    }
    
    class InputCannotBeApplied(
        ) : RoomListException() {
        override val message
            get() = ""
    }
    
    class RoomNotFound(
        val `roomName`: String
        ) : RoomListException() {
        override val message
            get() = "roomName=${ `roomName` }"
    }
    
    class InvalidRoomId(
        val `error`: String
        ) : RoomListException() {
        override val message
            get() = "error=${ `error` }"
    }
    

    companion object ErrorHandler : CallStatusErrorHandler<RoomListException> {
        override fun lift(error_buf: RustBuffer.ByValue): RoomListException = FfiConverterTypeRoomListError.lift(error_buf)
    }

    
}

public object FfiConverterTypeRoomListError : FfiConverterRustBuffer<RoomListException> {
    override fun read(buf: ByteBuffer): RoomListException {
        

        return when(buf.getInt()) {
            1 -> RoomListException.SlidingSync(
                FfiConverterString.read(buf),
                )
            2 -> RoomListException.UnknownList(
                FfiConverterString.read(buf),
                )
            3 -> RoomListException.InputCannotBeApplied()
            4 -> RoomListException.RoomNotFound(
                FfiConverterString.read(buf),
                )
            5 -> RoomListException.InvalidRoomId(
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: RoomListException): Int {
        return when(value) {
            is RoomListException.SlidingSync -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`error`)
            )
            is RoomListException.UnknownList -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`listName`)
            )
            is RoomListException.InputCannotBeApplied -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
            )
            is RoomListException.RoomNotFound -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`roomName`)
            )
            is RoomListException.InvalidRoomId -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4
                + FfiConverterString.allocationSize(value.`error`)
            )
        }
    }

    override fun write(value: RoomListException, buf: ByteBuffer) {
        when(value) {
            is RoomListException.SlidingSync -> {
                buf.putInt(1)
                FfiConverterString.write(value.`error`, buf)
                Unit
            }
            is RoomListException.UnknownList -> {
                buf.putInt(2)
                FfiConverterString.write(value.`listName`, buf)
                Unit
            }
            is RoomListException.InputCannotBeApplied -> {
                buf.putInt(3)
                Unit
            }
            is RoomListException.RoomNotFound -> {
                buf.putInt(4)
                FfiConverterString.write(value.`roomName`, buf)
                Unit
            }
            is RoomListException.InvalidRoomId -> {
                buf.putInt(5)
                FfiConverterString.write(value.`error`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




sealed class RoomListInput {
    data class Viewport(
        val `ranges`: List<RoomListRange>
        ) : RoomListInput() {
        companion object
    }
    

    
    companion object
}

public object FfiConverterTypeRoomListInput : FfiConverterRustBuffer<RoomListInput>{
    override fun read(buf: ByteBuffer): RoomListInput {
        return when(buf.getInt()) {
            1 -> RoomListInput.Viewport(
                FfiConverterSequenceTypeRoomListRange.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: RoomListInput) = when(value) {
        is RoomListInput.Viewport -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterSequenceTypeRoomListRange.allocationSize(value.`ranges`)
            )
        }
    }

    override fun write(value: RoomListInput, buf: ByteBuffer) {
        when(value) {
            is RoomListInput.Viewport -> {
                buf.putInt(1)
                FfiConverterSequenceTypeRoomListRange.write(value.`ranges`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class RoomListLoadingState {
    object NotLoaded : RoomListLoadingState()
    
    data class Loaded(
        val `maximumNumberOfRooms`: UInt?
        ) : RoomListLoadingState() {
        companion object
    }
    

    
    companion object
}

public object FfiConverterTypeRoomListLoadingState : FfiConverterRustBuffer<RoomListLoadingState>{
    override fun read(buf: ByteBuffer): RoomListLoadingState {
        return when(buf.getInt()) {
            1 -> RoomListLoadingState.NotLoaded
            2 -> RoomListLoadingState.Loaded(
                FfiConverterOptionalUInt.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: RoomListLoadingState) = when(value) {
        is RoomListLoadingState.NotLoaded -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is RoomListLoadingState.Loaded -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterOptionalUInt.allocationSize(value.`maximumNumberOfRooms`)
            )
        }
    }

    override fun write(value: RoomListLoadingState, buf: ByteBuffer) {
        when(value) {
            is RoomListLoadingState.NotLoaded -> {
                buf.putInt(1)
                Unit
            }
            is RoomListLoadingState.Loaded -> {
                buf.putInt(2)
                FfiConverterOptionalUInt.write(value.`maximumNumberOfRooms`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class RoomListServiceState {
    INITIAL,SETTING_UP,RECOVERING,RUNNING,ERROR,TERMINATED;
    companion object
}

public object FfiConverterTypeRoomListServiceState: FfiConverterRustBuffer<RoomListServiceState> {
    override fun read(buf: ByteBuffer) = try {
        RoomListServiceState.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: RoomListServiceState) = 4

    override fun write(value: RoomListServiceState, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class RoomListServiceSyncIndicator {
    SHOW,HIDE;
    companion object
}

public object FfiConverterTypeRoomListServiceSyncIndicator: FfiConverterRustBuffer<RoomListServiceSyncIndicator> {
    override fun read(buf: ByteBuffer) = try {
        RoomListServiceSyncIndicator.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: RoomListServiceSyncIndicator) = 4

    override fun write(value: RoomListServiceSyncIndicator, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class RoomNotificationMode {
    ALL_MESSAGES,MENTIONS_AND_KEYWORDS_ONLY,MUTE;
    companion object
}

public object FfiConverterTypeRoomNotificationMode: FfiConverterRustBuffer<RoomNotificationMode> {
    override fun read(buf: ByteBuffer) = try {
        RoomNotificationMode.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: RoomNotificationMode) = 4

    override fun write(value: RoomNotificationMode, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class RoomPreset {
    PRIVATE_CHAT,PUBLIC_CHAT,TRUSTED_PRIVATE_CHAT;
    companion object
}

public object FfiConverterTypeRoomPreset: FfiConverterRustBuffer<RoomPreset> {
    override fun read(buf: ByteBuffer) = try {
        RoomPreset.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: RoomPreset) = 4

    override fun write(value: RoomPreset, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class RoomVisibility {
    PUBLIC,PRIVATE;
    companion object
}

public object FfiConverterTypeRoomVisibility: FfiConverterRustBuffer<RoomVisibility> {
    override fun read(buf: ByteBuffer) = try {
        RoomVisibility.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: RoomVisibility) = 4

    override fun write(value: RoomVisibility, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






sealed class SessionVerificationData: Disposable  {
    data class Emojis(
        val `emojis`: List<SessionVerificationEmoji>, 
        val `indices`: ByteArray
        ) : SessionVerificationData() {
        companion object
    }
    data class Decimals(
        val `values`: List<UShort>
        ) : SessionVerificationData() {
        companion object
    }
    

    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        when(this) {
            is SessionVerificationData.Emojis -> {
                
    Disposable.destroy(
        this.`emojis`, 
        this.`indices`)
                
            }
            is SessionVerificationData.Decimals -> {
                
    Disposable.destroy(
        this.`values`)
                
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
    
    companion object
}

public object FfiConverterTypeSessionVerificationData : FfiConverterRustBuffer<SessionVerificationData>{
    override fun read(buf: ByteBuffer): SessionVerificationData {
        return when(buf.getInt()) {
            1 -> SessionVerificationData.Emojis(
                FfiConverterSequenceTypeSessionVerificationEmoji.read(buf),
                FfiConverterByteArray.read(buf),
                )
            2 -> SessionVerificationData.Decimals(
                FfiConverterSequenceUShort.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: SessionVerificationData) = when(value) {
        is SessionVerificationData.Emojis -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterSequenceTypeSessionVerificationEmoji.allocationSize(value.`emojis`)
                + FfiConverterByteArray.allocationSize(value.`indices`)
            )
        }
        is SessionVerificationData.Decimals -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterSequenceUShort.allocationSize(value.`values`)
            )
        }
    }

    override fun write(value: SessionVerificationData, buf: ByteBuffer) {
        when(value) {
            is SessionVerificationData.Emojis -> {
                buf.putInt(1)
                FfiConverterSequenceTypeSessionVerificationEmoji.write(value.`emojis`, buf)
                FfiConverterByteArray.write(value.`indices`, buf)
                Unit
            }
            is SessionVerificationData.Decimals -> {
                buf.putInt(2)
                FfiConverterSequenceUShort.write(value.`values`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class StateEventContent {
    object PolicyRuleRoom : StateEventContent()
    
    object PolicyRuleServer : StateEventContent()
    
    object PolicyRuleUser : StateEventContent()
    
    object RoomAliases : StateEventContent()
    
    object RoomAvatar : StateEventContent()
    
    object RoomCanonicalAlias : StateEventContent()
    
    object RoomCreate : StateEventContent()
    
    object RoomEncryption : StateEventContent()
    
    object RoomGuestAccess : StateEventContent()
    
    object RoomHistoryVisibility : StateEventContent()
    
    object RoomJoinRules : StateEventContent()
    
    data class RoomMemberContent(
        val `userId`: String, 
        val `membershipState`: MembershipState
        ) : StateEventContent() {
        companion object
    }
    object RoomName : StateEventContent()
    
    object RoomPinnedEvents : StateEventContent()
    
    object RoomPowerLevels : StateEventContent()
    
    object RoomServerAcl : StateEventContent()
    
    object RoomThirdPartyInvite : StateEventContent()
    
    object RoomTombstone : StateEventContent()
    
    object RoomTopic : StateEventContent()
    
    object SpaceChild : StateEventContent()
    
    object SpaceParent : StateEventContent()
    
    

    
    companion object
}

public object FfiConverterTypeStateEventContent : FfiConverterRustBuffer<StateEventContent>{
    override fun read(buf: ByteBuffer): StateEventContent {
        return when(buf.getInt()) {
            1 -> StateEventContent.PolicyRuleRoom
            2 -> StateEventContent.PolicyRuleServer
            3 -> StateEventContent.PolicyRuleUser
            4 -> StateEventContent.RoomAliases
            5 -> StateEventContent.RoomAvatar
            6 -> StateEventContent.RoomCanonicalAlias
            7 -> StateEventContent.RoomCreate
            8 -> StateEventContent.RoomEncryption
            9 -> StateEventContent.RoomGuestAccess
            10 -> StateEventContent.RoomHistoryVisibility
            11 -> StateEventContent.RoomJoinRules
            12 -> StateEventContent.RoomMemberContent(
                FfiConverterString.read(buf),
                FfiConverterTypeMembershipState.read(buf),
                )
            13 -> StateEventContent.RoomName
            14 -> StateEventContent.RoomPinnedEvents
            15 -> StateEventContent.RoomPowerLevels
            16 -> StateEventContent.RoomServerAcl
            17 -> StateEventContent.RoomThirdPartyInvite
            18 -> StateEventContent.RoomTombstone
            19 -> StateEventContent.RoomTopic
            20 -> StateEventContent.SpaceChild
            21 -> StateEventContent.SpaceParent
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: StateEventContent) = when(value) {
        is StateEventContent.PolicyRuleRoom -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.PolicyRuleServer -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.PolicyRuleUser -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomAliases -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomAvatar -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomCanonicalAlias -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomCreate -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomEncryption -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomGuestAccess -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomHistoryVisibility -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomJoinRules -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomMemberContent -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`userId`)
                + FfiConverterTypeMembershipState.allocationSize(value.`membershipState`)
            )
        }
        is StateEventContent.RoomName -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomPinnedEvents -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomPowerLevels -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomServerAcl -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomThirdPartyInvite -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomTombstone -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.RoomTopic -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.SpaceChild -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is StateEventContent.SpaceParent -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
    }

    override fun write(value: StateEventContent, buf: ByteBuffer) {
        when(value) {
            is StateEventContent.PolicyRuleRoom -> {
                buf.putInt(1)
                Unit
            }
            is StateEventContent.PolicyRuleServer -> {
                buf.putInt(2)
                Unit
            }
            is StateEventContent.PolicyRuleUser -> {
                buf.putInt(3)
                Unit
            }
            is StateEventContent.RoomAliases -> {
                buf.putInt(4)
                Unit
            }
            is StateEventContent.RoomAvatar -> {
                buf.putInt(5)
                Unit
            }
            is StateEventContent.RoomCanonicalAlias -> {
                buf.putInt(6)
                Unit
            }
            is StateEventContent.RoomCreate -> {
                buf.putInt(7)
                Unit
            }
            is StateEventContent.RoomEncryption -> {
                buf.putInt(8)
                Unit
            }
            is StateEventContent.RoomGuestAccess -> {
                buf.putInt(9)
                Unit
            }
            is StateEventContent.RoomHistoryVisibility -> {
                buf.putInt(10)
                Unit
            }
            is StateEventContent.RoomJoinRules -> {
                buf.putInt(11)
                Unit
            }
            is StateEventContent.RoomMemberContent -> {
                buf.putInt(12)
                FfiConverterString.write(value.`userId`, buf)
                FfiConverterTypeMembershipState.write(value.`membershipState`, buf)
                Unit
            }
            is StateEventContent.RoomName -> {
                buf.putInt(13)
                Unit
            }
            is StateEventContent.RoomPinnedEvents -> {
                buf.putInt(14)
                Unit
            }
            is StateEventContent.RoomPowerLevels -> {
                buf.putInt(15)
                Unit
            }
            is StateEventContent.RoomServerAcl -> {
                buf.putInt(16)
                Unit
            }
            is StateEventContent.RoomThirdPartyInvite -> {
                buf.putInt(17)
                Unit
            }
            is StateEventContent.RoomTombstone -> {
                buf.putInt(18)
                Unit
            }
            is StateEventContent.RoomTopic -> {
                buf.putInt(19)
                Unit
            }
            is StateEventContent.SpaceChild -> {
                buf.putInt(20)
                Unit
            }
            is StateEventContent.SpaceParent -> {
                buf.putInt(21)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class StateEventType {
    CALL_MEMBER,POLICY_RULE_ROOM,POLICY_RULE_SERVER,POLICY_RULE_USER,ROOM_ALIASES,ROOM_AVATAR,ROOM_CANONICAL_ALIAS,ROOM_CREATE,ROOM_ENCRYPTION,ROOM_GUEST_ACCESS,ROOM_HISTORY_VISIBILITY,ROOM_JOIN_RULES,ROOM_MEMBER_EVENT,ROOM_NAME,ROOM_PINNED_EVENTS,ROOM_POWER_LEVELS,ROOM_SERVER_ACL,ROOM_THIRD_PARTY_INVITE,ROOM_TOMBSTONE,ROOM_TOPIC,SPACE_CHILD,SPACE_PARENT;
    companion object
}

public object FfiConverterTypeStateEventType: FfiConverterRustBuffer<StateEventType> {
    override fun read(buf: ByteBuffer) = try {
        StateEventType.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: StateEventType) = 4

    override fun write(value: StateEventType, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}







sealed class SteadyStateException(message: String): Exception(message) {
        // Each variant is a nested class
        // Flat enums carries a string error message, so no special implementation is necessary.
        class BackupDisabled(message: String) : SteadyStateException(message)
        class Connection(message: String) : SteadyStateException(message)
        class Lagged(message: String) : SteadyStateException(message)
        

    companion object ErrorHandler : CallStatusErrorHandler<SteadyStateException> {
        override fun lift(error_buf: RustBuffer.ByValue): SteadyStateException = FfiConverterTypeSteadyStateError.lift(error_buf)
    }
}

public object FfiConverterTypeSteadyStateError : FfiConverterRustBuffer<SteadyStateException> {
    override fun read(buf: ByteBuffer): SteadyStateException {
        
            return when(buf.getInt()) {
            1 -> SteadyStateException.BackupDisabled(FfiConverterString.read(buf))
            2 -> SteadyStateException.Connection(FfiConverterString.read(buf))
            3 -> SteadyStateException.Lagged(FfiConverterString.read(buf))
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
        
    }

    override fun allocationSize(value: SteadyStateException): Int {
        return 4
    }

    override fun write(value: SteadyStateException, buf: ByteBuffer) {
        when(value) {
            is SteadyStateException.BackupDisabled -> {
                buf.putInt(1)
                Unit
            }
            is SteadyStateException.Connection -> {
                buf.putInt(2)
                Unit
            }
            is SteadyStateException.Lagged -> {
                buf.putInt(3)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}




enum class SyncServiceState {
    IDLE,RUNNING,TERMINATED,ERROR;
    companion object
}

public object FfiConverterTypeSyncServiceState: FfiConverterRustBuffer<SyncServiceState> {
    override fun read(buf: ByteBuffer) = try {
        SyncServiceState.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: SyncServiceState) = 4

    override fun write(value: SyncServiceState, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class TimelineChange {
    APPEND,CLEAR,INSERT,SET,REMOVE,PUSH_BACK,PUSH_FRONT,POP_BACK,POP_FRONT,TRUNCATE,RESET;
    companion object
}

public object FfiConverterTypeTimelineChange: FfiConverterRustBuffer<TimelineChange> {
    override fun read(buf: ByteBuffer) = try {
        TimelineChange.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: TimelineChange) = 4

    override fun write(value: TimelineChange, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






sealed class TimelineEventType: Disposable  {
    data class MessageLike(
        val `content`: MessageLikeEventContent
        ) : TimelineEventType() {
        companion object
    }
    data class State(
        val `content`: StateEventContent
        ) : TimelineEventType() {
        companion object
    }
    

    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        when(this) {
            is TimelineEventType.MessageLike -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
            is TimelineEventType.State -> {
                
    Disposable.destroy(
        this.`content`)
                
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
    
    companion object
}

public object FfiConverterTypeTimelineEventType : FfiConverterRustBuffer<TimelineEventType>{
    override fun read(buf: ByteBuffer): TimelineEventType {
        return when(buf.getInt()) {
            1 -> TimelineEventType.MessageLike(
                FfiConverterTypeMessageLikeEventContent.read(buf),
                )
            2 -> TimelineEventType.State(
                FfiConverterTypeStateEventContent.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: TimelineEventType) = when(value) {
        is TimelineEventType.MessageLike -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeMessageLikeEventContent.allocationSize(value.`content`)
            )
        }
        is TimelineEventType.State -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeStateEventContent.allocationSize(value.`content`)
            )
        }
    }

    override fun write(value: TimelineEventType, buf: ByteBuffer) {
        when(value) {
            is TimelineEventType.MessageLike -> {
                buf.putInt(1)
                FfiConverterTypeMessageLikeEventContent.write(value.`content`, buf)
                Unit
            }
            is TimelineEventType.State -> {
                buf.putInt(2)
                FfiConverterTypeStateEventContent.write(value.`content`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class TimelineItemContentKind: Disposable  {
    object Message : TimelineItemContentKind()
    
    object RedactedMessage : TimelineItemContentKind()
    
    data class Sticker(
        val `body`: String, 
        val `info`: ImageInfo, 
        val `url`: String
        ) : TimelineItemContentKind() {
        companion object
    }
    data class Poll(
        val `question`: String, 
        val `kind`: PollKind, 
        val `maxSelections`: ULong, 
        val `answers`: List<PollAnswer>, 
        val `votes`: Map<String, List<String>>, 
        val `endTime`: ULong?, 
        val `hasBeenEdited`: Boolean
        ) : TimelineItemContentKind() {
        companion object
    }
    data class UnableToDecrypt(
        val `msg`: EncryptedMessage
        ) : TimelineItemContentKind() {
        companion object
    }
    data class RoomMembership(
        val `userId`: String, 
        val `change`: MembershipChange?
        ) : TimelineItemContentKind() {
        companion object
    }
    data class ProfileChange(
        val `displayName`: String?, 
        val `prevDisplayName`: String?, 
        val `avatarUrl`: String?, 
        val `prevAvatarUrl`: String?
        ) : TimelineItemContentKind() {
        companion object
    }
    data class State(
        val `stateKey`: String, 
        val `content`: OtherState
        ) : TimelineItemContentKind() {
        companion object
    }
    data class FailedToParseMessageLike(
        val `eventType`: String, 
        val `error`: String
        ) : TimelineItemContentKind() {
        companion object
    }
    data class FailedToParseState(
        val `eventType`: String, 
        val `stateKey`: String, 
        val `error`: String
        ) : TimelineItemContentKind() {
        companion object
    }
    

    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        when(this) {
            is TimelineItemContentKind.Message -> {// Nothing to destroy
            }
            is TimelineItemContentKind.RedactedMessage -> {// Nothing to destroy
            }
            is TimelineItemContentKind.Sticker -> {
                
    Disposable.destroy(
        this.`body`, 
        this.`info`, 
        this.`url`)
                
            }
            is TimelineItemContentKind.Poll -> {
                
    Disposable.destroy(
        this.`question`, 
        this.`kind`, 
        this.`maxSelections`, 
        this.`answers`, 
        this.`votes`, 
        this.`endTime`, 
        this.`hasBeenEdited`)
                
            }
            is TimelineItemContentKind.UnableToDecrypt -> {
                
    Disposable.destroy(
        this.`msg`)
                
            }
            is TimelineItemContentKind.RoomMembership -> {
                
    Disposable.destroy(
        this.`userId`, 
        this.`change`)
                
            }
            is TimelineItemContentKind.ProfileChange -> {
                
    Disposable.destroy(
        this.`displayName`, 
        this.`prevDisplayName`, 
        this.`avatarUrl`, 
        this.`prevAvatarUrl`)
                
            }
            is TimelineItemContentKind.State -> {
                
    Disposable.destroy(
        this.`stateKey`, 
        this.`content`)
                
            }
            is TimelineItemContentKind.FailedToParseMessageLike -> {
                
    Disposable.destroy(
        this.`eventType`, 
        this.`error`)
                
            }
            is TimelineItemContentKind.FailedToParseState -> {
                
    Disposable.destroy(
        this.`eventType`, 
        this.`stateKey`, 
        this.`error`)
                
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
    
    companion object
}

public object FfiConverterTypeTimelineItemContentKind : FfiConverterRustBuffer<TimelineItemContentKind>{
    override fun read(buf: ByteBuffer): TimelineItemContentKind {
        return when(buf.getInt()) {
            1 -> TimelineItemContentKind.Message
            2 -> TimelineItemContentKind.RedactedMessage
            3 -> TimelineItemContentKind.Sticker(
                FfiConverterString.read(buf),
                FfiConverterTypeImageInfo.read(buf),
                FfiConverterString.read(buf),
                )
            4 -> TimelineItemContentKind.Poll(
                FfiConverterString.read(buf),
                FfiConverterTypePollKind.read(buf),
                FfiConverterULong.read(buf),
                FfiConverterSequenceTypePollAnswer.read(buf),
                FfiConverterMapStringSequenceString.read(buf),
                FfiConverterOptionalULong.read(buf),
                FfiConverterBoolean.read(buf),
                )
            5 -> TimelineItemContentKind.UnableToDecrypt(
                FfiConverterTypeEncryptedMessage.read(buf),
                )
            6 -> TimelineItemContentKind.RoomMembership(
                FfiConverterString.read(buf),
                FfiConverterOptionalTypeMembershipChange.read(buf),
                )
            7 -> TimelineItemContentKind.ProfileChange(
                FfiConverterOptionalString.read(buf),
                FfiConverterOptionalString.read(buf),
                FfiConverterOptionalString.read(buf),
                FfiConverterOptionalString.read(buf),
                )
            8 -> TimelineItemContentKind.State(
                FfiConverterString.read(buf),
                FfiConverterTypeOtherState.read(buf),
                )
            9 -> TimelineItemContentKind.FailedToParseMessageLike(
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                )
            10 -> TimelineItemContentKind.FailedToParseState(
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: TimelineItemContentKind) = when(value) {
        is TimelineItemContentKind.Message -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is TimelineItemContentKind.RedactedMessage -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
        is TimelineItemContentKind.Sticker -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`body`)
                + FfiConverterTypeImageInfo.allocationSize(value.`info`)
                + FfiConverterString.allocationSize(value.`url`)
            )
        }
        is TimelineItemContentKind.Poll -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`question`)
                + FfiConverterTypePollKind.allocationSize(value.`kind`)
                + FfiConverterULong.allocationSize(value.`maxSelections`)
                + FfiConverterSequenceTypePollAnswer.allocationSize(value.`answers`)
                + FfiConverterMapStringSequenceString.allocationSize(value.`votes`)
                + FfiConverterOptionalULong.allocationSize(value.`endTime`)
                + FfiConverterBoolean.allocationSize(value.`hasBeenEdited`)
            )
        }
        is TimelineItemContentKind.UnableToDecrypt -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterTypeEncryptedMessage.allocationSize(value.`msg`)
            )
        }
        is TimelineItemContentKind.RoomMembership -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`userId`)
                + FfiConverterOptionalTypeMembershipChange.allocationSize(value.`change`)
            )
        }
        is TimelineItemContentKind.ProfileChange -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterOptionalString.allocationSize(value.`displayName`)
                + FfiConverterOptionalString.allocationSize(value.`prevDisplayName`)
                + FfiConverterOptionalString.allocationSize(value.`avatarUrl`)
                + FfiConverterOptionalString.allocationSize(value.`prevAvatarUrl`)
            )
        }
        is TimelineItemContentKind.State -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`stateKey`)
                + FfiConverterTypeOtherState.allocationSize(value.`content`)
            )
        }
        is TimelineItemContentKind.FailedToParseMessageLike -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`eventType`)
                + FfiConverterString.allocationSize(value.`error`)
            )
        }
        is TimelineItemContentKind.FailedToParseState -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`eventType`)
                + FfiConverterString.allocationSize(value.`stateKey`)
                + FfiConverterString.allocationSize(value.`error`)
            )
        }
    }

    override fun write(value: TimelineItemContentKind, buf: ByteBuffer) {
        when(value) {
            is TimelineItemContentKind.Message -> {
                buf.putInt(1)
                Unit
            }
            is TimelineItemContentKind.RedactedMessage -> {
                buf.putInt(2)
                Unit
            }
            is TimelineItemContentKind.Sticker -> {
                buf.putInt(3)
                FfiConverterString.write(value.`body`, buf)
                FfiConverterTypeImageInfo.write(value.`info`, buf)
                FfiConverterString.write(value.`url`, buf)
                Unit
            }
            is TimelineItemContentKind.Poll -> {
                buf.putInt(4)
                FfiConverterString.write(value.`question`, buf)
                FfiConverterTypePollKind.write(value.`kind`, buf)
                FfiConverterULong.write(value.`maxSelections`, buf)
                FfiConverterSequenceTypePollAnswer.write(value.`answers`, buf)
                FfiConverterMapStringSequenceString.write(value.`votes`, buf)
                FfiConverterOptionalULong.write(value.`endTime`, buf)
                FfiConverterBoolean.write(value.`hasBeenEdited`, buf)
                Unit
            }
            is TimelineItemContentKind.UnableToDecrypt -> {
                buf.putInt(5)
                FfiConverterTypeEncryptedMessage.write(value.`msg`, buf)
                Unit
            }
            is TimelineItemContentKind.RoomMembership -> {
                buf.putInt(6)
                FfiConverterString.write(value.`userId`, buf)
                FfiConverterOptionalTypeMembershipChange.write(value.`change`, buf)
                Unit
            }
            is TimelineItemContentKind.ProfileChange -> {
                buf.putInt(7)
                FfiConverterOptionalString.write(value.`displayName`, buf)
                FfiConverterOptionalString.write(value.`prevDisplayName`, buf)
                FfiConverterOptionalString.write(value.`avatarUrl`, buf)
                FfiConverterOptionalString.write(value.`prevAvatarUrl`, buf)
                Unit
            }
            is TimelineItemContentKind.State -> {
                buf.putInt(8)
                FfiConverterString.write(value.`stateKey`, buf)
                FfiConverterTypeOtherState.write(value.`content`, buf)
                Unit
            }
            is TimelineItemContentKind.FailedToParseMessageLike -> {
                buf.putInt(9)
                FfiConverterString.write(value.`eventType`, buf)
                FfiConverterString.write(value.`error`, buf)
                Unit
            }
            is TimelineItemContentKind.FailedToParseState -> {
                buf.putInt(10)
                FfiConverterString.write(value.`eventType`, buf)
                FfiConverterString.write(value.`stateKey`, buf)
                FfiConverterString.write(value.`error`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class VirtualTimelineItem {
    data class DayDivider(
        val `ts`: ULong
        ) : VirtualTimelineItem() {
        companion object
    }
    object ReadMarker : VirtualTimelineItem()
    
    

    
    companion object
}

public object FfiConverterTypeVirtualTimelineItem : FfiConverterRustBuffer<VirtualTimelineItem>{
    override fun read(buf: ByteBuffer): VirtualTimelineItem {
        return when(buf.getInt()) {
            1 -> VirtualTimelineItem.DayDivider(
                FfiConverterULong.read(buf),
                )
            2 -> VirtualTimelineItem.ReadMarker
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: VirtualTimelineItem) = when(value) {
        is VirtualTimelineItem.DayDivider -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterULong.allocationSize(value.`ts`)
            )
        }
        is VirtualTimelineItem.ReadMarker -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
            )
        }
    }

    override fun write(value: VirtualTimelineItem, buf: ByteBuffer) {
        when(value) {
            is VirtualTimelineItem.DayDivider -> {
                buf.putInt(1)
                FfiConverterULong.write(value.`ts`, buf)
                Unit
            }
            is VirtualTimelineItem.ReadMarker -> {
                buf.putInt(2)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






sealed class WidgetEventFilter {
    data class MessageLikeWithType(
        val `eventType`: String
        ) : WidgetEventFilter() {
        companion object
    }
    data class RoomMessageWithMsgtype(
        val `msgtype`: String
        ) : WidgetEventFilter() {
        companion object
    }
    data class StateWithType(
        val `eventType`: String
        ) : WidgetEventFilter() {
        companion object
    }
    data class StateWithTypeAndStateKey(
        val `eventType`: String, 
        val `stateKey`: String
        ) : WidgetEventFilter() {
        companion object
    }
    

    
    companion object
}

public object FfiConverterTypeWidgetEventFilter : FfiConverterRustBuffer<WidgetEventFilter>{
    override fun read(buf: ByteBuffer): WidgetEventFilter {
        return when(buf.getInt()) {
            1 -> WidgetEventFilter.MessageLikeWithType(
                FfiConverterString.read(buf),
                )
            2 -> WidgetEventFilter.RoomMessageWithMsgtype(
                FfiConverterString.read(buf),
                )
            3 -> WidgetEventFilter.StateWithType(
                FfiConverterString.read(buf),
                )
            4 -> WidgetEventFilter.StateWithTypeAndStateKey(
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: WidgetEventFilter) = when(value) {
        is WidgetEventFilter.MessageLikeWithType -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`eventType`)
            )
        }
        is WidgetEventFilter.RoomMessageWithMsgtype -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`msgtype`)
            )
        }
        is WidgetEventFilter.StateWithType -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`eventType`)
            )
        }
        is WidgetEventFilter.StateWithTypeAndStateKey -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4
                + FfiConverterString.allocationSize(value.`eventType`)
                + FfiConverterString.allocationSize(value.`stateKey`)
            )
        }
    }

    override fun write(value: WidgetEventFilter, buf: ByteBuffer) {
        when(value) {
            is WidgetEventFilter.MessageLikeWithType -> {
                buf.putInt(1)
                FfiConverterString.write(value.`eventType`, buf)
                Unit
            }
            is WidgetEventFilter.RoomMessageWithMsgtype -> {
                buf.putInt(2)
                FfiConverterString.write(value.`msgtype`, buf)
                Unit
            }
            is WidgetEventFilter.StateWithType -> {
                buf.putInt(3)
                FfiConverterString.write(value.`eventType`, buf)
                Unit
            }
            is WidgetEventFilter.StateWithTypeAndStateKey -> {
                buf.putInt(4)
                FfiConverterString.write(value.`eventType`, buf)
                FfiConverterString.write(value.`stateKey`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






public interface BackPaginationStatusListener {
    fun `onUpdate`(`status`: BackPaginationStatus)
    
    companion object
}


internal typealias Handle = Long
internal class ConcurrentHandleMap<T>(
    private val leftMap: MutableMap<Handle, T> = mutableMapOf(),
) {
    private val lock = java.util.concurrent.locks.ReentrantLock()
    private val currentHandle = AtomicLong(0L)
    private val stride = 1L

    fun insert(obj: T): Handle =
        lock.withLock {
            currentHandle.getAndAdd(stride)
                .also { handle ->
                    leftMap[handle] = obj
                }
            }

    fun get(handle: Handle) = lock.withLock {
        leftMap[handle] ?: throw InternalException("No callback in handlemap; this is a Uniffi bug")
    }

    fun delete(handle: Handle) {
        this.remove(handle)
    }

    fun remove(handle: Handle): T? =
        lock.withLock {
            leftMap.remove(handle)
        }
}

interface ForeignCallback : com.sun.jna.Callback {
    public fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int
}

// Magic number for the Rust proxy to call using the same mechanism as every other method,
// to free the callback once it's dropped by Rust.
internal const val IDX_CALLBACK_FREE = 0
// Callback return codes
internal const val UNIFFI_CALLBACK_SUCCESS = 0
internal const val UNIFFI_CALLBACK_ERROR = 1
internal const val UNIFFI_CALLBACK_UNEXPECTED_ERROR = 2

public abstract class FfiConverterCallbackInterface<CallbackInterface>: FfiConverter<CallbackInterface, Handle> {
    internal val handleMap = ConcurrentHandleMap<CallbackInterface>()

    internal fun drop(handle: Handle) {
        handleMap.remove(handle)
    }

    override fun lift(value: Handle): CallbackInterface {
        return handleMap.get(value)
    }

    override fun read(buf: ByteBuffer) = lift(buf.getLong())

    override fun lower(value: CallbackInterface) = handleMap.insert(value)

    override fun allocationSize(value: CallbackInterface) = 8

    override fun write(value: CallbackInterface, buf: ByteBuffer) {
        buf.putLong(lower(value))
    }
}

// Implement the foreign callback handler for BackPaginationStatusListener
internal class UniffiCallbackInterfaceBackPaginationStatusListener : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeBackPaginationStatusListener.handleMap.get(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeBackPaginationStatusListener.handleMap.remove(handle)

                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnUpdate`(kotlinCallbackInterface: BackPaginationStatusListener, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`onUpdate`(
                FfiConverterTypeBackPaginationStatus.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: _UniFFILib) {
        lib.uniffi_matrix_sdk_ffi_fn_init_callback_backpaginationstatuslistener(this)
    }
}

internal val uniffiCallbackInterfaceBackPaginationStatusListener = UniffiCallbackInterfaceBackPaginationStatusListener()

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeBackPaginationStatusListener: FfiConverterCallbackInterface<BackPaginationStatusListener>()




public interface BackupStateListener {
    fun `onUpdate`(`status`: BackupState)
    
    companion object
}


// Implement the foreign callback handler for BackupStateListener
internal class UniffiCallbackInterfaceBackupStateListener : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeBackupStateListener.handleMap.get(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeBackupStateListener.handleMap.remove(handle)

                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnUpdate`(kotlinCallbackInterface: BackupStateListener, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`onUpdate`(
                FfiConverterTypeBackupState.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: _UniFFILib) {
        lib.uniffi_matrix_sdk_ffi_fn_init_callback_backupstatelistener(this)
    }
}

internal val uniffiCallbackInterfaceBackupStateListener = UniffiCallbackInterfaceBackupStateListener()

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeBackupStateListener: FfiConverterCallbackInterface<BackupStateListener>()




public interface BackupSteadyStateListener {
    fun `onUpdate`(`status`: BackupUploadState)
    
    companion object
}


// Implement the foreign callback handler for BackupSteadyStateListener
internal class UniffiCallbackInterfaceBackupSteadyStateListener : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeBackupSteadyStateListener.handleMap.get(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeBackupSteadyStateListener.handleMap.remove(handle)

                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnUpdate`(kotlinCallbackInterface: BackupSteadyStateListener, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`onUpdate`(
                FfiConverterTypeBackupUploadState.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: _UniFFILib) {
        lib.uniffi_matrix_sdk_ffi_fn_init_callback_backupsteadystatelistener(this)
    }
}

internal val uniffiCallbackInterfaceBackupSteadyStateListener = UniffiCallbackInterfaceBackupSteadyStateListener()

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeBackupSteadyStateListener: FfiConverterCallbackInterface<BackupSteadyStateListener>()




public interface ClientDelegate {
    fun `didReceiveAuthError`(`isSoftLogout`: Boolean)
    fun `didRefreshTokens`()
    
    companion object
}


// Implement the foreign callback handler for ClientDelegate
internal class UniffiCallbackInterfaceClientDelegate : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeClientDelegate.handleMap.get(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeClientDelegate.handleMap.remove(handle)

                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidReceiveAuthError`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            2 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidRefreshTokens`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidReceiveAuthError`(kotlinCallbackInterface: ClientDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`didReceiveAuthError`(
                FfiConverterBoolean.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidRefreshTokens`(kotlinCallbackInterface: ClientDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        fun makeCall() : Int {
            kotlinCallbackInterface.`didRefreshTokens`(
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: _UniFFILib) {
        lib.uniffi_matrix_sdk_ffi_fn_init_callback_clientdelegate(this)
    }
}

internal val uniffiCallbackInterfaceClientDelegate = UniffiCallbackInterfaceClientDelegate()

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeClientDelegate: FfiConverterCallbackInterface<ClientDelegate>()




public interface ClientSessionDelegate {
    fun `retrieveSessionFromKeychain`(`userId`: String): Session
    fun `saveSessionInKeychain`(`session`: Session)
    
    companion object
}


// Implement the foreign callback handler for ClientSessionDelegate
internal class UniffiCallbackInterfaceClientSessionDelegate : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeClientSessionDelegate.handleMap.get(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeClientSessionDelegate.handleMap.remove(handle)

                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeRetrieveSessionFromKeychain`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            2 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeSaveSessionInKeychain`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeRetrieveSessionFromKeychain`(kotlinCallbackInterface: ClientSessionDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            val returnValue = kotlinCallbackInterface.`retrieveSessionFromKeychain`(
                FfiConverterString.read(argsBuf)
                
            )
            outBuf.setValue(FfiConverterTypeSession.lowerIntoRustBuffer(returnValue))
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError()  : Int = try {
            makeCall()
        } catch (e: ClientException) {
            // Expected error, serialize it into outBuf
            outBuf.setValue(FfiConverterTypeClientError.lowerIntoRustBuffer(e))
            UNIFFI_CALLBACK_ERROR
        }

        return makeCallAndHandleError()
    }
    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeSaveSessionInKeychain`(kotlinCallbackInterface: ClientSessionDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`saveSessionInKeychain`(
                FfiConverterTypeSession.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: _UniFFILib) {
        lib.uniffi_matrix_sdk_ffi_fn_init_callback_clientsessiondelegate(this)
    }
}

internal val uniffiCallbackInterfaceClientSessionDelegate = UniffiCallbackInterfaceClientSessionDelegate()

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeClientSessionDelegate: FfiConverterCallbackInterface<ClientSessionDelegate>()




public interface EnableRecoveryProgressListener {
    fun `onUpdate`(`status`: EnableRecoveryProgress)
    
    companion object
}


// Implement the foreign callback handler for EnableRecoveryProgressListener
internal class UniffiCallbackInterfaceEnableRecoveryProgressListener : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeEnableRecoveryProgressListener.handleMap.get(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeEnableRecoveryProgressListener.handleMap.remove(handle)

                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnUpdate`(kotlinCallbackInterface: EnableRecoveryProgressListener, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`onUpdate`(
                FfiConverterTypeEnableRecoveryProgress.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: _UniFFILib) {
        lib.uniffi_matrix_sdk_ffi_fn_init_callback_enablerecoveryprogresslistener(this)
    }
}

internal val uniffiCallbackInterfaceEnableRecoveryProgressListener = UniffiCallbackInterfaceEnableRecoveryProgressListener()

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeEnableRecoveryProgressListener: FfiConverterCallbackInterface<EnableRecoveryProgressListener>()




public interface NotificationSettingsDelegate {
    fun `settingsDidChange`()
    
    companion object
}


// Implement the foreign callback handler for NotificationSettingsDelegate
internal class UniffiCallbackInterfaceNotificationSettingsDelegate : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeNotificationSettingsDelegate.handleMap.get(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeNotificationSettingsDelegate.handleMap.remove(handle)

                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeSettingsDidChange`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeSettingsDidChange`(kotlinCallbackInterface: NotificationSettingsDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        fun makeCall() : Int {
            kotlinCallbackInterface.`settingsDidChange`(
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: _UniFFILib) {
        lib.uniffi_matrix_sdk_ffi_fn_init_callback_notificationsettingsdelegate(this)
    }
}

internal val uniffiCallbackInterfaceNotificationSettingsDelegate = UniffiCallbackInterfaceNotificationSettingsDelegate()

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeNotificationSettingsDelegate: FfiConverterCallbackInterface<NotificationSettingsDelegate>()




public interface ProgressWatcher {
    fun `transmissionProgress`(`progress`: TransmissionProgress)
    
    companion object
}


// Implement the foreign callback handler for ProgressWatcher
internal class UniffiCallbackInterfaceProgressWatcher : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeProgressWatcher.handleMap.get(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeProgressWatcher.handleMap.remove(handle)

                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeTransmissionProgress`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeTransmissionProgress`(kotlinCallbackInterface: ProgressWatcher, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`transmissionProgress`(
                FfiConverterTypeTransmissionProgress.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: _UniFFILib) {
        lib.uniffi_matrix_sdk_ffi_fn_init_callback_progresswatcher(this)
    }
}

internal val uniffiCallbackInterfaceProgressWatcher = UniffiCallbackInterfaceProgressWatcher()

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeProgressWatcher: FfiConverterCallbackInterface<ProgressWatcher>()




public interface RecoveryStateListener {
    fun `onUpdate`(`status`: RecoveryState)
    
    companion object
}


// Implement the foreign callback handler for RecoveryStateListener
internal class UniffiCallbackInterfaceRecoveryStateListener : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeRecoveryStateListener.handleMap.get(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeRecoveryStateListener.handleMap.remove(handle)

                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnUpdate`(kotlinCallbackInterface: RecoveryStateListener, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`onUpdate`(
                FfiConverterTypeRecoveryState.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: _UniFFILib) {
        lib.uniffi_matrix_sdk_ffi_fn_init_callback_recoverystatelistener(this)
    }
}

internal val uniffiCallbackInterfaceRecoveryStateListener = UniffiCallbackInterfaceRecoveryStateListener()

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeRecoveryStateListener: FfiConverterCallbackInterface<RecoveryStateListener>()




public interface RoomInfoListener {
    fun `call`(`roomInfo`: RoomInfo)
    
    companion object
}


// Implement the foreign callback handler for RoomInfoListener
internal class UniffiCallbackInterfaceRoomInfoListener : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeRoomInfoListener.handleMap.get(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeRoomInfoListener.handleMap.remove(handle)

                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeCall`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeCall`(kotlinCallbackInterface: RoomInfoListener, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`call`(
                FfiConverterTypeRoomInfo.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: _UniFFILib) {
        lib.uniffi_matrix_sdk_ffi_fn_init_callback_roominfolistener(this)
    }
}

internal val uniffiCallbackInterfaceRoomInfoListener = UniffiCallbackInterfaceRoomInfoListener()

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeRoomInfoListener: FfiConverterCallbackInterface<RoomInfoListener>()




public interface RoomListEntriesListener {
    fun `onUpdate`(`roomEntriesUpdate`: List<RoomListEntriesUpdate>)
    
    companion object
}


// Implement the foreign callback handler for RoomListEntriesListener
internal class UniffiCallbackInterfaceRoomListEntriesListener : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeRoomListEntriesListener.handleMap.get(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeRoomListEntriesListener.handleMap.remove(handle)

                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnUpdate`(kotlinCallbackInterface: RoomListEntriesListener, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`onUpdate`(
                FfiConverterSequenceTypeRoomListEntriesUpdate.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: _UniFFILib) {
        lib.uniffi_matrix_sdk_ffi_fn_init_callback_roomlistentrieslistener(this)
    }
}

internal val uniffiCallbackInterfaceRoomListEntriesListener = UniffiCallbackInterfaceRoomListEntriesListener()

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeRoomListEntriesListener: FfiConverterCallbackInterface<RoomListEntriesListener>()




public interface RoomListLoadingStateListener {
    fun `onUpdate`(`state`: RoomListLoadingState)
    
    companion object
}


// Implement the foreign callback handler for RoomListLoadingStateListener
internal class UniffiCallbackInterfaceRoomListLoadingStateListener : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeRoomListLoadingStateListener.handleMap.get(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeRoomListLoadingStateListener.handleMap.remove(handle)

                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnUpdate`(kotlinCallbackInterface: RoomListLoadingStateListener, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`onUpdate`(
                FfiConverterTypeRoomListLoadingState.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: _UniFFILib) {
        lib.uniffi_matrix_sdk_ffi_fn_init_callback_roomlistloadingstatelistener(this)
    }
}

internal val uniffiCallbackInterfaceRoomListLoadingStateListener = UniffiCallbackInterfaceRoomListLoadingStateListener()

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeRoomListLoadingStateListener: FfiConverterCallbackInterface<RoomListLoadingStateListener>()




public interface RoomListServiceStateListener {
    fun `onUpdate`(`state`: RoomListServiceState)
    
    companion object
}


// Implement the foreign callback handler for RoomListServiceStateListener
internal class UniffiCallbackInterfaceRoomListServiceStateListener : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeRoomListServiceStateListener.handleMap.get(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeRoomListServiceStateListener.handleMap.remove(handle)

                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnUpdate`(kotlinCallbackInterface: RoomListServiceStateListener, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`onUpdate`(
                FfiConverterTypeRoomListServiceState.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: _UniFFILib) {
        lib.uniffi_matrix_sdk_ffi_fn_init_callback_roomlistservicestatelistener(this)
    }
}

internal val uniffiCallbackInterfaceRoomListServiceStateListener = UniffiCallbackInterfaceRoomListServiceStateListener()

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeRoomListServiceStateListener: FfiConverterCallbackInterface<RoomListServiceStateListener>()




public interface RoomListServiceSyncIndicatorListener {
    fun `onUpdate`(`syncIndicator`: RoomListServiceSyncIndicator)
    
    companion object
}


// Implement the foreign callback handler for RoomListServiceSyncIndicatorListener
internal class UniffiCallbackInterfaceRoomListServiceSyncIndicatorListener : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeRoomListServiceSyncIndicatorListener.handleMap.get(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeRoomListServiceSyncIndicatorListener.handleMap.remove(handle)

                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnUpdate`(kotlinCallbackInterface: RoomListServiceSyncIndicatorListener, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`onUpdate`(
                FfiConverterTypeRoomListServiceSyncIndicator.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: _UniFFILib) {
        lib.uniffi_matrix_sdk_ffi_fn_init_callback_roomlistservicesyncindicatorlistener(this)
    }
}

internal val uniffiCallbackInterfaceRoomListServiceSyncIndicatorListener = UniffiCallbackInterfaceRoomListServiceSyncIndicatorListener()

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeRoomListServiceSyncIndicatorListener: FfiConverterCallbackInterface<RoomListServiceSyncIndicatorListener>()




public interface SessionVerificationControllerDelegate {
    fun `didAcceptVerificationRequest`()
    fun `didStartSasVerification`()
    fun `didReceiveVerificationData`(`data`: SessionVerificationData)
    fun `didFail`()
    fun `didCancel`()
    fun `didFinish`()
    
    companion object
}


// Implement the foreign callback handler for SessionVerificationControllerDelegate
internal class UniffiCallbackInterfaceSessionVerificationControllerDelegate : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeSessionVerificationControllerDelegate.handleMap.get(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeSessionVerificationControllerDelegate.handleMap.remove(handle)

                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidAcceptVerificationRequest`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            2 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidStartSasVerification`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            3 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidReceiveVerificationData`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            4 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidFail`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            5 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidCancel`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            6 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeDidFinish`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidAcceptVerificationRequest`(kotlinCallbackInterface: SessionVerificationControllerDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        fun makeCall() : Int {
            kotlinCallbackInterface.`didAcceptVerificationRequest`(
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidStartSasVerification`(kotlinCallbackInterface: SessionVerificationControllerDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        fun makeCall() : Int {
            kotlinCallbackInterface.`didStartSasVerification`(
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidReceiveVerificationData`(kotlinCallbackInterface: SessionVerificationControllerDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`didReceiveVerificationData`(
                FfiConverterTypeSessionVerificationData.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidFail`(kotlinCallbackInterface: SessionVerificationControllerDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        fun makeCall() : Int {
            kotlinCallbackInterface.`didFail`(
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidCancel`(kotlinCallbackInterface: SessionVerificationControllerDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        fun makeCall() : Int {
            kotlinCallbackInterface.`didCancel`(
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeDidFinish`(kotlinCallbackInterface: SessionVerificationControllerDelegate, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        fun makeCall() : Int {
            kotlinCallbackInterface.`didFinish`(
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: _UniFFILib) {
        lib.uniffi_matrix_sdk_ffi_fn_init_callback_sessionverificationcontrollerdelegate(this)
    }
}

internal val uniffiCallbackInterfaceSessionVerificationControllerDelegate = UniffiCallbackInterfaceSessionVerificationControllerDelegate()

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeSessionVerificationControllerDelegate: FfiConverterCallbackInterface<SessionVerificationControllerDelegate>()




public interface SyncServiceStateObserver {
    fun `onUpdate`(`state`: SyncServiceState)
    
    companion object
}


// Implement the foreign callback handler for SyncServiceStateObserver
internal class UniffiCallbackInterfaceSyncServiceStateObserver : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeSyncServiceStateObserver.handleMap.get(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeSyncServiceStateObserver.handleMap.remove(handle)

                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnUpdate`(kotlinCallbackInterface: SyncServiceStateObserver, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`onUpdate`(
                FfiConverterTypeSyncServiceState.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: _UniFFILib) {
        lib.uniffi_matrix_sdk_ffi_fn_init_callback_syncservicestateobserver(this)
    }
}

internal val uniffiCallbackInterfaceSyncServiceStateObserver = UniffiCallbackInterfaceSyncServiceStateObserver()

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeSyncServiceStateObserver: FfiConverterCallbackInterface<SyncServiceStateObserver>()




public interface TimelineListener {
    fun `onUpdate`(`diff`: List<TimelineDiff>)
    
    companion object
}


// Implement the foreign callback handler for TimelineListener
internal class UniffiCallbackInterfaceTimelineListener : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeTimelineListener.handleMap.get(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeTimelineListener.handleMap.remove(handle)

                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeOnUpdate`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeOnUpdate`(kotlinCallbackInterface: TimelineListener, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            kotlinCallbackInterface.`onUpdate`(
                FfiConverterSequenceTypeTimelineDiff.read(argsBuf)
            )
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: _UniFFILib) {
        lib.uniffi_matrix_sdk_ffi_fn_init_callback_timelinelistener(this)
    }
}

internal val uniffiCallbackInterfaceTimelineListener = UniffiCallbackInterfaceTimelineListener()

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeTimelineListener: FfiConverterCallbackInterface<TimelineListener>()




public interface WidgetCapabilitiesProvider {
    fun `acquireCapabilities`(`capabilities`: WidgetCapabilities): WidgetCapabilities
    
    companion object
}


// Implement the foreign callback handler for WidgetCapabilitiesProvider
internal class UniffiCallbackInterfaceWidgetCapabilitiesProvider : ForeignCallback {
    @Suppress("TooGenericExceptionCaught")
    override fun invoke(handle: Handle, method: Int, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val cb = FfiConverterTypeWidgetCapabilitiesProvider.handleMap.get(handle)
        return when (method) {
            IDX_CALLBACK_FREE -> {
                FfiConverterTypeWidgetCapabilitiesProvider.handleMap.remove(handle)

                // Successful return
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                UNIFFI_CALLBACK_SUCCESS
            }
            1 -> {
                // Call the method, write to outBuf and return a status code
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs` for info
                try {
                    this.`invokeAcquireCapabilities`(cb, argsData, argsLen, outBuf)
                } catch (e: Throwable) {
                    // Unexpected error
                    try {
                        // Try to serialize the error into a string
                        outBuf.setValue(FfiConverterString.lower(e.toString()))
                    } catch (e: Throwable) {
                        // If that fails, then it's time to give up and just return
                    }
                    UNIFFI_CALLBACK_UNEXPECTED_ERROR
                }
            }
            
            else -> {
                // An unexpected error happened.
                // See docs of ForeignCallback in `uniffi_core/src/ffi/foreigncallbacks.rs`
                try {
                    // Try to serialize the error into a string
                    outBuf.setValue(FfiConverterString.lower("Invalid Callback index"))
                } catch (e: Throwable) {
                    // If that fails, then it's time to give up and just return
                }
                UNIFFI_CALLBACK_UNEXPECTED_ERROR
            }
        }
    }

    
    @Suppress("UNUSED_PARAMETER")
    private fun `invokeAcquireCapabilities`(kotlinCallbackInterface: WidgetCapabilitiesProvider, argsData: Pointer, argsLen: Int, outBuf: RustBufferByReference): Int {
        val argsBuf = argsData.getByteBuffer(0, argsLen.toLong()).also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
        fun makeCall() : Int {
            val returnValue = kotlinCallbackInterface.`acquireCapabilities`(
                FfiConverterTypeWidgetCapabilities.read(argsBuf)
                
            )
            outBuf.setValue(FfiConverterTypeWidgetCapabilities.lowerIntoRustBuffer(returnValue))
            return UNIFFI_CALLBACK_SUCCESS
        }
        fun makeCallAndHandleError() : Int = makeCall()

        return makeCallAndHandleError()
    }
    

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: _UniFFILib) {
        lib.uniffi_matrix_sdk_ffi_fn_init_callback_widgetcapabilitiesprovider(this)
    }
}

internal val uniffiCallbackInterfaceWidgetCapabilitiesProvider = UniffiCallbackInterfaceWidgetCapabilitiesProvider()

// The ffiConverter which transforms the Callbacks in to Handles to pass to Rust.
public object FfiConverterTypeWidgetCapabilitiesProvider: FfiConverterCallbackInterface<WidgetCapabilitiesProvider>()




public object FfiConverterOptionalUByte: FfiConverterRustBuffer<UByte?> {
    override fun read(buf: ByteBuffer): UByte? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterUByte.read(buf)
    }

    override fun allocationSize(value: UByte?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterUByte.allocationSize(value)
        }
    }

    override fun write(value: UByte?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterUByte.write(value, buf)
        }
    }
}




public object FfiConverterOptionalUInt: FfiConverterRustBuffer<UInt?> {
    override fun read(buf: ByteBuffer): UInt? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterUInt.read(buf)
    }

    override fun allocationSize(value: UInt?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterUInt.allocationSize(value)
        }
    }

    override fun write(value: UInt?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterUInt.write(value, buf)
        }
    }
}




public object FfiConverterOptionalInt: FfiConverterRustBuffer<Int?> {
    override fun read(buf: ByteBuffer): Int? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterInt.read(buf)
    }

    override fun allocationSize(value: Int?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterInt.allocationSize(value)
        }
    }

    override fun write(value: Int?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterInt.write(value, buf)
        }
    }
}




public object FfiConverterOptionalULong: FfiConverterRustBuffer<ULong?> {
    override fun read(buf: ByteBuffer): ULong? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterULong.read(buf)
    }

    override fun allocationSize(value: ULong?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterULong.allocationSize(value)
        }
    }

    override fun write(value: ULong?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterULong.write(value, buf)
        }
    }
}




public object FfiConverterOptionalDouble: FfiConverterRustBuffer<Double?> {
    override fun read(buf: ByteBuffer): Double? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterDouble.read(buf)
    }

    override fun allocationSize(value: Double?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterDouble.allocationSize(value)
        }
    }

    override fun write(value: Double?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterDouble.write(value, buf)
        }
    }
}




public object FfiConverterOptionalBoolean: FfiConverterRustBuffer<Boolean?> {
    override fun read(buf: ByteBuffer): Boolean? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterBoolean.read(buf)
    }

    override fun allocationSize(value: Boolean?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterBoolean.allocationSize(value)
        }
    }

    override fun write(value: Boolean?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterBoolean.write(value, buf)
        }
    }
}




public object FfiConverterOptionalString: FfiConverterRustBuffer<String?> {
    override fun read(buf: ByteBuffer): String? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterString.read(buf)
    }

    override fun allocationSize(value: String?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterString.allocationSize(value)
        }
    }

    override fun write(value: String?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterString.write(value, buf)
        }
    }
}




public object FfiConverterOptionalDuration: FfiConverterRustBuffer<java.time.Duration?> {
    override fun read(buf: ByteBuffer): java.time.Duration? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterDuration.read(buf)
    }

    override fun allocationSize(value: java.time.Duration?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterDuration.allocationSize(value)
        }
    }

    override fun write(value: java.time.Duration?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterDuration.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeEventTimelineItem: FfiConverterRustBuffer<EventTimelineItem?> {
    override fun read(buf: ByteBuffer): EventTimelineItem? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeEventTimelineItem.read(buf)
    }

    override fun allocationSize(value: EventTimelineItem?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeEventTimelineItem.allocationSize(value)
        }
    }

    override fun write(value: EventTimelineItem?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeEventTimelineItem.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeHomeserverLoginDetails: FfiConverterRustBuffer<HomeserverLoginDetails?> {
    override fun read(buf: ByteBuffer): HomeserverLoginDetails? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeHomeserverLoginDetails.read(buf)
    }

    override fun allocationSize(value: HomeserverLoginDetails?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeHomeserverLoginDetails.allocationSize(value)
        }
    }

    override fun write(value: HomeserverLoginDetails?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeHomeserverLoginDetails.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeMediaSource: FfiConverterRustBuffer<MediaSource?> {
    override fun read(buf: ByteBuffer): MediaSource? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeMediaSource.read(buf)
    }

    override fun allocationSize(value: MediaSource?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeMediaSource.allocationSize(value)
        }
    }

    override fun write(value: MediaSource?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeMediaSource.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeMessage: FfiConverterRustBuffer<Message?> {
    override fun read(buf: ByteBuffer): Message? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeMessage.read(buf)
    }

    override fun allocationSize(value: Message?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeMessage.allocationSize(value)
        }
    }

    override fun write(value: Message?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeMessage.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeRoom: FfiConverterRustBuffer<Room?> {
    override fun read(buf: ByteBuffer): Room? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeRoom.read(buf)
    }

    override fun allocationSize(value: Room?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeRoom.allocationSize(value)
        }
    }

    override fun write(value: Room?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeRoom.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeRoomMember: FfiConverterRustBuffer<RoomMember?> {
    override fun read(buf: ByteBuffer): RoomMember? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeRoomMember.read(buf)
    }

    override fun allocationSize(value: RoomMember?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeRoomMember.allocationSize(value)
        }
    }

    override fun write(value: RoomMember?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeRoomMember.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeTaskHandle: FfiConverterRustBuffer<TaskHandle?> {
    override fun read(buf: ByteBuffer): TaskHandle? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeTaskHandle.read(buf)
    }

    override fun allocationSize(value: TaskHandle?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeTaskHandle.allocationSize(value)
        }
    }

    override fun write(value: TaskHandle?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeTaskHandle.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeTimelineItem: FfiConverterRustBuffer<TimelineItem?> {
    override fun read(buf: ByteBuffer): TimelineItem? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeTimelineItem.read(buf)
    }

    override fun allocationSize(value: TimelineItem?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeTimelineItem.allocationSize(value)
        }
    }

    override fun write(value: TimelineItem?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeTimelineItem.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeAudioInfo: FfiConverterRustBuffer<AudioInfo?> {
    override fun read(buf: ByteBuffer): AudioInfo? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeAudioInfo.read(buf)
    }

    override fun allocationSize(value: AudioInfo?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeAudioInfo.allocationSize(value)
        }
    }

    override fun write(value: AudioInfo?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeAudioInfo.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeFileInfo: FfiConverterRustBuffer<FileInfo?> {
    override fun read(buf: ByteBuffer): FileInfo? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeFileInfo.read(buf)
    }

    override fun allocationSize(value: FileInfo?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeFileInfo.allocationSize(value)
        }
    }

    override fun write(value: FileInfo?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeFileInfo.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeFormattedBody: FfiConverterRustBuffer<FormattedBody?> {
    override fun read(buf: ByteBuffer): FormattedBody? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeFormattedBody.read(buf)
    }

    override fun allocationSize(value: FormattedBody?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeFormattedBody.allocationSize(value)
        }
    }

    override fun write(value: FormattedBody?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeFormattedBody.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeImageInfo: FfiConverterRustBuffer<ImageInfo?> {
    override fun read(buf: ByteBuffer): ImageInfo? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeImageInfo.read(buf)
    }

    override fun allocationSize(value: ImageInfo?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeImageInfo.allocationSize(value)
        }
    }

    override fun write(value: ImageInfo?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeImageInfo.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeInReplyToDetails: FfiConverterRustBuffer<InReplyToDetails?> {
    override fun read(buf: ByteBuffer): InReplyToDetails? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeInReplyToDetails.read(buf)
    }

    override fun allocationSize(value: InReplyToDetails?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeInReplyToDetails.allocationSize(value)
        }
    }

    override fun write(value: InReplyToDetails?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeInReplyToDetails.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeInsertData: FfiConverterRustBuffer<InsertData?> {
    override fun read(buf: ByteBuffer): InsertData? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeInsertData.read(buf)
    }

    override fun allocationSize(value: InsertData?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeInsertData.allocationSize(value)
        }
    }

    override fun write(value: InsertData?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeInsertData.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeNotificationItem: FfiConverterRustBuffer<NotificationItem?> {
    override fun read(buf: ByteBuffer): NotificationItem? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeNotificationItem.read(buf)
    }

    override fun allocationSize(value: NotificationItem?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeNotificationItem.allocationSize(value)
        }
    }

    override fun write(value: NotificationItem?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeNotificationItem.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeNotificationPowerLevels: FfiConverterRustBuffer<NotificationPowerLevels?> {
    override fun read(buf: ByteBuffer): NotificationPowerLevels? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeNotificationPowerLevels.read(buf)
    }

    override fun allocationSize(value: NotificationPowerLevels?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeNotificationPowerLevels.allocationSize(value)
        }
    }

    override fun write(value: NotificationPowerLevels?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeNotificationPowerLevels.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeOidcConfiguration: FfiConverterRustBuffer<OidcConfiguration?> {
    override fun read(buf: ByteBuffer): OidcConfiguration? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeOidcConfiguration.read(buf)
    }

    override fun allocationSize(value: OidcConfiguration?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeOidcConfiguration.allocationSize(value)
        }
    }

    override fun write(value: OidcConfiguration?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeOidcConfiguration.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypePowerLevels: FfiConverterRustBuffer<PowerLevels?> {
    override fun read(buf: ByteBuffer): PowerLevels? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypePowerLevels.read(buf)
    }

    override fun allocationSize(value: PowerLevels?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypePowerLevels.allocationSize(value)
        }
    }

    override fun write(value: PowerLevels?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypePowerLevels.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeRoomSubscription: FfiConverterRustBuffer<RoomSubscription?> {
    override fun read(buf: ByteBuffer): RoomSubscription? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeRoomSubscription.read(buf)
    }

    override fun allocationSize(value: RoomSubscription?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeRoomSubscription.allocationSize(value)
        }
    }

    override fun write(value: RoomSubscription?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeRoomSubscription.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeSetData: FfiConverterRustBuffer<SetData?> {
    override fun read(buf: ByteBuffer): SetData? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeSetData.read(buf)
    }

    override fun allocationSize(value: SetData?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeSetData.allocationSize(value)
        }
    }

    override fun write(value: SetData?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeSetData.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeThumbnailInfo: FfiConverterRustBuffer<ThumbnailInfo?> {
    override fun read(buf: ByteBuffer): ThumbnailInfo? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeThumbnailInfo.read(buf)
    }

    override fun allocationSize(value: ThumbnailInfo?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeThumbnailInfo.allocationSize(value)
        }
    }

    override fun write(value: ThumbnailInfo?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeThumbnailInfo.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeTracingFileConfiguration: FfiConverterRustBuffer<TracingFileConfiguration?> {
    override fun read(buf: ByteBuffer): TracingFileConfiguration? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeTracingFileConfiguration.read(buf)
    }

    override fun allocationSize(value: TracingFileConfiguration?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeTracingFileConfiguration.allocationSize(value)
        }
    }

    override fun write(value: TracingFileConfiguration?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeTracingFileConfiguration.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeUnstableAudioDetailsContent: FfiConverterRustBuffer<UnstableAudioDetailsContent?> {
    override fun read(buf: ByteBuffer): UnstableAudioDetailsContent? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeUnstableAudioDetailsContent.read(buf)
    }

    override fun allocationSize(value: UnstableAudioDetailsContent?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeUnstableAudioDetailsContent.allocationSize(value)
        }
    }

    override fun write(value: UnstableAudioDetailsContent?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeUnstableAudioDetailsContent.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeUnstableVoiceContent: FfiConverterRustBuffer<UnstableVoiceContent?> {
    override fun read(buf: ByteBuffer): UnstableVoiceContent? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeUnstableVoiceContent.read(buf)
    }

    override fun allocationSize(value: UnstableVoiceContent?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeUnstableVoiceContent.allocationSize(value)
        }
    }

    override fun write(value: UnstableVoiceContent?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeUnstableVoiceContent.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeVideoInfo: FfiConverterRustBuffer<VideoInfo?> {
    override fun read(buf: ByteBuffer): VideoInfo? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeVideoInfo.read(buf)
    }

    override fun allocationSize(value: VideoInfo?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeVideoInfo.allocationSize(value)
        }
    }

    override fun write(value: VideoInfo?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeVideoInfo.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeAccountManagementAction: FfiConverterRustBuffer<AccountManagementAction?> {
    override fun read(buf: ByteBuffer): AccountManagementAction? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeAccountManagementAction.read(buf)
    }

    override fun allocationSize(value: AccountManagementAction?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeAccountManagementAction.allocationSize(value)
        }
    }

    override fun write(value: AccountManagementAction?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeAccountManagementAction.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeAssetType: FfiConverterRustBuffer<AssetType?> {
    override fun read(buf: ByteBuffer): AssetType? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeAssetType.read(buf)
    }

    override fun allocationSize(value: AssetType?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeAssetType.allocationSize(value)
        }
    }

    override fun write(value: AssetType?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeAssetType.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeEventItemOrigin: FfiConverterRustBuffer<EventItemOrigin?> {
    override fun read(buf: ByteBuffer): EventItemOrigin? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeEventItemOrigin.read(buf)
    }

    override fun allocationSize(value: EventItemOrigin?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeEventItemOrigin.allocationSize(value)
        }
    }

    override fun write(value: EventItemOrigin?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeEventItemOrigin.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeEventSendState: FfiConverterRustBuffer<EventSendState?> {
    override fun read(buf: ByteBuffer): EventSendState? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeEventSendState.read(buf)
    }

    override fun allocationSize(value: EventSendState?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeEventSendState.allocationSize(value)
        }
    }

    override fun write(value: EventSendState?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeEventSendState.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeMembershipChange: FfiConverterRustBuffer<MembershipChange?> {
    override fun read(buf: ByteBuffer): MembershipChange? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeMembershipChange.read(buf)
    }

    override fun allocationSize(value: MembershipChange?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeMembershipChange.allocationSize(value)
        }
    }

    override fun write(value: MembershipChange?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeMembershipChange.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypePushFormat: FfiConverterRustBuffer<PushFormat?> {
    override fun read(buf: ByteBuffer): PushFormat? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypePushFormat.read(buf)
    }

    override fun allocationSize(value: PushFormat?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypePushFormat.allocationSize(value)
        }
    }

    override fun write(value: PushFormat?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypePushFormat.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeRoomNotificationMode: FfiConverterRustBuffer<RoomNotificationMode?> {
    override fun read(buf: ByteBuffer): RoomNotificationMode? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeRoomNotificationMode.read(buf)
    }

    override fun allocationSize(value: RoomNotificationMode?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeRoomNotificationMode.allocationSize(value)
        }
    }

    override fun write(value: RoomNotificationMode?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeRoomNotificationMode.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeVirtualTimelineItem: FfiConverterRustBuffer<VirtualTimelineItem?> {
    override fun read(buf: ByteBuffer): VirtualTimelineItem? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeVirtualTimelineItem.read(buf)
    }

    override fun allocationSize(value: VirtualTimelineItem?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeVirtualTimelineItem.allocationSize(value)
        }
    }

    override fun write(value: VirtualTimelineItem?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeVirtualTimelineItem.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeBackupSteadyStateListener: FfiConverterRustBuffer<BackupSteadyStateListener?> {
    override fun read(buf: ByteBuffer): BackupSteadyStateListener? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeBackupSteadyStateListener.read(buf)
    }

    override fun allocationSize(value: BackupSteadyStateListener?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeBackupSteadyStateListener.allocationSize(value)
        }
    }

    override fun write(value: BackupSteadyStateListener?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeBackupSteadyStateListener.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeClientDelegate: FfiConverterRustBuffer<ClientDelegate?> {
    override fun read(buf: ByteBuffer): ClientDelegate? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeClientDelegate.read(buf)
    }

    override fun allocationSize(value: ClientDelegate?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeClientDelegate.allocationSize(value)
        }
    }

    override fun write(value: ClientDelegate?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeClientDelegate.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeClientSessionDelegate: FfiConverterRustBuffer<ClientSessionDelegate?> {
    override fun read(buf: ByteBuffer): ClientSessionDelegate? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeClientSessionDelegate.read(buf)
    }

    override fun allocationSize(value: ClientSessionDelegate?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeClientSessionDelegate.allocationSize(value)
        }
    }

    override fun write(value: ClientSessionDelegate?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeClientSessionDelegate.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeNotificationSettingsDelegate: FfiConverterRustBuffer<NotificationSettingsDelegate?> {
    override fun read(buf: ByteBuffer): NotificationSettingsDelegate? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeNotificationSettingsDelegate.read(buf)
    }

    override fun allocationSize(value: NotificationSettingsDelegate?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeNotificationSettingsDelegate.allocationSize(value)
        }
    }

    override fun write(value: NotificationSettingsDelegate?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeNotificationSettingsDelegate.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeProgressWatcher: FfiConverterRustBuffer<ProgressWatcher?> {
    override fun read(buf: ByteBuffer): ProgressWatcher? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeProgressWatcher.read(buf)
    }

    override fun allocationSize(value: ProgressWatcher?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeProgressWatcher.allocationSize(value)
        }
    }

    override fun write(value: ProgressWatcher?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeProgressWatcher.write(value, buf)
        }
    }
}




public object FfiConverterOptionalTypeSessionVerificationControllerDelegate: FfiConverterRustBuffer<SessionVerificationControllerDelegate?> {
    override fun read(buf: ByteBuffer): SessionVerificationControllerDelegate? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeSessionVerificationControllerDelegate.read(buf)
    }

    override fun allocationSize(value: SessionVerificationControllerDelegate?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterTypeSessionVerificationControllerDelegate.allocationSize(value)
        }
    }

    override fun write(value: SessionVerificationControllerDelegate?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeSessionVerificationControllerDelegate.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceString: FfiConverterRustBuffer<List<String>?> {
    override fun read(buf: ByteBuffer): List<String>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceString.read(buf)
    }

    override fun allocationSize(value: List<String>?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterSequenceString.allocationSize(value)
        }
    }

    override fun write(value: List<String>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceString.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceTypeRoomMember: FfiConverterRustBuffer<List<RoomMember>?> {
    override fun read(buf: ByteBuffer): List<RoomMember>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeRoomMember.read(buf)
    }

    override fun allocationSize(value: List<RoomMember>?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterSequenceTypeRoomMember.allocationSize(value)
        }
    }

    override fun write(value: List<RoomMember>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeRoomMember.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceTypeTimelineItem: FfiConverterRustBuffer<List<TimelineItem>?> {
    override fun read(buf: ByteBuffer): List<TimelineItem>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeTimelineItem.read(buf)
    }

    override fun allocationSize(value: List<TimelineItem>?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterSequenceTypeTimelineItem.allocationSize(value)
        }
    }

    override fun write(value: List<TimelineItem>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeTimelineItem.write(value, buf)
        }
    }
}




public object FfiConverterOptionalSequenceTypeRequiredState: FfiConverterRustBuffer<List<RequiredState>?> {
    override fun read(buf: ByteBuffer): List<RequiredState>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeRequiredState.read(buf)
    }

    override fun allocationSize(value: List<RequiredState>?): Int {
        if (value == null) {
            return 1
        } else {
            return 1 + FfiConverterSequenceTypeRequiredState.allocationSize(value)
        }
    }

    override fun write(value: List<RequiredState>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeRequiredState.write(value, buf)
        }
    }
}




public object FfiConverterSequenceUShort: FfiConverterRustBuffer<List<UShort>> {
    override fun read(buf: ByteBuffer): List<UShort> {
        val len = buf.getInt()
        return List<UShort>(len) {
            FfiConverterUShort.read(buf)
        }
    }

    override fun allocationSize(value: List<UShort>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterUShort.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<UShort>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterUShort.write(it, buf)
        }
    }
}




public object FfiConverterSequenceString: FfiConverterRustBuffer<List<String>> {
    override fun read(buf: ByteBuffer): List<String> {
        val len = buf.getInt()
        return List<String>(len) {
            FfiConverterString.read(buf)
        }
    }

    override fun allocationSize(value: List<String>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterString.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<String>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterString.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeRoom: FfiConverterRustBuffer<List<Room>> {
    override fun read(buf: ByteBuffer): List<Room> {
        val len = buf.getInt()
        return List<Room>(len) {
            FfiConverterTypeRoom.read(buf)
        }
    }

    override fun allocationSize(value: List<Room>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeRoom.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<Room>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeRoom.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeRoomMember: FfiConverterRustBuffer<List<RoomMember>> {
    override fun read(buf: ByteBuffer): List<RoomMember> {
        val len = buf.getInt()
        return List<RoomMember>(len) {
            FfiConverterTypeRoomMember.read(buf)
        }
    }

    override fun allocationSize(value: List<RoomMember>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeRoomMember.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<RoomMember>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeRoomMember.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeSessionVerificationEmoji: FfiConverterRustBuffer<List<SessionVerificationEmoji>> {
    override fun read(buf: ByteBuffer): List<SessionVerificationEmoji> {
        val len = buf.getInt()
        return List<SessionVerificationEmoji>(len) {
            FfiConverterTypeSessionVerificationEmoji.read(buf)
        }
    }

    override fun allocationSize(value: List<SessionVerificationEmoji>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeSessionVerificationEmoji.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<SessionVerificationEmoji>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeSessionVerificationEmoji.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeTimelineDiff: FfiConverterRustBuffer<List<TimelineDiff>> {
    override fun read(buf: ByteBuffer): List<TimelineDiff> {
        val len = buf.getInt()
        return List<TimelineDiff>(len) {
            FfiConverterTypeTimelineDiff.read(buf)
        }
    }

    override fun allocationSize(value: List<TimelineDiff>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeTimelineDiff.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<TimelineDiff>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeTimelineDiff.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeTimelineItem: FfiConverterRustBuffer<List<TimelineItem>> {
    override fun read(buf: ByteBuffer): List<TimelineItem> {
        val len = buf.getInt()
        return List<TimelineItem>(len) {
            FfiConverterTypeTimelineItem.read(buf)
        }
    }

    override fun allocationSize(value: List<TimelineItem>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeTimelineItem.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<TimelineItem>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeTimelineItem.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypePollAnswer: FfiConverterRustBuffer<List<PollAnswer>> {
    override fun read(buf: ByteBuffer): List<PollAnswer> {
        val len = buf.getInt()
        return List<PollAnswer>(len) {
            FfiConverterTypePollAnswer.read(buf)
        }
    }

    override fun allocationSize(value: List<PollAnswer>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypePollAnswer.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<PollAnswer>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypePollAnswer.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeReaction: FfiConverterRustBuffer<List<Reaction>> {
    override fun read(buf: ByteBuffer): List<Reaction> {
        val len = buf.getInt()
        return List<Reaction>(len) {
            FfiConverterTypeReaction.read(buf)
        }
    }

    override fun allocationSize(value: List<Reaction>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeReaction.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<Reaction>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeReaction.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeReactionSenderData: FfiConverterRustBuffer<List<ReactionSenderData>> {
    override fun read(buf: ByteBuffer): List<ReactionSenderData> {
        val len = buf.getInt()
        return List<ReactionSenderData>(len) {
            FfiConverterTypeReactionSenderData.read(buf)
        }
    }

    override fun allocationSize(value: List<ReactionSenderData>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeReactionSenderData.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<ReactionSenderData>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeReactionSenderData.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeRequiredState: FfiConverterRustBuffer<List<RequiredState>> {
    override fun read(buf: ByteBuffer): List<RequiredState> {
        val len = buf.getInt()
        return List<RequiredState>(len) {
            FfiConverterTypeRequiredState.read(buf)
        }
    }

    override fun allocationSize(value: List<RequiredState>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeRequiredState.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<RequiredState>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeRequiredState.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeRoomListRange: FfiConverterRustBuffer<List<RoomListRange>> {
    override fun read(buf: ByteBuffer): List<RoomListRange> {
        val len = buf.getInt()
        return List<RoomListRange>(len) {
            FfiConverterTypeRoomListRange.read(buf)
        }
    }

    override fun allocationSize(value: List<RoomListRange>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeRoomListRange.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<RoomListRange>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeRoomListRange.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeUserProfile: FfiConverterRustBuffer<List<UserProfile>> {
    override fun read(buf: ByteBuffer): List<UserProfile> {
        val len = buf.getInt()
        return List<UserProfile>(len) {
            FfiConverterTypeUserProfile.read(buf)
        }
    }

    override fun allocationSize(value: List<UserProfile>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeUserProfile.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<UserProfile>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeUserProfile.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeRoomListEntriesUpdate: FfiConverterRustBuffer<List<RoomListEntriesUpdate>> {
    override fun read(buf: ByteBuffer): List<RoomListEntriesUpdate> {
        val len = buf.getInt()
        return List<RoomListEntriesUpdate>(len) {
            FfiConverterTypeRoomListEntriesUpdate.read(buf)
        }
    }

    override fun allocationSize(value: List<RoomListEntriesUpdate>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeRoomListEntriesUpdate.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<RoomListEntriesUpdate>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeRoomListEntriesUpdate.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeRoomListEntry: FfiConverterRustBuffer<List<RoomListEntry>> {
    override fun read(buf: ByteBuffer): List<RoomListEntry> {
        val len = buf.getInt()
        return List<RoomListEntry>(len) {
            FfiConverterTypeRoomListEntry.read(buf)
        }
    }

    override fun allocationSize(value: List<RoomListEntry>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeRoomListEntry.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<RoomListEntry>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeRoomListEntry.write(it, buf)
        }
    }
}




public object FfiConverterSequenceTypeWidgetEventFilter: FfiConverterRustBuffer<List<WidgetEventFilter>> {
    override fun read(buf: ByteBuffer): List<WidgetEventFilter> {
        val len = buf.getInt()
        return List<WidgetEventFilter>(len) {
            FfiConverterTypeWidgetEventFilter.read(buf)
        }
    }

    override fun allocationSize(value: List<WidgetEventFilter>): Int {
        val sizeForLength = 4
        val sizeForItems = value.map { FfiConverterTypeWidgetEventFilter.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<WidgetEventFilter>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.forEach {
            FfiConverterTypeWidgetEventFilter.write(it, buf)
        }
    }
}



public object FfiConverterMapStringInt: FfiConverterRustBuffer<Map<String, Int>> {
    override fun read(buf: ByteBuffer): Map<String, Int> {
        val len = buf.getInt()
        return buildMap<String, Int>(len) {
            repeat(len) {
                val k = FfiConverterString.read(buf)
                val v = FfiConverterInt.read(buf)
                this[k] = v
            }
        }
    }

    override fun allocationSize(value: Map<String, Int>): Int {
        val spaceForMapSize = 4
        val spaceForChildren = value.map { (k, v) ->
            FfiConverterString.allocationSize(k) +
            FfiConverterInt.allocationSize(v)
        }.sum()
        return spaceForMapSize + spaceForChildren
    }

    override fun write(value: Map<String, Int>, buf: ByteBuffer) {
        buf.putInt(value.size)
        // The parens on `(k, v)` here ensure we're calling the right method,
        // which is important for compatibility with older android devices.
        // Ref https://blog.danlew.net/2017/03/16/kotlin-puzzler-whose-line-is-it-anyways/
        value.forEach { (k, v) ->
            FfiConverterString.write(k, buf)
            FfiConverterInt.write(v, buf)
        }
    }
}



public object FfiConverterMapStringString: FfiConverterRustBuffer<Map<String, String>> {
    override fun read(buf: ByteBuffer): Map<String, String> {
        val len = buf.getInt()
        return buildMap<String, String>(len) {
            repeat(len) {
                val k = FfiConverterString.read(buf)
                val v = FfiConverterString.read(buf)
                this[k] = v
            }
        }
    }

    override fun allocationSize(value: Map<String, String>): Int {
        val spaceForMapSize = 4
        val spaceForChildren = value.map { (k, v) ->
            FfiConverterString.allocationSize(k) +
            FfiConverterString.allocationSize(v)
        }.sum()
        return spaceForMapSize + spaceForChildren
    }

    override fun write(value: Map<String, String>, buf: ByteBuffer) {
        buf.putInt(value.size)
        // The parens on `(k, v)` here ensure we're calling the right method,
        // which is important for compatibility with older android devices.
        // Ref https://blog.danlew.net/2017/03/16/kotlin-puzzler-whose-line-is-it-anyways/
        value.forEach { (k, v) ->
            FfiConverterString.write(k, buf)
            FfiConverterString.write(v, buf)
        }
    }
}



public object FfiConverterMapStringTypeReceipt: FfiConverterRustBuffer<Map<String, Receipt>> {
    override fun read(buf: ByteBuffer): Map<String, Receipt> {
        val len = buf.getInt()
        return buildMap<String, Receipt>(len) {
            repeat(len) {
                val k = FfiConverterString.read(buf)
                val v = FfiConverterTypeReceipt.read(buf)
                this[k] = v
            }
        }
    }

    override fun allocationSize(value: Map<String, Receipt>): Int {
        val spaceForMapSize = 4
        val spaceForChildren = value.map { (k, v) ->
            FfiConverterString.allocationSize(k) +
            FfiConverterTypeReceipt.allocationSize(v)
        }.sum()
        return spaceForMapSize + spaceForChildren
    }

    override fun write(value: Map<String, Receipt>, buf: ByteBuffer) {
        buf.putInt(value.size)
        // The parens on `(k, v)` here ensure we're calling the right method,
        // which is important for compatibility with older android devices.
        // Ref https://blog.danlew.net/2017/03/16/kotlin-puzzler-whose-line-is-it-anyways/
        value.forEach { (k, v) ->
            FfiConverterString.write(k, buf)
            FfiConverterTypeReceipt.write(v, buf)
        }
    }
}



public object FfiConverterMapStringSequenceString: FfiConverterRustBuffer<Map<String, List<String>>> {
    override fun read(buf: ByteBuffer): Map<String, List<String>> {
        val len = buf.getInt()
        return buildMap<String, List<String>>(len) {
            repeat(len) {
                val k = FfiConverterString.read(buf)
                val v = FfiConverterSequenceString.read(buf)
                this[k] = v
            }
        }
    }

    override fun allocationSize(value: Map<String, List<String>>): Int {
        val spaceForMapSize = 4
        val spaceForChildren = value.map { (k, v) ->
            FfiConverterString.allocationSize(k) +
            FfiConverterSequenceString.allocationSize(v)
        }.sum()
        return spaceForMapSize + spaceForChildren
    }

    override fun write(value: Map<String, List<String>>, buf: ByteBuffer) {
        buf.putInt(value.size)
        // The parens on `(k, v)` here ensure we're calling the right method,
        // which is important for compatibility with older android devices.
        // Ref https://blog.danlew.net/2017/03/16/kotlin-puzzler-whose-line-is-it-anyways/
        value.forEach { (k, v) ->
            FfiConverterString.write(k, buf)
            FfiConverterSequenceString.write(v, buf)
        }
    }
}





fun `genTransactionId`(): String {
    return FfiConverterString.lift(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_gen_transaction_id(_status)
})
}

@Throws(ParseException::class)

@Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
suspend fun `generateWebviewUrl`(`widgetSettings`: WidgetSettings, `room`: Room, `props`: ClientProperties) : String {
    return uniffiRustCallAsync(
        _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_generate_webview_url(FfiConverterTypeWidgetSettings.lower(`widgetSettings`),FfiConverterTypeRoom.lower(`room`),FfiConverterTypeClientProperties.lower(`props`),),
        { future, callback, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> _UniFFILib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterString.lift(it) },
        // Error FFI converter
        ParseException.ErrorHandler,
    )
}

fun `getElementCallRequiredPermissions`(): WidgetCapabilities {
    return FfiConverterTypeWidgetCapabilities.lift(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_get_element_call_required_permissions(_status)
})
}


fun `logEvent`(`file`: String, `line`: UInt?, `level`: LogLevel, `target`: String, `message`: String) =
    
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_log_event(FfiConverterString.lower(`file`),FfiConverterOptionalUInt.lower(`line`),FfiConverterTypeLogLevel.lower(`level`),FfiConverterString.lower(`target`),FfiConverterString.lower(`message`),_status)
}


@Throws(ParseException::class)

fun `makeWidgetDriver`(`settings`: WidgetSettings): WidgetDriverAndHandle {
    return FfiConverterTypeWidgetDriverAndHandle.lift(
    rustCallWithError(ParseException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_make_widget_driver(FfiConverterTypeWidgetSettings.lower(`settings`),_status)
})
}


fun `mediaSourceFromUrl`(`url`: String): MediaSource {
    return FfiConverterTypeMediaSource.lift(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_media_source_from_url(FfiConverterString.lower(`url`),_status)
})
}


fun `messageEventContentFromHtml`(`body`: String, `htmlBody`: String): RoomMessageEventContentWithoutRelation {
    return FfiConverterTypeRoomMessageEventContentWithoutRelation.lift(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_message_event_content_from_html(FfiConverterString.lower(`body`),FfiConverterString.lower(`htmlBody`),_status)
})
}


fun `messageEventContentFromHtmlAsEmote`(`body`: String, `htmlBody`: String): RoomMessageEventContentWithoutRelation {
    return FfiConverterTypeRoomMessageEventContentWithoutRelation.lift(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_message_event_content_from_html_as_emote(FfiConverterString.lower(`body`),FfiConverterString.lower(`htmlBody`),_status)
})
}


fun `messageEventContentFromMarkdown`(`md`: String): RoomMessageEventContentWithoutRelation {
    return FfiConverterTypeRoomMessageEventContentWithoutRelation.lift(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_message_event_content_from_markdown(FfiConverterString.lower(`md`),_status)
})
}


fun `messageEventContentFromMarkdownAsEmote`(`md`: String): RoomMessageEventContentWithoutRelation {
    return FfiConverterTypeRoomMessageEventContentWithoutRelation.lift(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_message_event_content_from_markdown_as_emote(FfiConverterString.lower(`md`),_status)
})
}

@Throws(ClientException::class)

fun `messageEventContentNew`(`msgtype`: MessageType): RoomMessageEventContentWithoutRelation {
    return FfiConverterTypeRoomMessageEventContentWithoutRelation.lift(
    rustCallWithError(ClientException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_message_event_content_new(FfiConverterTypeMessageType.lower(`msgtype`),_status)
})
}

@Throws(ParseException::class)

fun `newVirtualElementCallWidget`(`props`: VirtualElementCallWidgetOptions): WidgetSettings {
    return FfiConverterTypeWidgetSettings.lift(
    rustCallWithError(ParseException) { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_new_virtual_element_call_widget(FfiConverterTypeVirtualElementCallWidgetOptions.lower(`props`),_status)
})
}


fun `sdkGitSha`(): String {
    return FfiConverterString.lift(
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_sdk_git_sha(_status)
})
}


fun `setupOtlpTracing`(`config`: OtlpTracingConfiguration) =
    
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_setup_otlp_tracing(FfiConverterTypeOtlpTracingConfiguration.lower(`config`),_status)
}



fun `setupTracing`(`config`: TracingConfiguration) =
    
    rustCall() { _status ->
    _UniFFILib.INSTANCE.uniffi_matrix_sdk_ffi_fn_func_setup_tracing(FfiConverterTypeTracingConfiguration.lower(`config`),_status)
}



