// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("NAME_SHADOWING")

package org.matrix.rustcomponents.sdk;

// Common helper code.
//
// Ideally this would live in a separate .kt file where it can be unittested etc
// in isolation, and perhaps even published as a re-useable package.
//
// However, it's important that the details of how this helper code works (e.g. the
// way that different builtin types are passed across the FFI) exactly match what's
// expected by the Rust code on the other side of the interface. In practice right
// now that means coming from the exact some version of `uniffi` that was used to
// compile the Rust component. The easiest way to ensure this is to bundle the Kotlin
// helpers directly inline like we're doing here.

import com.sun.jna.Library
import com.sun.jna.IntegerType
import com.sun.jna.Native
import com.sun.jna.Pointer
import com.sun.jna.Structure
import com.sun.jna.Callback
import com.sun.jna.ptr.*
import java.nio.ByteBuffer
import java.nio.ByteOrder
import java.nio.CharBuffer
import java.nio.charset.CodingErrorAction
import java.util.concurrent.atomic.AtomicLong
import java.util.concurrent.ConcurrentHashMap
import android.os.Build
import androidx.annotation.RequiresApi
import java.util.concurrent.atomic.AtomicBoolean
import kotlin.coroutines.resume
import kotlinx.coroutines.CancellableContinuation
import kotlinx.coroutines.DelicateCoroutinesApi
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.Job
import kotlinx.coroutines.launch
import kotlinx.coroutines.suspendCancellableCoroutine
import uniffi.matrix_sdk.BackupDownloadStrategy
import uniffi.matrix_sdk.FfiConverterTypeBackupDownloadStrategy
import uniffi.matrix_sdk.FfiConverterTypeRoomMemberRole
import uniffi.matrix_sdk.FfiConverterTypeRoomPowerLevelChanges
import uniffi.matrix_sdk.RoomMemberRole
import uniffi.matrix_sdk.RoomPowerLevelChanges
import uniffi.matrix_sdk_base.ComposerDraft
import uniffi.matrix_sdk_base.FfiConverterTypeComposerDraft
import uniffi.matrix_sdk_crypto.FfiConverterTypeUtdCause
import uniffi.matrix_sdk_crypto.UtdCause
import uniffi.matrix_sdk_ui.EventItemOrigin
import uniffi.matrix_sdk_ui.FfiConverterTypeEventItemOrigin
import uniffi.matrix_sdk_ui.FfiConverterTypeLiveBackPaginationStatus
import uniffi.matrix_sdk_ui.LiveBackPaginationStatus
import uniffi.matrix_sdk.RustBuffer as RustBufferBackupDownloadStrategy
import uniffi.matrix_sdk.RustBuffer as RustBufferRoomMemberRole
import uniffi.matrix_sdk.RustBuffer as RustBufferRoomPowerLevelChanges
import uniffi.matrix_sdk_base.RustBuffer as RustBufferComposerDraft
import uniffi.matrix_sdk_crypto.RustBuffer as RustBufferUtdCause
import uniffi.matrix_sdk_ui.RustBuffer as RustBufferEventItemOrigin
import uniffi.matrix_sdk_ui.RustBuffer as RustBufferLiveBackPaginationStatus

// This is a helper for safely working with byte buffers returned from the Rust code.
// A rust-owned buffer is represented by its capacity, its current length, and a
// pointer to the underlying data.

@Structure.FieldOrder("capacity", "len", "data")
open class RustBuffer : Structure() {
    // Note: `capacity` and `len` are actually `ULong` values, but JVM only supports signed values.
    // When dealing with these fields, make sure to call `toULong()`.
    @JvmField var capacity: Long = 0
    @JvmField var len: Long = 0
    @JvmField var data: Pointer? = null

    class ByValue: RustBuffer(), Structure.ByValue
    class ByReference: RustBuffer(), Structure.ByReference

   internal fun setValue(other: RustBuffer) {
        capacity = other.capacity
        len = other.len
        data = other.data
    }

    companion object {
        internal fun alloc(size: ULong = 0UL) = uniffiRustCall() { status ->
            // Note: need to convert the size to a `Long` value to make this work with JVM.
            UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rustbuffer_alloc(size.toLong(), status)
        }.also {
            if(it.data == null) {
               throw RuntimeException("RustBuffer.alloc() returned null data pointer (size=${size})")
           }
        }

        internal fun create(capacity: ULong, len: ULong, data: Pointer?): RustBuffer.ByValue {
            var buf = RustBuffer.ByValue()
            buf.capacity = capacity.toLong()
            buf.len = len.toLong()
            buf.data = data
            return buf
        }

        internal fun free(buf: RustBuffer.ByValue) = uniffiRustCall() { status ->
            UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rustbuffer_free(buf, status)
        }
    }

    @Suppress("TooGenericExceptionThrown")
    fun asByteBuffer() =
        this.data?.getByteBuffer(0, this.len.toLong())?.also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
}

/**
 * The equivalent of the `*mut RustBuffer` type.
 * Required for callbacks taking in an out pointer.
 *
 * Size is the sum of all values in the struct.
 */
class RustBufferByReference : ByReference(16) {
    /**
     * Set the pointed-to `RustBuffer` to the given value.
     */
    fun setValue(value: RustBuffer.ByValue) {
        // NOTE: The offsets are as they are in the C-like struct.
        val pointer = getPointer()
        pointer.setLong(0, value.capacity)
        pointer.setLong(8, value.len)
        pointer.setPointer(16, value.data)
    }

    /**
     * Get a `RustBuffer.ByValue` from this reference.
     */
    fun getValue(): RustBuffer.ByValue {
        val pointer = getPointer()
        val value = RustBuffer.ByValue()
        value.writeField("capacity", pointer.getLong(0))
        value.writeField("len", pointer.getLong(8))
        value.writeField("data", pointer.getLong(16))

        return value
    }
}

// This is a helper for safely passing byte references into the rust code.
// It's not actually used at the moment, because there aren't many things that you
// can take a direct pointer to in the JVM, and if we're going to copy something
// then we might as well copy it into a `RustBuffer`. But it's here for API
// completeness.

@Structure.FieldOrder("len", "data")
open class ForeignBytes : Structure() {
    @JvmField var len: Int = 0
    @JvmField var data: Pointer? = null

    class ByValue : ForeignBytes(), Structure.ByValue
}
// The FfiConverter interface handles converter types to and from the FFI
//
// All implementing objects should be public to support external types.  When a
// type is external we need to import it's FfiConverter.
public interface FfiConverter<KotlinType, FfiType> {
    // Convert an FFI type to a Kotlin type
    fun lift(value: FfiType): KotlinType

    // Convert an Kotlin type to an FFI type
    fun lower(value: KotlinType): FfiType

    // Read a Kotlin type from a `ByteBuffer`
    fun read(buf: ByteBuffer): KotlinType

    // Calculate bytes to allocate when creating a `RustBuffer`
    //
    // This must return at least as many bytes as the write() function will
    // write. It can return more bytes than needed, for example when writing
    // Strings we can't know the exact bytes needed until we the UTF-8
    // encoding, so we pessimistically allocate the largest size possible (3
    // bytes per codepoint).  Allocating extra bytes is not really a big deal
    // because the `RustBuffer` is short-lived.
    fun allocationSize(value: KotlinType): ULong

    // Write a Kotlin type to a `ByteBuffer`
    fun write(value: KotlinType, buf: ByteBuffer)

    // Lower a value into a `RustBuffer`
    //
    // This method lowers a value into a `RustBuffer` rather than the normal
    // FfiType.  It's used by the callback interface code.  Callback interface
    // returns are always serialized into a `RustBuffer` regardless of their
    // normal FFI type.
    fun lowerIntoRustBuffer(value: KotlinType): RustBuffer.ByValue {
        val rbuf = RustBuffer.alloc(allocationSize(value))
        try {
            val bbuf = rbuf.data!!.getByteBuffer(0, rbuf.capacity).also {
                it.order(ByteOrder.BIG_ENDIAN)
            }
            write(value, bbuf)
            rbuf.writeField("len", bbuf.position().toLong())
            return rbuf
        } catch (e: Throwable) {
            RustBuffer.free(rbuf)
            throw e
        }
    }

    // Lift a value from a `RustBuffer`.
    //
    // This here mostly because of the symmetry with `lowerIntoRustBuffer()`.
    // It's currently only used by the `FfiConverterRustBuffer` class below.
    fun liftFromRustBuffer(rbuf: RustBuffer.ByValue): KotlinType {
        val byteBuf = rbuf.asByteBuffer()!!
        try {
           val item = read(byteBuf)
           if (byteBuf.hasRemaining()) {
               throw RuntimeException("junk remaining in buffer after lifting, something is very wrong!!")
           }
           return item
        } finally {
            RustBuffer.free(rbuf)
        }
    }
}

// FfiConverter that uses `RustBuffer` as the FfiType
public interface FfiConverterRustBuffer<KotlinType>: FfiConverter<KotlinType, RustBuffer.ByValue> {
    override fun lift(value: RustBuffer.ByValue) = liftFromRustBuffer(value)
    override fun lower(value: KotlinType) = lowerIntoRustBuffer(value)
}
// A handful of classes and functions to support the generated data structures.
// This would be a good candidate for isolating in its own ffi-support lib.

internal const val UNIFFI_CALL_SUCCESS = 0.toByte()
internal const val UNIFFI_CALL_ERROR = 1.toByte()
internal const val UNIFFI_CALL_UNEXPECTED_ERROR = 2.toByte()

@Structure.FieldOrder("code", "error_buf")
internal open class UniffiRustCallStatus : Structure() {
    @JvmField var code: Byte = 0
    @JvmField var error_buf: RustBuffer.ByValue = RustBuffer.ByValue()

    class ByValue: UniffiRustCallStatus(), Structure.ByValue

    fun isSuccess(): Boolean {
        return code == UNIFFI_CALL_SUCCESS
    }

    fun isError(): Boolean {
        return code == UNIFFI_CALL_ERROR
    }

    fun isPanic(): Boolean {
        return code == UNIFFI_CALL_UNEXPECTED_ERROR
    }

    companion object {
        fun create(code: Byte, errorBuf: RustBuffer.ByValue): UniffiRustCallStatus.ByValue {
            val callStatus = UniffiRustCallStatus.ByValue()
            callStatus.code = code
            callStatus.error_buf = errorBuf
            return callStatus
        }
    }
}

class InternalException(message: String) : Exception(message)

// Each top-level error class has a companion object that can lift the error from the call status's rust buffer
interface UniffiRustCallStatusErrorHandler<E> {
    fun lift(error_buf: RustBuffer.ByValue): E;
}

// Helpers for calling Rust
// In practice we usually need to be synchronized to call this safely, so it doesn't
// synchronize itself

// Call a rust function that returns a Result<>.  Pass in the Error class companion that corresponds to the Err
private inline fun <U, E: Exception> uniffiRustCallWithError(errorHandler: UniffiRustCallStatusErrorHandler<E>, callback: (UniffiRustCallStatus) -> U): U {
    var status = UniffiRustCallStatus();
    val return_value = callback(status)
    uniffiCheckCallStatus(errorHandler, status)
    return return_value
}

// Check UniffiRustCallStatus and throw an error if the call wasn't successful
private fun<E: Exception> uniffiCheckCallStatus(errorHandler: UniffiRustCallStatusErrorHandler<E>, status: UniffiRustCallStatus) {
    if (status.isSuccess()) {
        return
    } else if (status.isError()) {
        throw errorHandler.lift(status.error_buf)
    } else if (status.isPanic()) {
        // when the rust code sees a panic, it tries to construct a rustbuffer
        // with the message.  but if that code panics, then it just sends back
        // an empty buffer.
        if (status.error_buf.len > 0) {
            throw InternalException(FfiConverterString.lift(status.error_buf))
        } else {
            throw InternalException("Rust panic")
        }
    } else {
        throw InternalException("Unknown rust call status: $status.code")
    }
}

// UniffiRustCallStatusErrorHandler implementation for times when we don't expect a CALL_ERROR
object UniffiNullRustCallStatusErrorHandler: UniffiRustCallStatusErrorHandler<InternalException> {
    override fun lift(error_buf: RustBuffer.ByValue): InternalException {
        RustBuffer.free(error_buf)
        return InternalException("Unexpected CALL_ERROR")
    }
}

// Call a rust function that returns a plain value
private inline fun <U> uniffiRustCall(callback: (UniffiRustCallStatus) -> U): U {
    return uniffiRustCallWithError(UniffiNullRustCallStatusErrorHandler, callback);
}

internal inline fun<T> uniffiTraitInterfaceCall(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
) {
    try {
        writeReturn(makeCall())
    } catch(e: Exception) {
        callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
        callStatus.error_buf = FfiConverterString.lower(e.toString())
    }
}

internal inline fun<T, reified E: Throwable> uniffiTraitInterfaceCallWithError(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
    lowerError: (E) -> RustBuffer.ByValue
) {
    try {
        writeReturn(makeCall())
    } catch(e: Exception) {
        if (e is E) {
            callStatus.code = UNIFFI_CALL_ERROR
            callStatus.error_buf = lowerError(e)
        } else {
            callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
            callStatus.error_buf = FfiConverterString.lower(e.toString())
        }
    }
}
// Map handles to objects
//
// This is used pass an opaque 64-bit handle representing a foreign object to the Rust code.
internal class UniffiHandleMap<T: Any> {
    private val map = ConcurrentHashMap<Long, T>()
    private val counter = java.util.concurrent.atomic.AtomicLong(0)

    val size: Int
        get() = map.size

    // Insert a new object into the handle map and get a handle for it
    fun insert(obj: T): Long {
        val handle = counter.getAndAdd(1)
        map.put(handle, obj)
        return handle
    }

    // Get an object from the handle map
    fun get(handle: Long): T {
        return map.get(handle) ?: throw InternalException("UniffiHandleMap.get: Invalid handle")
    }

    // Remove an entry from the handlemap and get the Kotlin object back
    fun remove(handle: Long): T {
        return map.remove(handle) ?: throw InternalException("UniffiHandleMap: Invalid handle")
    }
}

// Contains loading, initialization code,
// and the FFI Function declarations in a com.sun.jna.Library.
@Synchronized
private fun findLibraryName(componentName: String): String {
    val libOverride = System.getProperty("uniffi.component.$componentName.libraryOverride")
    if (libOverride != null) {
        return libOverride
    }
    return "matrix_sdk_ffi"
}

private inline fun <reified Lib : Library> loadIndirect(
    componentName: String
): Lib {
    return Native.load<Lib>(findLibraryName(componentName), Lib::class.java)
}

// Define FFI callback types
internal interface UniffiRustFutureContinuationCallback : com.sun.jna.Callback {
    fun callback(`data`: Long,`pollResult`: Byte,)
}
internal interface UniffiForeignFutureFree : com.sun.jna.Callback {
    fun callback(`handle`: Long,)
}
internal interface UniffiCallbackInterfaceFree : com.sun.jna.Callback {
    fun callback(`handle`: Long,)
}
@Structure.FieldOrder("handle", "free")
internal open class UniffiForeignFuture(
    @JvmField internal var `handle`: Long = 0.toLong(),
    @JvmField internal var `free`: UniffiForeignFutureFree? = null,
) : Structure() {
    class UniffiByValue(
        `handle`: Long = 0.toLong(),
        `free`: UniffiForeignFutureFree? = null,
    ): UniffiForeignFuture(`handle`,`free`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFuture) {
        `handle` = other.`handle`
        `free` = other.`free`
    }

}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU8(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU8 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU8.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI8(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI8 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI8.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU16(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU16 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU16.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI16(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI16 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI16.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructF32(
    @JvmField internal var `returnValue`: Float = 0.0f,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Float = 0.0f,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructF32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructF32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteF32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructF32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructF64(
    @JvmField internal var `returnValue`: Double = 0.0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Double = 0.0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructF64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructF64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteF64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructF64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructPointer(
    @JvmField internal var `returnValue`: Pointer = Pointer.NULL,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Pointer = Pointer.NULL,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructPointer(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructPointer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompletePointer : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructPointer.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructRustBuffer(
    @JvmField internal var `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructRustBuffer(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructRustBuffer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteRustBuffer : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructRustBuffer.UniffiByValue,)
}
@Structure.FieldOrder("callStatus")
internal open class UniffiForeignFutureStructVoid(
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructVoid(`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructVoid) {
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteVoid : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructVoid.UniffiByValue,)
}
internal interface UniffiCallbackInterfaceBackupStateListenerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`status`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceBackupSteadyStateListenerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`status`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceClientDelegateMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`isSoftLogout`: Byte,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceClientDelegateMethod1 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceClientSessionDelegateMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`userId`: RustBuffer.ByValue,`uniffiOutReturn`: RustBuffer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceClientSessionDelegateMethod1 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`session`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceEnableRecoveryProgressListenerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`status`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceIgnoredUsersListenerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`ignoredUserIds`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceNotificationSettingsDelegateMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfacePaginationStatusListenerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`status`: RustBufferLiveBackPaginationStatus.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceProgressWatcherMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`progress`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceQrLoginProgressListenerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`state`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceRecoveryStateListenerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`status`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceRoomDirectorySearchEntriesListenerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`roomEntriesUpdate`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceRoomInfoListenerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`roomInfo`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceRoomListEntriesListenerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`roomEntriesUpdate`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceRoomListLoadingStateListenerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`state`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceRoomListServiceStateListenerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`state`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceRoomListServiceSyncIndicatorListenerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`syncIndicator`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceSendQueueRoomErrorListenerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`roomId`: RustBuffer.ByValue,`error`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceSessionVerificationControllerDelegateMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceSessionVerificationControllerDelegateMethod1 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceSessionVerificationControllerDelegateMethod2 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`data`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceSessionVerificationControllerDelegateMethod3 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceSessionVerificationControllerDelegateMethod4 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceSessionVerificationControllerDelegateMethod5 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceSyncServiceStateObserverMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`state`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceTimelineListenerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`diff`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceTypingNotificationsListenerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`typingUserIds`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceUnableToDecryptDelegateMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`info`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceVerificationStateListenerMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`status`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceWidgetCapabilitiesProviderMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`capabilities`: RustBuffer.ByValue,`uniffiOutReturn`: RustBuffer,uniffiCallStatus: UniffiRustCallStatus,)
}
@Structure.FieldOrder("onUpdate", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceBackupStateListener(
    @JvmField internal var `onUpdate`: UniffiCallbackInterfaceBackupStateListenerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onUpdate`: UniffiCallbackInterfaceBackupStateListenerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceBackupStateListener(`onUpdate`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceBackupStateListener) {
        `onUpdate` = other.`onUpdate`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onUpdate", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceBackupSteadyStateListener(
    @JvmField internal var `onUpdate`: UniffiCallbackInterfaceBackupSteadyStateListenerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onUpdate`: UniffiCallbackInterfaceBackupSteadyStateListenerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceBackupSteadyStateListener(`onUpdate`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceBackupSteadyStateListener) {
        `onUpdate` = other.`onUpdate`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("didReceiveAuthError", "didRefreshTokens", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceClientDelegate(
    @JvmField internal var `didReceiveAuthError`: UniffiCallbackInterfaceClientDelegateMethod0? = null,
    @JvmField internal var `didRefreshTokens`: UniffiCallbackInterfaceClientDelegateMethod1? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `didReceiveAuthError`: UniffiCallbackInterfaceClientDelegateMethod0? = null,
        `didRefreshTokens`: UniffiCallbackInterfaceClientDelegateMethod1? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceClientDelegate(`didReceiveAuthError`,`didRefreshTokens`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceClientDelegate) {
        `didReceiveAuthError` = other.`didReceiveAuthError`
        `didRefreshTokens` = other.`didRefreshTokens`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("retrieveSessionFromKeychain", "saveSessionInKeychain", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceClientSessionDelegate(
    @JvmField internal var `retrieveSessionFromKeychain`: UniffiCallbackInterfaceClientSessionDelegateMethod0? = null,
    @JvmField internal var `saveSessionInKeychain`: UniffiCallbackInterfaceClientSessionDelegateMethod1? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `retrieveSessionFromKeychain`: UniffiCallbackInterfaceClientSessionDelegateMethod0? = null,
        `saveSessionInKeychain`: UniffiCallbackInterfaceClientSessionDelegateMethod1? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceClientSessionDelegate(`retrieveSessionFromKeychain`,`saveSessionInKeychain`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceClientSessionDelegate) {
        `retrieveSessionFromKeychain` = other.`retrieveSessionFromKeychain`
        `saveSessionInKeychain` = other.`saveSessionInKeychain`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onUpdate", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceEnableRecoveryProgressListener(
    @JvmField internal var `onUpdate`: UniffiCallbackInterfaceEnableRecoveryProgressListenerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onUpdate`: UniffiCallbackInterfaceEnableRecoveryProgressListenerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceEnableRecoveryProgressListener(`onUpdate`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceEnableRecoveryProgressListener) {
        `onUpdate` = other.`onUpdate`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("call", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceIgnoredUsersListener(
    @JvmField internal var `call`: UniffiCallbackInterfaceIgnoredUsersListenerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `call`: UniffiCallbackInterfaceIgnoredUsersListenerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceIgnoredUsersListener(`call`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceIgnoredUsersListener) {
        `call` = other.`call`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("settingsDidChange", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceNotificationSettingsDelegate(
    @JvmField internal var `settingsDidChange`: UniffiCallbackInterfaceNotificationSettingsDelegateMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `settingsDidChange`: UniffiCallbackInterfaceNotificationSettingsDelegateMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceNotificationSettingsDelegate(`settingsDidChange`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceNotificationSettingsDelegate) {
        `settingsDidChange` = other.`settingsDidChange`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onUpdate", "uniffiFree")
internal open class UniffiVTableCallbackInterfacePaginationStatusListener(
    @JvmField internal var `onUpdate`: UniffiCallbackInterfacePaginationStatusListenerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onUpdate`: UniffiCallbackInterfacePaginationStatusListenerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfacePaginationStatusListener(`onUpdate`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfacePaginationStatusListener) {
        `onUpdate` = other.`onUpdate`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("transmissionProgress", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceProgressWatcher(
    @JvmField internal var `transmissionProgress`: UniffiCallbackInterfaceProgressWatcherMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `transmissionProgress`: UniffiCallbackInterfaceProgressWatcherMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceProgressWatcher(`transmissionProgress`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceProgressWatcher) {
        `transmissionProgress` = other.`transmissionProgress`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onUpdate", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceQrLoginProgressListener(
    @JvmField internal var `onUpdate`: UniffiCallbackInterfaceQrLoginProgressListenerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onUpdate`: UniffiCallbackInterfaceQrLoginProgressListenerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceQrLoginProgressListener(`onUpdate`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceQrLoginProgressListener) {
        `onUpdate` = other.`onUpdate`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onUpdate", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceRecoveryStateListener(
    @JvmField internal var `onUpdate`: UniffiCallbackInterfaceRecoveryStateListenerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onUpdate`: UniffiCallbackInterfaceRecoveryStateListenerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceRecoveryStateListener(`onUpdate`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceRecoveryStateListener) {
        `onUpdate` = other.`onUpdate`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onUpdate", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceRoomDirectorySearchEntriesListener(
    @JvmField internal var `onUpdate`: UniffiCallbackInterfaceRoomDirectorySearchEntriesListenerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onUpdate`: UniffiCallbackInterfaceRoomDirectorySearchEntriesListenerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceRoomDirectorySearchEntriesListener(`onUpdate`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceRoomDirectorySearchEntriesListener) {
        `onUpdate` = other.`onUpdate`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("call", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceRoomInfoListener(
    @JvmField internal var `call`: UniffiCallbackInterfaceRoomInfoListenerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `call`: UniffiCallbackInterfaceRoomInfoListenerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceRoomInfoListener(`call`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceRoomInfoListener) {
        `call` = other.`call`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onUpdate", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceRoomListEntriesListener(
    @JvmField internal var `onUpdate`: UniffiCallbackInterfaceRoomListEntriesListenerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onUpdate`: UniffiCallbackInterfaceRoomListEntriesListenerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceRoomListEntriesListener(`onUpdate`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceRoomListEntriesListener) {
        `onUpdate` = other.`onUpdate`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onUpdate", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceRoomListLoadingStateListener(
    @JvmField internal var `onUpdate`: UniffiCallbackInterfaceRoomListLoadingStateListenerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onUpdate`: UniffiCallbackInterfaceRoomListLoadingStateListenerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceRoomListLoadingStateListener(`onUpdate`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceRoomListLoadingStateListener) {
        `onUpdate` = other.`onUpdate`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onUpdate", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceRoomListServiceStateListener(
    @JvmField internal var `onUpdate`: UniffiCallbackInterfaceRoomListServiceStateListenerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onUpdate`: UniffiCallbackInterfaceRoomListServiceStateListenerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceRoomListServiceStateListener(`onUpdate`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceRoomListServiceStateListener) {
        `onUpdate` = other.`onUpdate`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onUpdate", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceRoomListServiceSyncIndicatorListener(
    @JvmField internal var `onUpdate`: UniffiCallbackInterfaceRoomListServiceSyncIndicatorListenerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onUpdate`: UniffiCallbackInterfaceRoomListServiceSyncIndicatorListenerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceRoomListServiceSyncIndicatorListener(`onUpdate`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceRoomListServiceSyncIndicatorListener) {
        `onUpdate` = other.`onUpdate`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onError", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceSendQueueRoomErrorListener(
    @JvmField internal var `onError`: UniffiCallbackInterfaceSendQueueRoomErrorListenerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onError`: UniffiCallbackInterfaceSendQueueRoomErrorListenerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceSendQueueRoomErrorListener(`onError`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceSendQueueRoomErrorListener) {
        `onError` = other.`onError`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("didAcceptVerificationRequest", "didStartSasVerification", "didReceiveVerificationData", "didFail", "didCancel", "didFinish", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceSessionVerificationControllerDelegate(
    @JvmField internal var `didAcceptVerificationRequest`: UniffiCallbackInterfaceSessionVerificationControllerDelegateMethod0? = null,
    @JvmField internal var `didStartSasVerification`: UniffiCallbackInterfaceSessionVerificationControllerDelegateMethod1? = null,
    @JvmField internal var `didReceiveVerificationData`: UniffiCallbackInterfaceSessionVerificationControllerDelegateMethod2? = null,
    @JvmField internal var `didFail`: UniffiCallbackInterfaceSessionVerificationControllerDelegateMethod3? = null,
    @JvmField internal var `didCancel`: UniffiCallbackInterfaceSessionVerificationControllerDelegateMethod4? = null,
    @JvmField internal var `didFinish`: UniffiCallbackInterfaceSessionVerificationControllerDelegateMethod5? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `didAcceptVerificationRequest`: UniffiCallbackInterfaceSessionVerificationControllerDelegateMethod0? = null,
        `didStartSasVerification`: UniffiCallbackInterfaceSessionVerificationControllerDelegateMethod1? = null,
        `didReceiveVerificationData`: UniffiCallbackInterfaceSessionVerificationControllerDelegateMethod2? = null,
        `didFail`: UniffiCallbackInterfaceSessionVerificationControllerDelegateMethod3? = null,
        `didCancel`: UniffiCallbackInterfaceSessionVerificationControllerDelegateMethod4? = null,
        `didFinish`: UniffiCallbackInterfaceSessionVerificationControllerDelegateMethod5? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceSessionVerificationControllerDelegate(`didAcceptVerificationRequest`,`didStartSasVerification`,`didReceiveVerificationData`,`didFail`,`didCancel`,`didFinish`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceSessionVerificationControllerDelegate) {
        `didAcceptVerificationRequest` = other.`didAcceptVerificationRequest`
        `didStartSasVerification` = other.`didStartSasVerification`
        `didReceiveVerificationData` = other.`didReceiveVerificationData`
        `didFail` = other.`didFail`
        `didCancel` = other.`didCancel`
        `didFinish` = other.`didFinish`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onUpdate", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceSyncServiceStateObserver(
    @JvmField internal var `onUpdate`: UniffiCallbackInterfaceSyncServiceStateObserverMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onUpdate`: UniffiCallbackInterfaceSyncServiceStateObserverMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceSyncServiceStateObserver(`onUpdate`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceSyncServiceStateObserver) {
        `onUpdate` = other.`onUpdate`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onUpdate", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceTimelineListener(
    @JvmField internal var `onUpdate`: UniffiCallbackInterfaceTimelineListenerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onUpdate`: UniffiCallbackInterfaceTimelineListenerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceTimelineListener(`onUpdate`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceTimelineListener) {
        `onUpdate` = other.`onUpdate`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("call", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceTypingNotificationsListener(
    @JvmField internal var `call`: UniffiCallbackInterfaceTypingNotificationsListenerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `call`: UniffiCallbackInterfaceTypingNotificationsListenerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceTypingNotificationsListener(`call`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceTypingNotificationsListener) {
        `call` = other.`call`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onUtd", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceUnableToDecryptDelegate(
    @JvmField internal var `onUtd`: UniffiCallbackInterfaceUnableToDecryptDelegateMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onUtd`: UniffiCallbackInterfaceUnableToDecryptDelegateMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceUnableToDecryptDelegate(`onUtd`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceUnableToDecryptDelegate) {
        `onUtd` = other.`onUtd`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onUpdate", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceVerificationStateListener(
    @JvmField internal var `onUpdate`: UniffiCallbackInterfaceVerificationStateListenerMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onUpdate`: UniffiCallbackInterfaceVerificationStateListenerMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceVerificationStateListener(`onUpdate`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceVerificationStateListener) {
        `onUpdate` = other.`onUpdate`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("acquireCapabilities", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceWidgetCapabilitiesProvider(
    @JvmField internal var `acquireCapabilities`: UniffiCallbackInterfaceWidgetCapabilitiesProviderMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `acquireCapabilities`: UniffiCallbackInterfaceWidgetCapabilitiesProviderMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceWidgetCapabilitiesProvider(`acquireCapabilities`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceWidgetCapabilitiesProvider) {
        `acquireCapabilities` = other.`acquireCapabilities`
        `uniffiFree` = other.`uniffiFree`
    }

}























































































































































































































































































































































































































































































































































































































































































































































































































































































































// A JNA Library to expose the extern-C FFI definitions.
// This is an implementation detail which will be called internally by the public API.

internal interface UniffiLib : Library {
    companion object {
        internal val INSTANCE: UniffiLib by lazy {
            loadIndirect<UniffiLib>(componentName = "matrix_sdk_ffi")
            .also { lib: UniffiLib ->
                uniffiCheckContractApiVersion(lib)
                uniffiCheckApiChecksums(lib)
                uniffiCallbackInterfaceBackupStateListener.register(lib)
                uniffiCallbackInterfaceBackupSteadyStateListener.register(lib)
                uniffiCallbackInterfaceClientDelegate.register(lib)
                uniffiCallbackInterfaceClientSessionDelegate.register(lib)
                uniffiCallbackInterfaceEnableRecoveryProgressListener.register(lib)
                uniffiCallbackInterfaceIgnoredUsersListener.register(lib)
                uniffiCallbackInterfaceNotificationSettingsDelegate.register(lib)
                uniffiCallbackInterfacePaginationStatusListener.register(lib)
                uniffiCallbackInterfaceProgressWatcher.register(lib)
                uniffiCallbackInterfaceQrLoginProgressListener.register(lib)
                uniffiCallbackInterfaceRecoveryStateListener.register(lib)
                uniffiCallbackInterfaceRoomDirectorySearchEntriesListener.register(lib)
                uniffiCallbackInterfaceRoomInfoListener.register(lib)
                uniffiCallbackInterfaceRoomListEntriesListener.register(lib)
                uniffiCallbackInterfaceRoomListLoadingStateListener.register(lib)
                uniffiCallbackInterfaceRoomListServiceStateListener.register(lib)
                uniffiCallbackInterfaceRoomListServiceSyncIndicatorListener.register(lib)
                uniffiCallbackInterfaceSendQueueRoomErrorListener.register(lib)
                uniffiCallbackInterfaceSessionVerificationControllerDelegate.register(lib)
                uniffiCallbackInterfaceSyncServiceStateObserver.register(lib)
                uniffiCallbackInterfaceTimelineListener.register(lib)
                uniffiCallbackInterfaceTypingNotificationsListener.register(lib)
                uniffiCallbackInterfaceUnableToDecryptDelegate.register(lib)
                uniffiCallbackInterfaceVerificationStateListener.register(lib)
                uniffiCallbackInterfaceWidgetCapabilitiesProvider.register(lib)
                }
        }
        
        // The Cleaner for the whole library
        internal val CLEANER: UniffiCleaner by lazy {
            UniffiCleaner.create()
        }
    }

    fun uniffi_matrix_sdk_ffi_fn_clone_mediasource(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_mediasource(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_constructor_mediasource_from_json(`json`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_mediasource_to_json(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_mediasource_url(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_clone_roommessageeventcontentwithoutrelation(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_roommessageeventcontentwithoutrelation(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roommessageeventcontentwithoutrelation_with_mentions(`ptr`: Pointer,`mentions`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_clone_abortsendhandle(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_abortsendhandle(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_abortsendhandle_abort(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_clone_authenticationservice(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_authenticationservice(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_constructor_authenticationservice_new(`sessionPath`: RustBuffer.ByValue,`passphrase`: RustBuffer.ByValue,`userAgent`: RustBuffer.ByValue,`additionalRootCertificates`: RustBuffer.ByValue,`proxy`: RustBuffer.ByValue,`oidcConfiguration`: RustBuffer.ByValue,`customSlidingSyncProxy`: RustBuffer.ByValue,`sessionDelegate`: RustBuffer.ByValue,`crossProcessRefreshLockId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_authenticationservice_configure_homeserver(`ptr`: Pointer,`serverNameOrHomeserverUrl`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_authenticationservice_homeserver_details(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_authenticationservice_login(`ptr`: Pointer,`username`: RustBuffer.ByValue,`password`: RustBuffer.ByValue,`initialDeviceName`: RustBuffer.ByValue,`deviceId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_authenticationservice_login_with_oidc_callback(`ptr`: Pointer,`authenticationData`: Pointer,`callbackUrl`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_authenticationservice_url_for_oidc_login(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_clone_client(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_client(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_account_data(`ptr`: Pointer,`eventType`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_account_url(`ptr`: Pointer,`action`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_avatar_url(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_cached_avatar_url(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_create_room(`ptr`: Pointer,`request`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_delete_pusher(`ptr`: Pointer,`identifiers`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_device_id(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_display_name(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_enable_all_send_queues(`ptr`: Pointer,`enable`: Byte,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_client_encryption(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_dm_room(`ptr`: Pointer,`userId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_media_content(`ptr`: Pointer,`mediaSource`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_media_file(`ptr`: Pointer,`mediaSource`: Pointer,`body`: RustBuffer.ByValue,`mimeType`: RustBuffer.ByValue,`useCache`: Byte,`tempDir`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_media_thumbnail(`ptr`: Pointer,`mediaSource`: Pointer,`width`: Long,`height`: Long,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_notification_settings(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_profile(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_recently_visited_rooms(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_room_preview_from_room_alias(`ptr`: Pointer,`roomAlias`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_room_preview_from_room_id(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`viaServers`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_get_session_verification_controller(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_homeserver(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_ignore_user(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_ignored_users(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_join_room_by_id(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_join_room_by_id_or_alias(`ptr`: Pointer,`roomIdOrAlias`: RustBuffer.ByValue,`serverNames`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_login(`ptr`: Pointer,`username`: RustBuffer.ByValue,`password`: RustBuffer.ByValue,`initialDeviceName`: RustBuffer.ByValue,`deviceId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_logout(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_notification_client(`ptr`: Pointer,`processSetup`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_remove_avatar(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_resolve_room_alias(`ptr`: Pointer,`roomAlias`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_restore_session(`ptr`: Pointer,`session`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_room_directory_search(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_client_rooms(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_search_users(`ptr`: Pointer,`searchTerm`: RustBuffer.ByValue,`limit`: Long,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_session(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_set_account_data(`ptr`: Pointer,`eventType`: RustBuffer.ByValue,`content`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_set_delegate(`ptr`: Pointer,`delegate`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_client_set_display_name(`ptr`: Pointer,`name`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_set_pusher(`ptr`: Pointer,`identifiers`: RustBuffer.ByValue,`kind`: RustBuffer.ByValue,`appDisplayName`: RustBuffer.ByValue,`deviceDisplayName`: RustBuffer.ByValue,`profileTag`: RustBuffer.ByValue,`lang`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_subscribe_to_ignored_users(`ptr`: Pointer,`listener`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_client_subscribe_to_send_queue_status(`ptr`: Pointer,`listener`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_client_sync_service(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_client_track_recently_visited_room(`ptr`: Pointer,`room`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_unignore_user(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_upload_avatar(`ptr`: Pointer,`mimeType`: RustBuffer.ByValue,`data`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_upload_media(`ptr`: Pointer,`mimeType`: RustBuffer.ByValue,`data`: RustBuffer.ByValue,`progressWatcher`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_client_user_id(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_clone_clientbuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_clientbuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_constructor_clientbuilder_new(uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_add_root_certificates(`ptr`: Pointer,`certificates`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_auto_enable_backups(`ptr`: Pointer,`autoEnableBackups`: Byte,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_auto_enable_cross_signing(`ptr`: Pointer,`autoEnableCrossSigning`: Byte,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_backup_download_strategy(`ptr`: Pointer,`backupDownloadStrategy`: RustBufferBackupDownloadStrategy.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_build(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_build_with_qr_code(`ptr`: Pointer,`qrCodeData`: Pointer,`oidcConfiguration`: RustBuffer.ByValue,`progressListener`: Long,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_disable_automatic_token_refresh(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_disable_ssl_verification(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_enable_cross_process_refresh_lock(`ptr`: Pointer,`processId`: RustBuffer.ByValue,`sessionDelegate`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_homeserver_url(`ptr`: Pointer,`url`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_passphrase(`ptr`: Pointer,`passphrase`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_proxy(`ptr`: Pointer,`url`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_server_name(`ptr`: Pointer,`serverName`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_server_name_or_homeserver_url(`ptr`: Pointer,`serverNameOrUrl`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_server_versions(`ptr`: Pointer,`versions`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_session_path(`ptr`: Pointer,`path`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_set_session_delegate(`ptr`: Pointer,`sessionDelegate`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_sliding_sync_proxy(`ptr`: Pointer,`slidingSyncProxy`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_user_agent(`ptr`: Pointer,`userAgent`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_clientbuilder_username(`ptr`: Pointer,`username`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_clone_encryption(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_encryption(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_backup_exists_on_server(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_backup_state(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_backup_state_listener(`ptr`: Pointer,`listener`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_curve25519_key(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_disable_recovery(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_ed25519_key(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_enable_backups(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_enable_recovery(`ptr`: Pointer,`waitForBackupsToUpload`: Byte,`progressListener`: Long,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_is_last_device(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_recover(`ptr`: Pointer,`recoveryKey`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_recover_and_reset(`ptr`: Pointer,`oldRecoveryKey`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_recovery_state(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_recovery_state_listener(`ptr`: Pointer,`listener`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_reset_recovery_key(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_verification_state(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_verification_state_listener(`ptr`: Pointer,`listener`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_wait_for_backup_upload_steady_state(`ptr`: Pointer,`progressListener`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_encryption_wait_for_e2ee_initialization_tasks(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_clone_eventtimelineitem(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_eventtimelineitem(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_can_be_replied_to(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_content(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_debug_info(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_event_id(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_editable(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_local(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_own(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_remote(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_local_send_state(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_origin(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_reactions(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_read_receipts(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_sender(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_sender_profile(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_timestamp(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_transaction_id(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_clone_homeserverlogindetails(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_homeserverlogindetails(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_homeserverlogindetails_sliding_sync_proxy(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_homeserverlogindetails_supports_oidc_login(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_homeserverlogindetails_supports_password_login(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_homeserverlogindetails_url(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_clone_mediafilehandle(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_mediafilehandle(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_mediafilehandle_path(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_mediafilehandle_persist(`ptr`: Pointer,`path`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_clone_message(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_message(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_message_body(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_message_content(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_message_in_reply_to(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_message_is_edited(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_message_is_threaded(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_message_msgtype(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_clone_notificationclient(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_notificationclient(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationclient_get_notification(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`eventId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_clone_notificationsettings(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_notificationsettings(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_can_homeserver_push_encrypted_event_to_device(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_can_push_encrypted_event_to_device(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_contains_keywords_rules(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_get_default_room_notification_mode(`ptr`: Pointer,`isEncrypted`: Byte,`isOneToOne`: Byte,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_get_room_notification_settings(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`isEncrypted`: Byte,`isOneToOne`: Byte,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_get_rooms_with_user_defined_rules(`ptr`: Pointer,`enabled`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_get_user_defined_room_notification_mode(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_call_enabled(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_invite_for_me_enabled(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_room_mention_enabled(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_user_mention_enabled(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_restore_default_room_notification_mode(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_call_enabled(`ptr`: Pointer,`enabled`: Byte,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_default_room_notification_mode(`ptr`: Pointer,`isEncrypted`: Byte,`isOneToOne`: Byte,`mode`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_delegate(`ptr`: Pointer,`delegate`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_invite_for_me_enabled(`ptr`: Pointer,`enabled`: Byte,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_room_mention_enabled(`ptr`: Pointer,`enabled`: Byte,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_room_notification_mode(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`mode`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_user_mention_enabled(`ptr`: Pointer,`enabled`: Byte,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_notificationsettings_unmute_room(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,`isEncrypted`: Byte,`isOneToOne`: Byte,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_clone_oidcauthenticationdata(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_oidcauthenticationdata(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_oidcauthenticationdata_login_url(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_clone_qrcodedata(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_qrcodedata(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_constructor_qrcodedata_from_bytes(`bytes`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_clone_room(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_room(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_active_members_count(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_active_room_call_participants(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_alternative_aliases(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_apply_power_level_changes(`ptr`: Pointer,`changes`: RustBufferRoomPowerLevelChanges.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_avatar_url(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_ban_user(`ptr`: Pointer,`userId`: RustBuffer.ByValue,`reason`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_ban(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_invite(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_kick(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_redact_other(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_redact_own(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_send_message(`ptr`: Pointer,`userId`: RustBuffer.ByValue,`message`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_send_state(`ptr`: Pointer,`userId`: RustBuffer.ByValue,`stateEvent`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_can_user_trigger_room_notification(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_canonical_alias(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_clear_composer_draft(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_discard_room_key(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_display_name(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_enable_send_queue(`ptr`: Pointer,`enable`: Byte,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_room_get_power_levels(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_has_active_room_call(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_room_heroes(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_id(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_ignore_user(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_invite_user_by_id(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_invited_members_count(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_inviter(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_is_direct(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_room_is_encrypted(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_room_is_public(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_room_is_send_queue_enabled(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_room_is_space(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_room_is_tombstoned(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_room_join(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_joined_members_count(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_kick_user(`ptr`: Pointer,`userId`: RustBuffer.ByValue,`reason`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_leave(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_load_composer_draft(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_mark_as_read(`ptr`: Pointer,`receiptType`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_matrix_to_event_permalink(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_matrix_to_permalink(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_member(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_member_avatar_url(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_member_display_name(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_members(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_members_no_sync(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_membership(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_own_user_id(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_raw_name(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_redact(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,`reason`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_remove_avatar(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_report_content(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,`score`: RustBuffer.ByValue,`reason`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_reset_power_levels(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_room_info(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_save_composer_draft(`ptr`: Pointer,`draft`: RustBufferComposerDraft.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_send_call_notification(`ptr`: Pointer,`callId`: RustBuffer.ByValue,`application`: RustBuffer.ByValue,`notifyType`: RustBuffer.ByValue,`mentions`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_send_call_notification_if_needed(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_set_is_favourite(`ptr`: Pointer,`isFavourite`: Byte,`tagOrder`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_set_is_low_priority(`ptr`: Pointer,`isLowPriority`: Byte,`tagOrder`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_set_name(`ptr`: Pointer,`name`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_set_topic(`ptr`: Pointer,`topic`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_set_unread_flag(`ptr`: Pointer,`newValue`: Byte,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_subscribe_to_room_info_updates(`ptr`: Pointer,`listener`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_subscribe_to_typing_notifications(`ptr`: Pointer,`listener`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_room_suggested_role_for_user(`ptr`: Pointer,`userId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_timeline(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_timeline_focused_on_event(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,`numContextEvents`: Short,`internalIdPrefix`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_topic(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_room_typing_notice(`ptr`: Pointer,`isTyping`: Byte,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_unban_user(`ptr`: Pointer,`userId`: RustBuffer.ByValue,`reason`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_update_power_levels_for_users(`ptr`: Pointer,`updates`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_room_upload_avatar(`ptr`: Pointer,`mimeType`: RustBuffer.ByValue,`data`: RustBuffer.ByValue,`mediaInfo`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_clone_roomdirectorysearch(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_roomdirectorysearch(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomdirectorysearch_is_at_last_page(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_roomdirectorysearch_loaded_pages(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_roomdirectorysearch_next_page(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_roomdirectorysearch_results(`ptr`: Pointer,`listener`: Long,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_roomdirectorysearch_search(`ptr`: Pointer,`filter`: RustBuffer.ByValue,`batchSize`: Int,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_clone_roomlist(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_roomlist(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlist_entries(`ptr`: Pointer,`listener`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roomlist_entries_with_dynamic_adapters(`ptr`: Pointer,`pageSize`: Int,`listener`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roomlist_loading_state(`ptr`: Pointer,`listener`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roomlist_room(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_clone_roomlistdynamicentriescontroller(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_roomlistdynamicentriescontroller(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistdynamicentriescontroller_add_one_page(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistdynamicentriescontroller_reset_to_one_page(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistdynamicentriescontroller_set_filter(`ptr`: Pointer,`kind`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_clone_roomlistitem(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_roomlistitem(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_avatar_url(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_canonical_alias(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_display_name(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_full_room(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_id(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_init_timeline(`ptr`: Pointer,`eventTypeFilter`: RustBuffer.ByValue,`internalIdPrefix`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_is_direct(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_is_timeline_initialized(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_latest_event(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_room_info(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_subscribe(`ptr`: Pointer,`settings`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistitem_unsubscribe(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_clone_roomlistservice(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_roomlistservice(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistservice_all_rooms(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistservice_apply_input(`ptr`: Pointer,`input`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistservice_room(`ptr`: Pointer,`roomId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistservice_state(`ptr`: Pointer,`listener`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_roomlistservice_sync_indicator(`ptr`: Pointer,`delayBeforeShowingInMs`: Int,`delayBeforeHidingInMs`: Int,`listener`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_clone_roommembersiterator(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_roommembersiterator(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_roommembersiterator_len(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Int
    fun uniffi_matrix_sdk_ffi_fn_method_roommembersiterator_next_chunk(`ptr`: Pointer,`chunkSize`: Int,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_clone_sendattachmentjoinhandle(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_sendattachmentjoinhandle(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_sendattachmentjoinhandle_cancel(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_sendattachmentjoinhandle_join(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_clone_sessionverificationcontroller(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_sessionverificationcontroller(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_approve_verification(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_cancel_verification(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_decline_verification(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_is_verified(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_request_verification(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_set_delegate(`ptr`: Pointer,`delegate`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_start_sas_verification(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_clone_sessionverificationemoji(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_sessionverificationemoji(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationemoji_description(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_sessionverificationemoji_symbol(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_clone_span(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_span(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_constructor_span_current(uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_constructor_span_new(`file`: RustBuffer.ByValue,`line`: RustBuffer.ByValue,`level`: RustBuffer.ByValue,`target`: RustBuffer.ByValue,`name`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_span_enter(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_span_exit(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_span_is_none(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_clone_syncservice(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_syncservice(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_syncservice_room_list_service(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_syncservice_start(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_syncservice_state(`ptr`: Pointer,`listener`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_syncservice_stop(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_clone_syncservicebuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_syncservicebuilder(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_syncservicebuilder_finish(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_syncservicebuilder_with_cross_process_lock(`ptr`: Pointer,`appIdentifier`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_syncservicebuilder_with_utd_hook(`ptr`: Pointer,`delegate`: Long,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_clone_taskhandle(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_taskhandle(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_taskhandle_cancel(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_taskhandle_is_finished(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_clone_timeline(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_timeline(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_add_listener(`ptr`: Pointer,`listener`: Long,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_create_poll(`ptr`: Pointer,`question`: RustBuffer.ByValue,`answers`: RustBuffer.ByValue,`maxSelections`: Byte,`pollKind`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_edit(`ptr`: Pointer,`newContent`: Pointer,`editItem`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_edit_poll(`ptr`: Pointer,`question`: RustBuffer.ByValue,`answers`: RustBuffer.ByValue,`maxSelections`: Byte,`pollKind`: RustBuffer.ByValue,`editItem`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_end_poll(`ptr`: Pointer,`pollStartId`: RustBuffer.ByValue,`text`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_fetch_details_for_event(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_fetch_members(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_focused_paginate_forwards(`ptr`: Pointer,`numEvents`: Short,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_get_event_timeline_item_by_event_id(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_get_event_timeline_item_by_transaction_id(`ptr`: Pointer,`transactionId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_load_reply_details(`ptr`: Pointer,`eventIdStr`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_mark_as_read(`ptr`: Pointer,`receiptType`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_paginate_backwards(`ptr`: Pointer,`numEvents`: Short,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_redact_event(`ptr`: Pointer,`item`: Pointer,`reason`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_retry_decryption(`ptr`: Pointer,`sessionIds`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_send(`ptr`: Pointer,`msg`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_send_audio(`ptr`: Pointer,`url`: RustBuffer.ByValue,`audioInfo`: RustBuffer.ByValue,`caption`: RustBuffer.ByValue,`formattedCaption`: RustBuffer.ByValue,`progressWatcher`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_send_file(`ptr`: Pointer,`url`: RustBuffer.ByValue,`fileInfo`: RustBuffer.ByValue,`progressWatcher`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_send_image(`ptr`: Pointer,`url`: RustBuffer.ByValue,`thumbnailUrl`: RustBuffer.ByValue,`imageInfo`: RustBuffer.ByValue,`caption`: RustBuffer.ByValue,`formattedCaption`: RustBuffer.ByValue,`progressWatcher`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_send_location(`ptr`: Pointer,`body`: RustBuffer.ByValue,`geoUri`: RustBuffer.ByValue,`description`: RustBuffer.ByValue,`zoomLevel`: RustBuffer.ByValue,`assetType`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_send_poll_response(`ptr`: Pointer,`pollStartId`: RustBuffer.ByValue,`answers`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_send_read_receipt(`ptr`: Pointer,`receiptType`: RustBuffer.ByValue,`eventId`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_send_reply(`ptr`: Pointer,`msg`: Pointer,`replyItem`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_send_video(`ptr`: Pointer,`url`: RustBuffer.ByValue,`thumbnailUrl`: RustBuffer.ByValue,`videoInfo`: RustBuffer.ByValue,`caption`: RustBuffer.ByValue,`formattedCaption`: RustBuffer.ByValue,`progressWatcher`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_send_voice_message(`ptr`: Pointer,`url`: RustBuffer.ByValue,`audioInfo`: RustBuffer.ByValue,`waveform`: RustBuffer.ByValue,`caption`: RustBuffer.ByValue,`formattedCaption`: RustBuffer.ByValue,`progressWatcher`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_subscribe_to_back_pagination_status(`ptr`: Pointer,`listener`: Long,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_timeline_toggle_reaction(`ptr`: Pointer,`eventId`: RustBuffer.ByValue,`key`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_clone_timelinediff(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_timelinediff(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_append(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_change(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_insert(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_push_back(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_push_front(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_remove(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_reset(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelinediff_set(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_clone_timelineevent(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_timelineevent(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timelineevent_event_id(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineevent_event_type(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineevent_sender_id(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineevent_timestamp(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_clone_timelineeventtypefilter(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_timelineeventtypefilter(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_constructor_timelineeventtypefilter_exclude(`eventTypes`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_constructor_timelineeventtypefilter_include(`eventTypes`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_clone_timelineitem(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_timelineitem(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timelineitem_as_event(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineitem_as_virtual(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineitem_fmt_debug(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineitem_unique_id(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_clone_timelineitemcontent(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_timelineitemcontent(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_timelineitemcontent_as_message(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_method_timelineitemcontent_kind(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_clone_unreadnotificationscount(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_unreadnotificationscount(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_unreadnotificationscount_has_notifications(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun uniffi_matrix_sdk_ffi_fn_method_unreadnotificationscount_highlight_count(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Int
    fun uniffi_matrix_sdk_ffi_fn_method_unreadnotificationscount_notification_count(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Int
    fun uniffi_matrix_sdk_ffi_fn_clone_widgetdriver(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_widgetdriver(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_widgetdriver_run(`ptr`: Pointer,`room`: Pointer,`capabilitiesProvider`: Long,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_clone_widgetdriverhandle(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_free_widgetdriverhandle(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_method_widgetdriverhandle_recv(`ptr`: Pointer,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_method_widgetdriverhandle_send(`ptr`: Pointer,`msg`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_backupstatelistener(`vtable`: UniffiVTableCallbackInterfaceBackupStateListener,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_backupsteadystatelistener(`vtable`: UniffiVTableCallbackInterfaceBackupSteadyStateListener,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_clientdelegate(`vtable`: UniffiVTableCallbackInterfaceClientDelegate,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_clientsessiondelegate(`vtable`: UniffiVTableCallbackInterfaceClientSessionDelegate,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_enablerecoveryprogresslistener(`vtable`: UniffiVTableCallbackInterfaceEnableRecoveryProgressListener,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_ignoreduserslistener(`vtable`: UniffiVTableCallbackInterfaceIgnoredUsersListener,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_notificationsettingsdelegate(`vtable`: UniffiVTableCallbackInterfaceNotificationSettingsDelegate,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_paginationstatuslistener(`vtable`: UniffiVTableCallbackInterfacePaginationStatusListener,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_progresswatcher(`vtable`: UniffiVTableCallbackInterfaceProgressWatcher,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_qrloginprogresslistener(`vtable`: UniffiVTableCallbackInterfaceQrLoginProgressListener,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_recoverystatelistener(`vtable`: UniffiVTableCallbackInterfaceRecoveryStateListener,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_roomdirectorysearchentrieslistener(`vtable`: UniffiVTableCallbackInterfaceRoomDirectorySearchEntriesListener,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_roominfolistener(`vtable`: UniffiVTableCallbackInterfaceRoomInfoListener,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_roomlistentrieslistener(`vtable`: UniffiVTableCallbackInterfaceRoomListEntriesListener,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_roomlistloadingstatelistener(`vtable`: UniffiVTableCallbackInterfaceRoomListLoadingStateListener,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_roomlistservicestatelistener(`vtable`: UniffiVTableCallbackInterfaceRoomListServiceStateListener,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_roomlistservicesyncindicatorlistener(`vtable`: UniffiVTableCallbackInterfaceRoomListServiceSyncIndicatorListener,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_sendqueueroomerrorlistener(`vtable`: UniffiVTableCallbackInterfaceSendQueueRoomErrorListener,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_sessionverificationcontrollerdelegate(`vtable`: UniffiVTableCallbackInterfaceSessionVerificationControllerDelegate,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_syncservicestateobserver(`vtable`: UniffiVTableCallbackInterfaceSyncServiceStateObserver,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_timelinelistener(`vtable`: UniffiVTableCallbackInterfaceTimelineListener,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_typingnotificationslistener(`vtable`: UniffiVTableCallbackInterfaceTypingNotificationsListener,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_unabletodecryptdelegate(`vtable`: UniffiVTableCallbackInterfaceUnableToDecryptDelegate,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_verificationstatelistener(`vtable`: UniffiVTableCallbackInterfaceVerificationStateListener,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_init_callback_vtable_widgetcapabilitiesprovider(`vtable`: UniffiVTableCallbackInterfaceWidgetCapabilitiesProvider,
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_func_gen_transaction_id(uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_func_generate_webview_url(`widgetSettings`: RustBuffer.ByValue,`room`: Pointer,`props`: RustBuffer.ByValue,
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_func_get_element_call_required_permissions(`ownUserId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_func_log_event(`file`: RustBuffer.ByValue,`line`: RustBuffer.ByValue,`level`: RustBuffer.ByValue,`target`: RustBuffer.ByValue,`message`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_func_make_widget_driver(`settings`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_func_matrix_to_room_alias_permalink(`roomAlias`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_func_matrix_to_user_permalink(`userId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_func_media_source_from_url(`url`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_func_message_event_content_from_html(`body`: RustBuffer.ByValue,`htmlBody`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_func_message_event_content_from_html_as_emote(`body`: RustBuffer.ByValue,`htmlBody`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_func_message_event_content_from_markdown(`md`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_func_message_event_content_from_markdown_as_emote(`md`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_func_message_event_content_new(`msgtype`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun uniffi_matrix_sdk_ffi_fn_func_new_virtual_element_call_widget(`props`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_func_parse_matrix_entity_from(`uri`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_func_sdk_git_sha(uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun uniffi_matrix_sdk_ffi_fn_func_setup_tracing(`config`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_fn_func_suggested_power_level_for_role(`role`: RustBufferRoomMemberRole.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Long
    fun uniffi_matrix_sdk_ffi_fn_func_suggested_role_for_power_level(`powerLevel`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBufferRoomMemberRole.ByValue
    fun ffi_matrix_sdk_ffi_rustbuffer_alloc(`size`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_rustbuffer_from_bytes(`bytes`: ForeignBytes.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_rustbuffer_free(`buf`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun ffi_matrix_sdk_ffi_rustbuffer_reserve(`buf`: RustBuffer.ByValue,`additional`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_rust_future_poll_u8(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_u8(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_u8(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_u8(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun ffi_matrix_sdk_ffi_rust_future_poll_i8(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_i8(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_i8(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_i8(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Byte
    fun ffi_matrix_sdk_ffi_rust_future_poll_u16(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_u16(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_u16(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_u16(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Short
    fun ffi_matrix_sdk_ffi_rust_future_poll_i16(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_i16(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_i16(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_i16(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Short
    fun ffi_matrix_sdk_ffi_rust_future_poll_u32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_u32(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_u32(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_u32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Int
    fun ffi_matrix_sdk_ffi_rust_future_poll_i32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_i32(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_i32(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_i32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Int
    fun ffi_matrix_sdk_ffi_rust_future_poll_u64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_u64(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_u64(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_u64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Long
    fun ffi_matrix_sdk_ffi_rust_future_poll_i64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_i64(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_i64(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_i64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Long
    fun ffi_matrix_sdk_ffi_rust_future_poll_f32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_f32(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_f32(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_f32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Float
    fun ffi_matrix_sdk_ffi_rust_future_poll_f64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_f64(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_f64(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_f64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Double
    fun ffi_matrix_sdk_ffi_rust_future_poll_pointer(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_pointer(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_pointer(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_pointer(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Pointer
    fun ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_rust_buffer(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): RustBuffer.ByValue
    fun ffi_matrix_sdk_ffi_rust_future_poll_void(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_cancel_void(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_free_void(`handle`: Long,
    ): Unit
    fun ffi_matrix_sdk_ffi_rust_future_complete_void(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
    ): Unit
    fun uniffi_matrix_sdk_ffi_checksum_func_gen_transaction_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_generate_webview_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_get_element_call_required_permissions(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_log_event(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_make_widget_driver(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_matrix_to_room_alias_permalink(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_matrix_to_user_permalink(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_media_source_from_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_message_event_content_from_html(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_message_event_content_from_html_as_emote(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_message_event_content_from_markdown(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_message_event_content_from_markdown_as_emote(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_message_event_content_new(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_new_virtual_element_call_widget(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_parse_matrix_entity_from(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_sdk_git_sha(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_setup_tracing(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_suggested_power_level_for_role(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_func_suggested_role_for_power_level(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_mediasource_to_json(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_mediasource_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommessageeventcontentwithoutrelation_with_mentions(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_abortsendhandle_abort(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_configure_homeserver(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_homeserver_details(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_login(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_login_with_oidc_callback(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_url_for_oidc_login(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_account_data(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_account_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_avatar_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_cached_avatar_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_create_room(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_delete_pusher(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_device_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_display_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_enable_all_send_queues(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_encryption(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_dm_room(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_media_content(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_media_file(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_media_thumbnail(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_notification_settings(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_profile(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_recently_visited_rooms(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_room_preview_from_room_alias(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_room_preview_from_room_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_get_session_verification_controller(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_homeserver(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_ignore_user(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_ignored_users(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_join_room_by_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_join_room_by_id_or_alias(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_login(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_logout(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_notification_client(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_remove_avatar(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_resolve_room_alias(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_restore_session(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_room_directory_search(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_rooms(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_search_users(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_session(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_set_account_data(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_set_delegate(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_set_display_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_set_pusher(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_subscribe_to_ignored_users(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_subscribe_to_send_queue_status(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_sync_service(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_track_recently_visited_room(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_unignore_user(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_upload_avatar(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_upload_media(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_client_user_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_add_root_certificates(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_auto_enable_backups(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_auto_enable_cross_signing(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_backup_download_strategy(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_build(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_build_with_qr_code(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_disable_automatic_token_refresh(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_disable_ssl_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_enable_cross_process_refresh_lock(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_homeserver_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_passphrase(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_proxy(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_server_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_server_name_or_homeserver_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_server_versions(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_session_path(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_set_session_delegate(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_sliding_sync_proxy(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_user_agent(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_username(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_backup_exists_on_server(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_backup_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_backup_state_listener(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_curve25519_key(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_disable_recovery(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_ed25519_key(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_enable_backups(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_enable_recovery(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_is_last_device(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_recover(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_recover_and_reset(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_recovery_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_recovery_state_listener(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_reset_recovery_key(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_verification_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_verification_state_listener(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_wait_for_backup_upload_steady_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_encryption_wait_for_e2ee_initialization_tasks(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_can_be_replied_to(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_content(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_debug_info(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_event_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_editable(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_local(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_own(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_remote(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_local_send_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_origin(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_reactions(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_read_receipts(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_sender(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_sender_profile(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_timestamp(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_transaction_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_homeserverlogindetails_sliding_sync_proxy(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_homeserverlogindetails_supports_oidc_login(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_homeserverlogindetails_supports_password_login(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_homeserverlogindetails_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_mediafilehandle_path(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_mediafilehandle_persist(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_message_body(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_message_content(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_message_in_reply_to(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_message_is_edited(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_message_is_threaded(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_message_msgtype(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationclient_get_notification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_can_homeserver_push_encrypted_event_to_device(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_can_push_encrypted_event_to_device(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_contains_keywords_rules(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_get_default_room_notification_mode(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_get_room_notification_settings(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_get_rooms_with_user_defined_rules(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_get_user_defined_room_notification_mode(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_call_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_invite_for_me_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_room_mention_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_user_mention_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_restore_default_room_notification_mode(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_call_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_default_room_notification_mode(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_delegate(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_invite_for_me_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_room_mention_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_room_notification_mode(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_user_mention_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_unmute_room(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_oidcauthenticationdata_login_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_active_members_count(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_active_room_call_participants(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_alternative_aliases(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_apply_power_level_changes(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_avatar_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_ban_user(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_ban(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_invite(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_kick(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_redact_other(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_redact_own(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_send_message(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_send_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_can_user_trigger_room_notification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_canonical_alias(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_clear_composer_draft(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_discard_room_key(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_display_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_enable_send_queue(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_get_power_levels(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_has_active_room_call(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_heroes(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_ignore_user(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_invite_user_by_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_invited_members_count(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_inviter(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_is_direct(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_is_encrypted(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_is_public(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_is_send_queue_enabled(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_is_space(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_is_tombstoned(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_join(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_joined_members_count(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_kick_user(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_leave(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_load_composer_draft(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_mark_as_read(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_matrix_to_event_permalink(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_matrix_to_permalink(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_member(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_member_avatar_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_member_display_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_members(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_members_no_sync(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_membership(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_own_user_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_raw_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_redact(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_remove_avatar(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_report_content(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_reset_power_levels(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_room_info(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_save_composer_draft(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_send_call_notification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_send_call_notification_if_needed(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_set_is_favourite(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_set_is_low_priority(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_set_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_set_topic(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_set_unread_flag(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_subscribe_to_room_info_updates(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_subscribe_to_typing_notifications(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_suggested_role_for_user(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_timeline(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_timeline_focused_on_event(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_topic(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_typing_notice(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_unban_user(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_update_power_levels_for_users(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_room_upload_avatar(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomdirectorysearch_is_at_last_page(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomdirectorysearch_loaded_pages(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomdirectorysearch_next_page(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomdirectorysearch_results(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomdirectorysearch_search(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlist_entries(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlist_entries_with_dynamic_adapters(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlist_loading_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlist_room(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistdynamicentriescontroller_add_one_page(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistdynamicentriescontroller_reset_to_one_page(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistdynamicentriescontroller_set_filter(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_avatar_url(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_canonical_alias(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_display_name(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_full_room(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_init_timeline(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_is_direct(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_is_timeline_initialized(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_latest_event(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_room_info(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_subscribe(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_unsubscribe(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_all_rooms(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_apply_input(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_room(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_sync_indicator(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommembersiterator_len(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roommembersiterator_next_chunk(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sendattachmentjoinhandle_cancel(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sendattachmentjoinhandle_join(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_approve_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_cancel_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_decline_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_is_verified(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_request_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_set_delegate(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_start_sas_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationemoji_description(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationemoji_symbol(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_span_enter(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_span_exit(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_span_is_none(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservice_room_list_service(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservice_start(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservice_state(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservice_stop(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservicebuilder_finish(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservicebuilder_with_cross_process_lock(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservicebuilder_with_utd_hook(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_taskhandle_cancel(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_taskhandle_is_finished(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_add_listener(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_create_poll(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_edit(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_edit_poll(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_end_poll(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_fetch_details_for_event(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_fetch_members(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_focused_paginate_forwards(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_get_event_timeline_item_by_event_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_get_event_timeline_item_by_transaction_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_load_reply_details(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_mark_as_read(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_paginate_backwards(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_redact_event(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_retry_decryption(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_send(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_send_audio(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_send_file(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_send_image(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_send_location(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_send_poll_response(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_send_read_receipt(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_send_reply(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_send_video(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_send_voice_message(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_subscribe_to_back_pagination_status(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timeline_toggle_reaction(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_append(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_change(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_insert(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_push_back(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_push_front(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_remove(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_reset(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinediff_set(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineevent_event_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineevent_event_type(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineevent_sender_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineevent_timestamp(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineitem_as_event(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineitem_as_virtual(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineitem_fmt_debug(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineitem_unique_id(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineitemcontent_as_message(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelineitemcontent_kind(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_unreadnotificationscount_has_notifications(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_unreadnotificationscount_highlight_count(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_unreadnotificationscount_notification_count(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_widgetdriver_run(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_widgetdriverhandle_recv(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_widgetdriverhandle_send(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_constructor_mediasource_from_json(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_constructor_authenticationservice_new(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_constructor_clientbuilder_new(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_constructor_qrcodedata_from_bytes(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_constructor_span_current(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_constructor_span_new(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_constructor_timelineeventtypefilter_exclude(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_constructor_timelineeventtypefilter_include(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_backupstatelistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_backupsteadystatelistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientdelegate_did_receive_auth_error(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientdelegate_did_refresh_tokens(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientsessiondelegate_retrieve_session_from_keychain(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_clientsessiondelegate_save_session_in_keychain(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_enablerecoveryprogresslistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_ignoreduserslistener_call(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_notificationsettingsdelegate_settings_did_change(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_paginationstatuslistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_progresswatcher_transmission_progress(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_qrloginprogresslistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_recoverystatelistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomdirectorysearchentrieslistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roominfolistener_call(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistentrieslistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistloadingstatelistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservicestatelistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_roomlistservicesyncindicatorlistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sendqueueroomerrorlistener_on_error(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_accept_verification_request(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_start_sas_verification(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_receive_verification_data(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_fail(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_cancel(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_finish(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_syncservicestateobserver_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_timelinelistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_typingnotificationslistener_call(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_unabletodecryptdelegate_on_utd(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_verificationstatelistener_on_update(
    ): Short
    fun uniffi_matrix_sdk_ffi_checksum_method_widgetcapabilitiesprovider_acquire_capabilities(
    ): Short
    fun ffi_matrix_sdk_ffi_uniffi_contract_version(
    ): Int
    
}

private fun uniffiCheckContractApiVersion(lib: UniffiLib) {
    // Get the bindings contract version from our ComponentInterface
    val bindings_contract_version = 26
    // Get the scaffolding contract version by calling the into the dylib
    val scaffolding_contract_version = lib.ffi_matrix_sdk_ffi_uniffi_contract_version()
    if (bindings_contract_version != scaffolding_contract_version) {
        throw RuntimeException("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    }
}

@Suppress("UNUSED_PARAMETER")
private fun uniffiCheckApiChecksums(lib: UniffiLib) {
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_gen_transaction_id() != 15808.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_generate_webview_url() != 6844.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_get_element_call_required_permissions() != 51419.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_log_event() != 62286.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_make_widget_driver() != 34206.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_matrix_to_room_alias_permalink() != 13776.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_matrix_to_user_permalink() != 46473.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_media_source_from_url() != 12165.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_message_event_content_from_html() != 37203.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_message_event_content_from_html_as_emote() != 8938.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_message_event_content_from_markdown() != 58385.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_message_event_content_from_markdown_as_emote() != 20152.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_message_event_content_new() != 57839.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_new_virtual_element_call_widget() != 48052.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_parse_matrix_entity_from() != 49710.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_sdk_git_sha() != 4038.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_setup_tracing() != 45018.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_suggested_power_level_for_role() != 61777.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_func_suggested_role_for_power_level() != 48532.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_mediasource_to_json() != 2998.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_mediasource_url() != 34026.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommessageeventcontentwithoutrelation_with_mentions() != 8867.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_abortsendhandle_abort() != 55658.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_configure_homeserver() != 11225.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_homeserver_details() != 39542.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_login() != 26494.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_login_with_oidc_callback() != 1852.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_authenticationservice_url_for_oidc_login() != 64804.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_account_data() != 50433.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_account_url() != 42373.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_avatar_url() != 27867.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_cached_avatar_url() != 58990.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_create_room() != 52700.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_delete_pusher() != 45990.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_device_id() != 44340.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_display_name() != 56259.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_enable_all_send_queues() != 24140.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_encryption() != 9657.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_dm_room() != 5137.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_media_content() != 40308.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_media_file() != 47034.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_media_thumbnail() != 52601.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_notification_settings() != 6359.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_profile() != 60062.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_recently_visited_rooms() != 22399.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_room_preview_from_room_alias() != 10849.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_room_preview_from_room_id() != 6925.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_get_session_verification_controller() != 55934.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_homeserver() != 26427.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_ignore_user() != 14588.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_ignored_users() != 49620.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_join_room_by_id() != 64032.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_join_room_by_id_or_alias() != 18521.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_login() != 33276.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_logout() != 7576.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_notification_client() != 37308.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_remove_avatar() != 29033.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_resolve_room_alias() != 14306.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_restore_session() != 40455.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_room_directory_search() != 39855.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_rooms() != 29558.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_search_users() != 42927.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_session() != 8085.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_set_account_data() != 18256.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_set_delegate() != 59796.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_set_display_name() != 15292.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_set_pusher() != 41975.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_subscribe_to_ignored_users() != 23285.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_subscribe_to_send_queue_status() != 57403.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_sync_service() != 52812.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_track_recently_visited_room() != 56986.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_unignore_user() != 8489.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_upload_avatar() != 64486.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_upload_media() != 51195.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_client_user_id() != 40531.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_add_root_certificates() != 14763.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_auto_enable_backups() != 44502.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_auto_enable_cross_signing() != 37167.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_backup_download_strategy() != 11959.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_build() != 56018.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_build_with_qr_code() != 51905.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_disable_automatic_token_refresh() != 43839.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_disable_ssl_verification() != 2334.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_enable_cross_process_refresh_lock() != 34129.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_homeserver_url() != 28347.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_passphrase() != 14286.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_proxy() != 5659.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_server_name() != 29096.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_server_name_or_homeserver_url() != 30022.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_server_versions() != 15644.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_session_path() != 49266.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_set_session_delegate() != 8576.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_sliding_sync_proxy() != 15622.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_user_agent() != 13719.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientbuilder_username() != 45302.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_backup_exists_on_server() != 45490.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_backup_state() != 51049.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_backup_state_listener() != 14246.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_curve25519_key() != 58425.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_disable_recovery() != 18699.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_ed25519_key() != 11864.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_enable_backups() != 55446.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_enable_recovery() != 9043.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_is_last_device() != 27955.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_recover() != 33712.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_recover_and_reset() != 12902.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_recovery_state() != 54051.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_recovery_state_listener() != 36612.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_reset_recovery_key() != 20380.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_verification_state() != 29114.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_verification_state_listener() != 59806.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_wait_for_backup_upload_steady_state() != 37503.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_encryption_wait_for_e2ee_initialization_tasks() != 41585.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_can_be_replied_to() != 42922.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_content() != 41060.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_debug_info() != 31359.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_event_id() != 8156.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_editable() != 4716.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_local() != 12539.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_own() != 50903.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_is_remote() != 5953.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_local_send_state() != 53866.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_origin() != 19585.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_reactions() != 42968.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_read_receipts() != 22462.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_sender() != 58860.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_sender_profile() != 3911.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_timestamp() != 44397.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_eventtimelineitem_transaction_id() != 40338.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_homeserverlogindetails_sliding_sync_proxy() != 46815.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_homeserverlogindetails_supports_oidc_login() != 46090.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_homeserverlogindetails_supports_password_login() != 33501.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_homeserverlogindetails_url() != 61326.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_mediafilehandle_path() != 16357.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_mediafilehandle_persist() != 12883.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_message_body() != 21198.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_message_content() != 57046.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_message_in_reply_to() != 16154.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_message_is_edited() != 60975.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_message_is_threaded() != 9404.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_message_msgtype() != 14062.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationclient_get_notification() != 2524.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_can_homeserver_push_encrypted_event_to_device() != 37323.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_can_push_encrypted_event_to_device() != 21251.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_contains_keywords_rules() != 60025.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_get_default_room_notification_mode() != 36211.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_get_room_notification_settings() != 55295.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_get_rooms_with_user_defined_rules() != 19849.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_get_user_defined_room_notification_mode() != 18228.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_call_enabled() != 12210.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_invite_for_me_enabled() != 533.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_room_mention_enabled() != 13304.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_is_user_mention_enabled() != 49857.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_restore_default_room_notification_mode() != 35399.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_call_enabled() != 16823.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_default_room_notification_mode() != 9426.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_delegate() != 57636.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_invite_for_me_enabled() != 11988.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_room_mention_enabled() != 31650.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_room_notification_mode() != 4135.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_set_user_mention_enabled() != 56594.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettings_unmute_room() != 47580.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_oidcauthenticationdata_login_url() != 43638.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_active_members_count() != 61905.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_active_room_call_participants() != 41533.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_alternative_aliases() != 28555.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_apply_power_level_changes() != 44206.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_avatar_url() != 34637.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_ban_user() != 35046.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_ban() != 64711.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_invite() != 62459.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_kick() != 12773.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_redact_other() != 13274.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_redact_own() != 57442.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_send_message() != 36743.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_send_state() != 19062.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_can_user_trigger_room_notification() != 18832.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_canonical_alias() != 19786.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_clear_composer_draft() != 39667.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_discard_room_key() != 18081.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_display_name() != 64194.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_enable_send_queue() != 23914.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_get_power_levels() != 54094.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_has_active_room_call() != 33588.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_heroes() != 22313.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_id() != 61990.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_ignore_user() != 62239.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_invite_user_by_id() != 41133.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_invited_members_count() != 1023.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_inviter() != 49874.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_is_direct() != 16947.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_is_encrypted() != 55158.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_is_public() != 7336.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_is_send_queue_enabled() != 36591.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_is_space() != 16919.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_is_tombstoned() != 49186.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_join() != 9240.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_joined_members_count() != 55835.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_kick_user() != 28600.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_leave() != 63688.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_load_composer_draft() != 53887.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_mark_as_read() != 16004.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_matrix_to_event_permalink() != 36705.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_matrix_to_permalink() != 47781.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_member() != 48980.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_member_avatar_url() != 29492.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_member_display_name() != 33206.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_members() != 42691.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_members_no_sync() != 3255.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_membership() != 26065.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_own_user_id() != 39510.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_raw_name() != 15453.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_redact() != 2549.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_remove_avatar() != 7230.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_report_content() != 16529.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_reset_power_levels() != 63622.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_room_info() != 41146.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_save_composer_draft() != 56684.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_send_call_notification() != 43366.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_send_call_notification_if_needed() != 24013.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_set_is_favourite() != 64403.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_set_is_low_priority() != 48070.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_set_name() != 52127.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_set_topic() != 5576.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_set_unread_flag() != 2381.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_subscribe_to_room_info_updates() != 48209.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_subscribe_to_typing_notifications() != 38524.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_suggested_role_for_user() != 47787.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_timeline() != 701.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_timeline_focused_on_event() != 27319.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_topic() != 59745.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_typing_notice() != 28642.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_unban_user() != 1803.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_update_power_levels_for_users() != 52057.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_room_upload_avatar() != 19069.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomdirectorysearch_is_at_last_page() != 22509.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomdirectorysearch_loaded_pages() != 7109.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomdirectorysearch_next_page() != 14603.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomdirectorysearch_results() != 40665.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomdirectorysearch_search() != 26558.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlist_entries() != 26697.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlist_entries_with_dynamic_adapters() != 46829.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlist_loading_state() != 21585.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlist_room() != 8801.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistdynamicentriescontroller_add_one_page() != 47748.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistdynamicentriescontroller_reset_to_one_page() != 61352.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistdynamicentriescontroller_set_filter() != 61202.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_avatar_url() != 39097.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_canonical_alias() != 63300.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_display_name() != 8651.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_full_room() != 41333.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_id() != 41176.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_init_timeline() != 61817.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_is_direct() != 46873.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_is_timeline_initialized() != 46855.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_latest_event() != 41471.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_room_info() != 32985.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_subscribe() != 60003.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistitem_unsubscribe() != 45026.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_all_rooms() != 49704.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_apply_input() != 31607.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_room() != 5185.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_state() != 64650.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservice_sync_indicator() != 16821.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommembersiterator_len() != 39835.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roommembersiterator_next_chunk() != 23186.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sendattachmentjoinhandle_cancel() != 19759.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sendattachmentjoinhandle_join() != 49985.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_approve_verification() != 12154.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_cancel_verification() != 42503.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_decline_verification() != 51976.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_is_verified() != 60081.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_request_verification() != 22948.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_set_delegate() != 42324.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontroller_start_sas_verification() != 17409.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationemoji_description() != 21346.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationemoji_symbol() != 46075.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_span_enter() != 8900.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_span_exit() != 47924.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_span_is_none() != 33327.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservice_room_list_service() != 26426.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservice_start() != 16010.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservice_state() != 61806.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservice_stop() != 23138.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservicebuilder_finish() != 22814.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservicebuilder_with_cross_process_lock() != 31599.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservicebuilder_with_utd_hook() != 9029.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_taskhandle_cancel() != 9124.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_taskhandle_is_finished() != 29008.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_add_listener() != 18746.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_create_poll() != 37925.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_edit() != 45021.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_edit_poll() != 40066.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_end_poll() != 31506.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_fetch_details_for_event() != 54068.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_fetch_members() != 37994.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_focused_paginate_forwards() != 51003.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_get_event_timeline_item_by_event_id() != 28091.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_get_event_timeline_item_by_transaction_id() != 64706.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_load_reply_details() != 52892.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_mark_as_read() != 16621.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_paginate_backwards() != 65175.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_redact_event() != 8574.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_retry_decryption() != 21112.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_send() != 62420.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_send_audio() != 47157.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_send_file() != 9210.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_send_image() != 30540.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_send_location() != 47400.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_send_poll_response() != 59076.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_send_read_receipt() != 37532.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_send_reply() != 356.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_send_video() != 34287.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_send_voice_message() != 49989.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_subscribe_to_back_pagination_status() != 46161.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timeline_toggle_reaction() != 10294.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_append() != 8453.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_change() != 4562.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_insert() != 26630.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_push_back() != 53464.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_push_front() != 42084.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_remove() != 74.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_reset() != 34118.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinediff_set() != 13334.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineevent_event_id() != 11088.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineevent_event_type() != 12922.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineevent_sender_id() != 18142.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineevent_timestamp() != 58123.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineitem_as_event() != 52211.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineitem_as_virtual() != 50960.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineitem_fmt_debug() != 38094.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineitem_unique_id() != 30409.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineitemcontent_as_message() != 45784.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelineitemcontent_kind() != 44789.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_unreadnotificationscount_has_notifications() != 33024.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_unreadnotificationscount_highlight_count() != 35997.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_unreadnotificationscount_notification_count() != 35655.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_widgetdriver_run() != 7519.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_widgetdriverhandle_recv() != 2662.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_widgetdriverhandle_send() != 18689.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_constructor_mediasource_from_json() != 29216.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_constructor_authenticationservice_new() != 23411.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_constructor_clientbuilder_new() != 27991.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_constructor_qrcodedata_from_bytes() != 32675.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_constructor_span_current() != 53698.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_constructor_span_new() != 30597.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_constructor_timelineeventtypefilter_exclude() != 53805.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_constructor_timelineeventtypefilter_include() != 25498.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_backupstatelistener_on_update() != 12849.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_backupsteadystatelistener_on_update() != 41052.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientdelegate_did_receive_auth_error() != 26350.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientdelegate_did_refresh_tokens() != 16325.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientsessiondelegate_retrieve_session_from_keychain() != 43954.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_clientsessiondelegate_save_session_in_keychain() != 53223.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_enablerecoveryprogresslistener_on_update() != 13538.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_ignoreduserslistener_call() != 47519.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_notificationsettingsdelegate_settings_did_change() != 51708.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_paginationstatuslistener_on_update() != 29884.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_progresswatcher_transmission_progress() != 41133.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_qrloginprogresslistener_on_update() != 9758.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_recoverystatelistener_on_update() != 64575.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomdirectorysearchentrieslistener_on_update() != 41968.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roominfolistener_call() != 44934.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistentrieslistener_on_update() != 12576.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistloadingstatelistener_on_update() != 23169.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservicestatelistener_on_update() != 24823.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_roomlistservicesyncindicatorlistener_on_update() != 36937.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sendqueueroomerrorlistener_on_error() != 38224.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_accept_verification_request() != 22759.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_start_sas_verification() != 54982.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_receive_verification_data() != 19380.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_fail() != 56823.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_cancel() != 29888.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_sessionverificationcontrollerdelegate_did_finish() != 54532.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_syncservicestateobserver_on_update() != 62231.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_timelinelistener_on_update() != 30147.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_typingnotificationslistener_call() != 64299.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_unabletodecryptdelegate_on_utd() != 61791.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_verificationstatelistener_on_update() != 38998.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_matrix_sdk_ffi_checksum_method_widgetcapabilitiesprovider_acquire_capabilities() != 12846.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

// Async support
// Async return type handlers

internal const val UNIFFI_RUST_FUTURE_POLL_READY = 0.toByte()
internal const val UNIFFI_RUST_FUTURE_POLL_MAYBE_READY = 1.toByte()

internal val uniffiContinuationHandleMap = UniffiHandleMap<CancellableContinuation<Byte>>()

// FFI type for Rust future continuations
internal object uniffiRustFutureContinuationCallbackImpl: UniffiRustFutureContinuationCallback {
    override fun callback(data: Long, pollResult: Byte) {
        uniffiContinuationHandleMap.remove(data).resume(pollResult)
    }
}

internal suspend fun<T, F, E: Exception> uniffiRustCallAsync(
    rustFuture: Long,
    pollFunc: (Long, UniffiRustFutureContinuationCallback, Long) -> Unit,
    completeFunc: (Long, UniffiRustCallStatus) -> F,
    freeFunc: (Long) -> Unit,
    liftFunc: (F) -> T,
    errorHandler: UniffiRustCallStatusErrorHandler<E>
): T {
    try {
        do {
            val pollResult = suspendCancellableCoroutine<Byte> { continuation ->
                pollFunc(
                    rustFuture,
                    uniffiRustFutureContinuationCallbackImpl,
                    uniffiContinuationHandleMap.insert(continuation)
                )
            }
        } while (pollResult != UNIFFI_RUST_FUTURE_POLL_READY);

        return liftFunc(
            uniffiRustCallWithError(errorHandler, { status -> completeFunc(rustFuture, status) })
        )
    } finally {
        freeFunc(rustFuture)
    }
}

// Public interface members begin here.


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }

/** Used to instantiate an interface without an actual pointer, for fakes in tests, mostly. */
object NoPointer

public object FfiConverterUByte: FfiConverter<UByte, Byte> {
    override fun lift(value: Byte): UByte {
        return value.toUByte()
    }

    override fun read(buf: ByteBuffer): UByte {
        return lift(buf.get())
    }

    override fun lower(value: UByte): Byte {
        return value.toByte()
    }

    override fun allocationSize(value: UByte) = 1UL

    override fun write(value: UByte, buf: ByteBuffer) {
        buf.put(value.toByte())
    }
}

public object FfiConverterUShort: FfiConverter<UShort, Short> {
    override fun lift(value: Short): UShort {
        return value.toUShort()
    }

    override fun read(buf: ByteBuffer): UShort {
        return lift(buf.getShort())
    }

    override fun lower(value: UShort): Short {
        return value.toShort()
    }

    override fun allocationSize(value: UShort) = 2UL

    override fun write(value: UShort, buf: ByteBuffer) {
        buf.putShort(value.toShort())
    }
}

public object FfiConverterUInt: FfiConverter<UInt, Int> {
    override fun lift(value: Int): UInt {
        return value.toUInt()
    }

    override fun read(buf: ByteBuffer): UInt {
        return lift(buf.getInt())
    }

    override fun lower(value: UInt): Int {
        return value.toInt()
    }

    override fun allocationSize(value: UInt) = 4UL

    override fun write(value: UInt, buf: ByteBuffer) {
        buf.putInt(value.toInt())
    }
}

public object FfiConverterInt: FfiConverter<Int, Int> {
    override fun lift(value: Int): Int {
        return value
    }

    override fun read(buf: ByteBuffer): Int {
        return buf.getInt()
    }

    override fun lower(value: Int): Int {
        return value
    }

    override fun allocationSize(value: Int) = 4UL

    override fun write(value: Int, buf: ByteBuffer) {
        buf.putInt(value)
    }
}

public object FfiConverterULong: FfiConverter<ULong, Long> {
    override fun lift(value: Long): ULong {
        return value.toULong()
    }

    override fun read(buf: ByteBuffer): ULong {
        return lift(buf.getLong())
    }

    override fun lower(value: ULong): Long {
        return value.toLong()
    }

    override fun allocationSize(value: ULong) = 8UL

    override fun write(value: ULong, buf: ByteBuffer) {
        buf.putLong(value.toLong())
    }
}

public object FfiConverterLong: FfiConverter<Long, Long> {
    override fun lift(value: Long): Long {
        return value
    }

    override fun read(buf: ByteBuffer): Long {
        return buf.getLong()
    }

    override fun lower(value: Long): Long {
        return value
    }

    override fun allocationSize(value: Long) = 8UL

    override fun write(value: Long, buf: ByteBuffer) {
        buf.putLong(value)
    }
}

public object FfiConverterDouble: FfiConverter<Double, Double> {
    override fun lift(value: Double): Double {
        return value
    }

    override fun read(buf: ByteBuffer): Double {
        return buf.getDouble()
    }

    override fun lower(value: Double): Double {
        return value
    }

    override fun allocationSize(value: Double) = 8UL

    override fun write(value: Double, buf: ByteBuffer) {
        buf.putDouble(value)
    }
}

public object FfiConverterBoolean: FfiConverter<Boolean, Byte> {
    override fun lift(value: Byte): Boolean {
        return value.toInt() != 0
    }

    override fun read(buf: ByteBuffer): Boolean {
        return lift(buf.get())
    }

    override fun lower(value: Boolean): Byte {
        return if (value) 1.toByte() else 0.toByte()
    }

    override fun allocationSize(value: Boolean) = 1UL

    override fun write(value: Boolean, buf: ByteBuffer) {
        buf.put(lower(value))
    }
}

public object FfiConverterString: FfiConverter<String, RustBuffer.ByValue> {
    // Note: we don't inherit from FfiConverterRustBuffer, because we use a
    // special encoding when lowering/lifting.  We can use `RustBuffer.len` to
    // store our length and avoid writing it out to the buffer.
    override fun lift(value: RustBuffer.ByValue): String {
        try {
            val byteArr = ByteArray(value.len.toInt())
            value.asByteBuffer()!!.get(byteArr)
            return byteArr.toString(Charsets.UTF_8)
        } finally {
            RustBuffer.free(value)
        }
    }

    override fun read(buf: ByteBuffer): String {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr.toString(Charsets.UTF_8)
    }

    fun toUtf8(value: String): ByteBuffer {
        // Make sure we don't have invalid UTF-16, check for lone surrogates.
        return Charsets.UTF_8.newEncoder().run {
            onMalformedInput(CodingErrorAction.REPORT)
            encode(CharBuffer.wrap(value))
        }
    }

    override fun lower(value: String): RustBuffer.ByValue {
        val byteBuf = toUtf8(value)
        // Ideally we'd pass these bytes to `ffi_bytebuffer_from_bytes`, but doing so would require us
        // to copy them into a JNA `Memory`. So we might as well directly copy them into a `RustBuffer`.
        val rbuf = RustBuffer.alloc(byteBuf.limit().toULong())
        rbuf.asByteBuffer()!!.put(byteBuf)
        return rbuf
    }

    // We aren't sure exactly how many bytes our string will be once it's UTF-8
    // encoded.  Allocate 3 bytes per UTF-16 code unit which will always be
    // enough.
    override fun allocationSize(value: String): ULong {
        val sizeForLength = 4UL
        val sizeForString = value.length.toULong() * 3UL
        return sizeForLength + sizeForString
    }

    override fun write(value: String, buf: ByteBuffer) {
        val byteBuf = toUtf8(value)
        buf.putInt(byteBuf.limit())
        buf.put(byteBuf)
    }
}

public object FfiConverterByteArray: FfiConverterRustBuffer<ByteArray> {
    override fun read(buf: ByteBuffer): ByteArray {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr
    }
    override fun allocationSize(value: ByteArray): ULong {
        return 4UL + value.size.toULong()
    }
    override fun write(value: ByteArray, buf: ByteBuffer) {
        buf.putInt(value.size)
        buf.put(value)
    }
}


public object FfiConverterDuration: FfiConverterRustBuffer<java.time.Duration> {
    override fun read(buf: ByteBuffer): java.time.Duration {
        // Type mismatch (should be u64) but we check for overflow/underflow below
        val seconds = buf.getLong()
        // Type mismatch (should be u32) but we check for overflow/underflow below
        val nanoseconds = buf.getInt().toLong()
        if (seconds < 0) {
            throw java.time.DateTimeException("Duration exceeds minimum or maximum value supported by uniffi")
        }
        if (nanoseconds < 0) {
            throw java.time.DateTimeException("Duration nanoseconds exceed minimum or maximum supported by uniffi")
        }
        return java.time.Duration.ofSeconds(seconds, nanoseconds)
    }

    // 8 bytes for seconds, 4 bytes for nanoseconds
    override fun allocationSize(value: java.time.Duration) = 12UL

    override fun write(value: java.time.Duration, buf: ByteBuffer) {
        if (value.seconds < 0) {
            // Rust does not support negative Durations
            throw IllegalArgumentException("Invalid duration, must be non-negative")
        }

        if (value.nano < 0) {
            // Java docs provide guarantee that nano will always be positive, so this should be impossible
            // See: https://docs.oracle.com/javase/8/docs/api/java/time/Duration.html
            throw IllegalArgumentException("Invalid duration, nano value must be non-negative")
        }

        // Type mismatch (should be u64) but since Rust doesn't support negative durations we should be OK
        buf.putLong(value.seconds)
        // Type mismatch (should be u32) but since values will always be between 0 and 999,999,999 it should be OK
        buf.putInt(value.nano)
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


// The cleaner interface for Object finalization code to run.
// This is the entry point to any implementation that we're using.
//
// The cleaner registers objects and returns cleanables, so now we are
// defining a `UniffiCleaner` with a `UniffiClenaer.Cleanable` to abstract the
// different implmentations available at compile time.
interface UniffiCleaner {
    interface Cleanable {
        fun clean()
    }

    fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable

    companion object
}

// The fallback Jna cleaner, which is available for both Android, and the JVM.
private class UniffiJnaCleaner : UniffiCleaner {
    private val cleaner = com.sun.jna.internal.Cleaner.getCleaner()

    override fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable =
        UniffiJnaCleanable(cleaner.register(value, cleanUpTask))
}

private class UniffiJnaCleanable(
    private val cleanable: com.sun.jna.internal.Cleaner.Cleanable,
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}

// We decide at uniffi binding generation time whether we were
// using Android or not.
// There are further runtime checks to chose the correct implementation
// of the cleaner.


private fun UniffiCleaner.Companion.create(): UniffiCleaner =
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.UPSIDE_DOWN_CAKE) {
        AndroidSystemCleaner()
    } else {
        UniffiJnaCleaner()
    }

// The SystemCleaner, available from API Level 33.
// Some API Level 33 OSes do not support using it, so we require API Level 34.
@RequiresApi(Build.VERSION_CODES.UPSIDE_DOWN_CAKE)
private class AndroidSystemCleaner : UniffiCleaner {
    val cleaner = android.system.SystemCleaner.cleaner()

    override fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable =
        AndroidSystemCleanable(cleaner.register(value, cleanUpTask))
}

@RequiresApi(Build.VERSION_CODES.UPSIDE_DOWN_CAKE)
private class AndroidSystemCleanable(
    private val cleanable: java.lang.ref.Cleaner.Cleanable,
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}
public interface AbortSendHandleInterface {
    
    /**
     * Try to abort the sending of the current event.
     *
     * If this returns `true`, then the sending could be aborted, because the
     * event hasn't been sent yet. Otherwise, if this returns `false`, the
     * event had already been sent and could not be aborted.
     *
     * This has an effect only on the first call; subsequent calls will always
     * return `false`.
     */
    suspend fun `abort`(): kotlin.Boolean
    
    companion object
}

open class AbortSendHandle: Disposable, AutoCloseable, AbortSendHandleInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_abortsendhandle(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_abortsendhandle(pointer!!, status)
        }
    }

    
    /**
     * Try to abort the sending of the current event.
     *
     * If this returns `true`, then the sending could be aborted, because the
     * event hasn't been sent yet. Otherwise, if this returns `false`, the
     * event had already been sent and could not be aborted.
     *
     * This has an effect only on the first call; subsequent calls will always
     * return `false`.
     */
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `abort`() : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_abortsendhandle_abort(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        UniffiNullRustCallStatusErrorHandler,
    )
    }

    

    
    
    companion object
    
}

public object FfiConverterTypeAbortSendHandle: FfiConverter<AbortSendHandle, Pointer> {

    override fun lower(value: AbortSendHandle): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): AbortSendHandle {
        return AbortSendHandle(value)
    }

    override fun read(buf: ByteBuffer): AbortSendHandle {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: AbortSendHandle) = 8UL

    override fun write(value: AbortSendHandle, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface AuthenticationServiceInterface {
    
    /**
     * Updates the service to authenticate with the homeserver for the
     * specified address.
     */
    suspend fun `configureHomeserver`(`serverNameOrHomeserverUrl`: kotlin.String)
    
    fun `homeserverDetails`(): HomeserverLoginDetails?
    
    /**
     * Performs a password login using the current homeserver.
     */
    suspend fun `login`(`username`: kotlin.String, `password`: kotlin.String, `initialDeviceName`: kotlin.String?, `deviceId`: kotlin.String?): Client
    
    /**
     * Completes the OIDC login process.
     */
    suspend fun `loginWithOidcCallback`(`authenticationData`: OidcAuthenticationData, `callbackUrl`: kotlin.String): Client
    
    /**
     * Requests the URL needed for login in a web view using OIDC. Once the web
     * view has succeeded, call `login_with_oidc_callback` with the callback it
     * returns.
     */
    suspend fun `urlForOidcLogin`(): OidcAuthenticationData
    
    companion object
}

open class AuthenticationService: Disposable, AutoCloseable, AuthenticationServiceInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    /**
     * Creates a new service to authenticate a user with.
     *
     * # Arguments
     *
     * * `session_path` - A path to the directory where the session data will
     * be stored. A new directory **must** be given for each subsequent
     * session as the database isn't designed to be shared.
     *
     * * `passphrase` - An optional passphrase to use to encrypt the session
     * data.
     *
     * * `user_agent` - An optional user agent to use when making requests.
     *
     * * `additional_root_certificates` - Additional root certificates to trust
     * when making requests when built with rustls.
     *
     * * `proxy` - An optional HTTP(S) proxy URL to use when making requests.
     *
     * * `oidc_configuration` - Configuration data about the app to use during
     * OIDC authentication. This is required if OIDC authentication is to be
     * used.
     *
     * * `custom_sliding_sync_proxy` - An optional sliding sync proxy URL that
     * will override the proxy discovered from the homeserver's well-known.
     *
     * * `session_delegate` - A delegate that will handle token refresh etc.
     * when the cross-process lock is configured.
     *
     * * `cross_process_refresh_lock_id` - A process ID to use for
     * cross-process token refresh locks.
     */
    constructor(`sessionPath`: kotlin.String, `passphrase`: kotlin.String?, `userAgent`: kotlin.String?, `additionalRootCertificates`: List<kotlin.ByteArray>, `proxy`: kotlin.String?, `oidcConfiguration`: OidcConfiguration?, `customSlidingSyncProxy`: kotlin.String?, `sessionDelegate`: ClientSessionDelegate?, `crossProcessRefreshLockId`: kotlin.String?) :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_constructor_authenticationservice_new(
        FfiConverterString.lower(`sessionPath`),FfiConverterOptionalString.lower(`passphrase`),FfiConverterOptionalString.lower(`userAgent`),FfiConverterSequenceByteArray.lower(`additionalRootCertificates`),FfiConverterOptionalString.lower(`proxy`),FfiConverterOptionalTypeOidcConfiguration.lower(`oidcConfiguration`),FfiConverterOptionalString.lower(`customSlidingSyncProxy`),FfiConverterOptionalTypeClientSessionDelegate.lower(`sessionDelegate`),FfiConverterOptionalString.lower(`crossProcessRefreshLockId`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_authenticationservice(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_authenticationservice(pointer!!, status)
        }
    }

    
    /**
     * Updates the service to authenticate with the homeserver for the
     * specified address.
     */
    @Throws(AuthenticationException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `configureHomeserver`(`serverNameOrHomeserverUrl`: kotlin.String) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_authenticationservice_configure_homeserver(
                thisPtr,
                FfiConverterString.lower(`serverNameOrHomeserverUrl`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        AuthenticationException.ErrorHandler,
    )
    }

    override fun `homeserverDetails`(): HomeserverLoginDetails? {
            return FfiConverterOptionalTypeHomeserverLoginDetails.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_authenticationservice_homeserver_details(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * Performs a password login using the current homeserver.
     */
    @Throws(AuthenticationException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `login`(`username`: kotlin.String, `password`: kotlin.String, `initialDeviceName`: kotlin.String?, `deviceId`: kotlin.String?) : Client {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_authenticationservice_login(
                thisPtr,
                FfiConverterString.lower(`username`),FfiConverterString.lower(`password`),FfiConverterOptionalString.lower(`initialDeviceName`),FfiConverterOptionalString.lower(`deviceId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeClient.lift(it) },
        // Error FFI converter
        AuthenticationException.ErrorHandler,
    )
    }

    
    /**
     * Completes the OIDC login process.
     */
    @Throws(AuthenticationException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `loginWithOidcCallback`(`authenticationData`: OidcAuthenticationData, `callbackUrl`: kotlin.String) : Client {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_authenticationservice_login_with_oidc_callback(
                thisPtr,
                FfiConverterTypeOidcAuthenticationData.lower(`authenticationData`),FfiConverterString.lower(`callbackUrl`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeClient.lift(it) },
        // Error FFI converter
        AuthenticationException.ErrorHandler,
    )
    }

    
    /**
     * Requests the URL needed for login in a web view using OIDC. Once the web
     * view has succeeded, call `login_with_oidc_callback` with the callback it
     * returns.
     */
    @Throws(AuthenticationException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `urlForOidcLogin`() : OidcAuthenticationData {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_authenticationservice_url_for_oidc_login(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeOidcAuthenticationData.lift(it) },
        // Error FFI converter
        AuthenticationException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

public object FfiConverterTypeAuthenticationService: FfiConverter<AuthenticationService, Pointer> {

    override fun lower(value: AuthenticationService): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): AuthenticationService {
        return AuthenticationService(value)
    }

    override fun read(buf: ByteBuffer): AuthenticationService {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: AuthenticationService) = 8UL

    override fun write(value: AuthenticationService, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface ClientInterface {
    
    /**
     * Get the content of the event of the given type out of the account data
     * store.
     *
     * It will be returned as a JSON string.
     */
    suspend fun `accountData`(`eventType`: kotlin.String): kotlin.String?
    
    suspend fun `accountUrl`(`action`: AccountManagementAction?): kotlin.String?
    
    /**
     * Sends a request to retrieve the avatar URL. Will fill the cache used by
     * [`Self::cached_avatar_url`] on success.
     */
    suspend fun `avatarUrl`(): kotlin.String?
    
    /**
     * Retrieves an avatar cached from a previous call to [`Self::avatar_url`].
     */
    fun `cachedAvatarUrl`(): kotlin.String?
    
    suspend fun `createRoom`(`request`: CreateRoomParameters): kotlin.String
    
    /**
     * Deletes a pusher of given pusher ids
     */
    suspend fun `deletePusher`(`identifiers`: PusherIdentifiers)
    
    fun `deviceId`(): kotlin.String
    
    suspend fun `displayName`(): kotlin.String
    
    /**
     * Enables or disables all the room send queues at once.
     *
     * When connectivity is lost on a device, it is recommended to disable the
     * room sending queues.
     *
     * This can be controlled for individual rooms, using
     * [`Room::enable_send_queue`].
     */
    fun `enableAllSendQueues`(`enable`: kotlin.Boolean)
    
    fun `encryption`(): Encryption
    
    fun `getDmRoom`(`userId`: kotlin.String): Room?
    
    suspend fun `getMediaContent`(`mediaSource`: MediaSource): kotlin.ByteArray
    
    suspend fun `getMediaFile`(`mediaSource`: MediaSource, `body`: kotlin.String?, `mimeType`: kotlin.String, `useCache`: kotlin.Boolean, `tempDir`: kotlin.String?): MediaFileHandle
    
    suspend fun `getMediaThumbnail`(`mediaSource`: MediaSource, `width`: kotlin.ULong, `height`: kotlin.ULong): kotlin.ByteArray
    
    fun `getNotificationSettings`(): NotificationSettings
    
    suspend fun `getProfile`(`userId`: kotlin.String): UserProfile
    
    suspend fun `getRecentlyVisitedRooms`(): List<kotlin.String>
    
    /**
     * Given a room alias, get the preview of a room, to interact with it.
     */
    suspend fun `getRoomPreviewFromRoomAlias`(`roomAlias`: kotlin.String): RoomPreview
    
    /**
     * Given a room id, get the preview of a room, to interact with it.
     *
     * The list of `via_servers` must be a list of servers that know
     * about the room and can resolve it, and that may appear as a `via`
     * parameter in e.g. a permalink URL. This list can be empty.
     */
    suspend fun `getRoomPreviewFromRoomId`(`roomId`: kotlin.String, `viaServers`: List<kotlin.String>): RoomPreview
    
    suspend fun `getSessionVerificationController`(): SessionVerificationController
    
    /**
     * The homeserver this client is configured to use.
     */
    fun `homeserver`(): kotlin.String
    
    suspend fun `ignoreUser`(`userId`: kotlin.String)
    
    suspend fun `ignoredUsers`(): List<kotlin.String>
    
    /**
     * Join a room by its ID.
     *
     * Use this method when the homeserver already knows of the given room ID.
     * Otherwise use `join_room_by_id_or_alias` so you can pass a list of
     * server names for the homeserver to find the room.
     */
    suspend fun `joinRoomById`(`roomId`: kotlin.String): Room
    
    /**
     * Join a room by its ID or alias.
     *
     * When supplying the room's ID, you can also supply a list of server names
     * for the homeserver to find the room. Typically these server names
     * come from a permalink's `via` parameters, or from resolving a room's
     * alias into an ID.
     */
    suspend fun `joinRoomByIdOrAlias`(`roomIdOrAlias`: kotlin.String, `serverNames`: List<kotlin.String>): Room
    
    /**
     * Login using a username and password.
     */
    suspend fun `login`(`username`: kotlin.String, `password`: kotlin.String, `initialDeviceName`: kotlin.String?, `deviceId`: kotlin.String?)
    
    /**
     * Log out the current user. This method returns an optional URL that
     * should be presented to the user to complete logout (in the case of
     * Session having been authenticated using OIDC).
     */
    suspend fun `logout`(): kotlin.String?
    
    suspend fun `notificationClient`(`processSetup`: NotificationProcessSetup): NotificationClient
    
    suspend fun `removeAvatar`()
    
    /**
     * Resolves the given room alias to a room ID (and a list of servers), if
     * possible.
     */
    suspend fun `resolveRoomAlias`(`roomAlias`: kotlin.String): ResolvedRoomAlias
    
    /**
     * Restores the client from a `Session`.
     */
    suspend fun `restoreSession`(`session`: Session)
    
    fun `roomDirectorySearch`(): RoomDirectorySearch
    
    fun `rooms`(): List<Room>
    
    suspend fun `searchUsers`(`searchTerm`: kotlin.String, `limit`: kotlin.ULong): SearchUsersResults
    
    fun `session`(): Session
    
    /**
     * Set the given account data content for the given event type.
     *
     * It should be supplied as a JSON string.
     */
    suspend fun `setAccountData`(`eventType`: kotlin.String, `content`: kotlin.String)
    
    fun `setDelegate`(`delegate`: ClientDelegate?): TaskHandle?
    
    suspend fun `setDisplayName`(`name`: kotlin.String)
    
    /**
     * Registers a pusher with given parameters
     */
    suspend fun `setPusher`(`identifiers`: PusherIdentifiers, `kind`: PusherKind, `appDisplayName`: kotlin.String, `deviceDisplayName`: kotlin.String, `profileTag`: kotlin.String?, `lang`: kotlin.String)
    
    fun `subscribeToIgnoredUsers`(`listener`: IgnoredUsersListener): TaskHandle
    
    /**
     * Subscribe to the global enablement status of the send queue, at the
     * client-wide level.
     *
     * The given listener will be immediately called with the initial value of
     * the enablement status.
     */
    fun `subscribeToSendQueueStatus`(`listener`: SendQueueRoomErrorListener): TaskHandle
    
    fun `syncService`(): SyncServiceBuilder
    
    suspend fun `trackRecentlyVisitedRoom`(`room`: kotlin.String)
    
    suspend fun `unignoreUser`(`userId`: kotlin.String)
    
    suspend fun `uploadAvatar`(`mimeType`: kotlin.String, `data`: kotlin.ByteArray)
    
    suspend fun `uploadMedia`(`mimeType`: kotlin.String, `data`: kotlin.ByteArray, `progressWatcher`: ProgressWatcher?): kotlin.String
    
    fun `userId`(): kotlin.String
    
    companion object
}

open class Client: Disposable, AutoCloseable, ClientInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_client(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_client(pointer!!, status)
        }
    }

    
    /**
     * Get the content of the event of the given type out of the account data
     * store.
     *
     * It will be returned as a JSON string.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `accountData`(`eventType`: kotlin.String) : kotlin.String? {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_account_data(
                thisPtr,
                FfiConverterString.lower(`eventType`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterOptionalString.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `accountUrl`(`action`: AccountManagementAction?) : kotlin.String? {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_account_url(
                thisPtr,
                FfiConverterOptionalTypeAccountManagementAction.lower(`action`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterOptionalString.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Sends a request to retrieve the avatar URL. Will fill the cache used by
     * [`Self::cached_avatar_url`] on success.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `avatarUrl`() : kotlin.String? {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_avatar_url(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterOptionalString.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Retrieves an avatar cached from a previous call to [`Self::avatar_url`].
     */
    @Throws(ClientException::class)override fun `cachedAvatarUrl`(): kotlin.String? {
            return FfiConverterOptionalString.lift(
    callWithPointer {
    uniffiRustCallWithError(ClientException) { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_cached_avatar_url(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `createRoom`(`request`: CreateRoomParameters) : kotlin.String {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_create_room(
                thisPtr,
                FfiConverterTypeCreateRoomParameters.lower(`request`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterString.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Deletes a pusher of given pusher ids
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `deletePusher`(`identifiers`: PusherIdentifiers) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_delete_pusher(
                thisPtr,
                FfiConverterTypePusherIdentifiers.lower(`identifiers`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)override fun `deviceId`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(ClientException) { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_device_id(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `displayName`() : kotlin.String {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_display_name(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterString.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Enables or disables all the room send queues at once.
     *
     * When connectivity is lost on a device, it is recommended to disable the
     * room sending queues.
     *
     * This can be controlled for individual rooms, using
     * [`Room::enable_send_queue`].
     */override fun `enableAllSendQueues`(`enable`: kotlin.Boolean)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_enable_all_send_queues(
        it, FfiConverterBoolean.lower(`enable`),_status)
}
    }
    
    

    override fun `encryption`(): Encryption {
            return FfiConverterTypeEncryption.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_encryption(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(ClientException::class)override fun `getDmRoom`(`userId`: kotlin.String): Room? {
            return FfiConverterOptionalTypeRoom.lift(
    callWithPointer {
    uniffiRustCallWithError(ClientException) { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_dm_room(
        it, FfiConverterString.lower(`userId`),_status)
}
    }
    )
    }
    

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getMediaContent`(`mediaSource`: MediaSource) : kotlin.ByteArray {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_media_content(
                thisPtr,
                FfiConverterTypeMediaSource.lower(`mediaSource`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterByteArray.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getMediaFile`(`mediaSource`: MediaSource, `body`: kotlin.String?, `mimeType`: kotlin.String, `useCache`: kotlin.Boolean, `tempDir`: kotlin.String?) : MediaFileHandle {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_media_file(
                thisPtr,
                FfiConverterTypeMediaSource.lower(`mediaSource`),FfiConverterOptionalString.lower(`body`),FfiConverterString.lower(`mimeType`),FfiConverterBoolean.lower(`useCache`),FfiConverterOptionalString.lower(`tempDir`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeMediaFileHandle.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getMediaThumbnail`(`mediaSource`: MediaSource, `width`: kotlin.ULong, `height`: kotlin.ULong) : kotlin.ByteArray {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_media_thumbnail(
                thisPtr,
                FfiConverterTypeMediaSource.lower(`mediaSource`),FfiConverterULong.lower(`width`),FfiConverterULong.lower(`height`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterByteArray.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    override fun `getNotificationSettings`(): NotificationSettings {
            return FfiConverterTypeNotificationSettings.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_notification_settings(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getProfile`(`userId`: kotlin.String) : UserProfile {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_profile(
                thisPtr,
                FfiConverterString.lower(`userId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeUserProfile.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getRecentlyVisitedRooms`() : List<kotlin.String> {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_recently_visited_rooms(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterSequenceString.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Given a room alias, get the preview of a room, to interact with it.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getRoomPreviewFromRoomAlias`(`roomAlias`: kotlin.String) : RoomPreview {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_room_preview_from_room_alias(
                thisPtr,
                FfiConverterString.lower(`roomAlias`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeRoomPreview.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Given a room id, get the preview of a room, to interact with it.
     *
     * The list of `via_servers` must be a list of servers that know
     * about the room and can resolve it, and that may appear as a `via`
     * parameter in e.g. a permalink URL. This list can be empty.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getRoomPreviewFromRoomId`(`roomId`: kotlin.String, `viaServers`: List<kotlin.String>) : RoomPreview {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_room_preview_from_room_id(
                thisPtr,
                FfiConverterString.lower(`roomId`),FfiConverterSequenceString.lower(`viaServers`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeRoomPreview.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getSessionVerificationController`() : SessionVerificationController {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_get_session_verification_controller(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeSessionVerificationController.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * The homeserver this client is configured to use.
     */override fun `homeserver`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_homeserver(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `ignoreUser`(`userId`: kotlin.String) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_ignore_user(
                thisPtr,
                FfiConverterString.lower(`userId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `ignoredUsers`() : List<kotlin.String> {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_ignored_users(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterSequenceString.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Join a room by its ID.
     *
     * Use this method when the homeserver already knows of the given room ID.
     * Otherwise use `join_room_by_id_or_alias` so you can pass a list of
     * server names for the homeserver to find the room.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `joinRoomById`(`roomId`: kotlin.String) : Room {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_join_room_by_id(
                thisPtr,
                FfiConverterString.lower(`roomId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeRoom.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Join a room by its ID or alias.
     *
     * When supplying the room's ID, you can also supply a list of server names
     * for the homeserver to find the room. Typically these server names
     * come from a permalink's `via` parameters, or from resolving a room's
     * alias into an ID.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `joinRoomByIdOrAlias`(`roomIdOrAlias`: kotlin.String, `serverNames`: List<kotlin.String>) : Room {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_join_room_by_id_or_alias(
                thisPtr,
                FfiConverterString.lower(`roomIdOrAlias`),FfiConverterSequenceString.lower(`serverNames`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeRoom.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Login using a username and password.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `login`(`username`: kotlin.String, `password`: kotlin.String, `initialDeviceName`: kotlin.String?, `deviceId`: kotlin.String?) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_login(
                thisPtr,
                FfiConverterString.lower(`username`),FfiConverterString.lower(`password`),FfiConverterOptionalString.lower(`initialDeviceName`),FfiConverterOptionalString.lower(`deviceId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Log out the current user. This method returns an optional URL that
     * should be presented to the user to complete logout (in the case of
     * Session having been authenticated using OIDC).
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `logout`() : kotlin.String? {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_logout(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterOptionalString.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `notificationClient`(`processSetup`: NotificationProcessSetup) : NotificationClient {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_notification_client(
                thisPtr,
                FfiConverterTypeNotificationProcessSetup.lower(`processSetup`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeNotificationClient.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `removeAvatar`() {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_remove_avatar(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Resolves the given room alias to a room ID (and a list of servers), if
     * possible.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `resolveRoomAlias`(`roomAlias`: kotlin.String) : ResolvedRoomAlias {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_resolve_room_alias(
                thisPtr,
                FfiConverterString.lower(`roomAlias`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeResolvedRoomAlias.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Restores the client from a `Session`.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `restoreSession`(`session`: Session) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_restore_session(
                thisPtr,
                FfiConverterTypeSession.lower(`session`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    override fun `roomDirectorySearch`(): RoomDirectorySearch {
            return FfiConverterTypeRoomDirectorySearch.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_room_directory_search(
        it, _status)
}
    }
    )
    }
    

    override fun `rooms`(): List<Room> {
            return FfiConverterSequenceTypeRoom.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_rooms(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `searchUsers`(`searchTerm`: kotlin.String, `limit`: kotlin.ULong) : SearchUsersResults {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_search_users(
                thisPtr,
                FfiConverterString.lower(`searchTerm`),FfiConverterULong.lower(`limit`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeSearchUsersResults.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)override fun `session`(): Session {
            return FfiConverterTypeSession.lift(
    callWithPointer {
    uniffiRustCallWithError(ClientException) { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_session(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * Set the given account data content for the given event type.
     *
     * It should be supplied as a JSON string.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setAccountData`(`eventType`: kotlin.String, `content`: kotlin.String) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_set_account_data(
                thisPtr,
                FfiConverterString.lower(`eventType`),FfiConverterString.lower(`content`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    override fun `setDelegate`(`delegate`: ClientDelegate?): TaskHandle? {
            return FfiConverterOptionalTypeTaskHandle.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_set_delegate(
        it, FfiConverterOptionalTypeClientDelegate.lower(`delegate`),_status)
}
    }
    )
    }
    

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setDisplayName`(`name`: kotlin.String) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_set_display_name(
                thisPtr,
                FfiConverterString.lower(`name`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Registers a pusher with given parameters
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setPusher`(`identifiers`: PusherIdentifiers, `kind`: PusherKind, `appDisplayName`: kotlin.String, `deviceDisplayName`: kotlin.String, `profileTag`: kotlin.String?, `lang`: kotlin.String) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_set_pusher(
                thisPtr,
                FfiConverterTypePusherIdentifiers.lower(`identifiers`),FfiConverterTypePusherKind.lower(`kind`),FfiConverterString.lower(`appDisplayName`),FfiConverterString.lower(`deviceDisplayName`),FfiConverterOptionalString.lower(`profileTag`),FfiConverterString.lower(`lang`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    override fun `subscribeToIgnoredUsers`(`listener`: IgnoredUsersListener): TaskHandle {
            return FfiConverterTypeTaskHandle.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_subscribe_to_ignored_users(
        it, FfiConverterTypeIgnoredUsersListener.lower(`listener`),_status)
}
    }
    )
    }
    

    
    /**
     * Subscribe to the global enablement status of the send queue, at the
     * client-wide level.
     *
     * The given listener will be immediately called with the initial value of
     * the enablement status.
     */override fun `subscribeToSendQueueStatus`(`listener`: SendQueueRoomErrorListener): TaskHandle {
            return FfiConverterTypeTaskHandle.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_subscribe_to_send_queue_status(
        it, FfiConverterTypeSendQueueRoomErrorListener.lower(`listener`),_status)
}
    }
    )
    }
    

    override fun `syncService`(): SyncServiceBuilder {
            return FfiConverterTypeSyncServiceBuilder.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_sync_service(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `trackRecentlyVisitedRoom`(`room`: kotlin.String) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_track_recently_visited_room(
                thisPtr,
                FfiConverterString.lower(`room`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `unignoreUser`(`userId`: kotlin.String) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_unignore_user(
                thisPtr,
                FfiConverterString.lower(`userId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `uploadAvatar`(`mimeType`: kotlin.String, `data`: kotlin.ByteArray) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_upload_avatar(
                thisPtr,
                FfiConverterString.lower(`mimeType`),FfiConverterByteArray.lower(`data`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `uploadMedia`(`mimeType`: kotlin.String, `data`: kotlin.ByteArray, `progressWatcher`: ProgressWatcher?) : kotlin.String {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_upload_media(
                thisPtr,
                FfiConverterString.lower(`mimeType`),FfiConverterByteArray.lower(`data`),FfiConverterOptionalTypeProgressWatcher.lower(`progressWatcher`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterString.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)override fun `userId`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(ClientException) { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_client_user_id(
        it, _status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeClient: FfiConverter<Client, Pointer> {

    override fun lower(value: Client): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Client {
        return Client(value)
    }

    override fun read(buf: ByteBuffer): Client {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Client) = 8UL

    override fun write(value: Client, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface ClientBuilderInterface {
    
    fun `addRootCertificates`(`certificates`: List<kotlin.ByteArray>): ClientBuilder
    
    /**
     * Automatically create a backup version if no backup exists.
     */
    fun `autoEnableBackups`(`autoEnableBackups`: kotlin.Boolean): ClientBuilder
    
    fun `autoEnableCrossSigning`(`autoEnableCrossSigning`: kotlin.Boolean): ClientBuilder
    
    /**
     * Select a strategy to download room keys from the backup. By default
     * we download after a decryption failure.
     *
     * Take a look at the [`BackupDownloadStrategy`] enum for more options.
     */
    fun `backupDownloadStrategy`(`backupDownloadStrategy`: BackupDownloadStrategy): ClientBuilder
    
    suspend fun `build`(): Client
    
    /**
     * Finish the building of the client and attempt to log in using the
     * provided [`QrCodeData`].
     *
     * This method will build the client and immediately attempt to log the
     * client in using the provided [`QrCodeData`] using the login
     * mechanism described in [MSC4108]. As such this methods requires OIDC
     * support as well as sliding sync support.
     *
     * The usage of the progress_listener is required to transfer the
     * [`CheckCode`] to the existing client.
     *
     * [MSC4108]: https://github.com/matrix-org/matrix-spec-proposals/pull/4108
     */
    suspend fun `buildWithQrCode`(`qrCodeData`: QrCodeData, `oidcConfiguration`: OidcConfiguration, `progressListener`: QrLoginProgressListener): Client
    
    fun `disableAutomaticTokenRefresh`(): ClientBuilder
    
    fun `disableSslVerification`(): ClientBuilder
    
    fun `enableCrossProcessRefreshLock`(`processId`: kotlin.String, `sessionDelegate`: ClientSessionDelegate): ClientBuilder
    
    fun `homeserverUrl`(`url`: kotlin.String): ClientBuilder
    
    fun `passphrase`(`passphrase`: kotlin.String?): ClientBuilder
    
    fun `proxy`(`url`: kotlin.String): ClientBuilder
    
    fun `serverName`(`serverName`: kotlin.String): ClientBuilder
    
    fun `serverNameOrHomeserverUrl`(`serverNameOrUrl`: kotlin.String): ClientBuilder
    
    fun `serverVersions`(`versions`: List<kotlin.String>): ClientBuilder
    
    /**
     * Sets the path that the client will use to store its data once logged in.
     * This path **must** be unique per session as the data stores aren't
     * capable of handling multiple users.
     *
     * Leaving this unset tells the client to use an in-memory data store.
     */
    fun `sessionPath`(`path`: kotlin.String): ClientBuilder
    
    fun `setSessionDelegate`(`sessionDelegate`: ClientSessionDelegate): ClientBuilder
    
    fun `slidingSyncProxy`(`slidingSyncProxy`: kotlin.String?): ClientBuilder
    
    fun `userAgent`(`userAgent`: kotlin.String): ClientBuilder
    
    fun `username`(`username`: kotlin.String): ClientBuilder
    
    companion object
}

open class ClientBuilder: Disposable, AutoCloseable, ClientBuilderInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor() :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_constructor_clientbuilder_new(
        _status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_clientbuilder(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_clientbuilder(pointer!!, status)
        }
    }

    override fun `addRootCertificates`(`certificates`: List<kotlin.ByteArray>): ClientBuilder {
            return FfiConverterTypeClientBuilder.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_add_root_certificates(
        it, FfiConverterSequenceByteArray.lower(`certificates`),_status)
}
    }
    )
    }
    

    
    /**
     * Automatically create a backup version if no backup exists.
     */override fun `autoEnableBackups`(`autoEnableBackups`: kotlin.Boolean): ClientBuilder {
            return FfiConverterTypeClientBuilder.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_auto_enable_backups(
        it, FfiConverterBoolean.lower(`autoEnableBackups`),_status)
}
    }
    )
    }
    

    override fun `autoEnableCrossSigning`(`autoEnableCrossSigning`: kotlin.Boolean): ClientBuilder {
            return FfiConverterTypeClientBuilder.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_auto_enable_cross_signing(
        it, FfiConverterBoolean.lower(`autoEnableCrossSigning`),_status)
}
    }
    )
    }
    

    
    /**
     * Select a strategy to download room keys from the backup. By default
     * we download after a decryption failure.
     *
     * Take a look at the [`BackupDownloadStrategy`] enum for more options.
     */override fun `backupDownloadStrategy`(`backupDownloadStrategy`: BackupDownloadStrategy): ClientBuilder {
            return FfiConverterTypeClientBuilder.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_backup_download_strategy(
        it, FfiConverterTypeBackupDownloadStrategy.lower(`backupDownloadStrategy`),_status)
}
    }
    )
    }
    

    
    @Throws(ClientBuildException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `build`() : Client {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_build(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeClient.lift(it) },
        // Error FFI converter
        ClientBuildException.ErrorHandler,
    )
    }

    
    /**
     * Finish the building of the client and attempt to log in using the
     * provided [`QrCodeData`].
     *
     * This method will build the client and immediately attempt to log the
     * client in using the provided [`QrCodeData`] using the login
     * mechanism described in [MSC4108]. As such this methods requires OIDC
     * support as well as sliding sync support.
     *
     * The usage of the progress_listener is required to transfer the
     * [`CheckCode`] to the existing client.
     *
     * [MSC4108]: https://github.com/matrix-org/matrix-spec-proposals/pull/4108
     */
    @Throws(HumanQrLoginException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `buildWithQrCode`(`qrCodeData`: QrCodeData, `oidcConfiguration`: OidcConfiguration, `progressListener`: QrLoginProgressListener) : Client {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_build_with_qr_code(
                thisPtr,
                FfiConverterTypeQrCodeData.lower(`qrCodeData`),FfiConverterTypeOidcConfiguration.lower(`oidcConfiguration`),FfiConverterTypeQrLoginProgressListener.lower(`progressListener`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeClient.lift(it) },
        // Error FFI converter
        HumanQrLoginException.ErrorHandler,
    )
    }

    override fun `disableAutomaticTokenRefresh`(): ClientBuilder {
            return FfiConverterTypeClientBuilder.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_disable_automatic_token_refresh(
        it, _status)
}
    }
    )
    }
    

    override fun `disableSslVerification`(): ClientBuilder {
            return FfiConverterTypeClientBuilder.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_disable_ssl_verification(
        it, _status)
}
    }
    )
    }
    

    override fun `enableCrossProcessRefreshLock`(`processId`: kotlin.String, `sessionDelegate`: ClientSessionDelegate): ClientBuilder {
            return FfiConverterTypeClientBuilder.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_enable_cross_process_refresh_lock(
        it, FfiConverterString.lower(`processId`),FfiConverterTypeClientSessionDelegate.lower(`sessionDelegate`),_status)
}
    }
    )
    }
    

    override fun `homeserverUrl`(`url`: kotlin.String): ClientBuilder {
            return FfiConverterTypeClientBuilder.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_homeserver_url(
        it, FfiConverterString.lower(`url`),_status)
}
    }
    )
    }
    

    override fun `passphrase`(`passphrase`: kotlin.String?): ClientBuilder {
            return FfiConverterTypeClientBuilder.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_passphrase(
        it, FfiConverterOptionalString.lower(`passphrase`),_status)
}
    }
    )
    }
    

    override fun `proxy`(`url`: kotlin.String): ClientBuilder {
            return FfiConverterTypeClientBuilder.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_proxy(
        it, FfiConverterString.lower(`url`),_status)
}
    }
    )
    }
    

    override fun `serverName`(`serverName`: kotlin.String): ClientBuilder {
            return FfiConverterTypeClientBuilder.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_server_name(
        it, FfiConverterString.lower(`serverName`),_status)
}
    }
    )
    }
    

    override fun `serverNameOrHomeserverUrl`(`serverNameOrUrl`: kotlin.String): ClientBuilder {
            return FfiConverterTypeClientBuilder.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_server_name_or_homeserver_url(
        it, FfiConverterString.lower(`serverNameOrUrl`),_status)
}
    }
    )
    }
    

    override fun `serverVersions`(`versions`: List<kotlin.String>): ClientBuilder {
            return FfiConverterTypeClientBuilder.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_server_versions(
        it, FfiConverterSequenceString.lower(`versions`),_status)
}
    }
    )
    }
    

    
    /**
     * Sets the path that the client will use to store its data once logged in.
     * This path **must** be unique per session as the data stores aren't
     * capable of handling multiple users.
     *
     * Leaving this unset tells the client to use an in-memory data store.
     */override fun `sessionPath`(`path`: kotlin.String): ClientBuilder {
            return FfiConverterTypeClientBuilder.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_session_path(
        it, FfiConverterString.lower(`path`),_status)
}
    }
    )
    }
    

    override fun `setSessionDelegate`(`sessionDelegate`: ClientSessionDelegate): ClientBuilder {
            return FfiConverterTypeClientBuilder.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_set_session_delegate(
        it, FfiConverterTypeClientSessionDelegate.lower(`sessionDelegate`),_status)
}
    }
    )
    }
    

    override fun `slidingSyncProxy`(`slidingSyncProxy`: kotlin.String?): ClientBuilder {
            return FfiConverterTypeClientBuilder.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_sliding_sync_proxy(
        it, FfiConverterOptionalString.lower(`slidingSyncProxy`),_status)
}
    }
    )
    }
    

    override fun `userAgent`(`userAgent`: kotlin.String): ClientBuilder {
            return FfiConverterTypeClientBuilder.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_user_agent(
        it, FfiConverterString.lower(`userAgent`),_status)
}
    }
    )
    }
    

    override fun `username`(`username`: kotlin.String): ClientBuilder {
            return FfiConverterTypeClientBuilder.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_clientbuilder_username(
        it, FfiConverterString.lower(`username`),_status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeClientBuilder: FfiConverter<ClientBuilder, Pointer> {

    override fun lower(value: ClientBuilder): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): ClientBuilder {
        return ClientBuilder(value)
    }

    override fun read(buf: ByteBuffer): ClientBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: ClientBuilder) = 8UL

    override fun write(value: ClientBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface EncryptionInterface {
    
    /**
     * Does a backup exist on the server?
     *
     * Because the homeserver doesn't notify us about changes to the backup
     * version, the [`BackupState`] and its listener are a bit crippled.
     * The `BackupState::Unknown` state might mean there is no backup at all or
     * a backup exists but we don't have access to it.
     *
     * Therefore it is necessary to poll the server for an answer every time
     * you want to differentiate between those two states.
     */
    suspend fun `backupExistsOnServer`(): kotlin.Boolean
    
    fun `backupState`(): BackupState
    
    fun `backupStateListener`(`listener`: BackupStateListener): TaskHandle
    
    /**
     * Get the public curve25519 key of our own device in base64. This is
     * usually what is called the identity key of the device.
     */
    suspend fun `curve25519Key`(): kotlin.String?
    
    suspend fun `disableRecovery`()
    
    /**
     * Get the public ed25519 key of our own device. This is usually what is
     * called the fingerprint of the device.
     */
    suspend fun `ed25519Key`(): kotlin.String?
    
    suspend fun `enableBackups`()
    
    suspend fun `enableRecovery`(`waitForBackupsToUpload`: kotlin.Boolean, `progressListener`: EnableRecoveryProgressListener): kotlin.String
    
    suspend fun `isLastDevice`(): kotlin.Boolean
    
    suspend fun `recover`(`recoveryKey`: kotlin.String)
    
    suspend fun `recoverAndReset`(`oldRecoveryKey`: kotlin.String): kotlin.String
    
    fun `recoveryState`(): RecoveryState
    
    fun `recoveryStateListener`(`listener`: RecoveryStateListener): TaskHandle
    
    suspend fun `resetRecoveryKey`(): kotlin.String
    
    fun `verificationState`(): VerificationState
    
    fun `verificationStateListener`(`listener`: VerificationStateListener): TaskHandle
    
    suspend fun `waitForBackupUploadSteadyState`(`progressListener`: BackupSteadyStateListener?)
    
    /**
     * Waits for end-to-end encryption initialization tasks to finish, if any
     * was running in the background.
     */
    suspend fun `waitForE2eeInitializationTasks`()
    
    companion object
}

open class Encryption: Disposable, AutoCloseable, EncryptionInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_encryption(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_encryption(pointer!!, status)
        }
    }

    
    /**
     * Does a backup exist on the server?
     *
     * Because the homeserver doesn't notify us about changes to the backup
     * version, the [`BackupState`] and its listener are a bit crippled.
     * The `BackupState::Unknown` state might mean there is no backup at all or
     * a backup exists but we don't have access to it.
     *
     * Therefore it is necessary to poll the server for an answer every time
     * you want to differentiate between those two states.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `backupExistsOnServer`() : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_backup_exists_on_server(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    override fun `backupState`(): BackupState {
            return FfiConverterTypeBackupState.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_backup_state(
        it, _status)
}
    }
    )
    }
    

    override fun `backupStateListener`(`listener`: BackupStateListener): TaskHandle {
            return FfiConverterTypeTaskHandle.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_backup_state_listener(
        it, FfiConverterTypeBackupStateListener.lower(`listener`),_status)
}
    }
    )
    }
    

    
    /**
     * Get the public curve25519 key of our own device in base64. This is
     * usually what is called the identity key of the device.
     */
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `curve25519Key`() : kotlin.String? {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_curve25519_key(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterOptionalString.lift(it) },
        // Error FFI converter
        UniffiNullRustCallStatusErrorHandler,
    )
    }

    
    @Throws(RecoveryException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `disableRecovery`() {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_disable_recovery(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        RecoveryException.ErrorHandler,
    )
    }

    
    /**
     * Get the public ed25519 key of our own device. This is usually what is
     * called the fingerprint of the device.
     */
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `ed25519Key`() : kotlin.String? {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_ed25519_key(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterOptionalString.lift(it) },
        // Error FFI converter
        UniffiNullRustCallStatusErrorHandler,
    )
    }

    
    @Throws(RecoveryException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `enableBackups`() {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_enable_backups(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        RecoveryException.ErrorHandler,
    )
    }

    
    @Throws(RecoveryException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `enableRecovery`(`waitForBackupsToUpload`: kotlin.Boolean, `progressListener`: EnableRecoveryProgressListener) : kotlin.String {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_enable_recovery(
                thisPtr,
                FfiConverterBoolean.lower(`waitForBackupsToUpload`),FfiConverterTypeEnableRecoveryProgressListener.lower(`progressListener`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterString.lift(it) },
        // Error FFI converter
        RecoveryException.ErrorHandler,
    )
    }

    
    @Throws(RecoveryException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `isLastDevice`() : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_is_last_device(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        RecoveryException.ErrorHandler,
    )
    }

    
    @Throws(RecoveryException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `recover`(`recoveryKey`: kotlin.String) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_recover(
                thisPtr,
                FfiConverterString.lower(`recoveryKey`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        RecoveryException.ErrorHandler,
    )
    }

    
    @Throws(RecoveryException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `recoverAndReset`(`oldRecoveryKey`: kotlin.String) : kotlin.String {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_recover_and_reset(
                thisPtr,
                FfiConverterString.lower(`oldRecoveryKey`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterString.lift(it) },
        // Error FFI converter
        RecoveryException.ErrorHandler,
    )
    }

    override fun `recoveryState`(): RecoveryState {
            return FfiConverterTypeRecoveryState.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_recovery_state(
        it, _status)
}
    }
    )
    }
    

    override fun `recoveryStateListener`(`listener`: RecoveryStateListener): TaskHandle {
            return FfiConverterTypeTaskHandle.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_recovery_state_listener(
        it, FfiConverterTypeRecoveryStateListener.lower(`listener`),_status)
}
    }
    )
    }
    

    
    @Throws(RecoveryException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `resetRecoveryKey`() : kotlin.String {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_reset_recovery_key(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterString.lift(it) },
        // Error FFI converter
        RecoveryException.ErrorHandler,
    )
    }

    override fun `verificationState`(): VerificationState {
            return FfiConverterTypeVerificationState.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_verification_state(
        it, _status)
}
    }
    )
    }
    

    override fun `verificationStateListener`(`listener`: VerificationStateListener): TaskHandle {
            return FfiConverterTypeTaskHandle.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_verification_state_listener(
        it, FfiConverterTypeVerificationStateListener.lower(`listener`),_status)
}
    }
    )
    }
    

    
    @Throws(SteadyStateException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `waitForBackupUploadSteadyState`(`progressListener`: BackupSteadyStateListener?) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_wait_for_backup_upload_steady_state(
                thisPtr,
                FfiConverterOptionalTypeBackupSteadyStateListener.lower(`progressListener`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        SteadyStateException.ErrorHandler,
    )
    }

    
    /**
     * Waits for end-to-end encryption initialization tasks to finish, if any
     * was running in the background.
     */
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `waitForE2eeInitializationTasks`() {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_encryption_wait_for_e2ee_initialization_tasks(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        UniffiNullRustCallStatusErrorHandler,
    )
    }

    

    
    
    companion object
    
}

public object FfiConverterTypeEncryption: FfiConverter<Encryption, Pointer> {

    override fun lower(value: Encryption): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Encryption {
        return Encryption(value)
    }

    override fun read(buf: ByteBuffer): Encryption {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Encryption) = 8UL

    override fun write(value: Encryption, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface EventTimelineItemInterface {
    
    fun `canBeRepliedTo`(): kotlin.Boolean
    
    fun `content`(): TimelineItemContent
    
    fun `debugInfo`(): EventTimelineItemDebugInfo
    
    fun `eventId`(): kotlin.String?
    
    fun `isEditable`(): kotlin.Boolean
    
    fun `isLocal`(): kotlin.Boolean
    
    fun `isOwn`(): kotlin.Boolean
    
    fun `isRemote`(): kotlin.Boolean
    
    fun `localSendState`(): EventSendState?
    
    fun `origin`(): EventItemOrigin?
    
    fun `reactions`(): List<Reaction>
    
    fun `readReceipts`(): Map<kotlin.String, Receipt>
    
    fun `sender`(): kotlin.String
    
    fun `senderProfile`(): ProfileDetails
    
    fun `timestamp`(): kotlin.ULong
    
    fun `transactionId`(): kotlin.String?
    
    companion object
}

open class EventTimelineItem: Disposable, AutoCloseable, EventTimelineItemInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_eventtimelineitem(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_eventtimelineitem(pointer!!, status)
        }
    }

    override fun `canBeRepliedTo`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_can_be_replied_to(
        it, _status)
}
    }
    )
    }
    

    override fun `content`(): TimelineItemContent {
            return FfiConverterTypeTimelineItemContent.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_content(
        it, _status)
}
    }
    )
    }
    

    override fun `debugInfo`(): EventTimelineItemDebugInfo {
            return FfiConverterTypeEventTimelineItemDebugInfo.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_debug_info(
        it, _status)
}
    }
    )
    }
    

    override fun `eventId`(): kotlin.String? {
            return FfiConverterOptionalString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_event_id(
        it, _status)
}
    }
    )
    }
    

    override fun `isEditable`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_editable(
        it, _status)
}
    }
    )
    }
    

    override fun `isLocal`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_local(
        it, _status)
}
    }
    )
    }
    

    override fun `isOwn`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_own(
        it, _status)
}
    }
    )
    }
    

    override fun `isRemote`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_is_remote(
        it, _status)
}
    }
    )
    }
    

    override fun `localSendState`(): EventSendState? {
            return FfiConverterOptionalTypeEventSendState.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_local_send_state(
        it, _status)
}
    }
    )
    }
    

    override fun `origin`(): EventItemOrigin? {
            return FfiConverterOptionalTypeEventItemOrigin.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_origin(
        it, _status)
}
    }
    )
    }
    

    override fun `reactions`(): List<Reaction> {
            return FfiConverterSequenceTypeReaction.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_reactions(
        it, _status)
}
    }
    )
    }
    

    override fun `readReceipts`(): Map<kotlin.String, Receipt> {
            return FfiConverterMapStringTypeReceipt.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_read_receipts(
        it, _status)
}
    }
    )
    }
    

    override fun `sender`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_sender(
        it, _status)
}
    }
    )
    }
    

    override fun `senderProfile`(): ProfileDetails {
            return FfiConverterTypeProfileDetails.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_sender_profile(
        it, _status)
}
    }
    )
    }
    

    override fun `timestamp`(): kotlin.ULong {
            return FfiConverterULong.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_timestamp(
        it, _status)
}
    }
    )
    }
    

    override fun `transactionId`(): kotlin.String? {
            return FfiConverterOptionalString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_eventtimelineitem_transaction_id(
        it, _status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeEventTimelineItem: FfiConverter<EventTimelineItem, Pointer> {

    override fun lower(value: EventTimelineItem): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): EventTimelineItem {
        return EventTimelineItem(value)
    }

    override fun read(buf: ByteBuffer): EventTimelineItem {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: EventTimelineItem) = 8UL

    override fun write(value: EventTimelineItem, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface HomeserverLoginDetailsInterface {
    
    /**
     * The URL of the discovered or manually set sliding sync proxy,
     * if any.
     */
    fun `slidingSyncProxy`(): kotlin.String?
    
    /**
     * Whether the current homeserver supports login using OIDC.
     */
    fun `supportsOidcLogin`(): kotlin.Boolean
    
    /**
     * Whether the current homeserver supports the password login flow.
     */
    fun `supportsPasswordLogin`(): kotlin.Boolean
    
    /**
     * The URL of the currently configured homeserver.
     */
    fun `url`(): kotlin.String
    
    companion object
}

open class HomeserverLoginDetails: Disposable, AutoCloseable, HomeserverLoginDetailsInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_homeserverlogindetails(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_homeserverlogindetails(pointer!!, status)
        }
    }

    
    /**
     * The URL of the discovered or manually set sliding sync proxy,
     * if any.
     */override fun `slidingSyncProxy`(): kotlin.String? {
            return FfiConverterOptionalString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_homeserverlogindetails_sliding_sync_proxy(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * Whether the current homeserver supports login using OIDC.
     */override fun `supportsOidcLogin`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_homeserverlogindetails_supports_oidc_login(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * Whether the current homeserver supports the password login flow.
     */override fun `supportsPasswordLogin`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_homeserverlogindetails_supports_password_login(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * The URL of the currently configured homeserver.
     */override fun `url`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_homeserverlogindetails_url(
        it, _status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeHomeserverLoginDetails: FfiConverter<HomeserverLoginDetails, Pointer> {

    override fun lower(value: HomeserverLoginDetails): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): HomeserverLoginDetails {
        return HomeserverLoginDetails(value)
    }

    override fun read(buf: ByteBuffer): HomeserverLoginDetails {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: HomeserverLoginDetails) = 8UL

    override fun write(value: HomeserverLoginDetails, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * A file handle that takes ownership of a media file on disk. When the handle
 * is dropped, the file will be removed from the disk.
 */
public interface MediaFileHandleInterface {
    
    /**
     * Get the media file's path.
     */
    fun `path`(): kotlin.String
    
    fun `persist`(`path`: kotlin.String): kotlin.Boolean
    
    companion object
}

/**
 * A file handle that takes ownership of a media file on disk. When the handle
 * is dropped, the file will be removed from the disk.
 */
open class MediaFileHandle: Disposable, AutoCloseable, MediaFileHandleInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_mediafilehandle(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_mediafilehandle(pointer!!, status)
        }
    }

    
    /**
     * Get the media file's path.
     */
    @Throws(ClientException::class)override fun `path`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCallWithError(ClientException) { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_mediafilehandle_path(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(ClientException::class)override fun `persist`(`path`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCallWithError(ClientException) { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_mediafilehandle_persist(
        it, FfiConverterString.lower(`path`),_status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeMediaFileHandle: FfiConverter<MediaFileHandle, Pointer> {

    override fun lower(value: MediaFileHandle): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): MediaFileHandle {
        return MediaFileHandle(value)
    }

    override fun read(buf: ByteBuffer): MediaFileHandle {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: MediaFileHandle) = 8UL

    override fun write(value: MediaFileHandle, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface MediaSourceInterface {
    
    fun `toJson`(): kotlin.String
    
    fun `url`(): kotlin.String
    
    companion object
}

open class MediaSource: Disposable, AutoCloseable, MediaSourceInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_mediasource(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_mediasource(pointer!!, status)
        }
    }

    override fun `toJson`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_mediasource_to_json(
        it, _status)
}
    }
    )
    }
    

    override fun `url`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_mediasource_url(
        it, _status)
}
    }
    )
    }
    

    

    
    companion object {
        
    @Throws(ClientException::class) fun `fromJson`(`json`: kotlin.String): MediaSource {
            return FfiConverterTypeMediaSource.lift(
    uniffiRustCallWithError(ClientException) { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_constructor_mediasource_from_json(
        FfiConverterString.lower(`json`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeMediaSource: FfiConverter<MediaSource, Pointer> {

    override fun lower(value: MediaSource): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): MediaSource {
        return MediaSource(value)
    }

    override fun read(buf: ByteBuffer): MediaSource {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: MediaSource) = 8UL

    override fun write(value: MediaSource, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface MessageInterface {
    
    fun `body`(): kotlin.String
    
    fun `content`(): RoomMessageEventContentWithoutRelation
    
    fun `inReplyTo`(): InReplyToDetails?
    
    fun `isEdited`(): kotlin.Boolean
    
    fun `isThreaded`(): kotlin.Boolean
    
    fun `msgtype`(): MessageType
    
    companion object
}

open class Message: Disposable, AutoCloseable, MessageInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_message(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_message(pointer!!, status)
        }
    }

    override fun `body`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_message_body(
        it, _status)
}
    }
    )
    }
    

    override fun `content`(): RoomMessageEventContentWithoutRelation {
            return FfiConverterTypeRoomMessageEventContentWithoutRelation.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_message_content(
        it, _status)
}
    }
    )
    }
    

    override fun `inReplyTo`(): InReplyToDetails? {
            return FfiConverterOptionalTypeInReplyToDetails.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_message_in_reply_to(
        it, _status)
}
    }
    )
    }
    

    override fun `isEdited`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_message_is_edited(
        it, _status)
}
    }
    )
    }
    

    override fun `isThreaded`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_message_is_threaded(
        it, _status)
}
    }
    )
    }
    

    override fun `msgtype`(): MessageType {
            return FfiConverterTypeMessageType.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_message_msgtype(
        it, _status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeMessage: FfiConverter<Message, Pointer> {

    override fun lower(value: Message): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Message {
        return Message(value)
    }

    override fun read(buf: ByteBuffer): Message {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Message) = 8UL

    override fun write(value: Message, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface NotificationClientInterface {
    
    /**
     * See also documentation of
     * `MatrixNotificationClient::get_notification`.
     */
    suspend fun `getNotification`(`roomId`: kotlin.String, `eventId`: kotlin.String): NotificationItem?
    
    companion object
}

open class NotificationClient: Disposable, AutoCloseable, NotificationClientInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_notificationclient(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_notificationclient(pointer!!, status)
        }
    }

    
    /**
     * See also documentation of
     * `MatrixNotificationClient::get_notification`.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getNotification`(`roomId`: kotlin.String, `eventId`: kotlin.String) : NotificationItem? {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationclient_get_notification(
                thisPtr,
                FfiConverterString.lower(`roomId`),FfiConverterString.lower(`eventId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterOptionalTypeNotificationItem.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

public object FfiConverterTypeNotificationClient: FfiConverter<NotificationClient, Pointer> {

    override fun lower(value: NotificationClient): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): NotificationClient {
        return NotificationClient(value)
    }

    override fun read(buf: ByteBuffer): NotificationClient {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: NotificationClient) = 8UL

    override fun write(value: NotificationClient, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface NotificationSettingsInterface {
    
    /**
     * Check whether [MSC 4028 push rule][rule] is enabled on the homeserver.
     *
     * [rule]: https://github.com/matrix-org/matrix-spec-proposals/blob/giomfo/push_encrypted_events/proposals/4028-push-all-encrypted-events-except-for-muted-rooms.md
     */
    suspend fun `canHomeserverPushEncryptedEventToDevice`(): kotlin.Boolean
    
    /**
     * Returns true if [MSC 4028 push rule][rule] is supported and enabled.
     *
     * [rule]: https://github.com/matrix-org/matrix-spec-proposals/blob/giomfo/push_encrypted_events/proposals/4028-push-all-encrypted-events-except-for-muted-rooms.md
     */
    suspend fun `canPushEncryptedEventToDevice`(): kotlin.Boolean
    
    /**
     * Get whether some enabled keyword rules exist.
     */
    suspend fun `containsKeywordsRules`(): kotlin.Boolean
    
    /**
     * Get the default room notification mode
     *
     * The mode will depend on the associated `PushRule` based on whether the
     * room is encrypted or not, and on the number of members.
     *
     * # Arguments
     *
     * * `is_encrypted` - whether the room is encrypted
     * * `is_one_to_one` - whether the room is a direct chats involving two
     * people
     */
    suspend fun `getDefaultRoomNotificationMode`(`isEncrypted`: kotlin.Boolean, `isOneToOne`: kotlin.Boolean): RoomNotificationMode
    
    /**
     * Get the notification settings for a room.
     *
     * # Arguments
     *
     * * `room_id` - the room ID
     * * `is_encrypted` - whether the room is encrypted
     * * `is_one_to_one` - whether the room is a direct chat involving two
     * people
     */
    suspend fun `getRoomNotificationSettings`(`roomId`: kotlin.String, `isEncrypted`: kotlin.Boolean, `isOneToOne`: kotlin.Boolean): RoomNotificationSettings
    
    /**
     * Get all room IDs for which a user-defined rule exists.
     */
    suspend fun `getRoomsWithUserDefinedRules`(`enabled`: kotlin.Boolean?): List<kotlin.String>
    
    /**
     * Get the user defined room notification mode
     */
    suspend fun `getUserDefinedRoomNotificationMode`(`roomId`: kotlin.String): RoomNotificationMode?
    
    /**
     * Get whether the `.m.rule.call` push rule is enabled
     */
    suspend fun `isCallEnabled`(): kotlin.Boolean
    
    /**
     * Get whether the `.m.rule.invite_for_me` push rule is enabled
     */
    suspend fun `isInviteForMeEnabled`(): kotlin.Boolean
    
    /**
     * Get whether room mentions are enabled.
     */
    suspend fun `isRoomMentionEnabled`(): kotlin.Boolean
    
    /**
     * Get whether user mentions are enabled.
     */
    suspend fun `isUserMentionEnabled`(): kotlin.Boolean
    
    /**
     * Restore the default notification mode for a room
     */
    suspend fun `restoreDefaultRoomNotificationMode`(`roomId`: kotlin.String)
    
    /**
     * Set whether the `.m.rule.call` push rule is enabled
     */
    suspend fun `setCallEnabled`(`enabled`: kotlin.Boolean)
    
    /**
     * Set the default room notification mode
     *
     * # Arguments
     *
     * * `is_encrypted` - whether the mode is for encrypted rooms
     * * `is_one_to_one` - whether the mode is for direct chats involving two
     * people
     * * `mode` - the new default mode
     */
    suspend fun `setDefaultRoomNotificationMode`(`isEncrypted`: kotlin.Boolean, `isOneToOne`: kotlin.Boolean, `mode`: RoomNotificationMode)
    
    fun `setDelegate`(`delegate`: NotificationSettingsDelegate?)
    
    /**
     * Set whether the `.m.rule.invite_for_me` push rule is enabled
     */
    suspend fun `setInviteForMeEnabled`(`enabled`: kotlin.Boolean)
    
    /**
     * Set whether room mentions are enabled.
     */
    suspend fun `setRoomMentionEnabled`(`enabled`: kotlin.Boolean)
    
    /**
     * Set the notification mode for a room.
     */
    suspend fun `setRoomNotificationMode`(`roomId`: kotlin.String, `mode`: RoomNotificationMode)
    
    /**
     * Set whether user mentions are enabled.
     */
    suspend fun `setUserMentionEnabled`(`enabled`: kotlin.Boolean)
    
    /**
     * Unmute a room.
     *
     * # Arguments
     *
     * * `room_id` - the room to unmute
     * * `is_encrypted` - whether the room is encrypted
     * * `is_one_to_one` - whether the room is a direct chat involving two
     * people
     */
    suspend fun `unmuteRoom`(`roomId`: kotlin.String, `isEncrypted`: kotlin.Boolean, `isOneToOne`: kotlin.Boolean)
    
    companion object
}

open class NotificationSettings: Disposable, AutoCloseable, NotificationSettingsInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_notificationsettings(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_notificationsettings(pointer!!, status)
        }
    }

    
    /**
     * Check whether [MSC 4028 push rule][rule] is enabled on the homeserver.
     *
     * [rule]: https://github.com/matrix-org/matrix-spec-proposals/blob/giomfo/push_encrypted_events/proposals/4028-push-all-encrypted-events-except-for-muted-rooms.md
     */
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canHomeserverPushEncryptedEventToDevice`() : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_can_homeserver_push_encrypted_event_to_device(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        UniffiNullRustCallStatusErrorHandler,
    )
    }

    
    /**
     * Returns true if [MSC 4028 push rule][rule] is supported and enabled.
     *
     * [rule]: https://github.com/matrix-org/matrix-spec-proposals/blob/giomfo/push_encrypted_events/proposals/4028-push-all-encrypted-events-except-for-muted-rooms.md
     */
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canPushEncryptedEventToDevice`() : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_can_push_encrypted_event_to_device(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        UniffiNullRustCallStatusErrorHandler,
    )
    }

    
    /**
     * Get whether some enabled keyword rules exist.
     */
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `containsKeywordsRules`() : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_contains_keywords_rules(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        UniffiNullRustCallStatusErrorHandler,
    )
    }

    
    /**
     * Get the default room notification mode
     *
     * The mode will depend on the associated `PushRule` based on whether the
     * room is encrypted or not, and on the number of members.
     *
     * # Arguments
     *
     * * `is_encrypted` - whether the room is encrypted
     * * `is_one_to_one` - whether the room is a direct chats involving two
     * people
     */
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getDefaultRoomNotificationMode`(`isEncrypted`: kotlin.Boolean, `isOneToOne`: kotlin.Boolean) : RoomNotificationMode {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_get_default_room_notification_mode(
                thisPtr,
                FfiConverterBoolean.lower(`isEncrypted`),FfiConverterBoolean.lower(`isOneToOne`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeRoomNotificationMode.lift(it) },
        // Error FFI converter
        UniffiNullRustCallStatusErrorHandler,
    )
    }

    
    /**
     * Get the notification settings for a room.
     *
     * # Arguments
     *
     * * `room_id` - the room ID
     * * `is_encrypted` - whether the room is encrypted
     * * `is_one_to_one` - whether the room is a direct chat involving two
     * people
     */
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getRoomNotificationSettings`(`roomId`: kotlin.String, `isEncrypted`: kotlin.Boolean, `isOneToOne`: kotlin.Boolean) : RoomNotificationSettings {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_get_room_notification_settings(
                thisPtr,
                FfiConverterString.lower(`roomId`),FfiConverterBoolean.lower(`isEncrypted`),FfiConverterBoolean.lower(`isOneToOne`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeRoomNotificationSettings.lift(it) },
        // Error FFI converter
        NotificationSettingsException.ErrorHandler,
    )
    }

    
    /**
     * Get all room IDs for which a user-defined rule exists.
     */
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getRoomsWithUserDefinedRules`(`enabled`: kotlin.Boolean?) : List<kotlin.String> {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_get_rooms_with_user_defined_rules(
                thisPtr,
                FfiConverterOptionalBoolean.lower(`enabled`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterSequenceString.lift(it) },
        // Error FFI converter
        UniffiNullRustCallStatusErrorHandler,
    )
    }

    
    /**
     * Get the user defined room notification mode
     */
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getUserDefinedRoomNotificationMode`(`roomId`: kotlin.String) : RoomNotificationMode? {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_get_user_defined_room_notification_mode(
                thisPtr,
                FfiConverterString.lower(`roomId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterOptionalTypeRoomNotificationMode.lift(it) },
        // Error FFI converter
        NotificationSettingsException.ErrorHandler,
    )
    }

    
    /**
     * Get whether the `.m.rule.call` push rule is enabled
     */
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `isCallEnabled`() : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_call_enabled(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        NotificationSettingsException.ErrorHandler,
    )
    }

    
    /**
     * Get whether the `.m.rule.invite_for_me` push rule is enabled
     */
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `isInviteForMeEnabled`() : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_invite_for_me_enabled(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        NotificationSettingsException.ErrorHandler,
    )
    }

    
    /**
     * Get whether room mentions are enabled.
     */
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `isRoomMentionEnabled`() : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_room_mention_enabled(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        NotificationSettingsException.ErrorHandler,
    )
    }

    
    /**
     * Get whether user mentions are enabled.
     */
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `isUserMentionEnabled`() : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_is_user_mention_enabled(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        NotificationSettingsException.ErrorHandler,
    )
    }

    
    /**
     * Restore the default notification mode for a room
     */
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `restoreDefaultRoomNotificationMode`(`roomId`: kotlin.String) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_restore_default_room_notification_mode(
                thisPtr,
                FfiConverterString.lower(`roomId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        NotificationSettingsException.ErrorHandler,
    )
    }

    
    /**
     * Set whether the `.m.rule.call` push rule is enabled
     */
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setCallEnabled`(`enabled`: kotlin.Boolean) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_call_enabled(
                thisPtr,
                FfiConverterBoolean.lower(`enabled`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        NotificationSettingsException.ErrorHandler,
    )
    }

    
    /**
     * Set the default room notification mode
     *
     * # Arguments
     *
     * * `is_encrypted` - whether the mode is for encrypted rooms
     * * `is_one_to_one` - whether the mode is for direct chats involving two
     * people
     * * `mode` - the new default mode
     */
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setDefaultRoomNotificationMode`(`isEncrypted`: kotlin.Boolean, `isOneToOne`: kotlin.Boolean, `mode`: RoomNotificationMode) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_default_room_notification_mode(
                thisPtr,
                FfiConverterBoolean.lower(`isEncrypted`),FfiConverterBoolean.lower(`isOneToOne`),FfiConverterTypeRoomNotificationMode.lower(`mode`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        NotificationSettingsException.ErrorHandler,
    )
    }

    override fun `setDelegate`(`delegate`: NotificationSettingsDelegate?)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_delegate(
        it, FfiConverterOptionalTypeNotificationSettingsDelegate.lower(`delegate`),_status)
}
    }
    
    

    
    /**
     * Set whether the `.m.rule.invite_for_me` push rule is enabled
     */
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setInviteForMeEnabled`(`enabled`: kotlin.Boolean) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_invite_for_me_enabled(
                thisPtr,
                FfiConverterBoolean.lower(`enabled`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        NotificationSettingsException.ErrorHandler,
    )
    }

    
    /**
     * Set whether room mentions are enabled.
     */
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setRoomMentionEnabled`(`enabled`: kotlin.Boolean) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_room_mention_enabled(
                thisPtr,
                FfiConverterBoolean.lower(`enabled`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        NotificationSettingsException.ErrorHandler,
    )
    }

    
    /**
     * Set the notification mode for a room.
     */
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setRoomNotificationMode`(`roomId`: kotlin.String, `mode`: RoomNotificationMode) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_room_notification_mode(
                thisPtr,
                FfiConverterString.lower(`roomId`),FfiConverterTypeRoomNotificationMode.lower(`mode`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        NotificationSettingsException.ErrorHandler,
    )
    }

    
    /**
     * Set whether user mentions are enabled.
     */
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setUserMentionEnabled`(`enabled`: kotlin.Boolean) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_set_user_mention_enabled(
                thisPtr,
                FfiConverterBoolean.lower(`enabled`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        NotificationSettingsException.ErrorHandler,
    )
    }

    
    /**
     * Unmute a room.
     *
     * # Arguments
     *
     * * `room_id` - the room to unmute
     * * `is_encrypted` - whether the room is encrypted
     * * `is_one_to_one` - whether the room is a direct chat involving two
     * people
     */
    @Throws(NotificationSettingsException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `unmuteRoom`(`roomId`: kotlin.String, `isEncrypted`: kotlin.Boolean, `isOneToOne`: kotlin.Boolean) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_notificationsettings_unmute_room(
                thisPtr,
                FfiConverterString.lower(`roomId`),FfiConverterBoolean.lower(`isEncrypted`),FfiConverterBoolean.lower(`isOneToOne`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        NotificationSettingsException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

public object FfiConverterTypeNotificationSettings: FfiConverter<NotificationSettings, Pointer> {

    override fun lower(value: NotificationSettings): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): NotificationSettings {
        return NotificationSettings(value)
    }

    override fun read(buf: ByteBuffer): NotificationSettings {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: NotificationSettings) = 8UL

    override fun write(value: NotificationSettings, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * The data required to authenticate against an OIDC server.
 */
public interface OidcAuthenticationDataInterface {
    
    /**
     * The login URL to use for authentication.
     */
    fun `loginUrl`(): kotlin.String
    
    companion object
}

/**
 * The data required to authenticate against an OIDC server.
 */
open class OidcAuthenticationData: Disposable, AutoCloseable, OidcAuthenticationDataInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_oidcauthenticationdata(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_oidcauthenticationdata(pointer!!, status)
        }
    }

    
    /**
     * The login URL to use for authentication.
     */override fun `loginUrl`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_oidcauthenticationdata_login_url(
        it, _status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeOidcAuthenticationData: FfiConverter<OidcAuthenticationData, Pointer> {

    override fun lower(value: OidcAuthenticationData): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): OidcAuthenticationData {
        return OidcAuthenticationData(value)
    }

    override fun read(buf: ByteBuffer): OidcAuthenticationData {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: OidcAuthenticationData) = 8UL

    override fun write(value: OidcAuthenticationData, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * Data for the QR code login mechanism.
 *
 * The [`QrCodeData`] can be serialized and encoded as a QR code or it can be
 * decoded from a QR code.
 */
public interface QrCodeDataInterface {
    
    companion object
}

/**
 * Data for the QR code login mechanism.
 *
 * The [`QrCodeData`] can be serialized and encoded as a QR code or it can be
 * decoded from a QR code.
 */
open class QrCodeData: Disposable, AutoCloseable, QrCodeDataInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_qrcodedata(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_qrcodedata(pointer!!, status)
        }
    }

    

    
    companion object {
        
    /**
     * Attempt to decode a slice of bytes into a [`QrCodeData`] object.
     *
     * The slice of bytes would generally be returned by a QR code decoder.
     */
    @Throws(QrCodeDecodeException::class) fun `fromBytes`(`bytes`: kotlin.ByteArray): QrCodeData {
            return FfiConverterTypeQrCodeData.lift(
    uniffiRustCallWithError(QrCodeDecodeException) { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_constructor_qrcodedata_from_bytes(
        FfiConverterByteArray.lower(`bytes`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeQrCodeData: FfiConverter<QrCodeData, Pointer> {

    override fun lower(value: QrCodeData): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): QrCodeData {
        return QrCodeData(value)
    }

    override fun read(buf: ByteBuffer): QrCodeData {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: QrCodeData) = 8UL

    override fun write(value: QrCodeData, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface RoomInterface {
    
    fun `activeMembersCount`(): kotlin.ULong
    
    /**
     * Returns a Vec of userId's that participate in the room call.
     *
     * MatrixRTC memberships with application "m.call" and scope "m.room" are
     * considered. A user can occur twice if they join with two devices.
     * convert to a set depending if the different users are required or the
     * amount of sessions.
     *
     * The vector is ordered by oldest membership user to newest.
     */
    fun `activeRoomCallParticipants`(): List<kotlin.String>
    
    fun `alternativeAliases`(): List<kotlin.String>
    
    suspend fun `applyPowerLevelChanges`(`changes`: RoomPowerLevelChanges)
    
    fun `avatarUrl`(): kotlin.String?
    
    suspend fun `banUser`(`userId`: kotlin.String, `reason`: kotlin.String?)
    
    suspend fun `canUserBan`(`userId`: kotlin.String): kotlin.Boolean
    
    suspend fun `canUserInvite`(`userId`: kotlin.String): kotlin.Boolean
    
    suspend fun `canUserKick`(`userId`: kotlin.String): kotlin.Boolean
    
    suspend fun `canUserRedactOther`(`userId`: kotlin.String): kotlin.Boolean
    
    suspend fun `canUserRedactOwn`(`userId`: kotlin.String): kotlin.Boolean
    
    suspend fun `canUserSendMessage`(`userId`: kotlin.String, `message`: MessageLikeEventType): kotlin.Boolean
    
    suspend fun `canUserSendState`(`userId`: kotlin.String, `stateEvent`: StateEventType): kotlin.Boolean
    
    suspend fun `canUserTriggerRoomNotification`(`userId`: kotlin.String): kotlin.Boolean
    
    fun `canonicalAlias`(): kotlin.String?
    
    /**
     * Remove the `ComposerDraft` stored in the state store for this room.
     */
    suspend fun `clearComposerDraft`()
    
    /**
     * Forces the currently active room key, which is used to encrypt messages,
     * to be rotated.
     *
     * A new room key will be crated and shared with all the room members the
     * next time a message will be sent. You don't have to call this method,
     * room keys will be rotated automatically when necessary. This method is
     * still useful for debugging purposes.
     */
    suspend fun `discardRoomKey`()
    
    /**
     * Returns the room's name from the state event if available, otherwise
     * compute a room name based on the room's nature (DM or not) and number of
     * members.
     */
    fun `displayName`(): kotlin.String?
    
    /**
     * Enable or disable the send queue for that particular room.
     */
    fun `enableSendQueue`(`enable`: kotlin.Boolean)
    
    suspend fun `getPowerLevels`(): RoomPowerLevels
    
    /**
     * Is there a non expired membership with application "m.call" and scope
     * "m.room" in this room.
     */
    fun `hasActiveRoomCall`(): kotlin.Boolean
    
    /**
     * Returns the room heroes for this room.
     */
    fun `heroes`(): List<RoomHero>
    
    fun `id`(): kotlin.String
    
    /**
     * Ignores a user.
     *
     * # Arguments
     *
     * * `user_id` - The ID of the user to ignore.
     */
    suspend fun `ignoreUser`(`userId`: kotlin.String)
    
    suspend fun `inviteUserById`(`userId`: kotlin.String)
    
    fun `invitedMembersCount`(): kotlin.ULong
    
    /**
     * For rooms one is invited to, retrieves the room member information for
     * the user who invited the logged-in user to a room.
     */
    suspend fun `inviter`(): RoomMember?
    
    fun `isDirect`(): kotlin.Boolean
    
    fun `isEncrypted`(): kotlin.Boolean
    
    fun `isPublic`(): kotlin.Boolean
    
    /**
     * Returns whether the send queue for that particular room is enabled or
     * not.
     */
    fun `isSendQueueEnabled`(): kotlin.Boolean
    
    fun `isSpace`(): kotlin.Boolean
    
    fun `isTombstoned`(): kotlin.Boolean
    
    /**
     * Join this room.
     *
     * Only invited and left rooms can be joined via this method.
     */
    suspend fun `join`()
    
    fun `joinedMembersCount`(): kotlin.ULong
    
    suspend fun `kickUser`(`userId`: kotlin.String, `reason`: kotlin.String?)
    
    /**
     * Leave this room.
     *
     * Only invited and joined rooms can be left.
     */
    suspend fun `leave`()
    
    /**
     * Retrieve the `ComposerDraft` stored in the state store for this room.
     */
    suspend fun `loadComposerDraft`(): ComposerDraft?
    
    /**
     * Mark a room as read, by attaching a read receipt on the latest event.
     *
     * Note: this does NOT unset the unread flag; it's the caller's
     * responsibility to do so, if needs be.
     */
    suspend fun `markAsRead`(`receiptType`: ReceiptType)
    
    suspend fun `matrixToEventPermalink`(`eventId`: kotlin.String): kotlin.String
    
    suspend fun `matrixToPermalink`(): kotlin.String
    
    suspend fun `member`(`userId`: kotlin.String): RoomMember
    
    suspend fun `memberAvatarUrl`(`userId`: kotlin.String): kotlin.String?
    
    suspend fun `memberDisplayName`(`userId`: kotlin.String): kotlin.String?
    
    suspend fun `members`(): RoomMembersIterator
    
    suspend fun `membersNoSync`(): RoomMembersIterator
    
    fun `membership`(): Membership
    
    fun `ownUserId`(): kotlin.String
    
    /**
     * The raw name as present in the room state event.
     */
    fun `rawName`(): kotlin.String?
    
    /**
     * Redacts an event from the room.
     *
     * # Arguments
     *
     * * `event_id` - The ID of the event to redact
     *
     * * `reason` - The reason for the event being redacted (optional).
     * its transaction ID (optional). If not given one is created.
     */
    suspend fun `redact`(`eventId`: kotlin.String, `reason`: kotlin.String?)
    
    /**
     * Removes the current room avatar
     */
    suspend fun `removeAvatar`()
    
    /**
     * Reports an event from the room.
     *
     * # Arguments
     *
     * * `event_id` - The ID of the event to report
     *
     * * `reason` - The reason for the event being reported (optional).
     *
     * * `score` - The score to rate this content as where -100 is most
     * offensive and 0 is inoffensive (optional).
     */
    suspend fun `reportContent`(`eventId`: kotlin.String, `score`: kotlin.Int?, `reason`: kotlin.String?)
    
    suspend fun `resetPowerLevels`(): RoomPowerLevels
    
    suspend fun `roomInfo`(): RoomInfo
    
    /**
     * Store the given `ComposerDraft` in the state store using the current
     * room id, as identifier.
     */
    suspend fun `saveComposerDraft`(`draft`: ComposerDraft)
    
    /**
     * Send a call notification event in the current room.
     *
     * This is only supposed to be used in **custom** situations where the user
     * explicitly chooses to send a `m.call.notify` event to invite/notify
     * someone explicitly in unusual conditions. The default should be to
     * use `send_call_notification_if_necessary` just before a new room call is
     * created/joined.
     *
     * One example could be that the UI allows to start a call with a subset of
     * users of the room members first. And then later on the user can
     * invite more users to the call.
     */
    suspend fun `sendCallNotification`(`callId`: kotlin.String, `application`: RtcApplicationType, `notifyType`: NotifyType, `mentions`: Mentions)
    
    /**
     * This will only send a call notification event if appropriate.
     *
     * This function is supposed to be called whenever the user creates a room
     * call. It will send a `m.call.notify` event if:
     * - there is not yet a running call.
     * It will configure the notify type: ring or notify based on:
     * - is this a DM room -> ring
     * - is this a group with more than one other member -> notify
     */
    suspend fun `sendCallNotificationIfNeeded`()
    
    suspend fun `setIsFavourite`(`isFavourite`: kotlin.Boolean, `tagOrder`: kotlin.Double?)
    
    suspend fun `setIsLowPriority`(`isLowPriority`: kotlin.Boolean, `tagOrder`: kotlin.Double?)
    
    /**
     * Sets a new name to the room.
     */
    suspend fun `setName`(`name`: kotlin.String)
    
    /**
     * Sets a new topic in the room.
     */
    suspend fun `setTopic`(`topic`: kotlin.String)
    
    /**
     * Set (or unset) a flag on the room to indicate that the user has
     * explicitly marked it as unread.
     */
    suspend fun `setUnreadFlag`(`newValue`: kotlin.Boolean)
    
    fun `subscribeToRoomInfoUpdates`(`listener`: RoomInfoListener): TaskHandle
    
    fun `subscribeToTypingNotifications`(`listener`: TypingNotificationsListener): TaskHandle
    
    suspend fun `suggestedRoleForUser`(`userId`: kotlin.String): RoomMemberRole
    
    suspend fun `timeline`(): Timeline
    
    /**
     * Returns a timeline focused on the given event.
     *
     * Note: this timeline is independent from that returned with
     * [`Self::timeline`], and as such it is not cached.
     */
    suspend fun `timelineFocusedOnEvent`(`eventId`: kotlin.String, `numContextEvents`: kotlin.UShort, `internalIdPrefix`: kotlin.String?): Timeline
    
    fun `topic`(): kotlin.String?
    
    suspend fun `typingNotice`(`isTyping`: kotlin.Boolean)
    
    suspend fun `unbanUser`(`userId`: kotlin.String, `reason`: kotlin.String?)
    
    suspend fun `updatePowerLevelsForUsers`(`updates`: List<UserPowerLevelUpdate>)
    
    /**
     * Upload and set the room's avatar.
     *
     * This will upload the data produced by the reader to the homeserver's
     * content repository, and set the room's avatar to the MXC URI for the
     * uploaded file.
     *
     * # Arguments
     *
     * * `mime_type` - The mime description of the avatar, for example
     * image/jpeg
     * * `data` - The raw data that will be uploaded to the homeserver's
     * content repository
     * * `media_info` - The media info used as avatar image info.
     */
    suspend fun `uploadAvatar`(`mimeType`: kotlin.String, `data`: kotlin.ByteArray, `mediaInfo`: ImageInfo?)
    
    companion object
}

open class Room: Disposable, AutoCloseable, RoomInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_room(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_room(pointer!!, status)
        }
    }

    override fun `activeMembersCount`(): kotlin.ULong {
            return FfiConverterULong.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_active_members_count(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * Returns a Vec of userId's that participate in the room call.
     *
     * MatrixRTC memberships with application "m.call" and scope "m.room" are
     * considered. A user can occur twice if they join with two devices.
     * convert to a set depending if the different users are required or the
     * amount of sessions.
     *
     * The vector is ordered by oldest membership user to newest.
     */override fun `activeRoomCallParticipants`(): List<kotlin.String> {
            return FfiConverterSequenceString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_active_room_call_participants(
        it, _status)
}
    }
    )
    }
    

    override fun `alternativeAliases`(): List<kotlin.String> {
            return FfiConverterSequenceString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_alternative_aliases(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `applyPowerLevelChanges`(`changes`: RoomPowerLevelChanges) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_apply_power_level_changes(
                thisPtr,
                FfiConverterTypeRoomPowerLevelChanges.lower(`changes`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    override fun `avatarUrl`(): kotlin.String? {
            return FfiConverterOptionalString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_avatar_url(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `banUser`(`userId`: kotlin.String, `reason`: kotlin.String?) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_ban_user(
                thisPtr,
                FfiConverterString.lower(`userId`),FfiConverterOptionalString.lower(`reason`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserBan`(`userId`: kotlin.String) : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_ban(
                thisPtr,
                FfiConverterString.lower(`userId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserInvite`(`userId`: kotlin.String) : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_invite(
                thisPtr,
                FfiConverterString.lower(`userId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserKick`(`userId`: kotlin.String) : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_kick(
                thisPtr,
                FfiConverterString.lower(`userId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserRedactOther`(`userId`: kotlin.String) : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_redact_other(
                thisPtr,
                FfiConverterString.lower(`userId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserRedactOwn`(`userId`: kotlin.String) : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_redact_own(
                thisPtr,
                FfiConverterString.lower(`userId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserSendMessage`(`userId`: kotlin.String, `message`: MessageLikeEventType) : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_send_message(
                thisPtr,
                FfiConverterString.lower(`userId`),FfiConverterTypeMessageLikeEventType.lower(`message`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserSendState`(`userId`: kotlin.String, `stateEvent`: StateEventType) : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_send_state(
                thisPtr,
                FfiConverterString.lower(`userId`),FfiConverterTypeStateEventType.lower(`stateEvent`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `canUserTriggerRoomNotification`(`userId`: kotlin.String) : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_can_user_trigger_room_notification(
                thisPtr,
                FfiConverterString.lower(`userId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    override fun `canonicalAlias`(): kotlin.String? {
            return FfiConverterOptionalString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_canonical_alias(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * Remove the `ComposerDraft` stored in the state store for this room.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `clearComposerDraft`() {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_clear_composer_draft(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Forces the currently active room key, which is used to encrypt messages,
     * to be rotated.
     *
     * A new room key will be crated and shared with all the room members the
     * next time a message will be sent. You don't have to call this method,
     * room keys will be rotated automatically when necessary. This method is
     * still useful for debugging purposes.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `discardRoomKey`() {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_discard_room_key(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Returns the room's name from the state event if available, otherwise
     * compute a room name based on the room's nature (DM or not) and number of
     * members.
     */override fun `displayName`(): kotlin.String? {
            return FfiConverterOptionalString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_display_name(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * Enable or disable the send queue for that particular room.
     */override fun `enableSendQueue`(`enable`: kotlin.Boolean)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_enable_send_queue(
        it, FfiConverterBoolean.lower(`enable`),_status)
}
    }
    
    

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getPowerLevels`() : RoomPowerLevels {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_get_power_levels(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeRoomPowerLevels.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Is there a non expired membership with application "m.call" and scope
     * "m.room" in this room.
     */override fun `hasActiveRoomCall`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_has_active_room_call(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * Returns the room heroes for this room.
     */override fun `heroes`(): List<RoomHero> {
            return FfiConverterSequenceTypeRoomHero.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_heroes(
        it, _status)
}
    }
    )
    }
    

    override fun `id`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_id(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * Ignores a user.
     *
     * # Arguments
     *
     * * `user_id` - The ID of the user to ignore.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `ignoreUser`(`userId`: kotlin.String) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_ignore_user(
                thisPtr,
                FfiConverterString.lower(`userId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `inviteUserById`(`userId`: kotlin.String) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_invite_user_by_id(
                thisPtr,
                FfiConverterString.lower(`userId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    override fun `invitedMembersCount`(): kotlin.ULong {
            return FfiConverterULong.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_invited_members_count(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * For rooms one is invited to, retrieves the room member information for
     * the user who invited the logged-in user to a room.
     */
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `inviter`() : RoomMember? {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_inviter(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterOptionalTypeRoomMember.lift(it) },
        // Error FFI converter
        UniffiNullRustCallStatusErrorHandler,
    )
    }

    override fun `isDirect`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_is_direct(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(ClientException::class)override fun `isEncrypted`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCallWithError(ClientException) { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_is_encrypted(
        it, _status)
}
    }
    )
    }
    

    override fun `isPublic`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_is_public(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * Returns whether the send queue for that particular room is enabled or
     * not.
     */override fun `isSendQueueEnabled`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_is_send_queue_enabled(
        it, _status)
}
    }
    )
    }
    

    override fun `isSpace`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_is_space(
        it, _status)
}
    }
    )
    }
    

    override fun `isTombstoned`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_is_tombstoned(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * Join this room.
     *
     * Only invited and left rooms can be joined via this method.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `join`() {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_join(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    override fun `joinedMembersCount`(): kotlin.ULong {
            return FfiConverterULong.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_joined_members_count(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `kickUser`(`userId`: kotlin.String, `reason`: kotlin.String?) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_kick_user(
                thisPtr,
                FfiConverterString.lower(`userId`),FfiConverterOptionalString.lower(`reason`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Leave this room.
     *
     * Only invited and joined rooms can be left.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `leave`() {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_leave(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Retrieve the `ComposerDraft` stored in the state store for this room.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `loadComposerDraft`() : ComposerDraft? {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_load_composer_draft(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterOptionalTypeComposerDraft.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Mark a room as read, by attaching a read receipt on the latest event.
     *
     * Note: this does NOT unset the unread flag; it's the caller's
     * responsibility to do so, if needs be.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `markAsRead`(`receiptType`: ReceiptType) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_mark_as_read(
                thisPtr,
                FfiConverterTypeReceiptType.lower(`receiptType`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `matrixToEventPermalink`(`eventId`: kotlin.String) : kotlin.String {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_matrix_to_event_permalink(
                thisPtr,
                FfiConverterString.lower(`eventId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterString.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `matrixToPermalink`() : kotlin.String {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_matrix_to_permalink(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterString.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `member`(`userId`: kotlin.String) : RoomMember {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_member(
                thisPtr,
                FfiConverterString.lower(`userId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeRoomMember.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `memberAvatarUrl`(`userId`: kotlin.String) : kotlin.String? {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_member_avatar_url(
                thisPtr,
                FfiConverterString.lower(`userId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterOptionalString.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `memberDisplayName`(`userId`: kotlin.String) : kotlin.String? {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_member_display_name(
                thisPtr,
                FfiConverterString.lower(`userId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterOptionalString.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `members`() : RoomMembersIterator {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_members(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeRoomMembersIterator.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `membersNoSync`() : RoomMembersIterator {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_members_no_sync(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeRoomMembersIterator.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    override fun `membership`(): Membership {
            return FfiConverterTypeMembership.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_membership(
        it, _status)
}
    }
    )
    }
    

    override fun `ownUserId`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_own_user_id(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * The raw name as present in the room state event.
     */override fun `rawName`(): kotlin.String? {
            return FfiConverterOptionalString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_raw_name(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * Redacts an event from the room.
     *
     * # Arguments
     *
     * * `event_id` - The ID of the event to redact
     *
     * * `reason` - The reason for the event being redacted (optional).
     * its transaction ID (optional). If not given one is created.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `redact`(`eventId`: kotlin.String, `reason`: kotlin.String?) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_redact(
                thisPtr,
                FfiConverterString.lower(`eventId`),FfiConverterOptionalString.lower(`reason`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Removes the current room avatar
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `removeAvatar`() {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_remove_avatar(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Reports an event from the room.
     *
     * # Arguments
     *
     * * `event_id` - The ID of the event to report
     *
     * * `reason` - The reason for the event being reported (optional).
     *
     * * `score` - The score to rate this content as where -100 is most
     * offensive and 0 is inoffensive (optional).
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `reportContent`(`eventId`: kotlin.String, `score`: kotlin.Int?, `reason`: kotlin.String?) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_report_content(
                thisPtr,
                FfiConverterString.lower(`eventId`),FfiConverterOptionalInt.lower(`score`),FfiConverterOptionalString.lower(`reason`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `resetPowerLevels`() : RoomPowerLevels {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_reset_power_levels(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeRoomPowerLevels.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `roomInfo`() : RoomInfo {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_room_info(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeRoomInfo.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Store the given `ComposerDraft` in the state store using the current
     * room id, as identifier.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `saveComposerDraft`(`draft`: ComposerDraft) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_save_composer_draft(
                thisPtr,
                FfiConverterTypeComposerDraft.lower(`draft`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Send a call notification event in the current room.
     *
     * This is only supposed to be used in **custom** situations where the user
     * explicitly chooses to send a `m.call.notify` event to invite/notify
     * someone explicitly in unusual conditions. The default should be to
     * use `send_call_notification_if_necessary` just before a new room call is
     * created/joined.
     *
     * One example could be that the UI allows to start a call with a subset of
     * users of the room members first. And then later on the user can
     * invite more users to the call.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `sendCallNotification`(`callId`: kotlin.String, `application`: RtcApplicationType, `notifyType`: NotifyType, `mentions`: Mentions) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_send_call_notification(
                thisPtr,
                FfiConverterString.lower(`callId`),FfiConverterTypeRtcApplicationType.lower(`application`),FfiConverterTypeNotifyType.lower(`notifyType`),FfiConverterTypeMentions.lower(`mentions`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * This will only send a call notification event if appropriate.
     *
     * This function is supposed to be called whenever the user creates a room
     * call. It will send a `m.call.notify` event if:
     * - there is not yet a running call.
     * It will configure the notify type: ring or notify based on:
     * - is this a DM room -> ring
     * - is this a group with more than one other member -> notify
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `sendCallNotificationIfNeeded`() {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_send_call_notification_if_needed(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setIsFavourite`(`isFavourite`: kotlin.Boolean, `tagOrder`: kotlin.Double?) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_set_is_favourite(
                thisPtr,
                FfiConverterBoolean.lower(`isFavourite`),FfiConverterOptionalDouble.lower(`tagOrder`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setIsLowPriority`(`isLowPriority`: kotlin.Boolean, `tagOrder`: kotlin.Double?) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_set_is_low_priority(
                thisPtr,
                FfiConverterBoolean.lower(`isLowPriority`),FfiConverterOptionalDouble.lower(`tagOrder`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Sets a new name to the room.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setName`(`name`: kotlin.String) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_set_name(
                thisPtr,
                FfiConverterString.lower(`name`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Sets a new topic in the room.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setTopic`(`topic`: kotlin.String) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_set_topic(
                thisPtr,
                FfiConverterString.lower(`topic`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Set (or unset) a flag on the room to indicate that the user has
     * explicitly marked it as unread.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `setUnreadFlag`(`newValue`: kotlin.Boolean) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_set_unread_flag(
                thisPtr,
                FfiConverterBoolean.lower(`newValue`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    override fun `subscribeToRoomInfoUpdates`(`listener`: RoomInfoListener): TaskHandle {
            return FfiConverterTypeTaskHandle.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_subscribe_to_room_info_updates(
        it, FfiConverterTypeRoomInfoListener.lower(`listener`),_status)
}
    }
    )
    }
    

    override fun `subscribeToTypingNotifications`(`listener`: TypingNotificationsListener): TaskHandle {
            return FfiConverterTypeTaskHandle.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_subscribe_to_typing_notifications(
        it, FfiConverterTypeTypingNotificationsListener.lower(`listener`),_status)
}
    }
    )
    }
    

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `suggestedRoleForUser`(`userId`: kotlin.String) : RoomMemberRole {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_suggested_role_for_user(
                thisPtr,
                FfiConverterString.lower(`userId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation).let { RustBufferRoomMemberRole.create(it.capacity.toULong(), it.len.toULong(), it.data) } },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeRoomMemberRole.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `timeline`() : Timeline {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_timeline(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeTimeline.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Returns a timeline focused on the given event.
     *
     * Note: this timeline is independent from that returned with
     * [`Self::timeline`], and as such it is not cached.
     */
    @Throws(FocusEventException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `timelineFocusedOnEvent`(`eventId`: kotlin.String, `numContextEvents`: kotlin.UShort, `internalIdPrefix`: kotlin.String?) : Timeline {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_timeline_focused_on_event(
                thisPtr,
                FfiConverterString.lower(`eventId`),FfiConverterUShort.lower(`numContextEvents`),FfiConverterOptionalString.lower(`internalIdPrefix`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeTimeline.lift(it) },
        // Error FFI converter
        FocusEventException.ErrorHandler,
    )
    }

    override fun `topic`(): kotlin.String? {
            return FfiConverterOptionalString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_topic(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `typingNotice`(`isTyping`: kotlin.Boolean) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_typing_notice(
                thisPtr,
                FfiConverterBoolean.lower(`isTyping`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `unbanUser`(`userId`: kotlin.String, `reason`: kotlin.String?) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_unban_user(
                thisPtr,
                FfiConverterString.lower(`userId`),FfiConverterOptionalString.lower(`reason`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `updatePowerLevelsForUsers`(`updates`: List<UserPowerLevelUpdate>) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_update_power_levels_for_users(
                thisPtr,
                FfiConverterSequenceTypeUserPowerLevelUpdate.lower(`updates`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Upload and set the room's avatar.
     *
     * This will upload the data produced by the reader to the homeserver's
     * content repository, and set the room's avatar to the MXC URI for the
     * uploaded file.
     *
     * # Arguments
     *
     * * `mime_type` - The mime description of the avatar, for example
     * image/jpeg
     * * `data` - The raw data that will be uploaded to the homeserver's
     * content repository
     * * `media_info` - The media info used as avatar image info.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `uploadAvatar`(`mimeType`: kotlin.String, `data`: kotlin.ByteArray, `mediaInfo`: ImageInfo?) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_room_upload_avatar(
                thisPtr,
                FfiConverterString.lower(`mimeType`),FfiConverterByteArray.lower(`data`),FfiConverterOptionalTypeImageInfo.lower(`mediaInfo`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

public object FfiConverterTypeRoom: FfiConverter<Room, Pointer> {

    override fun lower(value: Room): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Room {
        return Room(value)
    }

    override fun read(buf: ByteBuffer): Room {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Room) = 8UL

    override fun write(value: Room, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface RoomDirectorySearchInterface {
    
    suspend fun `isAtLastPage`(): kotlin.Boolean
    
    suspend fun `loadedPages`(): kotlin.UInt
    
    suspend fun `nextPage`()
    
    suspend fun `results`(`listener`: RoomDirectorySearchEntriesListener): TaskHandle
    
    suspend fun `search`(`filter`: kotlin.String?, `batchSize`: kotlin.UInt)
    
    companion object
}

open class RoomDirectorySearch: Disposable, AutoCloseable, RoomDirectorySearchInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_roomdirectorysearch(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_roomdirectorysearch(pointer!!, status)
        }
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `isAtLastPage`() : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomdirectorysearch_is_at_last_page(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `loadedPages`() : kotlin.UInt {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomdirectorysearch_loaded_pages(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_u32(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_u32(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_u32(future) },
        // lift function
        { FfiConverterUInt.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `nextPage`() {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomdirectorysearch_next_page(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `results`(`listener`: RoomDirectorySearchEntriesListener) : TaskHandle {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomdirectorysearch_results(
                thisPtr,
                FfiConverterTypeRoomDirectorySearchEntriesListener.lower(`listener`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeTaskHandle.lift(it) },
        // Error FFI converter
        UniffiNullRustCallStatusErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `search`(`filter`: kotlin.String?, `batchSize`: kotlin.UInt) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomdirectorysearch_search(
                thisPtr,
                FfiConverterOptionalString.lower(`filter`),FfiConverterUInt.lower(`batchSize`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

public object FfiConverterTypeRoomDirectorySearch: FfiConverter<RoomDirectorySearch, Pointer> {

    override fun lower(value: RoomDirectorySearch): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): RoomDirectorySearch {
        return RoomDirectorySearch(value)
    }

    override fun read(buf: ByteBuffer): RoomDirectorySearch {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomDirectorySearch) = 8UL

    override fun write(value: RoomDirectorySearch, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface RoomListInterface {
    
    fun `entries`(`listener`: RoomListEntriesListener): RoomListEntriesResult
    
    fun `entriesWithDynamicAdapters`(`pageSize`: kotlin.UInt, `listener`: RoomListEntriesListener): RoomListEntriesWithDynamicAdaptersResult
    
    fun `loadingState`(`listener`: RoomListLoadingStateListener): RoomListLoadingStateResult
    
    fun `room`(`roomId`: kotlin.String): RoomListItem
    
    companion object
}

open class RoomList: Disposable, AutoCloseable, RoomListInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_roomlist(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_roomlist(pointer!!, status)
        }
    }

    override fun `entries`(`listener`: RoomListEntriesListener): RoomListEntriesResult {
            return FfiConverterTypeRoomListEntriesResult.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlist_entries(
        it, FfiConverterTypeRoomListEntriesListener.lower(`listener`),_status)
}
    }
    )
    }
    

    override fun `entriesWithDynamicAdapters`(`pageSize`: kotlin.UInt, `listener`: RoomListEntriesListener): RoomListEntriesWithDynamicAdaptersResult {
            return FfiConverterTypeRoomListEntriesWithDynamicAdaptersResult.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlist_entries_with_dynamic_adapters(
        it, FfiConverterUInt.lower(`pageSize`),FfiConverterTypeRoomListEntriesListener.lower(`listener`),_status)
}
    }
    )
    }
    

    
    @Throws(RoomListException::class)override fun `loadingState`(`listener`: RoomListLoadingStateListener): RoomListLoadingStateResult {
            return FfiConverterTypeRoomListLoadingStateResult.lift(
    callWithPointer {
    uniffiRustCallWithError(RoomListException) { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlist_loading_state(
        it, FfiConverterTypeRoomListLoadingStateListener.lower(`listener`),_status)
}
    }
    )
    }
    

    
    @Throws(RoomListException::class)override fun `room`(`roomId`: kotlin.String): RoomListItem {
            return FfiConverterTypeRoomListItem.lift(
    callWithPointer {
    uniffiRustCallWithError(RoomListException) { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlist_room(
        it, FfiConverterString.lower(`roomId`),_status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeRoomList: FfiConverter<RoomList, Pointer> {

    override fun lower(value: RoomList): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): RoomList {
        return RoomList(value)
    }

    override fun read(buf: ByteBuffer): RoomList {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomList) = 8UL

    override fun write(value: RoomList, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface RoomListDynamicEntriesControllerInterface {
    
    fun `addOnePage`()
    
    fun `resetToOnePage`()
    
    fun `setFilter`(`kind`: RoomListEntriesDynamicFilterKind): kotlin.Boolean
    
    companion object
}

open class RoomListDynamicEntriesController: Disposable, AutoCloseable, RoomListDynamicEntriesControllerInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_roomlistdynamicentriescontroller(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_roomlistdynamicentriescontroller(pointer!!, status)
        }
    }

    override fun `addOnePage`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistdynamicentriescontroller_add_one_page(
        it, _status)
}
    }
    
    

    override fun `resetToOnePage`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistdynamicentriescontroller_reset_to_one_page(
        it, _status)
}
    }
    
    

    override fun `setFilter`(`kind`: RoomListEntriesDynamicFilterKind): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistdynamicentriescontroller_set_filter(
        it, FfiConverterTypeRoomListEntriesDynamicFilterKind.lower(`kind`),_status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeRoomListDynamicEntriesController: FfiConverter<RoomListDynamicEntriesController, Pointer> {

    override fun lower(value: RoomListDynamicEntriesController): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): RoomListDynamicEntriesController {
        return RoomListDynamicEntriesController(value)
    }

    override fun read(buf: ByteBuffer): RoomListDynamicEntriesController {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomListDynamicEntriesController) = 8UL

    override fun write(value: RoomListDynamicEntriesController, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface RoomListItemInterface {
    
    fun `avatarUrl`(): kotlin.String?
    
    fun `canonicalAlias`(): kotlin.String?
    
    /**
     * Returns the room's name from the state event if available, otherwise
     * compute a room name based on the room's nature (DM or not) and number of
     * members.
     */
    fun `displayName`(): kotlin.String?
    
    /**
     * Build a full `Room` FFI object, filling its associated timeline.
     *
     * If its internal timeline hasn't been initialized, it'll fail.
     */
    fun `fullRoom`(): Room
    
    fun `id`(): kotlin.String
    
    /**
     * Initializes the timeline for this room using the provided parameters.
     *
     * * `event_type_filter` - An optional [`TimelineEventTypeFilter`] to be
     * used to filter timeline events besides the default timeline filter. If
     * `None` is passed, only the default timeline filter will be used.
     * * `internal_id_prefix` - An optional String that will be prepended to
     * all the timeline item's internal IDs, making it possible to
     * distinguish different timeline instances from each other.
     */
    suspend fun `initTimeline`(`eventTypeFilter`: TimelineEventTypeFilter?, `internalIdPrefix`: kotlin.String?)
    
    fun `isDirect`(): kotlin.Boolean
    
    /**
     * Checks whether the Room's timeline has been initialized before.
     */
    fun `isTimelineInitialized`(): kotlin.Boolean
    
    suspend fun `latestEvent`(): EventTimelineItem?
    
    suspend fun `roomInfo`(): RoomInfo
    
    fun `subscribe`(`settings`: RoomSubscription?)
    
    fun `unsubscribe`()
    
    companion object
}

open class RoomListItem: Disposable, AutoCloseable, RoomListItemInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_roomlistitem(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_roomlistitem(pointer!!, status)
        }
    }

    override fun `avatarUrl`(): kotlin.String? {
            return FfiConverterOptionalString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_avatar_url(
        it, _status)
}
    }
    )
    }
    

    override fun `canonicalAlias`(): kotlin.String? {
            return FfiConverterOptionalString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_canonical_alias(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * Returns the room's name from the state event if available, otherwise
     * compute a room name based on the room's nature (DM or not) and number of
     * members.
     */override fun `displayName`(): kotlin.String? {
            return FfiConverterOptionalString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_display_name(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * Build a full `Room` FFI object, filling its associated timeline.
     *
     * If its internal timeline hasn't been initialized, it'll fail.
     */
    @Throws(RoomListException::class)override fun `fullRoom`(): Room {
            return FfiConverterTypeRoom.lift(
    callWithPointer {
    uniffiRustCallWithError(RoomListException) { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_full_room(
        it, _status)
}
    }
    )
    }
    

    override fun `id`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_id(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * Initializes the timeline for this room using the provided parameters.
     *
     * * `event_type_filter` - An optional [`TimelineEventTypeFilter`] to be
     * used to filter timeline events besides the default timeline filter. If
     * `None` is passed, only the default timeline filter will be used.
     * * `internal_id_prefix` - An optional String that will be prepended to
     * all the timeline item's internal IDs, making it possible to
     * distinguish different timeline instances from each other.
     */
    @Throws(RoomListException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `initTimeline`(`eventTypeFilter`: TimelineEventTypeFilter?, `internalIdPrefix`: kotlin.String?) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_init_timeline(
                thisPtr,
                FfiConverterOptionalTypeTimelineEventTypeFilter.lower(`eventTypeFilter`),FfiConverterOptionalString.lower(`internalIdPrefix`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        RoomListException.ErrorHandler,
    )
    }

    override fun `isDirect`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_is_direct(
        it, _status)
}
    }
    )
    }
    

    
    /**
     * Checks whether the Room's timeline has been initialized before.
     */override fun `isTimelineInitialized`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_is_timeline_initialized(
        it, _status)
}
    }
    )
    }
    

    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `latestEvent`() : EventTimelineItem? {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_latest_event(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterOptionalTypeEventTimelineItem.lift(it) },
        // Error FFI converter
        UniffiNullRustCallStatusErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `roomInfo`() : RoomInfo {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_room_info(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeRoomInfo.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    override fun `subscribe`(`settings`: RoomSubscription?)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_subscribe(
        it, FfiConverterOptionalTypeRoomSubscription.lower(`settings`),_status)
}
    }
    
    

    override fun `unsubscribe`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistitem_unsubscribe(
        it, _status)
}
    }
    
    

    

    
    
    companion object
    
}

public object FfiConverterTypeRoomListItem: FfiConverter<RoomListItem, Pointer> {

    override fun lower(value: RoomListItem): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): RoomListItem {
        return RoomListItem(value)
    }

    override fun read(buf: ByteBuffer): RoomListItem {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomListItem) = 8UL

    override fun write(value: RoomListItem, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface RoomListServiceInterface {
    
    suspend fun `allRooms`(): RoomList
    
    suspend fun `applyInput`(`input`: RoomListInput)
    
    fun `room`(`roomId`: kotlin.String): RoomListItem
    
    fun `state`(`listener`: RoomListServiceStateListener): TaskHandle
    
    fun `syncIndicator`(`delayBeforeShowingInMs`: kotlin.UInt, `delayBeforeHidingInMs`: kotlin.UInt, `listener`: RoomListServiceSyncIndicatorListener): TaskHandle
    
    companion object
}

open class RoomListService: Disposable, AutoCloseable, RoomListServiceInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_roomlistservice(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_roomlistservice(pointer!!, status)
        }
    }

    
    @Throws(RoomListException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `allRooms`() : RoomList {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistservice_all_rooms(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeRoomList.lift(it) },
        // Error FFI converter
        RoomListException.ErrorHandler,
    )
    }

    
    @Throws(RoomListException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `applyInput`(`input`: RoomListInput) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistservice_apply_input(
                thisPtr,
                FfiConverterTypeRoomListInput.lower(`input`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        RoomListException.ErrorHandler,
    )
    }

    
    @Throws(RoomListException::class)override fun `room`(`roomId`: kotlin.String): RoomListItem {
            return FfiConverterTypeRoomListItem.lift(
    callWithPointer {
    uniffiRustCallWithError(RoomListException) { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistservice_room(
        it, FfiConverterString.lower(`roomId`),_status)
}
    }
    )
    }
    

    override fun `state`(`listener`: RoomListServiceStateListener): TaskHandle {
            return FfiConverterTypeTaskHandle.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistservice_state(
        it, FfiConverterTypeRoomListServiceStateListener.lower(`listener`),_status)
}
    }
    )
    }
    

    override fun `syncIndicator`(`delayBeforeShowingInMs`: kotlin.UInt, `delayBeforeHidingInMs`: kotlin.UInt, `listener`: RoomListServiceSyncIndicatorListener): TaskHandle {
            return FfiConverterTypeTaskHandle.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roomlistservice_sync_indicator(
        it, FfiConverterUInt.lower(`delayBeforeShowingInMs`),FfiConverterUInt.lower(`delayBeforeHidingInMs`),FfiConverterTypeRoomListServiceSyncIndicatorListener.lower(`listener`),_status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeRoomListService: FfiConverter<RoomListService, Pointer> {

    override fun lower(value: RoomListService): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): RoomListService {
        return RoomListService(value)
    }

    override fun read(buf: ByteBuffer): RoomListService {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomListService) = 8UL

    override fun write(value: RoomListService, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface RoomMembersIteratorInterface {
    
    fun `len`(): kotlin.UInt
    
    fun `nextChunk`(`chunkSize`: kotlin.UInt): List<RoomMember>?
    
    companion object
}

open class RoomMembersIterator: Disposable, AutoCloseable, RoomMembersIteratorInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_roommembersiterator(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_roommembersiterator(pointer!!, status)
        }
    }

    override fun `len`(): kotlin.UInt {
            return FfiConverterUInt.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommembersiterator_len(
        it, _status)
}
    }
    )
    }
    

    override fun `nextChunk`(`chunkSize`: kotlin.UInt): List<RoomMember>? {
            return FfiConverterOptionalSequenceTypeRoomMember.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommembersiterator_next_chunk(
        it, FfiConverterUInt.lower(`chunkSize`),_status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeRoomMembersIterator: FfiConverter<RoomMembersIterator, Pointer> {

    override fun lower(value: RoomMembersIterator): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): RoomMembersIterator {
        return RoomMembersIterator(value)
    }

    override fun read(buf: ByteBuffer): RoomMembersIterator {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomMembersIterator) = 8UL

    override fun write(value: RoomMembersIterator, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface RoomMessageEventContentWithoutRelationInterface {
    
    fun `withMentions`(`mentions`: Mentions): RoomMessageEventContentWithoutRelation
    
    companion object
}

open class RoomMessageEventContentWithoutRelation: Disposable, AutoCloseable, RoomMessageEventContentWithoutRelationInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_roommessageeventcontentwithoutrelation(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_roommessageeventcontentwithoutrelation(pointer!!, status)
        }
    }

    override fun `withMentions`(`mentions`: Mentions): RoomMessageEventContentWithoutRelation {
            return FfiConverterTypeRoomMessageEventContentWithoutRelation.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_roommessageeventcontentwithoutrelation_with_mentions(
        it, FfiConverterTypeMentions.lower(`mentions`),_status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeRoomMessageEventContentWithoutRelation: FfiConverter<RoomMessageEventContentWithoutRelation, Pointer> {

    override fun lower(value: RoomMessageEventContentWithoutRelation): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): RoomMessageEventContentWithoutRelation {
        return RoomMessageEventContentWithoutRelation(value)
    }

    override fun read(buf: ByteBuffer): RoomMessageEventContentWithoutRelation {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: RoomMessageEventContentWithoutRelation) = 8UL

    override fun write(value: RoomMessageEventContentWithoutRelation, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface SendAttachmentJoinHandleInterface {
    
    fun `cancel`()
    
    suspend fun `join`()
    
    companion object
}

open class SendAttachmentJoinHandle: Disposable, AutoCloseable, SendAttachmentJoinHandleInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_sendattachmentjoinhandle(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_sendattachmentjoinhandle(pointer!!, status)
        }
    }

    override fun `cancel`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sendattachmentjoinhandle_cancel(
        it, _status)
}
    }
    
    

    
    @Throws(RoomException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `join`() {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sendattachmentjoinhandle_join(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        RoomException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

public object FfiConverterTypeSendAttachmentJoinHandle: FfiConverter<SendAttachmentJoinHandle, Pointer> {

    override fun lower(value: SendAttachmentJoinHandle): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): SendAttachmentJoinHandle {
        return SendAttachmentJoinHandle(value)
    }

    override fun read(buf: ByteBuffer): SendAttachmentJoinHandle {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SendAttachmentJoinHandle) = 8UL

    override fun write(value: SendAttachmentJoinHandle, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface SessionVerificationControllerInterface {
    
    suspend fun `approveVerification`()
    
    suspend fun `cancelVerification`()
    
    suspend fun `declineVerification`()
    
    suspend fun `isVerified`(): kotlin.Boolean
    
    suspend fun `requestVerification`()
    
    fun `setDelegate`(`delegate`: SessionVerificationControllerDelegate?)
    
    suspend fun `startSasVerification`()
    
    companion object
}

open class SessionVerificationController: Disposable, AutoCloseable, SessionVerificationControllerInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_sessionverificationcontroller(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_sessionverificationcontroller(pointer!!, status)
        }
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `approveVerification`() {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_approve_verification(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `cancelVerification`() {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_cancel_verification(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `declineVerification`() {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_decline_verification(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `isVerified`() : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_is_verified(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `requestVerification`() {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_request_verification(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    override fun `setDelegate`(`delegate`: SessionVerificationControllerDelegate?)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_set_delegate(
        it, FfiConverterOptionalTypeSessionVerificationControllerDelegate.lower(`delegate`),_status)
}
    }
    
    

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `startSasVerification`() {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationcontroller_start_sas_verification(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

public object FfiConverterTypeSessionVerificationController: FfiConverter<SessionVerificationController, Pointer> {

    override fun lower(value: SessionVerificationController): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): SessionVerificationController {
        return SessionVerificationController(value)
    }

    override fun read(buf: ByteBuffer): SessionVerificationController {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SessionVerificationController) = 8UL

    override fun write(value: SessionVerificationController, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface SessionVerificationEmojiInterface {
    
    fun `description`(): kotlin.String
    
    fun `symbol`(): kotlin.String
    
    companion object
}

open class SessionVerificationEmoji: Disposable, AutoCloseable, SessionVerificationEmojiInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_sessionverificationemoji(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_sessionverificationemoji(pointer!!, status)
        }
    }

    override fun `description`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationemoji_description(
        it, _status)
}
    }
    )
    }
    

    override fun `symbol`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_sessionverificationemoji_symbol(
        it, _status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeSessionVerificationEmoji: FfiConverter<SessionVerificationEmoji, Pointer> {

    override fun lower(value: SessionVerificationEmoji): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): SessionVerificationEmoji {
        return SessionVerificationEmoji(value)
    }

    override fun read(buf: ByteBuffer): SessionVerificationEmoji {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SessionVerificationEmoji) = 8UL

    override fun write(value: SessionVerificationEmoji, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface SpanInterface {
    
    fun `enter`()
    
    fun `exit`()
    
    fun `isNone`(): kotlin.Boolean
    
    companion object
}

open class Span: Disposable, AutoCloseable, SpanInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    /**
     * Create a span originating at the given callsite (file, line and column).
     *
     * The target should be something like a module path, and can be referenced
     * in the filter string given to `setup_tracing`. `level` and `target`
     * for a callsite are fixed at the first creation of a span for that
     * callsite and can not be changed afterwards, i.e. the level and
     * target passed for second and following creation of a span with the same
     * callsite will be ignored.
     *
     * This function leaks a little bit of memory for each unique (file + line
     * + level + target + name) it is called with. Please make sure that the
     * number of different combinations of those parameters this can be called
     * with is constant in the final executable.
     *
     * For a span to have an effect, you must `.enter()` it at the start of a
     * logical unit of work and `.exit()` it at the end of the same (including
     * on failure). Entering registers the span in thread-local storage, so
     * future calls to `log_event` on the same thread are able to attach the
     * events they create to the span, exiting unregisters it. For this to
     * work, exiting a span must be done on the same thread where it was
     * entered. It is possible to enter a span on multiple threads, in which
     * case it should also be exited on all of them individually; that is,
     * unless you *want* the span to be attached to all further events created
     * on that thread.
     */
    constructor(`file`: kotlin.String, `line`: kotlin.UInt?, `level`: LogLevel, `target`: kotlin.String, `name`: kotlin.String) :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_constructor_span_new(
        FfiConverterString.lower(`file`),FfiConverterOptionalUInt.lower(`line`),FfiConverterTypeLogLevel.lower(`level`),FfiConverterString.lower(`target`),FfiConverterString.lower(`name`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_span(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_span(pointer!!, status)
        }
    }

    override fun `enter`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_span_enter(
        it, _status)
}
    }
    
    

    override fun `exit`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_span_exit(
        it, _status)
}
    }
    
    

    override fun `isNone`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_span_is_none(
        it, _status)
}
    }
    )
    }
    

    

    
    companion object {
         fun `current`(): Span {
            return FfiConverterTypeSpan.lift(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_constructor_span_current(
        _status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeSpan: FfiConverter<Span, Pointer> {

    override fun lower(value: Span): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Span {
        return Span(value)
    }

    override fun read(buf: ByteBuffer): Span {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Span) = 8UL

    override fun write(value: Span, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface SyncServiceInterface {
    
    fun `roomListService`(): RoomListService
    
    suspend fun `start`()
    
    fun `state`(`listener`: SyncServiceStateObserver): TaskHandle
    
    suspend fun `stop`()
    
    companion object
}

open class SyncService: Disposable, AutoCloseable, SyncServiceInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_syncservice(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_syncservice(pointer!!, status)
        }
    }

    override fun `roomListService`(): RoomListService {
            return FfiConverterTypeRoomListService.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_syncservice_room_list_service(
        it, _status)
}
    }
    )
    }
    

    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `start`() {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_syncservice_start(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        UniffiNullRustCallStatusErrorHandler,
    )
    }

    override fun `state`(`listener`: SyncServiceStateObserver): TaskHandle {
            return FfiConverterTypeTaskHandle.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_syncservice_state(
        it, FfiConverterTypeSyncServiceStateObserver.lower(`listener`),_status)
}
    }
    )
    }
    

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `stop`() {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_syncservice_stop(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

public object FfiConverterTypeSyncService: FfiConverter<SyncService, Pointer> {

    override fun lower(value: SyncService): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): SyncService {
        return SyncService(value)
    }

    override fun read(buf: ByteBuffer): SyncService {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SyncService) = 8UL

    override fun write(value: SyncService, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface SyncServiceBuilderInterface {
    
    suspend fun `finish`(): SyncService
    
    fun `withCrossProcessLock`(`appIdentifier`: kotlin.String?): SyncServiceBuilder
    
    suspend fun `withUtdHook`(`delegate`: UnableToDecryptDelegate): SyncServiceBuilder
    
    companion object
}

open class SyncServiceBuilder: Disposable, AutoCloseable, SyncServiceBuilderInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_syncservicebuilder(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_syncservicebuilder(pointer!!, status)
        }
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `finish`() : SyncService {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_syncservicebuilder_finish(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeSyncService.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    override fun `withCrossProcessLock`(`appIdentifier`: kotlin.String?): SyncServiceBuilder {
            return FfiConverterTypeSyncServiceBuilder.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_syncservicebuilder_with_cross_process_lock(
        it, FfiConverterOptionalString.lower(`appIdentifier`),_status)
}
    }
    )
    }
    

    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `withUtdHook`(`delegate`: UnableToDecryptDelegate) : SyncServiceBuilder {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_syncservicebuilder_with_utd_hook(
                thisPtr,
                FfiConverterTypeUnableToDecryptDelegate.lower(`delegate`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeSyncServiceBuilder.lift(it) },
        // Error FFI converter
        UniffiNullRustCallStatusErrorHandler,
    )
    }

    

    
    
    companion object
    
}

public object FfiConverterTypeSyncServiceBuilder: FfiConverter<SyncServiceBuilder, Pointer> {

    override fun lower(value: SyncServiceBuilder): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): SyncServiceBuilder {
        return SyncServiceBuilder(value)
    }

    override fun read(buf: ByteBuffer): SyncServiceBuilder {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: SyncServiceBuilder) = 8UL

    override fun write(value: SyncServiceBuilder, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * A task handle is a way to keep the handle a task running by itself in
 * detached mode.
 *
 * It's a thin wrapper around [`JoinHandle`].
 */
public interface TaskHandleInterface {
    
    fun `cancel`()
    
    /**
     * Check whether the handle is finished.
     */
    fun `isFinished`(): kotlin.Boolean
    
    companion object
}

/**
 * A task handle is a way to keep the handle a task running by itself in
 * detached mode.
 *
 * It's a thin wrapper around [`JoinHandle`].
 */
open class TaskHandle: Disposable, AutoCloseable, TaskHandleInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_taskhandle(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_taskhandle(pointer!!, status)
        }
    }

    override fun `cancel`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_taskhandle_cancel(
        it, _status)
}
    }
    
    

    
    /**
     * Check whether the handle is finished.
     */override fun `isFinished`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_taskhandle_is_finished(
        it, _status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeTaskHandle: FfiConverter<TaskHandle, Pointer> {

    override fun lower(value: TaskHandle): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): TaskHandle {
        return TaskHandle(value)
    }

    override fun read(buf: ByteBuffer): TaskHandle {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: TaskHandle) = 8UL

    override fun write(value: TaskHandle, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface TimelineInterface {
    
    suspend fun `addListener`(`listener`: TimelineListener): TaskHandle
    
    suspend fun `createPoll`(`question`: kotlin.String, `answers`: List<kotlin.String>, `maxSelections`: kotlin.UByte, `pollKind`: PollKind)
    
    suspend fun `edit`(`newContent`: RoomMessageEventContentWithoutRelation, `editItem`: EventTimelineItem)
    
    suspend fun `editPoll`(`question`: kotlin.String, `answers`: List<kotlin.String>, `maxSelections`: kotlin.UByte, `pollKind`: PollKind, `editItem`: EventTimelineItem)
    
    fun `endPoll`(`pollStartId`: kotlin.String, `text`: kotlin.String)
    
    suspend fun `fetchDetailsForEvent`(`eventId`: kotlin.String)
    
    suspend fun `fetchMembers`()
    
    /**
     * Paginate forwards, when in focused mode.
     *
     * Returns whether we hit the end of the timeline or not.
     */
    suspend fun `focusedPaginateForwards`(`numEvents`: kotlin.UShort): kotlin.Boolean
    
    /**
     * Get the current timeline item for the given event ID, if any.
     *
     * Will return a remote event, *or* a local echo that has been sent but not
     * yet replaced by a remote echo.
     *
     * It's preferable to store the timeline items in the model for your UI, if
     * possible, instead of just storing IDs and coming back to the timeline
     * object to look up items.
     */
    suspend fun `getEventTimelineItemByEventId`(`eventId`: kotlin.String): EventTimelineItem
    
    /**
     * Get the current timeline item for the given transaction ID, if any.
     *
     * This will always return a local echo, if found.
     *
     * It's preferable to store the timeline items in the model for your UI, if
     * possible, instead of just storing IDs and coming back to the timeline
     * object to look up items.
     */
    suspend fun `getEventTimelineItemByTransactionId`(`transactionId`: kotlin.String): EventTimelineItem
    
    /**
     * Load the reply details for the given event id.
     *
     * This will return an `InReplyToDetails` object that contains the details
     * which will either be ready or an error.
     */
    suspend fun `loadReplyDetails`(`eventIdStr`: kotlin.String): InReplyToDetails
    
    /**
     * Mark the room as read by trying to attach an *unthreaded* read receipt
     * to the latest room event.
     *
     * This works even if the latest event belongs to a thread, as a threaded
     * reply also belongs to the unthreaded timeline. No threaded receipt
     * will be sent here (see also #3123).
     */
    suspend fun `markAsRead`(`receiptType`: ReceiptType)
    
    /**
     * Paginate backwards, whether we are in focused mode or in live mode.
     *
     * Returns whether we hit the end of the timeline or not.
     */
    suspend fun `paginateBackwards`(`numEvents`: kotlin.UShort): kotlin.Boolean
    
    /**
     * Redacts an event from the timeline.
     *
     * Only works for events that exist as timeline items.
     *
     * If it was a local event, this will *try* to cancel it, if it was not
     * being sent already. If the event was a remote event, then it will be
     * redacted by sending a redaction request to the server.
     *
     * Returns whether the redaction did happen. It can only return false for
     * local events that are being processed.
     */
    suspend fun `redactEvent`(`item`: EventTimelineItem, `reason`: kotlin.String?): kotlin.Boolean
    
    fun `retryDecryption`(`sessionIds`: List<kotlin.String>)
    
    /**
     * Queues an event in the room's send queue so it's processed for
     * sending later.
     *
     * Returns an abort handle that allows to abort sending, if it hasn't
     * happened yet.
     */
    suspend fun `send`(`msg`: RoomMessageEventContentWithoutRelation): AbortSendHandle
    
    fun `sendAudio`(`url`: kotlin.String, `audioInfo`: AudioInfo, `caption`: kotlin.String?, `formattedCaption`: FormattedBody?, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle
    
    fun `sendFile`(`url`: kotlin.String, `fileInfo`: FileInfo, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle
    
    fun `sendImage`(`url`: kotlin.String, `thumbnailUrl`: kotlin.String?, `imageInfo`: ImageInfo, `caption`: kotlin.String?, `formattedCaption`: FormattedBody?, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle
    
    suspend fun `sendLocation`(`body`: kotlin.String, `geoUri`: kotlin.String, `description`: kotlin.String?, `zoomLevel`: kotlin.UByte?, `assetType`: AssetType?)
    
    suspend fun `sendPollResponse`(`pollStartId`: kotlin.String, `answers`: List<kotlin.String>)
    
    suspend fun `sendReadReceipt`(`receiptType`: ReceiptType, `eventId`: kotlin.String)
    
    suspend fun `sendReply`(`msg`: RoomMessageEventContentWithoutRelation, `replyItem`: EventTimelineItem)
    
    fun `sendVideo`(`url`: kotlin.String, `thumbnailUrl`: kotlin.String?, `videoInfo`: VideoInfo, `caption`: kotlin.String?, `formattedCaption`: FormattedBody?, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle
    
    fun `sendVoiceMessage`(`url`: kotlin.String, `audioInfo`: AudioInfo, `waveform`: List<kotlin.UShort>, `caption`: kotlin.String?, `formattedCaption`: FormattedBody?, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle
    
    suspend fun `subscribeToBackPaginationStatus`(`listener`: PaginationStatusListener): TaskHandle
    
    suspend fun `toggleReaction`(`eventId`: kotlin.String, `key`: kotlin.String)
    
    companion object
}

open class Timeline: Disposable, AutoCloseable, TimelineInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_timeline(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_timeline(pointer!!, status)
        }
    }

    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `addListener`(`listener`: TimelineListener) : TaskHandle {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_add_listener(
                thisPtr,
                FfiConverterTypeTimelineListener.lower(`listener`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeTaskHandle.lift(it) },
        // Error FFI converter
        UniffiNullRustCallStatusErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `createPoll`(`question`: kotlin.String, `answers`: List<kotlin.String>, `maxSelections`: kotlin.UByte, `pollKind`: PollKind) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_create_poll(
                thisPtr,
                FfiConverterString.lower(`question`),FfiConverterSequenceString.lower(`answers`),FfiConverterUByte.lower(`maxSelections`),FfiConverterTypePollKind.lower(`pollKind`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `edit`(`newContent`: RoomMessageEventContentWithoutRelation, `editItem`: EventTimelineItem) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_edit(
                thisPtr,
                FfiConverterTypeRoomMessageEventContentWithoutRelation.lower(`newContent`),FfiConverterTypeEventTimelineItem.lower(`editItem`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `editPoll`(`question`: kotlin.String, `answers`: List<kotlin.String>, `maxSelections`: kotlin.UByte, `pollKind`: PollKind, `editItem`: EventTimelineItem) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_edit_poll(
                thisPtr,
                FfiConverterString.lower(`question`),FfiConverterSequenceString.lower(`answers`),FfiConverterUByte.lower(`maxSelections`),FfiConverterTypePollKind.lower(`pollKind`),FfiConverterTypeEventTimelineItem.lower(`editItem`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)override fun `endPoll`(`pollStartId`: kotlin.String, `text`: kotlin.String)
        = 
    callWithPointer {
    uniffiRustCallWithError(ClientException) { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_end_poll(
        it, FfiConverterString.lower(`pollStartId`),FfiConverterString.lower(`text`),_status)
}
    }
    
    

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `fetchDetailsForEvent`(`eventId`: kotlin.String) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_fetch_details_for_event(
                thisPtr,
                FfiConverterString.lower(`eventId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `fetchMembers`() {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_fetch_members(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        UniffiNullRustCallStatusErrorHandler,
    )
    }

    
    /**
     * Paginate forwards, when in focused mode.
     *
     * Returns whether we hit the end of the timeline or not.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `focusedPaginateForwards`(`numEvents`: kotlin.UShort) : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_focused_paginate_forwards(
                thisPtr,
                FfiConverterUShort.lower(`numEvents`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Get the current timeline item for the given event ID, if any.
     *
     * Will return a remote event, *or* a local echo that has been sent but not
     * yet replaced by a remote echo.
     *
     * It's preferable to store the timeline items in the model for your UI, if
     * possible, instead of just storing IDs and coming back to the timeline
     * object to look up items.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getEventTimelineItemByEventId`(`eventId`: kotlin.String) : EventTimelineItem {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_get_event_timeline_item_by_event_id(
                thisPtr,
                FfiConverterString.lower(`eventId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeEventTimelineItem.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Get the current timeline item for the given transaction ID, if any.
     *
     * This will always return a local echo, if found.
     *
     * It's preferable to store the timeline items in the model for your UI, if
     * possible, instead of just storing IDs and coming back to the timeline
     * object to look up items.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getEventTimelineItemByTransactionId`(`transactionId`: kotlin.String) : EventTimelineItem {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_get_event_timeline_item_by_transaction_id(
                thisPtr,
                FfiConverterString.lower(`transactionId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeEventTimelineItem.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Load the reply details for the given event id.
     *
     * This will return an `InReplyToDetails` object that contains the details
     * which will either be ready or an error.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `loadReplyDetails`(`eventIdStr`: kotlin.String) : InReplyToDetails {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_load_reply_details(
                thisPtr,
                FfiConverterString.lower(`eventIdStr`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeInReplyToDetails.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Mark the room as read by trying to attach an *unthreaded* read receipt
     * to the latest room event.
     *
     * This works even if the latest event belongs to a thread, as a threaded
     * reply also belongs to the unthreaded timeline. No threaded receipt
     * will be sent here (see also #3123).
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `markAsRead`(`receiptType`: ReceiptType) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_mark_as_read(
                thisPtr,
                FfiConverterTypeReceiptType.lower(`receiptType`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Paginate backwards, whether we are in focused mode or in live mode.
     *
     * Returns whether we hit the end of the timeline or not.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `paginateBackwards`(`numEvents`: kotlin.UShort) : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_paginate_backwards(
                thisPtr,
                FfiConverterUShort.lower(`numEvents`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    /**
     * Redacts an event from the timeline.
     *
     * Only works for events that exist as timeline items.
     *
     * If it was a local event, this will *try* to cancel it, if it was not
     * being sent already. If the event was a remote event, then it will be
     * redacted by sending a redaction request to the server.
     *
     * Returns whether the redaction did happen. It can only return false for
     * local events that are being processed.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `redactEvent`(`item`: EventTimelineItem, `reason`: kotlin.String?) : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_redact_event(
                thisPtr,
                FfiConverterTypeEventTimelineItem.lower(`item`),FfiConverterOptionalString.lower(`reason`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    override fun `retryDecryption`(`sessionIds`: List<kotlin.String>)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_retry_decryption(
        it, FfiConverterSequenceString.lower(`sessionIds`),_status)
}
    }
    
    

    
    /**
     * Queues an event in the room's send queue so it's processed for
     * sending later.
     *
     * Returns an abort handle that allows to abort sending, if it hasn't
     * happened yet.
     */
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `send`(`msg`: RoomMessageEventContentWithoutRelation) : AbortSendHandle {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_send(
                thisPtr,
                FfiConverterTypeRoomMessageEventContentWithoutRelation.lower(`msg`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeAbortSendHandle.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    override fun `sendAudio`(`url`: kotlin.String, `audioInfo`: AudioInfo, `caption`: kotlin.String?, `formattedCaption`: FormattedBody?, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle {
            return FfiConverterTypeSendAttachmentJoinHandle.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_send_audio(
        it, FfiConverterString.lower(`url`),FfiConverterTypeAudioInfo.lower(`audioInfo`),FfiConverterOptionalString.lower(`caption`),FfiConverterOptionalTypeFormattedBody.lower(`formattedCaption`),FfiConverterOptionalTypeProgressWatcher.lower(`progressWatcher`),_status)
}
    }
    )
    }
    

    override fun `sendFile`(`url`: kotlin.String, `fileInfo`: FileInfo, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle {
            return FfiConverterTypeSendAttachmentJoinHandle.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_send_file(
        it, FfiConverterString.lower(`url`),FfiConverterTypeFileInfo.lower(`fileInfo`),FfiConverterOptionalTypeProgressWatcher.lower(`progressWatcher`),_status)
}
    }
    )
    }
    

    override fun `sendImage`(`url`: kotlin.String, `thumbnailUrl`: kotlin.String?, `imageInfo`: ImageInfo, `caption`: kotlin.String?, `formattedCaption`: FormattedBody?, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle {
            return FfiConverterTypeSendAttachmentJoinHandle.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_send_image(
        it, FfiConverterString.lower(`url`),FfiConverterOptionalString.lower(`thumbnailUrl`),FfiConverterTypeImageInfo.lower(`imageInfo`),FfiConverterOptionalString.lower(`caption`),FfiConverterOptionalTypeFormattedBody.lower(`formattedCaption`),FfiConverterOptionalTypeProgressWatcher.lower(`progressWatcher`),_status)
}
    }
    )
    }
    

    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `sendLocation`(`body`: kotlin.String, `geoUri`: kotlin.String, `description`: kotlin.String?, `zoomLevel`: kotlin.UByte?, `assetType`: AssetType?) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_send_location(
                thisPtr,
                FfiConverterString.lower(`body`),FfiConverterString.lower(`geoUri`),FfiConverterOptionalString.lower(`description`),FfiConverterOptionalUByte.lower(`zoomLevel`),FfiConverterOptionalTypeAssetType.lower(`assetType`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        UniffiNullRustCallStatusErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `sendPollResponse`(`pollStartId`: kotlin.String, `answers`: List<kotlin.String>) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_send_poll_response(
                thisPtr,
                FfiConverterString.lower(`pollStartId`),FfiConverterSequenceString.lower(`answers`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `sendReadReceipt`(`receiptType`: ReceiptType, `eventId`: kotlin.String) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_send_read_receipt(
                thisPtr,
                FfiConverterTypeReceiptType.lower(`receiptType`),FfiConverterString.lower(`eventId`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `sendReply`(`msg`: RoomMessageEventContentWithoutRelation, `replyItem`: EventTimelineItem) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_send_reply(
                thisPtr,
                FfiConverterTypeRoomMessageEventContentWithoutRelation.lower(`msg`),FfiConverterTypeEventTimelineItem.lower(`replyItem`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    override fun `sendVideo`(`url`: kotlin.String, `thumbnailUrl`: kotlin.String?, `videoInfo`: VideoInfo, `caption`: kotlin.String?, `formattedCaption`: FormattedBody?, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle {
            return FfiConverterTypeSendAttachmentJoinHandle.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_send_video(
        it, FfiConverterString.lower(`url`),FfiConverterOptionalString.lower(`thumbnailUrl`),FfiConverterTypeVideoInfo.lower(`videoInfo`),FfiConverterOptionalString.lower(`caption`),FfiConverterOptionalTypeFormattedBody.lower(`formattedCaption`),FfiConverterOptionalTypeProgressWatcher.lower(`progressWatcher`),_status)
}
    }
    )
    }
    

    override fun `sendVoiceMessage`(`url`: kotlin.String, `audioInfo`: AudioInfo, `waveform`: List<kotlin.UShort>, `caption`: kotlin.String?, `formattedCaption`: FormattedBody?, `progressWatcher`: ProgressWatcher?): SendAttachmentJoinHandle {
            return FfiConverterTypeSendAttachmentJoinHandle.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_send_voice_message(
        it, FfiConverterString.lower(`url`),FfiConverterTypeAudioInfo.lower(`audioInfo`),FfiConverterSequenceUShort.lower(`waveform`),FfiConverterOptionalString.lower(`caption`),FfiConverterOptionalTypeFormattedBody.lower(`formattedCaption`),FfiConverterOptionalTypeProgressWatcher.lower(`progressWatcher`),_status)
}
    }
    )
    }
    

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `subscribeToBackPaginationStatus`(`listener`: PaginationStatusListener) : TaskHandle {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_subscribe_to_back_pagination_status(
                thisPtr,
                FfiConverterTypePaginationStatusListener.lower(`listener`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeTaskHandle.lift(it) },
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    
    @Throws(ClientException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `toggleReaction`(`eventId`: kotlin.String, `key`: kotlin.String) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timeline_toggle_reaction(
                thisPtr,
                FfiConverterString.lower(`eventId`),FfiConverterString.lower(`key`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        ClientException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

public object FfiConverterTypeTimeline: FfiConverter<Timeline, Pointer> {

    override fun lower(value: Timeline): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): Timeline {
        return Timeline(value)
    }

    override fun read(buf: ByteBuffer): Timeline {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Timeline) = 8UL

    override fun write(value: Timeline, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface TimelineDiffInterface {
    
    fun `append`(): List<TimelineItem>?
    
    fun `change`(): TimelineChange
    
    fun `insert`(): InsertData?
    
    fun `pushBack`(): TimelineItem?
    
    fun `pushFront`(): TimelineItem?
    
    fun `remove`(): kotlin.UInt?
    
    fun `reset`(): List<TimelineItem>?
    
    fun `set`(): SetData?
    
    companion object
}

open class TimelineDiff: Disposable, AutoCloseable, TimelineDiffInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_timelinediff(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_timelinediff(pointer!!, status)
        }
    }

    override fun `append`(): List<TimelineItem>? {
            return FfiConverterOptionalSequenceTypeTimelineItem.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_append(
        it, _status)
}
    }
    )
    }
    

    override fun `change`(): TimelineChange {
            return FfiConverterTypeTimelineChange.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_change(
        it, _status)
}
    }
    )
    }
    

    override fun `insert`(): InsertData? {
            return FfiConverterOptionalTypeInsertData.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_insert(
        it, _status)
}
    }
    )
    }
    

    override fun `pushBack`(): TimelineItem? {
            return FfiConverterOptionalTypeTimelineItem.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_push_back(
        it, _status)
}
    }
    )
    }
    

    override fun `pushFront`(): TimelineItem? {
            return FfiConverterOptionalTypeTimelineItem.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_push_front(
        it, _status)
}
    }
    )
    }
    

    override fun `remove`(): kotlin.UInt? {
            return FfiConverterOptionalUInt.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_remove(
        it, _status)
}
    }
    )
    }
    

    override fun `reset`(): List<TimelineItem>? {
            return FfiConverterOptionalSequenceTypeTimelineItem.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_reset(
        it, _status)
}
    }
    )
    }
    

    override fun `set`(): SetData? {
            return FfiConverterOptionalTypeSetData.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelinediff_set(
        it, _status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeTimelineDiff: FfiConverter<TimelineDiff, Pointer> {

    override fun lower(value: TimelineDiff): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): TimelineDiff {
        return TimelineDiff(value)
    }

    override fun read(buf: ByteBuffer): TimelineDiff {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: TimelineDiff) = 8UL

    override fun write(value: TimelineDiff, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface TimelineEventInterface {
    
    fun `eventId`(): kotlin.String
    
    fun `eventType`(): TimelineEventType
    
    fun `senderId`(): kotlin.String
    
    fun `timestamp`(): kotlin.ULong
    
    companion object
}

open class TimelineEvent: Disposable, AutoCloseable, TimelineEventInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_timelineevent(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_timelineevent(pointer!!, status)
        }
    }

    override fun `eventId`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineevent_event_id(
        it, _status)
}
    }
    )
    }
    

    
    @Throws(ClientException::class)override fun `eventType`(): TimelineEventType {
            return FfiConverterTypeTimelineEventType.lift(
    callWithPointer {
    uniffiRustCallWithError(ClientException) { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineevent_event_type(
        it, _status)
}
    }
    )
    }
    

    override fun `senderId`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineevent_sender_id(
        it, _status)
}
    }
    )
    }
    

    override fun `timestamp`(): kotlin.ULong {
            return FfiConverterULong.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineevent_timestamp(
        it, _status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeTimelineEvent: FfiConverter<TimelineEvent, Pointer> {

    override fun lower(value: TimelineEvent): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): TimelineEvent {
        return TimelineEvent(value)
    }

    override fun read(buf: ByteBuffer): TimelineEvent {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: TimelineEvent) = 8UL

    override fun write(value: TimelineEvent, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface TimelineEventTypeFilterInterface {
    
    companion object
}

open class TimelineEventTypeFilter: Disposable, AutoCloseable, TimelineEventTypeFilterInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_timelineeventtypefilter(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_timelineeventtypefilter(pointer!!, status)
        }
    }

    

    
    companion object {
         fun `exclude`(`eventTypes`: List<FilterTimelineEventType>): TimelineEventTypeFilter {
            return FfiConverterTypeTimelineEventTypeFilter.lift(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_constructor_timelineeventtypefilter_exclude(
        FfiConverterSequenceTypeFilterTimelineEventType.lower(`eventTypes`),_status)
}
    )
    }
    

         fun `include`(`eventTypes`: List<FilterTimelineEventType>): TimelineEventTypeFilter {
            return FfiConverterTypeTimelineEventTypeFilter.lift(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_constructor_timelineeventtypefilter_include(
        FfiConverterSequenceTypeFilterTimelineEventType.lower(`eventTypes`),_status)
}
    )
    }
    

        
    }
    
}

public object FfiConverterTypeTimelineEventTypeFilter: FfiConverter<TimelineEventTypeFilter, Pointer> {

    override fun lower(value: TimelineEventTypeFilter): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): TimelineEventTypeFilter {
        return TimelineEventTypeFilter(value)
    }

    override fun read(buf: ByteBuffer): TimelineEventTypeFilter {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: TimelineEventTypeFilter) = 8UL

    override fun write(value: TimelineEventTypeFilter, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface TimelineItemInterface {
    
    fun `asEvent`(): EventTimelineItem?
    
    fun `asVirtual`(): VirtualTimelineItem?
    
    fun `fmtDebug`(): kotlin.String
    
    fun `uniqueId`(): kotlin.String
    
    companion object
}

open class TimelineItem: Disposable, AutoCloseable, TimelineItemInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_timelineitem(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_timelineitem(pointer!!, status)
        }
    }

    override fun `asEvent`(): EventTimelineItem? {
            return FfiConverterOptionalTypeEventTimelineItem.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineitem_as_event(
        it, _status)
}
    }
    )
    }
    

    override fun `asVirtual`(): VirtualTimelineItem? {
            return FfiConverterOptionalTypeVirtualTimelineItem.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineitem_as_virtual(
        it, _status)
}
    }
    )
    }
    

    override fun `fmtDebug`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineitem_fmt_debug(
        it, _status)
}
    }
    )
    }
    

    override fun `uniqueId`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineitem_unique_id(
        it, _status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeTimelineItem: FfiConverter<TimelineItem, Pointer> {

    override fun lower(value: TimelineItem): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): TimelineItem {
        return TimelineItem(value)
    }

    override fun read(buf: ByteBuffer): TimelineItem {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: TimelineItem) = 8UL

    override fun write(value: TimelineItem, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface TimelineItemContentInterface {
    
    fun `asMessage`(): Message?
    
    fun `kind`(): TimelineItemContentKind
    
    companion object
}

open class TimelineItemContent: Disposable, AutoCloseable, TimelineItemContentInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_timelineitemcontent(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_timelineitemcontent(pointer!!, status)
        }
    }

    override fun `asMessage`(): Message? {
            return FfiConverterOptionalTypeMessage.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineitemcontent_as_message(
        it, _status)
}
    }
    )
    }
    

    override fun `kind`(): TimelineItemContentKind {
            return FfiConverterTypeTimelineItemContentKind.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_timelineitemcontent_kind(
        it, _status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeTimelineItemContent: FfiConverter<TimelineItemContent, Pointer> {

    override fun lower(value: TimelineItemContent): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): TimelineItemContent {
        return TimelineItemContent(value)
    }

    override fun read(buf: ByteBuffer): TimelineItemContent {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: TimelineItemContent) = 8UL

    override fun write(value: TimelineItemContent, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface UnreadNotificationsCountInterface {
    
    fun `hasNotifications`(): kotlin.Boolean
    
    fun `highlightCount`(): kotlin.UInt
    
    fun `notificationCount`(): kotlin.UInt
    
    companion object
}

open class UnreadNotificationsCount: Disposable, AutoCloseable, UnreadNotificationsCountInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_unreadnotificationscount(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_unreadnotificationscount(pointer!!, status)
        }
    }

    override fun `hasNotifications`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_unreadnotificationscount_has_notifications(
        it, _status)
}
    }
    )
    }
    

    override fun `highlightCount`(): kotlin.UInt {
            return FfiConverterUInt.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_unreadnotificationscount_highlight_count(
        it, _status)
}
    }
    )
    }
    

    override fun `notificationCount`(): kotlin.UInt {
            return FfiConverterUInt.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_unreadnotificationscount_notification_count(
        it, _status)
}
    }
    )
    }
    

    

    
    
    companion object
    
}

public object FfiConverterTypeUnreadNotificationsCount: FfiConverter<UnreadNotificationsCount, Pointer> {

    override fun lower(value: UnreadNotificationsCount): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): UnreadNotificationsCount {
        return UnreadNotificationsCount(value)
    }

    override fun read(buf: ByteBuffer): UnreadNotificationsCount {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: UnreadNotificationsCount) = 8UL

    override fun write(value: UnreadNotificationsCount, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * An object that handles all interactions of a widget living inside a webview
 * or IFrame with the Matrix world.
 */
public interface WidgetDriverInterface {
    
    suspend fun `run`(`room`: Room, `capabilitiesProvider`: WidgetCapabilitiesProvider)
    
    companion object
}

/**
 * An object that handles all interactions of a widget living inside a webview
 * or IFrame with the Matrix world.
 */
open class WidgetDriver: Disposable, AutoCloseable, WidgetDriverInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_widgetdriver(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_widgetdriver(pointer!!, status)
        }
    }

    
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `run`(`room`: Room, `capabilitiesProvider`: WidgetCapabilitiesProvider) {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_widgetdriver_run(
                thisPtr,
                FfiConverterTypeRoom.lower(`room`),FfiConverterTypeWidgetCapabilitiesProvider.lower(`capabilitiesProvider`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_void(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_void(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_void(future) },
        // lift function
        { Unit },
        
        // Error FFI converter
        UniffiNullRustCallStatusErrorHandler,
    )
    }

    

    
    
    companion object
    
}

public object FfiConverterTypeWidgetDriver: FfiConverter<WidgetDriver, Pointer> {

    override fun lower(value: WidgetDriver): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): WidgetDriver {
        return WidgetDriver(value)
    }

    override fun read(buf: ByteBuffer): WidgetDriver {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: WidgetDriver) = 8UL

    override fun write(value: WidgetDriver, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * A handle that encapsulates the communication between a widget driver and the
 * corresponding widget (inside a webview or IFrame).
 */
public interface WidgetDriverHandleInterface {
    
    /**
     * Receive a message from the widget driver.
     *
     * The message must be passed on to the widget.
     *
     * Returns `None` if the widget driver is no longer running.
     */
    suspend fun `recv`(): kotlin.String?
    
    /**
     *
     * Returns `false` if the widget driver is no longer running.
     */
    suspend fun `send`(`msg`: kotlin.String): kotlin.Boolean
    
    companion object
}

/**
 * A handle that encapsulates the communication between a widget driver and the
 * corresponding widget (inside a webview or IFrame).
 */
open class WidgetDriverHandle: Disposable, AutoCloseable, WidgetDriverHandleInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_free_widgetdriverhandle(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_clone_widgetdriverhandle(pointer!!, status)
        }
    }

    
    /**
     * Receive a message from the widget driver.
     *
     * The message must be passed on to the widget.
     *
     * Returns `None` if the widget driver is no longer running.
     */
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `recv`() : kotlin.String? {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_widgetdriverhandle_recv(
                thisPtr,
                
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterOptionalString.lift(it) },
        // Error FFI converter
        UniffiNullRustCallStatusErrorHandler,
    )
    }

    
    /**
     *
     * Returns `false` if the widget driver is no longer running.
     */
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `send`(`msg`: kotlin.String) : kotlin.Boolean {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_matrix_sdk_ffi_fn_method_widgetdriverhandle_send(
                thisPtr,
                FfiConverterString.lower(`msg`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_poll_i8(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_complete_i8(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_matrix_sdk_ffi_rust_future_free_i8(future) },
        // lift function
        { FfiConverterBoolean.lift(it) },
        // Error FFI converter
        UniffiNullRustCallStatusErrorHandler,
    )
    }

    

    
    
    companion object
    
}

public object FfiConverterTypeWidgetDriverHandle: FfiConverter<WidgetDriverHandle, Pointer> {

    override fun lower(value: WidgetDriverHandle): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): WidgetDriverHandle {
        return WidgetDriverHandle(value)
    }

    override fun read(buf: ByteBuffer): WidgetDriverHandle {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: WidgetDriverHandle) = 8UL

    override fun write(value: WidgetDriverHandle, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}



data class AudioInfo (
    var `duration`: java.time.Duration?, 
    var `size`: kotlin.ULong?, 
    var `mimetype`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypeAudioInfo: FfiConverterRustBuffer<AudioInfo> {
    override fun read(buf: ByteBuffer): AudioInfo {
        return AudioInfo(
            FfiConverterOptionalDuration.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: AudioInfo) = (
            FfiConverterOptionalDuration.allocationSize(value.`duration`) +
            FfiConverterOptionalULong.allocationSize(value.`size`) +
            FfiConverterOptionalString.allocationSize(value.`mimetype`)
    )

    override fun write(value: AudioInfo, buf: ByteBuffer) {
            FfiConverterOptionalDuration.write(value.`duration`, buf)
            FfiConverterOptionalULong.write(value.`size`, buf)
            FfiConverterOptionalString.write(value.`mimetype`, buf)
    }
}



data class AudioMessageContent (
    var `body`: kotlin.String, 
    var `formatted`: FormattedBody?, 
    var `filename`: kotlin.String?, 
    var `source`: MediaSource, 
    var `info`: AudioInfo?, 
    var `audio`: UnstableAudioDetailsContent?, 
    var `voice`: UnstableVoiceContent?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`body`, 
        this.`formatted`, 
        this.`filename`, 
        this.`source`, 
        this.`info`, 
        this.`audio`, 
        this.`voice`)
    }
    
    companion object
}

public object FfiConverterTypeAudioMessageContent: FfiConverterRustBuffer<AudioMessageContent> {
    override fun read(buf: ByteBuffer): AudioMessageContent {
        return AudioMessageContent(
            FfiConverterString.read(buf),
            FfiConverterOptionalTypeFormattedBody.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterTypeMediaSource.read(buf),
            FfiConverterOptionalTypeAudioInfo.read(buf),
            FfiConverterOptionalTypeUnstableAudioDetailsContent.read(buf),
            FfiConverterOptionalTypeUnstableVoiceContent.read(buf),
        )
    }

    override fun allocationSize(value: AudioMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterOptionalTypeFormattedBody.allocationSize(value.`formatted`) +
            FfiConverterOptionalString.allocationSize(value.`filename`) +
            FfiConverterTypeMediaSource.allocationSize(value.`source`) +
            FfiConverterOptionalTypeAudioInfo.allocationSize(value.`info`) +
            FfiConverterOptionalTypeUnstableAudioDetailsContent.allocationSize(value.`audio`) +
            FfiConverterOptionalTypeUnstableVoiceContent.allocationSize(value.`voice`)
    )

    override fun write(value: AudioMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterOptionalTypeFormattedBody.write(value.`formatted`, buf)
            FfiConverterOptionalString.write(value.`filename`, buf)
            FfiConverterTypeMediaSource.write(value.`source`, buf)
            FfiConverterOptionalTypeAudioInfo.write(value.`info`, buf)
            FfiConverterOptionalTypeUnstableAudioDetailsContent.write(value.`audio`, buf)
            FfiConverterOptionalTypeUnstableVoiceContent.write(value.`voice`, buf)
    }
}



data class ClientProperties (
    /**
     * The client_id provides the widget with the option to behave differently
     * for different clients. e.g org.example.ios.
     */
    var `clientId`: kotlin.String, 
    /**
     * The language tag the client is set to e.g. en-us. (Undefined and invalid
     * becomes: `en-US`)
     */
    var `languageTag`: kotlin.String?, 
    /**
     * A string describing the theme (dark, light) or org.example.dark.
     * (default: `light`)
     */
    var `theme`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypeClientProperties: FfiConverterRustBuffer<ClientProperties> {
    override fun read(buf: ByteBuffer): ClientProperties {
        return ClientProperties(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: ClientProperties) = (
            FfiConverterString.allocationSize(value.`clientId`) +
            FfiConverterOptionalString.allocationSize(value.`languageTag`) +
            FfiConverterOptionalString.allocationSize(value.`theme`)
    )

    override fun write(value: ClientProperties, buf: ByteBuffer) {
            FfiConverterString.write(value.`clientId`, buf)
            FfiConverterOptionalString.write(value.`languageTag`, buf)
            FfiConverterOptionalString.write(value.`theme`, buf)
    }
}



data class CreateRoomParameters (
    var `name`: kotlin.String?, 
    var `topic`: kotlin.String? = null, 
    var `isEncrypted`: kotlin.Boolean, 
    var `isDirect`: kotlin.Boolean = false, 
    var `visibility`: RoomVisibility, 
    var `preset`: RoomPreset, 
    var `invite`: List<kotlin.String>? = null, 
    var `avatar`: kotlin.String? = null, 
    var `powerLevelContentOverride`: PowerLevels? = null
) {
    
    companion object
}

public object FfiConverterTypeCreateRoomParameters: FfiConverterRustBuffer<CreateRoomParameters> {
    override fun read(buf: ByteBuffer): CreateRoomParameters {
        return CreateRoomParameters(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterTypeRoomVisibility.read(buf),
            FfiConverterTypeRoomPreset.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalTypePowerLevels.read(buf),
        )
    }

    override fun allocationSize(value: CreateRoomParameters) = (
            FfiConverterOptionalString.allocationSize(value.`name`) +
            FfiConverterOptionalString.allocationSize(value.`topic`) +
            FfiConverterBoolean.allocationSize(value.`isEncrypted`) +
            FfiConverterBoolean.allocationSize(value.`isDirect`) +
            FfiConverterTypeRoomVisibility.allocationSize(value.`visibility`) +
            FfiConverterTypeRoomPreset.allocationSize(value.`preset`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`invite`) +
            FfiConverterOptionalString.allocationSize(value.`avatar`) +
            FfiConverterOptionalTypePowerLevels.allocationSize(value.`powerLevelContentOverride`)
    )

    override fun write(value: CreateRoomParameters, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`name`, buf)
            FfiConverterOptionalString.write(value.`topic`, buf)
            FfiConverterBoolean.write(value.`isEncrypted`, buf)
            FfiConverterBoolean.write(value.`isDirect`, buf)
            FfiConverterTypeRoomVisibility.write(value.`visibility`, buf)
            FfiConverterTypeRoomPreset.write(value.`preset`, buf)
            FfiConverterOptionalSequenceString.write(value.`invite`, buf)
            FfiConverterOptionalString.write(value.`avatar`, buf)
            FfiConverterOptionalTypePowerLevels.write(value.`powerLevelContentOverride`, buf)
    }
}



data class EmoteMessageContent (
    var `body`: kotlin.String, 
    var `formatted`: FormattedBody?
) {
    
    companion object
}

public object FfiConverterTypeEmoteMessageContent: FfiConverterRustBuffer<EmoteMessageContent> {
    override fun read(buf: ByteBuffer): EmoteMessageContent {
        return EmoteMessageContent(
            FfiConverterString.read(buf),
            FfiConverterOptionalTypeFormattedBody.read(buf),
        )
    }

    override fun allocationSize(value: EmoteMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterOptionalTypeFormattedBody.allocationSize(value.`formatted`)
    )

    override fun write(value: EmoteMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterOptionalTypeFormattedBody.write(value.`formatted`, buf)
    }
}



data class EventTimelineItemDebugInfo (
    var `model`: kotlin.String, 
    var `originalJson`: kotlin.String?, 
    var `latestEditJson`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypeEventTimelineItemDebugInfo: FfiConverterRustBuffer<EventTimelineItemDebugInfo> {
    override fun read(buf: ByteBuffer): EventTimelineItemDebugInfo {
        return EventTimelineItemDebugInfo(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: EventTimelineItemDebugInfo) = (
            FfiConverterString.allocationSize(value.`model`) +
            FfiConverterOptionalString.allocationSize(value.`originalJson`) +
            FfiConverterOptionalString.allocationSize(value.`latestEditJson`)
    )

    override fun write(value: EventTimelineItemDebugInfo, buf: ByteBuffer) {
            FfiConverterString.write(value.`model`, buf)
            FfiConverterOptionalString.write(value.`originalJson`, buf)
            FfiConverterOptionalString.write(value.`latestEditJson`, buf)
    }
}



data class FileInfo (
    var `mimetype`: kotlin.String?, 
    var `size`: kotlin.ULong?, 
    var `thumbnailInfo`: ThumbnailInfo?, 
    var `thumbnailSource`: MediaSource?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`mimetype`, 
        this.`size`, 
        this.`thumbnailInfo`, 
        this.`thumbnailSource`)
    }
    
    companion object
}

public object FfiConverterTypeFileInfo: FfiConverterRustBuffer<FileInfo> {
    override fun read(buf: ByteBuffer): FileInfo {
        return FileInfo(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalTypeThumbnailInfo.read(buf),
            FfiConverterOptionalTypeMediaSource.read(buf),
        )
    }

    override fun allocationSize(value: FileInfo) = (
            FfiConverterOptionalString.allocationSize(value.`mimetype`) +
            FfiConverterOptionalULong.allocationSize(value.`size`) +
            FfiConverterOptionalTypeThumbnailInfo.allocationSize(value.`thumbnailInfo`) +
            FfiConverterOptionalTypeMediaSource.allocationSize(value.`thumbnailSource`)
    )

    override fun write(value: FileInfo, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`mimetype`, buf)
            FfiConverterOptionalULong.write(value.`size`, buf)
            FfiConverterOptionalTypeThumbnailInfo.write(value.`thumbnailInfo`, buf)
            FfiConverterOptionalTypeMediaSource.write(value.`thumbnailSource`, buf)
    }
}



data class FileMessageContent (
    var `body`: kotlin.String, 
    var `formatted`: FormattedBody?, 
    var `filename`: kotlin.String?, 
    var `source`: MediaSource, 
    var `info`: FileInfo?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`body`, 
        this.`formatted`, 
        this.`filename`, 
        this.`source`, 
        this.`info`)
    }
    
    companion object
}

public object FfiConverterTypeFileMessageContent: FfiConverterRustBuffer<FileMessageContent> {
    override fun read(buf: ByteBuffer): FileMessageContent {
        return FileMessageContent(
            FfiConverterString.read(buf),
            FfiConverterOptionalTypeFormattedBody.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterTypeMediaSource.read(buf),
            FfiConverterOptionalTypeFileInfo.read(buf),
        )
    }

    override fun allocationSize(value: FileMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterOptionalTypeFormattedBody.allocationSize(value.`formatted`) +
            FfiConverterOptionalString.allocationSize(value.`filename`) +
            FfiConverterTypeMediaSource.allocationSize(value.`source`) +
            FfiConverterOptionalTypeFileInfo.allocationSize(value.`info`)
    )

    override fun write(value: FileMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterOptionalTypeFormattedBody.write(value.`formatted`, buf)
            FfiConverterOptionalString.write(value.`filename`, buf)
            FfiConverterTypeMediaSource.write(value.`source`, buf)
            FfiConverterOptionalTypeFileInfo.write(value.`info`, buf)
    }
}



data class FormattedBody (
    var `format`: MessageFormat, 
    var `body`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypeFormattedBody: FfiConverterRustBuffer<FormattedBody> {
    override fun read(buf: ByteBuffer): FormattedBody {
        return FormattedBody(
            FfiConverterTypeMessageFormat.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: FormattedBody) = (
            FfiConverterTypeMessageFormat.allocationSize(value.`format`) +
            FfiConverterString.allocationSize(value.`body`)
    )

    override fun write(value: FormattedBody, buf: ByteBuffer) {
            FfiConverterTypeMessageFormat.write(value.`format`, buf)
            FfiConverterString.write(value.`body`, buf)
    }
}



data class HttpPusherData (
    var `url`: kotlin.String, 
    var `format`: PushFormat?, 
    var `defaultPayload`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypeHttpPusherData: FfiConverterRustBuffer<HttpPusherData> {
    override fun read(buf: ByteBuffer): HttpPusherData {
        return HttpPusherData(
            FfiConverterString.read(buf),
            FfiConverterOptionalTypePushFormat.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: HttpPusherData) = (
            FfiConverterString.allocationSize(value.`url`) +
            FfiConverterOptionalTypePushFormat.allocationSize(value.`format`) +
            FfiConverterOptionalString.allocationSize(value.`defaultPayload`)
    )

    override fun write(value: HttpPusherData, buf: ByteBuffer) {
            FfiConverterString.write(value.`url`, buf)
            FfiConverterOptionalTypePushFormat.write(value.`format`, buf)
            FfiConverterOptionalString.write(value.`defaultPayload`, buf)
    }
}



data class ImageInfo (
    var `height`: kotlin.ULong?, 
    var `width`: kotlin.ULong?, 
    var `mimetype`: kotlin.String?, 
    var `size`: kotlin.ULong?, 
    var `thumbnailInfo`: ThumbnailInfo?, 
    var `thumbnailSource`: MediaSource?, 
    var `blurhash`: kotlin.String?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`height`, 
        this.`width`, 
        this.`mimetype`, 
        this.`size`, 
        this.`thumbnailInfo`, 
        this.`thumbnailSource`, 
        this.`blurhash`)
    }
    
    companion object
}

public object FfiConverterTypeImageInfo: FfiConverterRustBuffer<ImageInfo> {
    override fun read(buf: ByteBuffer): ImageInfo {
        return ImageInfo(
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalTypeThumbnailInfo.read(buf),
            FfiConverterOptionalTypeMediaSource.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: ImageInfo) = (
            FfiConverterOptionalULong.allocationSize(value.`height`) +
            FfiConverterOptionalULong.allocationSize(value.`width`) +
            FfiConverterOptionalString.allocationSize(value.`mimetype`) +
            FfiConverterOptionalULong.allocationSize(value.`size`) +
            FfiConverterOptionalTypeThumbnailInfo.allocationSize(value.`thumbnailInfo`) +
            FfiConverterOptionalTypeMediaSource.allocationSize(value.`thumbnailSource`) +
            FfiConverterOptionalString.allocationSize(value.`blurhash`)
    )

    override fun write(value: ImageInfo, buf: ByteBuffer) {
            FfiConverterOptionalULong.write(value.`height`, buf)
            FfiConverterOptionalULong.write(value.`width`, buf)
            FfiConverterOptionalString.write(value.`mimetype`, buf)
            FfiConverterOptionalULong.write(value.`size`, buf)
            FfiConverterOptionalTypeThumbnailInfo.write(value.`thumbnailInfo`, buf)
            FfiConverterOptionalTypeMediaSource.write(value.`thumbnailSource`, buf)
            FfiConverterOptionalString.write(value.`blurhash`, buf)
    }
}



data class ImageMessageContent (
    var `body`: kotlin.String, 
    var `formatted`: FormattedBody?, 
    var `filename`: kotlin.String?, 
    var `source`: MediaSource, 
    var `info`: ImageInfo?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`body`, 
        this.`formatted`, 
        this.`filename`, 
        this.`source`, 
        this.`info`)
    }
    
    companion object
}

public object FfiConverterTypeImageMessageContent: FfiConverterRustBuffer<ImageMessageContent> {
    override fun read(buf: ByteBuffer): ImageMessageContent {
        return ImageMessageContent(
            FfiConverterString.read(buf),
            FfiConverterOptionalTypeFormattedBody.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterTypeMediaSource.read(buf),
            FfiConverterOptionalTypeImageInfo.read(buf),
        )
    }

    override fun allocationSize(value: ImageMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterOptionalTypeFormattedBody.allocationSize(value.`formatted`) +
            FfiConverterOptionalString.allocationSize(value.`filename`) +
            FfiConverterTypeMediaSource.allocationSize(value.`source`) +
            FfiConverterOptionalTypeImageInfo.allocationSize(value.`info`)
    )

    override fun write(value: ImageMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterOptionalTypeFormattedBody.write(value.`formatted`, buf)
            FfiConverterOptionalString.write(value.`filename`, buf)
            FfiConverterTypeMediaSource.write(value.`source`, buf)
            FfiConverterOptionalTypeImageInfo.write(value.`info`, buf)
    }
}



data class InReplyToDetails (
    var `eventId`: kotlin.String, 
    var `event`: RepliedToEventDetails
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`eventId`, 
        this.`event`)
    }
    
    companion object
}

public object FfiConverterTypeInReplyToDetails: FfiConverterRustBuffer<InReplyToDetails> {
    override fun read(buf: ByteBuffer): InReplyToDetails {
        return InReplyToDetails(
            FfiConverterString.read(buf),
            FfiConverterTypeRepliedToEventDetails.read(buf),
        )
    }

    override fun allocationSize(value: InReplyToDetails) = (
            FfiConverterString.allocationSize(value.`eventId`) +
            FfiConverterTypeRepliedToEventDetails.allocationSize(value.`event`)
    )

    override fun write(value: InReplyToDetails, buf: ByteBuffer) {
            FfiConverterString.write(value.`eventId`, buf)
            FfiConverterTypeRepliedToEventDetails.write(value.`event`, buf)
    }
}



data class InsertData (
    var `index`: kotlin.UInt, 
    var `item`: TimelineItem
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`index`, 
        this.`item`)
    }
    
    companion object
}

public object FfiConverterTypeInsertData: FfiConverterRustBuffer<InsertData> {
    override fun read(buf: ByteBuffer): InsertData {
        return InsertData(
            FfiConverterUInt.read(buf),
            FfiConverterTypeTimelineItem.read(buf),
        )
    }

    override fun allocationSize(value: InsertData) = (
            FfiConverterUInt.allocationSize(value.`index`) +
            FfiConverterTypeTimelineItem.allocationSize(value.`item`)
    )

    override fun write(value: InsertData, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`index`, buf)
            FfiConverterTypeTimelineItem.write(value.`item`, buf)
    }
}



data class LocationContent (
    var `body`: kotlin.String, 
    var `geoUri`: kotlin.String, 
    var `description`: kotlin.String?, 
    var `zoomLevel`: kotlin.UByte?, 
    var `asset`: AssetType?
) {
    
    companion object
}

public object FfiConverterTypeLocationContent: FfiConverterRustBuffer<LocationContent> {
    override fun read(buf: ByteBuffer): LocationContent {
        return LocationContent(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalUByte.read(buf),
            FfiConverterOptionalTypeAssetType.read(buf),
        )
    }

    override fun allocationSize(value: LocationContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterString.allocationSize(value.`geoUri`) +
            FfiConverterOptionalString.allocationSize(value.`description`) +
            FfiConverterOptionalUByte.allocationSize(value.`zoomLevel`) +
            FfiConverterOptionalTypeAssetType.allocationSize(value.`asset`)
    )

    override fun write(value: LocationContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterString.write(value.`geoUri`, buf)
            FfiConverterOptionalString.write(value.`description`, buf)
            FfiConverterOptionalUByte.write(value.`zoomLevel`, buf)
            FfiConverterOptionalTypeAssetType.write(value.`asset`, buf)
    }
}



/**
 * A Matrix entity that can be a room, room alias, user, or event, and a list
 * of via servers.
 */
data class MatrixEntity (
    var `id`: MatrixId, 
    var `via`: List<kotlin.String>
) {
    
    companion object
}

public object FfiConverterTypeMatrixEntity: FfiConverterRustBuffer<MatrixEntity> {
    override fun read(buf: ByteBuffer): MatrixEntity {
        return MatrixEntity(
            FfiConverterTypeMatrixId.read(buf),
            FfiConverterSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: MatrixEntity) = (
            FfiConverterTypeMatrixId.allocationSize(value.`id`) +
            FfiConverterSequenceString.allocationSize(value.`via`)
    )

    override fun write(value: MatrixEntity, buf: ByteBuffer) {
            FfiConverterTypeMatrixId.write(value.`id`, buf)
            FfiConverterSequenceString.write(value.`via`, buf)
    }
}



data class Mentions (
    var `userIds`: List<kotlin.String>, 
    var `room`: kotlin.Boolean
) {
    
    companion object
}

public object FfiConverterTypeMentions: FfiConverterRustBuffer<Mentions> {
    override fun read(buf: ByteBuffer): Mentions {
        return Mentions(
            FfiConverterSequenceString.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: Mentions) = (
            FfiConverterSequenceString.allocationSize(value.`userIds`) +
            FfiConverterBoolean.allocationSize(value.`room`)
    )

    override fun write(value: Mentions, buf: ByteBuffer) {
            FfiConverterSequenceString.write(value.`userIds`, buf)
            FfiConverterBoolean.write(value.`room`, buf)
    }
}



data class NoticeMessageContent (
    var `body`: kotlin.String, 
    var `formatted`: FormattedBody?
) {
    
    companion object
}

public object FfiConverterTypeNoticeMessageContent: FfiConverterRustBuffer<NoticeMessageContent> {
    override fun read(buf: ByteBuffer): NoticeMessageContent {
        return NoticeMessageContent(
            FfiConverterString.read(buf),
            FfiConverterOptionalTypeFormattedBody.read(buf),
        )
    }

    override fun allocationSize(value: NoticeMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterOptionalTypeFormattedBody.allocationSize(value.`formatted`)
    )

    override fun write(value: NoticeMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterOptionalTypeFormattedBody.write(value.`formatted`, buf)
    }
}



data class NotificationItem (
    var `event`: NotificationEvent, 
    var `senderInfo`: NotificationSenderInfo, 
    var `roomInfo`: NotificationRoomInfo, 
    /**
     * Is the notification supposed to be at the "noisy" level?
     * Can be `None` if we couldn't determine this, because we lacked
     * information to create a push context.
     */
    var `isNoisy`: kotlin.Boolean?, 
    var `hasMention`: kotlin.Boolean?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`event`, 
        this.`senderInfo`, 
        this.`roomInfo`, 
        this.`isNoisy`, 
        this.`hasMention`)
    }
    
    companion object
}

public object FfiConverterTypeNotificationItem: FfiConverterRustBuffer<NotificationItem> {
    override fun read(buf: ByteBuffer): NotificationItem {
        return NotificationItem(
            FfiConverterTypeNotificationEvent.read(buf),
            FfiConverterTypeNotificationSenderInfo.read(buf),
            FfiConverterTypeNotificationRoomInfo.read(buf),
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterOptionalBoolean.read(buf),
        )
    }

    override fun allocationSize(value: NotificationItem) = (
            FfiConverterTypeNotificationEvent.allocationSize(value.`event`) +
            FfiConverterTypeNotificationSenderInfo.allocationSize(value.`senderInfo`) +
            FfiConverterTypeNotificationRoomInfo.allocationSize(value.`roomInfo`) +
            FfiConverterOptionalBoolean.allocationSize(value.`isNoisy`) +
            FfiConverterOptionalBoolean.allocationSize(value.`hasMention`)
    )

    override fun write(value: NotificationItem, buf: ByteBuffer) {
            FfiConverterTypeNotificationEvent.write(value.`event`, buf)
            FfiConverterTypeNotificationSenderInfo.write(value.`senderInfo`, buf)
            FfiConverterTypeNotificationRoomInfo.write(value.`roomInfo`, buf)
            FfiConverterOptionalBoolean.write(value.`isNoisy`, buf)
            FfiConverterOptionalBoolean.write(value.`hasMention`, buf)
    }
}



data class NotificationPowerLevels (
    var `room`: kotlin.Int
) {
    
    companion object
}

public object FfiConverterTypeNotificationPowerLevels: FfiConverterRustBuffer<NotificationPowerLevels> {
    override fun read(buf: ByteBuffer): NotificationPowerLevels {
        return NotificationPowerLevels(
            FfiConverterInt.read(buf),
        )
    }

    override fun allocationSize(value: NotificationPowerLevels) = (
            FfiConverterInt.allocationSize(value.`room`)
    )

    override fun write(value: NotificationPowerLevels, buf: ByteBuffer) {
            FfiConverterInt.write(value.`room`, buf)
    }
}



data class NotificationRoomInfo (
    var `displayName`: kotlin.String, 
    var `avatarUrl`: kotlin.String?, 
    var `canonicalAlias`: kotlin.String?, 
    var `joinedMembersCount`: kotlin.ULong, 
    var `isEncrypted`: kotlin.Boolean?, 
    var `isDirect`: kotlin.Boolean
) {
    
    companion object
}

public object FfiConverterTypeNotificationRoomInfo: FfiConverterRustBuffer<NotificationRoomInfo> {
    override fun read(buf: ByteBuffer): NotificationRoomInfo {
        return NotificationRoomInfo(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterOptionalBoolean.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: NotificationRoomInfo) = (
            FfiConverterString.allocationSize(value.`displayName`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`) +
            FfiConverterOptionalString.allocationSize(value.`canonicalAlias`) +
            FfiConverterULong.allocationSize(value.`joinedMembersCount`) +
            FfiConverterOptionalBoolean.allocationSize(value.`isEncrypted`) +
            FfiConverterBoolean.allocationSize(value.`isDirect`)
    )

    override fun write(value: NotificationRoomInfo, buf: ByteBuffer) {
            FfiConverterString.write(value.`displayName`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
            FfiConverterOptionalString.write(value.`canonicalAlias`, buf)
            FfiConverterULong.write(value.`joinedMembersCount`, buf)
            FfiConverterOptionalBoolean.write(value.`isEncrypted`, buf)
            FfiConverterBoolean.write(value.`isDirect`, buf)
    }
}



data class NotificationSenderInfo (
    var `displayName`: kotlin.String?, 
    var `avatarUrl`: kotlin.String?, 
    var `isNameAmbiguous`: kotlin.Boolean
) {
    
    companion object
}

public object FfiConverterTypeNotificationSenderInfo: FfiConverterRustBuffer<NotificationSenderInfo> {
    override fun read(buf: ByteBuffer): NotificationSenderInfo {
        return NotificationSenderInfo(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: NotificationSenderInfo) = (
            FfiConverterOptionalString.allocationSize(value.`displayName`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`) +
            FfiConverterBoolean.allocationSize(value.`isNameAmbiguous`)
    )

    override fun write(value: NotificationSenderInfo, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`displayName`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
            FfiConverterBoolean.write(value.`isNameAmbiguous`, buf)
    }
}



/**
 * The configuration to use when authenticating with OIDC.
 */
data class OidcConfiguration (
    /**
     * The name of the client that will be shown during OIDC authentication.
     */
    var `clientName`: kotlin.String?, 
    /**
     * The redirect URI that will be used when OIDC authentication is
     * successful.
     */
    var `redirectUri`: kotlin.String, 
    /**
     * A URI that contains information about the client.
     */
    var `clientUri`: kotlin.String?, 
    /**
     * A URI that contains the client's logo.
     */
    var `logoUri`: kotlin.String?, 
    /**
     * A URI that contains the client's terms of service.
     */
    var `tosUri`: kotlin.String?, 
    /**
     * A URI that contains the client's privacy policy.
     */
    var `policyUri`: kotlin.String?, 
    /**
     * An array of e-mail addresses of people responsible for this client.
     */
    var `contacts`: List<kotlin.String>?, 
    /**
     * Pre-configured registrations for use with issuers that don't support
     * dynamic client registration.
     */
    var `staticRegistrations`: Map<kotlin.String, kotlin.String>, 
    /**
     * A file path where any dynamic registrations should be stored.
     *
     * Suggested value: `{base_path}/oidc/registrations.json`
     */
    var `dynamicRegistrationsFile`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypeOidcConfiguration: FfiConverterRustBuffer<OidcConfiguration> {
    override fun read(buf: ByteBuffer): OidcConfiguration {
        return OidcConfiguration(
            FfiConverterOptionalString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterMapStringString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: OidcConfiguration) = (
            FfiConverterOptionalString.allocationSize(value.`clientName`) +
            FfiConverterString.allocationSize(value.`redirectUri`) +
            FfiConverterOptionalString.allocationSize(value.`clientUri`) +
            FfiConverterOptionalString.allocationSize(value.`logoUri`) +
            FfiConverterOptionalString.allocationSize(value.`tosUri`) +
            FfiConverterOptionalString.allocationSize(value.`policyUri`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`contacts`) +
            FfiConverterMapStringString.allocationSize(value.`staticRegistrations`) +
            FfiConverterString.allocationSize(value.`dynamicRegistrationsFile`)
    )

    override fun write(value: OidcConfiguration, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`clientName`, buf)
            FfiConverterString.write(value.`redirectUri`, buf)
            FfiConverterOptionalString.write(value.`clientUri`, buf)
            FfiConverterOptionalString.write(value.`logoUri`, buf)
            FfiConverterOptionalString.write(value.`tosUri`, buf)
            FfiConverterOptionalString.write(value.`policyUri`, buf)
            FfiConverterOptionalSequenceString.write(value.`contacts`, buf)
            FfiConverterMapStringString.write(value.`staticRegistrations`, buf)
            FfiConverterString.write(value.`dynamicRegistrationsFile`, buf)
    }
}



data class PollAnswer (
    var `id`: kotlin.String, 
    var `text`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypePollAnswer: FfiConverterRustBuffer<PollAnswer> {
    override fun read(buf: ByteBuffer): PollAnswer {
        return PollAnswer(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: PollAnswer) = (
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterString.allocationSize(value.`text`)
    )

    override fun write(value: PollAnswer, buf: ByteBuffer) {
            FfiConverterString.write(value.`id`, buf)
            FfiConverterString.write(value.`text`, buf)
    }
}



data class PowerLevels (
    var `usersDefault`: kotlin.Int?, 
    var `eventsDefault`: kotlin.Int?, 
    var `stateDefault`: kotlin.Int?, 
    var `ban`: kotlin.Int?, 
    var `kick`: kotlin.Int?, 
    var `redact`: kotlin.Int?, 
    var `invite`: kotlin.Int?, 
    var `notifications`: NotificationPowerLevels?, 
    var `users`: Map<kotlin.String, kotlin.Int>, 
    var `events`: Map<kotlin.String, kotlin.Int>
) {
    
    companion object
}

public object FfiConverterTypePowerLevels: FfiConverterRustBuffer<PowerLevels> {
    override fun read(buf: ByteBuffer): PowerLevels {
        return PowerLevels(
            FfiConverterOptionalInt.read(buf),
            FfiConverterOptionalInt.read(buf),
            FfiConverterOptionalInt.read(buf),
            FfiConverterOptionalInt.read(buf),
            FfiConverterOptionalInt.read(buf),
            FfiConverterOptionalInt.read(buf),
            FfiConverterOptionalInt.read(buf),
            FfiConverterOptionalTypeNotificationPowerLevels.read(buf),
            FfiConverterMapStringInt.read(buf),
            FfiConverterMapStringInt.read(buf),
        )
    }

    override fun allocationSize(value: PowerLevels) = (
            FfiConverterOptionalInt.allocationSize(value.`usersDefault`) +
            FfiConverterOptionalInt.allocationSize(value.`eventsDefault`) +
            FfiConverterOptionalInt.allocationSize(value.`stateDefault`) +
            FfiConverterOptionalInt.allocationSize(value.`ban`) +
            FfiConverterOptionalInt.allocationSize(value.`kick`) +
            FfiConverterOptionalInt.allocationSize(value.`redact`) +
            FfiConverterOptionalInt.allocationSize(value.`invite`) +
            FfiConverterOptionalTypeNotificationPowerLevels.allocationSize(value.`notifications`) +
            FfiConverterMapStringInt.allocationSize(value.`users`) +
            FfiConverterMapStringInt.allocationSize(value.`events`)
    )

    override fun write(value: PowerLevels, buf: ByteBuffer) {
            FfiConverterOptionalInt.write(value.`usersDefault`, buf)
            FfiConverterOptionalInt.write(value.`eventsDefault`, buf)
            FfiConverterOptionalInt.write(value.`stateDefault`, buf)
            FfiConverterOptionalInt.write(value.`ban`, buf)
            FfiConverterOptionalInt.write(value.`kick`, buf)
            FfiConverterOptionalInt.write(value.`redact`, buf)
            FfiConverterOptionalInt.write(value.`invite`, buf)
            FfiConverterOptionalTypeNotificationPowerLevels.write(value.`notifications`, buf)
            FfiConverterMapStringInt.write(value.`users`, buf)
            FfiConverterMapStringInt.write(value.`events`, buf)
    }
}



data class PusherIdentifiers (
    var `pushkey`: kotlin.String, 
    var `appId`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypePusherIdentifiers: FfiConverterRustBuffer<PusherIdentifiers> {
    override fun read(buf: ByteBuffer): PusherIdentifiers {
        return PusherIdentifiers(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: PusherIdentifiers) = (
            FfiConverterString.allocationSize(value.`pushkey`) +
            FfiConverterString.allocationSize(value.`appId`)
    )

    override fun write(value: PusherIdentifiers, buf: ByteBuffer) {
            FfiConverterString.write(value.`pushkey`, buf)
            FfiConverterString.write(value.`appId`, buf)
    }
}



data class Reaction (
    var `key`: kotlin.String, 
    var `count`: kotlin.ULong, 
    var `senders`: List<ReactionSenderData>
) {
    
    companion object
}

public object FfiConverterTypeReaction: FfiConverterRustBuffer<Reaction> {
    override fun read(buf: ByteBuffer): Reaction {
        return Reaction(
            FfiConverterString.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterSequenceTypeReactionSenderData.read(buf),
        )
    }

    override fun allocationSize(value: Reaction) = (
            FfiConverterString.allocationSize(value.`key`) +
            FfiConverterULong.allocationSize(value.`count`) +
            FfiConverterSequenceTypeReactionSenderData.allocationSize(value.`senders`)
    )

    override fun write(value: Reaction, buf: ByteBuffer) {
            FfiConverterString.write(value.`key`, buf)
            FfiConverterULong.write(value.`count`, buf)
            FfiConverterSequenceTypeReactionSenderData.write(value.`senders`, buf)
    }
}



data class ReactionSenderData (
    var `senderId`: kotlin.String, 
    var `timestamp`: kotlin.ULong
) {
    
    companion object
}

public object FfiConverterTypeReactionSenderData: FfiConverterRustBuffer<ReactionSenderData> {
    override fun read(buf: ByteBuffer): ReactionSenderData {
        return ReactionSenderData(
            FfiConverterString.read(buf),
            FfiConverterULong.read(buf),
        )
    }

    override fun allocationSize(value: ReactionSenderData) = (
            FfiConverterString.allocationSize(value.`senderId`) +
            FfiConverterULong.allocationSize(value.`timestamp`)
    )

    override fun write(value: ReactionSenderData, buf: ByteBuffer) {
            FfiConverterString.write(value.`senderId`, buf)
            FfiConverterULong.write(value.`timestamp`, buf)
    }
}



data class Receipt (
    var `timestamp`: kotlin.ULong?
) {
    
    companion object
}

public object FfiConverterTypeReceipt: FfiConverterRustBuffer<Receipt> {
    override fun read(buf: ByteBuffer): Receipt {
        return Receipt(
            FfiConverterOptionalULong.read(buf),
        )
    }

    override fun allocationSize(value: Receipt) = (
            FfiConverterOptionalULong.allocationSize(value.`timestamp`)
    )

    override fun write(value: Receipt, buf: ByteBuffer) {
            FfiConverterOptionalULong.write(value.`timestamp`, buf)
    }
}



data class RequiredState (
    var `key`: kotlin.String, 
    var `value`: kotlin.String
) {
    
    companion object
}

public object FfiConverterTypeRequiredState: FfiConverterRustBuffer<RequiredState> {
    override fun read(buf: ByteBuffer): RequiredState {
        return RequiredState(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: RequiredState) = (
            FfiConverterString.allocationSize(value.`key`) +
            FfiConverterString.allocationSize(value.`value`)
    )

    override fun write(value: RequiredState, buf: ByteBuffer) {
            FfiConverterString.write(value.`key`, buf)
            FfiConverterString.write(value.`value`, buf)
    }
}



/**
 * Information about a room, that was resolved from a room alias.
 */
data class ResolvedRoomAlias (
    /**
     * The room ID that the alias resolved to.
     */
    var `roomId`: kotlin.String, 
    /**
     * A list of servers that can be used to find the room by its room ID.
     */
    var `servers`: List<kotlin.String>
) {
    
    companion object
}

public object FfiConverterTypeResolvedRoomAlias: FfiConverterRustBuffer<ResolvedRoomAlias> {
    override fun read(buf: ByteBuffer): ResolvedRoomAlias {
        return ResolvedRoomAlias(
            FfiConverterString.read(buf),
            FfiConverterSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: ResolvedRoomAlias) = (
            FfiConverterString.allocationSize(value.`roomId`) +
            FfiConverterSequenceString.allocationSize(value.`servers`)
    )

    override fun write(value: ResolvedRoomAlias, buf: ByteBuffer) {
            FfiConverterString.write(value.`roomId`, buf)
            FfiConverterSequenceString.write(value.`servers`, buf)
    }
}



data class RoomDescription (
    var `roomId`: kotlin.String, 
    var `name`: kotlin.String?, 
    var `topic`: kotlin.String?, 
    var `alias`: kotlin.String?, 
    var `avatarUrl`: kotlin.String?, 
    var `joinRule`: PublicRoomJoinRule?, 
    var `isWorldReadable`: kotlin.Boolean, 
    var `joinedMembers`: kotlin.ULong
) {
    
    companion object
}

public object FfiConverterTypeRoomDescription: FfiConverterRustBuffer<RoomDescription> {
    override fun read(buf: ByteBuffer): RoomDescription {
        return RoomDescription(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalTypePublicRoomJoinRule.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterULong.read(buf),
        )
    }

    override fun allocationSize(value: RoomDescription) = (
            FfiConverterString.allocationSize(value.`roomId`) +
            FfiConverterOptionalString.allocationSize(value.`name`) +
            FfiConverterOptionalString.allocationSize(value.`topic`) +
            FfiConverterOptionalString.allocationSize(value.`alias`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`) +
            FfiConverterOptionalTypePublicRoomJoinRule.allocationSize(value.`joinRule`) +
            FfiConverterBoolean.allocationSize(value.`isWorldReadable`) +
            FfiConverterULong.allocationSize(value.`joinedMembers`)
    )

    override fun write(value: RoomDescription, buf: ByteBuffer) {
            FfiConverterString.write(value.`roomId`, buf)
            FfiConverterOptionalString.write(value.`name`, buf)
            FfiConverterOptionalString.write(value.`topic`, buf)
            FfiConverterOptionalString.write(value.`alias`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
            FfiConverterOptionalTypePublicRoomJoinRule.write(value.`joinRule`, buf)
            FfiConverterBoolean.write(value.`isWorldReadable`, buf)
            FfiConverterULong.write(value.`joinedMembers`, buf)
    }
}



data class RoomDirectorySearchEntriesResult (
    var `entriesStream`: TaskHandle
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`entriesStream`)
    }
    
    companion object
}

public object FfiConverterTypeRoomDirectorySearchEntriesResult: FfiConverterRustBuffer<RoomDirectorySearchEntriesResult> {
    override fun read(buf: ByteBuffer): RoomDirectorySearchEntriesResult {
        return RoomDirectorySearchEntriesResult(
            FfiConverterTypeTaskHandle.read(buf),
        )
    }

    override fun allocationSize(value: RoomDirectorySearchEntriesResult) = (
            FfiConverterTypeTaskHandle.allocationSize(value.`entriesStream`)
    )

    override fun write(value: RoomDirectorySearchEntriesResult, buf: ByteBuffer) {
            FfiConverterTypeTaskHandle.write(value.`entriesStream`, buf)
    }
}



/**
 * Information about a member considered to be a room hero.
 */
data class RoomHero (
    /**
     * The user ID of the hero.
     */
    var `userId`: kotlin.String, 
    /**
     * The display name of the hero.
     */
    var `displayName`: kotlin.String?, 
    /**
     * The avatar URL of the hero.
     */
    var `avatarUrl`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypeRoomHero: FfiConverterRustBuffer<RoomHero> {
    override fun read(buf: ByteBuffer): RoomHero {
        return RoomHero(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: RoomHero) = (
            FfiConverterString.allocationSize(value.`userId`) +
            FfiConverterOptionalString.allocationSize(value.`displayName`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`)
    )

    override fun write(value: RoomHero, buf: ByteBuffer) {
            FfiConverterString.write(value.`userId`, buf)
            FfiConverterOptionalString.write(value.`displayName`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
    }
}



data class RoomInfo (
    var `id`: kotlin.String, 
    /**
     * The room's name from the room state event if received from sync, or one
     * that's been computed otherwise.
     */
    var `displayName`: kotlin.String?, 
    /**
     * Room name as defined by the room state event only.
     */
    var `rawName`: kotlin.String?, 
    var `topic`: kotlin.String?, 
    var `avatarUrl`: kotlin.String?, 
    var `isDirect`: kotlin.Boolean, 
    var `isPublic`: kotlin.Boolean, 
    var `isSpace`: kotlin.Boolean, 
    var `isTombstoned`: kotlin.Boolean, 
    var `isFavourite`: kotlin.Boolean, 
    var `canonicalAlias`: kotlin.String?, 
    var `alternativeAliases`: List<kotlin.String>, 
    var `membership`: Membership, 
    /**
     * Member who invited the current user to a room that's in the invited
     * state.
     *
     * Can be missing if the room membership invite event is missing from the
     * store.
     */
    var `inviter`: RoomMember?, 
    var `heroes`: List<RoomHero>, 
    var `activeMembersCount`: kotlin.ULong, 
    var `invitedMembersCount`: kotlin.ULong, 
    var `joinedMembersCount`: kotlin.ULong, 
    var `userPowerLevels`: Map<kotlin.String, kotlin.Long>, 
    var `highlightCount`: kotlin.ULong, 
    var `notificationCount`: kotlin.ULong, 
    var `userDefinedNotificationMode`: RoomNotificationMode?, 
    var `hasRoomCall`: kotlin.Boolean, 
    var `activeRoomCallParticipants`: List<kotlin.String>, 
    /**
     * Whether this room has been explicitly marked as unread
     */
    var `isMarkedUnread`: kotlin.Boolean, 
    /**
     * "Interesting" messages received in that room, independently of the
     * notification settings.
     */
    var `numUnreadMessages`: kotlin.ULong, 
    /**
     * Events that will notify the user, according to their
     * notification settings.
     */
    var `numUnreadNotifications`: kotlin.ULong, 
    /**
     * Events causing mentions/highlights for the user, according to their
     * notification settings.
     */
    var `numUnreadMentions`: kotlin.ULong
) {
    
    companion object
}

public object FfiConverterTypeRoomInfo: FfiConverterRustBuffer<RoomInfo> {
    override fun read(buf: ByteBuffer): RoomInfo {
        return RoomInfo(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterSequenceString.read(buf),
            FfiConverterTypeMembership.read(buf),
            FfiConverterOptionalTypeRoomMember.read(buf),
            FfiConverterSequenceTypeRoomHero.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterMapStringLong.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterOptionalTypeRoomNotificationMode.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterSequenceString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterULong.read(buf),
        )
    }

    override fun allocationSize(value: RoomInfo) = (
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterOptionalString.allocationSize(value.`displayName`) +
            FfiConverterOptionalString.allocationSize(value.`rawName`) +
            FfiConverterOptionalString.allocationSize(value.`topic`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`) +
            FfiConverterBoolean.allocationSize(value.`isDirect`) +
            FfiConverterBoolean.allocationSize(value.`isPublic`) +
            FfiConverterBoolean.allocationSize(value.`isSpace`) +
            FfiConverterBoolean.allocationSize(value.`isTombstoned`) +
            FfiConverterBoolean.allocationSize(value.`isFavourite`) +
            FfiConverterOptionalString.allocationSize(value.`canonicalAlias`) +
            FfiConverterSequenceString.allocationSize(value.`alternativeAliases`) +
            FfiConverterTypeMembership.allocationSize(value.`membership`) +
            FfiConverterOptionalTypeRoomMember.allocationSize(value.`inviter`) +
            FfiConverterSequenceTypeRoomHero.allocationSize(value.`heroes`) +
            FfiConverterULong.allocationSize(value.`activeMembersCount`) +
            FfiConverterULong.allocationSize(value.`invitedMembersCount`) +
            FfiConverterULong.allocationSize(value.`joinedMembersCount`) +
            FfiConverterMapStringLong.allocationSize(value.`userPowerLevels`) +
            FfiConverterULong.allocationSize(value.`highlightCount`) +
            FfiConverterULong.allocationSize(value.`notificationCount`) +
            FfiConverterOptionalTypeRoomNotificationMode.allocationSize(value.`userDefinedNotificationMode`) +
            FfiConverterBoolean.allocationSize(value.`hasRoomCall`) +
            FfiConverterSequenceString.allocationSize(value.`activeRoomCallParticipants`) +
            FfiConverterBoolean.allocationSize(value.`isMarkedUnread`) +
            FfiConverterULong.allocationSize(value.`numUnreadMessages`) +
            FfiConverterULong.allocationSize(value.`numUnreadNotifications`) +
            FfiConverterULong.allocationSize(value.`numUnreadMentions`)
    )

    override fun write(value: RoomInfo, buf: ByteBuffer) {
            FfiConverterString.write(value.`id`, buf)
            FfiConverterOptionalString.write(value.`displayName`, buf)
            FfiConverterOptionalString.write(value.`rawName`, buf)
            FfiConverterOptionalString.write(value.`topic`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
            FfiConverterBoolean.write(value.`isDirect`, buf)
            FfiConverterBoolean.write(value.`isPublic`, buf)
            FfiConverterBoolean.write(value.`isSpace`, buf)
            FfiConverterBoolean.write(value.`isTombstoned`, buf)
            FfiConverterBoolean.write(value.`isFavourite`, buf)
            FfiConverterOptionalString.write(value.`canonicalAlias`, buf)
            FfiConverterSequenceString.write(value.`alternativeAliases`, buf)
            FfiConverterTypeMembership.write(value.`membership`, buf)
            FfiConverterOptionalTypeRoomMember.write(value.`inviter`, buf)
            FfiConverterSequenceTypeRoomHero.write(value.`heroes`, buf)
            FfiConverterULong.write(value.`activeMembersCount`, buf)
            FfiConverterULong.write(value.`invitedMembersCount`, buf)
            FfiConverterULong.write(value.`joinedMembersCount`, buf)
            FfiConverterMapStringLong.write(value.`userPowerLevels`, buf)
            FfiConverterULong.write(value.`highlightCount`, buf)
            FfiConverterULong.write(value.`notificationCount`, buf)
            FfiConverterOptionalTypeRoomNotificationMode.write(value.`userDefinedNotificationMode`, buf)
            FfiConverterBoolean.write(value.`hasRoomCall`, buf)
            FfiConverterSequenceString.write(value.`activeRoomCallParticipants`, buf)
            FfiConverterBoolean.write(value.`isMarkedUnread`, buf)
            FfiConverterULong.write(value.`numUnreadMessages`, buf)
            FfiConverterULong.write(value.`numUnreadNotifications`, buf)
            FfiConverterULong.write(value.`numUnreadMentions`, buf)
    }
}



data class RoomListEntriesResult (
    var `entries`: List<RoomListEntry>, 
    var `entriesStream`: TaskHandle
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`entries`, 
        this.`entriesStream`)
    }
    
    companion object
}

public object FfiConverterTypeRoomListEntriesResult: FfiConverterRustBuffer<RoomListEntriesResult> {
    override fun read(buf: ByteBuffer): RoomListEntriesResult {
        return RoomListEntriesResult(
            FfiConverterSequenceTypeRoomListEntry.read(buf),
            FfiConverterTypeTaskHandle.read(buf),
        )
    }

    override fun allocationSize(value: RoomListEntriesResult) = (
            FfiConverterSequenceTypeRoomListEntry.allocationSize(value.`entries`) +
            FfiConverterTypeTaskHandle.allocationSize(value.`entriesStream`)
    )

    override fun write(value: RoomListEntriesResult, buf: ByteBuffer) {
            FfiConverterSequenceTypeRoomListEntry.write(value.`entries`, buf)
            FfiConverterTypeTaskHandle.write(value.`entriesStream`, buf)
    }
}



data class RoomListEntriesWithDynamicAdaptersResult (
    var `controller`: RoomListDynamicEntriesController, 
    var `entriesStream`: TaskHandle
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`controller`, 
        this.`entriesStream`)
    }
    
    companion object
}

public object FfiConverterTypeRoomListEntriesWithDynamicAdaptersResult: FfiConverterRustBuffer<RoomListEntriesWithDynamicAdaptersResult> {
    override fun read(buf: ByteBuffer): RoomListEntriesWithDynamicAdaptersResult {
        return RoomListEntriesWithDynamicAdaptersResult(
            FfiConverterTypeRoomListDynamicEntriesController.read(buf),
            FfiConverterTypeTaskHandle.read(buf),
        )
    }

    override fun allocationSize(value: RoomListEntriesWithDynamicAdaptersResult) = (
            FfiConverterTypeRoomListDynamicEntriesController.allocationSize(value.`controller`) +
            FfiConverterTypeTaskHandle.allocationSize(value.`entriesStream`)
    )

    override fun write(value: RoomListEntriesWithDynamicAdaptersResult, buf: ByteBuffer) {
            FfiConverterTypeRoomListDynamicEntriesController.write(value.`controller`, buf)
            FfiConverterTypeTaskHandle.write(value.`entriesStream`, buf)
    }
}



data class RoomListLoadingStateResult (
    var `state`: RoomListLoadingState, 
    var `stateStream`: TaskHandle
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`state`, 
        this.`stateStream`)
    }
    
    companion object
}

public object FfiConverterTypeRoomListLoadingStateResult: FfiConverterRustBuffer<RoomListLoadingStateResult> {
    override fun read(buf: ByteBuffer): RoomListLoadingStateResult {
        return RoomListLoadingStateResult(
            FfiConverterTypeRoomListLoadingState.read(buf),
            FfiConverterTypeTaskHandle.read(buf),
        )
    }

    override fun allocationSize(value: RoomListLoadingStateResult) = (
            FfiConverterTypeRoomListLoadingState.allocationSize(value.`state`) +
            FfiConverterTypeTaskHandle.allocationSize(value.`stateStream`)
    )

    override fun write(value: RoomListLoadingStateResult, buf: ByteBuffer) {
            FfiConverterTypeRoomListLoadingState.write(value.`state`, buf)
            FfiConverterTypeTaskHandle.write(value.`stateStream`, buf)
    }
}



data class RoomListRange (
    var `start`: kotlin.UInt, 
    var `endInclusive`: kotlin.UInt
) {
    
    companion object
}

public object FfiConverterTypeRoomListRange: FfiConverterRustBuffer<RoomListRange> {
    override fun read(buf: ByteBuffer): RoomListRange {
        return RoomListRange(
            FfiConverterUInt.read(buf),
            FfiConverterUInt.read(buf),
        )
    }

    override fun allocationSize(value: RoomListRange) = (
            FfiConverterUInt.allocationSize(value.`start`) +
            FfiConverterUInt.allocationSize(value.`endInclusive`)
    )

    override fun write(value: RoomListRange, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`start`, buf)
            FfiConverterUInt.write(value.`endInclusive`, buf)
    }
}



data class RoomMember (
    var `userId`: kotlin.String, 
    var `displayName`: kotlin.String?, 
    var `avatarUrl`: kotlin.String?, 
    var `membership`: MembershipState, 
    var `isNameAmbiguous`: kotlin.Boolean, 
    var `powerLevel`: kotlin.Long, 
    var `normalizedPowerLevel`: kotlin.Long, 
    var `isIgnored`: kotlin.Boolean, 
    var `suggestedRoleForPowerLevel`: RoomMemberRole
) {
    
    companion object
}

public object FfiConverterTypeRoomMember: FfiConverterRustBuffer<RoomMember> {
    override fun read(buf: ByteBuffer): RoomMember {
        return RoomMember(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterTypeMembershipState.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterLong.read(buf),
            FfiConverterLong.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterTypeRoomMemberRole.read(buf),
        )
    }

    override fun allocationSize(value: RoomMember) = (
            FfiConverterString.allocationSize(value.`userId`) +
            FfiConverterOptionalString.allocationSize(value.`displayName`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`) +
            FfiConverterTypeMembershipState.allocationSize(value.`membership`) +
            FfiConverterBoolean.allocationSize(value.`isNameAmbiguous`) +
            FfiConverterLong.allocationSize(value.`powerLevel`) +
            FfiConverterLong.allocationSize(value.`normalizedPowerLevel`) +
            FfiConverterBoolean.allocationSize(value.`isIgnored`) +
            FfiConverterTypeRoomMemberRole.allocationSize(value.`suggestedRoleForPowerLevel`)
    )

    override fun write(value: RoomMember, buf: ByteBuffer) {
            FfiConverterString.write(value.`userId`, buf)
            FfiConverterOptionalString.write(value.`displayName`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
            FfiConverterTypeMembershipState.write(value.`membership`, buf)
            FfiConverterBoolean.write(value.`isNameAmbiguous`, buf)
            FfiConverterLong.write(value.`powerLevel`, buf)
            FfiConverterLong.write(value.`normalizedPowerLevel`, buf)
            FfiConverterBoolean.write(value.`isIgnored`, buf)
            FfiConverterTypeRoomMemberRole.write(value.`suggestedRoleForPowerLevel`, buf)
    }
}



/**
 * `RoomNotificationSettings` represents the current settings for a `Room`
 */
data class RoomNotificationSettings (
    /**
     * The room notification mode
     */
    var `mode`: RoomNotificationMode, 
    /**
     * Whether the mode is the default one
     */
    var `isDefault`: kotlin.Boolean
) {
    
    companion object
}

public object FfiConverterTypeRoomNotificationSettings: FfiConverterRustBuffer<RoomNotificationSettings> {
    override fun read(buf: ByteBuffer): RoomNotificationSettings {
        return RoomNotificationSettings(
            FfiConverterTypeRoomNotificationMode.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: RoomNotificationSettings) = (
            FfiConverterTypeRoomNotificationMode.allocationSize(value.`mode`) +
            FfiConverterBoolean.allocationSize(value.`isDefault`)
    )

    override fun write(value: RoomNotificationSettings, buf: ByteBuffer) {
            FfiConverterTypeRoomNotificationMode.write(value.`mode`, buf)
            FfiConverterBoolean.write(value.`isDefault`, buf)
    }
}



data class RoomPowerLevels (
    /**
     * The level required to ban a user.
     */
    var `ban`: kotlin.Long, 
    /**
     * The level required to invite a user.
     */
    var `invite`: kotlin.Long, 
    /**
     * The level required to kick a user.
     */
    var `kick`: kotlin.Long, 
    /**
     * The level required to redact an event.
     */
    var `redact`: kotlin.Long, 
    /**
     * The default level required to send message events.
     */
    var `eventsDefault`: kotlin.Long, 
    /**
     * The default level required to send state events.
     */
    var `stateDefault`: kotlin.Long, 
    /**
     * The default power level for every user in the room.
     */
    var `usersDefault`: kotlin.Long, 
    /**
     * The level required to change the room's name.
     */
    var `roomName`: kotlin.Long, 
    /**
     * The level required to change the room's avatar.
     */
    var `roomAvatar`: kotlin.Long, 
    /**
     * The level required to change the room's topic.
     */
    var `roomTopic`: kotlin.Long
) {
    
    companion object
}

public object FfiConverterTypeRoomPowerLevels: FfiConverterRustBuffer<RoomPowerLevels> {
    override fun read(buf: ByteBuffer): RoomPowerLevels {
        return RoomPowerLevels(
            FfiConverterLong.read(buf),
            FfiConverterLong.read(buf),
            FfiConverterLong.read(buf),
            FfiConverterLong.read(buf),
            FfiConverterLong.read(buf),
            FfiConverterLong.read(buf),
            FfiConverterLong.read(buf),
            FfiConverterLong.read(buf),
            FfiConverterLong.read(buf),
            FfiConverterLong.read(buf),
        )
    }

    override fun allocationSize(value: RoomPowerLevels) = (
            FfiConverterLong.allocationSize(value.`ban`) +
            FfiConverterLong.allocationSize(value.`invite`) +
            FfiConverterLong.allocationSize(value.`kick`) +
            FfiConverterLong.allocationSize(value.`redact`) +
            FfiConverterLong.allocationSize(value.`eventsDefault`) +
            FfiConverterLong.allocationSize(value.`stateDefault`) +
            FfiConverterLong.allocationSize(value.`usersDefault`) +
            FfiConverterLong.allocationSize(value.`roomName`) +
            FfiConverterLong.allocationSize(value.`roomAvatar`) +
            FfiConverterLong.allocationSize(value.`roomTopic`)
    )

    override fun write(value: RoomPowerLevels, buf: ByteBuffer) {
            FfiConverterLong.write(value.`ban`, buf)
            FfiConverterLong.write(value.`invite`, buf)
            FfiConverterLong.write(value.`kick`, buf)
            FfiConverterLong.write(value.`redact`, buf)
            FfiConverterLong.write(value.`eventsDefault`, buf)
            FfiConverterLong.write(value.`stateDefault`, buf)
            FfiConverterLong.write(value.`usersDefault`, buf)
            FfiConverterLong.write(value.`roomName`, buf)
            FfiConverterLong.write(value.`roomAvatar`, buf)
            FfiConverterLong.write(value.`roomTopic`, buf)
    }
}



/**
 * The preview of a room, be it invited/joined/left, or not.
 */
data class RoomPreview (
    /**
     * The room id for this room.
     */
    var `roomId`: kotlin.String, 
    /**
     * The canonical alias for the room.
     */
    var `canonicalAlias`: kotlin.String?, 
    /**
     * The room's name, if set.
     */
    var `name`: kotlin.String?, 
    /**
     * The room's topic, if set.
     */
    var `topic`: kotlin.String?, 
    /**
     * The MXC URI to the room's avatar, if set.
     */
    var `avatarUrl`: kotlin.String?, 
    /**
     * The number of joined members.
     */
    var `numJoinedMembers`: kotlin.ULong, 
    /**
     * The room type (space, custom) or nothing, if it's a regular room.
     */
    var `roomType`: kotlin.String?, 
    /**
     * Is the history world-readable for this room?
     */
    var `isHistoryWorldReadable`: kotlin.Boolean, 
    /**
     * Is the room joined by the current user?
     */
    var `isJoined`: kotlin.Boolean, 
    /**
     * Is the current user invited to this room?
     */
    var `isInvited`: kotlin.Boolean, 
    /**
     * is the join rule public for this room?
     */
    var `isPublic`: kotlin.Boolean, 
    /**
     * Can we knock (or restricted-knock) to this room?
     */
    var `canKnock`: kotlin.Boolean
) {
    
    companion object
}

public object FfiConverterTypeRoomPreview: FfiConverterRustBuffer<RoomPreview> {
    override fun read(buf: ByteBuffer): RoomPreview {
        return RoomPreview(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterULong.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: RoomPreview) = (
            FfiConverterString.allocationSize(value.`roomId`) +
            FfiConverterOptionalString.allocationSize(value.`canonicalAlias`) +
            FfiConverterOptionalString.allocationSize(value.`name`) +
            FfiConverterOptionalString.allocationSize(value.`topic`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`) +
            FfiConverterULong.allocationSize(value.`numJoinedMembers`) +
            FfiConverterOptionalString.allocationSize(value.`roomType`) +
            FfiConverterBoolean.allocationSize(value.`isHistoryWorldReadable`) +
            FfiConverterBoolean.allocationSize(value.`isJoined`) +
            FfiConverterBoolean.allocationSize(value.`isInvited`) +
            FfiConverterBoolean.allocationSize(value.`isPublic`) +
            FfiConverterBoolean.allocationSize(value.`canKnock`)
    )

    override fun write(value: RoomPreview, buf: ByteBuffer) {
            FfiConverterString.write(value.`roomId`, buf)
            FfiConverterOptionalString.write(value.`canonicalAlias`, buf)
            FfiConverterOptionalString.write(value.`name`, buf)
            FfiConverterOptionalString.write(value.`topic`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
            FfiConverterULong.write(value.`numJoinedMembers`, buf)
            FfiConverterOptionalString.write(value.`roomType`, buf)
            FfiConverterBoolean.write(value.`isHistoryWorldReadable`, buf)
            FfiConverterBoolean.write(value.`isJoined`, buf)
            FfiConverterBoolean.write(value.`isInvited`, buf)
            FfiConverterBoolean.write(value.`isPublic`, buf)
            FfiConverterBoolean.write(value.`canKnock`, buf)
    }
}



data class RoomSubscription (
    var `requiredState`: List<RequiredState>?, 
    var `timelineLimit`: kotlin.UInt?, 
    var `includeHeroes`: kotlin.Boolean?
) {
    
    companion object
}

public object FfiConverterTypeRoomSubscription: FfiConverterRustBuffer<RoomSubscription> {
    override fun read(buf: ByteBuffer): RoomSubscription {
        return RoomSubscription(
            FfiConverterOptionalSequenceTypeRequiredState.read(buf),
            FfiConverterOptionalUInt.read(buf),
            FfiConverterOptionalBoolean.read(buf),
        )
    }

    override fun allocationSize(value: RoomSubscription) = (
            FfiConverterOptionalSequenceTypeRequiredState.allocationSize(value.`requiredState`) +
            FfiConverterOptionalUInt.allocationSize(value.`timelineLimit`) +
            FfiConverterOptionalBoolean.allocationSize(value.`includeHeroes`)
    )

    override fun write(value: RoomSubscription, buf: ByteBuffer) {
            FfiConverterOptionalSequenceTypeRequiredState.write(value.`requiredState`, buf)
            FfiConverterOptionalUInt.write(value.`timelineLimit`, buf)
            FfiConverterOptionalBoolean.write(value.`includeHeroes`, buf)
    }
}



data class SearchUsersResults (
    var `results`: List<UserProfile>, 
    var `limited`: kotlin.Boolean
) {
    
    companion object
}

public object FfiConverterTypeSearchUsersResults: FfiConverterRustBuffer<SearchUsersResults> {
    override fun read(buf: ByteBuffer): SearchUsersResults {
        return SearchUsersResults(
            FfiConverterSequenceTypeUserProfile.read(buf),
            FfiConverterBoolean.read(buf),
        )
    }

    override fun allocationSize(value: SearchUsersResults) = (
            FfiConverterSequenceTypeUserProfile.allocationSize(value.`results`) +
            FfiConverterBoolean.allocationSize(value.`limited`)
    )

    override fun write(value: SearchUsersResults, buf: ByteBuffer) {
            FfiConverterSequenceTypeUserProfile.write(value.`results`, buf)
            FfiConverterBoolean.write(value.`limited`, buf)
    }
}



data class Session (
    /**
     * The access token used for this session.
     */
    var `accessToken`: kotlin.String, 
    /**
     * The token used for [refreshing the access token], if any.
     *
     * [refreshing the access token]: https://spec.matrix.org/v1.3/client-server-api/#refreshing-access-tokens
     */
    var `refreshToken`: kotlin.String?, 
    /**
     * The user the access token was issued for.
     */
    var `userId`: kotlin.String, 
    /**
     * The ID of the client device.
     */
    var `deviceId`: kotlin.String, 
    /**
     * The URL for the homeserver used for this session.
     */
    var `homeserverUrl`: kotlin.String, 
    /**
     * Additional data for this session if OpenID Connect was used for
     * authentication.
     */
    var `oidcData`: kotlin.String?, 
    /**
     * The URL for the sliding sync proxy used for this session.
     */
    var `slidingSyncProxy`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypeSession: FfiConverterRustBuffer<Session> {
    override fun read(buf: ByteBuffer): Session {
        return Session(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: Session) = (
            FfiConverterString.allocationSize(value.`accessToken`) +
            FfiConverterOptionalString.allocationSize(value.`refreshToken`) +
            FfiConverterString.allocationSize(value.`userId`) +
            FfiConverterString.allocationSize(value.`deviceId`) +
            FfiConverterString.allocationSize(value.`homeserverUrl`) +
            FfiConverterOptionalString.allocationSize(value.`oidcData`) +
            FfiConverterOptionalString.allocationSize(value.`slidingSyncProxy`)
    )

    override fun write(value: Session, buf: ByteBuffer) {
            FfiConverterString.write(value.`accessToken`, buf)
            FfiConverterOptionalString.write(value.`refreshToken`, buf)
            FfiConverterString.write(value.`userId`, buf)
            FfiConverterString.write(value.`deviceId`, buf)
            FfiConverterString.write(value.`homeserverUrl`, buf)
            FfiConverterOptionalString.write(value.`oidcData`, buf)
            FfiConverterOptionalString.write(value.`slidingSyncProxy`, buf)
    }
}



data class SetData (
    var `index`: kotlin.UInt, 
    var `item`: TimelineItem
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`index`, 
        this.`item`)
    }
    
    companion object
}

public object FfiConverterTypeSetData: FfiConverterRustBuffer<SetData> {
    override fun read(buf: ByteBuffer): SetData {
        return SetData(
            FfiConverterUInt.read(buf),
            FfiConverterTypeTimelineItem.read(buf),
        )
    }

    override fun allocationSize(value: SetData) = (
            FfiConverterUInt.allocationSize(value.`index`) +
            FfiConverterTypeTimelineItem.allocationSize(value.`item`)
    )

    override fun write(value: SetData, buf: ByteBuffer) {
            FfiConverterUInt.write(value.`index`, buf)
            FfiConverterTypeTimelineItem.write(value.`item`, buf)
    }
}



data class TextMessageContent (
    var `body`: kotlin.String, 
    var `formatted`: FormattedBody?
) {
    
    companion object
}

public object FfiConverterTypeTextMessageContent: FfiConverterRustBuffer<TextMessageContent> {
    override fun read(buf: ByteBuffer): TextMessageContent {
        return TextMessageContent(
            FfiConverterString.read(buf),
            FfiConverterOptionalTypeFormattedBody.read(buf),
        )
    }

    override fun allocationSize(value: TextMessageContent) = (
            FfiConverterString.allocationSize(value.`body`) +
            FfiConverterOptionalTypeFormattedBody.allocationSize(value.`formatted`)
    )

    override fun write(value: TextMessageContent, buf: ByteBuffer) {
            FfiConverterString.write(value.`body`, buf)
            FfiConverterOptionalTypeFormattedBody.write(value.`formatted`, buf)
    }
}



data class ThumbnailInfo (
    var `height`: kotlin.ULong?, 
    var `width`: kotlin.ULong?, 
    var `mimetype`: kotlin.String?, 
    var `size`: kotlin.ULong?
) {
    
    companion object
}

public object FfiConverterTypeThumbnailInfo: FfiConverterRustBuffer<ThumbnailInfo> {
    override fun read(buf: ByteBuffer): ThumbnailInfo {
        return ThumbnailInfo(
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalULong.read(buf),
        )
    }

    override fun allocationSize(value: ThumbnailInfo) = (
            FfiConverterOptionalULong.allocationSize(value.`height`) +
            FfiConverterOptionalULong.allocationSize(value.`width`) +
            FfiConverterOptionalString.allocationSize(value.`mimetype`) +
            FfiConverterOptionalULong.allocationSize(value.`size`)
    )

    override fun write(value: ThumbnailInfo, buf: ByteBuffer) {
            FfiConverterOptionalULong.write(value.`height`, buf)
            FfiConverterOptionalULong.write(value.`width`, buf)
            FfiConverterOptionalString.write(value.`mimetype`, buf)
            FfiConverterOptionalULong.write(value.`size`, buf)
    }
}



data class TracingConfiguration (
    var `filter`: kotlin.String, 
    /**
     * Controls whether to print to stdout or, equivalent, the system logs on
     * Android.
     */
    var `writeToStdoutOrSystem`: kotlin.Boolean, 
    var `writeToFiles`: TracingFileConfiguration?
) {
    
    companion object
}

public object FfiConverterTypeTracingConfiguration: FfiConverterRustBuffer<TracingConfiguration> {
    override fun read(buf: ByteBuffer): TracingConfiguration {
        return TracingConfiguration(
            FfiConverterString.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterOptionalTypeTracingFileConfiguration.read(buf),
        )
    }

    override fun allocationSize(value: TracingConfiguration) = (
            FfiConverterString.allocationSize(value.`filter`) +
            FfiConverterBoolean.allocationSize(value.`writeToStdoutOrSystem`) +
            FfiConverterOptionalTypeTracingFileConfiguration.allocationSize(value.`writeToFiles`)
    )

    override fun write(value: TracingConfiguration, buf: ByteBuffer) {
            FfiConverterString.write(value.`filter`, buf)
            FfiConverterBoolean.write(value.`writeToStdoutOrSystem`, buf)
            FfiConverterOptionalTypeTracingFileConfiguration.write(value.`writeToFiles`, buf)
    }
}



data class TracingFileConfiguration (
    var `path`: kotlin.String, 
    var `filePrefix`: kotlin.String, 
    var `fileSuffix`: kotlin.String?, 
    var `maxFiles`: kotlin.ULong?
) {
    
    companion object
}

public object FfiConverterTypeTracingFileConfiguration: FfiConverterRustBuffer<TracingFileConfiguration> {
    override fun read(buf: ByteBuffer): TracingFileConfiguration {
        return TracingFileConfiguration(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalULong.read(buf),
        )
    }

    override fun allocationSize(value: TracingFileConfiguration) = (
            FfiConverterString.allocationSize(value.`path`) +
            FfiConverterString.allocationSize(value.`filePrefix`) +
            FfiConverterOptionalString.allocationSize(value.`fileSuffix`) +
            FfiConverterOptionalULong.allocationSize(value.`maxFiles`)
    )

    override fun write(value: TracingFileConfiguration, buf: ByteBuffer) {
            FfiConverterString.write(value.`path`, buf)
            FfiConverterString.write(value.`filePrefix`, buf)
            FfiConverterOptionalString.write(value.`fileSuffix`, buf)
            FfiConverterOptionalULong.write(value.`maxFiles`, buf)
    }
}



data class TransmissionProgress (
    var `current`: kotlin.ULong, 
    var `total`: kotlin.ULong
) {
    
    companion object
}

public object FfiConverterTypeTransmissionProgress: FfiConverterRustBuffer<TransmissionProgress> {
    override fun read(buf: ByteBuffer): TransmissionProgress {
        return TransmissionProgress(
            FfiConverterULong.read(buf),
            FfiConverterULong.read(buf),
        )
    }

    override fun allocationSize(value: TransmissionProgress) = (
            FfiConverterULong.allocationSize(value.`current`) +
            FfiConverterULong.allocationSize(value.`total`)
    )

    override fun write(value: TransmissionProgress, buf: ByteBuffer) {
            FfiConverterULong.write(value.`current`, buf)
            FfiConverterULong.write(value.`total`, buf)
    }
}



data class UnableToDecryptInfo (
    /**
     * The identifier of the event that couldn't get decrypted.
     */
    var `eventId`: kotlin.String, 
    /**
     * If the event could be decrypted late (that is, the event was encrypted
     * at first, but could be decrypted later on), then this indicates the
     * time it took to decrypt the event. If it is not set, this is
     * considered a definite UTD.
     *
     * If set, this is in milliseconds.
     */
    var `timeToDecryptMs`: kotlin.ULong?, 
    /**
     * What we know about what caused this UTD. E.g. was this event sent when
     * we were not a member of this room?
     */
    var `cause`: UtdCause
) {
    
    companion object
}

public object FfiConverterTypeUnableToDecryptInfo: FfiConverterRustBuffer<UnableToDecryptInfo> {
    override fun read(buf: ByteBuffer): UnableToDecryptInfo {
        return UnableToDecryptInfo(
            FfiConverterString.read(buf),
            FfiConverterOptionalULong.read(buf),
            FfiConverterTypeUtdCause.read(buf),
        )
    }

    override fun allocationSize(value: UnableToDecryptInfo) = (
            FfiConverterString.allocationSize(value.`eventId`) +
            FfiConverterOptionalULong.allocationSize(value.`timeToDecryptMs`) +
            FfiConverterTypeUtdCause.allocationSize(value.`cause`)
    )

    override fun write(value: UnableToDecryptInfo, buf: ByteBuffer) {
            FfiConverterString.write(value.`eventId`, buf)
            FfiConverterOptionalULong.write(value.`timeToDecryptMs`, buf)
            FfiConverterTypeUtdCause.write(value.`cause`, buf)
    }
}



data class UnstableAudioDetailsContent (
    var `duration`: java.time.Duration, 
    var `waveform`: List<kotlin.UShort>
) {
    
    companion object
}

public object FfiConverterTypeUnstableAudioDetailsContent: FfiConverterRustBuffer<UnstableAudioDetailsContent> {
    override fun read(buf: ByteBuffer): UnstableAudioDetailsContent {
        return UnstableAudioDetailsContent(
            FfiConverterDuration.read(buf),
            FfiConverterSequenceUShort.read(buf),
        )
    }

    override fun allocationSize(value: UnstableAudioDetailsContent) = (
            FfiConverterDuration.allocationSize(value.`duration`) +
            FfiConverterSequenceUShort.allocationSize(value.`waveform`)
    )

    override fun write(value: UnstableAudioDetailsContent, buf: ByteBuffer) {
            FfiConverterDuration.write(value.`duration`, buf)
            FfiConverterSequenceUShort.write(value.`waveform`, buf)
    }
}



class UnstableVoiceContent {
    override fun equals(other: Any?): Boolean {
        return other is UnstableVoiceContent
    }

    override fun hashCode(): Int {
        return javaClass.hashCode()
    }

    companion object
}

public object FfiConverterTypeUnstableVoiceContent: FfiConverterRustBuffer<UnstableVoiceContent> {
    override fun read(buf: ByteBuffer): UnstableVoiceContent {
        return UnstableVoiceContent()
    }

    override fun allocationSize(value: UnstableVoiceContent) = 0UL

    override fun write(value: UnstableVoiceContent, buf: ByteBuffer) {
    }
}



/**
 * An update for a particular user's power level within the room.
 */
data class UserPowerLevelUpdate (
    /**
     * The user ID of the user to update.
     */
    var `userId`: kotlin.String, 
    /**
     * The power level to assign to the user.
     */
    var `powerLevel`: kotlin.Long
) {
    
    companion object
}

public object FfiConverterTypeUserPowerLevelUpdate: FfiConverterRustBuffer<UserPowerLevelUpdate> {
    override fun read(buf: ByteBuffer): UserPowerLevelUpdate {
        return UserPowerLevelUpdate(
            FfiConverterString.read(buf),
            FfiConverterLong.read(buf),
        )
    }

    override fun allocationSize(value: UserPowerLevelUpdate) = (
            FfiConverterString.allocationSize(value.`userId`) +
            FfiConverterLong.allocationSize(value.`powerLevel`)
    )

    override fun write(value: UserPowerLevelUpdate, buf: ByteBuffer) {
            FfiConverterString.write(value.`userId`, buf)
            FfiConverterLong.write(value.`powerLevel`, buf)
    }
}



data class UserProfile (
    var `userId`: kotlin.String, 
    var `displayName`: kotlin.String?, 
    var `avatarUrl`: kotlin.String?
) {
    
    companion object
}

public object FfiConverterTypeUserProfile: FfiConverterRustBuffer<UserProfile> {
    override fun read(buf: ByteBuffer): UserProfile {
        return UserProfile(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: UserProfile) = (
            FfiConverterString.allocationSize(value.`userId`) +
            FfiConverterOptionalString.allocationSize(value.`displayName`) +
            FfiConverterOptionalString.allocationSize(value.`avatarUrl`)
    )

    override fun write(value: UserProfile, buf: ByteBuffer) {
            FfiConverterString.write(value.`userId`, buf)
            FfiConverterOptionalString.write(value.`displayName`, buf)
            FfiConverterOptionalString.write(value.`avatarUrl`, buf)
    }
}



data class VideoInfo (
    var `duration`: java.time.Duration?, 
    var `height`: kotlin.ULong?, 
    var `width`: kotlin.ULong?, 
    var `mimetype`: kotlin.String?, 
    var `size`: kotlin.ULong?, 
    var `thumbnailInfo`: ThumbnailInfo?, 
    var `thumbnailSource`: MediaSource?, 
    var `blurhash`: kotlin.String?
) : Disposable {
    
    @Suppress("UNNECESSARY_SAFE_CALL") // codegen is much simpler if we unconditionally emit safe calls here
    override fun destroy() {
        
    Disposable.destroy(
        this.`duration`, 
        this.`height`, 
        this.`width`, 
        this.`mimetype`, 
        this.`size`, 
        this.`thumbnailInfo`, 
        this.`thumbnailSource`, 
        this.`blurhash`)
    }
    
    companion 