/*
 * Decompiled with CFR 0.152.
 */
package org.maxur.mserv.core.embedded.grizzly;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.io.NIOOutputStream;
import org.glassfish.grizzly.http.server.FileCacheFilter;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.StaticHttpHandlerBase;
import org.glassfish.grizzly.http.server.filecache.FileCache;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeType;
import org.glassfish.grizzly.memory.BufferArray;
import org.glassfish.grizzly.memory.MemoryManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxur.mserv.core.domain.Path;
import org.maxur.mserv.core.embedded.grizzly.Root;
import org.maxur.mserv.core.embedded.properties.StaticContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 $2\u00020\u0001:\f!\"#$%&'()*+,B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0005\"\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\n\u0010\u001e\u001a\u00020\u001f*\u00020 R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00060\u0012R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;", "Lorg/glassfish/grizzly/http/server/StaticHttpHandlerBase;", "path", "", "roots", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "Ljava/net/URI;", "(Ljava/lang/String;[Ljava/net/URI;)V", "staticContent", "Lorg/maxur/mserv/core/embedded/properties/StaticContent;", "classLoader", "Ljava/lang/ClassLoader;", "(Lorg/maxur/mserv/core/embedded/properties/StaticContent;Ljava/lang/ClassLoader;)V", "getClassLoader", "()Ljava/lang/ClassLoader;", "defaultPage", "resourceLocator", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$ResourceLocator;", "handle", "", "resourcePath", "request", "Lorg/glassfish/grizzly/http/server/Request;", "response", "Lorg/glassfish/grizzly/http/server/Response;", "respondedFile", "Ljava/io/File;", "url", "Ljava/net/URL;", "close", "", "Ljava/net/JarURLConnection;", "BundleResource", "CLFileResource", "CLRoot", "Companion", "FileResource", "FileRoot", "JarResource", "JarURLInputStream", "RedirectedResource", "Resource", "ResourceLocator", "UnknownResource", "maxur-mserv-core"})
public final class StaticHttpHandler
extends StaticHttpHandlerBase {
    private final ResourceLocator resourceLocator;
    private final String defaultPage;
    @NotNull
    private final ClassLoader classLoader;
    private static final Logger log;
    public static final Companion Companion;

    public boolean handle(@NotNull String resourcePath, @NotNull Request request, @NotNull Response response) throws Exception {
        Resource resource;
        Resource it;
        Intrinsics.checkParameterIsNotNull((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Resource resource2 = this.resourceLocator.find(resourcePath);
        if (resource2 != null && (it = (resource = resource2)).isExist()) {
            return it.handle(request, response);
        }
        Companion.getLog().trace("Resource not found " + resourcePath);
        return false;
    }

    @NotNull
    public final File respondedFile(@NotNull URL url2) {
        Intrinsics.checkParameterIsNotNull((Object)url2, (String)"url");
        File file = new File(url2.toURI());
        if (!file.exists() || !file.isDirectory()) {
            return file;
        }
        File welcomeFile = new File(file, '/' + this.defaultPage);
        if (welcomeFile.exists() && welcomeFile.isFile()) {
            return welcomeFile;
        }
        return file;
    }

    public final void close(@NotNull JarURLConnection $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!$receiver.getUseCaches()) {
            $receiver.getJarFile().close();
        }
    }

    @NotNull
    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public StaticHttpHandler(@NotNull StaticContent staticContent, @NotNull ClassLoader classLoader) {
        Intrinsics.checkParameterIsNotNull((Object)staticContent, (String)"staticContent");
        Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
        this.classLoader = classLoader;
        this.resourceLocator = new ResourceLocator(this.classLoader, staticContent);
        String string2 = staticContent.getPage();
        if (string2 == null) {
            string2 = "index.html";
        }
        this.defaultPage = string2;
    }

    public /* synthetic */ StaticHttpHandler(StaticContent staticContent, ClassLoader classLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ClassLoader classLoader2 = StaticHttpHandler.class.getClassLoader();
            Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"StaticHttpHandler::class.java.classLoader");
            classLoader = classLoader2;
        }
        this(staticContent, classLoader);
    }

    /*
     * WARNING - void declaration
     */
    public StaticHttpHandler(@NotNull String path, String ... roots) {
        Collection<URI> collection;
        void $receiver$iv$iv;
        Collection $receiver$iv;
        StaticContent staticContent;
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)roots, (String)"roots");
        Object[] objectArray = roots;
        Path path2 = new Path(path);
        StaticContent staticContent2 = staticContent;
        StaticContent staticContent3 = staticContent;
        StaticHttpHandler staticHttpHandler = this;
        void var4_8 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void it;
            void item$iv$iv = $receiver$iv$iv[i];
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            URI uRI = URI.create((String)it);
            collection.add(uRI);
        }
        collection = (List)destination$iv$iv;
        Collection thisCollection$iv = $receiver$iv = (Collection)collection;
        URI[] uRIArray = thisCollection$iv.toArray(new URI[thisCollection$iv.size()]);
        if (uRIArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        collection = uRIArray;
        staticContent2(path2, (URI[])collection, null, null, 12, null);
        staticHttpHandler(staticContent3, null, 2, null);
    }

    public StaticHttpHandler(@NotNull String path, URI ... roots) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)roots, (String)"roots");
        this(new StaticContent(new Path(path), Arrays.copyOf(roots, roots.length), null, null, 12, null), null, 2, null);
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(StaticHttpHandler.class);
    }

    public static final /* synthetic */ void access$addCachingHeaders$s677078821(Response p0, File p1) {
        StaticHttpHandlerBase.addCachingHeaders((Response)p0, (File)p1);
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$CLFileResource;", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$Resource;", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;", "url", "Ljava/net/URL;", "resourcePath", "", "file", "Ljava/io/File;", "path", "(Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;Ljava/net/URL;Ljava/lang/String;Ljava/io/File;Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "getUrl", "()Ljava/net/URL;", "isExist", "", "mustBeRedirected", "process", "", "request", "Lorg/glassfish/grizzly/http/server/Request;", "response", "Lorg/glassfish/grizzly/http/server/Response;", "maxur-mserv-core"})
    public final class CLFileResource
    extends Resource {
        @NotNull
        private final URL url;
        private final File file;
        @NotNull
        private final String path;
        final /* synthetic */ StaticHttpHandler this$0;

        @Override
        public boolean mustBeRedirected(@NotNull String resourcePath) {
            Intrinsics.checkParameterIsNotNull((Object)resourcePath, (String)"resourcePath");
            return this.file.isDirectory() && !StringsKt.endsWith$default((String)resourcePath, (String)"/", (boolean)false, (int)2, null);
        }

        @Override
        public boolean isExist() {
            return this.file.exists();
        }

        @Override
        public void process(@NotNull Request request, @NotNull Response response) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
            this.this$0.addToFileCache(request, response, this.file);
            StaticHttpHandlerBase.sendFile((Response)response, (File)this.file);
        }

        @NotNull
        public final URL getUrl() {
            return this.url;
        }

        @Override
        @NotNull
        public String getPath() {
            return this.path;
        }

        public CLFileResource(@NotNull StaticHttpHandler $outer, @NotNull URL url2, @NotNull String resourcePath, @NotNull File file, String path) {
            Intrinsics.checkParameterIsNotNull((Object)url2, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)resourcePath, (String)"resourcePath");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            this.this$0 = $outer;
            this.url = url2;
            this.file = file;
            this.path = path;
        }

        public /* synthetic */ CLFileResource(StaticHttpHandler staticHttpHandler, URL uRL, String string2, File file, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                file = staticHttpHandler.respondedFile(uRL);
            }
            if ((n & 8) != 0) {
                string3 = string2;
            }
            this(staticHttpHandler, uRL, string2, file, string3);
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$JarURLInputStream;", "Ljava/io/FilterInputStream;", "jarConnection", "Ljava/net/JarURLConnection;", "src", "Ljava/io/InputStream;", "(Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;Ljava/net/JarURLConnection;Ljava/io/InputStream;)V", "close", "", "maxur-mserv-core"})
    public final class JarURLInputStream
    extends FilterInputStream {
        private final JarURLConnection jarConnection;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                super.close();
            }
            finally {
                StaticHttpHandler.this.close(this.jarConnection);
            }
        }

        public JarURLInputStream(@NotNull JarURLConnection jarConnection, InputStream src) {
            Intrinsics.checkParameterIsNotNull((Object)jarConnection, (String)"jarConnection");
            Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
            super(src);
            this.jarConnection = jarConnection;
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\u0007H\u0003J\b\u0010\u001f\u001a\u00020\u0017H\u0016J\u001e\u0010 \u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\"\u0012\u0004\u0012\u00020#0!2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u0007H\u0016J\u0018\u0010(\u001a\u00020)2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0018\u00010\u0015R\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$JarResource;", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$Resource;", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;", "url", "Ljava/net/URL;", "(Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;Ljava/net/URL;)V", "filePath", "", "getFilePath", "()Ljava/lang/String;", "setFilePath", "(Ljava/lang/String;)V", "path", "getPath", "getUrl", "()Ljava/net/URL;", "urlConnection", "Ljava/net/URLConnection;", "getUrlConnection", "()Ljava/net/URLConnection;", "urlInputStream", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$JarURLInputStream;", "addTimeStampEntryToFileCache", "", "request", "Lorg/glassfish/grizzly/http/server/Request;", "response", "Lorg/glassfish/grizzly/http/server/Response;", "archive", "Ljava/io/File;", "getJarFile", "isExist", "makeInputStream", "Lkotlin/Pair;", "Ljava/io/InputStream;", "Ljava/util/jar/JarEntry;", "jarUrlConnection", "Ljava/net/JarURLConnection;", "mustBeRedirected", "resourcePath", "process", "", "maxur-mserv-core"})
    public final class JarResource
    extends Resource {
        @NotNull
        private final URLConnection urlConnection;
        @Nullable
        private String filePath;
        @NotNull
        private final String path;
        private JarURLInputStream urlInputStream;
        @NotNull
        private final URL url;

        @NotNull
        public final URLConnection getUrlConnection() {
            return this.urlConnection;
        }

        @Nullable
        public final String getFilePath() {
            return this.filePath;
        }

        public final void setFilePath(@Nullable String string2) {
            this.filePath = string2;
        }

        @Override
        @NotNull
        public String getPath() {
            String string2 = this.filePath;
            if (string2 == null) {
                string2 = this.path;
            }
            return string2;
        }

        @Override
        public boolean mustBeRedirected(@NotNull String resourcePath) {
            Intrinsics.checkParameterIsNotNull((Object)resourcePath, (String)"resourcePath");
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean isExist() {
            void iinputStream;
            URLConnection uRLConnection = this.urlConnection;
            if (uRLConnection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.net.JarURLConnection");
            }
            JarURLConnection jarUrlConnection = (JarURLConnection)uRLConnection;
            Pair<InputStream, JarEntry> pair = this.makeInputStream(jarUrlConnection);
            InputStream inputStream = (InputStream)pair.component1();
            JarEntry jarEntry = (JarEntry)pair.component2();
            if (iinputStream != null) {
                this.urlInputStream = new JarURLInputStream(jarUrlConnection, (InputStream)iinputStream);
                this.filePath = jarEntry.getName();
                return true;
            }
            StaticHttpHandler.this.close(jarUrlConnection);
            return false;
        }

        private final Pair<InputStream, JarEntry> makeInputStream(JarURLConnection jarUrlConnection) {
            JarFile jarFile = jarUrlConnection.getJarFile();
            JarEntry jarEntry = jarUrlConnection.getJarEntry();
            Intrinsics.checkExpressionValueIsNotNull((Object)jarEntry, (String)"jarUrlConnection.jarEntry");
            JarEntry jarEntry2 = jarEntry;
            InputStream iinputStream = jarFile.getInputStream(jarEntry2);
            if (jarEntry2.isDirectory() || iinputStream == null) {
                String welcomeResource = StringsKt.endsWith$default((String)jarEntry2.getName(), (String)"/", (boolean)false, (int)2, null) ? "" + jarEntry2.getName() + "" + StaticHttpHandler.this.defaultPage : "" + jarEntry2.getName() + '/' + StaticHttpHandler.this.defaultPage;
                JarEntry jarEntry3 = jarFile.getJarEntry(welcomeResource);
                Intrinsics.checkExpressionValueIsNotNull((Object)jarEntry3, (String)"jarFile.getJarEntry(welcomeResource)");
                jarEntry2 = jarEntry3;
                if (jarEntry2 != null) {
                    iinputStream = jarFile.getInputStream(jarEntry2);
                }
            }
            return new Pair((Object)iinputStream, (Object)jarEntry2);
        }

        @Override
        public void process(@NotNull Request request, @NotNull Response response) {
            InputStream inputStream;
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
            String string2 = new URI(this.url.getPath()).getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"URI(url.path).path");
            File jarFile = this.getJarFile(string2);
            this.addTimeStampEntryToFileCache(request, response, jarFile);
            JarURLInputStream jarURLInputStream = this.urlInputStream;
            if (jarURLInputStream != null) {
                inputStream = jarURLInputStream;
            } else {
                inputStream = this.urlConnection.getInputStream();
                if (inputStream == null) {
                    Intrinsics.throwNpe();
                }
            }
            InputStream stream = inputStream;
            this.sendResource(response, stream);
        }

        private final boolean addTimeStampEntryToFileCache(Request request, Response response, File archive) {
            if (!StaticHttpHandler.this.isFileCacheEnabled()) {
                return false;
            }
            FileCacheFilter fileCacheFilter = StaticHttpHandler.this.lookupFileCache(request.getContext());
            if (fileCacheFilter == null) {
                return false;
            }
            FileCacheFilter fileCacheFilter2 = fileCacheFilter;
            FileCache fileCache = fileCacheFilter2.getFileCache();
            if (!fileCache.isEnabled()) {
                return false;
            }
            StaticHttpHandler.access$addCachingHeaders$s677078821(response, archive);
            fileCache.add(request.getRequest(), archive.lastModified());
            return true;
        }

        private final File getJarFile(String path) throws MalformedURLException, FileNotFoundException {
            File file;
            int jarDelimIdx = StringsKt.indexOf$default((CharSequence)path, (String)"!/", (int)0, (boolean)false, (int)6, null);
            if (jarDelimIdx == -1) {
                throw (Throwable)new MalformedURLException("The jar file delimiter were not found");
            }
            String string2 = path;
            int n = 0;
            File file2 = file;
            File file3 = file;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, jarDelimIdx);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string5 = string4;
            file2(string5);
            File file4 = file3;
            if (file4.exists() && file4.isFile()) {
                return file4;
            }
            throw (Throwable)new FileNotFoundException("The jar file was not found");
        }

        @NotNull
        public final URL getUrl() {
            return this.url;
        }

        public JarResource(URL url2) {
            Intrinsics.checkParameterIsNotNull((Object)url2, (String)"url");
            this.url = url2;
            URLConnection uRLConnection = this.url.openConnection();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRLConnection, (String)"url.openConnection()");
            this.urlConnection = uRLConnection;
            String string2 = this.url.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url.path");
            this.path = string2;
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0018\u001a\u00020\u0006H\u0016J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u000bH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$BundleResource;", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$Resource;", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;", "url", "Ljava/net/URL;", "mayBeFolder", "", "(Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;Ljava/net/URL;Z)V", "getMayBeFolder", "()Z", "path", "", "getPath", "()Ljava/lang/String;", "getUrl", "()Ljava/net/URL;", "setUrl", "(Ljava/net/URL;)V", "urlConnection", "Ljava/net/URLConnection;", "getUrlConnection", "()Ljava/net/URLConnection;", "setUrlConnection", "(Ljava/net/URLConnection;)V", "isExist", "mustBeRedirected", "resourcePath", "process", "", "request", "Lorg/glassfish/grizzly/http/server/Request;", "response", "Lorg/glassfish/grizzly/http/server/Response;", "maxur-mserv-core"})
    public final class BundleResource
    extends Resource {
        @NotNull
        private URLConnection urlConnection;
        @NotNull
        private final String path;
        @NotNull
        private URL url;
        private final boolean mayBeFolder;

        @Override
        public boolean mustBeRedirected(@NotNull String resourcePath) {
            Intrinsics.checkParameterIsNotNull((Object)resourcePath, (String)"resourcePath");
            return false;
        }

        @NotNull
        public final URLConnection getUrlConnection() {
            return this.urlConnection;
        }

        public final void setUrlConnection(@NotNull URLConnection uRLConnection) {
            Intrinsics.checkParameterIsNotNull((Object)uRLConnection, (String)"<set-?>");
            this.urlConnection = uRLConnection;
        }

        @Override
        @NotNull
        public String getPath() {
            return this.path;
        }

        @Override
        public boolean isExist() {
            URL welcomeUrl;
            if (this.mayBeFolder && this.urlConnection.getContentLength() <= 0 && (welcomeUrl = StaticHttpHandler.this.getClassLoader().getResource("" + this.url.getPath() + '/' + StaticHttpHandler.this.defaultPage)) != null) {
                this.url = welcomeUrl;
                URLConnection uRLConnection = welcomeUrl.openConnection();
                Intrinsics.checkExpressionValueIsNotNull((Object)uRLConnection, (String)"welcomeUrl.openConnection()");
                this.urlConnection = uRLConnection;
            }
            return true;
        }

        @Override
        public void process(@NotNull Request request, @NotNull Response response) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
            InputStream inputStream = this.urlConnection.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"urlConnection.getInputStream()");
            this.sendResource(response, inputStream);
        }

        @NotNull
        public final URL getUrl() {
            return this.url;
        }

        public final void setUrl(@NotNull URL uRL) {
            Intrinsics.checkParameterIsNotNull((Object)uRL, (String)"<set-?>");
            this.url = uRL;
        }

        public final boolean getMayBeFolder() {
            return this.mayBeFolder;
        }

        public BundleResource(URL url2, boolean mayBeFolder) {
            Intrinsics.checkParameterIsNotNull((Object)url2, (String)"url");
            this.url = url2;
            this.mayBeFolder = mayBeFolder;
            URLConnection uRLConnection = this.url.openConnection();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRLConnection, (String)"url.openConnection()");
            this.urlConnection = uRLConnection;
            String string2 = this.url.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url.path");
            this.path = string2;
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$UnknownResource;", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$Resource;", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;", "url", "Ljava/net/URL;", "(Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;Ljava/net/URL;)V", "path", "", "getPath", "()Ljava/lang/String;", "getUrl", "()Ljava/net/URL;", "urlConnection", "Ljava/net/URLConnection;", "getUrlConnection", "()Ljava/net/URLConnection;", "setUrlConnection", "(Ljava/net/URLConnection;)V", "isExist", "", "mustBeRedirected", "resourcePath", "process", "", "request", "Lorg/glassfish/grizzly/http/server/Request;", "response", "Lorg/glassfish/grizzly/http/server/Response;", "maxur-mserv-core"})
    public final class UnknownResource
    extends Resource {
        @NotNull
        private final String path;
        @NotNull
        private URLConnection urlConnection;
        @NotNull
        private final URL url;

        @Override
        public boolean mustBeRedirected(@NotNull String resourcePath) {
            Intrinsics.checkParameterIsNotNull((Object)resourcePath, (String)"resourcePath");
            return false;
        }

        @Override
        @NotNull
        public String getPath() {
            return this.path;
        }

        @NotNull
        public final URLConnection getUrlConnection() {
            return this.urlConnection;
        }

        public final void setUrlConnection(@NotNull URLConnection uRLConnection) {
            Intrinsics.checkParameterIsNotNull((Object)uRLConnection, (String)"<set-?>");
            this.urlConnection = uRLConnection;
        }

        @Override
        public boolean isExist() {
            return true;
        }

        @Override
        public void process(@NotNull Request request, @NotNull Response response) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
            InputStream inputStream = this.urlConnection.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"urlConnection.getInputStream()");
            this.sendResource(response, inputStream);
        }

        @NotNull
        public final URL getUrl() {
            return this.url;
        }

        public UnknownResource(URL url2) {
            Intrinsics.checkParameterIsNotNull((Object)url2, (String)"url");
            this.url = url2;
            String string2 = this.url.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url.path");
            this.path = string2;
            URLConnection uRLConnection = this.url.openConnection();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRLConnection, (String)"url.openConnection()");
            this.urlConnection = uRLConnection;
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0006\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$RedirectedResource;", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$Resource;", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;", "url", "", "(Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;Ljava/lang/String;)V", "path", "getPath", "()Ljava/lang/String;", "isExist", "", "mustBeRedirected", "resourcePath", "process", "", "request", "Lorg/glassfish/grizzly/http/server/Request;", "response", "Lorg/glassfish/grizzly/http/server/Response;", "maxur-mserv-core"})
    public final class RedirectedResource
    extends Resource {
        @NotNull
        private final String path;

        @Override
        public boolean mustBeRedirected(@NotNull String resourcePath) {
            Intrinsics.checkParameterIsNotNull((Object)resourcePath, (String)"resourcePath");
            return false;
        }

        @Override
        @NotNull
        public String getPath() {
            return this.path;
        }

        @Override
        public boolean isExist() {
            return true;
        }

        @Override
        public void process(@NotNull Request request, @NotNull Response response) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
            response.setStatus(HttpStatus.MOVED_PERMANENTLY_301);
            response.setHeader(Header.Location, response.encodeRedirectURL("" + this.getPath() + '/'));
        }

        public RedirectedResource(String url2) {
            Intrinsics.checkParameterIsNotNull((Object)url2, (String)"url");
            this.path = url2;
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00a6\u0004\u0018\u00002\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\bH&J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0004H&J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0004J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0005J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$Resource;", "", "(Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;)V", "path", "", "getPath", "()Ljava/lang/String;", "handle", "", "request", "Lorg/glassfish/grizzly/http/server/Request;", "response", "Lorg/glassfish/grizzly/http/server/Response;", "isExist", "isGet", "methodIsNotAllowed", "resource", "mustBeRedirected", "resourcePath", "pickupContentType", "", "process", "sendResource", "input", "Ljava/io/InputStream;", "success", "NonBlockingDownloadHandler", "maxur-mserv-core"})
    public abstract class Resource {
        @NotNull
        public abstract String getPath();

        public final boolean handle(@NotNull Request request, @NotNull Response response) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
            return this.isGet(request) ? this.success(response, request) : this.methodIsNotAllowed(this.getPath(), request, response);
        }

        private final boolean isGet(Request request) {
            return Intrinsics.areEqual((Object)Method.GET, (Object)request.getMethod());
        }

        private final boolean success(Response response, Request request) {
            this.pickupContentType(response, this.getPath());
            this.process(request, response);
            return true;
        }

        private final boolean methodIsNotAllowed(String resource, Request request, Response response) {
            Companion.getLog().trace("File found " + resource + ", but HTTP method " + request.getMethod() + " is not allowed");
            response.setStatus(HttpStatus.METHOD_NOT_ALLOWED_405);
            response.setHeader(Header.Allow, "GET");
            return true;
        }

        public abstract boolean isExist();

        public abstract void process(@NotNull Request var1, @NotNull Response var2);

        protected final void pickupContentType(@NotNull Response response, @NotNull String path) {
            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            if (response.getResponse().isContentTypeSet()) {
                return;
            }
            int dot = StringsKt.lastIndexOf$default((CharSequence)path, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (dot > 0) {
                String string2 = path;
                int n = dot + 1;
                String string3 = string2.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                String ext = string3;
                String ct = MimeType.get((String)ext);
                if (ct != null) {
                    response.setContentType(ct);
                }
            } else {
                response.setContentType(MimeType.get((String)"html"));
            }
        }

        protected final void sendResource(@NotNull Response response, @NotNull InputStream input) throws IOException {
            NIOOutputStream outputStream;
            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            response.setStatus(HttpStatus.OK_200);
            response.addDateHeader(Header.Date, System.currentTimeMillis());
            int chunkSize = 8192;
            response.suspend();
            NIOOutputStream nIOOutputStream = outputStream = response.getNIOOutputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)nIOOutputStream, (String)"outputStream");
            outputStream.notifyCanWrite((WriteHandler)new NonBlockingDownloadHandler(response, nIOOutputStream, input, chunkSize));
        }

        public abstract boolean mustBeRedirected(@NotNull String var1);

        @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u000eH\u0017J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\b\u0010\u001d\u001a\u00020\u0012H\u0003R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$Resource$NonBlockingDownloadHandler;", "Lorg/glassfish/grizzly/WriteHandler;", "response", "Lorg/glassfish/grizzly/http/server/Response;", "outputStream", "Lorg/glassfish/grizzly/http/io/NIOOutputStream;", "inputStream", "Ljava/io/InputStream;", "chunkSize", "", "(Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$Resource;Lorg/glassfish/grizzly/http/server/Response;Lorg/glassfish/grizzly/http/io/NIOOutputStream;Ljava/io/InputStream;I)V", "mm", "Lorg/glassfish/grizzly/memory/MemoryManager;", "closeStream", "", "stream", "Ljava/io/Closeable;", "isError", "", "complete", "directAllocateBuffer", "Lorg/glassfish/grizzly/Buffer;", "indirectAllocateBuffer", "onError", "t", "", "onWritePossible", "readCompositeBuffer", "buffer", "sendChunk", "maxur-mserv-core"})
        private final class NonBlockingDownloadHandler
        implements WriteHandler {
            private final MemoryManager<?> mm;
            private final Response response;
            private final NIOOutputStream outputStream;
            private final InputStream inputStream;
            private final int chunkSize;

            public void onWritePossible() throws Exception {
                Companion.getLog().trace("[onWritePossible]");
                boolean isWriteMore = this.sendChunk();
                if (isWriteMore) {
                    this.outputStream.notifyCanWrite((WriteHandler)this);
                }
            }

            public void onError(@NotNull Throwable t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                Companion.getLog().trace("[onError] ", t);
                this.response.setStatus(500, t.getMessage());
                this.complete(true);
            }

            private final boolean sendChunk() throws IOException {
                Buffer buffer;
                Buffer buffer2 = buffer = !this.mm.willAllocateDirect(this.chunkSize) ? this.indirectAllocateBuffer() : this.directAllocateBuffer();
                if (buffer == null) {
                    this.complete(false);
                    return false;
                }
                buffer.allowBufferDispose(true);
                buffer.trim();
                this.outputStream.write(buffer);
                return true;
            }

            private final Buffer directAllocateBuffer() {
                byte[] buf = new byte[this.chunkSize];
                int len = this.inputStream.read(buf);
                if (len <= 0) {
                    return null;
                }
                Buffer buffer = this.mm.allocate(len);
                Intrinsics.checkExpressionValueIsNotNull((Object)buffer, (String)"mm.allocate(len)");
                Buffer buffer2 = buffer;
                buffer2.put(buf);
                return buffer2;
            }

            private final Buffer indirectAllocateBuffer() {
                int len;
                Buffer buffer = this.mm.allocate(this.chunkSize);
                Intrinsics.checkExpressionValueIsNotNull((Object)buffer, (String)"mm.allocate(chunkSize)");
                Buffer buffer2 = buffer;
                int n = len = buffer2.isComposite() ? this.readCompositeBuffer(buffer2) : this.inputStream.read(buffer2.array(), buffer2.position() + buffer2.arrayOffset(), this.chunkSize);
                if (len > 0) {
                    buffer2.position(buffer2.position() + len);
                } else {
                    buffer2.dispose();
                }
                if (len > 0) {
                    return buffer2;
                }
                return null;
            }

            /*
             * WARNING - void declaration
             */
            private final int readCompositeBuffer(Buffer buffer) {
                BufferArray bufferArray = buffer.toBufferArray();
                int size = bufferArray.size();
                Buffer[] buffers = (Buffer[])bufferArray.getArray();
                int lenCounter = 0;
                int n = 0;
                int n2 = size - 1;
                if (n <= n2) {
                    while (true) {
                        void i;
                        Buffer subBuffer = buffers[i];
                        int subBufferLen = subBuffer.remaining();
                        int justReadLen = this.inputStream.read(subBuffer.array(), subBuffer.position() + subBuffer.arrayOffset(), subBufferLen);
                        if (justReadLen > 0) {
                            lenCounter += justReadLen;
                        }
                        if (justReadLen < subBufferLen || i == n2) break;
                        ++i;
                    }
                }
                bufferArray.restore();
                bufferArray.recycle();
                return lenCounter > 0 ? lenCounter : -1;
            }

            private final void complete(boolean isError) {
                this.closeStream(this.inputStream, isError);
                this.closeStream((Closeable)this.outputStream, isError);
                if (this.response.isSuspended()) {
                    this.response.resume();
                } else {
                    this.response.finish();
                }
            }

            private final void closeStream(Closeable stream, boolean isError) {
                block2: {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        if (isError) break block2;
                        this.response.setStatus(500, e.getMessage());
                    }
                }
            }

            public NonBlockingDownloadHandler(@NotNull Response response, @NotNull NIOOutputStream outputStream, InputStream inputStream, int chunkSize) {
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
                Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
                this.response = response;
                this.outputStream = outputStream;
                this.inputStream = inputStream;
                this.chunkSize = chunkSize;
                MemoryManager memoryManager = this.response.getRequest().getContext().getMemoryManager();
                Intrinsics.checkExpressionValueIsNotNull((Object)memoryManager, (String)"response.getRequest().context.memoryManager");
                this.mm = memoryManager;
            }
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0010\u001a\b\u0018\u00010\u0011R\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nJ\u0016\u0010\u0014\u001a\b\u0018\u00010\u0011R\u00020\u00122\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$ResourceLocator;", "", "classLoader", "Ljava/lang/ClassLoader;", "staticContent", "Lorg/maxur/mserv/core/embedded/properties/StaticContent;", "(Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;Ljava/lang/ClassLoader;Lorg/maxur/mserv/core/embedded/properties/StaticContent;)V", "CHECK_NON_SLASH_TERMINATED_FOLDERS", "", "CHECK_NON_SLASH_TERMINATED_FOLDERS_PROP", "", "getClassLoader", "()Ljava/lang/ClassLoader;", "roots", "", "Lorg/maxur/mserv/core/embedded/grizzly/Root;", "find", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$Resource;", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;", "resourcePath", "findDefaultPage", "folderPath", "makeRoot", "uri", "Ljava/net/URI;", "makeRoots", "maxur-mserv-core"})
    public final class ResourceLocator {
        private final Set<Root> roots;
        private final String CHECK_NON_SLASH_TERMINATED_FOLDERS_PROP;
        private final boolean CHECK_NON_SLASH_TERMINATED_FOLDERS;
        @NotNull
        private final ClassLoader classLoader;

        private final Set<Root> makeRoots(StaticContent staticContent) {
            Root root;
            Root it;
            Collection collection;
            Object item$iv$iv;
            Object $receiver$iv$iv;
            Object $receiver$iv = staticContent.getRoots();
            Object[] objectArray = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(((Object[])$receiver$iv).length);
            for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                item$iv$iv = $receiver$iv$iv[i];
                URI uRI = (URI)item$iv$iv;
                collection = destination$iv$iv;
                root = this.makeRoot((URI)((Object)it));
                collection.add(root);
            }
            $receiver$iv = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                item$iv$iv = iterator.next();
                it = (Root)item$iv$iv;
                collection = destination$iv$iv;
                root = it.validate();
                collection.add(root);
            }
            HashSet set = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
            Collection collection2 = set;
            if (!collection2.isEmpty()) {
                return set;
            }
            return SetsKt.setOf((Object)new CLRoot(StaticHttpHandler.this, "", this.classLoader));
        }

        /*
         * Unable to fully structure code
         */
        private final Root makeRoot(URI uri) {
            block5: {
                block4: {
                    v0 = var2_2 = uri.getScheme();
                    if (v0 == null) ** GOTO lbl10
                    switch (v0.hashCode()) {
                        case 3143036: {
                            if (!var2_2.equals("file")) ** break;
                            break;
                        }
                        case -8875619: {
                            if (!var2_2.equals("classpath")) ** break;
                            break block4;
                        }
lbl10:
                        // 1 sources

                        v1 = new FileRoot(new File(uri.toString()));
                        break block5;
                    }
                    v2 = Paths.get(uri).toFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"Paths.get(uri).toFile()");
                    v1 = new FileRoot(v2);
                    break block5;
                }
                v1 = new CLRoot(StaticHttpHandler.this, uri, this.classLoader);
                break block5;
                v1 = null;
            }
            return v1;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Resource find(@NotNull String resourcePath) {
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)resourcePath, (String)"resourcePath");
            String path = StringsKt.trimStart((String)resourcePath, (char[])new char[]{'/'});
            Object object = path;
            if (object.length() == 0 || StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
                return this.findDefaultPage(path);
            }
            Iterable $receiver$iv = this.roots;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Root root = (Root)item$iv$iv;
                Collection collection = destination$iv$iv;
                Resource resource = it.lookupResource(path, true);
                collection.add(resource);
            }
            Resource resource = (Resource)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (resource != null) {
                object = resource;
                Object it = object;
                return ((Resource)it).mustBeRedirected(resourcePath) ? (Resource)new RedirectedResource(resourcePath) : it;
            }
            if (this.CHECK_NON_SLASH_TERMINATED_FOLDERS) {
                return this.findDefaultPage(path + "/");
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private final Resource findDefaultPage(String folderPath) {
            void $receiver$iv$iv;
            Iterable $receiver$iv = this.roots;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Root root = (Root)item$iv$iv;
                Collection collection = destination$iv$iv;
                Resource resource = it.lookupResource(folderPath + StaticHttpHandler.this.defaultPage, false);
                collection.add(resource);
            }
            Resource resource = (Resource)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (resource != null) {
                Resource resource2;
                Resource it = resource2 = resource;
                return it;
            }
            return null;
        }

        @NotNull
        public final ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public ResourceLocator(@NotNull ClassLoader classLoader, StaticContent staticContent) {
            Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
            Intrinsics.checkParameterIsNotNull((Object)staticContent, (String)"staticContent");
            this.classLoader = classLoader;
            this.roots = this.makeRoots(staticContent);
            this.CHECK_NON_SLASH_TERMINATED_FOLDERS_PROP = StaticHttpHandler.class.getName() + ".check-non-slash-terminated-folders";
            this.CHECK_NON_SLASH_TERMINATED_FOLDERS = System.getProperty(this.CHECK_NON_SLASH_TERMINATED_FOLDERS_PROP) == null || Boolean.getBoolean(this.CHECK_NON_SLASH_TERMINATED_FOLDERS_PROP);
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$FileResource;", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$Resource;", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;", "folder", "Ljava/io/File;", "resourcePath", "", "file", "(Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;Ljava/io/File;Ljava/lang/String;Ljava/io/File;)V", "path", "getPath", "()Ljava/lang/String;", "isExist", "", "mustBeRedirected", "process", "", "request", "Lorg/glassfish/grizzly/http/server/Request;", "response", "Lorg/glassfish/grizzly/http/server/Response;", "maxur-mserv-core"})
    public final class FileResource
    extends Resource {
        @NotNull
        private final String path;
        private final File file;
        final /* synthetic */ StaticHttpHandler this$0;

        @Override
        public boolean mustBeRedirected(@NotNull String resourcePath) {
            Intrinsics.checkParameterIsNotNull((Object)resourcePath, (String)"resourcePath");
            return this.file.isDirectory() && !StringsKt.endsWith$default((String)resourcePath, (String)"/", (boolean)false, (int)2, null);
        }

        @Override
        @NotNull
        public String getPath() {
            return this.path;
        }

        @Override
        public boolean isExist() {
            return this.file.exists();
        }

        @Override
        public void process(@NotNull Request request, @NotNull Response response) {
            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
            Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
            if (this.file.exists()) {
                this.this$0.addToFileCache(request, response, this.file);
                StaticHttpHandlerBase.sendFile((Response)response, (File)this.file);
            }
        }

        public FileResource(@NotNull StaticHttpHandler $outer, @NotNull File folder, @NotNull String resourcePath, File file) {
            Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
            Intrinsics.checkParameterIsNotNull((Object)resourcePath, (String)"resourcePath");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            this.this$0 = $outer;
            this.file = file;
            String string2 = this.file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.path");
            this.path = string2;
        }

        public /* synthetic */ FileResource(StaticHttpHandler staticHttpHandler, File file, String string2, File file2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                file2 = new File(file, string2);
            }
            this(staticHttpHandler, file, string2, file2);
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\b\u0018\u00010\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0001H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$FileRoot;", "Lorg/maxur/mserv/core/embedded/grizzly/Root;", "file", "Ljava/io/File;", "(Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "lookupResource", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$Resource;", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;", "resourcePath", "", "mayBeFolder", "", "validate", "maxur-mserv-core"})
    public final class FileRoot
    implements Root {
        @NotNull
        private final File file;

        @Override
        @NotNull
        public Root validate() {
            return this;
        }

        @Override
        @Nullable
        public Resource lookupResource(@NotNull String resourcePath, boolean mayBeFolder) {
            Intrinsics.checkParameterIsNotNull((Object)resourcePath, (String)"resourcePath");
            return new FileResource(StaticHttpHandler.this, this.file, resourcePath, null, 4, null);
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public FileRoot(File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            this.file = file;
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u000e\u001a\b\u0018\u00010\u000fR\u00020\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J$\u0010\u0014\u001a\u00060\u000fR\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0017\u001a\u00020\u0001H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$CLRoot;", "Lorg/maxur/mserv/core/embedded/grizzly/Root;", "uri", "Ljava/net/URI;", "classLoader", "Ljava/lang/ClassLoader;", "(Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;Ljava/net/URI;Ljava/lang/ClassLoader;)V", "path", "", "(Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;Ljava/lang/String;Ljava/lang/ClassLoader;)V", "getClassLoader", "()Ljava/lang/ClassLoader;", "getPath", "()Ljava/lang/String;", "lookupResource", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$Resource;", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;", "resourcePath", "mayBeFolder", "", "make", "url", "Ljava/net/URL;", "validate", "maxur-mserv-core"})
    public final class CLRoot
    implements Root {
        @NotNull
        private final String path;
        @NotNull
        private final ClassLoader classLoader;
        final /* synthetic */ StaticHttpHandler this$0;

        @Override
        @NotNull
        public Root validate() {
            if (!StringsKt.endsWith$default((String)this.path, (String)"/", (boolean)false, (int)2, null)) {
                throw (Throwable)new IllegalArgumentException("Doc root should end with slash ('/')");
            }
            return this;
        }

        @Override
        @Nullable
        public Resource lookupResource(@NotNull String resourcePath, boolean mayBeFolder) {
            URL uRL;
            URL it;
            Resource resource;
            Intrinsics.checkParameterIsNotNull((Object)resourcePath, (String)"resourcePath");
            URL uRL2 = this.classLoader.getResource(this.path + resourcePath);
            if (uRL2 != null && (resource = this.make(resourcePath, it = (uRL = uRL2), mayBeFolder)).isExist()) {
                return resource;
            }
            return null;
        }

        /*
         * Unable to fully structure code
         */
        private final Resource make(String path, URL url, boolean mayBeFolder) {
            block8: {
                block5: {
                    block7: {
                        block6: {
                            v0 = var4_4 = url.getProtocol();
                            if (v0 == null) break block5;
                            switch (v0.hashCode()) {
                                case 3143036: {
                                    if (!var4_4.equals("file")) ** break;
                                    break;
                                }
                                case 104987: {
                                    if (!var4_4.equals("jar")) ** break;
                                    break block6;
                                }
                                case -1377881982: {
                                    if (!var4_4.equals("bundle")) ** break;
                                    break block7;
                                }
                            }
                            v1 = new CLFileResource(this.this$0, url, path, null, null, 12, null);
                            break block8;
                        }
                        v1 = this.this$0.new JarResource(url);
                        break block8;
                    }
                    v1 = this.this$0.new BundleResource(url, mayBeFolder);
                    break block8;
                }
                v1 = this.this$0.new UnknownResource(url);
            }
            return v1;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public CLRoot(@NotNull StaticHttpHandler $outer, @NotNull String path, ClassLoader classLoader) {
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
            this.this$0 = $outer;
            this.path = path;
            this.classLoader = classLoader;
        }

        public CLRoot(@NotNull StaticHttpHandler $outer, @NotNull URI uri, ClassLoader classLoader) {
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            Intrinsics.checkParameterIsNotNull((Object)classLoader, (String)"classLoader");
            String string2 = uri.toString();
            int n = 10;
            StaticHttpHandler staticHttpHandler = $outer;
            CLRoot cLRoot = this;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            String string5 = string4;
            cLRoot(staticHttpHandler, StringsKt.trimStart((String)string5, (char[])new char[]{'/'}), classLoader);
        }
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "maxur-mserv-core"})
    public static final class Companion {
        public final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

