/*
 * Decompiled with CFR 0.152.
 */
package org.maxur.mserv.core.embedded.grizzly;

import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.Application;
import jersey.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpHandlerRegistration;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.utils.Charsets;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.process.JerseyProcessingUncaughtExceptionHandler;
import org.jetbrains.annotations.NotNull;
import org.maxur.mserv.core.domain.BaseService;
import org.maxur.mserv.core.embedded.WebAppConfig;
import org.maxur.mserv.core.embedded.WebEntries;
import org.maxur.mserv.core.embedded.WebServer;
import org.maxur.mserv.core.embedded.grizzly.GrizzlyHttpContainer;
import org.maxur.mserv.core.embedded.grizzly.StaticHttpHandler;
import org.maxur.mserv.core.embedded.properties.StaticContent;
import org.maxur.mserv.core.kotlin.Locator;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\"\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\b\u0010'\u001a\u00020\u001aH\u0014J\b\u0010(\u001a\u00020\u001aH\u0014J\f\u0010)\u001a\u00020\u000f*\u00020*H\u0002R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u00020\u000f8VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006+"}, d2={"Lorg/maxur/mserv/core/embedded/grizzly/WebServerGrizzlyImpl;", "Lorg/maxur/mserv/core/domain/BaseService;", "Lorg/maxur/mserv/core/embedded/WebServer;", "config", "Lorg/maxur/mserv/core/embedded/WebAppConfig;", "locator", "Lorg/maxur/mserv/core/kotlin/Locator;", "(Lorg/maxur/mserv/core/embedded/WebAppConfig;Lorg/maxur/mserv/core/kotlin/Locator;)V", "baseUri", "Ljava/net/URI;", "getBaseUri", "()Ljava/net/URI;", "httpServer", "Lorg/glassfish/grizzly/http/server/HttpServer;", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "createHttpServer", "listener", "Lorg/glassfish/grizzly/http/server/NetworkListener;", "entries", "Lorg/maxur/mserv/core/embedded/WebEntries;", "launch", "", "makeDynamicHandler", "Lorg/maxur/mserv/core/embedded/grizzly/GrizzlyHttpContainer;", "makeStaticHandler", "Lorg/maxur/mserv/core/embedded/grizzly/StaticHttpHandler;", "content", "Lorg/maxur/mserv/core/embedded/properties/StaticContent;", "networkListener", "uri", "secure", "", "sslEngineConfigurator", "Lorg/glassfish/grizzly/ssl/SSLEngineConfigurator;", "relaunch", "shutdown", "title", "Lorg/glassfish/grizzly/http/server/ServerConfiguration;", "maxur-mserv-core"})
public class WebServerGrizzlyImpl
extends BaseService
implements WebServer {
    private final HttpServer httpServer;
    @NotNull
    private String name;
    private final WebAppConfig config;

    private final String title(@NotNull ServerConfiguration $receiver) {
        return "" + $receiver.getName() + " '" + $receiver.getHttpServerName() + '-' + $receiver.getHttpServerVersion() + '\'';
    }

    @Override
    @NotNull
    public URI getBaseUri() {
        return this.config.getUrl();
    }

    @Override
    @NotNull
    public String getName() {
        return this.title(this.httpServer.getServerConfiguration());
    }

    @Override
    public void setName(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.name = string2;
    }

    @Override
    protected void launch() {
        this.httpServer.start();
    }

    @Override
    protected void shutdown() {
        this.httpServer.shutdownNow();
    }

    @Override
    protected void relaunch() {
        this.httpServer.shutdownNow();
        this.httpServer.start();
    }

    private final HttpServer httpServer() {
        NetworkListener listener = this.networkListener(this.config.getUrl(), false, null);
        HttpServer server = this.createHttpServer(listener);
        server.getServerConfiguration().addHttpHandler((HttpHandler)this.makeDynamicHandler(), new String[]{'/' + this.config.getRestPath().getContextPath()});
        Iterable $receiver$iv = this.config.getStaticContent();
        for (Object element$iv : $receiver$iv) {
            StaticContent it = (StaticContent)element$iv;
            server.getServerConfiguration().addHttpHandler((HttpHandler)this.makeStaticHandler(it), new String[]{'/' + it.getPath().getContextPath()});
        }
        return server;
    }

    private final GrizzlyHttpContainer makeDynamicHandler() {
        return new GrizzlyHttpContainer((Application)this.config.getResourceConfig(), (ServiceLocator)this.getLocator().implementation());
    }

    private final StaticHttpHandler makeStaticHandler(StaticContent content) {
        return new StaticHttpHandler(content, null, 2, null);
    }

    @Override
    @NotNull
    public WebEntries entries() {
        Map $receiver$iv;
        ServerConfiguration cfg = this.httpServer.getServerConfiguration();
        WebEntries entries = new WebEntries(this.config.getUrl());
        Map map = $receiver$iv = cfg.getHttpHandlersWithMapping();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $$_$_regs = element$iv = iterator.next();
            Object object = $$_$_regs;
            HttpHandlerRegistration[] regs = (HttpHandlerRegistration[])object.getValue();
            object = this;
            WebServerGrizzlyImpl $receiver = (WebServerGrizzlyImpl)object;
            HttpHandlerRegistration[] httpHandlerRegistrationArray = regs;
            for (int i = 0; i < httpHandlerRegistrationArray.length; ++i) {
                HttpHandlerRegistration reg = httpHandlerRegistrationArray[i];
                String string2 = reg.getContextPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"reg.contextPath");
                String string3 = reg.getUrlPattern();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"reg.urlPattern");
                WebAppConfig webAppConfig = $receiver.config;
                String string4 = reg.getContextPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"reg.contextPath");
                Object object2 = webAppConfig.staticContentByPath(string4);
                if (object2 == null || (object2 = ((StaticContent)object2).getStartUrl()) == null) {
                    object2 = "";
                }
                entries.add(string2, string3, (String)object2);
            }
        }
        return entries;
    }

    private final HttpServer createHttpServer(NetworkListener listener) {
        HttpServer server = new HttpServer();
        server.addListener(listener);
        server.getServerConfiguration().setPassTraceRequest(true);
        server.getServerConfiguration().setDefaultQueryEncoding(Charsets.UTF8_CHARSET);
        return server;
    }

    private final NetworkListener networkListener(URI uri, boolean secure, SSLEngineConfigurator sslEngineConfigurator) {
        String host;
        String string2 = host = uri.getHost() == null ? "0.0.0.0" : uri.getHost();
        int port = uri.getPort() == -1 ? (secure ? 443 : 80) : uri.getPort();
        NetworkListener listener = new NetworkListener("grizzly", host, port);
        listener.getTransport().getWorkerThreadPoolConfig().setThreadFactory(new ThreadFactoryBuilder().setNameFormat("grizzly-http-server-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new JerseyProcessingUncaughtExceptionHandler()).build());
        listener.setSecure(secure);
        if (sslEngineConfigurator != null) {
            listener.setSSLEngineConfig(sslEngineConfigurator);
        }
        return listener;
    }

    public WebServerGrizzlyImpl(@NotNull WebAppConfig config, @NotNull Locator locator2) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)locator2, (String)"locator");
        super(locator2);
        this.config = config;
        this.httpServer = this.httpServer();
        this.name = "Unknown web service";
    }
}

