/*
 * Decompiled with CFR 0.152.
 */
package org.maxur.mserv.core.embedded.properties;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxur.mserv.core.domain.Path;
import org.maxur.mserv.core.domain.Resource;
import org.maxur.mserv.core.embedded.properties.RestService;
import org.maxur.mserv.core.embedded.properties.StaticContent;
import org.maxur.mserv.core.rest.RestResourceConfig;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0001(BA\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0001\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\b\b\u0003\u0010\t\u001a\u00020\n\u0012\b\b\u0003\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001b\u001a\u00020\bH\u0002J&\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0#j\b\u0012\u0004\u0012\u00020\b`$2\u0006\u0010%\u001a\u00020&J\b\u0010'\u001a\u00020\bH\u0002R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019\u00a8\u0006)"}, d2={"Lorg/maxur/mserv/core/embedded/properties/WebAppProperties;", "", "url", "Ljava/net/URI;", "rest", "Lorg/maxur/mserv/core/embedded/properties/RestService;", "staticContent", "", "Lorg/maxur/mserv/core/embedded/properties/StaticContent;", "withHalBrowser", "", "withSwaggerUi", "(Ljava/net/URI;Lorg/maxur/mserv/core/embedded/properties/RestService;[Lorg/maxur/mserv/core/embedded/properties/StaticContent;ZZ)V", "getRest", "()Lorg/maxur/mserv/core/embedded/properties/RestService;", "restPath", "Lorg/maxur/mserv/core/domain/Path;", "getRestPath", "()Lorg/maxur/mserv/core/domain/Path;", "getStaticContent", "()[Lorg/maxur/mserv/core/embedded/properties/StaticContent;", "[Lorg/maxur/mserv/core/embedded/properties/StaticContent;", "getUrl", "()Ljava/net/URI;", "getWithHalBrowser", "()Z", "getWithSwaggerUi", "halContent", "initSwagger", "", "packages", "", "", "path", "uri", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "restConfig", "Lorg/maxur/mserv/core/rest/RestResourceConfig;", "swaggerContent", "Companion", "maxur-mserv-core"})
public final class WebAppProperties {
    @NotNull
    private final Path restPath;
    @NotNull
    private final URI url;
    @Nullable
    private final RestService rest;
    @Nullable
    private final StaticContent[] staticContent;
    private final boolean withHalBrowser;
    private final boolean withSwaggerUi;
    @NotNull
    private static final URI SWAGGER_URL;
    @NotNull
    private static final URI HAL_URL;
    public static final Companion Companion;

    @NotNull
    public final Path getRestPath() {
        return this.restPath;
    }

    @NotNull
    public final ArrayList<StaticContent> staticContent(@NotNull RestResourceConfig restConfig2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)restConfig2), (String)"restConfig");
        ArrayList<StaticContent> result2 = new ArrayList<StaticContent>();
        if (this.staticContent != null) {
            CollectionsKt.addAll((Collection)result2, (Object[])this.staticContent);
        }
        if (this.withHalBrowser) {
            result2.add(this.halContent());
        }
        if (this.withSwaggerUi) {
            result2.add(this.swaggerContent());
            List<String> list = restConfig2.getPackages();
            RestService restService = this.rest;
            if (restService == null) {
                Intrinsics.throwNpe();
            }
            this.initSwagger(list, restService.getPath(), this.url);
            String[] stringArray = new String[1];
            String string2 = ApiListingResource.class.getPackage().getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ApiListingResource::class.java.`package`.name");
            stringArray[0] = string2;
            restConfig2.resources(stringArray);
        }
        return result2;
    }

    private final StaticContent swaggerContent() {
        return new StaticContent(new Path("docs"), new URI[]{Companion.getSWAGGER_URL()}, "index.html", "index.html?url=/api/swagger.json");
    }

    private final StaticContent halContent() {
        return new StaticContent(new Path("hal"), new URI[]{Companion.getHAL_URL()}, "browser.html", "#/api/service");
    }

    private final void initSwagger(List<String> packages, Path path, URI uri) {
        BeanConfig config = new BeanConfig();
        config.setBasePath("/" + path.getAsString());
        config.setHost("" + uri.getHost() + ':' + uri.getPort());
        config.setResourcePackage(CollectionsKt.joinToString$default((Iterable)packages, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        config.setScan(true);
    }

    @NotNull
    public final URI getUrl() {
        return this.url;
    }

    @Nullable
    public final RestService getRest() {
        return this.rest;
    }

    @Nullable
    public final StaticContent[] getStaticContent() {
        return this.staticContent;
    }

    public final boolean getWithHalBrowser() {
        return this.withHalBrowser;
    }

    public final boolean getWithSwaggerUi() {
        return this.withSwaggerUi;
    }

    public WebAppProperties(@JsonProperty(value="url") @NotNull URI url2, @JsonProperty(value="rest", required=false) @Nullable RestService rest, @JsonProperty(value="static-content", required=false) @Nullable StaticContent[] staticContent, @JsonProperty(value="with-hal-browser", required=false) boolean withHalBrowser, @JsonProperty(value="with-swagger-ui", required=false) boolean withSwaggerUi) {
        Intrinsics.checkParameterIsNotNull((Object)url2, (String)"url");
        this.url = url2;
        this.rest = rest;
        this.staticContent = staticContent;
        this.withHalBrowser = withHalBrowser;
        this.withSwaggerUi = withSwaggerUi;
        Object object = this.rest;
        if (object == null || (object = ((RestService)object).getPath()) == null) {
            object = new Path("api");
        }
        this.restPath = object;
    }

    public /* synthetic */ WebAppProperties(URI uRI, RestService restService, StaticContent[] staticContentArray, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(uRI, restService, staticContentArray, bl, bl2);
    }

    static {
        Companion = new Companion(null);
        URI uRI = new Resource("/META-INF/resources/webjars/swagger-ui/").getSubfolder();
        if (uRI == null) {
            throw (Throwable)new IllegalStateException("Swagger UI is not found in class path");
        }
        SWAGGER_URL = uRI;
        URI uRI2 = new Resource("/META-INF/resources/webjars/hal-browser/").getSubfolder();
        if (uRI2 == null) {
            throw (Throwable)new IllegalStateException("HAL Browser is not found in class path");
        }
        HAL_URL = uRI2;
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/maxur/mserv/core/embedded/properties/WebAppProperties$Companion;", "", "()V", "HAL_URL", "Ljava/net/URI;", "getHAL_URL", "()Ljava/net/URI;", "SWAGGER_URL", "getSWAGGER_URL", "maxur-mserv-core"})
    public static final class Companion {
        @NotNull
        public final URI getSWAGGER_URL() {
            return SWAGGER_URL;
        }

        @NotNull
        public final URI getHAL_URL() {
            return HAL_URL;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

