/*
 * Decompiled with CFR 0.152.
 */
package org.maxur.mserv.core.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.maxur.mserv.core.MicroService;
import org.maxur.mserv.core.rest.ServiceView;

@Path(value="/service")
@Api(value="/service", description="Endpoint for Service specific operations")
@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0002\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/maxur/mserv/core/rest/ServiceResource;", "", "service", "Lorg/maxur/mserv/core/MicroService;", "(Lorg/maxur/mserv/core/MicroService;)V", "getService", "()Lorg/maxur/mserv/core/MicroService;", "Lorg/maxur/mserv/core/rest/ServiceView;", "state", "", "command", "", "maxur-mserv-core"})
public final class ServiceResource {
    @NotNull
    private final MicroService service;

    @GET
    @Produces(value={"application/hal+json"})
    @ApiOperation(value="Represent this service", response=ServiceView.class, produces="application/hal+json")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful operation"), @ApiResponse(code=500, message="Internal server error")})
    @NotNull
    public final ServiceView service() {
        return new ServiceView(this.service);
    }

    @PUT
    @Path(value="/{state}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Change service state", notes="Commands for stop or restart service")
    @ApiResponses(value={@ApiResponse(code=204, message="Successful operation"), @ApiResponse(code=400, message="On invalid command"), @ApiResponse(code=500, message="Internal server error")})
    public final void state(@ApiParam(name="state", value="New service state", required=true, allowableValues="stop, restart") @PathParam(value="state") @NotNull String command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        String string2 = command;
        String string3 = string2.toUpperCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
        switch (string3) {
            case "STOP": {
                this.service.deferredStop();
                break;
            }
            case "RESTART": {
                this.service.deferredRestart();
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Command '" + command + "' unknown");
            }
        }
    }

    @NotNull
    public final MicroService getService() {
        return this.service;
    }

    @Inject
    public ServiceResource(@NotNull MicroService service2) {
        Intrinsics.checkParameterIsNotNull((Object)service2, (String)"service");
        this.service = service2;
    }
}

