/*
 * Decompiled with CFR 0.152.
 */
package org.maxur.mserv.core.service.properties;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jasonclawson.jackson.dataformat.hocon.HoconFactory;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Paths;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxur.mserv.core.service.jackson.ObjectMapperProvider;
import org.maxur.mserv.core.service.properties.Properties;
import org.maxur.mserv.core.service.properties.PropertiesSource;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0019J\u001e\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0015\u001a\u00020\u00062\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J3\u0010 \u001a\u0004\u0018\u0001H!\"\u0004\b\u0000\u0010!2\u0006\u0010\u0015\u001a\u00020\u00062\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u0001H!0#H\u0002\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'H\u0002J+\u0010(\u001a\u0004\u0018\u0001H)\"\u0004\b\u0000\u0010)2\u0006\u0010\u0015\u001a\u00020\u00062\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H)0\u001dH\u0017\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020\u000eH\u0002R\u0014\u0010\b\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006,"}, d2={"Lorg/maxur/mserv/core/service/properties/PropertiesSourceHoconImpl;", "Lorg/maxur/mserv/core/service/properties/Properties;", "Lorg/maxur/mserv/core/service/properties/PropertiesSource;", "sourceUri", "Ljava/net/URI;", "rootKey", "", "(Ljava/net/URI;Ljava/lang/String;)V", "format", "getFormat", "()Ljava/lang/String;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "root", "Lcom/typesafe/config/Config;", "getRootKey", "uri", "getUri", "()Ljava/net/URI;", "asInteger", "", "key", "(Ljava/lang/String;)Ljava/lang/Integer;", "asLong", "", "(Ljava/lang/String;)Ljava/lang/Long;", "asObject", "", "clazz", "Ljava/lang/Class;", "asString", "asURI", "getValue", "T", "transform", "Lkotlin/Function1;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "loadFrom", "file", "Ljava/io/File;", "read", "P", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "rootNode", "maxur-mserv-core"})
public final class PropertiesSourceHoconImpl
extends PropertiesSource
implements Properties {
    @NotNull
    private final String format = "Hocon";
    @NotNull
    private final String rootKey;
    private Config root;
    private final ObjectMapper mapper;
    private final URI sourceUri;

    @Override
    @NotNull
    public String getFormat() {
        return this.format;
    }

    @Override
    @NotNull
    public String getRootKey() {
        return this.rootKey;
    }

    /*
     * Unable to fully structure code
     */
    private final Config rootNode() {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (this.sourceUri != null) break block4;
                        v0 = ConfigFactory.load();
                        v1 = v0;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"ConfigFactory.load()");
                        break block5;
                    }
                    v2 = var1_1 = this.sourceUri.getScheme();
                    if (v2 == null) ** GOTO lbl16
                    switch (v2.hashCode()) {
                        case 3143036: {
                            if (!var1_1.equals("file")) ** break;
                            break;
                        }
                        case -8875619: {
                            if (!var1_1.equals("classpath")) ** break;
                            break block6;
                        }
lbl16:
                        // 1 sources

                        v3 = this.loadFrom(new File(this.sourceUri.toString()));
                        break block7;
                    }
                    v4 = Paths.get(this.sourceUri).toFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"Paths.get(sourceUri).toFile()");
                    v3 = this.loadFrom(v4);
                    break block7;
                }
                v3 = ConfigFactory.load((String)this.withoutScheme(this.sourceUri));
                break block7;
                throw (Throwable)new IllegalArgumentException("Unsupported schema '" + this.sourceUri.getScheme() + "' to properties source. " + "Must be one of [file, classpath]");
            }
            v1 = v3;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"when (sourceUri.scheme) \u2026      )\n                }");
        }
        return v1;
    }

    @Override
    @NotNull
    public URI getUri() {
        Object object;
        Object object2 = this.root.origin();
        if (object2 == null || (object2 = object2.url()) == null || (object2 = ((URL)object2).toURI()) == null) {
            object2 = object = this.sourceUri;
        }
        if (object2 == null) {
            object = new URI("");
        }
        return object;
    }

    @Override
    @Nullable
    public <P> P read(@NotNull String key, @NotNull Class<P> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        Class<P> clazz2 = clazz;
        return (P)(Intrinsics.areEqual(clazz2, String.class) ? (Object)this.asString(key) : (Intrinsics.areEqual(clazz2, Integer.TYPE) || Intrinsics.areEqual(clazz2, Integer.class) ? (Object)this.asInteger(key) : (Intrinsics.areEqual(clazz2, Long.TYPE) ? (Object)this.asLong(key) : (Intrinsics.areEqual(clazz2, URI.class) ? (Object)this.asURI(key) : (Intrinsics.areEqual(clazz2, Double.TYPE) ? (Object)this.root.getDouble(key) : (Intrinsics.areEqual(clazz2, Duration.class) ? (Object)this.root.getDuration(key) : this.asObject(key, clazz)))))));
    }

    private final Config loadFrom(File file) {
        if (!file.exists()) {
            throw (Throwable)new IllegalArgumentException("Properties file '" + file.getAbsolutePath() + "' is not found");
        }
        Config config = ConfigFactory.parseFile((File)file);
        Intrinsics.checkExpressionValueIsNotNull((Object)config, (String)"ConfigFactory.parseFile(file)");
        return config;
    }

    @Override
    @Nullable
    public URI asURI(@NotNull String key) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        String string3 = string2 = this.asString(key);
        return string3 == null ? null : URI.create(string2);
    }

    private final Object asObject(String key, Class<?> clazz) {
        try {
            Object object;
            ConfigObject configObject = (ConfigObject)this.getValue(key, (Function1)new Function1<Config, ConfigObject>(key){
                final /* synthetic */ String $key;

                public final ConfigObject invoke(@NotNull Config it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return it.getObject(this.$key);
                }
                {
                    this.$key = string2;
                    super(1);
                }
            });
            if (configObject != null) {
                ConfigObject configObject2;
                ConfigObject it = configObject2 = configObject;
                object = this.mapper.readValue(it.render(), clazz);
            } else {
                object = null;
            }
            return object;
        }
        catch (Exception e) {
            Exception exception = e;
            if (exception instanceof IOException || exception instanceof ConfigException.WrongType) {
                throw (Throwable)new IllegalStateException("Configuration parameter '" + key + "' is not parsed.", e);
            }
            throw (Throwable)e;
        }
    }

    @Override
    @Nullable
    public String asString(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return (String)this.getValue(key, (Function1)new Function1<Config, String>(key){
            final /* synthetic */ String $key;

            public final String invoke(@NotNull Config it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.getString(this.$key);
            }
            {
                this.$key = string2;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public Long asLong(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return (Long)this.getValue(key, (Function1)new Function1<Config, Long>(key){
            final /* synthetic */ String $key;

            public final long invoke(@NotNull Config it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.getLong(this.$key);
            }
            {
                this.$key = string2;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    public Integer asInteger(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return (Integer)this.getValue(key, (Function1)new Function1<Config, Integer>(key){
            final /* synthetic */ String $key;

            public final int invoke(@NotNull Config it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.getInt(this.$key);
            }
            {
                this.$key = string2;
                super(1);
            }
        });
    }

    private final <T> T getValue(String key, Function1<? super Config, ? extends T> transform) {
        Object object;
        try {
            Config it = object = this.root;
            object = transform.invoke((Object)it);
        }
        catch (ConfigException.Missing e) {
            throw (Throwable)new IllegalStateException("Configuration parameter '" + key + "' is not found.", e);
        }
        return (T)object;
    }

    public PropertiesSourceHoconImpl(@Nullable URI sourceUri, @Nullable String rootKey) {
        Config config;
        this.sourceUri = sourceUri;
        this.format = "Hocon";
        String string2 = rootKey;
        if (string2 == null) {
            string2 = "DEFAULTS";
        }
        this.rootKey = string2;
        PropertiesSourceHoconImpl propertiesSourceHoconImpl = this;
        try {
            PropertiesSourceHoconImpl propertiesSourceHoconImpl2 = propertiesSourceHoconImpl;
            Config config2 = this.rootNode().getConfig(this.getRootKey());
            Intrinsics.checkExpressionValueIsNotNull((Object)config2, (String)"rootNode().getConfig(this.rootKey)");
            config = config2;
        }
        catch (ConfigException.Missing missing) {
            PropertiesSourceHoconImpl propertiesSourceHoconImpl3 = propertiesSourceHoconImpl;
            StringBuilder stringBuilder = new StringBuilder().append("The properties source '");
            Object object = this.sourceUri;
            if (object == null) {
                object = "<default>";
            }
            throw (Throwable)new IllegalStateException(stringBuilder.append(object).append("' not found. ").append("You need create one with '").append(this.getRootKey()).append("' section").toString());
        }
        propertiesSourceHoconImpl2.root = config;
        this.mapper = ObjectMapperProvider.INSTANCE.config(new ObjectMapper((JsonFactory)new HoconFactory()));
    }

    public /* synthetic */ PropertiesSourceHoconImpl(URI uRI, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            uRI = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(uRI, string2);
    }

    public PropertiesSourceHoconImpl() {
        this(null, null, 3, null);
    }

    @Override
    @Nullable
    public <P> P read(@NotNull String key, @NotNull KClass<P> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return Properties.DefaultImpls.read(this, key, clazz);
    }

    @Override
    @NotNull
    public String withoutScheme(@NotNull URI $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Properties.DefaultImpls.withoutScheme(this, $receiver);
    }
}

