/*
 * Decompiled with CFR 0.152.
 */
package org.maxur.mserv.core.rest;

import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.maxur.mserv.core.rest.Incident;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\f\u0012\b\u0012\u00060\u0002j\u0002`\u00030\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\n\u0010\t\u001a\u00060\u0002j\u0002`\u0003H\u0002J \u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\n\u0010\t\u001a\u00060\u0002j\u0002`\u0003H\u0002J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\t\u001a\u00060\rj\u0002`\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0010H\u0002J\u0014\u0010\u0011\u001a\u00020\f2\n\u0010\t\u001a\u00060\u0002j\u0002`\u0003H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/maxur/mserv/core/rest/RuntimeExceptionHandler;", "Ljavax/ws/rs/ext/ExceptionMapper;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "()V", "makeSystemErrorEntity", "Ljavax/ws/rs/core/GenericEntity;", "", "Lorg/maxur/mserv/core/rest/Incident;", "exception", "makeUserErrorEntity", "onIllegalArgument", "Ljavax/ws/rs/core/Response;", "Ljava/lang/IllegalArgumentException;", "Lkotlin/IllegalArgumentException;", "onWebApplicationException", "Ljavax/ws/rs/WebApplicationException;", "toResponse", "Companion", "maxur-mserv-core"})
public final class RuntimeExceptionHandler
implements ExceptionMapper<RuntimeException> {
    @NotNull
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    public Response toResponse(@NotNull RuntimeException exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        RuntimeException runtimeException = exception;
        if (runtimeException instanceof IllegalArgumentException) {
            return this.onIllegalArgument((IllegalArgumentException)exception);
        }
        if (runtimeException instanceof WebApplicationException) {
            return this.onWebApplicationException((WebApplicationException)exception);
        }
        Companion.getLog().error(exception.getMessage(), (Throwable)exception);
        Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("application/json").entity(this.makeSystemErrorEntity(exception)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"status(Status.INTERNAL_S\u2026                 .build()");
        return response;
    }

    private final Response onWebApplicationException(WebApplicationException exception) {
        Companion.getLog().debug(exception.getMessage(), (Throwable)exception);
        Response response = exception.getResponse();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"exception.response");
        return response;
    }

    private final Response onIllegalArgument(IllegalArgumentException exception) {
        Companion.getLog().warn(exception.getMessage());
        Companion.getLog().debug(exception.getMessage(), (Throwable)exception);
        Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/json").entity(this.makeUserErrorEntity(exception)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"status(Status.BAD_REQUES\u2026\n                .build()");
        return response;
    }

    private final GenericEntity<List<Incident>> makeSystemErrorEntity(RuntimeException exception) {
        String[] stringArray = new String[2];
        stringArray[0] = "System error";
        String string2 = exception.getMessage();
        if (string2 == null) {
            string2 = "Unknown";
        }
        stringArray[1] = string2;
        return (GenericEntity)new GenericEntity<List<? extends Incident>>(exception, Incident.Companion.incidents(stringArray)){
            final /* synthetic */ RuntimeException $exception;
            {
                this.$exception = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
    }

    private final GenericEntity<List<Incident>> makeUserErrorEntity(RuntimeException exception) {
        String[] stringArray = new String[2];
        stringArray[0] = "Bad parameters";
        String string2 = exception.getMessage();
        if (string2 == null) {
            string2 = "Unknown";
        }
        stringArray[1] = string2;
        return (GenericEntity)new GenericEntity<List<? extends Incident>>(exception, Incident.Companion.incidents(stringArray)){
            final /* synthetic */ RuntimeException $exception;
            {
                this.$exception = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(RuntimeExceptionHandler.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(\u2026ptionHandler::class.java)");
        log = logger;
    }

    @Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/maxur/mserv/core/rest/RuntimeExceptionHandler$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "maxur-mserv-core"})
    public static final class Companion {
        @NotNull
        public final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

