/*
 * Decompiled with CFR 0.152.
 */
package org.maxur.mserv.core.service.properties;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maxur.mserv.core.service.jackson.ObjectMapperProvider;
import org.maxur.mserv.core.service.properties.Properties;
import org.maxur.mserv.core.service.properties.PropertiesSource;

@Metadata(mv={1, 1, 8}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0018\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0006H\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J+\u0010\"\u001a\u0004\u0018\u0001H#\"\u0004\b\u0000\u0010#2\u0006\u0010\u0018\u001a\u00020\u00062\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%H\u0016\u00a2\u0006\u0002\u0010&J\u0012\u0010'\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0014\u0010\u000b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u001c\u0010\u0007\u001a\n \u0013*\u0004\u0018\u00010\b0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006("}, d2={"Lorg/maxur/mserv/core/service/properties/PropertiesSourceJacksonImpl;", "Lorg/maxur/mserv/core/service/properties/Properties;", "Lorg/maxur/mserv/core/service/properties/PropertiesSource;", "factory", "Lcom/fasterxml/jackson/core/JsonFactory;", "defaultExt", "", "uri", "Ljava/net/URI;", "rootKey", "(Lcom/fasterxml/jackson/core/JsonFactory;Ljava/lang/String;Ljava/net/URI;Ljava/lang/String;)V", "format", "getFormat", "()Ljava/lang/String;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "root", "Lcom/fasterxml/jackson/databind/JsonNode;", "getRootKey", "kotlin.jvm.PlatformType", "getUri", "()Ljava/net/URI;", "asInteger", "", "key", "(Ljava/lang/String;)Ljava/lang/Integer;", "asLong", "", "(Ljava/lang/String;)Ljava/lang/Long;", "asString", "asURI", "inputStreamByResource", "Ljava/io/InputStream;", "node", "read", "P", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "rootNode", "maxur-mserv-core"})
public final class PropertiesSourceJacksonImpl
extends PropertiesSource
implements Properties {
    @NotNull
    private final String rootKey;
    @NotNull
    private final String format;
    private final URI uri;
    private final ObjectMapper mapper;
    private JsonNode root;

    @Override
    @NotNull
    public String getRootKey() {
        return this.rootKey;
    }

    @Override
    @NotNull
    public String getFormat() {
        return this.format;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    /*
     * Unable to fully structure code
     */
    private final JsonNode rootNode(URI uri) {
        block7: {
            block6: {
                v0 = var2_2 = uri.getScheme();
                if (v0 == null) ** GOTO lbl10
                switch (v0.hashCode()) {
                    case 3143036: {
                        if (!var2_2.equals("file")) ** break;
                        break;
                    }
                    case -8875619: {
                        if (!var2_2.equals("classpath")) ** break;
                        break block6;
                    }
lbl10:
                    // 1 sources

                    v1 = this.mapper.readTree(new File(uri.toString()));
                    break block7;
                }
                v1 = this.mapper.readTree(Paths.get(uri).toFile());
                break block7;
            }
            v2 = this.inputStreamByResource(uri);
            if (v2 != null) {
                it = var3_3 = v2;
                v1 = this.mapper.readTree(it);
            } else {
                v1 = null;
            }
            break block7;
            throw (Throwable)new IllegalArgumentException("Unsupported schema '" + uri.getScheme() + "' to properties source. Must be one of [file, classpath]");
        }
        return v1;
    }

    private final InputStream inputStreamByResource(URI uri) {
        return this.getClass().getResourceAsStream("/" + this.withoutScheme(uri));
    }

    @Override
    @Nullable
    public String asString(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.node(key).asText();
    }

    @Override
    @Nullable
    public Long asLong(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.node(key).asLong();
    }

    @Override
    @Nullable
    public Integer asInteger(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.node(key).asInt();
    }

    @Override
    @Nullable
    public URI asURI(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return (URI)this.mapper.treeToValue((TreeNode)this.node(key), URI.class);
    }

    @Override
    @Nullable
    public <P> P read(@NotNull String key, @NotNull Class<P> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        try {
            return (P)this.mapper.treeToValue((TreeNode)this.node(key), clazz);
        }
        catch (JsonMappingException e) {
            throw (Throwable)new IllegalStateException("Configuration parameter '" + key + "' is not parsed.", e);
        }
    }

    private final JsonNode node(String key) {
        JsonNode jsonNode = this.root.get(key);
        if (jsonNode == null) {
            throw (Throwable)new IllegalStateException("Configuration parameter '" + key + "' is not found.");
        }
        return jsonNode;
    }

    public PropertiesSourceJacksonImpl(@NotNull JsonFactory factory, @NotNull String defaultExt, @Nullable URI uri, @Nullable String rootKey) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        Intrinsics.checkParameterIsNotNull((Object)defaultExt, (String)"defaultExt");
        String string2 = rootKey;
        if (string2 == null) {
            string2 = "/";
        }
        this.rootKey = string2;
        this.format = StringsKt.capitalize((String)defaultExt);
        URI uRI = uri;
        if (uRI == null) {
            uRI = URI.create("classpath:///application." + defaultExt);
        }
        this.uri = uRI;
        this.mapper = ObjectMapperProvider.INSTANCE.config(new ObjectMapper(factory));
        if (rootKey == null) {
            URI uRI2 = this.getUri();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI2, (String)"this.uri");
            object = this.rootNode(uRI2);
        } else {
            URI uRI3 = this.getUri();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRI3, (String)"this.uri");
            JsonNode jsonNode = this.rootNode(uRI3);
            object = jsonNode != null ? jsonNode.get(this.getRootKey()) : null;
        }
        if (object == null) {
            throw (Throwable)new IllegalStateException("The properties source '" + this.getUri() + "' not found. You need create one with '" + this.getRootKey() + "' section");
        }
        this.root = object;
    }

    public /* synthetic */ PropertiesSourceJacksonImpl(JsonFactory jsonFactory, String string2, URI uRI, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            uRI = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        this(jsonFactory, string2, uRI, string3);
    }

    @Override
    @Nullable
    public <P> P read(@NotNull String key, @NotNull KClass<P> clazz) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return Properties.DefaultImpls.read(this, key, clazz);
    }

    @Override
    @NotNull
    public String withoutScheme(@NotNull URI $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Properties.DefaultImpls.withoutScheme(this, $receiver);
    }
}

