/*
 * Decompiled with CFR 0.152.
 */
package org.mayanjun.mybatisx.starter;

import com.zaxxer.hikari.HikariDataSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mayanjun.core.Assert;
import org.mayanjun.mybatisx.dal.IdGenerator;
import org.mayanjun.mybatisx.dal.converter.PropertiesFactoryBean;
import org.mayanjun.mybatisx.dal.dao.BasicDAO;
import org.mayanjun.mybatisx.dal.dao.DatabaseRouter;
import org.mayanjun.mybatisx.dal.dao.DatabaseSession;
import org.mayanjun.mybatisx.dal.dao.ThreadLocalDatabaseRouter;
import org.mayanjun.mybatisx.dal.generator.SnowflakeIDGenerator;
import org.mayanjun.mybatisx.starter.DataSourceConfig;
import org.mayanjun.mybatisx.starter.MybatisxConfig;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class BasicDaoFactoryBean
implements FactoryBean<BasicDAO>,
ApplicationRunner,
ResourceLoaderAware {
    private static final Logger LOG = LoggerFactory.getLogger(BasicDaoFactoryBean.class);
    private MybatisxConfig config;
    private List<SqlSessionTemplate> sqlSessionTemplates = new ArrayList<SqlSessionTemplate>();
    private ResourceLoader resourceLoader;
    private Map<Class<? extends IdGenerator>, IdGenerator> reusableIdGenerators = new HashMap<Class<? extends IdGenerator>, IdGenerator>();
    private volatile IdGenerator defaultIdGenerator;

    public BasicDaoFactoryBean(@Autowired(required=false) MybatisxConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IdGenerator newIdGenerator(DataSourceConfig dataSourceConfig) {
        BasicDaoFactoryBean basicDaoFactoryBean;
        IdGenerator generator = null;
        String type = dataSourceConfig.getIdGeneratorType();
        if (StringUtils.isNotBlank((CharSequence)type)) {
            try {
                basicDaoFactoryBean = this;
                synchronized (basicDaoFactoryBean) {
                    Class<?> cls = Class.forName(type);
                    generator = this.reusableIdGenerators.get(cls);
                    if (generator == null) {
                        generator = (IdGenerator)cls.newInstance();
                        this.reusableIdGenerators.put(cls, generator);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Can't Instantiate ID generator for class: " + type, (Throwable)e);
            }
        }
        if (generator == null) {
            if (this.defaultIdGenerator == null) {
                basicDaoFactoryBean = this;
                synchronized (basicDaoFactoryBean) {
                    this.defaultIdGenerator = new SnowflakeIDGenerator();
                }
            }
            generator = this.defaultIdGenerator;
        }
        return generator;
    }

    public DatabaseRouter newDataBaseRouter(MybatisxConfig config) throws Exception {
        List<DataSourceConfig> dataSourceConfigList = config.getDataSources();
        if (dataSourceConfigList == null || dataSourceConfigList.isEmpty()) {
            dataSourceConfigList = new ArrayList<DataSourceConfig>();
            dataSourceConfigList.add(new DataSourceConfig());
            config.setDataSources(dataSourceConfigList);
        }
        Assert.notEmpty(config.getDataSources(), (String)"Datasource config(s) can not be empty");
        ThreadLocalDatabaseRouter databaseRouter = new ThreadLocalDatabaseRouter();
        for (DataSourceConfig dataSourceConfig : config.getDataSources()) {
            DataSource dataSource = this.createDataSource(dataSourceConfig);
            SqlSessionFactoryBean sqlSessionFactoryBean = this.createSqlSessionFactoryBean(dataSource, dataSourceConfig);
            SqlSessionFactory sqlSessionFactory = sqlSessionFactoryBean.getObject();
            SqlSessionTemplate template = new SqlSessionTemplate(sqlSessionFactory);
            this.sqlSessionTemplates.add(template);
            DataSourceTransactionManager manager = new DataSourceTransactionManager();
            manager.setDataSource(dataSource);
            manager.afterPropertiesSet();
            TransactionTemplate transactionTemplate = new TransactionTemplate();
            transactionTemplate.setIsolationLevelName(dataSourceConfig.getIsolationLevelName());
            transactionTemplate.setPropagationBehaviorName(dataSourceConfig.getPropagationBehaviorName());
            transactionTemplate.setTransactionManager((PlatformTransactionManager)manager);
            transactionTemplate.afterPropertiesSet();
            String databaseSessionName = dataSourceConfig.getName();
            Assert.notBlank((CharSequence)databaseSessionName, (String)"The database session name can not be empty");
            DatabaseSession session = new DatabaseSession(dataSourceConfig.getName(), dataSource, (SqlSession)template, this.newIdGenerator(dataSourceConfig), transactionTemplate);
            databaseRouter.addDatabaseSession(session);
        }
        databaseRouter.afterPropertiesSet();
        return databaseRouter;
    }

    private SqlSessionFactoryBean createSqlSessionFactoryBean(DataSource dataSource, DataSourceConfig config) throws Exception {
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource(dataSource);
        if (StringUtils.isNotBlank((CharSequence)config.getMybatisConfigLocation())) {
            Resource resource = this.resourceLoader.getResource(config.getMybatisConfigLocation());
            if (resource.exists()) {
                sqlSessionFactoryBean.setConfigLocation(resource);
            } else {
                LOG.warn("Mybatis config file not found: {}", (Object)config.getMybatisConfigLocation());
            }
        }
        sqlSessionFactoryBean.afterPropertiesSet();
        return sqlSessionFactoryBean;
    }

    private DataSource createDataSource(DataSourceConfig config) {
        HikariDataSource dataSource = new HikariDataSource();
        dataSource.setUsername(config.getUsername());
        dataSource.setPassword(config.getPassword());
        dataSource.setJdbcUrl(config.getJdbcUrl());
        dataSource.setDriverClassName(config.getDriverClassName());
        dataSource.setAutoCommit(config.isAutoCommit());
        dataSource.setMinimumIdle(config.getMinimumIdle());
        dataSource.setMaximumPoolSize(config.getMaximumPoolSize());
        dataSource.setConnectionInitSql(config.getValidationQuery());
        PropertiesFactoryBean propertiesFactoryBean = new PropertiesFactoryBean();
        propertiesFactoryBean.setConnectionProperties(config.getConnectionProperties());
        dataSource.setDataSourceProperties(propertiesFactoryBean.getObject());
        return dataSource;
    }

    public void init() throws Exception {
        if (this.sqlSessionTemplates != null && !this.sqlSessionTemplates.isEmpty()) {
            for (SqlSessionTemplate template : this.sqlSessionTemplates) {
                template.getConfiguration().getMappedStatements();
            }
        }
        LOG.info("All mapped statement build successfully");
    }

    public BasicDAO getObject() throws Exception {
        Assert.notNull((Object)this.config, (String)"config can not be null");
        DatabaseRouter router = this.newDataBaseRouter(this.config);
        BasicDAO dao = new BasicDAO();
        dao.setRouter(router);
        return dao;
    }

    public Class<?> getObjectType() {
        return BasicDAO.class;
    }

    public MybatisxConfig getConfig() {
        return this.config;
    }

    public void run(ApplicationArguments args) throws Exception {
        this.init();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

