/*
 * Decompiled with CFR 0.152.
 */
package org.mayanjun.mybatisx.starter;

import org.mayanjun.mybatisx.dal.dao.BasicDAO;
import org.mayanjun.mybatisx.starter.BasicDaoFactoryBean;
import org.mayanjun.mybatisx.starter.MybatisxConfig;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ResourceLoader;

@EnableConfigurationProperties(value={MybatisxConfig.class})
@ConditionalOnClass(value={BasicDAO.class})
@AutoConfigureAfter(value={MybatisAutoConfiguration.class})
public class MybatisxAutoConfiguration
implements ResourceLoaderAware {
    private static final Logger LOG = LoggerFactory.getLogger(MybatisxAutoConfiguration.class);
    @Autowired
    private MybatisxConfig config;
    private ResourceLoader resourceLoader;

    @Bean
    @ConditionalOnMissingBean(value={BasicDAO.class})
    public BasicDAO dao() throws Exception {
        BasicDaoFactoryBean factory = new BasicDaoFactoryBean(this.config);
        factory.setResourceLoader(this.resourceLoader);
        BasicDAO dao = factory.getObject();
        LOG.info("BasicDAO create successfully");
        return dao;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

