/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Window;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import mds.devices.Interface;

public abstract class DeviceComponent
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int DATA = 0;
    public static final int STATE = 1;
    public static final int DISPATCH = 2;
    public static final int STRUCTURE = 3;
    Interface subtree;
    public int mode = 0;
    public int baseNid = 0;
    public int offsetNid = 0;
    protected String curr_data = null;
    protected String init_data;
    protected boolean curr_on;
    protected boolean init_on;
    protected int nidData;
    protected int baseNidData;
    protected String identifier;
    protected String updateIdentifier;
    protected boolean editable = true;
    protected boolean isHighlighted = false;
    private boolean is_initialized = false;
    private boolean enabled = true;
    private int refShot = -2;
    DeviceSetup master = null;

    public void apply() throws Exception {
        if (!this.enabled) {
            return;
        }
        if (this.mode == 0) {
            this.curr_data = this.getData();
            if (this.editable && this.isDataChanged()) {
                try {
                    this.subtree.putDataExpr(this.nidData, this.curr_data);
                }
                catch (Exception e) {
                    System.out.println("Error writing device data: " + e);
                    System.out.println(this.curr_data);
                    throw e;
                }
            }
            this.checkRefShot();
        }
        if (this.mode != 2 && this.supportsState()) {
            this.curr_on = this.getState();
            try {
                this.subtree.setOn(this.nidData, this.curr_on);
            }
            catch (Exception e) {
                System.out.println("Error writing device state: " + e);
            }
        }
    }

    public void apply(int currBaseNid) throws Exception {
        int currNidData = currBaseNid + this.offsetNid;
        if (!this.enabled) {
            return;
        }
        if (this.mode == 0) {
            this.curr_data = this.getData();
            if (this.editable) {
                try {
                    this.subtree.putDataExpr(currNidData, this.curr_data);
                }
                catch (Exception e) {
                    System.out.println("Error writing device data: " + e);
                    System.out.println("at node: " + this.subtree.getFullPath(this.nidData));
                    System.out.println(this.curr_data);
                    throw e;
                }
            }
        }
        if (this.mode != 2 && this.supportsState()) {
            this.curr_on = this.getState();
            try {
                this.subtree.setOn(currNidData, this.curr_on);
            }
            catch (Exception e) {
                System.out.println("Error writing device state: " + e);
            }
        }
        this.checkRefShot();
    }

    public void checkRefShot() {
        if (this.refShot < -1) {
            return;
        }
        try {
            String refPath = this.subtree.getFullPath(this.baseNid + this.offsetNid);
            String refExpr = "USING(" + refPath + ",," + this.refShot + ")";
            System.out.println(refExpr);
            String refDataExpr = this.subtree.execute(refExpr);
            String currDataExpr = this.subtree.execute(this.curr_data);
            if (!currDataExpr.equals(refDataExpr)) {
                this.setHighlight(true);
            } else {
                this.setHighlight(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void configure(int baseNid) {
        this.baseNid = baseNid;
        this.nidData = baseNid + this.offsetNid;
        this.baseNidData = baseNid;
        if (this.mode == 0) {
            try {
                this.init_data = this.curr_data = this.subtree.getDataExpr(this.nidData);
            }
            catch (Exception e) {
                this.curr_data = null;
                this.init_data = null;
            }
        } else {
            this.init_data = null;
        }
        try {
            this.init_on = this.curr_on = this.subtree.isOn(this.nidData);
        }
        catch (Exception e) {
            System.out.println("Error configuring device: " + e);
        }
        if (!this.is_initialized) {
            this.initializeData(this.curr_data, this.curr_on);
            this.is_initialized = true;
        } else {
            this.displayData(this.curr_data, this.curr_on);
        }
        this.checkRefShot();
    }

    public void configure(int baseNid, boolean readOnly) {
        this.configure(baseNid);
    }

    protected Object copyData() {
        return null;
    }

    protected void dataChanged(int offsetNid, Object data) {
    }

    protected abstract void displayData(String var1, boolean var2);

    public void fireUpdate(String updateId, String newExpr) {
    }

    public int getBaseNid() {
        return this.baseNid;
    }

    protected abstract String getData();

    protected Object getFullData() {
        return this.getData();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getOffsetNid() {
        return this.offsetNid;
    }

    public int getRefShot() {
        return this.refShot;
    }

    protected abstract boolean getState();

    Interface getSubtree() {
        return this.subtree;
    }

    public String getUpdateId(DeviceSetup master) {
        this.master = master;
        return this.updateIdentifier;
    }

    public String getUpdateIdentifier() {
        return this.updateIdentifier;
    }

    protected abstract void initializeData(String var1, boolean var2);

    protected boolean isChanged() {
        try {
            return !this.init_data.equals(this.curr_data);
        }
        catch (Exception exc) {
            return false;
        }
    }

    protected boolean isDataChanged() {
        return true;
    }

    protected boolean isStateChanged() {
        return this.init_on != this.curr_on;
    }

    protected void pasteData(Object objData) {
    }

    void postApply() {
    }

    public void postConfigure() {
    }

    protected void redisplay() {
        Container curr_container;
        Container curr_component = this;
        do {
            curr_container = curr_component.getParent();
            curr_component = curr_container;
        } while (curr_container != null && !(curr_container instanceof Window));
    }

    public void reportDataChanged(Object data) {
        if (this.master == null) {
            return;
        }
        this.master.propagateData(this.offsetNid, data);
    }

    public void reportStateChanged(boolean state) {
        if (this.master == null) {
            return;
        }
        this.master.propagateState(this.offsetNid, state);
    }

    public void reset() {
        this.curr_data = this.init_data;
        this.curr_on = this.init_on;
        this.displayData(this.curr_data, this.curr_on);
    }

    public void setBaseNid(int nid) {
        this.baseNid = nid;
    }

    public void setDisable() {
        this.enabled = false;
    }

    public void setEnable() {
        this.enabled = true;
    }

    public void setHighlight(boolean isHighlighted) {
        this.isHighlighted = isHighlighted;
        Container currGrandparent = this;
        do {
            DeviceComponent currParent;
            if (!((currGrandparent = (currParent = currGrandparent).getParent()) instanceof JTabbedPane)) continue;
            int idx = ((JTabbedPane)currGrandparent).indexOfComponent(currParent);
            ((JTabbedPane)currGrandparent).setForegroundAt(idx, isHighlighted ? Color.red : Color.black);
        } while (!(currGrandparent instanceof DeviceSetup));
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setOffsetNid(int nid) {
        this.offsetNid = nid;
    }

    public void setRefShot(int refShot) {
        this.refShot = refShot;
    }

    void setSubtree(Interface subtree) {
        this.subtree = subtree;
    }

    public void setUpdateIdentifier(String updateIdentifier) {
        this.updateIdentifier = updateIdentifier;
    }

    protected void stateChanged(int offsetNid, boolean state) {
    }

    protected boolean supportsState() {
        return false;
    }

    public void update() {
        try {
            String updatedData = this.subtree.getDataExpr(this.baseNid + this.offsetNid);
            String prevInitData = this.init_data;
            this.init_data = updatedData;
            this.reset();
            this.init_data = prevInitData;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

