/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DeviceLabel
extends DeviceComponent {
    private static final long serialVersionUID = 1L;
    String data;
    public boolean textOnly = false;
    public boolean displayEvaluated = false;
    public String labelString = "<empty>";
    public int numCols = 10;
    protected boolean initializing = true;
    protected int preferredWidth = -1;
    JPanel jp;
    protected String initialField = "<empty>";
    private final boolean reportingChange = false;
    protected JLabel label = new JLabel("<empty>");

    public DeviceLabel() {
        this.add(this.label);
        this.setLayout(new FlowLayout(0, 2, 0));
        this.initializing = false;
    }

    @Override
    public Component add(Component c) {
        if (!this.initializing) {
            JOptionPane.showMessageDialog(null, "You cannot add a component to a Device Label. Please remove the component.", "Error adding Device field", 2);
            return null;
        }
        return super.add(c);
    }

    @Override
    public Component add(Component c, int intex) {
        if (!this.initializing) {
            JOptionPane.showMessageDialog(null, "You cannot add a component to a Device Label. Please remove the component.", "Error adding Device field", 2);
            return null;
        }
        return super.add(c);
    }

    @Override
    public Component add(String name, Component c) {
        if (!this.initializing) {
            JOptionPane.showMessageDialog(null, "You cannot add a component to a Device Label. Please remove the component.", "Error adding Device field", 2);
            return null;
        }
        return super.add(c);
    }

    @Override
    public void apply() {
    }

    @Override
    public void apply(int currBaseNid) {
    }

    protected void dataChanged(int offsetNid, String data) {
        if (this.offsetNid != offsetNid) {
            return;
        }
        this.label.setText(data);
    }

    @Override
    protected void displayData(String data, boolean is_on) {
        this.data = data;
        if (data != null) {
            String textString;
            if (this.displayEvaluated) {
                try {
                    this.initialField = textString = this.subtree.execute(data);
                }
                catch (Exception exc) {
                    textString = data;
                }
            } else {
                textString = data;
            }
            if (textString != null) {
                if (this.textOnly && textString.charAt(0) == '\"') {
                    this.label.setText(textString.substring(1, textString.length() - 1));
                } else {
                    this.label.setText(textString);
                }
            }
        } else {
            this.label.setText("<empty>");
        }
    }

    @Override
    protected String getData() {
        String dataString = this.label.getText();
        if (dataString == null) {
            return null;
        }
        if (this.textOnly) {
            return "\"" + dataString + "\"";
        }
        return dataString;
    }

    public boolean getDisplayEvaluated() {
        return this.displayEvaluated;
    }

    public String getLabelString() {
        return this.labelString;
    }

    public int getNumCols() {
        return this.numCols;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    @Override
    protected boolean getState() {
        return true;
    }

    public boolean getTextOnly() {
        return this.textOnly;
    }

    @Override
    protected void initializeData(String data, boolean is_on) {
        this.initializing = true;
        this.displayData(data, is_on);
        this.redisplay();
        this.initializing = false;
    }

    @Override
    protected boolean isDataChanged() {
        if (this.displayEvaluated && this.initialField != null) {
            return !this.label.getText().equals(this.initialField);
        }
        return true;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.setPreferredSize(new Dimension(width, height));
    }

    public void setDisplayEvaluated(boolean displayEvaluated) {
        this.displayEvaluated = displayEvaluated;
    }

    public void setLabelString(String labelString) {
        this.labelString = labelString;
        this.label.setText(labelString);
    }

    public void setNumCols(int numCols) {
        this.numCols = numCols;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.setSize(numCols * fm.charWidth('A'), fm.getHeight() + 4);
    }

    public void setPreferredWidth(int preferredWidth) {
        this.preferredWidth = preferredWidth;
    }

    public void setTextOnly(boolean textOnly) {
        this.textOnly = textOnly;
    }
}

