/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import mds.devices.Interface;

public class DeviceSetup
extends JDialog
implements Interface.Setup {
    private static final long serialVersionUID = 1L;
    protected static Hashtable<Integer, DeviceSetup> activeNidHash = new Hashtable();
    static Vector<DeviceSetup> openDevicesV = new Vector();
    protected String deviceType;
    protected String deviceTitle;
    protected String deviceProvider;
    public int baseNid;
    public int num_components = 0;
    protected Vector<DeviceComponent> device_components = new Vector();
    protected Vector<DeviceControl> device_controls = new Vector();
    public Interface subtree = null;
    protected String[] methods;
    protected DeviceButtons buttons = null;
    JMenuItem[] pop_items;
    JPopupMenu pop_methods = null;
    Hashtable<String, Vector<DeviceComponent>> updateHash = new Hashtable();
    Vector<DeviceCloseListener> deviceCloseListenerV = new Vector();
    Vector<DeviceUpdateListener> deviceUpdateListenerV = new Vector();
    boolean readOnly = false;
    boolean justApplied = false;
    protected String updateEvent = null;

    static void closeSetups() {
        for (DeviceSetup setup : openDevicesV) {
            setup.cancel();
        }
    }

    public static final Interface.Setup getSetup(int nid, boolean readOnly) {
        DeviceSetup ds = activeNidHash.get(new Integer(nid));
        if (ds != null) {
            ds.setReadOnly(readOnly);
            ds.setVisible(true);
        }
        return ds;
    }

    public static Interface.Setup newSetup(int nid, String model, Interface iface, Object pointOrComponent, boolean readOnly) throws Exception {
        Point point = null;
        Component parent = null;
        if (pointOrComponent instanceof Component) {
            parent = (Component)pointOrComponent;
        } else {
            point = (Point)pointOrComponent;
        }
        String deviceClassName = model + "Setup";
        Class<?> deviceClass = Class.forName(deviceClassName);
        DeviceSetup ds = (DeviceSetup)deviceClass.newInstance();
        Dimension prevDim = ds.getSize();
        ds.configure(iface, nid);
        ds.setReadOnly(readOnly);
        if (ds.getContentPane().getLayout() != null) {
            ds.pack();
        }
        ds.setSize(prevDim);
        if (parent != null) {
            ds.setLocationRelativeTo(parent);
        } else if (point != null) {
            ds.setLocation(point);
        } else {
            ds.setLocationByPlatform(true);
        }
        ds.setVisible(true);
        return ds;
    }

    public DeviceSetup() {
        this((Frame)null, false);
        this.setTitle(this.deviceTitle);
        DeviceSetupBeanInfo.beanDeviceType = this.deviceType;
        openDevicesV.addElement(this);
    }

    public DeviceSetup(Frame f) {
        this(f, false);
        openDevicesV.addElement(this);
    }

    public DeviceSetup(Frame f, boolean readOnly) {
        super(f);
        this.readOnly = readOnly;
        this.setTitle(this.deviceTitle);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DeviceSetup.this.cancel();
            }
        });
    }

    void addButton(JButton button) {
        if (this.buttons != null) {
            this.buttons.add(button);
        }
    }

    void addDeviceCloseListener(DeviceCloseListener listener) {
        this.deviceCloseListenerV.addElement(listener);
    }

    void addDeviceUpdateListener(DeviceUpdateListener listener) {
        this.deviceUpdateListenerV.addElement(listener);
    }

    public void apply() {
        int oldDef = this.pushDefault();
        for (DeviceComponent comp : this.device_components) {
            try {
                comp.apply();
            }
            catch (Exception exc) {
                String path;
                exc.printStackTrace();
                try {
                    path = this.subtree.getFullPath(comp.getBaseNid() + comp.getOffsetNid());
                }
                catch (Exception exc1) {
                    path = "";
                }
                JOptionPane.showMessageDialog(this, "Error writing data at  " + path + ": " + exc.toString(), "Error writing data", 2);
            }
        }
        for (DeviceComponent comp : this.device_components) {
            comp.postApply();
        }
        this.popDefault(oldDef);
        if (this.isChanged()) {
            for (DeviceUpdateListener dul : this.deviceUpdateListenerV) {
                dul.deviceUpdated();
            }
        }
        this.justApplied = true;
    }

    public void apply(int currBaseNid) {
        int oldDef = this.pushDefault();
        for (DeviceComponent comp : this.device_components) {
            try {
                comp.apply(currBaseNid);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                JOptionPane.showMessageDialog(this, exc.toString(), "Error writing data at offset nid " + comp.getOffsetNid(), 2);
            }
        }
        this.popDefault(oldDef);
        this.justApplied = true;
    }

    void cancel() {
        activeNidHash.remove(new Integer(this.baseNid));
        openDevicesV.removeElement(this);
        this.dispose();
        for (DeviceCloseListener dcl : this.deviceCloseListenerV) {
            dcl.deviceClosed(this.isChanged(), this.justApplied);
        }
        this.justApplied = false;
    }

    public boolean check() {
        if (this.buttons != null) {
            return this.buttons.check();
        }
        return true;
    }

    public boolean check(String[] expressions, String[] messages) {
        if (expressions == null || messages == null) {
            return true;
        }
        int num_expr = Math.min(expressions.length, messages.length);
        StringBuffer varExpr = new StringBuffer();
        for (DeviceComponent comp : this.device_components) {
            String currId = comp.getIdentifier();
            if (currId == null || currId.trim().equals("")) continue;
            String currData = comp.getData();
            if (currData != null) {
                varExpr.append("_" + currId + " = " + currData + ";");
            }
            if (comp.getState()) {
                varExpr.append("_" + currId + "_state = 1; ");
                continue;
            }
            varExpr.append("_" + currId + "_state = 0; ");
        }
        for (int i = 0; i < num_expr; ++i) {
            try {
                if (this.subtree.getInt(varExpr + expressions[i]) != 0) continue;
                JOptionPane.showMessageDialog(this, messages[i], "Error in device configuration", 2);
                continue;
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(this, exc.toString(), "Error in device configuration", 2);
                return false;
            }
        }
        return true;
    }

    public void configure(Interface subtree, int baseNid) {
        this.baseNid = baseNid;
        this.subtree = subtree;
        activeNidHash.put(new Integer(baseNid), this);
        int oldDef = this.pushDefault();
        String path = null;
        try {
            path = subtree.getFullPath(baseNid);
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
        if (path == null) {
            this.setTitle(this.deviceTitle);
        } else {
            this.setTitle(this.deviceTitle + " -- " + path);
        }
        Stack<Container> search_stack = new Stack<Container>();
        search_stack.push(this);
        while (!search_stack.isEmpty()) {
            Component[] curr_components = ((Container)search_stack.pop()).getComponents();
            if (curr_components == null) continue;
            for (Component comp : curr_components) {
                if (comp instanceof DeviceButtons) {
                    this.buttons = (DeviceButtons)comp;
                    this.methods = ((DeviceButtons)comp).getMethods();
                    this.buttons.setReadOnly(this.readOnly);
                } else if (comp instanceof DeviceComponent) {
                    this.device_components.addElement((DeviceComponent)comp);
                } else if (comp instanceof DeviceControl) {
                    this.device_controls.addElement((DeviceControl)comp);
                }
                if (!(comp instanceof Container)) continue;
                search_stack.push((Container)comp);
            }
        }
        this.num_components = this.device_components.size();
        for (DeviceComponent comp : this.device_components) {
            comp.setSubtree(subtree);
            comp.configure(baseNid, this.readOnly);
            String currUpdateId = comp.getUpdateId(this);
            if (currUpdateId == null || currUpdateId.equals("")) continue;
            Vector<DeviceComponent> components = this.updateHash.get(currUpdateId);
            if (components == null) {
                components = new Vector();
                this.updateHash.put(currUpdateId, components);
            }
            components.addElement(comp);
        }
        try {
            for (DeviceComponent comp : this.device_components) {
                comp.postConfigure();
            }
        }
        catch (Throwable exc) {
            System.out.println(exc);
        }
        if (this.methods != null && this.methods.length > 0) {
            this.pop_methods = new JPopupMenu("Methods");
            this.pop_items = new JMenuItem[this.methods.length];
            for (int i = 0; i < this.methods.length; ++i) {
                this.pop_items[i] = new JMenuItem(this.methods[i]);
                this.pop_methods.add(this.pop_items[i]);
                this.pop_items[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int j;
                        boolean success = true;
                        String errmsg = "";
                        for (j = 0; j < DeviceSetup.this.pop_items.length && (JMenuItem)e.getSource() != DeviceSetup.this.pop_items[j]; ++j) {
                        }
                        if (j == DeviceSetup.this.pop_items.length) {
                            return;
                        }
                        if (JOptionPane.showConfirmDialog(DeviceSetup.this, "Execute " + DeviceSetup.this.methods[j] + "?", "Execute a device method", 0, 3) == 0) {
                            try {
                                DeviceSetup.this.subtree.doDeviceMethod(DeviceSetup.this.baseNid, DeviceSetup.this.methods[j]);
                            }
                            catch (Exception exc) {
                                errmsg = exc.toString();
                                success = false;
                            }
                            if (!success) {
                                JOptionPane.showMessageDialog(DeviceSetup.this, "Error executing method " + DeviceSetup.this.methods[j] + ": " + errmsg, "Method execution report", 2);
                            } else {
                                JOptionPane.showMessageDialog(DeviceSetup.this, "Method " + DeviceSetup.this.methods[j] + " succesfully executed", "Method execution report", 1);
                            }
                        }
                    }
                });
            }
            this.pop_methods.pack();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if ((e.getModifiers() & 4) != 0) {
                        DeviceSetup.this.pop_methods.setInvoker(DeviceSetup.this);
                        DeviceSetup.this.pop_methods.show(DeviceSetup.this, e.getX(), e.getY());
                    }
                }
            });
        }
        this.popDefault(oldDef);
    }

    @Override
    public void dataChanged(int ... nids) {
        this.update();
    }

    public void fireUpdate(String id, String val) {
        Vector<DeviceComponent> components = this.updateHash.get(id);
        if (components != null) {
            for (DeviceComponent comp : components) {
                comp.fireUpdate(id, val);
            }
        }
    }

    public String getDeviceProvider() {
        DeviceSetupBeanInfo.beanDeviceProvider = this.deviceProvider;
        return this.deviceProvider;
    }

    public String getDeviceTitle() {
        return this.deviceTitle;
    }

    public String getDeviceType() {
        DeviceSetupBeanInfo.beanDeviceType = this.deviceType;
        return this.deviceType;
    }

    public String getUpdateEvent() {
        return this.updateEvent;
    }

    boolean isChanged() {
        for (DeviceComponent comp : this.device_components) {
            if (comp.isChanged()) {
                return true;
            }
            if (!comp.isStateChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private final void popDefault(int oldDef) {
        try {
            this.subtree.setDefault(oldDef);
        }
        catch (Exception exc) {
            System.out.println("Error resetting default: " + exc);
        }
    }

    public void propagateData(int offsetNid, Object data) {
        for (DeviceComponent comp : this.device_components) {
            comp.dataChanged(offsetNid, data);
        }
    }

    public void propagateState(int offsetNid, boolean state) {
        for (DeviceComponent comp : this.device_components) {
            comp.stateChanged(offsetNid, state);
        }
    }

    private final int pushDefault() {
        int oldDef = 0;
        try {
            oldDef = this.subtree.getDefault();
            this.subtree.setDefault(this.baseNid);
        }
        catch (Exception exc) {
            System.out.println("Error setting default: " + exc);
        }
        return oldDef;
    }

    public void reset() {
        int oldDef = this.pushDefault();
        for (DeviceComponent comp : this.device_components) {
            comp.reset();
        }
        this.popDefault(oldDef);
    }

    public void resetNidHash() {
        activeNidHash.remove(new Integer(this.baseNid));
    }

    public void setCancelText(String cancelText) {
        if (this.buttons != null) {
            this.buttons.setCancelText(cancelText);
        }
    }

    public void setDeviceProvider(String deviceProvider) {
        this.deviceProvider = deviceProvider;
        DeviceSetupBeanInfo.beanDeviceProvider = deviceProvider;
    }

    public void setDeviceTitle(String deviceTitle) {
        this.deviceTitle = deviceTitle;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
        DeviceSetupBeanInfo.beanDeviceType = deviceType;
    }

    public void setHeight(int height) {
        int width = super.getWidth();
        this.setSize(width, height);
    }

    void setHighlight(boolean isHighlighted, int[] nids) {
        block0: for (DeviceComponent comp : this.device_components) {
            int nid = comp.getBaseNid() + comp.getOffsetNid();
            for (int nid2 : nids) {
                if (nid2 != nid) continue;
                comp.setHighlight(isHighlighted);
                continue block0;
            }
        }
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        if (this.buttons != null) {
            this.buttons.setReadOnly(readOnly);
        }
        for (DeviceControl comp : this.device_controls) {
            comp.setReadOnly(readOnly);
        }
    }

    public void setUpdateEvent(String updateEvent) {
        this.updateEvent = updateEvent;
    }

    public void setWidth(int width) {
        int height = super.getHeight();
        this.setSize(width, height);
    }

    public void update() {
        int oldDef = this.pushDefault();
        for (DeviceComponent comp : this.device_components) {
            comp.update();
        }
        this.popDefault(oldDef);
    }

    public void updateIdentifiers() {
        StringBuffer varExpr = new StringBuffer();
        for (DeviceComponent comp : this.device_components) {
            String currId = comp.getIdentifier();
            if (currId == null) continue;
            String currData = comp.getData();
            if (currData != null) {
                varExpr.append("_" + currId + " = " + currData + ";");
            }
            if (comp.getState()) {
                varExpr.append("_" + currId + "_state = 1; ");
                continue;
            }
            varExpr.append("_" + currId + "_state = 0; ");
        }
        if (!this.device_components.isEmpty()) {
            try {
                this.subtree.getInt(varExpr.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

