/*
 * Decompiled with CFR 0.152.
 */
package mds.provider;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JFrame;
import mds.connection.ConnectionListener;
import mds.connection.UpdateEventListener;
import mds.provider.MdsDataProvider;
import mds.wave.DataProvider;
import mds.wave.DataServerItem;
import mds.wave.FrameData;
import mds.wave.WaveData;

public class UniversalDataProvider
implements DataProvider {
    private String error;
    private MdsDataProvider defaultProvider;
    private final Hashtable<String, MdsDataProvider> dataProviderH = new Hashtable();

    public UniversalDataProvider() {
        this.defaultProvider = new MdsDataProvider();
    }

    @Override
    public void addConnectionListener(ConnectionListener l) {
        this.defaultProvider.addConnectionListener(l);
    }

    @Override
    public void addUpdateEventListener(UpdateEventListener l, String event) throws IOException {
        this.defaultProvider.addUpdateEventListener(l, event);
    }

    @Override
    public void close() {
        Enumeration<MdsDataProvider> en = this.dataProviderH.elements();
        while (en.hasMoreElements()) {
            en.nextElement().close();
        }
    }

    @Override
    public String getError() {
        return this.error;
    }

    private String getExperiment(String in) {
        String subStr1 = in.trim().substring(2);
        int pos1 = subStr1.indexOf("/");
        String subStr2 = subStr1.substring(pos1 + 1);
        int pos2 = subStr2.indexOf("/");
        return subStr2.substring(0, pos2);
    }

    private String getExpr(String spec) {
        if (!spec.startsWith("//")) {
            return spec;
        }
        String subStr1 = spec.trim().substring(2);
        int pos1 = subStr1.indexOf("/");
        String subStr2 = subStr1.substring(pos1 + 1);
        int pos2 = subStr2.indexOf("/");
        String subStr3 = subStr2.substring(pos2 + 1);
        int pos3 = subStr3.indexOf("/");
        return subStr3.substring(pos3 + 1);
    }

    @Override
    public double getFloat(String in, int row, int col, int index) {
        try {
            return this.defaultProvider.getFloat(in, row, col, index);
        }
        catch (Exception exc) {
            this.error = "" + exc;
            return 0.0;
        }
    }

    @Override
    public FrameData getFrameData(String in_y, String in_x, float time_min, float time_max) throws IOException {
        return null;
    }

    private MdsDataProvider getProvider(String ip) {
        if (!ip.startsWith("//")) {
            return this.defaultProvider;
        }
        int pos = ip.substring(2).indexOf("/");
        String currIp = ip.substring(2, pos + 2);
        MdsDataProvider provider = this.dataProviderH.get(currIp);
        if (provider == null) {
            provider = new MdsDataProvider();
            try {
                provider.setArgument(currIp);
                this.dataProviderH.put(currIp, provider);
            }
            catch (Exception exc) {
                return null;
            }
        }
        return provider;
    }

    private int getShot(String in) throws Exception {
        String subStr1 = in.trim().substring(2);
        int pos1 = subStr1.indexOf("/");
        String subStr2 = subStr1.substring(pos1 + 1);
        int pos2 = subStr2.indexOf("/");
        String subStr3 = subStr2.substring(pos2 + 1);
        int pos3 = subStr3.indexOf("/");
        String subStr4 = subStr3.substring(0, pos3);
        return Integer.parseInt(subStr4);
    }

    @Override
    public long[] getShots(String in, String experiment) {
        try {
            return this.defaultProvider.getShots(in, experiment);
        }
        catch (Exception exc) {
            this.error = "" + exc;
            return null;
        }
    }

    @Override
    public String getString(String in, int row, int col, int index) {
        try {
            return this.defaultProvider.getString(in, row, col, index);
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Override
    public WaveData getWaveData(String in, int row, int col, int index) {
        MdsDataProvider currProvider = this.getProvider(in);
        if (currProvider == null) {
            this.error = "Missing default provider";
            return null;
        }
        if (!this.isDefault(in)) {
            try {
                currProvider.update(this.getExperiment(in), this.getShot(in));
            }
            catch (Exception exc) {
                System.out.println(exc);
            }
        }
        try {
            return currProvider.getWaveData(this.getExpr(in), row, col, index);
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Override
    public WaveData getWaveData(String in_y, String in_x, int row, int col, int index) {
        MdsDataProvider currProvider = this.getProvider(in_y);
        if (currProvider == null) {
            this.error = "Missing default provider";
            return null;
        }
        if (!this.isDefault(in_y)) {
            try {
                currProvider.update(this.getExperiment(in_y), this.getShot(in_y));
            }
            catch (Exception exc) {
                System.out.println(exc);
            }
        }
        try {
            return currProvider.getWaveData(this.getExpr(in_y), this.getExpr(in_x), row, col, index);
        }
        catch (Exception exc) {
            this.error = "" + exc;
            return null;
        }
    }

    @Override
    public int inquireCredentials(JFrame f, DataServerItem server_item) {
        return 1;
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    private boolean isDefault(String in) {
        return !in.startsWith("//");
    }

    @Override
    public void removeConnectionListener(ConnectionListener l) {
        this.defaultProvider.removeConnectionListener(l);
    }

    @Override
    public void removeUpdateEventListener(UpdateEventListener l, String event) throws IOException {
        this.defaultProvider.removeUpdateEventListener(l, event);
    }

    @Override
    public void setArgument(String arg) {
        try {
            this.defaultProvider.setArgument(arg);
        }
        catch (Exception exc) {
            this.defaultProvider = null;
        }
    }

    @Override
    public void setEnvironment(String exp) {
        Enumeration<MdsDataProvider> en = this.dataProviderH.elements();
        while (en.hasMoreElements()) {
            try {
                en.nextElement().setEnvironment(exp);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean supportsTunneling() {
        return false;
    }

    @Override
    public void update(String exp, long s) {
        this.defaultProvider.update(exp, s);
    }
}

