/*
 * Decompiled with CFR 0.152.
 */
package mds.jdispatcher;

import MDSplus.Data;
import MDSplus.Dispatch;
import MDSplus.MdsException;
import MDSplus.TreeNode;
import java.util.Date;
import mds.jdispatcher.MdsHelper;

class Action {
    static final int NOT_DISPATCHED = 1;
    static final int DISPATCHED = 2;
    static final int DOING = 3;
    static final int DONE = 4;
    static final int ABORTED = 5;
    static final int ServerNOT_DISPATCHED = 266436616;
    static final int ServerINVALID_DEPENDENCY = 266436626;
    static final int ServerCANT_HAPPEN = 266436634;
    private final MDSplus.Action action;
    private final Dispatch dispatch;
    private String server_address;
    private final int nid;
    private final String name;
    private final boolean on;
    private int dispatch_status;
    private int status;
    private boolean manual = false;
    private final boolean essential;

    public Action(MDSplus.Action action, int nid, String name, boolean on, boolean essential, String server_address) {
        this.action = action;
        this.nid = nid;
        this.name = name;
        this.on = on;
        this.dispatch_status = 1;
        this.status = 0;
        this.server_address = server_address;
        this.essential = essential;
        Data data = action.getDispatch();
        while (data != null && !(data instanceof Dispatch)) {
            if (data instanceof TreeNode) {
                try {
                    data = ((TreeNode)data).getData();
                }
                catch (MdsException e) {
                    data = null;
                }
                continue;
            }
            data.data();
        }
        this.dispatch = (Dispatch)data;
    }

    public MDSplus.Action getAction() {
        return this.action;
    }

    public Dispatch getDispatch() {
        return this.dispatch;
    }

    public synchronized int getDispatchStatus() {
        return this.dispatch_status;
    }

    public String getName() {
        return this.name;
    }

    public int getNid() {
        return this.nid;
    }

    public synchronized String getServerAddress() {
        return this.server_address;
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public boolean isEssential() {
        return this.essential;
    }

    public synchronized boolean isManual() {
        return this.manual;
    }

    public boolean isOn() {
        return this.on;
    }

    public synchronized void setManual(boolean manual) {
        this.manual = manual;
    }

    public synchronized void setServerAddress(String server_address) {
        this.server_address = server_address;
    }

    synchronized void setStatus(int status) {
        this.status = status;
    }

    synchronized void setStatus(int dispatch_status, int status, boolean verbose) {
        this.status = status;
        this.dispatch_status = dispatch_status;
        if (verbose) {
            String server;
            try {
                server = this.dispatch.getIdent().getString();
            }
            catch (Exception e) {
                server = "";
            }
            switch (dispatch_status) {
                case 2: {
                    System.out.println("" + new Date() + " Dispatching node " + this.name + "(" + this.nid + ") to " + server);
                    break;
                }
                case 3: {
                    System.out.println("" + new Date() + " " + server + " is beginning action " + this.name);
                    break;
                }
                case 4: {
                    if ((status & 1) != 0) {
                        System.out.println("" + new Date() + " Action " + this.name + " completed  ");
                        break;
                    }
                    System.out.println("" + new Date() + " Action " + this.name + " failed  " + MdsHelper.getErrorString(status));
                    break;
                }
                case 5: {
                    System.out.println("" + new Date() + " Action " + this.name + " aborted");
                }
            }
        }
    }

    public String toString() {
        return this.name;
    }
}

