/*
 * Decompiled with CFR 0.152.
 */
package mds.jdispatcher;

import MDSplus.Data;
import MDSplus.Method;
import MDSplus.Procedure;
import MDSplus.Program;
import MDSplus.Routine;
import MDSplus.TreeNode;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import mds.connection.ConnectionEvent;
import mds.connection.ConnectionListener;
import mds.connection.Descriptor;
import mds.jdispatcher.Action;
import mds.jdispatcher.MdsServer;
import mds.jdispatcher.MdsServerEvent;
import mds.jdispatcher.MdsServerListener;
import mds.jdispatcher.Server;
import mds.jdispatcher.ServerEvent;
import mds.jdispatcher.ServerListener;

class ActionServer
implements Server,
MdsServerListener,
ConnectionListener {
    static final int RECONNECT_TIME = 5;
    private final Queue<Action> enqueued_actions = new LinkedList<Action>();
    private final Hashtable<Integer, Action> doing_actions = new Hashtable();
    private final Vector<ServerListener> server_listeners = new Vector();
    private MdsServer mds_server = null;
    private String tree;
    private final String server_class;
    private final String ip_address;
    private final String subtree;
    private int shot;
    private boolean ready = false;
    private boolean active = false;
    private Timer timer = null;
    private boolean useJavaServer = true;
    private int watchdogPort = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void logAction(String msg) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.print("ActionServer: ");
            System.out.println(msg);
            System.out.flush();
        }
    }

    public ActionServer(String tree, String ip_address, String server_class) {
        this(tree, ip_address, server_class, null, true, -1);
    }

    public ActionServer(String tree, String ip_address, String server_class, boolean useJavaServer, int watchdogPort) {
        this(tree, ip_address, server_class, null, useJavaServer, watchdogPort);
    }

    public ActionServer(String tree, String ip_address, String server_class, String subtree, boolean useJavaServer, int watchdogPort) {
        this.tree = tree;
        this.server_class = server_class;
        this.ip_address = ip_address;
        this.subtree = subtree;
        this.useJavaServer = useJavaServer;
        this.watchdogPort = watchdogPort;
        try {
            this.mds_server = new MdsServer(ip_address, useJavaServer, watchdogPort);
            this.mds_server.addMdsServerListener(this);
            this.mds_server.addConnectionListener(this);
            this.active = true;
            this.ready = true;
        }
        catch (Exception exc) {
            ActionServer.logAction("Cannot connect to server " + ip_address + " server class " + server_class);
            this.shutdown();
            this.startServerPoll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(boolean flush) {
        Queue<Action> queue = this.enqueued_actions;
        synchronized (queue) {
            this.enqueued_actions.clear();
        }
        if (this.mds_server == null) {
            return;
        }
        try {
            this.mds_server.abort(flush);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean abortAction(Action action) {
        if (this.doing_actions.get(new Integer(action.getNid())) == null && !this.enqueued_actions.contains(action)) {
            return false;
        }
        Queue<Action> queue = this.enqueued_actions;
        synchronized (queue) {
            try {
                this.mds_server.abort(false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public synchronized void addServerListener(ServerListener listener) {
        this.server_listeners.addElement(listener);
    }

    @Override
    public void beginSequence(int shot) {
        this.shot = shot;
        if (this.mds_server == null || this.subtree == null || this.subtree.trim().equals("")) {
            return;
        }
        try {
            this.mds_server.createPulse(this.subtree, shot);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final synchronized void cancelTimer() {
        try {
            this.timer.cancel();
            this.timer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized Action[] collectActions() {
        return null;
    }

    @Override
    public Action[] collectActions(String rootPath) {
        return null;
    }

    @Override
    public synchronized void endSequence(int shot) {
        if (this.mds_server == null) {
            return;
        }
        try {
            this.mds_server.closeTrees();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getAddress() {
        return this.ip_address;
    }

    @Override
    public int getDoingAction() {
        return this.doing_actions.size();
    }

    @Override
    public int getQueueLength() {
        return this.enqueued_actions.size();
    }

    @Override
    public synchronized String getServerClass() {
        return this.server_class;
    }

    private final synchronized Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer(this.ip_address, true);
        }
        return this.timer;
    }

    @Override
    public boolean isActive() {
        return this.ready && this.active;
    }

    @Override
    public boolean isReady() {
        if (this.ready) {
            this.active = true;
        }
        return this.ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Action popAction() {
        Descriptor descr;
        if (this.mds_server == null) {
            return null;
        }
        try {
            descr = this.mds_server.removeLast();
        }
        catch (Exception exc) {
            return null;
        }
        if (descr.getInt() != 0) {
            Action removed;
            Queue<Action> queue = this.enqueued_actions;
            synchronized (queue) {
                removed = this.enqueued_actions.remove();
            }
            removed.setServerAddress(null);
            return removed;
        }
        return null;
    }

    protected synchronized void processAborted(Action action) {
        this.processAbortedNoSynch(action);
        this.notify();
    }

    protected void processAbortedNoSynch(Action action) {
        action.setServerAddress(this.ip_address);
        for (ServerListener listener : this.server_listeners) {
            listener.actionAborted(new ServerEvent((Object)this, action));
        }
    }

    protected void processConnected(String msg) {
        for (ServerListener listener : this.server_listeners) {
            listener.connected(new ServerEvent((Object)this, msg));
        }
    }

    public void processConnectionEvent(ConnectionEvent e) {
        if (e.getID() == 2000) {
            try {
                if (!this.shutdown()) {
                    return;
                }
            }
            catch (Exception exc) {
                System.err.println("Error shutting down socket : " + this.ip_address);
            }
            ActionServer.logAction("Detected server crash : " + this.server_class);
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.processDisconnected(this.ip_address);
            this.getTimer().schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ActionServer.this.mds_server = new MdsServer(ActionServer.this.ip_address, ActionServer.this.useJavaServer, ActionServer.this.watchdogPort);
                        ActionServer.this.mds_server.addMdsServerListener(ActionServer.this);
                        ActionServer.this.mds_server.addConnectionListener(ActionServer.this);
                        ActionServer.this.mds_server.dispatchCommand("TCL", "SET TREE " + ActionServer.this.tree + "/SHOT=" + ActionServer.this.shot);
                        ActionServer.logAction("Restarting server. Class : " + ActionServer.this.server_class + " Address: " + ActionServer.this.ip_address);
                        Thread.sleep(2000L);
                    }
                    catch (Exception exc) {
                        ActionServer.this.mds_server = null;
                        ActionServer.this.ready = (ActionServer.this.active = false);
                        ActionServer.this.startServerPoll();
                    }
                    Object object = ActionServer.this.doing_actions;
                    synchronized (object) {
                        if (!ActionServer.this.doing_actions.isEmpty()) {
                            Enumeration doing_list = ActionServer.this.doing_actions.elements();
                            while (doing_list.hasMoreElements()) {
                                ActionServer.this.processAbortedNoSynch((Action)doing_list.nextElement());
                            }
                            ActionServer.this.doing_actions.clear();
                        }
                    }
                    if (ActionServer.this.mds_server == null) {
                        object = ActionServer.this.enqueued_actions;
                        synchronized (object) {
                            while (!ActionServer.this.enqueued_actions.isEmpty()) {
                                ActionServer.this.processAbortedNoSynch((Action)ActionServer.this.enqueued_actions.remove());
                            }
                        }
                    }
                    ActionServer.this.ready = (ActionServer.this.active = true);
                    object = ActionServer.this.enqueued_actions;
                    synchronized (object) {
                        for (Action action : ActionServer.this.enqueued_actions) {
                            try {
                                action.setServerAddress(ActionServer.this.ip_address);
                                ActionServer.logAction(String.format("Dispatch %s -> %s", action.getName(), ActionServer.this.ip_address));
                                ActionServer.this.mds_server.dispatchAction(ActionServer.this.tree, ActionServer.this.shot, action.getName(), action.getNid());
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }, 5000L);
        }
    }

    protected void processDisconnected(String msg) {
        Enumeration<ServerListener> listeners = this.server_listeners.elements();
        while (listeners.hasMoreElements()) {
            ServerListener listener = listeners.nextElement();
            listener.disconnected(new ServerEvent((Object)this, msg));
        }
    }

    protected void processDoing(Action action) {
        action.setServerAddress(this.ip_address);
        for (ServerListener listener : this.server_listeners) {
            listener.actionStarting(new ServerEvent((Object)this, action));
        }
    }

    protected void processFinished(Action action) {
        for (ServerListener listener : this.server_listeners) {
            listener.actionFinished(new ServerEvent((Object)this, action));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMdsServerEvent(MdsServerEvent e) {
        int mode = e.getFlags();
        switch (mode) {
            case 2: {
                Action doing_action;
                Queue<Action> queue = this.enqueued_actions;
                synchronized (queue) {
                    doing_action = this.enqueued_actions.remove();
                }
                this.doing_actions.put(new Integer(e.getJobid()), doing_action);
                this.processDoing(doing_action);
                int timeout = 0;
                try {
                    Data task = doing_action.getAction().getTask();
                    while (task instanceof TreeNode) {
                        task = ((TreeNode)task).getData();
                    }
                    if (task instanceof Routine) {
                        timeout = ((Routine)task).getTimeout().getInt();
                    } else if (task instanceof Procedure) {
                        timeout = ((Procedure)task).getTimeout().getInt();
                    } else if (task instanceof Method) {
                        timeout = ((Method)task).getTimeout().getInt();
                    } else if (task instanceof Program) {
                        timeout = ((Program)task).getTimeout().getInt();
                    }
                }
                catch (Exception task) {
                    // empty catch block
                }
                if (timeout <= 0) break;
                this.getTimer().schedule(new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ActionServer actionServer = ActionServer.this;
                        synchronized (actionServer) {
                            if (ActionServer.this.doing_actions.size() != 1) {
                                return;
                            }
                            try {
                                ActionServer.this.mds_server.abort(false);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }, timeout * 1000);
                break;
            }
            case 3: {
                this.cancelTimer();
                if (e.getJobid() == 0) {
                    return;
                }
                Action done_action = this.doing_actions.remove(new Integer(e.getJobid()));
                if (done_action == null) {
                    ActionServer.logAction("ERROR: received finish message for an action which did not start. Try to restart mdsip server " + this.ip_address);
                    break;
                }
                done_action.setStatus(e.getStatus());
                this.processFinished(done_action);
                break;
            }
            case 1: {
                this.cancelTimer();
                Action aborted_action = this.doing_actions.remove(new Integer(e.getJobid()));
                if (aborted_action == null) {
                    ActionServer.logAction("ERROR: received abort message for an action which did not start. Try to restart mdsip server " + this.ip_address);
                }
                this.processAborted(aborted_action);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushAction(Action action) {
        Queue<Action> queue = this.enqueued_actions;
        synchronized (queue) {
            action.setServerAddress(this.ip_address);
            this.enqueued_actions.add(action);
        }
        try {
            this.mds_server.dispatchAction(this.tree, this.shot, action.getName(), action.getNid());
        }
        catch (Exception exc) {
            Queue<Action> queue2 = this.enqueued_actions;
            synchronized (queue2) {
                this.enqueued_actions.remove(action);
            }
            this.processAborted(action);
        }
    }

    @Override
    public void setTree(String tree) {
        this.tree = tree;
    }

    @Override
    public void setTree(String tree, int shot) {
        this.tree = tree;
        this.shot = shot;
    }

    private final boolean shutdown() {
        this.active = false;
        this.ready = false;
        if (this.mds_server != null) {
            this.mds_server.shutdown();
            this.mds_server = null;
            return true;
        }
        return false;
    }

    void startServerPoll() {
        new Thread(){

            @Override
            public void run() {
                while (!ActionServer.this.ready) {
                    try {
                        3.sleep(2000L);
                        ActionServer.this.mds_server = new MdsServer(ActionServer.this.ip_address, ActionServer.this.useJavaServer, ActionServer.this.watchdogPort);
                        ActionServer.this.mds_server.addMdsServerListener(ActionServer.this);
                        ActionServer.this.mds_server.addConnectionListener(ActionServer.this);
                        System.out.println("Reconnected to to server " + ActionServer.this.ip_address + " server class " + ActionServer.this.server_class);
                        ActionServer.this.ready = (ActionServer.this.active = true);
                        ActionServer.this.processConnected(ActionServer.this.ip_address);
                    }
                    catch (Exception exception) {}
                }
            }
        }.start();
    }
}

