/*
 * Decompiled with CFR 0.152.
 */
package mds.jdispatcher;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import mds.connection.MdsConnection;

public class AsyncMdsConnection
extends MdsConnection {
    static final long WRITE_TIMEOUT_SECS = 60L;

    public AsyncMdsConnection(String server) {
        super(server);
    }

    public void connectToServer() throws IOException {
        this.host = this.getProviderHost();
        this.port = this.getProviderPort();
        this.user = this.getProviderUser();
        AsyncSocket asock = new AsyncSocket(this.host, this.port);
        asock.setTcpNoDelay(true);
        this.dis = asock.getInputStream();
        this.dos = new DataOutputStream(asock.getOutputStream());
    }

    class AsyncSocket {
        AsynchronousSocketChannel asc;

        public AsyncSocket(String host, int port) throws IOException {
            try {
                this.asc = AsynchronousSocketChannel.open();
                InetSocketAddress hostAddress = new InetSocketAddress(host, port);
                Future<Void> future = this.asc.connect(hostAddress);
                if (future.get() != null) {
                    throw new IOException();
                }
            }
            catch (Exception exc) {
                System.out.println(exc);
            }
        }

        public InputStream getInputStream() {
            return new AsynInputStream();
        }

        public OutputStream getOutputStream() {
            return new AsynOutputStream();
        }

        public void setTcpNoDelay(boolean noDelay) throws IOException {
            this.asc.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)noDelay);
        }

        class AsynOutputStream
        extends OutputStream {
            AsynOutputStream() {
            }

            @Override
            public void write(int b) throws IOException {
                byte[] bb = new byte[]{(byte)b};
                WriteCompletionHandler wch = new WriteCompletionHandler();
                AsyncSocket.this.asc.write(ByteBuffer.wrap(bb), 60L, TimeUnit.SECONDS, null, wch);
                int numWritten = wch.getNumWritten();
                if (numWritten != 1) {
                    throw new IOException();
                }
            }
        }

        class AsynInputStream
        extends InputStream {
            AsynInputStream() {
            }

            @Override
            public int available() {
                return 1;
            }

            @Override
            public int read() throws IOException {
                ByteBuffer bb = ByteBuffer.allocate(1);
                int bytesRead = 0;
                while (bytesRead == 0) {
                    Future<Integer> f = AsyncSocket.this.asc.read(bb);
                    try {
                        bytesRead = f.get();
                    }
                    catch (Exception exception) {}
                }
                if (bytesRead == -1) {
                    throw new IOException();
                }
                return bb.array()[0];
            }
        }
    }

    class WriteCompletionHandler
    implements CompletionHandler<Integer, Void> {
        boolean done = false;
        int numWritten;

        WriteCompletionHandler() {
        }

        synchronized int getNumWritten() {
            if (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.numWritten;
        }

        @Override
        public synchronized void completed(Integer result, Void attachment) {
            this.numWritten = result;
            this.done = true;
            this.notify();
        }

        @Override
        public synchronized void failed(Throwable exc, Void attachment) {
            this.numWritten = -1;
            this.done = true;
            this.notify();
        }
    }
}

