/*
 * Decompiled with CFR 0.152.
 */
package mds.jdispatcher;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import mds.jdispatcher.Action;
import mds.jdispatcher.ActionServer;
import mds.jdispatcher.Server;
import mds.jdispatcher.ServerEvent;
import mds.jdispatcher.ServerListener;

class Balancer
implements ServerListener {
    Hashtable<String, Vector<Server>> servers = new Hashtable();
    Server default_server = null;

    Balancer() {
    }

    public void abort() {
        Enumeration<Vector<Server>> server_vects = this.servers.elements();
        while (server_vects.hasMoreElements()) {
            Vector<Server> server_vect = server_vects.nextElement();
            Enumeration<Server> server_list = server_vect.elements();
            while (server_list.hasMoreElements()) {
                server_list.nextElement().abort(true);
            }
        }
    }

    public void abortAction(Action action) {
        Enumeration<Vector<Server>> server_vects = this.servers.elements();
        while (server_vects.hasMoreElements()) {
            for (Server server : server_vects.nextElement()) {
                if (!server.abortAction(action)) continue;
                return;
            }
        }
    }

    @Override
    public void actionAborted(ServerEvent event) {
    }

    @Override
    public synchronized void actionFinished(ServerEvent event) {
        String server;
        try {
            server = event.action.getDispatch().getIdent().getString();
        }
        catch (Exception exc) {
            return;
        }
        Vector<Server> server_vect = this.servers.get(server.toUpperCase());
        if (server_vect == null) {
            return;
        }
        if (!this.isBalanced(server_vect)) {
            Server min_loaded = null;
            Server max_loaded = null;
            int max_load = 0;
            Enumeration<Server> server_list = server_vect.elements();
            while (server_list.hasMoreElements()) {
                Server curr_server = server_list.nextElement();
                int curr_len = curr_server.getQueueLength();
                if (curr_len == 0) {
                    min_loaded = curr_server;
                }
                if (curr_len <= max_load) continue;
                max_load = curr_len;
                max_loaded = curr_server;
            }
            Action action = max_loaded.popAction();
            if (action != null) {
                System.out.println("ACTION BALANCING: action " + action.getName() + " transferred between two equivalent servers");
                min_loaded.pushAction(action);
            }
        }
    }

    @Override
    public void actionStarting(ServerEvent event) {
    }

    public synchronized void addServer(Server server) {
        Vector<Server> server_vect = this.servers.get(server.getServerClass().toUpperCase());
        if (server_vect == null) {
            server_vect = new Vector();
            this.servers.put(server.getServerClass().toUpperCase(), server_vect);
        }
        server_vect.addElement(server);
        server.addServerListener(this);
    }

    @Override
    public void connected(ServerEvent event) {
    }

    @Override
    public void disconnected(ServerEvent event) {
    }

    public boolean enqueueAction(Action action) {
        String server_class;
        try {
            server_class = action.getDispatch().getIdent().getString();
        }
        catch (Exception exc) {
            if (this.default_server != null) {
                this.default_server.pushAction(action);
                return true;
            }
            return false;
        }
        Vector<Server> server_vect = new Vector<Server>();
        Vector<Server> all_server_vect = this.servers.get(server_class.toUpperCase());
        if (all_server_vect == null) {
            if (this.default_server != null) {
                this.default_server.pushAction(action);
                return true;
            }
            return false;
        }
        for (int i = 0; i < all_server_vect.size(); ++i) {
            Server curr_server = all_server_vect.elementAt(i);
            if (!curr_server.isReady()) continue;
            server_vect.addElement(curr_server);
        }
        if (server_vect.size() == 0) {
            if (this.default_server != null) {
                this.default_server.pushAction(action);
                return true;
            }
            return false;
        }
        Enumeration server_list = server_vect.elements();
        int min_load = 1000000;
        Server min_server = null;
        while (server_list.hasMoreElements()) {
            Server curr_server = (Server)server_list.nextElement();
            int curr_load = curr_server.getQueueLength();
            if (curr_load == 0 && curr_server.isActive()) {
                curr_server.pushAction(action);
                return true;
            }
            if (curr_load >= min_load || !curr_server.isActive()) continue;
            min_load = curr_load;
            min_server = curr_server;
        }
        if (min_server != null) {
            min_server.pushAction(action);
        } else if (this.default_server != null) {
            this.default_server.pushAction(action);
        } else {
            ((ActionServer)server_vect.elementAt(0)).pushAction(action);
        }
        return true;
    }

    public String getActServer(String serverClass) {
        Vector<Server> serverV = this.servers.get(serverClass.toUpperCase());
        if (serverV == null || serverV.size() == 0) {
            return this.default_server.getServerClass();
        }
        return serverClass;
    }

    protected boolean isBalanced(Vector<Server> server_vect) {
        if (server_vect.size() <= 1) {
            return true;
        }
        Enumeration<Server> server_list = server_vect.elements();
        int min_load = 1000000;
        int max_load = 0;
        while (server_list.hasMoreElements()) {
            Server curr_server = server_list.nextElement();
            if (!curr_server.isActive()) continue;
            int curr_load = curr_server.getQueueLength();
            if (curr_load < min_load) {
                min_load = curr_load;
            }
            if (curr_load <= max_load) continue;
            max_load = curr_load;
        }
        return min_load != 0 || max_load <= 1;
    }

    public synchronized void setDefaultServer(Server server) {
        this.default_server = server;
    }
}

