/*
 * Decompiled with CFR 0.152.
 */
package mds.jdispatcher;

import MDSplus.Compound;
import MDSplus.Data;
import MDSplus.Dispatch;
import MDSplus.Tree;
import MDSplus.TreeNode;
import MDSplus.TreeNodeArray;
import MDSplus.TreePath;
import java.util.Hashtable;
import java.util.Vector;
import mds.jdispatcher.Action;
import mds.jdispatcher.Server;
import mds.jdispatcher.ServerListener;

class InfoServer
implements Server {
    static Tree model_database;
    String tree;
    int shot = -1;

    public static Tree getDatabase() {
        return model_database;
    }

    public InfoServer() {
        this.tree = null;
    }

    public InfoServer(String tree) {
        this.tree = tree;
    }

    @Override
    public void abort(boolean flush) {
    }

    @Override
    public boolean abortAction(Action action) {
        return false;
    }

    @Override
    public void addServerListener(ServerListener listener) {
    }

    @Override
    public void beginSequence(int shot) {
        System.out.println("InfoServer: beginSequence...");
        try {
            model_database = new Tree(this.tree, -1);
            model_database.createPulse(shot);
            System.out.println("beginSequence Tree " + this.tree + " shot " + shot + " thread " + Thread.currentThread().getName());
        }
        catch (Exception exc) {
            model_database = null;
            System.out.println("Error opening " + this.tree + " shot " + shot + ": " + exc);
        }
        System.out.println("InfoServer: beginSequence terminated");
    }

    @Override
    public synchronized Action[] collectActions() {
        Vector<Action> action_vect = new Vector<Action>();
        Hashtable<Integer, MDSplus.Action> action_table = new Hashtable<Integer, MDSplus.Action>();
        System.out.println("model_database " + model_database);
        System.out.println("Tree " + this.tree + " shot " + this.shot + " thread " + Thread.currentThread().getName());
        model_database = null;
        if (model_database == null) {
            try {
                model_database = new Tree(this.tree, this.shot);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                return null;
            }
        }
        TreeNodeArray nids = null;
        try {
            nids = model_database.getNodeWild("***", 4);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
        if (nids == null) {
            return null;
        }
        int[] nid_array = new int[nids.size()];
        int num_actions = 0;
        for (int i = 0; i < nids.size(); ++i) {
            TreeNode nid = null;
            try {
                MDSplus.Action action_data;
                nid = nids.getElementAt(i);
                System.out.println("1 - " + nid.isOn() + " Path " + nid.getFullPath());
                if (!nid.isOn() || (action_data = (MDSplus.Action)nid.getData()).getDispatch() == null || action_data.getTask() == null) continue;
                Action action = new Action(action_data, nid.getNid(), nid.getFullPath(), nid.isOn(), nid.isEssential(), null);
                action_vect.addElement(action);
                nid_array[num_actions] = nid.getNid();
                action_table.put(new Integer(nid.getNid()), action_data);
                ++num_actions;
                System.out.println("2 - " + nid);
                System.out.println();
                continue;
            }
            catch (Exception exc) {
                System.out.println(nid);
                System.out.println(exc);
            }
        }
        Object[] actions = new Action[action_vect.size()];
        action_vect.copyInto(actions);
        for (int i = 0; i < num_actions; ++i) {
            try {
                this.traverseAction((Data)((Action)actions[i]).getDispatch(), action_table);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("End collectAction()");
        return actions;
    }

    @Override
    public Action[] collectActions(String rootPath) {
        if (model_database == null) {
            try {
                model_database = new Tree(this.tree, this.shot);
            }
            catch (Exception exc) {
                return null;
            }
        }
        try {
            TreeNode rootNid = model_database.getNode(rootPath);
            TreeNode prevDef = model_database.getDefault();
            model_database.setDefault(rootNid);
            Action[] actions = this.collectActions();
            model_database.setDefault(prevDef);
            return actions;
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Override
    public void endSequence(int shot) {
        System.out.println("endSequence for shot " + shot);
        if (model_database != null) {
            try {
                model_database.close();
            }
            catch (Exception exc) {
                System.out.println("Cannot close tree " + this.tree + " Shot " + shot + ": " + exc);
            }
        }
        model_database = null;
    }

    @Override
    public int getDoingAction() {
        return 0;
    }

    @Override
    public int getQueueLength() {
        return 0;
    }

    @Override
    public String getServerClass() {
        return "INFO_PROVIDER";
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public Action popAction() {
        return null;
    }

    @Override
    public void pushAction(Action action) {
    }

    @Override
    public void setTree(String tree) {
        this.tree = tree;
    }

    @Override
    public void setTree(String tree, int shot) {
        this.tree = tree;
        this.shot = shot;
    }

    protected Data traverseAction(Data data, Hashtable<Integer, MDSplus.Action> action_table) {
        if (data instanceof TreeNode) {
            MDSplus.Action action_d;
            try {
                action_d = action_table.get(new Integer(((TreeNode)data).getNid()));
            }
            catch (Exception exc) {
                return data;
            }
            if (action_d == null) {
                return data;
            }
            return action_d;
        }
        if (data instanceof TreePath) {
            MDSplus.Action action_d;
            TreeNode nid = null;
            try {
                nid = model_database.getNode((TreePath)data);
                action_d = action_table.get(new Integer(nid.getNid()));
            }
            catch (Exception exc) {
                return data;
            }
            if (action_d == null) {
                return data;
            }
            return action_d;
        }
        if (data instanceof Dispatch) {
            Dispatch dispData = (Dispatch)data;
            dispData.setIdent(this.traverseAction(dispData.getIdent(), action_table));
            dispData.setPhase(this.traverseAction(dispData.getPhase(), action_table));
            if (dispData.getOpcode() != 2) {
                dispData.setWhen(this.traverseAction(dispData.getWhen(), action_table));
            }
            dispData.setCompletion(this.traverseAction(dispData.getCompletion(), action_table));
            return data;
        }
        if (data instanceof Compound) {
            Data[] descs = ((Compound)data).getDescs();
            for (int i = 0; i < descs.length; ++i) {
                descs[i] = this.traverseAction(descs[i], action_table);
            }
            return data;
        }
        return data;
    }
}

