/*
 * Decompiled with CFR 0.152.
 */
package mds.jdispatcher;

import MDSplus.Data;
import MDSplus.Event;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import mds.jdispatcher.ServerInfo;

class MdsHelper {
    private static final Hashtable<String, Integer> name_to_id = new Hashtable();
    private static final Hashtable<Integer, String> id_to_name = new Hashtable();
    private static final String DEFAULT_FILENAME = "jDispatcher.properties";
    static String experiment = null;
    private static String dispatcher_ip = null;
    private static int dispatcherPort = 0;
    private static Properties properties = null;
    private static final String DISPATCH_FMRT = "jDispatcher.dispatch_%d.%s";
    private static final String SERVER_FMRT = "jDispatcher.server_%d.%s";

    MdsHelper() {
    }

    public static void generateEvent(String event, int shot) {
        byte[] shotBytes = ByteBuffer.allocate(4).putInt(shot).array();
        Event.setEventRaw((String)event, (byte[])shotBytes);
    }

    static final Vector<DispatchCmd> getDispatch() {
        Vector<DispatchCmd> dispatch = new Vector<DispatchCmd>();
        int i = 1;
        while (true) {
            String name = properties.getProperty(String.format(DISPATCH_FMRT, i, "name"));
            String cmd = properties.getProperty(String.format(DISPATCH_FMRT, i, "cmd"));
            if (name == null || cmd == null) break;
            dispatch.add(new DispatchCmd(name.trim(), cmd.trim()));
            ++i;
        }
        return dispatch;
    }

    public static String getDispatcher() {
        return dispatcher_ip;
    }

    public static int getDispatcherPort() {
        return dispatcherPort;
    }

    public static String getErrorString(int status) {
        return Data.getMdsMsg((int)status);
    }

    public static Vector<ServerInfo> getServers() {
        String server_ip;
        String server_class;
        Vector<ServerInfo> servers = new Vector<ServerInfo>();
        int i = 1;
        while ((server_class = properties.getProperty(String.format(SERVER_FMRT, i, "class"))) != null && (server_ip = properties.getProperty(String.format(SERVER_FMRT, i, "address"))) != null) {
            int watchdogPort;
            String server_subtree = properties.getProperty(String.format(SERVER_FMRT, i, "subtree"));
            String javasvr = properties.getProperty(String.format(SERVER_FMRT, i, "use_jserver"));
            boolean useJavaServer = javasvr == null || javasvr.equals("true");
            try {
                watchdogPort = Integer.parseInt(properties.getProperty(String.format(SERVER_FMRT, i, "watchdog_port")));
            }
            catch (Exception exc) {
                watchdogPort = -1;
            }
            String startScript = properties.getProperty(String.format(SERVER_FMRT, i, "start_script"));
            String stopScript = properties.getProperty(String.format(SERVER_FMRT, i, "stop_script"));
            ServerInfo srvInfo = new ServerInfo(server_class, server_ip, server_subtree, useJavaServer, watchdogPort, startScript, stopScript);
            servers.add(srvInfo);
            ++i;
        }
        return servers;
    }

    static Properties initialization(String ... args) {
        block21: {
            File etc;
            String string = experiment = args.length > 0 ? args[0] : "test";
            if (args.length > 1 && !args[1].trim().isEmpty()) {
                properties = new Properties();
                try (FileInputStream stream = new FileInputStream(args[1]);){
                    properties.load(stream);
                    break block21;
                }
                catch (IOException e) {
                    System.err.println("Cannot open specified jDispatcher properties file " + args[1]);
                    return null;
                }
            }
            Vector<String> paths = new Vector<String>();
            String path = System.getenv("MDSPLUS_DIR");
            if (path != null) {
                paths.add(new File(path, "local").getPath());
            }
            if ((path = System.getProperty("user.home")) != null) {
                paths.add(new File(path, "jdispatcher").getPath());
            }
            if (!System.getProperty("os.name").startsWith("Windows") && (etc = new File("/etc/jdispatcher")).exists()) {
                paths.add(etc.getPath());
            }
            Vector<String> names = new Vector<String>();
            if (experiment != null) {
                names.add("jDispatcher_" + experiment.toLowerCase() + ".properties");
            }
            properties = MdsHelper.tryOpen(paths, names);
        }
        if (properties == null) {
            System.err.println("Cannot open jDispatcher properties files");
            return null;
        }
        int i = 1;
        while (true) {
            String phase_name = properties.getProperty("jDispatcher.phase_" + i + ".name");
            String phase_id = properties.getProperty("jDispatcher.phase_" + i + ".id");
            if (phase_name == null || phase_id == null) break;
            id_to_name.put(new Integer(phase_id), phase_name);
            name_to_id.put(phase_name, new Integer(phase_id));
            ++i;
        }
        dispatcher_ip = properties.getProperty("jDispatcher.dispatcher_ip");
        dispatcherPort = Integer.parseInt(properties.getProperty("jDispatcher.port"));
        return properties;
    }

    public static int toPhaseId(String phase_name) {
        try {
            return name_to_id.get(phase_name);
        }
        catch (Exception exc) {
            return -1;
        }
    }

    public static String toPhaseName(int phase_id) {
        return id_to_name.get(new Integer(phase_id));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final Properties tryOpen(Vector<String> paths, Vector<String> names) {
        paths.add(null);
        names.add(DEFAULT_FILENAME);
        Properties properties2 = new Properties();
        Iterator<String> iterator = names.iterator();
        block22: while (true) {
            Object properties;
            if (!iterator.hasNext()) {
                try (InputStream stream = MdsHelper.class.getClassLoader().getResourceAsStream("mds/jdispatcher/jDispatcher.properties");){
                    properties2.load(stream);
                    properties = properties2;
                    return properties;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            String name = iterator.next();
            properties = paths.iterator();
            while (true) {
                if (!properties.hasNext()) continue block22;
                String path = properties.next();
                try (FileInputStream stream2 = new FileInputStream(new File(path, name));){
                    properties2.load(stream2);
                    return properties2;
                }
                catch (IOException next) {
                    continue;
                }
                break;
            }
            break;
        }
    }

    static final class DispatchCmd {
        final String name;
        final String cmd;

        DispatchCmd(String name, String cmd) {
            this.name = name;
            this.cmd = cmd;
        }
    }
}

