/*
 * Decompiled with CFR 0.152.
 */
package mds.jdispatcher;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;
import mds.connection.ConnectionEvent;
import mds.connection.ConnectionListener;
import mds.connection.MdsMessage;

class MdsIp
implements Runnable {
    int port;
    ServerSocket server_sock;
    boolean listening = true;
    Vector<ConnectionListener> listeners = new Vector();
    Thread listen_thread;
    protected boolean stopRequest = false;
    private final Vector<ReceiverThread> receivers = new Vector();

    public static final void tryClose(AutoCloseable obj) {
        if (obj != null) {
            try {
                obj.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public MdsIp(int port) {
        this.port = port;
    }

    public synchronized void addConnectionListener(ConnectionListener listener) {
        this.listeners.addElement(listener);
    }

    protected synchronized void fireConnectionEvent() {
        Enumeration<ConnectionListener> listener_list = this.listeners.elements();
        while (listener_list.hasMoreElements()) {
            ConnectionListener listener = listener_list.nextElement();
            listener.processConnectionEvent(new ConnectionEvent((Object)this, 2000, "Lost connection to mdsip client"));
        }
    }

    public Thread getListenThread() {
        return this.listen_thread;
    }

    public MdsMessage handleMessage(MdsMessage[] messages) {
        return new MdsMessage();
    }

    @Override
    public void run() {
        while (this.listening) {
            try {
                ReceiverThread rt = new ReceiverThread(this.server_sock.accept());
                this.receivers.add(rt);
                rt.setName(String.format("Receiver(%d, %d)", this.port, rt.sock.getPort()));
                rt.setDaemon(true);
                rt.start();
            }
            catch (Exception exc) {
                this.fireConnectionEvent();
                break;
            }
        }
        MdsIp.tryClose(this.server_sock);
    }

    public boolean start() {
        try {
            this.server_sock = new ServerSocket(this.port);
        }
        catch (Exception e) {
            System.err.println("Could not listen on port: " + this.port);
            return false;
        }
        this.listen_thread = new Thread(this);
        this.listen_thread.setName(String.format("Listener(%d)", this.port));
        this.listen_thread.setDaemon(true);
        this.listen_thread.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        this.stopRequest = true;
        this.listening = false;
        MdsIp.tryClose(this.server_sock);
        this.notifyAll();
        this.listen_thread.interrupt();
        Vector<ReceiverThread> vector = this.receivers;
        synchronized (vector) {
            for (ReceiverThread recv : this.receivers) {
                recv.close();
            }
        }
    }

    class ReceiverThread
    extends Thread {
        Socket sock;
        DataInputStream dis;
        DataOutputStream dos;

        public ReceiverThread(Socket sock) {
            this.sock = sock;
            try {
                this.dis = new DataInputStream(new BufferedInputStream(sock.getInputStream()));
                this.dos = new DataOutputStream(new BufferedOutputStream(sock.getOutputStream()));
            }
            catch (Exception exc) {
                MdsIp.this.fireConnectionEvent();
                this.dis = null;
                this.dos = null;
            }
        }

        public void close() {
            MdsIp.tryClose(this.dis);
            MdsIp.tryClose(this.dos);
            MdsIp.tryClose(this.sock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.dis == null || this.dos == null) {
                    return;
                }
                MdsMessage msg = new MdsMessage(0, 0, 0, null, new byte[0]);
                try {
                    msg.Receive((InputStream)this.dis);
                    new MdsMessage().Send(this.dos);
                }
                catch (Exception exc) {
                    MdsIp.this.fireConnectionEvent();
                    Vector vector = MdsIp.this.receivers;
                    synchronized (vector) {
                        MdsIp.this.receivers.remove(this);
                        if (MdsIp.this.receivers.isEmpty()) {
                            MdsIp.this.receivers.notifyAll();
                        }
                    }
                    return;
                }
                while (!MdsIp.this.stopRequest) {
                    try {
                        MdsMessage curr_msg = new MdsMessage(0, 0, 0, null, new byte[0]);
                        curr_msg.Receive((InputStream)this.dis);
                        MdsMessage[] messages = new MdsMessage[curr_msg.nargs];
                        messages[0] = curr_msg;
                        byte nargs = curr_msg.nargs;
                        for (int i = 0; i < nargs - 1; ++i) {
                            messages[i + 1] = new MdsMessage(0, 0, 0, null, new byte[0]);
                            messages[i + 1].Receive((InputStream)this.dis);
                        }
                        MdsMessage answ = MdsIp.this.handleMessage(messages);
                        answ.Send(this.dos);
                    }
                    catch (Exception exc) {
                        MdsIp.this.fireConnectionEvent();
                        break;
                    }
                }
            }
            finally {
                Vector vector = MdsIp.this.receivers;
                synchronized (vector) {
                    MdsIp.this.receivers.remove(this);
                    if (MdsIp.this.receivers.isEmpty()) {
                        MdsIp.this.receivers.notifyAll();
                    }
                }
            }
        }
    }
}

