/*
 * Decompiled with CFR 0.152.
 */
package mds.jdispatcher;

import java.io.BufferedOutputStream;
import java.net.Socket;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Vector;
import mds.connection.Descriptor;
import mds.connection.MdsMessage;
import mds.jdispatcher.Action;
import mds.jdispatcher.MdsHelper;
import mds.jdispatcher.MdsIp;
import mds.jdispatcher.MdsMonitorEvent;
import mds.jdispatcher.MonitorEvent;
import mds.jdispatcher.MonitorListener;

class MdsMonitor
extends MdsIp
implements MonitorListener,
Runnable {
    private final Vector<BufferedOutputStream> streams = new Vector();
    private final Vector<Socket> sockets = new Vector();
    private final Queue<MdsMonitorEvent> msgs = new LinkedList<MdsMonitorEvent>();

    private static final short toShort(byte b) {
        return (short)(b & 0xFF);
    }

    public MdsMonitor(int port) {
        super(port);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    MdsMonitor.this.sendMessages();
                }
                finally {
                    for (Socket sock : MdsMonitor.this.sockets) {
                        MdsIp.tryClose(sock);
                    }
                }
            }
        }).start();
    }

    @Override
    public synchronized void beginSequence(MonitorEvent event) {
        this.communicate(event, 1);
    }

    @Override
    public void build(MonitorEvent event) {
        this.communicate(event, 3);
    }

    @Override
    public void buildBegin(MonitorEvent event) {
        this.communicate(event, 2);
    }

    @Override
    public void buildEnd(MonitorEvent event) {
        this.communicate(event, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void communicate(MonitorEvent event, int mode) {
        try {
            MdsMonitorEvent mds_event = null;
            if (event.action == null) {
                int currMode = 0;
                switch (event.eventId) {
                    case 3: {
                        currMode = 12;
                        mds_event = new MdsMonitorEvent(this, null, 0, 0, 0, null, 1, currMode, null, event.getMessage(), 1);
                        break;
                    }
                    case 2: {
                        currMode = 13;
                        mds_event = new MdsMonitorEvent(this, null, 0, 0, 0, null, 1, currMode, null, event.getMessage(), 1);
                        break;
                    }
                    case 5: {
                        currMode = 10;
                        mds_event = new MdsMonitorEvent(this, event.getTree(), event.getShot(), MdsHelper.toPhaseId(event.getPhase()), 0, null, 1, currMode, null, null, 1);
                        break;
                    }
                    case 4: {
                        currMode = 9;
                        mds_event = new MdsMonitorEvent(this, event.getTree(), event.getShot(), MdsHelper.toPhaseId(event.getPhase()), 0, null, 1, currMode, null, null, 1);
                        break;
                    }
                    default: {
                        mds_event = new MdsMonitorEvent(this, event.getTree(), event.getShot(), 0, 0, null, 1, mode, null, null, 1);
                        break;
                    }
                }
            } else {
                Action action = event.getAction();
                mds_event = new MdsMonitorEvent(this, event.getTree(), event.getShot(), MdsHelper.toPhaseId(event.getPhase()), action.getNid(), action.getName(), action.isOn() ? 1 : 0, mode, action.getDispatch().getIdent().getString(), action.getServerAddress(), action.getStatus());
            }
            MdsMonitor mdsMonitor = this;
            synchronized (mdsMonitor) {
                this.msgs.add(mds_event);
                this.notify();
            }
        }
        catch (Exception exc) {
            System.out.println(exc);
        }
    }

    @Override
    public void connect(MonitorEvent event) {
        this.communicate(event, 3);
    }

    @Override
    public void disconnect(MonitorEvent event) {
        this.communicate(event, 2);
    }

    @Override
    public void dispatched(MonitorEvent event) {
        this.communicate(event, 6);
    }

    @Override
    public void doing(MonitorEvent event) {
        this.communicate(event, 7);
    }

    @Override
    public void done(MonitorEvent event) {
        this.communicate(event, 8);
    }

    @Override
    public void endPhase(MonitorEvent event) {
        this.communicate(event, 4);
    }

    @Override
    public synchronized void endSequence(MonitorEvent event) {
        this.communicate(event, 11);
    }

    @Override
    public MdsMessage handleMessage(MdsMessage[] messages) {
        if (messages.length < 6 || messages[2].dtype != 7 || messages[1].dtype != 6) {
            System.err.println("Unexpected message has been received by MdsMonitor");
        } else {
            try {
                short port = messages[2].ToShortArray()[0];
                String addr = "" + MdsMonitor.toShort(messages[1].body[0]) + "." + MdsMonitor.toShort(messages[1].body[1]) + "." + MdsMonitor.toShort(messages[1].body[2]) + "." + MdsMonitor.toShort(messages[1].body[3]);
                Socket sock = new Socket(addr, (int)port);
                this.sockets.add(sock);
                this.streams.add(new BufferedOutputStream(sock.getOutputStream()));
            }
            catch (Exception port) {
                // empty catch block
            }
        }
        MdsMessage msg = new MdsMessage(0, 8, 0, null, Descriptor.dataToByteArray((Object)new Integer(1)));
        msg.status = 1;
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessages() {
        while (true) {
            MdsMonitor mdsMonitor = this;
            synchronized (mdsMonitor) {
                try {
                    while (!this.msgs.isEmpty()) {
                        byte[] msg = this.msgs.remove().toBytes();
                        for (BufferedOutputStream stream : this.streams) {
                            try {
                                stream.write(msg);
                                stream.flush();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                catch (Exception exc) {
                    System.out.println("UNEXPECTED EXCPETION ORA");
                }
            }
            try {
                mdsMonitor = this;
                synchronized (mdsMonitor) {
                    this.wait();
                }
            }
            catch (InterruptedException exc) {
                return;
            }
        }
    }

    @Override
    public void startPhase(MonitorEvent event) {
        this.communicate(event, 5);
    }
}

