/*
 * Decompiled with CFR 0.152.
 */
package mds.jdispatcher;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.StringTokenizer;
import mds.jdispatcher.MdsHelper;
import mds.jdispatcher.MdsServerEvent;

class MdsMonitorEvent
extends MdsServerEvent {
    private static final long serialVersionUID = 1L;
    static final int MonitorBeginSequence = 1;
    static final int MonitorBuildBegin = 2;
    static final int MonitorBuild = 3;
    static final int MonitorBuildEnd = 4;
    static final int MonitorCheckin = 5;
    static final int MonitorDispatched = 6;
    static final int MonitorDoing = 7;
    static final int MonitorDone = 8;
    static final int MonitorEndPhase = 9;
    static final int MonitorStartPhase = 10;
    static final int MonitorEndSequence = 11;
    static final int MonitorServerConnected = 12;
    static final int MonitorServerDisconnected = 13;
    String tree;
    long shot;
    int phase;
    int nid;
    String name;
    int on;
    int mode;
    String server;
    String server_address;
    int ret_status;
    String node_path;
    Date date;
    String date_st;
    String error_message;
    long execution_time;

    public static String msecToString(long msec) {
        int min = (int)((double)msec / 60000.0);
        int sec = (int)((double)(msec -= (long)(min * 60000)) / 1000.0);
        DecimalFormat df = new DecimalFormat("#00");
        DecimalFormat df1 = new DecimalFormat("#000");
        return df.format(min) + "." + df.format(sec) + "." + df1.format(msec -= (long)(sec * 1000));
    }

    public MdsMonitorEvent(Object source, int id, int flags, int status, String data) throws Exception {
        super(source, id, flags, status);
        this.date = new Date();
        try {
            StringTokenizer buf = new StringTokenizer(data);
            this.tree = new String(buf.nextToken());
            if (buf.hasMoreTokens()) {
                this.shot = Long.decode(buf.nextToken()).intValue();
            }
            if (buf.hasMoreTokens()) {
                this.phase = Integer.decode(buf.nextToken());
            }
            if (buf.hasMoreTokens()) {
                this.nid = Integer.decode(buf.nextToken());
            }
            if (buf.hasMoreTokens()) {
                this.on = Integer.decode(buf.nextToken());
            }
            if (buf.hasMoreTokens()) {
                this.mode = Integer.decode(buf.nextToken());
            }
            if (buf.hasMoreTokens()) {
                this.server = new String(buf.nextToken());
            }
            if (buf.hasMoreTokens()) {
                this.server_address = new String(buf.nextToken());
            }
            if (buf.hasMoreTokens()) {
                this.ret_status = Integer.decode(buf.nextToken());
            }
            if (buf.hasMoreTokens()) {
                this.node_path = new String(buf.nextToken());
            }
            if (buf.hasMoreTokens()) {
                this.date_st = new String(buf.nextToken(";"));
            }
            if (buf.hasMoreTokens()) {
                this.error_message = new String(buf.nextToken(""));
                this.error_message = this.error_message.substring(1, this.error_message.length());
            }
        }
        catch (NumberFormatException e) {
            System.out.println(data);
            e.printStackTrace();
            throw new Exception("Bad monitor event data" + e);
        }
    }

    public MdsMonitorEvent(Object obj, int phase, int nid, String msg) {
        super(obj, 0, 0, 1);
        this.tree = null;
        this.shot = 0L;
        this.phase = phase;
        this.nid = nid;
        this.error_message = msg;
    }

    public MdsMonitorEvent(Object obj, int mode, String msg) {
        super(obj, 0, 0, 1);
        this.mode = mode;
        this.error_message = msg;
    }

    public MdsMonitorEvent(Object obj, String tree, int shot, int phase, int nid, String name, int on, int mode, String server, String server_address, int ret_status) {
        super(obj, 0, 0, 1);
        this.tree = tree;
        this.shot = shot;
        this.phase = phase;
        this.nid = nid;
        this.name = name;
        this.on = on;
        this.mode = mode;
        this.server = server;
        this.server_address = server_address;
        this.ret_status = ret_status;
        this.error_message = MdsHelper.getErrorString(ret_status);
        this.date_st = new Date().toString();
    }

    private String getMode(int mode_id) {
        switch (mode_id) {
            case 1: {
                return "MonitorBeginSequence";
            }
            case 2: {
                return "MonitorBuildBegin";
            }
            case 3: {
                return "MonitorBuild";
            }
            case 4: {
                return "MonitorBuildEnd";
            }
            case 5: {
                return "MonitorCheckin";
            }
            case 6: {
                return "MonitorDispatched";
            }
            case 7: {
                return "MonitorDoing";
            }
            case 8: {
                return "MonitorDone";
            }
            case 12: {
                return "MonitorServerConnected";
            }
            case 13: {
                return "MonitorServerDisconnected";
            }
            case 9: {
                return "MonitorEndPhase";
            }
            case 10: {
                return "MonitorStartPhase";
            }
            case 11: {
                return "MonitorEndSequence";
            }
        }
        return "";
    }

    public synchronized String getMonitorString() {
        StringBuffer out = new StringBuffer();
        if (this.mode == 8) {
            out.append("[" + MdsMonitorEvent.msecToString(this.execution_time) + "] " + this.date_st + ", ");
        } else {
            out.append(this.date_st + ", ");
        }
        switch (this.mode) {
            case 2: 
            case 3: 
            case 4: {
                String on_off = this.on == 1 ? "ON" : "OFF";
                out.append(" Action " + on_off + " node " + this.node_path);
                break;
            }
            case 6: {
                out.append(" Dispatching node " + this.node_path + "(" + this.nid + ") to " + this.server);
                break;
            }
            case 7: {
                out.append(" Doing " + this.node_path + " in " + this.tree + " shot " + this.shot + " on " + this.server);
                break;
            }
            case 8: {
                if ((this.ret_status & 1) == 1) {
                    out.append(" Done " + this.node_path + " in " + this.tree + " shot " + this.shot + " status " + this.ret_status + " on " + this.server);
                    break;
                }
                out.append(" Failed " + this.node_path + " in " + this.tree + " shot " + this.shot + " status " + this.ret_status + " on " + this.server + " " + this.error_message);
            }
        }
        return out.toString().trim();
    }

    public synchronized byte[] toBytes() {
        String out_st = this.tree + " " + this.shot + " " + this.phase + " " + this.nid + " " + this.on + " " + this.mode + " " + this.server + " " + this.server_address + " " + this.ret_status + " " + this.name + " " + this.date_st + " ; " + this.error_message;
        byte[] msg = out_st.getBytes();
        String head_st = "" + this.jobid + " " + this.flags + " " + this.status + " " + msg.length;
        byte[] headmsg = head_st.getBytes();
        byte[] outmsg = new byte[60 + msg.length];
        System.arraycopy(headmsg, 0, outmsg, 0, headmsg.length);
        System.arraycopy(msg, 0, outmsg, 60, msg.length);
        return outmsg;
    }

    @Override
    public synchronized String toString() {
        return "[exp=" + this.tree + "; shot=" + this.shot + "; phase=" + this.phase + "; nid=" + this.nid + "; on=" + this.on + "; mode= " + this.getMode(this.mode) + "; server=" + this.server + "; ServerAddress=" + this.server_address + "; status=" + this.ret_status + "]";
    }
}

