/*
 * Decompiled with CFR 0.152.
 */
package mds.jdispatcher;

import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import mds.connection.ConnectionEvent;
import mds.connection.Descriptor;
import mds.connection.MdsConnection;
import mds.jdispatcher.AsyncMdsConnection;
import mds.jdispatcher.MdsMonitorEvent;
import mds.jdispatcher.MdsServerEvent;
import mds.jdispatcher.MdsServerListener;

class MdsServer
extends AsyncMdsConnection {
    static final int SrvNoop = 0;
    static final int SrvAbort = 1;
    static final int SrvAction = 2;
    static final int SrvClose = 3;
    static final int SrvCreatePulse = 4;
    static final int SrvSetLogging = 5;
    static final int SrvCommand = 6;
    static final int SrvMonitor = 7;
    static final int SrvShow = 8;
    static final int SrvStop = 9;
    static final int SrvRemoveLast = 10;
    static final int SrvWatchdogPort = 11;
    static final int SrvJobBEFORE_NOTIFY = 1;
    static final int SrvJobAFTER_NOTIFY = 2;
    static final int ServerABORT = 266436658;
    static final short START_PORT = 8800;
    static final int WATCHDOG_PERIOD = 5000;
    static final int WATCHDOG_TIMEOUT = 20000;
    private ServerSocket rcv_sock;
    protected Socket read_sock = null;
    public short rcv_port;
    protected boolean rcv_connected = false;
    private final Vector<MdsServerListener> server_event_listener = new Vector();
    private final Vector<Socket> curr_listen_sock = new Vector();
    private boolean useJavaServer = true;
    private final byte[] self_address;
    private int watchdogPort = -1;

    static void main(String[] arg) {
        MdsServer ms = null;
        try {
            ms = new MdsServer("150.178.3.47:8001", true, -1);
            ms.monitorCheckin();
            Frame f = new Frame();
            f.setVisible(true);
        }
        catch (IOException e) {
            System.out.println("" + e);
        }
    }

    public MdsServer(String server, boolean useJavaServer, int watchdogPort) throws IOException {
        super(server);
        this.useJavaServer = useJavaServer;
        this.watchdogPort = watchdogPort;
        this.self_address = InetAddress.getLocalHost().getAddress();
        if (this.ConnectToMds(false) == 0) {
            throw new IOException(this.error);
        }
        this.startReceiver();
    }

    public Descriptor abort(boolean do_flush) throws IOException {
        int[] flush = new int[]{do_flush ? 1 : 0};
        Vector<Descriptor> args = new Vector<Descriptor>();
        args.add(new Descriptor(null, flush));
        Descriptor reply = this.sendMessage(0, 1, args, true);
        return reply;
    }

    public void addMdsServerListener(MdsServerListener l) {
        if (l != null) {
            this.server_event_listener.addElement(l);
        }
    }

    public Descriptor closeTrees() throws IOException {
        Descriptor reply = this.sendMessage(0, 3, null, true);
        return reply;
    }

    public synchronized int ConnectToMds(boolean use_compression) {
        int status = super.ConnectToMds(use_compression);
        if (this.watchdogPort > 0 && status != 0) {
            try {
                this.setWatchdogPort(this.watchdogPort);
            }
            catch (Exception exc) {
                System.err.println("Error setting watchdog port: " + exc);
            }
            this.startWatchdog(this.host, this.watchdogPort);
        }
        return status;
    }

    private void createPort(short start_port) throws IOException {
        boolean found = false;
        int tries = 0;
        while (!found) {
            for (tries = 0; this.rcv_sock == null && tries < 500; tries = (int)((short)(tries + 1))) {
                try {
                    this.rcv_port = (short)(start_port + tries);
                    this.rcv_sock = new ServerSocket(this.rcv_port);
                    continue;
                }
                catch (IOException e) {
                    this.rcv_sock = null;
                }
            }
            if (tries == 500) {
                throw new IOException("Can't create receive port");
            }
            found = true;
        }
    }

    public Descriptor createPulse(String tree, int shot) throws IOException {
        Vector<Descriptor> args = new Vector<Descriptor>();
        args.add(new Descriptor(null, tree));
        args.add(new Descriptor(null, new int[]{shot}));
        Descriptor reply = this.sendMessage(0, 4, args, true);
        return reply;
    }

    public Descriptor dispatchAction(String tree, int shot, String name, int id) throws IOException {
        Vector<Descriptor> args = new Vector<Descriptor>();
        args.add(new Descriptor(null, tree));
        args.add(new Descriptor(null, new int[]{shot}));
        if (this.useJavaServer) {
            args.add(new Descriptor(null, name));
        } else {
            args.add(new Descriptor(null, new int[]{id}));
        }
        Descriptor reply = this.sendMessage(id, 2, true, args, true);
        return reply;
    }

    public Descriptor dispatchCommand(String cli, String command) throws IOException {
        Vector<Descriptor> args = new Vector<Descriptor>();
        args.add(new Descriptor(null, cli));
        args.add(new Descriptor(null, command));
        Descriptor reply = this.sendMessage(0, 6, args, true);
        return reply;
    }

    public Descriptor dispatchDirectCommand(String command) throws IOException {
        Descriptor reply = this.MdsValue(command, new Descriptor[0]);
        return reply;
    }

    protected void dispatchMdsServerEvent(MdsServerEvent e) {
        Enumeration<MdsServerListener> elements = this.server_event_listener.elements();
        try {
            while (true) {
                elements.nextElement().processMdsServerEvent(e);
            }
        }
        catch (NoSuchElementException done) {
            return;
        }
    }

    protected void finalize() {
        this.shutdown();
    }

    public String getFullPath(String tree, int shot, int nid) {
        Descriptor out = this.MdsValue("JavaGetFullPath", new Descriptor[]{new Descriptor(null, tree), new Descriptor(null, new int[]{shot}), new Descriptor(null, new int[]{nid})});
        if (out.error != null) {
            return "<Path evaluation error>";
        }
        return out.strdata;
    }

    public Descriptor monitorCheckin() throws IOException {
        String cmd = "";
        Vector<Descriptor> args = new Vector<Descriptor>();
        args.add(new Descriptor(null, new int[]{0}));
        args.add(new Descriptor(null, new int[]{0}));
        args.add(new Descriptor(null, new int[]{0}));
        args.add(new Descriptor(null, new int[]{0}));
        args.add(new Descriptor(null, new int[]{5}));
        args.add(new Descriptor(null, ""));
        args.add(new Descriptor(null, new int[]{0}));
        Descriptor reply = this.sendMessage(0, 7, args, true);
        return reply;
    }

    public Descriptor removeLast() throws IOException {
        Descriptor reply = this.sendMessage(0, 10, null, true);
        return reply;
    }

    public void removeMdsServerListener(MdsServerListener l) {
        if (l != null) {
            this.server_event_listener.removeElement(l);
        }
    }

    public Descriptor sendMessage(int id, int op, boolean before_notify, Vector<Descriptor> args, boolean wait) throws IOException {
        int flags;
        String cmd = new String("ServerQAction");
        int n = flags = before_notify ? 1 : 2;
        if (args == null) {
            args = new Vector();
        }
        args.add(0, new Descriptor(null, new int[]{id}));
        args.add(0, new Descriptor(null, new int[]{flags}));
        args.add(0, new Descriptor(null, new int[]{op}));
        args.add(0, new Descriptor(null, new short[]{this.rcv_port}));
        args.add(0, new Descriptor(null, this.self_address));
        Descriptor out = this.MdsValue(cmd, args, wait);
        if (out.error != null) {
            throw new IOException(out.error);
        }
        return out;
    }

    public Descriptor sendMessage(int id, int op, Vector<Descriptor> args, boolean wait) throws IOException {
        return this.sendMessage(id, op, false, args, wait);
    }

    public Descriptor setLogging(byte logging_mode) throws IOException {
        byte[] data = new byte[]{logging_mode};
        Vector<Descriptor> args = new Vector<Descriptor>();
        args.add(new Descriptor(null, data));
        Descriptor reply = this.sendMessage(0, 5, args, true);
        return reply;
    }

    public Descriptor setWatchdogPort(int port) throws IOException {
        Vector<Descriptor> args = new Vector<Descriptor>();
        args.add(new Descriptor(null, new int[]{port}));
        Descriptor reply = this.sendMessage(0, 11, true, args, true);
        return reply;
    }

    public void shutdown() {
        this.server_event_listener.removeAllElements();
        MdsServer.tryClose((Object)this.rcv_sock);
        MdsServer.tryClose((Object)this.read_sock);
        Enumeration<Socket> elements = this.curr_listen_sock.elements();
        try {
            while (true) {
                MdsServer.tryClose((Object)elements.nextElement());
            }
        }
        catch (NoSuchElementException done) {
            this.curr_listen_sock.removeAllElements();
            this.QuitFromMds();
            return;
        }
    }

    private void startReceiver() throws IOException {
        if (this.rcv_port == 0) {
            this.createPort((short)8800);
        }
        ListenServerConnection listen_server_con = new ListenServerConnection();
        listen_server_con.start();
    }

    void startWatchdog(String host, int port) {
        new WatchdogHandler(host, port).start();
    }

    public Descriptor stop() throws IOException {
        Descriptor reply = this.sendMessage(0, 9, null, true);
        return reply;
    }

    class WatchdogHandler
    extends Thread {
        DataInputStream dis;
        DataOutputStream dos;
        Socket watchdogSock;

        WatchdogHandler(String host, int port) {
            try {
                this.watchdogSock = new Socket(host, port);
                this.dis = new DataInputStream(this.watchdogSock.getInputStream());
                this.dos = new DataOutputStream(this.watchdogSock.getOutputStream());
            }
            catch (Exception exc) {
                System.err.println("Error starting Watchdog: " + exc);
            }
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Timer timer = new Timer();
                    timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            System.out.println("Detected server TIMEOUT");
                            MdsConnection.tryClose((Object)MdsServer.this.sock);
                            MdsConnection.tryClose((Object)WatchdogHandler.this.watchdogSock);
                            MdsConnection.tryClose((Object)MdsServer.this.read_sock);
                            MdsConnection.tryClose((Object)MdsServer.this.rcv_sock);
                            ConnectionEvent ce = new ConnectionEvent((Object)this, 2000, "Lost connection from : " + MdsServer.this.provider);
                            MdsServer.this.dispatchConnectionEvent(ce);
                        }
                    }, 20000L);
                    this.dos.writeInt(1);
                    this.dos.flush();
                    this.dis.readInt();
                    timer.cancel();
                    Thread.currentThread();
                    Thread.sleep(5000L);
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    class ReceiveServerMessage
    extends Thread {
        DataInputStream dis;
        Socket s;
        boolean connected = true;

        public ReceiveServerMessage(Socket s) {
            this.s = s;
        }

        @Override
        public void run() {
            try {
                MdsServerEvent se = null;
                byte[] header = new byte[60];
                DataInputStream dis = new DataInputStream(new BufferedInputStream(this.s.getInputStream()));
                while (true) {
                    dis.readFully(header);
                    String head = new String(header);
                    StringTokenizer buf = new StringTokenizer(head, " \u0000");
                    int id = 0;
                    int flags = 0;
                    int status = 0;
                    try {
                        try {
                            id = Integer.decode(buf.nextToken());
                        }
                        catch (Exception exc) {
                            id = 0;
                        }
                        try {
                            flags = Integer.decode(buf.nextToken());
                        }
                        catch (Exception exc) {
                            flags = 0;
                        }
                        try {
                            status = Integer.decode(buf.nextToken());
                        }
                        catch (Exception exc) {
                            status = 0;
                        }
                        int msg_len = 0;
                        try {
                            msg_len = Integer.decode(buf.nextToken());
                        }
                        catch (Exception exc) {
                            msg_len = 0;
                        }
                        if (msg_len > 10000) {
                            System.err.println("WRONG MESSAGE LENGTH msg_len: " + msg_len);
                            System.err.println("for message: " + head);
                            msg_len = 0;
                        }
                        if (msg_len > 0) {
                            byte[] msg = new byte[msg_len];
                            dis.readFully(msg);
                            se = new MdsMonitorEvent(this, id, flags, status, new String(msg));
                        } else {
                            se = new MdsServerEvent(this, id, flags, status);
                        }
                        MdsServer.this.dispatchMdsServerEvent(se);
                    }
                    catch (Exception e) {
                        System.out.println("Bad Message " + head);
                        e.printStackTrace();
                        se = new MdsServerEvent(this, id, flags, status);
                        MdsServer.this.dispatchMdsServerEvent(se);
                    }
                }
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    class ListenServerConnection
    extends Thread {
        ListenServerConnection() {
        }

        @Override
        public void run() {
            try {
                MdsServer.this.read_sock = MdsServer.this.rcv_sock.accept();
                MdsServer.this.rcv_connected = true;
                MdsServer.this.curr_listen_sock.add(MdsServer.this.read_sock);
                System.out.println("Receive connection from server " + MdsServer.this.provider);
                ReceiveServerMessage rec_srv_msg = new ReceiveServerMessage(MdsServer.this.read_sock);
                rec_srv_msg.start();
            }
            catch (IOException e) {
                MdsServer.this.rcv_connected = false;
            }
        }
    }
}

