/*
 * Decompiled with CFR 0.152.
 */
package mds.jdispatcher;

import java.io.IOException;
import javax.swing.JButton;
import mds.jdispatcher.MdsMonitorEvent;
import mds.jdispatcher.jServer;

public class ServerInfo {
    private final String className;
    private final String address;
    private final String subTree;
    private final boolean isJava;
    private final int watchdogPort;
    private final String startScript;
    private final String stopScript;
    private MdsMonitorEvent monitorEvent;
    private int pos;
    boolean killed = false;
    private jServer server;
    private boolean active = false;

    private static void startServer(ServerInfo si) {
        try {
            if (si.server != null) {
                return;
            }
            if (si.getStartScript() != null) {
                Runtime.getRuntime().exec(si.getStartScript());
            } else if (si.address.startsWith("localhost:")) {
                int port = Integer.valueOf(si.address.substring(10));
                si.server = new jServer(port);
                si.server.start();
            }
        }
        catch (IOException exc) {
            System.out.println("Start " + exc);
        }
    }

    public ServerInfo(String className, String address, String subTree, boolean isJava, int watchdogPort, String startScript, String stopScript) {
        this.className = className;
        this.address = address;
        this.subTree = subTree;
        this.isJava = isJava;
        this.watchdogPort = watchdogPort;
        this.startScript = startScript;
        this.stopScript = stopScript;
    }

    public MdsMonitorEvent getAction() {
        return this.monitorEvent;
    }

    public String getAddress() {
        return this.address;
    }

    public Object[] getAsArray() {
        Object[] out = new Object[6];
        out[0] = new Boolean(this.active);
        out[1] = this.className;
        out[2] = this.address;
        out[3] = this.monitorEvent;
        return out;
    }

    public String getClassName() {
        return this.className;
    }

    public int getPos() {
        return this.pos;
    }

    public String getStartScript() {
        return this.startScript;
    }

    public String getStopScript() {
        return this.stopScript;
    }

    public String getSubTree() {
        return this.subTree;
    }

    public int getWarchdogPort() {
        return this.watchdogPort;
    }

    public boolean isActive() {
        return this.isJava;
    }

    public boolean isJava() {
        return this.isJava;
    }

    public void setAction(MdsMonitorEvent monitorEvent) {
        this.monitorEvent = monitorEvent;
    }

    public void setActive(boolean active) {
        if (this.killed && active) {
            this.killed = false;
        }
        this.active = active;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public void startServer() {
        ServerInfo.startServer(this);
    }

    public void stopServer() {
        this.stopServer(this);
    }

    public void stopServer(ServerInfo si) {
        try {
            if (si.server != null) {
                si.server.stop();
                si.server = null;
                si.killed = true;
            } else if (si.getStopScript() != null) {
                Runtime.getRuntime().exec(si.getStopScript());
            }
        }
        catch (IOException exc) {
            System.out.println("Stop " + exc);
        }
    }

    public String toString() {
        return "Class :" + this.className + "\nAddress : " + this.address + "\nSub Tree : " + this.subTree + "\nJava Server : " + this.isJava + "\nWatchdog port  : " + this.watchdogPort + "\nStart Script : " + this.startScript + "\nStop  Script : " + this.stopScript + "\n";
    }

    public class TableButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        private final ServerInfo serverInfo;

        public TableButton(String label, ServerInfo serverInfo) {
            super(label);
            this.serverInfo = serverInfo;
        }

        public ServerInfo getInfo() {
            return this.serverInfo;
        }

        @Override
        public String toString() {
            return "Class " + this.serverInfo.className + " Address " + this.serverInfo.address;
        }
    }
}

