/*
 * Decompiled with CFR 0.152.
 */
package mds.jdispatcher;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import mds.jdispatcher.ServerInfo;

public class ServerShowDialog
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String address;
    private int info_port;
    private Hashtable<String, ServerInfo> serversInfo = null;
    private JButton jButton1;
    private JButton jButton2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JButton killAllServer;
    private JButton startAllServer;

    public ServerShowDialog(Frame parent, boolean modal) {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.startAllServer = new JButton("Start All");
        this.killAllServer = new JButton("Kill All");
        this.jButton2 = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButton1.setText("Update");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerShowDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton1);
        this.startAllServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerShowDialog.this.startAllServerActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.startAllServer);
        this.killAllServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerShowDialog.this.killAllServerActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.killAllServer);
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerShowDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton2);
        this.add((Component)this.jPanel1, "Last");
        this.jPanel2.setLayout(new BorderLayout());
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"State", "Class Name", "Address", "Start", "Stop"}){
            private static final long serialVersionUID = 1L;
            private final boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true, true, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.addMouseListener(new JTableButtonMouseListener(this.jTable1));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jTable1.getColumnModel().getColumn(0).setMinWidth(50);
        this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.jTable1.getColumnModel().getColumn(0).setMaxWidth(50);
        this.jTable1.getColumnModel().getColumn(0).setCellRenderer(new StateRenderer());
        this.jTable1.getColumnModel().getColumn(3).setCellEditor(null);
        this.jTable1.getColumnModel().getColumn(3).setCellRenderer(new ButtonRenderer());
        this.jTable1.getColumnModel().getColumn(4).setCellRenderer(new ButtonRenderer());
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.jPanel2, "Center");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.updateServerState();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void killAllServerActionPerformed(ActionEvent evt) {
        Iterator<ServerInfo> i = this.serversInfo.values().iterator();
        while (i.hasNext()) {
            i.next().stopServer();
        }
    }

    public void loadServerState(String address, int info_port) throws Exception {
        this.address = address;
        this.info_port = info_port;
        Socket s = new Socket(address, info_port);
        s.setSoTimeout(500);
        DataOutputStream dos = new DataOutputStream(s.getOutputStream());
        DataInputStream dis = new DataInputStream(s.getInputStream());
        dos.writeUTF("servers");
        int numServer = dis.readInt();
        for (int i = 0; i < numServer; ++i) {
            int j;
            String serverClass = dis.readUTF();
            String addressSrv = dis.readUTF();
            boolean active = dis.readBoolean();
            int aDoing = dis.readInt();
            System.out.println("Class :" + serverClass + "Server :" + addressSrv + " doing " + aDoing);
            if (this.serversInfo == null || addressSrv == null || addressSrv.length() == 0) continue;
            DefaultTableModel md = (DefaultTableModel)this.jTable1.getModel();
            ServerInfo si = this.serversInfo.get(addressSrv);
            si.setActive(active);
            int numRow = md.getRowCount();
            for (j = 0; j < numRow; ++j) {
                Object o = md.getValueAt(j, 2);
                if (o == null || !o.equals(addressSrv)) continue;
                md.setValueAt(new Boolean(active), j, 0);
                break;
            }
            if (j != numRow) continue;
            md.addRow(si.getAsArray());
        }
        s.close();
    }

    public void setServersInfo(Hashtable<String, ServerInfo> serversInfo) {
        this.serversInfo = serversInfo;
    }

    private void startAllServerActionPerformed(ActionEvent evt) {
        Iterator<ServerInfo> i = this.serversInfo.values().iterator();
        while (i.hasNext()) {
            i.next().startServer();
        }
    }

    public void updateServerState() {
        try {
            this.loadServerState(this.address, this.info_port);
        }
        catch (Exception exc) {
            ShowMessage alert = new ShowMessage(exc.getMessage());
            SwingUtilities.invokeLater(alert);
        }
    }

    public class StateRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                if (b.booleanValue()) {
                    this.setBackground(Color.GREEN);
                } else {
                    this.setBackground(Color.RED);
                }
            }
            return this;
        }
    }

    class ShowMessage
    implements Runnable {
        String msg;

        public ShowMessage(String msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            JOptionPane.showMessageDialog(null, this.msg, "alert", 0);
        }
    }

    class JTableButtonMouseListener
    implements MouseListener {
        private final JTable table;

        public JTableButtonMouseListener(JTable table) {
            this.table = table;
        }

        private void forwardEventToButton(MouseEvent e) {
            TableColumnModel columnModel = this.table.getColumnModel();
            int column = columnModel.getColumnIndexAtX(e.getX());
            int row = e.getY() / this.table.getRowHeight();
            if (row >= this.table.getRowCount() || row < 0 || column >= this.table.getColumnCount() || column < 0) {
                return;
            }
            Object value = this.table.getValueAt(row, column);
            if (!(value instanceof JButton)) {
                return;
            }
            JButton button = (JButton)value;
            MouseEvent buttonEvent = SwingUtilities.convertMouseEvent(this.table, e, button);
            button.dispatchEvent(buttonEvent);
            this.table.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.forwardEventToButton(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.forwardEventToButton(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.forwardEventToButton(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.forwardEventToButton(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.forwardEventToButton(e);
        }
    }

    public class ButtonRenderer
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (Component)value;
        }
    }
}

