/*
 * Decompiled with CFR 0.152.
 */
package mds.jdispatcher;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import mds.jdispatcher.MdsMonitorEvent;
import mds.jdispatcher.ServerInfo;

public class ServersInfoPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String address;
    private int info_port;
    private Hashtable<String, ServerInfo> serversInfo = null;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JButton killAllServer;
    private JPopupMenu serverActionPopup;
    private JButton startAllServer;
    private JMenuItem startServer;
    private JMenuItem stopServer;
    private JButton update;

    public ServersInfoPanel() {
        this.initComponents();
        this.jTable1.setComponentPopupMenu(this.serverActionPopup);
    }

    public boolean checkInfoServer(String address, int info_port) {
        return this.address != null && address.equals(this.address) && info_port == this.info_port;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.serverActionPopup = new JPopupMenu();
        this.jPanel1 = new JPanel();
        this.update = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.startServer = new JMenuItem("Start");
        this.startServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableModel tm = ServersInfoPanel.this.jTable1.getModel();
                for (int i : ServersInfoPanel.this.jTable1.getSelectedRows()) {
                    String s = (String)tm.getValueAt(i, 2);
                    ((ServerInfo)ServersInfoPanel.this.serversInfo.get(s)).startServer();
                }
            }
        });
        this.serverActionPopup.add(this.startServer);
        this.stopServer = new JMenuItem("Stop");
        this.stopServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableModel tm = ServersInfoPanel.this.jTable1.getModel();
                for (int i : ServersInfoPanel.this.jTable1.getSelectedRows()) {
                    String s = (String)tm.getValueAt(i, 2);
                    ((ServerInfo)ServersInfoPanel.this.serversInfo.get(s)).stopServer();
                }
            }
        });
        this.serverActionPopup.add(this.stopServer);
        this.update.setText("Servers State Update");
        this.update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    ServersInfoPanel.this.updateServersState();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    System.out.println("Error : " + exc);
                }
            }
        });
        this.jPanel1.add(this.update);
        this.startAllServer = new JButton("Start All Servers");
        this.startAllServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Enumeration i = ServersInfoPanel.this.serversInfo.elements();
                while (i.hasMoreElements()) {
                    ((ServerInfo)i.nextElement()).startServer();
                }
            }
        });
        this.jPanel1.add(this.startAllServer);
        this.killAllServer = new JButton("Kill All Servers");
        this.killAllServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Enumeration i = ServersInfoPanel.this.serversInfo.elements();
                while (i.hasMoreElements()) {
                    ((ServerInfo)i.nextElement()).stopServer();
                }
            }
        });
        this.jPanel1.add(this.killAllServer);
        this.add((Component)this.jPanel1, "Last");
        this.jPanel2.setLayout(new BorderLayout());
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"State", "Class Name", "Address", "Action"}){
            private static final long serialVersionUID = 1L;
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.addMouseListener(new JTableButtonMouseListener(this.jTable1));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jTable1.getColumnModel().getColumn(0).setMinWidth(50);
        this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.jTable1.getColumnModel().getColumn(0).setMaxWidth(50);
        this.jTable1.getColumnModel().getColumn(0).setCellRenderer(new StateRenderer());
        this.jTable1.getColumnModel().getColumn(1).setMinWidth(180);
        this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(180);
        this.jTable1.getColumnModel().getColumn(1).setMaxWidth(180);
        this.jTable1.getColumnModel().getColumn(2).setMinWidth(200);
        this.jTable1.getColumnModel().getColumn(2).setPreferredWidth(200);
        this.jTable1.getColumnModel().getColumn(2).setMaxWidth(200);
        this.jTable1.getColumnModel().getColumn(3).setMinWidth(200);
        this.jTable1.getColumnModel().getColumn(3).setPreferredWidth(200);
        this.jTable1.getColumnModel().getColumn(3).setCellRenderer(new ActionRenderer());
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.jPanel2, "Center");
    }

    public void loadServerState(String address, int info_port) throws Exception {
        this.address = address;
        this.info_port = info_port;
        Socket s = new Socket(address, info_port);
        s.setSoTimeout(5000);
        DataOutputStream dos = new DataOutputStream(s.getOutputStream());
        DataInputStream dis = new DataInputStream(s.getInputStream());
        dos.writeUTF("servers");
        int numServer = dis.readInt();
        for (int i = 0; i < numServer; ++i) {
            int j;
            String serverClass = dis.readUTF();
            String addressSrv = dis.readUTF();
            boolean active = dis.readBoolean();
            if (this.serversInfo == null || addressSrv == null || addressSrv.length() == 0) continue;
            DefaultTableModel md = (DefaultTableModel)this.jTable1.getModel();
            ServerInfo si = this.serversInfo.get(addressSrv);
            if (si == null) {
                System.out.println("ERROR : Server Address " + addressSrv + " for server class " + serverClass + " not found");
                continue;
            }
            si.setActive(active);
            int numRow = md.getRowCount();
            for (j = 0; j < numRow; ++j) {
                Object o = md.getValueAt(j, 2);
                if (o == null || !o.equals(addressSrv)) continue;
                md.setValueAt(new Boolean(active), j, 0);
                break;
            }
            if (j != numRow) continue;
            si.setPos(j);
            md.addRow(si.getAsArray());
        }
        s.close();
    }

    public void setServersInfo(Hashtable<String, ServerInfo> serversInfo) {
        this.serversInfo = serversInfo;
    }

    public void updateServersInfoAction(MdsMonitorEvent event) {
        DefaultTableModel md = (DefaultTableModel)this.jTable1.getModel();
        ServerInfo si = this.serversInfo.get(event.server_address);
        if (si != null) {
            md.setValueAt(event, si.getPos(), 3);
        }
    }

    public void updateServersState() throws Exception {
        Socket s = new Socket(this.address, this.info_port);
        s.setSoTimeout(5000);
        DataOutputStream dos = new DataOutputStream(s.getOutputStream());
        DataInputStream dis = new DataInputStream(s.getInputStream());
        dos.writeUTF("servers");
        int numServer = dis.readInt();
        block0: for (int i = 0; i < numServer; ++i) {
            String serverClass = dis.readUTF();
            String addressSrv = dis.readUTF();
            boolean active = dis.readBoolean();
            if (this.serversInfo == null || addressSrv == null || addressSrv.length() == 0) continue;
            DefaultTableModel md = (DefaultTableModel)this.jTable1.getModel();
            ServerInfo si = this.serversInfo.get(addressSrv);
            if (si == null) {
                System.out.println("ERROR : Server Address " + addressSrv + " for server class " + serverClass + " not found");
                continue;
            }
            si.setActive(active);
            int numRow = md.getRowCount();
            for (int j = 0; j < numRow; ++j) {
                Object o = md.getValueAt(j, 2);
                if (o == null || !o.equals(addressSrv)) continue;
                md.setValueAt(new Boolean(active), j, 0);
                continue block0;
            }
        }
        s.close();
    }

    public void updateServerState(String serverAddress, boolean state) {
        try {
            DefaultTableModel md = (DefaultTableModel)this.jTable1.getModel();
            ServerInfo si = this.serversInfo.get(serverAddress);
            if (si != null) {
                md.setValueAt(new Boolean(state), si.getPos(), 0);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            System.out.println("Error : " + exc);
        }
    }

    public class StateRenderer
    extends JPanel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                if (b.booleanValue()) {
                    this.setBackground(Color.GREEN);
                } else {
                    this.setBackground(Color.RED);
                }
            }
            return this;
        }
    }

    class JTableButtonMouseListener
    implements MouseListener {
        private final JTable table;

        public JTableButtonMouseListener(JTable table) {
            this.table = table;
        }

        private void forwardEventToButton(MouseEvent e) {
            TableColumnModel columnModel = this.table.getColumnModel();
            int column = columnModel.getColumnIndexAtX(e.getX());
            int row = e.getY() / this.table.getRowHeight();
            if (row >= this.table.getRowCount() || row < 0 || column >= this.table.getColumnCount() || column < 0) {
                return;
            }
            Object value = this.table.getValueAt(row, column);
            if (!(value instanceof JButton)) {
                return;
            }
            JButton button = (JButton)value;
            MouseEvent buttonEvent = SwingUtilities.convertMouseEvent(this.table, e, button);
            button.dispatchEvent(buttonEvent);
            this.table.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.forwardEventToButton(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.forwardEventToButton(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.forwardEventToButton(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.forwardEventToButton(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.forwardEventToButton(e);
        }
    }

    public class ButtonRenderer
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (Component)value;
        }
    }

    public class ActionRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof MdsMonitorEvent) {
                MdsMonitorEvent e = (MdsMonitorEvent)value;
                switch (e.mode) {
                    case 7: {
                        this.setForeground(Color.BLUE);
                        break;
                    }
                    case 8: {
                        if ((e.status & 1) != 0) {
                            this.setForeground(Color.GREEN);
                            break;
                        }
                        this.setForeground(Color.RED);
                    }
                }
                this.setText(e.node_path);
            } else {
                this.setText("");
            }
            return this;
        }
    }
}

