/*
 * Decompiled with CFR 0.152.
 */
package mds.jdispatcher;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import mds.connection.ConnectionEvent;
import mds.connection.ConnectionListener;
import mds.connection.Descriptor;
import mds.connection.MdsConnection;
import mds.connection.MdsMessage;
import mds.jdispatcher.MdsHelper;
import mds.jdispatcher.MdsIp;
import mds.jdispatcher.MdsMonitorEvent;
import mds.jdispatcher.MdsServer;
import mds.jdispatcher.MdsServerEvent;
import mds.jdispatcher.MdsServerListener;
import mds.jdispatcher.ServerInfo;
import mds.jdispatcher.ServersInfoPanel;
import mds.jdispatcher.jDispatcherIp;

public class jDispatchMonitor
extends JFrame
implements MdsServerListener,
ConnectionListener {
    private static final long serialVersionUID = 1L;
    public static final int ACTION_NOT_FOUND = -2;
    private static final Font done_font = new Font("Platino Linotype", 0, 12);
    ServersInfoPanel serversInfoPanel = null;
    Hashtable<String, ServerInfo> serversInfo = new Hashtable();
    ShotsPerformance shotsPerformance = new ShotsPerformance();
    private String experiment;
    private MdsServer mds_server = null;
    private MdsConnection dispatcher = null;
    private JDesktopPane desktop = null;
    private final JLabel total_actions_l;
    private final JLabel dispatched_l;
    private final JLabel doing_l;
    private final JLabel done_l;
    private final JLabel failed_l;
    private final JLabel exp_l;
    private final JLabel shot_l;
    private final JLabel phase_l;
    private int disp_count = 0;
    private int doing_count = 0;
    private int done_count = 0;
    private int failed_count = 0;
    private int total_count = 0;
    private final ButtonGroup phase_group = new ButtonGroup();
    private final JMenu phase_m = new JMenu("Phase");
    private final JPopupMenu do_command_menu = new JPopupMenu();
    private JMenuItem do_redispatch;
    private JMenuItem do_abort;
    private JList<MdsMonitorEvent> curr_list;
    private int item_idx;
    private boolean auto_scroll = true;
    private int curr_phase = -1;
    private int show_phase = -1;
    private String tree;
    private long shot;
    private String monitor_server;
    private JInternalFrame build;
    private JInternalFrame executing;
    private JInternalFrame failed;
    private JList<MdsMonitorEvent> buildList;
    private JList<MdsMonitorEvent> executingList;
    private JList<MdsMonitorEvent> failedList;
    private final DefaultListModel<MdsMonitorEvent> build_list = new DefaultListModel();
    private final DefaultListModel<MdsMonitorEvent> executing_list = new DefaultListModel();
    private final DefaultListModel<MdsMonitorEvent> failed_list = new DefaultListModel();
    private int num_window = 0;
    private final Hashtable<Integer, Hashtable<Integer, MdsMonitorEvent>> phase_hash = new Hashtable();
    private final Hashtable<Integer, Hashtable<Integer, MdsMonitorEvent>> phase_name = new Hashtable();
    private final Hashtable<Integer, Hashtable<Integer, MdsMonitorEvent>> phase_failed = new Hashtable();
    private ErrorMgr error_mgr;
    private int info_port;
    private Process dispatcher_proc;
    long startPhaseTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void logMonitor(String event, String phase, Object ... more) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.print(String.format("Monitor: PHASE %-7s %-12s ", event, phase));
            for (Object e : more) {
                System.out.print(e);
            }
            System.out.println("");
            System.out.flush();
        }
    }

    public static void main(String[] args) {
        String experiment = "test";
        String monitor_server = "localhost:8800";
        if (args != null && args.length > 3) {
            System.out.println("jDispatchMonitor [monitor_server] [-e experiment ] \n");
            System.exit(0);
        }
        if (args.length > 0) {
            int i;
            for (i = 0; i < args.length && !args[i].equals("-e"); ++i) {
            }
            if (i < args.length) {
                experiment = args[i + 1];
                if (args.length >= 3) {
                    monitor_server = i == 0 ? args[i + 2] : args[0];
                }
            } else {
                monitor_server = args[0];
                if (args.length > 1) {
                    experiment = args[1];
                }
            }
        }
        System.out.println("jDispatchMonitor " + monitor_server + " " + experiment);
        jDispatchMonitor dm = new jDispatchMonitor(monitor_server, experiment);
        dm.pack();
        dm.setSize(600, 700);
        dm.setDefaultCloseOperation(3);
        dm.setVisible(true);
    }

    public jDispatchMonitor() {
        this((String)null, (String)null);
    }

    public jDispatchMonitor(String monitor_server, String experiment) {
        this.experiment = experiment;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                jDispatchMonitor.this.shotsPerformance.saveTimePhaseExecution();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.isAltDown() && e.isShiftDown() && e.getKeyChar() == 'P') {
                    jDispatchMonitor.this.shotsPerformance.print();
                }
            }
        });
        JMenuBar mb = new JMenuBar();
        this.setJMenuBar(mb);
        this.setWindowTitle();
        this.monitor_server = monitor_server;
        Properties properties = MdsHelper.initialization(experiment);
        if (properties == null) {
            JOptionPane.showMessageDialog(this, "Error reading properties file. Exiting.", "Alert", 0);
            System.exit(1);
        }
        int error_port = -1;
        try {
            error_port = Integer.parseInt(properties.getProperty("jDispatcher.error_port"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (error_port > 0) {
            this.error_mgr = new ErrorMgr(error_port);
            this.error_mgr.start();
        }
        this.info_port = 0;
        try {
            this.info_port = Integer.parseInt(properties.getProperty("jDispatcher.info_port"));
        }
        catch (Exception exc) {
            System.out.println("Cannot read info port");
        }
        for (ServerInfo srvInfo : MdsHelper.getServers()) {
            this.serversInfo.put(srvInfo.getAddress(), srvInfo);
        }
        this.serversInfoPanel = new ServersInfoPanel();
        this.serversInfoPanel.setServersInfo(this.serversInfo);
        try {
            if (monitor_server != null && monitor_server.length() != 0) {
                this.openConnection(monitor_server);
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        JMenu file = new JMenu("File");
        JMenuItem open = new JMenuItem("Open Connection ...");
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jDispatchMonitor.this.openConnection();
            }
        });
        file.add(open);
        JMenuItem exit = new JMenuItem("Exit");
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jDispatchMonitor.this.exitApplication();
            }
        });
        file.add(exit);
        JMenu view = new JMenu("View");
        JCheckBoxMenuItem build_cb = new JCheckBoxMenuItem("Build", true);
        build_cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jDispatchMonitor.this.num_window = jDispatchMonitor.this.num_window + (jDispatchMonitor.this.build.isShowing() ? -1 : 1);
                jDispatchMonitor.this.build.setVisible(!jDispatchMonitor.this.build.isShowing());
            }
        });
        view.add(build_cb);
        JCheckBoxMenuItem executing_cb = new JCheckBoxMenuItem("Executing", true);
        executing_cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jDispatchMonitor.this.num_window = jDispatchMonitor.this.num_window + (jDispatchMonitor.this.executing.isShowing() ? -1 : 1);
                jDispatchMonitor.this.executing.setVisible(!jDispatchMonitor.this.executing.isShowing());
            }
        });
        view.add(executing_cb);
        JCheckBoxMenuItem failed_cb = new JCheckBoxMenuItem("Failed", true);
        failed_cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jDispatchMonitor.this.num_window = jDispatchMonitor.this.num_window + (jDispatchMonitor.this.failed.isShowing() ? -1 : 1);
                jDispatchMonitor.this.failed.setVisible(!jDispatchMonitor.this.failed.isShowing());
            }
        });
        view.add(failed_cb);
        view.add(new JSeparator());
        JCheckBoxMenuItem auto_scroll_cb = new JCheckBoxMenuItem("Auto Scroll", true);
        auto_scroll_cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jDispatchMonitor.this.auto_scroll = !jDispatchMonitor.this.auto_scroll;
            }
        });
        view.add(auto_scroll_cb);
        JMenu info_m = new JMenu("Info");
        JMenuItem statistics_cb = new JMenuItem("Statistics");
        statistics_cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                jDispatchMonitor.this.shotsPerformance.print();
            }
        });
        info_m.add(statistics_cb);
        JMenu dispatch = new JMenu("Dispatch");
        for (final MdsHelper.DispatchCmd dispcmd : MdsHelper.getDispatch()) {
            JMenuItem item = new JMenuItem(dispcmd.name);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    jDispatchMonitor.this.doCommand(dispcmd.cmd);
                }
            });
            ((Container)dispatch).add(item);
        }
        mb.add(file);
        mb.add(view);
        mb.add(this.phase_m);
        mb.add((Component)dispatch);
        JPanel p0 = new JPanel();
        p0.setBorder(BorderFactory.createRaisedBevelBorder());
        Box box = new Box(1);
        JPanel p = new JPanel();
        p.add(new JLabel("Active actions"));
        this.total_actions_l = new JLabel("    0");
        p.add(this.total_actions_l);
        p.add(new JLabel("Dispatched"));
        this.dispatched_l = new JLabel("    0");
        p.add(this.dispatched_l);
        p.add(new JLabel("Doing"));
        this.doing_l = new JLabel("    0");
        p.add(this.doing_l);
        p.add(new JLabel("Done"));
        this.done_l = new JLabel("    0");
        p.add(this.done_l);
        p.add(new JLabel("Failed"));
        this.failed_l = new JLabel("    0");
        p.add(this.failed_l);
        JPanel p1 = new JPanel();
        this.exp_l = new JLabel("Experiment:          ");
        p1.add(this.exp_l);
        this.shot_l = new JLabel("Shot:        ");
        p1.add(this.shot_l);
        this.phase_l = new JLabel("Phase:        ");
        p1.add(this.phase_l);
        box.add(p1);
        box.add(p);
        p0.add(box);
        this.getContentPane().add((Component)p0, "North");
        this.desktop = new JDesktopPane(){
            private static final long serialVersionUID = 1L;

            private void positionWindow() {
                if (jDispatchMonitor.this.num_window == 0) {
                    return;
                }
                Dimension dim = jDispatchMonitor.this.desktop.getSize();
                dim.height /= jDispatchMonitor.this.num_window;
                int y = 0;
                if (jDispatchMonitor.this.build.isVisible()) {
                    jDispatchMonitor.this.build.setBounds(0, y, dim.width, dim.height);
                    y += dim.height;
                }
                if (jDispatchMonitor.this.executing.isVisible()) {
                    jDispatchMonitor.this.executing.setBounds(0, y, dim.width, dim.height);
                    y += dim.height;
                }
                if (jDispatchMonitor.this.failed.isVisible()) {
                    jDispatchMonitor.this.failed.setBounds(0, y, dim.width, dim.height);
                }
            }

            @Override
            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, y, width, height);
                this.positionWindow();
            }
        };
        this.buildList = new JList<MdsMonitorEvent>(this.build_list);
        this.buildList.setCellRenderer(new BuildCellRenderer());
        JScrollPane sp_build = new JScrollPane();
        sp_build.getViewport().setView(this.buildList);
        this.executingList = new ToolTipJList(this.executing_list);
        this.executingList.setToolTipText("");
        this.executingList.setCellRenderer(new ExecutingCellRenderer());
        JScrollPane sp_executing = new JScrollPane();
        sp_executing.getViewport().setView(this.executingList);
        this.do_redispatch = new JMenuItem("Redispatch");
        this.do_redispatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    for (MdsMonitorEvent event : jDispatchMonitor.this.executingList.getSelectedValuesList()) {
                        jDispatchMonitor.this.redispatch(event);
                    }
                }
                catch (Exception exc) {
                    JOptionPane.showMessageDialog(jDispatchMonitor.this, "Error dispatching action(s) : " + exc, "Alert", 0);
                }
            }
        });
        this.do_command_menu.add(this.do_redispatch);
        this.do_abort = new JMenuItem("Abort");
        this.do_abort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    for (MdsMonitorEvent event : jDispatchMonitor.this.executingList.getSelectedValuesList()) {
                        jDispatchMonitor.this.abortAction(event);
                    }
                }
                catch (Exception exc) {
                    JOptionPane.showMessageDialog(jDispatchMonitor.this, "Error Aborting Action", "Alert", 0);
                }
            }
        });
        this.do_command_menu.add(this.do_abort);
        this.executingList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (MdsHelper.getDispatcher() != null && (e.getModifiers() & 4) != 0) {
                    MdsMonitorEvent event = (MdsMonitorEvent)jDispatchMonitor.this.executingList.getSelectedValue();
                    if (event == null) {
                        if (jDispatchMonitor.this.executingList.getModel().getSize() != 0) {
                            JOptionPane.showMessageDialog(jDispatchMonitor.this, "Please select the action(s) to re-dispatch or abort", "Warning", 1);
                        }
                        return;
                    }
                    if (event.mode == 7 && jDispatchMonitor.this.executingList.getSelectedIndices().length == 1) {
                        jDispatchMonitor.this.do_redispatch.setEnabled(false);
                        jDispatchMonitor.this.do_abort.setEnabled(true);
                    } else {
                        jDispatchMonitor.this.do_redispatch.setEnabled(true);
                        jDispatchMonitor.this.do_abort.setEnabled(false);
                    }
                    int x = e.getX();
                    int y = e.getY();
                    jDispatchMonitor.this.do_command_menu.show(jDispatchMonitor.this.executingList, x, y);
                }
            }
        });
        this.failedList = new ToolTipJList(this.failed_list);
        this.failedList.setToolTipText("");
        this.failedList.setCellRenderer(new FailedCellRenderer());
        JScrollPane sp_failed = new JScrollPane();
        sp_failed.getViewport().setView(this.failedList);
        this.build = this.createInternalFrame("Build Table", sp_build);
        this.executing = this.createInternalFrame("Executing", sp_executing);
        this.failed = this.createInternalFrame("Failed", sp_failed);
        JTabbedPane dispatchMonitorPane = new JTabbedPane();
        this.getContentPane().add((Component)dispatchMonitorPane, "Center");
        dispatchMonitorPane.addTab("Actions Monitor", this.desktop);
        dispatchMonitorPane.addTab("Servers Info", this.serversInfoPanel);
        p1 = new JPanel();
        p1.setBackground(Color.white);
        p1.setBorder(BorderFactory.createLoweredBevelBorder());
        JLabel l1 = new JLabel("Dispatched           ");
        l1.setForeground(Color.lightGray);
        p1.add(l1);
        l1 = new JLabel("Doing               ");
        l1.setForeground(Color.blue);
        p1.add(l1);
        l1 = new JLabel("Done                ");
        l1.setForeground(Color.green);
        p1.add(l1);
        l1 = new JLabel("Failed              ");
        l1.setForeground(Color.red);
        p1.add(l1);
        this.getContentPane().add((Component)p1, "South");
    }

    private void abortAction(MdsMonitorEvent me) throws IOException {
        if (me.mode == 7) {
            this.doCommand("ABORT", me);
        }
    }

    private boolean addPhaseItem(int phase, String phase_st) {
        Enumeration<AbstractButton> e = this.phase_group.getElements();
        while (e.hasMoreElements()) {
            JCheckBoxMenuItem c = (JCheckBoxMenuItem)e.nextElement();
            if (!c.getText().equals("Phase_" + phase)) continue;
            return false;
        }
        JCheckBoxMenuItem phase_cb = new JCheckBoxMenuItem(phase_st);
        phase_cb.setActionCommand("" + phase);
        phase_cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmd = ((JCheckBoxMenuItem)e.getSource()).getActionCommand();
                jDispatchMonitor.this.show_phase = Integer.parseInt(cmd);
                jDispatchMonitor.this.showPhase(cmd);
            }
        });
        this.phase_group.add(phase_cb);
        this.phase_m.add(phase_cb);
        return true;
    }

    private void collectServersInfo() {
        try {
            String address = new StringTokenizer(this.monitor_server).nextToken(":");
            if (!this.serversInfoPanel.checkInfoServer(address, this.info_port)) {
                this.serversInfoPanel.loadServerState(address, this.info_port);
            } else {
                this.serversInfoPanel.updateServersState();
            }
        }
        catch (Exception exc) {
            ShowMessage alert = new ShowMessage(exc.getMessage());
            SwingUtilities.invokeLater(alert);
        }
    }

    private void counter(MdsMonitorEvent me) {
        switch (me.mode) {
            case 2: {
                ++this.total_count;
                break;
            }
            case 3: 
            case 4: {
                ++this.total_count;
                break;
            }
            case 6: {
                ++this.disp_count;
                break;
            }
            case 7: {
                ++this.doing_count;
                break;
            }
            case 8: {
                --this.doing_count;
                ++this.done_count;
                if ((me.ret_status & 1) != 0) break;
                ++this.failed_count;
            }
        }
        this.dispatched_l.setText(" " + this.disp_count);
        this.doing_l.setText(" " + this.doing_count);
        this.done_l.setText(" " + this.done_count);
        this.total_actions_l.setText(" " + this.total_count);
        this.failed_l.setText(" " + this.failed_count);
    }

    public JInternalFrame createInternalFrame(String title, Container panel) {
        JInternalFrame jif = new JInternalFrame();
        jif.setTitle(title);
        jif.setClosable(false);
        jif.setMaximizable(true);
        jif.setIconifiable(false);
        jif.setResizable(true);
        jif.setContentPane(panel);
        this.desktop.add((Component)jif, 1);
        jif.setVisible(true);
        ++this.num_window;
        return jif;
    }

    private final void doCommand(String command) {
        new Thread(() -> {
            try {
                this.getDispatcher().MdsValueStraight('@' + command, new Descriptor[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).start();
    }

    private void doCommand(String command, MdsMonitorEvent me) throws IOException {
        this.doCommand(String.format("%s %d %s", command, me.nid, MdsHelper.toPhaseName(me.phase)));
    }

    private void endPhase(MdsMonitorEvent me) {
        String phaseDuration = MdsMonitorEvent.msecToString(System.currentTimeMillis() - this.startPhaseTime);
        String phase_st = MdsHelper.toPhaseName(me.phase);
        jDispatchMonitor.logMonitor("END", phase_st, "duration ", phaseDuration);
        this.phase_m.setEnabled(true);
        this.shotsPerformance.add(this.shot, phase_st, phaseDuration);
    }

    public void exitApplication() {
        this.shotsPerformance.saveTimePhaseExecution();
        System.exit(0);
    }

    private final MdsConnection getDispatcher() throws Exception {
        if (this.dispatcher == null) {
            if (this.monitor_server == null) {
                throw new Exception("No monitor server.");
            }
            StringTokenizer st = new StringTokenizer(this.monitor_server, ":");
            this.dispatcher = new MdsConnection(st.nextToken() + ":" + MdsHelper.getDispatcherPort());
            this.dispatcher.ConnectToMds(false);
        }
        return this.dispatcher;
    }

    private int getIndex(MdsMonitorEvent me, int idx) {
        Hashtable<Integer, MdsMonitorEvent> actions = null;
        int ph = -1;
        ph = this.show_phase != this.curr_phase ? (me.phase = this.show_phase) : me.phase;
        if (this.phase_hash.containsKey(new Integer(ph))) {
            actions = this.phase_hash.get(new Integer(ph));
        } else {
            String phase_st = MdsHelper.toPhaseName(me.phase);
            this.addPhaseItem(me.phase, phase_st);
            actions = new Hashtable();
            this.phase_hash.put(new Integer(me.phase), actions);
            idx = 0;
        }
        if (actions == null) {
            return -2;
        }
        if (actions.containsKey(new Integer(me.nid))) {
            MdsMonitorEvent e = actions.get(new Integer(me.nid));
            if (e.tree == null) {
                e.tree = me.tree;
                e.shot = me.shot;
                e.name = me.name;
                e.on = me.on;
                e.mode = me.mode;
                e.server = me.server;
            }
            if (me.mode == 8) {
                e.error_message = e.error_message != null && e.error_message.indexOf("SS-W-NOMSG") == -1 ? new String(e.error_message + me.error_message) : new String(me.error_message);
                long start_date = e.date.getTime();
                long end_date = me.date.getTime();
                me.execution_time = e.execution_time = end_date - start_date;
            }
            e.ret_status = me.ret_status;
            e.mode = me.mode;
            e.date = me.date;
            return e.jobid;
        }
        me.jobid = idx;
        actions.put(new Integer(me.nid), me);
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void openConnection() {
        try {
            if (this.mds_server != null) {
                if (this.mds_server.isConnected()) {
                    Object[] options = new Object[]{"DISCONNECT", "CANCEL"};
                    int val = JOptionPane.showOptionDialog(this, "Dispatch monitor is already connected to " + this.mds_server.getProvider(), "Warning", -1, 2, null, options, options[0]);
                    if (val != 0) return;
                    this.mds_server.shutdown();
                    this.mds_server = null;
                    this.setWindowTitle();
                } else {
                    this.mds_server.shutdown();
                }
            }
            JComboBox cb = new JComboBox();
            cb.setEditable(true);
            this.monitor_server = (String)JOptionPane.showInputDialog(this, "Dispatch monitor server ip:port address", "Connection", 3, null, null, this.monitor_server);
            if (this.monitor_server == null) {
                return;
            }
            this.openConnection(this.monitor_server);
            return;
        }
        catch (IOException exc) {
            if (0 == JOptionPane.showConfirmDialog(this, exc.getMessage() + "\nWe will try to spawn a local instance if that is OK?", "Spawn local jDispatcherIp?", 2)) {
                // empty if block
            }
            this.spawnDispatcherIp();
        }
    }

    public void openConnection(String mon_srv) throws IOException {
        if (mon_srv == null) {
            throw new IOException("Can't connect to null address");
        }
        this.mds_server = new MdsServer(mon_srv, true, -1);
        this.mds_server.addMdsServerListener(this);
        this.mds_server.monitorCheckin();
        this.setWindowTitle();
        this.dispatcher = null;
        this.collectServersInfo();
    }

    public synchronized void processConnectionEvent(ConnectionEvent e) {
        if (e.getSource() == this.mds_server && e.getID() == 2000) {
            ShowMessage alert = new ShowMessage(e.getInfo());
            SwingUtilities.invokeLater(alert);
            this.setWindowTitle();
            this.mds_server = null;
        }
        if (e.getSource() == this.dispatcher && e.getID() == 2000) {
            this.dispatcher = null;
        }
    }

    @Override
    public synchronized void processMdsServerEvent(MdsServerEvent e) {
        if (e instanceof MdsMonitorEvent) {
            MdsMonitorEvent me = (MdsMonitorEvent)e;
            UpdateList ul = new UpdateList(me);
            try {
                SwingUtilities.invokeLater(ul);
            }
            catch (Exception exc) {
                System.out.println("processMdsServerEvent " + exc);
            }
        }
    }

    private void redispatch(MdsMonitorEvent me) throws IOException {
        if (me.mode == 8) {
            this.doCommand("REDISPATCH", me);
        }
    }

    private void resetAll(MdsMonitorEvent me) {
        this.total_count = 0;
        this.doing_count = 0;
        this.done_count = 0;
        this.failed_count = 0;
        this.disp_count = 0;
        this.phase_m.removeAll();
        this.build_list.removeAllElements();
        this.failed_list.removeAllElements();
        this.executing_list.removeAllElements();
        this.phase_hash.clear();
        this.phase_name.clear();
        this.phase_failed.clear();
        if (me != null) {
            this.shotsPerformance.saveTimePhaseExecution();
            this.tree = me.tree;
            this.shot = me.shot;
            this.exp_l.setText("Experiment: " + this.tree);
            this.shot_l.setText("Shot: " + this.shot);
            this.phase_l.setText("Phase: " + MdsHelper.toPhaseName(me.phase));
        }
    }

    private void setWindowTitle() {
        if (this.mds_server != null && this.mds_server.isConnected()) {
            this.setTitle("jDispatchMonitor - Connected to " + this.mds_server.getProvider() + " receive on port " + this.mds_server.rcv_port);
        } else {
            this.setTitle("jDispatchMonitor - Not Connected");
        }
    }

    private void showPhase(String phase) {
        if (this.phase_hash.containsKey(new Integer(phase))) {
            this.show_phase = Integer.parseInt(phase);
            this.executing_list.removeAllElements();
            this.failed_list.removeAllElements();
            Hashtable<Integer, MdsMonitorEvent> actions = this.phase_hash.get(new Integer(phase));
            this.executing_list.setSize(actions.size());
            int s_done = 0;
            int s_failed = 0;
            Enumeration<MdsMonitorEvent> e = actions.elements();
            while (e.hasMoreElements()) {
                MdsMonitorEvent me = e.nextElement();
                this.executing_list.set(me.jobid, me);
                ++s_done;
                if ((me.ret_status & 1) != 0) continue;
                this.failed_list.addElement(me);
                ++s_failed;
            }
            if (this.curr_phase != this.show_phase) {
                this.phase_l.setText("Phase : " + MdsHelper.toPhaseName(this.show_phase));
                this.executing.setTitle("Executed in " + MdsHelper.toPhaseName(this.show_phase) + " phase Done :" + s_done + " Failed: " + s_failed);
                this.failed.setTitle("Failed in " + MdsHelper.toPhaseName(this.show_phase));
            } else {
                this.phase_l.setText("Phase : " + MdsHelper.toPhaseName(this.curr_phase));
                this.executing.setTitle("Executing");
                this.failed.setTitle("Failed");
                this.show_phase = this.curr_phase;
            }
        }
    }

    private void showUpdateAction(JList<MdsMonitorEvent> list, int idx) {
        SwingUtilities.invokeLater(new UpdateHandler(list, idx));
    }

    private final void spawnDispatcherIp() {
        if (this.dispatcher_proc == null) {
            String sep = System.getProperty("file.separator");
            String classpath = System.getProperty("java.class.path");
            String path = System.getProperty("java.home") + sep + "bin" + sep + "java";
            ProcessBuilder processBuilder = new ProcessBuilder(path, "-cp", classpath, jDispatcherIp.class.getName(), this.experiment);
            try {
                this.dispatcher_proc = processBuilder.start();
                Runtime.getRuntime().addShutdownHook(new Thread(() -> this.dispatcher_proc.destroy()));
                new Thread(() -> {
                    while (true) {
                        try {
                            Thread.sleep(1000L);
                            this.openConnection(this.monitor_server);
                        }
                        catch (Exception e) {
                            continue;
                        }
                        break;
                    }
                }).start();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void startPhase(MdsMonitorEvent me) {
        this.startPhaseTime = System.currentTimeMillis();
        String phase_st = MdsHelper.toPhaseName(me.phase);
        jDispatchMonitor.logMonitor("START", phase_st, " ", me);
        this.executing_list.removeAllElements();
        this.phase_l.setText("Phase: " + phase_st);
        this.phase_m.setEnabled(false);
        this.curr_phase = this.show_phase = me.phase;
    }

    class UpdateList
    implements Runnable {
        MdsMonitorEvent me;

        UpdateList(MdsMonitorEvent me) {
            this.me = me;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int status = 1;
            switch (this.me.mode) {
                case 10: {
                    jDispatchMonitor.this.startPhase(this.me);
                    break;
                }
                case 9: {
                    jDispatchMonitor.this.endPhase(this.me);
                    break;
                }
                case 12: {
                    jDispatchMonitor.this.serversInfoPanel.updateServerState(this.me.server_address, true);
                    break;
                }
                case 13: {
                    jDispatchMonitor.this.serversInfoPanel.updateServerState(this.me.server_address, false);
                    ServerInfo si = jDispatchMonitor.this.serversInfo.get(this.me.server_address);
                    String msg = si != null ? (si.killed ? null : "Disconnect from server class " + si.getClassName() + " address :" + this.me.server_address) : "Disconnect from server class address :" + this.me.server_address;
                    if (msg == null) break;
                    JOptionPane.showMessageDialog(jDispatchMonitor.this, msg, "Alert", 0);
                    break;
                }
                case 2: {
                    jDispatchMonitor.this.resetAll(this.me);
                }
                case 3: 
                case 4: {
                    jDispatchMonitor.this.build_list.addElement(this.me);
                    break;
                }
                case 5: {
                    break;
                }
                case 8: {
                    status = this.me.ret_status;
                    Hashtable actions = null;
                    if (jDispatchMonitor.this.phase_failed.containsKey(new Integer(this.me.phase)) && (actions = (Hashtable)jDispatchMonitor.this.phase_failed.get(new Integer(this.me.phase))).containsKey(new Integer(this.me.nid))) {
                        MdsMonitorEvent me_failed = (MdsMonitorEvent)actions.get(new Integer(this.me.nid));
                        this.me.error_message = this.me.error_message == null || this.me.error_message.indexOf("SS-W-NOMSG") != -1 ? me_failed.error_message : this.me.error_message + " " + me_failed.error_message;
                        me_failed.error_message = new String(this.me.error_message);
                    }
                }
                case 6: 
                case 7: {
                    DefaultListModel defaultListModel = jDispatchMonitor.this.executing_list;
                    synchronized (defaultListModel) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                jDispatchMonitor.this.serversInfoPanel.updateServersInfoAction(UpdateList.this.me);
                            }
                        });
                        int idx = jDispatchMonitor.this.getIndex(this.me, jDispatchMonitor.this.executing_list.size());
                        if (idx == -2) {
                            JOptionPane.showMessageDialog(jDispatchMonitor.this, "Invalid message received", "Alert", 0);
                            return;
                        }
                        if (idx == -1 || jDispatchMonitor.this.executing_list.size() == 0) {
                            jDispatchMonitor.this.executing_list.addElement(this.me);
                        } else {
                            jDispatchMonitor.this.executing_list.set(idx, this.me);
                        }
                        if ((status & 1) == 0) {
                            jDispatchMonitor.this.failed_list.addElement(this.me);
                            jDispatchMonitor.this.showUpdateAction(jDispatchMonitor.this.failedList, -1);
                        }
                        jDispatchMonitor.this.showUpdateAction(jDispatchMonitor.this.executingList, idx);
                        break;
                    }
                }
            }
            jDispatchMonitor.this.counter(this.me);
        }
    }

    class UpdateHandler
    implements Runnable {
        JList<MdsMonitorEvent> list;
        int idx;

        UpdateHandler(JList<MdsMonitorEvent> list, int idx) {
            this.list = list;
            this.idx = idx;
        }

        @Override
        public void run() {
            jDispatchMonitor.this.curr_list = this.list;
            jDispatchMonitor.this.item_idx = this.idx;
            if (jDispatchMonitor.this.auto_scroll && jDispatchMonitor.this.show_phase == jDispatchMonitor.this.curr_phase) {
                if (jDispatchMonitor.this.item_idx == -1) {
                    jDispatchMonitor.this.item_idx = jDispatchMonitor.this.curr_list.getModel().getSize() - 1;
                }
                jDispatchMonitor.this.curr_list.ensureIndexIsVisible(jDispatchMonitor.this.item_idx);
            }
            this.list.repaint();
        }
    }

    class ToolTipJList
    extends JList<MdsMonitorEvent> {
        private static final long serialVersionUID = 1L;

        public ToolTipJList(ListModel<MdsMonitorEvent> lm) {
            super(lm);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        int index = ToolTipJList.this.locationToIndex(e.getPoint());
                        ListModel dlm = ToolTipJList.this.getModel();
                        MdsMonitorEvent item = (MdsMonitorEvent)dlm.getElementAt(index);
                        ToolTipJList.this.ensureIndexIsVisible(index);
                        if ((item.ret_status & 1) == 0) {
                            JOptionPane.showMessageDialog(jDispatchMonitor.this, item.error_message, "alert", 0);
                        } else if (item.error_message != null && item.error_message.length() != 0) {
                            JOptionPane.showMessageDialog(jDispatchMonitor.this, item.error_message, "alert", 2);
                        }
                    }
                }
            });
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            String out = null;
            int st = this.getFirstVisibleIndex();
            int end = this.getLastVisibleIndex();
            if (end == -1) {
                end = ((DefaultListModel)this.getModel()).size() - 1;
            }
            if (st == -1 || end == -1) {
                return null;
            }
            for (int i = st; i <= end; ++i) {
                Rectangle r = this.getCellBounds(i, i);
                if (!r.contains(event.getPoint())) continue;
                MdsMonitorEvent me = (MdsMonitorEvent)this.getModel().getElementAt(i);
                out = me.error_message;
                break;
            }
            return out;
        }
    }

    class ShowMessage
    implements Runnable {
        String msg;

        public ShowMessage(String msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            JOptionPane.showMessageDialog(jDispatchMonitor.this, this.msg, "alert", 0);
        }
    }

    public class ShotsPerformance {
        PrintStream log;
        Vector<String> labelText = new Vector();
        Hashtable<Long, Vector<String>> shotsInfo = new Hashtable();
        Vector<String> phaseDuration;

        public ShotsPerformance() {
            this.labelText.add("SHOT");
        }

        public void add(long shot, String phase, String duration) {
            if (phase == null) {
                return;
            }
            Long key = new Long(shot);
            if (!this.labelText.contains(phase)) {
                this.labelText.add(phase);
            }
            if (!this.shotsInfo.containsKey(key)) {
                this.phaseDuration = new Vector();
                this.shotsInfo.put(key, this.phaseDuration);
            } else {
                this.phaseDuration = this.shotsInfo.get(key);
            }
            this.phaseDuration.add(duration);
        }

        public void print() {
            for (int i = 0; i < this.labelText.size(); ++i) {
                System.out.print("\t" + this.labelText.elementAt(i));
            }
            System.out.println();
            Enumeration<Long> shots = this.shotsInfo.keys();
            Enumeration<Vector<String>> e = this.shotsInfo.elements();
            while (e.hasMoreElements()) {
                String shotStr = "\t" + shots.nextElement();
                Vector<String> phDur = e.nextElement();
                for (int i = 0; i < phDur.size(); ++i) {
                    if (i % (this.labelText.size() - 1) == 0) {
                        System.out.println(shotStr);
                    }
                    System.out.print("\t" + phDur.elementAt(i));
                }
            }
        }

        public void printHeader(PrintStream out) {
            for (int i = 0; i < this.labelText.size(); ++i) {
                out.print("\t" + this.labelText.elementAt(i));
            }
            out.println();
        }

        public void printValues(PrintStream out) {
            Vector<String> phDur = this.shotsInfo.get(new Long(jDispatchMonitor.this.shot));
            for (int i = 0; i < phDur.size(); ++i) {
                if (i % (this.labelText.size() - 1) == 0) {
                    out.println("\t" + jDispatchMonitor.this.shot);
                }
                out.print("\t" + phDur.elementAt(i));
            }
        }

        public void saveTimePhaseExecution() {
            File file = new File("PhaseExecutionTime.log");
            try {
                if (this.log == null) {
                    if (file.exists()) {
                        this.log = new PrintStream(new FileOutputStream(file, true));
                        this.log.println();
                        return;
                    }
                    if (this.labelText.size() > 1) {
                        this.log = new PrintStream(new FileOutputStream(file, true));
                        this.printHeader(this.log);
                    } else {
                        return;
                    }
                }
                this.printValues(this.log);
            }
            catch (Exception exc) {
                jDispatchMonitor.logMonitor("PERFORMANCE", "ERROR", new Object[]{exc});
                exc.printStackTrace();
            }
        }
    }

    class FailedCellRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        private static final long serialVersionUID = 1L;

        public FailedCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setFont(done_font);
            MdsMonitorEvent me = (MdsMonitorEvent)value;
            this.setText(me.getMonitorString());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setBackground(list.getBackground());
            }
            return this;
        }
    }

    class ExecutingCellRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        private static final long serialVersionUID = 1L;

        public ExecutingCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                return this;
            }
            this.setFont(done_font);
            MdsMonitorEvent me = (MdsMonitorEvent)value;
            this.setText(me.getMonitorString());
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            switch (me.mode) {
                case 6: {
                    this.setForeground(Color.lightGray);
                    break;
                }
                case 7: {
                    this.setForeground(Color.blue);
                    break;
                }
                case 8: {
                    if ((me.ret_status & 1) == 1) {
                        this.setForeground(Color.green);
                        break;
                    }
                    this.setForeground(Color.red);
                }
            }
            return this;
        }
    }

    public class ErrorMgr
    extends MdsIp {
        public ErrorMgr(int port) {
            super(port);
        }

        @Override
        public MdsMessage handleMessage(MdsMessage[] messages) {
            int[] nids = null;
            String message = null;
            try {
                nids = messages[1].ToIntArray();
                message = messages[2].ToString();
            }
            catch (Exception exc) {
                System.out.println("Error receiving error message : " + exc);
                return new MdsMessage(1);
            }
            if (nids == null || message == null) {
                return new MdsMessage(1);
            }
            Hashtable actions = null;
            if (jDispatchMonitor.this.phase_failed.containsKey(new Integer(jDispatchMonitor.this.curr_phase))) {
                actions = (Hashtable)jDispatchMonitor.this.phase_failed.get(new Integer(jDispatchMonitor.this.curr_phase));
            } else {
                actions = new Hashtable();
                jDispatchMonitor.this.phase_failed.put(new Integer(jDispatchMonitor.this.curr_phase), actions);
            }
            if (actions == null) {
                return new MdsMessage(1);
            }
            if (!actions.containsKey(new Integer(nids[0]))) {
                MdsMonitorEvent me = new MdsMonitorEvent((Object)this, jDispatchMonitor.this.curr_phase, nids[0], message);
                actions.put(new Integer(nids[0]), me);
            }
            return new MdsMessage(1);
        }
    }

    class BuildCellRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        private static final long serialVersionUID = 1L;

        public BuildCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setFont(done_font);
            MdsMonitorEvent me = (MdsMonitorEvent)value;
            this.setText(me.getMonitorString());
            if (me.on == 0) {
                this.setForeground(Color.lightGray);
            } else {
                this.setForeground(Color.black);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setBackground(list.getBackground());
            }
            return this;
        }
    }
}

