/*
 * Decompiled with CFR 0.152.
 */
package mds.jdispatcher;

import MDSplus.Compound;
import MDSplus.Condition;
import MDSplus.Data;
import MDSplus.Dependency;
import MDSplus.Dispatch;
import MDSplus.Ident;
import MDSplus.String;
import MDSplus.Tree;
import MDSplus.TreeNode;
import MDSplus.TreePath;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import mds.jdispatcher.Action;
import mds.jdispatcher.ActionServer;
import mds.jdispatcher.Balancer;
import mds.jdispatcher.InfoServer;
import mds.jdispatcher.MdsHelper;
import mds.jdispatcher.MonitorEvent;
import mds.jdispatcher.MonitorListener;
import mds.jdispatcher.Server;
import mds.jdispatcher.ServerEvent;
import mds.jdispatcher.ServerListener;

class jDispatcher
implements ServerListener {
    static boolean verbose = true;
    static final int MONITOR_BEGIN_SEQUENCE = 1;
    static final int MONITOR_BUILD_BEGIN = 2;
    static final int MONITOR_BUILD = 3;
    static final int MONITOR_BUILD_END = 4;
    static final int MONITOR_CHECKIN = 5;
    static final int MONITOR_DISPATCHED = 6;
    static final int MONITOR_DOING = 7;
    static final int MONITOR_DONE = 8;
    static final int MONITOR_START_PHASE = 9;
    static final int MONITOR_END_PHASE = 10;
    static final int MONITOR_END_SEQUENCE = 11;
    static final int TdiUNKNOWN_VAR = 265519346;
    private boolean doing_phase = false;
    Hashtable<java.lang.String, Vector<Integer>> synchSeqNumberH = new Hashtable();
    Vector<Integer> synchSeqNumbers = new Vector();
    java.lang.String defaultServerName = "";
    java.lang.String tree;
    int shot;
    int timestamp = 1;
    Hashtable<java.lang.String, Vector<Action>> totSeqDispatched = new Hashtable();
    Vector<Action> dep_dispatched = new Vector();
    Hashtable<java.lang.String, Enumeration<Integer>> totSeqNumbers = new Hashtable();
    Hashtable<java.lang.String, Integer> actSeqNumbers = new Hashtable();
    Hashtable<java.lang.String, Boolean> phaseTerminated = new Hashtable();
    Hashtable<Integer, Vector<Action>> nidDependencies = new Hashtable();
    protected PhaseDescriptor curr_phase;
    Hashtable<java.lang.String, PhaseDescriptor> phases = new Hashtable();
    Hashtable<MDSplus.Action, Action> actions = new Hashtable();
    Hashtable<Integer, Action> action_nids = new Hashtable();
    protected Vector<Server> servers = new Vector();
    protected Balancer balancer;
    protected Vector<MonitorListener> monitors = new Vector();
    int last_shot = -2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void logEvent(java.lang.String name, java.lang.String message) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            if (message == null) {
                System.out.println(java.lang.String.format("Event: %s", name));
            } else {
                System.out.println(java.lang.String.format("Event: %-20s %s", name, message));
            }
            System.out.flush();
        }
    }

    public jDispatcher() {
    }

    public jDispatcher(Balancer balancer) {
        this.balancer = balancer;
    }

    public void abortAction(int nid) {
        if (this.action_nids == null) {
            return;
        }
        Action action = this.action_nids.get(new Integer(nid));
        if (action == null) {
            return;
        }
        this.balancer.abortAction(action);
    }

    public synchronized void abortPhase() {
        Action action;
        this.balancer.abort();
        Enumeration<java.lang.String> serverClasses = this.totSeqDispatched.keys();
        while (serverClasses.hasMoreElements()) {
            java.lang.String serverClass = serverClasses.nextElement();
            Vector<Action> seqDispatched = this.totSeqDispatched.get(serverClass);
            while (seqDispatched != null && !seqDispatched.isEmpty()) {
                action = seqDispatched.elementAt(0);
                action.setStatus(5, 0, verbose);
                seqDispatched.removeElementAt(0);
            }
        }
        while (!this.dep_dispatched.isEmpty()) {
            action = this.dep_dispatched.elementAt(0);
            action.setStatus(5, 0, verbose);
        }
    }

    @Override
    public void actionAborted(ServerEvent event) {
        event.getAction().setStatus(5, 0, verbose);
        this.fireMonitorEvent(event.getAction(), 8);
        this.reportDone(event.getAction());
    }

    @Override
    public synchronized void actionFinished(ServerEvent event) {
        Action action = event.getAction();
        try {
            java.lang.String mdsevent = ((String)action.getDispatch().getCompletion()).getString();
            if (mdsevent != null && !mdsevent.equals("\"\"")) {
                MdsHelper.generateEvent(mdsevent, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        action.setStatus(4, event.getStatus(), verbose);
        this.fireMonitorEvent(action, 8);
        this.reportDone(action);
    }

    @Override
    public synchronized void actionStarting(ServerEvent event) {
        event.getAction().setStatus(3, 0, verbose);
        this.fireMonitorEvent(event.getAction(), 7);
    }

    public synchronized void addMonitorListener(MonitorListener monitor) {
        this.monitors.addElement(monitor);
    }

    public synchronized void addServer(Server server) {
        this.servers.addElement(server);
        server.addServerListener(this);
        this.balancer.addServer(server);
    }

    public synchronized void addSynchNumbers(java.lang.String phase, Vector<Integer> synchNumbers) {
        this.synchSeqNumberH.put(phase, synchNumbers);
    }

    boolean allSeqDispatchedAreEmpty() {
        Enumeration<java.lang.String> serverClasses = this.totSeqDispatched.keys();
        while (serverClasses.hasMoreElements()) {
            java.lang.String serverClass = serverClasses.nextElement();
            if (serverClass == null || this.totSeqDispatched.get(serverClass).isEmpty()) continue;
            return false;
        }
        return true;
    }

    boolean allTerminatedInPhase() {
        Enumeration<java.lang.String> serverClasses = this.phaseTerminated.keys();
        while (serverClasses.hasMoreElements()) {
            java.lang.String serverClass = serverClasses.nextElement();
            if (serverClass == null || this.phaseTerminated.get(serverClass).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public synchronized void beginSequence(int shot) {
        this.shot = shot;
        for (Server server : this.servers) {
            server.beginSequence(shot);
        }
        this.fireMonitorEvent((Action)null, 1);
    }

    protected void buildDependencies() {
        Enumeration<java.lang.String> phaseNames = this.phases.keys();
        while (phaseNames.hasMoreElements()) {
            PhaseDescriptor currPhase = this.phases.get(phaseNames.nextElement());
            if (currPhase == null) continue;
            Enumeration<MDSplus.Action> action_list = currPhase.dependencies.keys();
            while (action_list.hasMoreElements()) {
                Dispatch dispatch;
                MDSplus.Action action_data = action_list.nextElement();
                try {
                    dispatch = this.actions.get(action_data).getDispatch();
                }
                catch (Exception e) {
                    continue;
                }
                if (dispatch.getOpcode() != 3) continue;
                this.traverseDispatch(action_data, dispatch.getWhen(), currPhase);
            }
        }
    }

    Vector<java.lang.String> canProceede(java.lang.String serverClass) {
        Enumeration<Integer> seqNumbers = this.actSeqNumbers.elements();
        int maxSeq = -1;
        while (seqNumbers.hasMoreElements()) {
            int currSeq = seqNumbers.nextElement();
            if (currSeq <= maxSeq) continue;
            maxSeq = currSeq;
        }
        int actSynch = -1;
        int nextSynch = -1;
        for (int idx = 0; idx < this.synchSeqNumbers.size(); ++idx) {
            int currSynch = this.synchSeqNumbers.elementAt(idx);
            if (currSynch < maxSeq) continue;
            actSynch = currSynch;
            if (idx == this.synchSeqNumbers.size() - 1) {
                nextSynch = actSynch;
                break;
            }
            nextSynch = this.synchSeqNumbers.elementAt(idx + 1);
            break;
        }
        if (actSynch == -1) {
            Vector<java.lang.String> retVect = new Vector<java.lang.String>();
            retVect.addElement(serverClass);
            return retVect;
        }
        Integer thisSeq = this.actSeqNumbers.get(serverClass);
        Vector<Integer> currSeqNumbers = this.curr_phase.totSeqNumbers.get(serverClass);
        int thisIdx = currSeqNumbers.indexOf(thisSeq);
        int thisSeqN = thisSeq;
        if (thisIdx == currSeqNumbers.size() - 1 && thisSeqN != actSynch) {
            Vector<java.lang.String> retVect = new Vector<java.lang.String>();
            retVect.addElement(serverClass);
            return retVect;
        }
        if (thisIdx < currSeqNumbers.size() - 1 && currSeqNumbers.elementAt(thisIdx + 1) <= actSynch) {
            Vector<java.lang.String> retVect = new Vector<java.lang.String>();
            retVect.addElement(serverClass);
            return retVect;
        }
        if (!this.allSeqDispatchedAreEmpty()) {
            return new Vector<java.lang.String>();
        }
        Enumeration<java.lang.String> serverClasses = this.curr_phase.totSeqNumbers.keys();
        Vector<java.lang.String> serverClassesV = new Vector<java.lang.String>();
        while (serverClasses.hasMoreElements()) {
            java.lang.String currServerClass = serverClasses.nextElement();
            Integer currSeqNum = this.actSeqNumbers.get(currServerClass);
            Vector<Integer> currSeqVect = this.curr_phase.totSeqNumbers.get(currServerClass);
            int currSeqN = currSeqNum;
            if (currSeqN == -1) {
                int firstSeqN = currSeqVect.elementAt(0);
                if ((nextSynch != actSynch || firstSeqN <= actSynch) && (nextSynch <= actSynch || firstSeqN > nextSynch)) continue;
                serverClassesV.addElement(currServerClass);
                continue;
            }
            int currIdx = currSeqVect.indexOf(currSeqNum);
            serverClassesV.addElement(currServerClass);
            if (currIdx >= currSeqVect.size() - 1 || currSeqVect.elementAt(currIdx + 1) < actSynch) continue;
            return new Vector<java.lang.String>();
        }
        return serverClassesV;
    }

    public boolean checkEssential() {
        Enumeration<Action> actionsEn = this.curr_phase.all_actions.elements();
        while (actionsEn.hasMoreElements()) {
            Action action = actionsEn.nextElement();
            if (!action.isEssential() || action.getDispatchStatus() == 4 && (action.getStatus() & 1) != 0) continue;
            return false;
        }
        return true;
    }

    public synchronized void clearTables() {
        this.actions.clear();
        this.action_nids.clear();
        this.phases.clear();
        this.dep_dispatched.removeAllElements();
        this.totSeqDispatched = new Hashtable();
        this.actSeqNumbers = new Hashtable();
        this.nidDependencies.clear();
        ++this.timestamp;
    }

    public synchronized void collectDispatchInformation() {
        this.clearTables();
        for (Server server : this.servers) {
            Action[] curr_actions = server.collectActions();
            if (curr_actions == null) continue;
            for (int i = 0; i < curr_actions.length; ++i) {
                this.insertAction(curr_actions[i], i == 0, i == curr_actions.length - 1);
            }
        }
        this.buildDependencies();
    }

    public synchronized void collectDispatchInformation(java.lang.String rootPath) {
        this.clearTables();
        for (Server server : this.servers) {
            Action[] curr_actions = server.collectActions(rootPath);
            if (curr_actions == null) continue;
            for (int i = 0; i < curr_actions.length; ++i) {
                this.insertAction(curr_actions[i], i == 0, i == curr_actions.length - 1);
            }
        }
        this.buildDependencies();
    }

    @Override
    public void connected(ServerEvent event) {
        jDispatcher.logEvent("RECONNECTED", event.getMessage());
        event.getAction();
        this.fireMonitorEvent(event.getMessage(), 3);
    }

    void discardAction(Action action) {
        action.setStatus(5, 0, verbose);
        this.reportDone(action);
    }

    @Override
    public void disconnected(ServerEvent event) {
        jDispatcher.logEvent("DISCONNECTED", event.getMessage());
        this.fireMonitorEvent(event.getMessage(), 2);
    }

    public synchronized boolean dispatchAction(int nid) {
        if (this.action_nids == null) {
            return false;
        }
        Action action = this.action_nids.get(new Integer(nid));
        if (action == null) {
            return false;
        }
        action.setStatus(2, 0, verbose);
        action.setManual(true);
        this.fireMonitorEvent(action, 6);
        if (!this.balancer.enqueueAction(action)) {
            this.discardAction(action);
        }
        return true;
    }

    public void dispatchAction(java.lang.String actionPath) {
        Tree currTree = InfoServer.getDatabase();
        try {
            TreeNode nid = currTree.getNode(actionPath);
            this.dispatchAction(nid.getNid());
        }
        catch (Exception exc) {
            System.err.println("Cannot resolve " + actionPath);
            return;
        }
    }

    public synchronized void endSequence(int shot) {
        for (Server server : this.servers) {
            server.endSequence(shot);
        }
        this.clearTables();
        this.fireMonitorEvent((Action)null, 11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMonitorEvent(Action action, int mode) {
        if (this.shot != this.last_shot) {
            this.last_shot = this.shot;
            jDispatcher.logEvent("SHOT", java.lang.String.valueOf(this.last_shot));
        }
        MonitorEvent event = new MonitorEvent(this, this.tree, this.shot, this.curr_phase == null ? "NONE" : this.curr_phase.phase_name, action);
        Vector<MonitorListener> vector = this.monitors;
        synchronized (vector) {
            for (MonitorListener curr_listener : this.monitors) {
                switch (mode) {
                    case 1: {
                        curr_listener.beginSequence(event);
                        break;
                    }
                    case 2: {
                        curr_listener.buildBegin(event);
                        break;
                    }
                    case 3: {
                        curr_listener.build(event);
                        break;
                    }
                    case 4: {
                        curr_listener.buildEnd(event);
                        break;
                    }
                    case 6: {
                        curr_listener.dispatched(event);
                        break;
                    }
                    case 7: {
                        curr_listener.doing(event);
                        break;
                    }
                    case 8: {
                        curr_listener.done(event);
                        break;
                    }
                    case 11: {
                        curr_listener.endSequence(event);
                        break;
                    }
                    case 9: {
                        event.eventId = 5;
                        curr_listener.startPhase(event);
                        break;
                    }
                    case 10: {
                        event.eventId = 4;
                        curr_listener.endPhase(event);
                    }
                }
            }
        }
    }

    protected void fireMonitorEvent(java.lang.String message, int mode) {
        MonitorEvent event = new MonitorEvent(this, mode, message);
        for (MonitorListener monitor : this.monitors) {
            switch (mode) {
                case 3: {
                    monitor.connect(event);
                    break;
                }
                case 2: {
                    monitor.disconnect(event);
                    break;
                }
                case 5: {
                    monitor.startPhase(event);
                    break;
                }
                case 4: {
                    monitor.endPhase(event);
                }
            }
        }
    }

    int getFirstValidSynch() {
        for (int idx = 0; idx < this.synchSeqNumbers.size(); ++idx) {
            int currSynch = this.synchSeqNumbers.elementAt(idx);
            Enumeration<java.lang.String> serverClasses = this.curr_phase.totSeqNumbers.keys();
            while (serverClasses.hasMoreElements()) {
                java.lang.String currServerClass = serverClasses.nextElement();
                Vector<Integer> currSeqVect = this.curr_phase.totSeqNumbers.get(currServerClass);
                if (currSeqVect == null || currSeqVect.size() <= 0 || currSeqVect.elementAt(0) > currSynch) continue;
                return currSynch;
            }
        }
        return -1;
    }

    protected java.lang.String getServerClass(Action action) {
        try {
            Dispatch dispatch = action.getDispatch();
            java.lang.String serverClass = dispatch.getIdent().getString().toUpperCase();
            if (serverClass == null || serverClass.equals("")) {
                return this.defaultServerName;
            }
            return this.balancer.getActServer(serverClass);
        }
        catch (Exception exc) {
            return this.defaultServerName;
        }
    }

    Vector<Integer> getValidSynchSeq(java.lang.String phaseName, Hashtable<java.lang.String, Vector<Integer>> currTotSeqNumbers) {
        Vector<Integer> currSynchSeqNumbers = this.synchSeqNumberH.get(phaseName);
        if (currSynchSeqNumbers == null) {
            return new Vector<Integer>();
        }
        Vector<Integer> actSynchSeqNumbers = new Vector<Integer>();
        Enumeration<java.lang.String> serverNames = currTotSeqNumbers.keys();
        int minSeq = Integer.MAX_VALUE;
        int maxSeq = -1;
        while (serverNames.hasMoreElements()) {
            java.lang.String currServerName = serverNames.nextElement();
            Vector<Integer> currSeqNumbers = currTotSeqNumbers.get(currServerName);
            if (currSeqNumbers.size() <= 0) continue;
            int currMin = currSeqNumbers.elementAt(0);
            int currMax = currSeqNumbers.elementAt(currSeqNumbers.size() - 1);
            if (minSeq > currMin) {
                minSeq = currMin;
            }
            if (maxSeq >= currMax) continue;
            maxSeq = currMax;
        }
        if (maxSeq == -1) {
            return new Vector<Integer>();
        }
        for (int i = 0; i < currSynchSeqNumbers.size(); ++i) {
            int currSynch = currSynchSeqNumbers.elementAt(i);
            if (currSynch < minSeq || currSynch >= maxSeq) continue;
            actSynchSeqNumbers.addElement(new Integer(currSynch));
        }
        return actSynchSeqNumbers;
    }

    protected void insertAction(Action action, boolean is_first, boolean is_last) {
        java.lang.String phase_name;
        java.lang.String serverClass = this.getServerClass(action);
        this.actions.put(action.getAction(), action);
        this.action_nids.put(new Integer(action.getNid()), action);
        Dispatch dispatch = action.getDispatch();
        if (dispatch == null) {
            System.out.println("Warning: Action " + action + " without dispatch info");
            return;
        }
        try {
            phase_name = dispatch.getPhase().getString().toUpperCase();
        }
        catch (Exception exc) {
            System.out.println("Warning: Action " + action + " does not contain a phase string");
            return;
        }
        try {
            dispatch.getIdent().getString();
        }
        catch (Exception exc) {
            System.out.println("Warning: Action " + action + " does not containg a server class string");
            return;
        }
        this.curr_phase = this.phases.get(phase_name);
        if (this.curr_phase == null) {
            this.curr_phase = new PhaseDescriptor(phase_name);
            this.phases.put(phase_name, this.curr_phase);
        }
        this.curr_phase.all_actions.put(new Integer(action.getNid()), action);
        boolean isSequenceNumber = true;
        if (dispatch.getOpcode() == 2) {
            Vector<Integer> seqNumbers;
            Hashtable<Integer, Vector<Action>> seqActions;
            int seq_number = 0;
            if (dispatch.getWhen() instanceof TreeNode) {
                isSequenceNumber = false;
            } else {
                try {
                    seq_number = dispatch.getWhen().getInt();
                }
                catch (Exception exc) {
                    isSequenceNumber = false;
                }
            }
            if (!isSequenceNumber) {
                dispatch.setWhen(this.traverseSeqExpression(action.getAction(), dispatch.getWhen()));
            }
            if ((seqActions = this.curr_phase.totSeqActions.get(serverClass)) == null) {
                seqActions = new Hashtable();
                this.curr_phase.totSeqActions.put(serverClass, seqActions);
            }
            if ((seqNumbers = this.curr_phase.totSeqNumbers.get(serverClass)) == null) {
                seqNumbers = new Vector();
                this.curr_phase.totSeqNumbers.put(serverClass, seqNumbers);
            }
            if (isSequenceNumber) {
                Integer seq_obj = new Integer(seq_number);
                if (seqActions.containsKey(seq_obj)) {
                    seqActions.get(seq_obj).addElement(action);
                } else {
                    Vector<Action> curr_vector = new Vector<Action>();
                    curr_vector.add(action);
                    seqActions.put(seq_obj, curr_vector);
                    if (seqNumbers.size() == 0) {
                        seqNumbers.addElement(seq_obj);
                    } else {
                        int idx;
                        int currNum = -1;
                        for (idx = 0; idx < seqNumbers.size() && (currNum = seqNumbers.elementAt(idx).intValue()) < seq_number; ++idx) {
                        }
                        if (currNum != seq_number) {
                            seqNumbers.insertElementAt(seq_obj, idx);
                        }
                    }
                }
            }
        }
        if (dispatch.getOpcode() == 3 && dispatch.getWhen() == null) {
            this.curr_phase.immediate_actions.addElement(action);
        }
        this.curr_phase.dependencies.put(action.getAction(), new Vector());
        if (is_first) {
            this.fireMonitorEvent(action, 2);
        } else if (is_last) {
            this.fireMonitorEvent(action, 4);
        } else {
            this.fireMonitorEvent(action, 3);
        }
    }

    boolean isConditional(Action action) {
        Dispatch dispatch = action.getDispatch();
        if (dispatch.getOpcode() != 2) {
            return true;
        }
        return dispatch.getWhen() instanceof TreeNode || dispatch.getWhen() instanceof TreePath || dispatch.getWhen() instanceof Ident;
    }

    protected boolean isEnabled(Data when) {
        Action action;
        if (when instanceof Condition) {
            int modifier = ((Condition)when).getOpcode();
            Action action2 = this.actions.get(((Condition)when).getArg());
            if (action2 == null) {
                return false;
            }
            int dispatch_status = action2.getDispatchStatus();
            int status = action2.getStatus();
            if (dispatch_status != 4) {
                return false;
            }
            switch (modifier) {
                case 0: {
                    return (status & 1) != 0;
                }
                case 8: 
                case 9: {
                    return true;
                }
                case 7: {
                    return (status & 1) == 0;
                }
            }
        }
        if (when instanceof MDSplus.Action && (action = this.actions.get(when)).getDispatchStatus() != 4) {
            return false;
        }
        if (when instanceof Dependency) {
            Data[] args = ((Dependency)when).getDescs();
            if (args.length != 2) {
                System.out.println("Error: dependency needs 2 arguments. Ignored");
                return false;
            }
            int opcode = ((Dependency)when).getOpcode();
            switch (opcode) {
                case 10: {
                    return this.isEnabled(args[0]) && this.isEnabled(args[1]);
                }
                case 11: {
                    return this.isEnabled(args[0]) || this.isEnabled(args[1]);
                }
            }
        }
        return true;
    }

    public void redispatchAction(int nid) {
        if (this.doing_phase) {
            return;
        }
        Action action = this.curr_phase.all_actions.get(new Integer(nid));
        if (action == null) {
            System.err.println("Redispatched a non existent action");
            return;
        }
        this.dep_dispatched.addElement(action);
        action.setStatus(2, 0, verbose);
        action.setManual(true);
        this.fireMonitorEvent(action, 6);
        if (!this.balancer.enqueueAction(action)) {
            this.discardAction(action);
        }
    }

    public void redispatchAction(int nid, java.lang.String phaseName) {
        PhaseDescriptor phase = this.phases.get(phaseName);
        if (this.doing_phase) {
            return;
        }
        Action action = phase.all_actions.get(new Integer(nid));
        if (action == null) {
            System.err.println("Redispatched a non existent action");
            return;
        }
        this.dep_dispatched.addElement(action);
        action.setStatus(2, 0, verbose);
        action.setManual(true);
        this.fireMonitorEvent(action, 6);
        if (!this.balancer.enqueueAction(action)) {
            this.discardAction(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportDone(Action action) {
        Action currAction;
        java.lang.String serverClass = this.getServerClass(action);
        Vector<Action> currSeqDispatched = this.totSeqDispatched.get(serverClass);
        if (currSeqDispatched == null || !currSeqDispatched.removeElement(action)) {
            this.dep_dispatched.removeElement(action);
        }
        if (!action.isManual()) {
            Vector<Action> depVect;
            Vector<Action> currDepV = this.curr_phase.dependencies.get(action.getAction());
            if (currDepV != null && currDepV.size() > 0) {
                Enumeration<Action> depend_actions = currDepV.elements();
                while (depend_actions.hasMoreElements()) {
                    Action curr_action = depend_actions.nextElement();
                    if (!curr_action.isOn() || !this.isEnabled(curr_action.getDispatch().getWhen())) continue;
                    this.dep_dispatched.addElement(curr_action);
                    curr_action.setStatus(2, 0, verbose);
                    this.fireMonitorEvent(curr_action, 6);
                    if (this.balancer.enqueueAction(curr_action)) continue;
                    this.discardAction(action);
                }
            }
            if ((depVect = this.nidDependencies.get(new Integer(action.getNid()))) != null && depVect.size() > 0) {
                Tree tree = InfoServer.getDatabase();
                java.lang.String doneExpr = "PUBLIC _ACTION_" + Integer.toHexString(action.getNid()) + " = " + action.getStatus();
                try {
                    tree.tdiExecute(doneExpr, new Data[0]);
                }
                catch (Exception exc) {
                    System.err.println("Error setting completion TDI variable: " + exc);
                }
                for (int i = 0; i < depVect.size(); ++i) {
                    currAction = depVect.elementAt(i);
                    try {
                        Data retData = tree.tdiEvaluate(currAction.getDispatch().getWhen());
                        int retStatus = retData.getInt();
                        if ((retStatus & 1) != 0) {
                            this.dep_dispatched.addElement(currAction);
                            currAction.setStatus(2, 0, verbose);
                            this.fireMonitorEvent(currAction, 6);
                            if (this.balancer.enqueueAction(currAction)) continue;
                            this.discardAction(action);
                            continue;
                        }
                        action.setStatus(5, 266436616, verbose);
                        this.fireMonitorEvent(action, 8);
                        continue;
                    }
                    catch (Exception retData) {
                        // empty catch block
                    }
                }
            }
        }
        if (!this.isConditional(action)) {
            if (currSeqDispatched.isEmpty()) {
                Vector<java.lang.String> serverClassesV = this.canProceede(serverClass);
                for (int i = 0; i < serverClassesV.size(); ++i) {
                    java.lang.String currServerClass = serverClassesV.elementAt(i);
                    Enumeration<Integer> currSeqNumbers = this.totSeqNumbers.get(currServerClass);
                    currSeqDispatched = this.totSeqDispatched.get(currServerClass);
                    if (currSeqNumbers.hasMoreElements()) {
                        Integer curr_int = currSeqNumbers.nextElement();
                        this.actSeqNumbers.put(currServerClass, curr_int);
                        Enumeration<Action> actions = this.curr_phase.totSeqActions.get(currServerClass).get(curr_int).elements();
                        while (actions.hasMoreElements()) {
                            Action curr_action = actions.nextElement();
                            currSeqDispatched.addElement(curr_action);
                            curr_action.setStatus(2, 0, verbose);
                            this.fireMonitorEvent(curr_action, 6);
                            if (this.balancer.enqueueAction(curr_action)) continue;
                            this.discardAction(action);
                        }
                        continue;
                    }
                    this.phaseTerminated.put(currServerClass, new Boolean(true));
                    if (!this.allTerminatedInPhase() || !this.dep_dispatched.isEmpty()) continue;
                    this.doing_phase = false;
                    Enumeration<Action> allActionsEn = this.curr_phase.all_actions.elements();
                    while (allActionsEn.hasMoreElements()) {
                        currAction = allActionsEn.nextElement();
                        int currDispatchStatus = currAction.getDispatchStatus();
                        if (currDispatchStatus == 5 || currDispatchStatus == 4) continue;
                        currAction.setStatus(5, 266436634, verbose);
                        this.fireMonitorEvent(currAction, 8);
                    }
                    jDispatcher.logEvent("PHASE END", this.curr_phase.phase_name);
                    this.fireMonitorEvent((Action)null, 10);
                    jDispatcher jDispatcher2 = this;
                    synchronized (jDispatcher2) {
                        this.notify();
                    }
                    return;
                }
            }
        } else if (this.allTerminatedInPhase() && this.dep_dispatched.isEmpty()) {
            this.doing_phase = false;
            Enumeration<Action> allActionsEn = this.curr_phase.all_actions.elements();
            while (allActionsEn.hasMoreElements()) {
                Action currAction2 = allActionsEn.nextElement();
                int currDispatchStatus = currAction2.getDispatchStatus();
                if (currDispatchStatus == 5 || currDispatchStatus == 4) continue;
                currAction2.setStatus(5, 266436634, verbose);
                this.fireMonitorEvent(currAction2, 8);
            }
            jDispatcher.logEvent("PHASE END", this.curr_phase.phase_name);
            this.fireMonitorEvent((Action)null, 10);
            jDispatcher jDispatcher3 = this;
            synchronized (jDispatcher3) {
                this.notify();
            }
            return;
        }
    }

    public void setDefaultServer(Server server) {
        this.balancer.setDefaultServer(server);
    }

    public void setDefaultServerName(java.lang.String serverName) {
        this.defaultServerName = serverName;
    }

    public void setTree(java.lang.String tree) {
        this.tree = tree;
        for (Server server : this.servers) {
            server.setTree(tree);
        }
    }

    public void setTree(java.lang.String tree, int shot) {
        try {
            new Tree(tree, shot, "READONLY").close();
        }
        catch (Exception exc) {
            System.err.println("Cannot open tree " + tree + " " + shot);
            return;
        }
        this.tree = tree;
        this.shot = shot;
        for (Server server : this.servers) {
            server.setTree(tree, shot);
        }
    }

    public void startInfoServer(int port) {
        System.out.println("Start info server on port " + port);
        new jDispatcherInfo(port).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean startPhase(java.lang.String phase_name) {
        this.doing_phase = false;
        this.curr_phase = this.phases.get(phase_name);
        if (this.curr_phase == null) {
            this.curr_phase = new PhaseDescriptor(phase_name);
        }
        this.synchSeqNumbers = this.getValidSynchSeq(phase_name, this.curr_phase.totSeqNumbers);
        jDispatcher.logEvent("PHASE BEGIN", phase_name);
        if (!this.synchSeqNumbers.isEmpty()) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                System.out.print("SYNCHRONOUS SEQUENCE NUMBERS: ");
                for (Integer seq : this.synchSeqNumbers) {
                    System.out.print(" ");
                    System.out.print(seq);
                }
                System.out.println("");
                System.out.flush();
            }
        }
        this.fireMonitorEvent((Action)null, 9);
        if (this.curr_phase.immediate_actions.size() > 0) {
            for (int i = 0; i < this.curr_phase.immediate_actions.size(); ++i) {
                Action action = this.curr_phase.immediate_actions.elementAt(i);
                if (!action.isOn()) continue;
                this.doing_phase = true;
                this.dep_dispatched.addElement(action);
                action.setStatus(2, 0, verbose);
                this.fireMonitorEvent(action, 6);
                if (this.balancer.enqueueAction(action)) continue;
                this.discardAction(action);
            }
        }
        this.phaseTerminated = new Hashtable();
        boolean anyDispatched = false;
        int firstSynch = this.getFirstValidSynch();
        Enumeration<java.lang.String> serverClasses = this.curr_phase.totSeqNumbers.keys();
        while (serverClasses.hasMoreElements()) {
            int firstSeq;
            java.lang.String serverClass = serverClasses.nextElement();
            Vector<Integer> seqNumbers = this.curr_phase.totSeqNumbers.get(serverClass);
            if (seqNumbers == null) continue;
            try {
                firstSeq = seqNumbers.elementAt(0);
            }
            catch (Exception exc) {
                firstSeq = -1;
            }
            Enumeration<Integer> currSeqNumbers = seqNumbers.elements();
            this.totSeqNumbers.put(serverClass, currSeqNumbers);
            if (!currSeqNumbers.hasMoreElements()) continue;
            this.phaseTerminated.put(serverClass, new Boolean(false));
            if (firstSynch >= 0 && firstSeq > firstSynch) {
                this.actSeqNumbers.put(serverClass, new Integer(-1));
                this.totSeqDispatched.put(serverClass, new Vector());
                continue;
            }
            Integer curr_int = currSeqNumbers.nextElement();
            this.actSeqNumbers.put(serverClass, curr_int);
            Enumeration<Action> first_actions = this.curr_phase.totSeqActions.get(serverClass).get(curr_int).elements();
            while (first_actions.hasMoreElements()) {
                Action action = first_actions.nextElement();
                if (!action.isOn()) continue;
                this.doing_phase = true;
                Vector<Action> currSeqDispatched = this.totSeqDispatched.get(serverClass);
                if (currSeqDispatched == null) {
                    currSeqDispatched = new Vector();
                    this.totSeqDispatched.put(serverClass, currSeqDispatched);
                }
                currSeqDispatched.addElement(action);
                action.setStatus(2, 0, verbose);
                this.fireMonitorEvent(action, 6);
                if (this.balancer.enqueueAction(action)) continue;
                this.discardAction(action);
            }
            anyDispatched = true;
        }
        if (anyDispatched) {
            return true;
        }
        jDispatcher.logEvent("PHASE END", phase_name);
        this.fireMonitorEvent((Action)null, 10);
        return false;
    }

    protected void traverseDispatch(MDSplus.Action action_data, Data when, PhaseDescriptor currPhase) {
        if (when == null) {
            return;
        }
        if (when instanceof Condition) {
            Action action;
            Vector<Action> act_vector = currPhase.dependencies.get(((Condition)when).getArg());
            if (act_vector != null && (action = this.actions.get(action_data)) != null) {
                act_vector.addElement(action);
            } else {
                System.out.println("Warning: condition does not refer to a known action");
            }
        } else if (when instanceof MDSplus.Action) {
            Action action;
            Vector<Action> act_vector = currPhase.dependencies.get(when);
            if (act_vector != null && (action = this.actions.get(action_data)) != null) {
                act_vector.addElement(action);
            } else {
                System.out.println("Warning: condition does not refer to a known action");
            }
        } else if (when instanceof Dependency) {
            Data[] args;
            for (Data arg : args = ((Dependency)when).getDescs()) {
                this.traverseDispatch(action_data, arg, currPhase);
            }
        }
    }

    protected Data traverseSeqExpression(MDSplus.Action action_data, Data seq) {
        Action action = this.actions.get(action_data);
        if (action == null) {
            System.err.println("Internal error in traverseSeqExpression: no action for action_data");
            return null;
        }
        Tree tree = InfoServer.getDatabase();
        if (seq == null) {
            return null;
        }
        if (seq instanceof TreePath || seq instanceof TreeNode) {
            try {
                int nid = seq instanceof TreePath ? tree.getNode((TreePath)seq).getNid() : ((TreeNode)seq).getNid();
                Vector<Action> actVect = this.nidDependencies.get(new Integer(nid));
                if (actVect == null) {
                    actVect = new Vector();
                    this.nidDependencies.put(new Integer(nid), actVect);
                }
                actVect.addElement(action);
                java.lang.String expr = "PUBLIC _ACTION_" + Integer.toHexString(nid) + " = COMPILE('$_UNDEFINED')";
                try {
                    tree.tdiExecute(expr, new Data[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return new Ident("_ACTION_" + Integer.toHexString(nid));
            }
            catch (Exception exc) {
                System.err.println("Error in resolving path names in sequential action: " + exc);
                return null;
            }
        }
        if (seq instanceof Compound) {
            Data[] descs = ((Compound)seq).getDescs();
            for (int i = 0; i < descs.length; ++i) {
                descs[i] = this.traverseSeqExpression(action_data, descs[i]);
            }
        }
        return seq;
    }

    public synchronized void waitPhase() {
        try {
            while (this.doing_phase) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static class PhaseDescriptor {
        java.lang.String phase_name;
        Hashtable<java.lang.String, Vector<Integer>> totSeqNumbers = new Hashtable();
        Hashtable<java.lang.String, Hashtable<Integer, Vector<Action>>> totSeqActions = new Hashtable();
        Hashtable<MDSplus.Action, Vector<Action>> dependencies = new Hashtable();
        Vector<Action> immediate_actions = new Vector();
        Hashtable<Integer, Action> all_actions = new Hashtable();

        PhaseDescriptor(java.lang.String phase_name) {
            this.phase_name = phase_name;
        }
    }

    class jDispatcherInfoHandler
    extends Thread {
        DataInputStream dis;
        DataOutputStream dos;

        jDispatcherInfoHandler(Socket sock) {
            try {
                this.dis = new DataInputStream(sock.getInputStream());
                this.dos = new DataOutputStream(sock.getOutputStream());
            }
            catch (Exception exc) {
                this.dis = null;
                this.dos = null;
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                block2: while (true) {
                    if (!(command = this.dis.readUTF()).toLowerCase().equals("servers")) {
                        continue;
                    }
                    this.dos.writeInt(jDispatcher.this.servers.size());
                    i = 0;
                    while (true) {
                        if (i < jDispatcher.this.servers.size()) ** break;
                        continue block2;
                        currServer = jDispatcher.this.servers.elementAt(i);
                        serverClass = currServer.getServerClass();
                        address = "";
                        if (currServer instanceof ActionServer) {
                            address = ((ActionServer)currServer).getAddress();
                        }
                        isActive = currServer.isActive();
                        this.dos.writeUTF(serverClass);
                        this.dos.writeUTF(address);
                        this.dos.writeBoolean(isActive);
                        this.dos.flush();
                        ++i;
                    }
                    break;
                }
            }
            catch (Exception var1_2) {
                return;
            }
        }
    }

    class jDispatcherInfo
    extends Thread {
        ServerSocket serverSock;

        jDispatcherInfo(int port) {
            try {
                this.serverSock = new ServerSocket(port);
            }
            catch (Exception exc) {
                System.err.println("Error starting jDispatcher info server: " + exc);
                this.serverSock = null;
            }
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Socket sock = this.serverSock.accept();
                    new jDispatcherInfoHandler(sock).start();
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }
}

