/*
 * Decompiled with CFR 0.152.
 */
package mds.jdispatcher;

import MDSplus.MdsException;
import MDSplus.Tree;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import mds.connection.MdsMessage;
import mds.jdispatcher.ActionServer;
import mds.jdispatcher.Balancer;
import mds.jdispatcher.InfoServer;
import mds.jdispatcher.MdsHelper;
import mds.jdispatcher.MdsIp;
import mds.jdispatcher.MdsMonitor;
import mds.jdispatcher.Server;
import mds.jdispatcher.ServerInfo;
import mds.jdispatcher.jDispatcher;

class jDispatcherIp
extends MdsIp {
    private static final Vector<Server> servers = new Vector();
    private jDispatcher dispatcher;
    private int shot;
    private String currTreeName;
    private Tree tree;

    public static void main(String ... args) {
        String phaseName;
        String monitor_port;
        Properties properties = MdsHelper.initialization(args);
        if (properties == null) {
            System.exit(1);
        }
        Balancer balancer = new Balancer();
        jDispatcher dispatcher = new jDispatcher(balancer);
        dispatcher.addServer(new InfoServer());
        int port = 0;
        try {
            port = Integer.parseInt(properties.getProperty("jDispatcher.port"));
        }
        catch (Exception exc) {
            System.out.println("Cannot read port");
            System.exit(1);
        }
        int info_port = 0;
        try {
            info_port = Integer.parseInt(properties.getProperty("jDispatcher.info_port"));
            dispatcher.startInfoServer(info_port);
        }
        catch (Exception exc) {
            System.out.println("Cannot read info_port");
            System.exit(1);
        }
        System.out.println("Start dispatcher on port " + port);
        jDispatcherIp dispatcherIp = new jDispatcherIp(port, dispatcher, MdsHelper.experiment);
        dispatcherIp.start();
        for (ServerInfo si : MdsHelper.getServers()) {
            ActionServer server = new ActionServer("", si.getAddress(), si.getClassName(), si.getSubTree(), si.isJava(), si.getWarchdogPort());
            servers.add(server);
            dispatcher.addServer(server);
        }
        int i = 1;
        while ((monitor_port = properties.getProperty("jDispatcher.monitor_" + i + ".port")) != null) {
            try {
                int monitor_port_int = Integer.parseInt(monitor_port);
                System.out.println("Start monitor server on port " + monitor_port_int);
                MdsMonitor monitor = new MdsMonitor(monitor_port_int);
                dispatcher.addMonitorListener(monitor);
                monitor.start();
            }
            catch (Exception exc) {
                break;
            }
            ++i;
        }
        String default_server = properties.getProperty("jDispatcher.default_server_idx");
        try {
            int default_server_idx = Integer.parseInt(default_server) - 1;
            Server server = servers.elementAt(default_server_idx);
            dispatcher.setDefaultServer(server);
        }
        catch (Exception default_server_idx) {
            // empty catch block
        }
        int i2 = 1;
        while ((phaseName = properties.getProperty("jDispatcher.phase_" + i2 + ".name")) != null) {
            Vector<Integer> currSynchNumbers = new Vector<Integer>();
            String currSynchStr = properties.getProperty("jDispatcher.phase_" + i2 + ".synch_seq_numbers");
            if (currSynchStr != null) {
                StringTokenizer st = new StringTokenizer(currSynchStr, " ,");
                while (st.hasMoreTokens()) {
                    try {
                        currSynchNumbers.addElement(new Integer(st.nextToken()));
                    }
                    catch (Exception exc) {
                        System.out.println("WARNING: Invalid Syncronization number for phase " + phaseName);
                    }
                }
                dispatcher.addSynchNumbers(phaseName, currSynchNumbers);
            }
            ++i2;
        }
        try {
            dispatcherIp.getListenThread().join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public jDispatcherIp(int port, jDispatcher dispatcher, String treeName) {
        super(port);
        this.dispatcher = dispatcher;
        System.out.println("Tree name per jDispatcherIp : " + treeName);
        try {
            this.tree = new Tree(treeName, -1);
        }
        catch (Exception exc) {
            System.err.println("Cannot open tree " + treeName + ": " + exc);
        }
    }

    protected int doCommand(String command) {
        block43: {
            System.out.println("Command: " + command);
            StringTokenizer st = new StringTokenizer(command, "/ ");
            try {
                String first_part = st.nextToken();
                if (first_part.equals("DISPATCH")) {
                    int nid;
                    String second_part = st.nextToken();
                    if (second_part.equals("BUILD")) {
                        if (!st.hasMoreTokens()) {
                            this.dispatcher.collectDispatchInformation();
                        } else {
                            String buildRoot = st.nextToken();
                            this.dispatcher.collectDispatchInformation(buildRoot);
                        }
                        break block43;
                    }
                    if (second_part.equals("PHASE")) {
                        String third_part = st.nextToken();
                        this.dispatcher.startPhase(third_part);
                        this.dispatcher.waitPhase();
                        break block43;
                    }
                    try {
                        nid = Integer.parseInt(second_part);
                    }
                    catch (Exception ex) {
                        throw new InvalidCommand();
                    }
                    if (!this.dispatcher.dispatchAction(nid)) {
                        throw new Exception("Cannot dispatch action");
                    }
                    break block43;
                }
                if (first_part.equals("CREATE")) {
                    String second_part = st.nextToken();
                    if (second_part.equals("PULSE")) {
                        this.shot = Integer.parseInt(st.nextToken());
                        if (this.shot == 0) {
                            this.shot = this.getCurrentShot();
                        }
                        this.dispatcher.beginSequence(this.shot);
                        break block43;
                    }
                    throw new InvalidCommand();
                }
                if (first_part.equals("SET")) {
                    String second_part = st.nextToken();
                    if (second_part.equals("TREE")) {
                        if (st.hasMoreTokens()) {
                            this.currTreeName = st.nextToken();
                        }
                        try {
                            if (st.hasMoreTokens()) {
                                this.shot = Integer.parseInt(st.nextToken());
                                this.dispatcher.setTree(this.currTreeName, this.shot);
                                break block43;
                            }
                            this.dispatcher.setTree(this.currTreeName);
                        }
                        catch (Exception exc) {
                            System.err.println("Wrong shot number in SET TREE command\n" + exc);
                        }
                        break block43;
                    }
                    if (second_part.equals("CURRENT")) {
                        String third_part = st.nextToken();
                        this.setCurrentShot(Integer.parseInt(third_part));
                        break block43;
                    }
                    throw new InvalidCommand();
                }
                if (first_part.equals("CLOSE")) {
                    this.dispatcher.endSequence(this.shot);
                    break block43;
                }
                if (first_part.equals("ABORT")) {
                    String second_part = st.nextToken();
                    try {
                        if (second_part.toUpperCase().equals("PHASE")) {
                            this.dispatcher.abortPhase();
                        } else {
                            int nid = Integer.parseInt(second_part);
                            this.dispatcher.abortAction(nid);
                        }
                        break block43;
                    }
                    catch (Exception ex) {
                        throw new InvalidCommand();
                    }
                }
                if (first_part.equals("REDISPATCH")) {
                    int nid;
                    String second_part = st.nextToken();
                    String phaseName = null;
                    try {
                        phaseName = st.nextToken();
                    }
                    catch (Exception exc) {
                        phaseName = null;
                    }
                    try {
                        nid = Integer.parseInt(second_part);
                    }
                    catch (Exception ex) {
                        throw new InvalidCommand();
                    }
                    if (phaseName != null) {
                        this.dispatcher.redispatchAction(nid, phaseName);
                    } else {
                        this.dispatcher.redispatchAction(nid);
                    }
                    break block43;
                }
                if (first_part.equals("GET")) {
                    String second_part = st.nextToken();
                    if (second_part.equals("CURRENT")) {
                        System.out.println("Current shot :" + this.getCurrentShot());
                        return this.getCurrentShot();
                    }
                    throw new InvalidCommand();
                }
                if (first_part.equals("INCREMENT")) {
                    String second_part = st.nextToken();
                    if (second_part.equals("CURRENT")) {
                        this.incrementCurrentShot();
                        break block43;
                    }
                    throw new InvalidCommand();
                }
                if (first_part.equals("CHECK")) {
                    if (this.dispatcher.checkEssential()) {
                        return 1;
                    }
                    return 0;
                }
                if (first_part.equals("DO")) {
                    try {
                        String second_part = st.nextToken();
                        this.dispatcher.dispatchAction(second_part);
                        break block43;
                    }
                    catch (Exception exc) {
                        throw new InvalidCommand();
                    }
                }
                throw new InvalidCommand();
            }
            catch (InvalidCommand exc) {
                System.out.println("Command: Invalid " + command);
            }
            catch (Exception exc) {
                System.out.println("Command: Exception " + exc);
                exc.printStackTrace();
            }
        }
        return -1;
    }

    int getCurrentShot() {
        try {
            return this.tree.getCurrent();
        }
        catch (Exception exc) {
            return -1;
        }
    }

    @Override
    public MdsMessage handleMessage(MdsMessage[] messages) {
        int ris = -1;
        String command = "";
        String compositeCommand = "";
        compositeCommand = new String(messages[0].body);
        if (compositeCommand.startsWith("@")) {
            command = compositeCommand.substring(1).toUpperCase();
        } else {
            try {
                StringTokenizer st = new StringTokenizer(compositeCommand, "\"");
                while (!st.nextToken().equals("TCL")) {
                }
                st.nextToken();
                command = st.nextToken().toUpperCase();
            }
            catch (Exception exc) {
                System.err.println("Unexpected message has been received by jDispatcherIp:" + compositeCommand + " " + exc);
            }
        }
        try {
            for (String cmd : command.split("\\s*;\\s*")) {
                ris = this.doCommand(cmd);
            }
        }
        catch (Exception exc) {
            return new MdsMessage(exc.getMessage(), null);
        }
        if (ris < 0) {
            MdsMessage msg = new MdsMessage(1);
            msg.status = 1;
            return msg;
        }
        byte[] buf = new byte[]{(byte)(ris >> 24 & 0xFF), (byte)(ris >> 16 & 0xFF), (byte)(ris >> 8 & 0xFF), (byte)(ris & 0xFF)};
        MdsMessage msg = new MdsMessage(0, 8, 0, new int[]{1}, buf);
        msg.status = 1;
        return msg;
    }

    void incrementCurrentShot() {
        try {
            this.setCurrentShot(this.tree.getCurrent() + 1);
        }
        catch (MdsException e) {
            System.err.println("Error incrementing current shot");
        }
    }

    void setCurrentShot(int shot) {
        try {
            Tree.setCurrent((String)this.currTreeName, (int)shot);
        }
        catch (Exception exc) {
            System.err.println("Error setting current shot");
        }
    }

    public void setDispatcher(jDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    private class InvalidCommand
    extends Exception {
        private static final long serialVersionUID = 1L;

        private InvalidCommand() {
        }
    }
}

