/*
 * Decompiled with CFR 0.152.
 */
package mds.jdispatcher;

import MDSplus.Data;
import MDSplus.MdsException;
import MDSplus.Tree;
import MDSplus.TreeNode;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import mds.connection.MdsMessage;
import mds.jdispatcher.MdsIp;

public class jServer
extends MdsIp {
    static final int SrvNoop = 0;
    static final int SrvAbort = 1;
    static final int SrvAction = 2;
    static final int SrvClose = 3;
    static final int SrvCreatePulse = 4;
    static final int SrvSetLogging = 5;
    static final int SrvCommand = 6;
    static final int SrvMonitor = 7;
    static final int SrvShow = 8;
    static final int SrvStop = 9;
    static final int SrvRemoveLast = 10;
    static final int SrvWatchdogPort = 11;
    static final int SrvJobBEFORE_NOTIFY = 1;
    static final int SrvJobAFTER_NOTIFY = 2;
    static final int SrvJobABORTED = 1;
    static final int SrvJobSTARTING = 2;
    static final int SrvJobFINISHED = 3;
    static final int ServerABORT = 266436658;
    public static int doingNid;
    private final Vector<Socket> retSocketsV = new Vector();
    private Tree mdsTree = null;
    private final ActionQueue actionQueue = new ActionQueue();
    private final Worker worker = new Worker();
    private boolean watchdogStarted = false;
    String lastTree = null;
    int lastShot;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void logServer(Object ... elements) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.print("Server:  ");
            for (Object e : elements) {
                System.out.print(e);
            }
            System.out.println("");
            System.out.flush();
        }
    }

    public static void main(String ... args) {
        int port;
        try {
            System.out.println(args[0]);
            port = Integer.parseInt(args[0]);
        }
        catch (Exception exc) {
            port = 8002;
        }
        if (args.length > 1) {
            String tclBatch = args[1];
            try {
                Data.execute((String)("tcl('@" + tclBatch + "')"), (Data[])new Data[0]);
            }
            catch (Exception exc) {
                System.err.println("Error executing initial TCL batch: " + exc);
            }
        }
        jServer server = new jServer(port);
        server.start();
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        try {
            while (true) {
                String command;
                if (!(command = br.readLine()).equals("exit")) {
                    continue;
                }
                server.closeAll();
                System.exit(0);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    jServer(int port) {
        super(port);
    }

    public void closeAll() {
        for (int i = 0; i < this.retSocketsV.size(); ++i) {
            Socket currSock = this.retSocketsV.elementAt(i);
            if (currSock == null) continue;
            try {
                currSock.shutdownInput();
                currSock.shutdownOutput();
                currSock.close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    int doSimpleAction(String name, String tree, int shot) {
        int status = 0;
        try {
            TreeNode node;
            if (this.mdsTree != null) {
                this.mdsTree.close();
            }
            this.mdsTree = new Tree(tree, shot);
            this.lastTree = tree;
            this.lastShot = shot;
            try {
                node = this.mdsTree.getNode(name);
            }
            catch (MdsException exc) {
                jServer.logServer(new Object[]{"Cannot Find Node ", name, " : ", exc});
                jServer.logServer("Tree: ", this.mdsTree.getName(), " Shot: ", this.mdsTree.getShot());
                return Integer.MIN_VALUE;
            }
            doingNid = node.getNid();
            try {
                Data.execute((String)("DevSetDoingNid(" + doingNid + ")"), (Data[])new Data[0]);
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                name = node.getFullPath();
            }
            catch (MdsException exc) {
                jServer.logServer("Cannot resolve path of ", node);
                return Integer.MIN_VALUE;
            }
            jServer.logServer(new Date(), ", Doing ", name, " in ", tree, " shot ", shot);
            Data[] last_error_args = new Data[]{Data.toData((String)tree), Data.toData((int)shot), Data.toData((String)name)};
            Data.execute((String)"DevClearLastError($,$,$)", (Data[])last_error_args);
            try {
                status = node.doAction();
            }
            catch (MdsException exc) {
                jServer.logServer(new Object[]{"Dispatch failed ", name, " : ", exc});
                status = Integer.MIN_VALUE;
            }
            if ((status & 1) != 0) {
                jServer.logServer(new Date(), ", Done ", name, " in ", tree, " shot ", shot);
            } else {
                String errDevMsg = Data.execute((String)"DevGetLastError($,$,$)", (Data[])last_error_args).getString();
                String errMsg = Data.getMdsMsg((int)status);
                jServer.logServer(new Date(), ", Failed ", name, " in ", tree, " shot ", shot, ": ", errMsg, "; ", errDevMsg);
            }
        }
        catch (Exception exc) {
            jServer.logServer(new Date() + ", Failed ", name, " in ", tree, " shot ", shot, " : ", exc);
        }
        return status;
    }

    synchronized Socket getRetSocket(InetAddress ip, int port) {
        for (int i = 0; i < this.retSocketsV.size(); ++i) {
            Socket currSock = this.retSocketsV.elementAt(i);
            if (!currSock.getInetAddress().equals(ip) || currSock.getPort() != port || currSock.isInputShutdown()) continue;
            return currSock;
        }
        try {
            Socket newSock = new Socket(ip, port);
            this.retSocketsV.addElement(newSock);
            return newSock;
        }
        catch (Exception exc) {
            return null;
        }
    }

    @Override
    public MdsMessage handleMessage(MdsMessage[] messages) {
        block21: {
            String command = "";
            try {
                command = new String(messages[0].body);
                if (command.toLowerCase().startsWith("kill")) {
                    Timer timer = new Timer();
                    timer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            System.exit(0);
                        }
                    }, 500L);
                }
                if (!command.startsWith("ServerQAction")) break block21;
                InetAddress address = InetAddress.getByAddress(messages[1].body);
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(messages[2].body));
                short port = dis.readShort();
                dis = new DataInputStream(new ByteArrayInputStream(messages[3].body));
                int operation = dis.readInt();
                dis = new DataInputStream(new ByteArrayInputStream(messages[4].body));
                dis.readInt();
                dis = new DataInputStream(new ByteArrayInputStream(messages[5].body));
                int id = dis.readInt();
                switch (operation) {
                    case 2: {
                        String tree = new String(messages[6].body);
                        dis = new DataInputStream(new ByteArrayInputStream(messages[7].body));
                        int shot = dis.readInt();
                        String name = new String(messages[8].body);
                        this.actionQueue.enqueueAction(new ActionDescriptor(name, address, port, id, tree, shot));
                        break;
                    }
                    case 1: {
                        boolean flush;
                        dis = new DataInputStream(new ByteArrayInputStream(messages[6].body));
                        int flushInt = dis.readInt();
                        boolean bl = flush = flushInt != 0;
                        if (flush) {
                            this.actionQueue.dequeueAllActions();
                        }
                        this.worker.abortCurrentAction();
                        break;
                    }
                    case 3: {
                        String answer = "" + id + " " + 3 + " 1 0";
                        if (this.mdsTree != null) {
                            try {
                                this.mdsTree.close();
                                this.mdsTree = null;
                            }
                            catch (Exception exc) {
                                this.mdsTree = null;
                            }
                        }
                        this.writeAnswer(address, port, answer);
                        break;
                    }
                    case 4: {
                        String tree = new String(messages[6].body);
                        dis = new DataInputStream(new ByteArrayInputStream(messages[10].body));
                        int shot = dis.readInt();
                        String answer = "" + id + " " + 3 + " 1 0";
                        this.writeAnswer(address, port, answer);
                        break;
                    }
                    case 6: {
                        command = new String(messages[7].body);
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 11: {
                        dis = new DataInputStream(new ByteArrayInputStream(messages[6].body));
                        try {
                            int watchdogPort = dis.readInt();
                            this.startWatchdog(watchdogPort);
                        }
                        catch (Exception exc) {
                            jServer.logServer("Error getting watchdog port: ", exc);
                        }
                        this.removeAllRetSocket();
                        break;
                    }
                    case 10: {
                        if (this.actionQueue.removeLast()) {
                            MdsMessage msg = new MdsMessage(0, 8, 0, (int[])null, new byte[]{0, 0, 0, 1});
                            msg.status = 1;
                            return msg;
                        }
                        MdsMessage msg = new MdsMessage(0, 8, 0, (int[])null, new byte[]{0, 0, 0, 0});
                        msg.status = 1;
                        return msg;
                    }
                    default: {
                        jServer.logServer("Unknown Operation: ", operation);
                    }
                }
            }
            catch (Exception exc) {
                System.err.println(exc);
            }
        }
        MdsMessage msg = new MdsMessage(0, 8, 0, (int[])null, new byte[]{0, 0, 0, 0});
        msg.status = 1;
        return msg;
    }

    synchronized void removeAllRetSocket() {
        this.retSocketsV.removeAllElements();
    }

    synchronized void removeRetSocket(Socket sock) {
        this.retSocketsV.remove(sock);
    }

    @Override
    public void run() {
        this.worker.setName(String.format("Worker(%d)", this.port));
        this.worker.setDaemon(true);
        this.worker.start();
        super.run();
    }

    void startWatchdog(int watchdogPort) {
        if (this.watchdogStarted) {
            return;
        }
        new WatchdogHandler(watchdogPort).start();
        this.watchdogStarted = true;
    }

    @Override
    public void stop() {
        this.closeAll();
        this.stopRequest = true;
        this.worker.interrupt();
        super.stop();
    }

    synchronized Socket updateRetSocket(InetAddress ip, int port) {
        for (int i = 0; i < this.retSocketsV.size(); ++i) {
            Socket currSock = this.retSocketsV.elementAt(i);
            if (!currSock.getInetAddress().equals(ip) || currSock.getPort() != port || currSock.isInputShutdown()) continue;
            this.retSocketsV.remove(currSock);
            break;
        }
        try {
            Socket newSock = new Socket(ip, port);
            this.retSocketsV.addElement(newSock);
            return newSock;
        }
        catch (Exception exc) {
            jServer.logServer("Error creating socket for answers");
            return null;
        }
    }

    synchronized void writeAnswer(InetAddress ip, int port, String answer) {
        try {
            int i;
            Socket sock = this.getRetSocket(ip, port);
            DataOutputStream dos = new DataOutputStream(sock.getOutputStream());
            byte[] answerMsg = answer.getBytes();
            byte[] retMsg = new byte[60];
            for (i = 0; i < answerMsg.length; ++i) {
                retMsg[i] = answerMsg[i];
            }
            for (i = answerMsg.length; i < 60; ++i) {
                retMsg[i] = 0;
            }
            try {
                dos.write(retMsg);
                dos.flush();
            }
            catch (Exception exc) {
                sock.close();
                jServer.logServer("Connection to jDispatcher lost: ", exc);
                exc.printStackTrace();
                this.updateRetSocket(ip, port);
                sock = this.getRetSocket(ip, port);
                dos = new DataOutputStream(sock.getOutputStream());
                dos.write(retMsg);
                dos.flush();
                sock.close();
            }
        }
        catch (Exception exc) {
            jServer.logServer("Error sending answer: ", exc);
        }
    }

    static /* synthetic */ void access$000(Object[] x0) {
        jServer.logServer(x0);
    }

    class Worker
    extends Thread {
        ActionDescriptor currAction;
        int retStatus = 0;
        boolean currentActionAborted = false;

        Worker() {
        }

        public synchronized void abortCurrentAction() {
            this.currentActionAborted = true;
            this.notify();
        }

        public synchronized void awakeWorker() {
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!jServer.this.stopRequest) {
                String answer;
                ActionMaker currMaker;
                try {
                    this.currAction = jServer.this.actionQueue.nextAction();
                }
                catch (InterruptedException e) {
                    continue;
                }
                String message = "" + this.currAction.getId() + " " + 2 + " 1 0";
                jServer.this.writeAnswer(this.currAction.getAddress(), this.currAction.getPort(), message);
                Worker worker = this;
                synchronized (worker) {
                    this.currentActionAborted = false;
                    currMaker = new ActionMaker(this.currAction);
                    currMaker.start();
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.currentActionAborted) {
                    currMaker.setAborted();
                    answer = "" + this.currAction.getId() + " " + 1 + " 1 0";
                    jServer.this.writeAnswer(this.currAction.getAddress(), this.currAction.getPort(), answer);
                    continue;
                }
                answer = "" + this.currAction.getId() + " " + 3 + " " + this.retStatus + " 0";
                jServer.this.writeAnswer(this.currAction.getAddress(), this.currAction.getPort(), answer);
            }
        }

        class ActionMaker
        extends Thread {
            boolean aborted = false;
            ActionDescriptor action;

            ActionMaker(ActionDescriptor action) {
                this.action = action;
            }

            @Override
            public void run() {
                int status = jServer.this.doSimpleAction(this.action.getName(), this.action.getTree(), this.action.getShot());
                if (!this.aborted) {
                    Worker.this.retStatus = status;
                    Worker.this.awakeWorker();
                }
            }

            public void setAborted() {
                this.aborted = true;
            }
        }
    }

    class WatchdogHandler
    extends Thread {
        int port;

        WatchdogHandler(int port) {
            this.port = port;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                serverSock = new ServerSocket(this.port);
                var2_3 = null;
                block18: while (true) {
                    try {
                        try {
                            while (true) lbl-1000:
                            // 4 sources

                            {
                                sock = serverSock.accept();
                                var4_6 = null;
                                try {
                                    dis = new DataInputStream(sock.getInputStream());
                                    dos = new DataOutputStream(sock.getOutputStream());
                                    try {
                                        while (true) {
                                            dos.writeInt(dis.readInt());
                                            dos.flush();
                                        }
                                    }
                                    catch (Exception var7_11) {
                                        if (sock == null) continue;
                                        if (var4_6 != null) {
                                            try {
                                                sock.close();
                                            }
                                            catch (Throwable var5_8) {
                                                var4_6.addSuppressed(var5_8);
                                                continue;
                                            }
                                            continue block18;
                                        }
                                        sock.close();
                                        continue;
                                    }
                                }
                                catch (Throwable var5_9) {
                                    try {
                                        var4_6 = var5_9;
                                        throw var5_9;
                                    }
                                    catch (Throwable var8_12) {
                                        if (sock != null) {
                                            if (var4_6 != null) {
                                                try {
                                                    sock.close();
                                                }
                                                catch (Throwable var9_13) {
                                                    var4_6.addSuppressed(var9_13);
                                                }
                                            } else {
                                                sock.close();
                                            }
                                        }
                                        throw var8_12;
                                    }
                                }
                                break;
                            }
                        }
                        catch (Throwable var3_5) {
                            var2_3 = var3_5;
                            throw var3_5;
                        }
                        {
                            ** while (true)
                        }
                    }
                    catch (Throwable var10_14) {
                        if (serverSock != null) {
                            if (var2_3 != null) {
                                try {
                                    serverSock.close();
                                }
                                catch (Throwable var11_15) {
                                    var2_3.addSuppressed(var11_15);
                                }
                            } else {
                                serverSock.close();
                            }
                        }
                        throw var10_14;
                    }
                    break;
                }
            }
            catch (Exception exc) {
                jServer.access$000(new Object[]{"Error accepting watchdog: ", exc});
                return;
            }
        }
    }

    class ActionQueue {
        Vector<ActionDescriptor> actionV = new Vector();

        ActionQueue() {
        }

        void dequeueAllActions() {
            this.actionV.removeAllElements();
        }

        synchronized void enqueueAction(ActionDescriptor actionDescr) {
            this.actionV.addElement(actionDescr);
            this.notify();
        }

        synchronized ActionDescriptor nextAction() throws InterruptedException {
            while (this.actionV.size() == 0) {
                this.wait();
            }
            ActionDescriptor retAction = this.actionV.elementAt(0);
            this.actionV.removeElementAt(0);
            return retAction;
        }

        synchronized boolean removeLast() {
            if (this.actionV.size() > 0) {
                this.actionV.removeElementAt(this.actionV.size() - 1);
                return true;
            }
            return false;
        }
    }

    static class ActionDescriptor {
        InetAddress address;
        int port;
        int id;
        String tree;
        String name;
        int shot;

        ActionDescriptor(String name, InetAddress address, int port, int id, String tree, int shot) {
            this.name = name;
            this.address = address;
            this.port = port;
            this.id = id;
            this.tree = tree;
            this.shot = shot;
        }

        final InetAddress getAddress() {
            return this.address;
        }

        final int getId() {
            return this.id;
        }

        final String getName() {
            return this.name;
        }

        final int getPort() {
            return this.port;
        }

        final int getShot() {
            return this.shot;
        }

        final String getTree() {
            return this.tree;
        }
    }
}

