/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core;

import com.predic8.membrane.core.config.spring.CheckableBeanFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractRefreshableApplicationContext;

public class HotDeploymentThread
extends Thread {
    private static Logger log = LoggerFactory.getLogger((String)HotDeploymentThread.class.getName());
    private List<FileInfo> files = new ArrayList<FileInfo>();
    protected AbstractRefreshableApplicationContext applicationContext;
    private boolean reloading;

    public HotDeploymentThread(AbstractRefreshableApplicationContext applicationContext) {
        super("Membrane Hot Deployment Thread");
        this.applicationContext = applicationContext;
    }

    public void setFiles(List<File> files) {
        this.files.clear();
        for (File file : files) {
            FileInfo fi = new FileInfo();
            fi.file = file.getAbsolutePath();
            this.files.add(fi);
        }
        this.updateLastModified();
    }

    private void updateLastModified() {
        for (FileInfo fi : this.files) {
            fi.lastModified = new File(fi.file).lastModified();
        }
    }

    private boolean configurationChanged() {
        for (FileInfo fi : this.files) {
            if (new File(fi.file).lastModified() <= fi.lastModified) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        log.debug("Spring Hot Deployment Thread started.");
        while (!this.isInterrupted()) {
            try {
                while (!this.configurationChanged()) {
                    HotDeploymentThread.sleep(1000L);
                }
                log.debug("spring configuration changed.");
                if (this.applicationContext instanceof CheckableBeanFactory) {
                    ((CheckableBeanFactory)this.applicationContext).checkForInvalidBeanDefinitions();
                }
                this.reload();
                break;
            }
            catch (CheckableBeanFactory.InvalidConfigurationException e) {
                log.error(e.getMessage());
                log.error("Application context was NOT restarted. Please fix the error in the configuration file.");
                this.updateLastModified();
            }
            catch (InterruptedException e) {
                this.interrupt();
            }
            catch (Exception e) {
                log.error("Could not redeploy.", (Throwable)e);
                this.updateLastModified();
            }
        }
        log.debug("Spring Hot Deployment Thread interrupted.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reload() throws Exception {
        HotDeploymentThread hotDeploymentThread = this;
        synchronized (hotDeploymentThread) {
            this.reloading = true;
        }
        this.applicationContext.stop();
        this.applicationContext.refresh();
        this.applicationContext.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopASAP() {
        HotDeploymentThread hotDeploymentThread = this;
        synchronized (hotDeploymentThread) {
            if (this.reloading) {
                return;
            }
        }
        this.interrupt();
    }

    private static class FileInfo {
        public String file;
        public long lastModified;

        private FileInfo() {
        }
    }
}

