/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.annot.MCMain;
import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.HotDeploymentThread;
import com.predic8.membrane.core.RuleManager;
import com.predic8.membrane.core.Statistics;
import com.predic8.membrane.core.config.spring.BaseLocationApplicationContext;
import com.predic8.membrane.core.config.spring.TrackingApplicationContext;
import com.predic8.membrane.core.config.spring.TrackingFileSystemXmlApplicationContext;
import com.predic8.membrane.core.exchangestore.ExchangeStore;
import com.predic8.membrane.core.exchangestore.LimitedMemoryExchangeStore;
import com.predic8.membrane.core.interceptor.Interceptor;
import com.predic8.membrane.core.jmx.JmxExporter;
import com.predic8.membrane.core.jmx.JmxRouter;
import com.predic8.membrane.core.kubernetes.KubernetesWatcher;
import com.predic8.membrane.core.kubernetes.client.KubernetesClientFactory;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.rules.InternalProxy;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.transport.Transport;
import com.predic8.membrane.core.transport.http.HttpClientFactory;
import com.predic8.membrane.core.transport.http.HttpServerThreadFactory;
import com.predic8.membrane.core.transport.http.HttpTransport;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import com.predic8.membrane.core.util.DNSCache;
import com.predic8.membrane.core.util.TimerManager;
import com.predic8.membrane.core.util.URIFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.Lifecycle;
import org.springframework.context.support.AbstractRefreshableApplicationContext;

@MCMain(outputPackage="com.predic8.membrane.core.config.spring", outputName="router-conf.xsd", targetNamespace="http://membrane-soa.org/proxies/1/")
@MCElement(name="router")
public class Router
implements Lifecycle,
ApplicationContextAware,
BeanNameAware {
    private static final Logger log = LoggerFactory.getLogger((String)Router.class.getName());
    protected static final HashSet<ApplicationContext> hotDeployingContexts = new HashSet();
    private ApplicationContext beanFactory;
    private String baseLocation;
    protected RuleManager ruleManager = new RuleManager();
    protected ExchangeStore exchangeStore;
    protected Transport transport;
    protected ResolverMap resolverMap;
    protected DNSCache dnsCache = new DNSCache();
    protected ExecutorService backgroundInitializator = Executors.newSingleThreadExecutor(new HttpServerThreadFactory("Router Background Initializator"));
    protected HotDeploymentThread hdt;
    protected URIFactory uriFactory = new URIFactory(false);
    protected Statistics statistics = new Statistics();
    protected String jmxRouterName;
    private boolean hotDeploy = true;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private boolean running;
    private int retryInitInterval = 300000;
    private boolean retryInit;
    private Timer reinitializator;
    private String id;
    private final KubernetesWatcher kubernetesWatcher = new KubernetesWatcher(this);
    private final TimerManager timerManager = new TimerManager();
    private final HttpClientFactory httpClientFactory = new HttpClientFactory(this.timerManager);
    private final KubernetesClientFactory kubernetesClientFactory = new KubernetesClientFactory(this.httpClientFactory);

    public Router() {
        this.ruleManager.setRouter(this);
        this.resolverMap = new ResolverMap(this.timerManager, this.httpClientFactory, this.kubernetesClientFactory);
        this.resolverMap.addRuleResolver(this);
    }

    public Collection<Rule> getRules() {
        return this.getRuleManager().getRulesBySource(RuleManager.RuleDefinitionSource.SPRING);
    }

    @MCChildElement(order=3)
    public void setRules(Collection<Rule> proxies) {
        for (Rule rule : proxies) {
            this.getRuleManager().addProxy(rule, RuleManager.RuleDefinitionSource.SPRING);
        }
    }

    public static Router init(String configFileName) throws MalformedURLException {
        log.debug("loading spring config from classpath: " + configFileName);
        return Router.init(configFileName, Router.class.getClassLoader());
    }

    public static Router init(String resource, ClassLoader classLoader) {
        log.debug("loading spring config: " + resource);
        TrackingFileSystemXmlApplicationContext beanFactory = new TrackingFileSystemXmlApplicationContext(new String[]{resource}, false);
        beanFactory.setClassLoader(classLoader);
        beanFactory.refresh();
        beanFactory.start();
        return (Router)beanFactory.getBean("router");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.beanFactory = applicationContext;
        if (applicationContext instanceof BaseLocationApplicationContext) {
            this.setBaseLocation(((BaseLocationApplicationContext)applicationContext).getBaseLocation());
        }
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public void setRuleManager(RuleManager ruleManager) {
        this.ruleManager = ruleManager;
        ruleManager.setRouter(this);
    }

    public ExchangeStore getExchangeStore() {
        return this.exchangeStore;
    }

    @MCAttribute
    public void setExchangeStore(ExchangeStore exchangeStore) {
        this.exchangeStore = exchangeStore;
    }

    public Transport getTransport() {
        return this.transport;
    }

    @MCChildElement(order=1, allowForeign=true)
    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public HttpClientConfiguration getHttpClientConfig() {
        return this.resolverMap.getHTTPSchemaResolver().getHttpClientConfig();
    }

    @MCChildElement
    public void setHttpClientConfig(HttpClientConfiguration httpClientConfig) {
        this.resolverMap.getHTTPSchemaResolver().setHttpClientConfig(httpClientConfig);
    }

    public DNSCache getDnsCache() {
        return this.dnsCache;
    }

    public ResolverMap getResolverMap() {
        return this.resolverMap;
    }

    public void shutdown() throws IOException {
        this.backgroundInitializator.shutdown();
        if (this.transport != null) {
            this.transport.closeAll();
        }
        this.timerManager.shutdown();
    }

    public void shutdownAll() throws IOException {
        for (String s : this.getBeanFactory().getBeanNamesForType(Router.class)) {
            ((Router)this.getBeanFactory().getBean(s)).shutdown();
        }
    }

    @Deprecated
    public void shutdownNoWait() throws IOException {
        this.shutdown();
    }

    public ExecutorService getBackgroundInitializator() {
        return this.backgroundInitializator;
    }

    public Rule getParentProxy(Interceptor interceptor) {
        for (Rule r : this.getRuleManager().getRules()) {
            if (r.getInterceptors() == null) continue;
            for (Interceptor i : r.getInterceptors()) {
                if (i != interceptor) continue;
                return r;
            }
        }
        throw new IllegalArgumentException("No parent proxy found for the given interceptor.");
    }

    public void add(Rule rule) throws IOException {
        this.ruleManager.addProxyAndOpenPortIfNew(rule);
    }

    public void init() throws Exception {
        this.initInternalProxies();
        this.initRemainingRules();
        this.transport.init(this);
    }

    private void initRemainingRules() throws Exception {
        for (Rule rule : this.getRuleManager().getRules().stream().filter(r -> !(r instanceof InternalProxy)).collect(Collectors.toList())) {
            rule.init(this);
        }
    }

    private void initInternalProxies() throws Exception {
        for (Rule rule : this.getRuleManager().getRules().stream().filter(r -> r instanceof InternalProxy).collect(Collectors.toList())) {
            rule.init(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            if (this.transport == null && this.beanFactory != null && this.beanFactory.getBeansOfType(Transport.class).values().size() > 0) {
                throw new RuntimeException("unclaimed transport detected. - please migrate to 4.0");
            }
            if (this.exchangeStore == null) {
                this.exchangeStore = new LimitedMemoryExchangeStore();
            }
            if (this.transport == null) {
                this.transport = new HttpTransport();
            }
            this.kubernetesWatcher.start();
            this.init();
            this.initJmx();
            this.getRuleManager().openPorts();
            try {
                if (this.hotDeploy) {
                    this.startHotDeployment();
                }
            }
            catch (Exception e) {
                this.shutdown();
                throw e;
            }
            if (this.retryInitInterval > 0) {
                this.startAutoReinitializator();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.startJmx();
        Object object = this.lock;
        synchronized (object) {
            this.running = true;
        }
        log.info("Membrane Service Proxy " + Constants.VERSION + " up and running!");
    }

    private void startJmx() {
        if (this.getBeanFactory() != null) {
            try {
                ((JmxExporter)((Object)this.getBeanFactory().getBean("jmxExporter"))).initAfterBeansAdded();
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
    }

    private void initJmx() {
        if (this.beanFactory != null) {
            try {
                JmxExporter exporter = (JmxExporter)((Object)this.beanFactory.getBean("jmxExporter"));
                exporter.addBean("org.membrane-soa:00=routers, name=" + this.jmxRouterName, new JmxRouter(this, exporter));
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startHotDeployment() {
        if (this.hdt != null) {
            throw new IllegalStateException("Hot deployment already started.");
        }
        if (!(this.beanFactory instanceof TrackingApplicationContext)) {
            throw new RuntimeException("ApplicationContext is not a TrackingApplicationContext. Please set <router hotDeploy=\"false\">.");
        }
        if (!(this.beanFactory instanceof AbstractRefreshableApplicationContext)) {
            throw new RuntimeException("ApplicationContext is not a AbstractRefreshableApplicationContext. Please set <router hotDeploy=\"false\">.");
        }
        HashSet<ApplicationContext> hashSet = hotDeployingContexts;
        synchronized (hashSet) {
            if (hotDeployingContexts.contains(this.beanFactory)) {
                return;
            }
            hotDeployingContexts.add(this.beanFactory);
        }
        this.hdt = new HotDeploymentThread((AbstractRefreshableApplicationContext)this.beanFactory);
        this.hdt.setFiles(((TrackingApplicationContext)this.beanFactory).getFiles());
        this.hdt.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopHotDeployment() {
        this.stopAutoReinitializator();
        if (this.hdt != null) {
            this.hdt.stopASAP();
            this.hdt = null;
            HashSet<ApplicationContext> hashSet = hotDeployingContexts;
            synchronized (hashSet) {
                hotDeployingContexts.remove(this.beanFactory);
            }
        }
    }

    private void startAutoReinitializator() {
        if (this.getInactiveRules().isEmpty()) {
            return;
        }
        this.reinitializator = new Timer("auto reinitializator", true);
        this.reinitializator.schedule(new TimerTask(){

            @Override
            public void run() {
                Router.this.tryReinitialization();
            }
        }, this.retryInitInterval, (long)this.retryInitInterval);
    }

    public void tryReinitialization() {
        boolean stillFailing = false;
        ArrayList<Rule> inactive = this.getInactiveRules();
        if (inactive.size() > 0) {
            log.info("Trying to activate all inactive rules.");
            for (Rule rule : inactive) {
                try {
                    Rule newRule = rule.clone();
                    if (!newRule.isActive()) {
                        log.info("New rule is still not active.");
                        stillFailing = true;
                    }
                    this.getRuleManager().replaceRule(rule, newRule);
                }
                catch (CloneNotSupportedException e) {
                    log.error("", (Throwable)e);
                }
            }
        }
        if (stillFailing) {
            log.info("There are still inactive rules.");
        } else {
            this.stopAutoReinitializator();
            log.info("All rules have been initialized.");
        }
    }

    private void stopAutoReinitializator() {
        Timer reinitializator2 = this.reinitializator;
        if (reinitializator2 != null) {
            reinitializator2.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.kubernetesWatcher.stop();
            if (this.hdt != null) {
                this.stopHotDeployment();
            }
            this.shutdown();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Object object = this.lock;
        synchronized (object) {
            this.running = false;
            this.lock.notifyAll();
        }
    }

    public void stopAll() {
        for (String s : this.getBeanFactory().getBeanNamesForType(Router.class)) {
            ((Router)this.getBeanFactory().getBean(s)).stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lock;
        synchronized (object) {
            return this.running;
        }
    }

    @MCAttribute
    public void setHotDeploy(boolean hotDeploy) {
        if (this.isRunning()) {
            if (this.hotDeploy && !hotDeploy) {
                this.stopHotDeployment();
            }
            if (!this.hotDeploy && hotDeploy) {
                this.startHotDeployment();
            }
        }
        this.hotDeploy = hotDeploy;
    }

    public boolean isHotDeploy() {
        return this.hotDeploy;
    }

    public int getRetryInitInterval() {
        return this.retryInitInterval;
    }

    @MCAttribute
    public void setRetryInitInterval(int retryInitInterval) {
        this.retryInitInterval = retryInitInterval;
    }

    private ArrayList<Rule> getInactiveRules() {
        ArrayList<Rule> inactive = new ArrayList<Rule>();
        for (Rule rule : this.getRuleManager().getRules()) {
            if (rule.isActive()) continue;
            inactive.add(rule);
        }
        return inactive;
    }

    public String getBaseLocation() {
        return this.baseLocation;
    }

    public void setBaseLocation(String baseLocation) {
        this.baseLocation = baseLocation;
    }

    public ApplicationContext getBeanFactory() {
        return this.beanFactory;
    }

    public boolean isRetryInit() {
        return this.retryInit;
    }

    @MCAttribute
    public void setRetryInit(boolean retryInit) {
        this.retryInit = retryInit;
    }

    public URIFactory getUriFactory() {
        return this.uriFactory;
    }

    @MCChildElement(order=-1, allowForeign=true)
    public void setUriFactory(URIFactory uriFactory) {
        this.uriFactory = uriFactory;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    @MCAttribute
    public void setJmx(String name) {
        this.jmxRouterName = name;
    }

    public String getJmx() {
        return this.jmxRouterName;
    }

    public void setBeanName(String s) {
        this.id = s;
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.isRunning()) {
                this.lock.wait();
            }
        }
    }

    public TimerManager getTimerManager() {
        return this.timerManager;
    }

    public KubernetesClientFactory getKubernetesClientFactory() {
        return this.kubernetesClientFactory;
    }

    public HttpClientFactory getHttpClientFactory() {
        return this.httpClientFactory;
    }
}

