/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core;

import com.predic8.membrane.core.MembraneCommandLine;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.config.spring.CheckableBeanFactory;
import com.predic8.membrane.core.config.spring.TrackingFileSystemXmlApplicationContext;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.resolver.ResourceRetrievalException;
import com.predic8.membrane.core.transport.PortOccupiedException;
import com.predic8.membrane.core.util.ExitException;
import com.predic8.membrane.core.util.OSUtil;
import java.io.File;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionStoreException;

public class RouterCLI {
    private static final Logger LOG = LoggerFactory.getLogger(RouterCLI.class);

    public static void main(String[] args) {
        MembraneCommandLine cl = RouterCLI.getMembraneCommandLine(args);
        Router router = null;
        try {
            try {
                router = Router.init(RouterCLI.getRulesFile(cl), RouterCLI.class.getClassLoader());
            }
            catch (XmlBeanDefinitionStoreException e) {
                TrackingFileSystemXmlApplicationContext.handleXmlBeanDefinitionStoreException(e);
            }
        }
        catch (CheckableBeanFactory.InvalidConfigurationException e) {
            System.err.println("Fatal error: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception ex) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)ex);
            if (rootCause instanceof ExitException) {
                ExitException ee = (ExitException)rootCause;
                RouterCLI.handleExitException(ee);
            } else if (rootCause instanceof PortOccupiedException) {
                PortOccupiedException poe = (PortOccupiedException)rootCause;
                RouterCLI.handlePortOccupiedException(poe);
            } else {
                ex.printStackTrace();
            }
            System.exit(1);
        }
        try {
            if (router != null) {
                router.waitFor();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static MembraneCommandLine getMembraneCommandLine(String[] args) {
        MembraneCommandLine cl = new MembraneCommandLine();
        try {
            cl.parse(args);
        }
        catch (ParseException e) {
            System.err.println("Error parsing commandline " + e.getMessage());
            cl.printUsage();
            System.exit(1);
        }
        if (cl.needHelp()) {
            cl.printUsage();
            System.exit(0);
        }
        return cl;
    }

    private static void handlePortOccupiedException(PortOccupiedException poe) {
        RouterCLI.printStars();
        System.err.println();
        System.err.printf("Membrane is configured to open port %d. But this port is alreay in\n", poe.getPort());
        System.err.println("use by a different program. To start Membrane do one of the following:\n\n1. Find and stop the program that is occupying the port. Then restart Membrane.");
        System.err.println();
        switch (OSUtil.getOS()) {
            case WINDOWS: {
                RouterCLI.printHowToFindPortWindows();
                break;
            }
            case LINUX: 
            case MAC: {
                RouterCLI.printHowToFindPortLinux();
            }
        }
        System.err.println("2. Configure Membrane to use a different port. Propably in the conf/proxies.xml\nfile. Then restart Membrane.\n");
    }

    private static void printHowToFindPortWindows() {
        System.err.println("netstat -aon | find /i \"listening\"\n");
    }

    private static void printHowToFindPortLinux() {
        System.err.println("e.g.:\n> lsof -i :2000\nCOMMAND    PID    USER  TYPE\njava     80910 predic8  IPv6  TCP  (LISTEN)\n> kill -9 80910\n");
    }

    private static void handleExitException(ExitException exitException) {
        RouterCLI.printStars();
        System.err.println();
        System.err.println(exitException.getMessage());
        System.err.println();
    }

    private static void printStars() {
        System.err.println("**********************************************************************************");
    }

    private static String getRulesFile(MembraneCommandLine line) {
        ResolverMap rm = new ResolverMap();
        if (line.hasConfiguration()) {
            String s = line.getConfiguration().replaceAll("\\\\", "/");
            if (s.startsWith("file:") || s.startsWith("/") || s.length() > 3 && s.startsWith(":/", 1)) {
                try {
                    rm.resolve(s);
                    return s;
                }
                catch (ResourceRetrievalException e) {
                    System.err.println("Could not open Membrane's configuration file: " + s + " not found.");
                    System.exit(1);
                }
            }
            return RouterCLI.getRulesFileFromRelativeSpec(rm, s, "");
        }
        Object errorNotice = "Please specify the location of Membrane's proxies.xml configuration file using the -c command line option.";
        errorNotice = System.getenv("MEMBRANE_HOME") != null ? (String)errorNotice + " Or create the file in MEMBRANE_HOME/conf (" + System.getenv("MEMBRANE_HOME") + "/conf/proxies.xml)." : (String)errorNotice + " You can also point the MEMBRANE_HOME environment variable to Membrane's distribution root directory and ensure that MEMBRANE_HOME/conf/proxies.xml exists.";
        return RouterCLI.getRulesFileFromRelativeSpec(rm, "conf/proxies.xml", (String)errorNotice);
    }

    private static String getRulesFileFromRelativeSpec(ResolverMap rm, String relativeFile, String errorNotice) {
        String membraneHome = System.getenv("MEMBRANE_HOME");
        Object userDir = System.getProperty("user.dir").replaceAll("\\\\", "/");
        if (!((String)userDir).endsWith("/")) {
            userDir = (String)userDir + "/";
        }
        String try1 = ResolverMap.combine(RouterCLI.prefix((String)userDir), relativeFile);
        try {
            rm.resolve(try1);
            return try1;
        }
        catch (ResourceRetrievalException resourceRetrievalException) {
            String try2 = null;
            if (membraneHome != null) {
                try2 = ResolverMap.combine(RouterCLI.prefix(membraneHome), relativeFile);
                try {
                    rm.resolve(try2);
                    return try2;
                }
                catch (ResourceRetrievalException resourceRetrievalException2) {
                    // empty catch block
                }
            }
            System.err.println("Could not find Membrane's configuration file at " + try1 + (String)(try2 == null ? "" : " and not at " + try2) + " . " + errorNotice);
            System.exit(1);
            throw new RuntimeException();
        }
    }

    private static String prefix(String dir) {
        File file = new File(dir);
        if (file.isAbsolute()) {
            return file.toURI().toString();
        }
        return dir;
    }
}

