/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.cloud.etcd;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.cloud.etcd.EtcdNodeInformation;
import com.predic8.membrane.core.cloud.etcd.EtcdRequest;
import com.predic8.membrane.core.cloud.etcd.EtcdResponse;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.interceptor.balancer.LoadBalancingInterceptor;
import com.predic8.membrane.core.interceptor.balancer.Node;
import com.predic8.membrane.core.rules.ServiceProxy;
import com.predic8.membrane.core.rules.ServiceProxyKey;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.StaticSSLContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.Lifecycle;

@MCElement(name="etcdBasedConfigurator")
public class EtcdBasedConfigurator
implements ApplicationContextAware,
Lifecycle,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger((String)EtcdBasedConfigurator.class.getName());
    private ApplicationContext context;
    private int port = 8080;
    private String baseUrl;
    private String baseKey;
    private Router router;
    private HashMap<String, ServiceProxy> runningServiceProxyForModule = new HashMap();
    private HashMap<String, HashSet<EtcdNodeInformation>> runningNodesForModule = new HashMap();
    private int waitTimeUntilPollAgain = 1000;
    private SSLParser ssl = null;
    private SSLContext sslCtx = null;
    private AtomicBoolean updateThreadRunning = new AtomicBoolean(false);
    private Thread nodeRefreshThread = new Thread(new Runnable(){

        @Override
        public void run() {
            EtcdBasedConfigurator.this.updateThreadRunning.compareAndSet(false, true);
            while (EtcdBasedConfigurator.this.updateThreadRunning.get()) {
                try {
                    EtcdBasedConfigurator.this.setUpServiceProxies(EtcdBasedConfigurator.this.getConfigFromEtcd());
                    Thread.sleep(EtcdBasedConfigurator.this.waitTimeUntilPollAgain);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!Thread.interrupted()) continue;
                return;
            }
        }
    });

    public int getPort() {
        return this.port;
    }

    @MCAttribute
    public void setPort(int port) {
        this.port = port;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @MCAttribute
    public void setBaseUrl(String baseURL) {
        this.baseUrl = baseURL;
    }

    public String getBaseKey() {
        return this.baseKey;
    }

    @MCAttribute
    public void setBaseKey(String baseKey) {
        this.baseKey = baseKey;
    }

    public boolean isRunning() {
        return false;
    }

    public void start() {
        if (this.router == null) {
            if (this.context == null) {
                throw new IllegalStateException("EtcdBasedConfigurator requires a Router. Option 1 is to call setRouter(). Option 2 is setApplicationContext() and the EBC will try to use the only Router available.");
            }
            this.router = (Router)this.context.getBean(Router.class);
        }
        if (this.ssl != null) {
            this.sslCtx = new StaticSSLContext(this.ssl, this.router.getResolverMap(), this.router.getBaseLocation());
        }
        if (!this.nodeRefreshThread.isAlive()) {
            this.nodeRefreshThread.start();
        }
    }

    private void setUpServiceProxies(ArrayList<EtcdNodeInformation> nodes) throws Exception {
        HashSet<EtcdNodeInformation> newRunningNodes = new HashSet<EtcdNodeInformation>();
        if (nodes.size() > 0) {
            for (EtcdNodeInformation node : nodes) {
                String currentModule = node.getModule();
                if (!this.runningServiceProxyForModule.containsKey(currentModule)) {
                    this.setUpModuleServiceProxy(currentModule + " cluster", this.port, currentModule);
                    this.runningNodesForModule.put(currentModule, new HashSet());
                }
                if (!this.runningNodesForModule.get(currentModule).contains(node)) {
                    this.setUpClusterNode(node);
                }
                newRunningNodes.add(node);
            }
        }
        this.cleanUpNotRunningNodes(newRunningNodes);
    }

    private void setUpClusterNode(EtcdNodeInformation node) {
        log.info("Creating " + node);
        ServiceProxy sp = this.runningServiceProxyForModule.get(node.getModule());
        LoadBalancingInterceptor lbi = (LoadBalancingInterceptor)sp.getInterceptors().get(0);
        lbi.getClusterManager().getClusters().get(0).nodeUp(new Node(node.getTargetHost(), Integer.parseInt(node.getTargetPort())));
        this.runningNodesForModule.get(node.getModule()).add(node);
    }

    private ServiceProxy setUpModuleServiceProxy(String name, int port, String path) {
        log.info("Creating serviceProxy for module: " + path);
        ServiceProxyKey key = new ServiceProxyKey("*", "*", path, port);
        key.setUsePathPattern(true);
        key.setPathRegExp(false);
        ServiceProxy sp = new ServiceProxy(key, null, 0);
        sp.getInterceptors().add(new LoadBalancingInterceptor());
        try {
            sp.init(this.router);
            this.router.add(sp);
            this.runningServiceProxyForModule.put(path, sp);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sp;
    }

    private void cleanUpNotRunningNodes(HashSet<EtcdNodeInformation> newRunningNodes) {
        HashSet currentlyRunningNodes = new HashSet();
        for (String module : this.runningNodesForModule.keySet()) {
            currentlyRunningNodes.addAll(this.runningNodesForModule.get(module));
        }
        for (EtcdNodeInformation node : newRunningNodes) {
            currentlyRunningNodes.remove(node);
        }
        for (EtcdNodeInformation node : currentlyRunningNodes) {
            this.shutdownRunningClusterNode(node);
        }
        HashSet<String> modules = new HashSet<String>();
        for (String module : this.runningNodesForModule.keySet()) {
            modules.add(module);
        }
        for (String module : modules) {
            if (this.runningNodesForModule.get(module).size() != 0) continue;
            this.runningNodesForModule.remove(module);
            this.shutDownRunningModuleServiceProxy(module);
        }
    }

    private void shutDownRunningModuleServiceProxy(String module) {
        log.info("Destroying serviceProxy for module: " + module);
        ServiceProxy sp = this.runningServiceProxyForModule.get(module);
        this.router.getRuleManager().removeRule(sp);
        this.runningServiceProxyForModule.remove(module);
    }

    private void shutdownRunningClusterNode(EtcdNodeInformation node) {
        log.info("Destroying " + node);
        ServiceProxy sp = this.runningServiceProxyForModule.get(node.getModule());
        LoadBalancingInterceptor lbi = (LoadBalancingInterceptor)sp.getInterceptors().get(0);
        lbi.getClusterManager().removeNode("Default", this.baseUrl, this.port);
        this.runningNodesForModule.get(node.getModule()).remove(node);
    }

    private EtcdRequest createRequest(String module) {
        if (this.sslCtx != null) {
            return EtcdRequest.create(this.sslCtx, this.baseUrl, this.baseKey, module);
        }
        return EtcdRequest.create(this.baseUrl, this.baseKey, module);
    }

    private ArrayList<EtcdNodeInformation> getConfigFromEtcd() {
        ArrayList<EtcdNodeInformation> nodes = new ArrayList<EtcdNodeInformation>();
        try {
            EtcdResponse respAvailableModules = this.createRequest("").sendRequest();
            if (!respAvailableModules.is2XX()) {
                return nodes;
            }
            ArrayList<String> availableModules = respAvailableModules.getDirectories();
            for (String module : availableModules) {
                EtcdResponse respAvailableServicesForModule = this.createRequest(module).sendRequest();
                if (!respAvailableServicesForModule.is2XX()) {
                    return nodes;
                }
                ArrayList<String> availableUUIDs = respAvailableServicesForModule.getDirectories();
                for (String uuid : availableUUIDs) {
                    EtcdResponse respName = this.createRequest(module).uuid(uuid).getValue("name").sendRequest();
                    if (!respName.is2XX()) {
                        return nodes;
                    }
                    String targetName = respName.getValue();
                    EtcdResponse respPort = this.createRequest(module).uuid(uuid).getValue("port").sendRequest();
                    if (!respPort.is2XX()) {
                        return nodes;
                    }
                    String targetPort = respPort.getValue();
                    EtcdResponse respHost = this.createRequest(module).uuid(uuid).getValue("host").sendRequest();
                    if (!respHost.is2XX()) {
                        return nodes;
                    }
                    String targetHost = respHost.getValue();
                    EtcdNodeInformation node = new EtcdNodeInformation(module, uuid, targetHost, targetPort, targetName);
                    if (!node.isValid()) continue;
                    nodes.add(node);
                }
            }
        }
        catch (Exception e) {
            log.warn("Error retrieving base info from etcd.");
        }
        return nodes;
    }

    public void stop() {
        this.updateThreadRunning.compareAndSet(true, false);
        this.nodeRefreshThread.interrupt();
        try {
            this.nodeRefreshThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        this.context = arg0;
    }

    public Router getRouter() {
        return this.router;
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    public SSLParser getSsl() {
        return this.ssl;
    }

    @MCChildElement
    public void setSsl(SSLParser ssl) {
        this.ssl = ssl;
    }

    public void destroy() throws Exception {
        log.info("Destroying nodes");
        this.sslCtx = null;
        this.ssl = null;
        this.updateThreadRunning.compareAndSet(true, false);
        this.nodeRefreshThread.interrupt();
        try {
            this.nodeRefreshThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.nodeRefreshThread = null;
    }
}

