/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.cloud.etcd;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.Router;
import com.predic8.membrane.core.cloud.ExponentialBackoff;
import com.predic8.membrane.core.cloud.etcd.EtcdNodeInformation;
import com.predic8.membrane.core.cloud.etcd.EtcdRequest;
import com.predic8.membrane.core.cloud.etcd.EtcdResponse;
import com.predic8.membrane.core.rules.Rule;
import com.predic8.membrane.core.rules.ServiceProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.Lifecycle;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;

@MCElement(name="etcdPublisher")
public class EtcdPublisher
implements ApplicationContextAware,
Lifecycle {
    private static final Logger log = LoggerFactory.getLogger((String)EtcdPublisher.class.getName());
    private ApplicationContext context;
    private HashMap<String, ArrayList<String>> modulesToUUIDs = new HashMap();
    private HashSet<EtcdNodeInformation> nodesFromConfig = new HashSet();
    private int ttl;
    private String baseUrl;
    private String baseKey;
    private Router router;
    private int retryDelayMin = 10000;
    private int retryDelayMax = 600000;
    private double expDelayFactor = 2.0;
    private ExponentialBackoff.Job jobPublishToEtcd = new ExponentialBackoff.Job(){

        @Override
        public boolean run() throws Exception {
            return EtcdPublisher.this.publishToEtcd();
        }
    };
    private Thread ttlRefreshThread = new Thread(new Runnable(){

        @Override
        public void run() {
            try {
                while (true) {
                    boolean connectionLost = false;
                    for (String module : EtcdPublisher.this.modulesToUUIDs.keySet()) {
                        for (String uuid : EtcdPublisher.this.modulesToUUIDs.get(module)) {
                            try {
                                if (EtcdRequest.create(EtcdPublisher.this.baseUrl, EtcdPublisher.this.baseKey, module).uuid(uuid).refreshTTL(EtcdPublisher.this.ttl).sendRequest().is2XX()) continue;
                                log.warn("Could not contact etcd at " + EtcdPublisher.this.baseUrl);
                                connectionLost = true;
                            }
                            catch (Exception e) {
                                connectionLost = true;
                            }
                        }
                    }
                    if (connectionLost) {
                        log.warn("Connection lost to etcd");
                        ExponentialBackoff.retryAfter(EtcdPublisher.this.retryDelayMin, EtcdPublisher.this.retryDelayMax, EtcdPublisher.this.expDelayFactor, "Republish from thread after failed ttl refresh", EtcdPublisher.this.jobPublishToEtcd);
                    }
                    Thread.sleep(Math.max(0, (EtcdPublisher.this.getTtl() - 2) * 1000));
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    });

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @MCAttribute
    public void setBaseUrl(String baseURL) {
        this.baseUrl = baseURL;
    }

    public String getBaseKey() {
        return this.baseKey;
    }

    @MCAttribute
    public void setBaseKey(String baseKey) {
        this.baseKey = baseKey;
    }

    public int getTtl() {
        return this.ttl;
    }

    @MCAttribute
    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public boolean isRunning() {
        return false;
    }

    public void readConfig() {
        this.nodesFromConfig.clear();
        for (Rule rule : this.router.getRuleManager().getRules()) {
            ServiceProxy sp;
            if (!(rule instanceof ServiceProxy) || (sp = (ServiceProxy)rule).getPath() == null) continue;
            this.nodesFromConfig.add(new EtcdNodeInformation(sp.getPath().getValue(), "/" + UUID.randomUUID().toString(), "localhost", Integer.toString(sp.getPort()), sp.getName()));
        }
    }

    public boolean publishToEtcd() {
        try {
            for (EtcdNodeInformation node : this.nodesFromConfig) {
                if (!this.createDirectoryWithTtl(node).is2XX()) {
                    return false;
                }
                if (!this.value(node, "name", node.getName()).is2XX()) {
                    return false;
                }
                if (!this.value(node, "port", node.getTargetPort()).is2XX()) {
                    return false;
                }
                if (!this.value(node, "host", node.getTargetHost()).is2XX()) {
                    return false;
                }
                if (!this.modulesToUUIDs.containsKey(node.getModule())) {
                    this.modulesToUUIDs.put(node.getModule(), new ArrayList());
                }
                this.modulesToUUIDs.get(node.getModule()).add(node.getUuid());
            }
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private EtcdResponse createDirectoryWithTtl(EtcdNodeInformation node) {
        return EtcdRequest.create(this.baseUrl, this.baseKey, node.getModule()).createDir(node.getUuid()).ttl(this.ttl).sendRequest();
    }

    private EtcdResponse value(EtcdNodeInformation node, String name, String value) {
        return EtcdRequest.create(this.baseUrl, this.baseKey, node.getModule()).uuid(node.getUuid()).setValue(name, value).sendRequest();
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void start() {
        if (this.context == null) {
            throw new IllegalStateException("EtcdBasedConfigurator requires a Router. Option 1 is to call setRouter(). Option 2 is setApplicationContext() and the EBC will try to use the only Router available.");
        }
        if (this.router == null) {
            this.router = (Router)this.context.getBean(Router.class);
        }
        this.readConfig();
        try {
            ExponentialBackoff.retryAfter(this.retryDelayMin, this.retryDelayMax, this.expDelayFactor, "Publish to etcd", this.jobPublishToEtcd);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.ttlRefreshThread.isAlive()) {
            this.ttlRefreshThread.start();
        }
    }

    public void stop() {
        this.ttlRefreshThread.interrupt();
        try {
            this.ttlRefreshThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        for (String module : this.modulesToUUIDs.keySet()) {
            for (String uuid : this.modulesToUUIDs.get(module)) {
                EtcdResponse etcdResponse = this.deleteDir(module, uuid);
            }
        }
    }

    private EtcdResponse deleteDir(String module, String uuid) {
        return EtcdRequest.create(this.baseUrl, this.baseKey, module).uuid(uuid).deleteDir().sendRequest();
    }

    public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        this.context = arg0;
    }
}

