/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.config;

import com.predic8.membrane.core.config.XMLElement;
import java.io.StringWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXmlElement
implements XMLElement {
    private static Logger log = LoggerFactory.getLogger((String)AbstractXmlElement.class.getName());

    @Override
    public XMLElement parse(XMLStreamReader token) throws Exception {
        this.move2RootElementIfNeeded(token);
        log.debug("<" + token.getLocalName() + ">");
        this.parseAttributes(token);
        while (token.hasNext()) {
            token.next();
            if (token.isStartElement()) {
                this.parseChildren(token, token.getName().getLocalPart());
                continue;
            }
            if (token.isCharacters()) {
                this.parseCharacters(token);
                continue;
            }
            if (!token.isEndElement()) continue;
            log.debug("</" + token.getLocalName() + ">");
            break;
        }
        this.doAfterParsing();
        return this;
    }

    public void doAfterParsing() throws Exception {
    }

    protected void move2RootElementIfNeeded(XMLStreamReader token) throws XMLStreamException {
        if (token.getEventType() == 7) {
            while (!token.isStartElement()) {
                token.next();
            }
        }
    }

    @Override
    public void write(XMLStreamWriter out) throws XMLStreamException {
    }

    protected void parseAttributes(XMLStreamReader token) throws Exception {
    }

    protected void parseCharacters(XMLStreamReader token) throws XMLStreamException {
    }

    protected void parseChildren(XMLStreamReader token, String child) throws Exception {
        int count = 0;
        while (true) {
            token.next();
            if (token.isEndElement() && child.equals(token.getName().getLocalPart())) {
                if (count == 0) {
                    return;
                }
                --count;
                continue;
            }
            if (!token.isStartElement() || !child.equals(token.getName().getLocalPart())) continue;
            ++count;
        }
    }

    protected String getElementName() {
        return null;
    }

    public String toXml() throws Exception {
        StringWriter sw = new StringWriter();
        XMLStreamWriter w = XMLOutputFactory.newInstance().createXMLStreamWriter(sw);
        w.writeStartDocument();
        this.write(w);
        w.writeEndDocument();
        return sw.toString();
    }

    protected boolean getBoolean(XMLStreamReader token, String attr) {
        return "true".equals(token.getAttributeValue("", attr));
    }

    protected void writeIfNotNull(AbstractXmlElement e, XMLStreamWriter out) throws XMLStreamException {
        if (e != null) {
            e.write(out);
        }
    }
}

