/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.config.security.acme;

import com.predic8.membrane.annot.MCAttribute;
import com.predic8.membrane.annot.MCChildElement;
import com.predic8.membrane.annot.MCElement;
import com.predic8.membrane.core.config.security.acme.AcmeSynchronizedStorage;
import com.predic8.membrane.core.config.security.acme.AcmeValidation;
import com.predic8.membrane.core.transport.http.client.HttpClientConfiguration;
import java.util.Objects;
import org.joda.time.Duration;

@MCElement(name="acme")
public class Acme {
    String directoryUrl;
    boolean termsOfServiceAgreed;
    String contacts;
    HttpClientConfiguration httpClientConfiguration;
    Duration validity;
    AcmeSynchronizedStorage acmeSynchronizedStorage;
    boolean experimental;
    String hosts;
    AcmeValidation validationMethod;
    String renewal = "1/3";
    int retry = 10000;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Acme acme = (Acme)o;
        return this.termsOfServiceAgreed == acme.termsOfServiceAgreed && this.experimental == acme.experimental && Objects.equals(this.directoryUrl, acme.directoryUrl) && Objects.equals(this.contacts, acme.contacts) && Objects.equals(this.httpClientConfiguration, acme.httpClientConfiguration) && Objects.equals(this.validity, acme.validity) && Objects.equals(this.acmeSynchronizedStorage, acme.acmeSynchronizedStorage) && Objects.equals(this.hosts, acme.hosts) && Objects.equals(this.validationMethod, acme.validationMethod) && Objects.equals(this.renewal, acme.renewal);
    }

    public int hashCode() {
        return Objects.hash(this.directoryUrl, this.termsOfServiceAgreed, this.contacts, this.httpClientConfiguration, this.validity, this.acmeSynchronizedStorage, this.experimental, this.hosts, this.validationMethod, this.renewal);
    }

    public String getDirectoryUrl() {
        return this.directoryUrl;
    }

    @MCAttribute
    public void setDirectoryUrl(String directoryUrl) {
        this.directoryUrl = directoryUrl;
    }

    public HttpClientConfiguration getHttpClientConfiguration() {
        return this.httpClientConfiguration;
    }

    @MCChildElement(order=10)
    public void setHttpClientConfiguration(HttpClientConfiguration httpClientConfiguration) {
        this.httpClientConfiguration = httpClientConfiguration;
    }

    public boolean isTermsOfServiceAgreed() {
        return this.termsOfServiceAgreed;
    }

    @MCAttribute
    public void setTermsOfServiceAgreed(boolean termsOfServiceAgreed) {
        this.termsOfServiceAgreed = termsOfServiceAgreed;
    }

    public String getContacts() {
        return this.contacts;
    }

    @MCAttribute
    public void setContacts(String contacts) {
        this.contacts = contacts;
    }

    public String getValidity() {
        return this.validity.toString();
    }

    @MCAttribute
    public void setValidity(String validity) {
        this.validity = validity == null ? null : Duration.parse((String)validity);
    }

    public Duration getValidityDuration() {
        return this.validity;
    }

    public AcmeSynchronizedStorage getAcmeSynchronizedStorage() {
        return this.acmeSynchronizedStorage;
    }

    @MCChildElement
    public void setAcmeSynchronizedStorage(AcmeSynchronizedStorage acmeSynchronizedStorage) {
        this.acmeSynchronizedStorage = acmeSynchronizedStorage;
    }

    public boolean isExperimental() {
        return this.experimental;
    }

    @MCAttribute
    public void setExperimental(boolean experimental) {
        this.experimental = experimental;
    }

    public String getHosts() {
        return this.hosts;
    }

    @MCAttribute
    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public String getRenewal() {
        return this.renewal;
    }

    @MCAttribute
    public void setRenewal(String renewal) {
        this.renewal = renewal;
    }

    public int getRetry() {
        return this.retry;
    }

    @MCAttribute
    public void setRetry(int retry) {
        this.retry = retry;
    }

    public AcmeValidation getValidationMethod() {
        return this.validationMethod;
    }

    @MCChildElement(order=20)
    public void setValidationMethod(AcmeValidation validationMethod) {
        this.validationMethod = validationMethod;
    }
}

